//=======================================
//MZ Window Patch 
//=======================================

/*:ja
 @target MV MZ
 @plugindesc MELOS　EngineをRPGツクールMZでも使用できるパッチファイルです。
 @author 	Tozuka

 @help このプラグインにプラグインコマンドはありません。

Copyright (c) 2023 Utoi Tozuka
Released under the MIT license
https://opensource.org/license/mit-license.php
*/

/*:
 @target MV MZ
 @plugindesc MELOS　Patch file to use MELOS Engine in RPG MAKER MZ
 @author 	Tozuka

 @help No Plugin Commands

Copyright (c) 2023 Utoi Tozuka
Released under the MIT license
https://opensource.org/license/mit-license.php
*/

(()=>{
'use strict';

const params = PluginManager.parameters('melos_mzwindowpatch');
const RPGMAKER = Utils.RPGMAKER_NAME;

if(RPGMAKER === 'MV') return;

//局地的グローバル変数の準備
const scrollable 	= 'Window_Scrollable';
const selectable 	= 'Window_Selectable';
const command 		= 'Window_Command';
const horzCommand 	= 'Window_HorzCommand';
const help 			= 'Window_Help';
const gold 			= 'Window_Gold';
const statusBase 	= 'Window_StatusBase';
const menuCommand 	= 'Window_MenuCommand';
const menuStatus 	= 'Window_MenuStatus';
const menuActor 	= 'Window_MenuActor';
const itemCategory 	= 'Window_ItemCategory';
const itemList 		= 'Window_ItemList';
const skillType 	= 'Window_SkillType';
const skillStatus 	= 'Window_SkillStatus';
const skillList 	= 'Window_SkillList';
const equipStatus 	= 'Window_EquipStatus';
const equipCommand 	= 'Window_EquipCommand';
const equipSlot 	= 'Window_EquipSlot';
const equipItem 	= 'Window_EquipItem';
const status 		= 'Window_Status';
const statusParams 	= 'Window_StatusParams';
const statusEquip 	= 'Window_StatusEquip';
const options 		= 'Window_Options';
const savefileList 	= 'Window_SavefileList';
const shopCommand 	= 'Window_ShopCommand';
const shopBuy 		= 'Window_ShopBuy';
const shopSell 		= 'Window_ShopSell';
const shopNumber 	= 'Window_ShopNumber';
const shopStatus 	= 'Window_ShopStatus';
const nameEdit 		= 'Window_NameEdit';
const nameInput 	= 'Window_NameInput';
//==========================================
const nameBox 		= 'Window_NameBox';
const choiceList 	= 'Window_ChoiceList';
const numberInput 	= 'Window_NumberInput';
const eventItem 	= 'Window_EventItem';

const message 		= 'Window_Message';
//==========================================
const scrollText 	= 'Window_ScrollText';

const mapName 		= 'Window_MapName';
const battleLog 	= 'Window_BattleLog';
const partyCommand 	= 'Window_PartyCommand';
const actorCommand 	= 'Window_ActorCommand';
const battleStatus 	= 'Window_BattleStatus';
const battleActor 	= 'Window_BattleActor';
const battleEnemy 	= 'Window_BattleEnemy';
const battleSkill 	= 'Window_BattleSkill';
const battleItem 	= 'Window_BattleItem';
const titleCommand 	= 'Window_TitleCommand';
const gameEnd 		= 'Window_GameEnd';
const debugRange 	= 'Window_DebugRange';
const debugEdit  	= 'Window_DebugEdit';


//MZではWindow_Baseの初期化時にrectオブジェクトを引数に受け、rectのプロパティで位置を決定している。
//そこで、initialize、およびエラーチェックファンクションを上書きする。

const _Window_Base_prototype_initialize = Window_Base.prototype.initialize;
Window_Base.prototype.initialize = function(rect, y, width, height, windowType) {
	Window.prototype.initialize.call(this);
    this.loadWindowskin();
    rect = this.checkRectObject(rect, y, width, height, windowType);
    this.move(rect.x, rect.y, Graphics.boxWidth, Graphics.boxHeight);
    this.updatePadding();
    this.updateBackOpacity();
    this.updateTone();
    this.createContents();
    this._opening = false;
    this._closing = false;
    this._dimmerSprite = null;
    this.move(rect.x, rect.y, rect.width, rect.height);
    this.contents.fontSize = this.standardFontSize();
};//*

const _Window_Base_prototype_checkRectObject = Window_Base.prototype.checkRectObject;
Window_Base.prototype.checkRectObject = function(rect, y, width, height, windowType) {
    if (typeof rect !== "object" || !("x" in rect)) {
	        // Probably MV plugin is used
	        //throw new Error("Argument must be a Rectangle");
	        let newRect = this.createFlexRectangle(windowType);
	        //console.log(windowType, rect, y, width, height, newRect);
	        if(this.checkNumberArguments(rect))		newRect.x = rect;
	        if(this.checkNumberArguments(y))		newRect.y = y;
	        if(this.checkNumberArguments(width))	newRect.width = width;
	        if(this.checkNumberArguments(height))	newRect.height = height;
	        return newRect;
    }else{
    		//titleCommand, mapName, message and its children, command, selectable, itemList
    		return rect;
    }
};//*

Window_Base.prototype.checkNumberArguments = function(arg){
	return typeof arg === 'number';
};//*

Window_Base.prototype.createFlexRectangle = function(windowType){
	const scene = SceneManager._scene;
	//console.log(scene);
	const sceneName = scene.constructor.name;
	//console.log(`sceneName:${sceneName}`, `windowType:${windowType}`);
	switch(windowType){
		//case scrollable 	:
		//case selectable 	:Sceneからのrect処理が存在しないので、デフォルト処理にまとめる
		case command 		: return new Rectangle(0, 0, this.windowWidth(), this.windowHeight());
		case horzCommand 	: return new Rectangle(0, 0, Graphics.boxWidth, this.windowHeight());
		case help 			: 
				if(sceneName === 'Scene_Status'){
						return scene.profileWindowRect(); //Scene_Status
				}else{
						return scene.helpWindowRect(); //Scene_MenuBase, File, Battle 
				};
		case gold 			: return scene.goldWindowRect(); //Scene_Message, Menu, Shop
		//case statusBase 	: Sceneからのrect処理が存在しないので、デフォルト処理にまとめる
		case menuCommand 	: return scene.commandWindowRect(); //Scene_Menu
		case menuStatus 	: return scene.statusWindowRect(); //Scene_Menu

		case menuActor 		: return scene.actorWindowRect(); //Scene_ItemBase
		case itemCategory 	: return scene.categoryWindowRect(); //Scene_Item, Shop
		case itemList 		: return scene.itemWindowRect(); //Scene_Item

		case skillType 		: return scene.skillTypeWindowRect(); //Scene_Skill
		case skillStatus 	: return scene.statusWindowRect(); //Scene_Skill
		case skillList 		: return scene.itemWindowRect(); //Scene_Skill

		case equipStatus 	: return scene.statusWindowRect(); //Scene_Equip
		case equipCommand 	: return scene.commandWindowRect(); //Scene_Equip
		case equipSlot 		: return scene.slotWindowRect(); //Scene_Equip
		case equipItem 		: return scene.itemWindowRect(); //Scene_Equip

		case status 		: return scene.statusWindowRect(); //Scene_Status
		case statusParams 	: return scene.statusParamsWindowRect(); //Scene_Status
		case statusEquip 	: return scene.statusEquipWindowRect(); //Scene_Status

		case options 		: return scene.optionsWindowRect(); //Scene_Options
		case savefileList 	: return scene.listWindowRect(); //Scene_File

		case shopCommand 	: return scene.commandWindowRect(); //Scene_Shop
		case shopBuy 		: return scene.buyWindowRect(); //Scene_Shop
		case shopSell 		: return scene.sellWindowRect(); //Scene_Shop
		case shopNumber 	: return scene.numberWindowRect(); //Scene_Shop
		case shopStatus 	: return scene.statusWindowRect(); //Scene_Shop

		case nameEdit 		: return scene.editWindowRect(); //Scene_Name
		case nameInput 		: return scene.inputWindowRect(); //Scene_Name
			
		case nameBox 		: return new Rectangle();
		case choiceList 	: return new Rectangle();
		case numberInput 	: return new Rectangle();
		case eventItem 		: return scene.eventItemWindowRect(); //Scene_Message
		case message 		: return scene.messageWindowRect(); //Scene_Message
		case scrollText 	: return scene.scrollTextWindowRect(); //Scene_Message

		case mapName 		: return scene.mapNameWindowRect(); //Scene_Map

		case battleLog 		: return scene.logWindowRect(); //Scene_Battle
		case partyCommand 	: return scene.partyCommandWindowRect(); //Scene_Battle
		case actorCommand 	: return scene.actorCommandWindowRect(); //Scene_Battle
		case battleStatus 	: return scene.statusWindowRect(); //Scene_Battle
		case battleActor 	: return scene.actorWindowRect(); //Scene_Battle
		case battleEnemy 	: return scene.enemyWindowRect(); //Scene_Battle
		case battleSkill 	: return scene.skillWindowRect(); //Scene_Battle
		case battleItem 	: return scene.itemWindowRect(); //Scene_Battle

		case titleCommand 	: return scene.commandWindowRect(); //Scene_Title
		case gameEnd 		: return scene.commandWindowRect(); //Scene_GameEnd
		case debugRange 	: return scene.rangeWindowRect(); //Scene_DebugRange
		case debugEdit 		: return scene.editWindowRect(); //Scene_DebugEdit
		default 			: 
				if(sceneName === 'Scene_Shop'){
						return scene.dummyWindowRect(); //Scene_Shop 
				}else if(sceneName === 'Scene_Debug'){
						return scene.debugHelpWindowRect(); //Scene_Debug
				}else{
						return new Rectangle(0, 0, Graphics.boxWidth, Graphics.boxHeight);	
				};//Window_Base itself or it's children
	}
};//*

/**************************************************************************************/
//====================================================================================//
/**************************************************************************************/
//各イニシャライザーがrect, y, width, heightの引数を参照できるようにオーバーライド。
//ファンクション内のcall処理でも引数追加が必要なため、プラグインの最上段に置かれるべき。

Window_Scrollable.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || scrollable;
    Window_Base.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._scrollX = 0;
    this._scrollY = 0;
    this._scrollBaseX = 0;
    this._scrollBaseY = 0;
    this.clearScrollStatus();
};//*

Window_Selectable.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || selectable;
    Window_Scrollable.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._index = -1;
    this._cursorFixed = false;
    this._cursorAll = false;
    this._helpWindow = null;
    this._handlers = {};
    this._doubleTouch = false;
    this._canRepeat = true;
    this.deactivate();
};

Window_Command.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || command;
    Window_Selectable.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.refresh();
    this.select(0);
    this.activate();
};

Window_HorzCommand.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || horzCommand;
    Window_Command.prototype.initialize.call(this, rect, y, width, height, windowType);
};

Window_Help.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || help;
    Window_Base.prototype.initialize.call(this, rect, y, width, height, windowType);
    if(rect > 0){
    	//from MV plugin , rect is numLines
    	this.height = this.fittingHeight(rect);
    }
    this._text = "";
};

Window_Gold.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || gold;
    Window_Selectable.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.refresh();
};

Window_StatusBase.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || statusBase;
    Window_Selectable.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._additionalSprites = {};
    this.loadFaceImages();
};

Window_MenuCommand.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || menuCommand;
    Window_Command.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.selectLast();
    this._canRepeat = false;
};

Window_MenuStatus.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || menuStatus;
    Window_StatusBase.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._formationMode = false;
    this._pendingIndex = -1;
    this.refresh();
};

Window_MenuActor.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || menuActor;
    Window_MenuStatus.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.hide();
};

Window_ItemCategory.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || itemCategory;
    Window_HorzCommand.prototype.initialize.call(this, rect, y, width, height, windowType);
};

Window_ItemList.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || itemList;
    Window_Selectable.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._category = "none";
    this._data = [];
};

Window_SkillType.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || skillType;
    Window_Command.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._actor = null;
};

Window_SkillStatus.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || skillStatus;
    Window_StatusBase.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._actor = null;
};

Window_SkillList.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || skillList;
    Window_Selectable.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._actor = null;
    this._stypeId = 0;
    this._data = [];
};

Window_EquipStatus.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || equipStatus;
    Window_StatusBase.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._actor = null;
    this._tempActor = null;
    this.refresh();
};

Window_EquipCommand.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || equipCommand;
    Window_HorzCommand.prototype.initialize.call(this, rect, y, width, height, windowType);
};

Window_EquipSlot.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || equipSlot;
    Window_StatusBase.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._actor = null;
    this.refresh();
};

Window_EquipItem.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || equipItem;
    Window_ItemList.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._actor = null;
    this._slotId = 0;
};

Window_Status.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || status;
    Window_StatusBase.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._actor = null;
    this.refresh();
    this.activate();
};

Window_StatusParams.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || statusParams;
    Window_StatusBase.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._actor = null;
};

Window_StatusEquip.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || statusEquip;
    Window_StatusBase.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._actor = null;
};

Window_Options.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || options;
    Window_Command.prototype.initialize.call(this, rect, y, width, height, windowType);
};

Window_SavefileList.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || savefileList;
    Window_Selectable.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.activate();
    this._mode = null;
    this._autosave = false;
};

Window_ShopCommand.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || shopCommand;
	//MVでは引数がwidth単体のため、rectにwidthが入ってくる
    Window_HorzCommand.prototype.initialize.call(this, 0, y, rect, height, windowType);
};

Window_ShopBuy.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || shopBuy;
    Window_Selectable.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._money = 0;
};

Window_ShopSell.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || shopSell;
    Window_ItemList.prototype.initialize.call(this, rect, y, width, height, windowType);
};

Window_ShopNumber.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || shopNumber;
	//MVでは第３引数のwidthがheightになっており、widthは用意されていない
    Window_Selectable.prototype.initialize.call(this, rect, y, width, width, windowType);
    this._item = null;
    this._max = 1;
    this._price = 0;
    this._number = 1;
    this._currencyUnit = TextManager.currencyUnit;
    this.createButtons();
    this.select(0);
    this._canRepeat = false;
};

Window_ShopStatus.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || shopStatus;
    Window_StatusBase.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._item = null;
    this._pageIndex = 0;
    this.refresh();
};

Window_NameEdit.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || nameEdit;
    Window_StatusBase.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._actor = null;
    this._maxLength = 0;
    this._name = "";
    this._index = 0;
    this._defaultName = 0;
    this.deactivate();
};

Window_NameInput.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || nameInput;
    Window_Selectable.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._editWindow = null;
    this._page = 0;
    this._index = 0;
};

Window_NameBox.prototype.initialize = function() {
    Window_Base.prototype.initialize.call(this, new Rectangle());
    this.openness = 0;
    this._name = "";
};

Window_ChoiceList.prototype.initialize = function() {
    Window_Command.prototype.initialize.call(this, new Rectangle());
    this.createCancelButton();
    this.openness = 0;
    this.deactivate();
    this._background = 0;
    this._canRepeat = false;
};

Window_NumberInput.prototype.initialize = function() {
    Window_Selectable.prototype.initialize.call(this, new Rectangle());
    this._number = 0;
    this._maxDigits = 1;
    this.openness = 0;
    this.createButtons();
    this.deactivate();
    this._canRepeat = false;
};

Window_EventItem.prototype.initialize = function(rect) {
    Window_ItemList.prototype.initialize.call(this, rect);
    this.createCancelButton();
    this.openness = 0;
    this.deactivate();
    this.setHandler("ok", this.onOk.bind(this));
    this.setHandler("cancel", this.onCancel.bind(this));
};

Window_Message.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || message;
    Window_Base.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.openness = 0;
    this.initMembers();
};

Window_ScrollText.prototype.initialize = function(rect) {
    Window_Base.prototype.initialize.call(this, new Rectangle());
    this.opacity = 0;
    this.hide();
    this._reservedRect = rect;
    this._text = "";
    this._maxBitmapHeight = 2048;
    this._allTextHeight = 0;
    this._blockHeight = 0;
    this._blockIndex = 0;
    this._scrollY = 0;
};

Window_MapName.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || mapName;
    Window_Base.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.opacity = 0;
    this.contentsOpacity = 0;
    this._showCount = 0;
    this.refresh();
};

Window_BattleLog.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || battleLog;
    Window_Base.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.opacity = 0;
    this._lines = [];
    this._methods = [];
    this._waitCount = 0;
    this._waitMode = "";
    this._baseLineStack = [];
    this._spriteset = null;
    this.refresh();
};

Window_PartyCommand.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || partyCommand;
    Window_Command.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.openness = 0;
    this.deactivate();
};

Window_ActorCommand.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || actorCommand;
    Window_Command.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.openness = 0;
    this.deactivate();
    this._actor = null;
};

Window_BattleStatus.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || battleStatus;
    Window_StatusBase.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.frameVisible = false;
    this.openness = 0;
    this._bitmapsReady = 0;
    this.preparePartyRefresh();
};

Window_BattleActor.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || battleActor;
    Window_BattleStatus.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.openness = 255;
    this.hide();
};

Window_BattleEnemy.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || battleEnemy;
    this._enemies = [];
    Window_Selectable.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.refresh();
    this.hide();
};

Window_BattleSkill.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || battleSkill;
    Window_SkillList.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.hide();
};

Window_BattleItem.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || battleItem;
    Window_ItemList.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.hide();
};

Window_TitleCommand.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || titleCommand;
    Window_Command.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.openness = 0;
    this.selectLast();
};

Window_GameEnd.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || gameEnd;
    Window_Command.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.openness = 0;
    this.open();
};

Window_DebugRange.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || debugRange;
    this._maxSwitches = Math.ceil(($dataSystem.switches.length - 1) / 10);
    this._maxVariables = Math.ceil(($dataSystem.variables.length - 1) / 10);
    Window_Selectable.prototype.initialize.call(this, rect, y, width, height, windowType);
    this.refresh();
    this.setTopRow(Window_DebugRange.lastTopRow);
    this.select(Window_DebugRange.lastIndex);
    this.activate();
};

Window_DebugEdit.prototype.initialize = function(rect, y, width, height, windowType) {
	windowType = windowType || debugEdit;
    Window_Selectable.prototype.initialize.call(this, rect, y, width, height, windowType);
    this._mode = "switch";
    this._topId = 1;
    this.refresh();
};


/**************************************************************************************/
//====================================================================================//
/**************************************************************************************/
//幅、高さに変更があった際、自動的にコンテンツ領域を調整する

Window_Base.prototype.contentsWidth = function() {
    return Math.max(this.innerWidth, this.width - this._padding * 2);
};

Window_Base.prototype.contentsHeight = function() {
    return Math.max(this.innerHeight, this.height - this._padding * 2);
};



/**************************************************************************************/
//====================================================================================//
/**************************************************************************************/
//MZでは削がれたファンクションを復活させる

Window_Base._faceWidth = ImageManager.faceWidth;
Window_Base._faceHeight = ImageManager.faceHeight;

Window_Base.prototype.drawGauge = function(x, y, width, rate, color1, color2) {
    var fillW = Math.floor(width * rate);
    var gaugeY = y + this.lineHeight() - 8;
    this.contents.fillRect(x, gaugeY, width, 6, this.gaugeBackColor());
    this.contents.gradientFillRect(x, gaugeY, fillW, 6, color1, color2);
};

Window_Base.prototype.hpColor = function(actor) {
    if (actor.isDead()) {
        return this.deathColor();
    } else if (actor.isDying()) {
        return this.crisisColor();
    } else {
        return this.normalColor();
    }
};//*

Window_Base.prototype.mpColor = function(actor) {
    return this.normalColor();
};//*

Window_Base.prototype.tpColor = function(actor) {
    return this.normalColor();
};//*

Window_Base.prototype.drawActorFace = function(actor, x, y, width, height) {
    this.drawFace(actor.faceName(), actor.faceIndex(), x, y, width, height);
};//*

Window_Base.prototype.drawActorName = function(actor, x, y, width) {
    width = width || 168;
    this.changeTextColor(this.hpColor(actor));
    this.drawText(actor.name(), x, y, width);
};//*

Window_Base.prototype.drawActorClass = function(actor, x, y, width) {
    width = width || 168;
    this.resetTextColor();
    this.drawText(actor.currentClass().name, x, y, width);
};//*

Window_Base.prototype.drawCurrentAndMax = function(current, max, x, y,
                                                   width, color1, color2) {
    var labelWidth = this.textWidth('HP');
    var valueWidth = this.textWidth('0000');
    var slashWidth = this.textWidth('/');
    var x1 = x + width - valueWidth;
    var x2 = x1 - slashWidth;
    var x3 = x2 - valueWidth;
    if (x3 >= x + labelWidth) {
        this.changeTextColor(color1);
        this.drawText(current, x3, y, valueWidth, 'right');
        this.changeTextColor(color2);
        this.drawText('/', x2, y, slashWidth, 'right');
        this.drawText(max, x1, y, valueWidth, 'right');
    } else {
        this.changeTextColor(color1);
        this.drawText(current, x1, y, valueWidth, 'right');
    }
};//*

Window_Base.prototype.drawActorHp = function(actor, x, y, width) {
    width = width || 186;
    var color1 = this.hpGaugeColor1();
    var color2 = this.hpGaugeColor2();
    this.drawGauge(x, y, width, actor.hpRate(), color1, color2);
    this.changeTextColor(this.systemColor());
    this.drawText(TextManager.hpA, x, y, 44);
    this.drawCurrentAndMax(actor.hp, actor.mhp, x, y, width,
                           this.hpColor(actor), this.normalColor());
};//*

Window_Base.prototype.drawActorMp = function(actor, x, y, width) {
    width = width || 186;
    var color1 = this.mpGaugeColor1();
    var color2 = this.mpGaugeColor2();
    this.drawGauge(x, y, width, actor.mpRate(), color1, color2);
    this.changeTextColor(this.systemColor());
    this.drawText(TextManager.mpA, x, y, 44);
    this.drawCurrentAndMax(actor.mp, actor.mmp, x, y, width,
                           this.mpColor(actor), this.normalColor());
};//*

Window_Base.prototype.drawActorTp = function(actor, x, y, width) {
    width = width || 96;
    var color1 = this.tpGaugeColor1();
    var color2 = this.tpGaugeColor2();
    this.drawGauge(x, y, width, actor.tpRate(), color1, color2);
    this.changeTextColor(this.systemColor());
    this.drawText(TextManager.tpA, x, y, 44);
    this.changeTextColor(this.tpColor(actor));
    this.drawText(actor.tp, x + width - 64, y, 64, 'right');
};//*

Window_Base.prototype.standardFontSize = function(){
	return $gameSystem.mainFontSize();
};//*

Window_Base.prototype.standardPadding = function(){
	return 18;
};//*

Window_Base.prototype.textPadding = function(){
	return this.itemPadding();
};//*

Window_Base.prototype.textColor = function(n) {
    return ColoManager.textColor(n);
};//*

Window_Base.prototype.normalColor = function() {
    return ColorManager.normalColor();
};//*

Window_Base.prototype.systemColor = function() {
    return ColorManager.systemColor();
};//*

Window_Base.prototype.crisisColor = function() {
    return ColorManager.crisisColor();
};//*

Window_Base.prototype.deathColor = function() {
    return ColorManager.deathColor();
};//*

Window_Base.prototype.gaugeBackColor = function() {
    return ColorManager.gaugeBackColor();
};//*

Window_Base.prototype.hpGaugeColor1 = function() {
    return ColorManager.hpGaugeColor1();
};//*

Window_Base.prototype.hpGaugeColor2 = function() {
    return ColorManager.hpGaugeColor2();
};//*

Window_Base.prototype.mpGaugeColor1 = function() {
    return ColorManager.mpGaugeColor1();
};//*

Window_Base.prototype.mpGaugeColor2 = function() {
    return ColorManager.mpGaugeColor2();
};//*

Window_Base.prototype.mpCostColor = function() {
    return ColorManager.mpCostColor();
};//*

Window_Base.prototype.powerUpColor = function() {
    return ColorManager.powerUpColor();
};//*

Window_Base.prototype.powerDownColor = function() {
    return ColorManager.powerDownColor();
};//*

Window_Base.prototype.tpGaugeColor1 = function() {
    return ColorManager.tpGaugeColor1();
};//*

Window_Base.prototype.tpGaugeColor2 = function() {
    return ColorManager.tpGaugeColor2();
};//*

Window_Base.prototype.tpCostColor = function() {
    return ColorManager.tpCostColor();
};//*

Window_Base.prototype.pendingColor = function() {
    return ColorManager.pendingColor();
};//*

Window_Base.prototype.paramchangeTextColor = function(change) {
    if (change > 0) {
        return this.powerUpColor();
    } else if (change < 0) {
        return this.powerDownColor();
    } else {
        return this.normalColor();
    }
};

Window_Base.prototype.reserveFaceImages = function() {
	/*
    $gameParty.members().forEach(function(actor) {
        ImageManager.reserveFace(actor.faceName());
    }, this);
	*/
};//*

Window_Selectable.prototype.resetScroll = function() {
    this.setTopRow(0);
};

Window_Selectable.prototype.spacing = function() {
    return 12;
};

Window_Selectable.prototype.itemRectForText = function(index) {
    return this.itemRectWithPadding(index);
};

Window_Selectable.prototype.isCursorVisible = function() {
    var row = this.row();
    return row >= this.topRow() && row <= this.bottomRow();
};

Window_Selectable.prototype.bottomRow = function() {
    return Math.max(0, this.topRow() + this.maxPageRows() - 1);
};

Window_Command.prototype.windowWidth = function() {
    return 240;
};

Window_Command.prototype.windowHeight = function() {
    return this.fittingHeight(this.numVisibleRows());
};

Window_Command.prototype.numVisibleRows = function() {
	if(!this._list){
		//added for MZ
		this.clearCommandList();
		this.makeCommandList();
	}
    return Math.ceil(this.maxItems() / this.maxCols());
};

Window_HorzCommand.prototype.numVisibleRows = function() {
    return 1;
};


Window_EquipStatus.prototype.drawRightArrow = function(x, y) {
    this.changeTextColor(this.systemColor());
    this.drawText('\u2192', x, y, 32, 'center');
};

Window_EquipSlot.prototype.slotName = function(index) {
	const actor = this._actor;
    return Window_StatusBase.prototype.actorSlotName.call(this, actor, index);
};//*




Window_Status.prototype.drawHorzLine = function(y) {
    var lineY = y + this.lineHeight() / 2 - 1;
    this.contents.paintOpacity = 48;
    this.contents.fillRect(0, lineY, this.contentsWidth(), 2, this.lineColor());
    this.contents.paintOpacity = 255;
};

Window_Status.prototype.lineColor = function() {
    return this.normalColor();
};


Window_ShopNumber.prototype.updateButtonsVisiblity = function() {
   /*
    if (TouchInput.date > Input.date) {
        this.showButtons();
    } else {
        this.hideButtons();
    }
    */
};

Window_ShopNumber.prototype.windowWidth = function() {
    return 456;
};

Window_ShopNumber.prototype.itemY = function() {
    return this.itemNameY();
};

Window_ShopNumber.prototype.priceY = function() {
    return this.totalPriceY();
};


Window_NumberInput.prototype.updateButtonsVisiblity = function() {
	/*
    if (TouchInput.date > Input.date) {
        this.showButtons();
    } else {
        this.hideButtons();
    }
    */
};

//terminate
})();