//====================================//
//MELOS Engine
//====================================//

/*:ja
@target MV MZ
@plugindesc 【β4.3.1】移動機能の強化・アクション仕様の実装・システムパラメーターの細かな調整が可能なミドルエンジンです。
@author	戸塚　雨樋
*
@help
*****************【コマンド・タグ　早見表】*****************************************************	
【エスケープコード】
\rb[text\ruby\lines] : ルビ振り
\F 	:メッセージ速度Up
\S 	:メッセージ速度Down
\D 	:メッセージ速度　超Down
\E 	:メッセージ色　強調
\W 	:メッセージ色　警告
\R 	:メッセージ色　リセット

詳しくはオンラインマニュアルをご覧ください。
https://melos-engine.kikai-kobo.com

***************＜特記事項＞*****************************************************

	--------------------------------------------------------------------------
*！！バフ補正の計算式について
	加算方式：デフォルト仕様で、強化・弱体した回数だけバフ補正値を"1"に加算・減算します。
	　　　　（例：補正値=0.25の時、１回強化で1.25倍、２回強化で1.5倍）
	累乗方式：先にバフ補正値＋"1"を行い、その値を強化・弱体回数だけ乗算します。
	　　　　（例：補正値=0.25の時、１回強化で1.25倍、２回強化で1.5625倍）
	--------------------------------------------------------------------------
*！！パラメーターIDについて
	0:最大HP　1:最大MP
	2:攻撃力　3:防御力　4:魔法力　5:魔法防御　6:敏捷性　7:運
	10~19:ユーザー定義（プラグインパラメーターから設定できます）
	--------------------------------------------------------------------------
*！！特徴の計算タイプについて
	・百分率：特徴の値を％表示に変換します。
	　　　　　計算の実行をOffにしている場合、このタイプで計算されます。

	・耐性　：特徴の値の、"1"からの差分を％で表示します。
	　　　　　表示値の大きさと実際の耐性が比例し、防御力がわかりやすくなります。

	・倍率　：特徴の値をそのまま表示します。
	　　　　　狙われ率・防御効果率・回復効果率・薬の知識
	　　　　　TPチャージ率・経験獲得率　に適用されます。
	--------------------------------------------------------------------------
*！！特徴パラメーターIDについて
	１：IDの割り振りは、大まかに次のようになっています。
		-1 	：使用停止
		0~9 	：追加能力
		10~19 	：特殊能力（下１桁を参照）
		101~199 	：属性有効度（下２桁を参照）
		201~1200 	：ステート有効度（-200されたIDで参照）
	
	２：追加能力と特殊能力のIDは、以下のようになっています。
	   ＜追加能力＞　　　＜特殊能力＞
	0　　命中率			狙われ率
	1　　回避率			防御効果率
	2　　会心率			回復効果率
	3　　会心回避率		薬の知識
	4　　魔法回避率		MP消費率
	5　　魔法反撃率		TPチャージ率
	6　　反撃率			物理ダメージ率
	7　　HP再生率		魔法ダメージ率
	8　　MP再生率		床ダメージ率
	9　　TP再生率		経験獲得率
	--------------------------------------------------------------------------

Copyright (c) 2024 Utoi Tozuka
Released under the MIT license
https://opensource.org/license/mit-license.php
//end
***********************************************************************************

@param 	consoler
@type 		boolean
@text 		出力調査
@desc 		On（true）の時、F8のデバッグモードでライブラリの結果を確認することができます。
@default 	false

@param inter
@text 	-------------------------

@param 	ConfigExtend
@type		select
@text		C o n f i g
@desc		コンフィグの拡張機能を設定します。データ間で共有できる情報についても設定します。
@default	名前横の階層ボタンで展開・収納
@option	名前横の階層ボタンで展開・収納
@value		名前横の階層ボタンで展開・収納

	@param configTitleWindow
	@parent 	ConfigExtend
	@type 		struct<ConfigTitleWindow>
	@text 		∟タイトルウィンドウ改造
	@desc 		タイトルウィンドウに関する設定を行います。

			@param 	inter_configTitleWindow
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param configSaveLoad
	@parent 	ConfigExtend
	@type 		struct<ConfigSaveLoad>
	@text 		∟セーブ・ロード強化
	@desc 		セーブやロードに関する機能を設定します。

			@param 	inter_configSaveLoad
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param configGeneralCommands
	@parent 	ConfigExtend
	@type 		struct<ConfigGeneralCommands>
	@text 		∟汎用オプション設定
	@desc 		オートダッシュ・コマンド記憶の項目の表示に関する設定です。

			@param 	inter_configGeneralCommands
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param eventSkip
	@parent 	ConfigExtend
	@type 		struct<EventSkip>
	@text 		∟イベントスキップ
	@desc 		イベントスキップに関する設定です。

			@param 	inter_eventSkip
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param initializedSwitches
	@parent 	ConfigExtend
	@type 		switch[]
	@text 		∟初期設定スイッチ
	@desc 		ゲーム開始時からOnにするスイッチを設定します。

			@param 	inter_initializedSwitches
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param initializedVariables
	@parent 	ConfigExtend
	@type 		struct<InitializedVariables>[]
	@text 		∟初期設定変数
	@desc 		ゲーム開始時に任意の変数に代入する初期値を設定します。

			@param 	inter_initializedVariables
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	configDifficulty
	@parent 	ConfigExtend
	@type 		struct<ConfigDifficulty>
	@text 		∟難易度設定
	@desc 		難易度の導入や詳細項目に関する設定です。
	
		@param 	difLevel
		@parent 	configDifficulty
		@type 		struct<DifLevel>
		@text 		∟∟段階方式の詳細設定
		@desc 		段階方式を導入時に反映される諸設定です。

		@param 	difStepless
		@parent 	configDifficulty
		@type 		struct<DifStepless>
		@text 		∟∟無段階方式の詳細設定
		@desc 		無段階方式を導入時に反映される諸設定です。

			@param 	inter_difficulty
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	
	@param 	configAudio
	@parent 	ConfigExtend
	@type 		struct<ConfigAudio>
	@text 		∟音量コンフィグの設定
	@desc 		コンフィグ画面での音量調節に関する設定です。

			@param 	inter_configAudio
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------
	
	@param 	configMessageSpeed
	@parent 	ConfigExtend
	@type 		struct<ConfigMessageSpeed>
	@text 		∟メッセージ速度設定
	@desc 		メッセージ速度のオプション導入に関する設定です。

		@param 	attentionColor
		@parent 	configMessageSpeed
		@type 		struct<AttentionColor>
		@text 		∟∟汎用文字色設定
		@desc 		強調色や危険色といった、よく使う文字色に関する設定です。
	

			@param 	inter_configMessage
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	commonSwitches
	@parent 	ConfigExtend
	@type 		string[]
	@text 		∟共有スイッチ
	@desc 		データ間で共有できるスイッチを設定します。On、Offはプラグインコマンドで行います。

			@param 	inter_commonSwitch
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	trophy
	@parent 	ConfigExtend
	@type 		struct<Trophy>[]
	@text 		∟トロフィー設定
	@desc 		実績やトロフィーの内容・条件を設定します。

		@param 	trophyConfig
		@parent 	trophy
		@type 		struct<TrophyConfig>
		@text 		∟∟共通設定
		@desc 		トロフィーの共通設定を行います。

		@param 	trophyGenre
		@parent 	trophy
		@type 		string[]
		@text 		∟∟トロフィー分類
		@desc 		トロフィーに付与する分類の名前を設定します。

		@param 	inter_trophy
		@parent 	ConfigExtend
		@type 		select
		@text 		.
		@default	---------------------------
		@option	---------------------------
		@value		---------------------------


	@param keyPad
	@parent ConfigExtend
	@type 	struct<KeyPad>
	@text 	∟キー・ボタン名
	@desc 	ゲームパッドのボタンやキーボードのキーの名前を設定します。

@param inter
@text 	-------------------------

@param moving
@type		select
@text		M o v e m e n t
@desc		移動速度や歩行中のHP減少・休憩などを設定します。
@default	名前横の階層ボタンで展開・収納
@option	名前横の階層ボタンで展開・収納
@value		名前横の階層ボタンで展開・収納

	@param 	fieldBasic
	@parent 	moving
	@type 		struct<FieldBasic>
	@text 		∟プレイヤー操作感
	@desc 		プレイヤーの操作に関する諸設定を行います。

			@param 	inter_field
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value	---------------------------

	@param 	vehicleValid
	@parent 	moving
	@type 	boolean
	@text 	∟乗り物拡張
	@desc 	On（true）の時、以下の乗り物拡張設定を有効にします。
	@default 	false

			@param 	vehicleList
			@parent 	vehicleValid
			@type 		struct<VehicleList>[]
			@text 		∟∟乗り物設定
			@desc 		追加の乗り物を設定します。

			@param 	inter_vehicles
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	staminaMode
	@parent 	moving
	@type 		boolean
	@text 		∟疲労システムの可否
	@desc 		On（true）にすると、移動に伴うスタミナ消費や移動速度の変化が実装できます。
	@default 	false
	
		@param 	staminaStatus
		@parent 	staminaMode
		@type 		select
		@text 		∟∟スタミナとして扱うステータス
		@desc 		HP MP TP スタミナ無し から選んで下さい。
		@default 	mp
		
			@option 	HP
			@value 	hp
			@option 	MP
			@value 	mp
			@option 	TP
			@value 	tp
			@option 	スタミナ無し
			@value 	none
		
		@param 	hpSpeedType
		@parent 	staminaMode
		@type 		select
		@text 		∟∟移動速度に係るゲージ残量の影響
		@desc 		・rate（割合）：最大値と現在値の比・fixed（固定）：現在実数値・limited（封印）：影響なし
		@default 	fixed

			@option  	rate（割合）
			@value  	rate

			@option  	fixed（固定）
			@value  	fixed

			@option 	limited（封印）
			@value 	limited
		
		
		@param 	heavyStatus
		@parent 	staminaMode
		@type 		struct<HeavyStatus>
		@text 		∟∟重量ステータス
		@desc 		重量にまつわる能力設定を行います。
		
		@param 	itemWeight
		@parent 	staminaMode
		@type 		boolean
		@text 		∟∟アイテム重量設定
		@desc 		On（true）にすると、メモ欄タグでアイテムに重量を設定できます。
		@default 	true
		
			@param 	inter_stamina
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------
	
	@param 	dayNightConcept
	@parent 	moving
	@type 		boolean
	@text 		∟昼夜の概念を導入
	@desc 		Onにすると、時間経過で昼夜が変わります。
	@default 	false
	
		@param 	daySecond
		@parent 	dayNightConcept
		@type 		struct<DaySecond>
		@text		∟∟色調と日照時間
		@desc 		昼を表現するための画面色調と日照時間を設定します。
		
		
		@param 	twilightSecond
		@parent 	dayNightConcept
		@type 		struct<DaySecond>
		@text		∟∟色調と夕暮れ時間
		@desc 		夕暮れを表現するための画面色調と時間を指定します。
		
		
		@param 	nightSecond
		@parent 	dayNightConcept
		@type 		struct<DaySecond>
		@text		∟∟色調と夜間時間
		@desc 		夜を表現するための画面色調と時間を指定します。
		
			@param 	inter_seconds
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	multiParty
	@parent 	moving
	@type 		struct<MultiParty>
	@text 		∟複数パーティ
	@desc 		複数のパーティ生成に関する設定です。

			@param 	initialMembers
			@parent 	multiParty
			@type 		struct<initialMembers>[]
			@text		∟∟複数パーティの初期設定
			@desc 		複数パーティ有効時の、各パーティの初期設定を行います。

			@param 	inter_party
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	timer
	@parent 	moving
	@type 		struct<Timer>
	@text 		∟タイマー拡張
	@desc 		タイマーのレイアウトに関する設定です。

			@param 	inter_timer
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	searchHelp
	@parent 	moving
	@type 		struct<SearchHelp>
	@text 		∟サーチ機能
	@desc 		特定のオブジェクトに近づくと表示されるフキダシアイコンの設定です。
	
			@param 	inter_searchHelp
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	doorCommand
	@parent 	moving
	@type 		struct<DoorCommand>
	@text 		∟ドアの挙動
	@desc 		プラグインコマンドdoorのweightに関する挙動設定です。

			@param 	inter_door
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	regionWall
	@parent 	moving
	@type 		number[]
	@text 		∟壁判定リージョン
	@desc 		自動ジャンプ実行時、壁として判定するリージョンIDのリストを設定します。
	@decimals 	0
	@default 	["0"]
	@max 		255

			@param 	fallingSwitch
			@parent 	regionWall
			@type 		switch
			@text 		∟∟落下死スイッチ
			@desc 		自動ジャンプで落下死した際、Onにするスイッチを設定します。
			@default 	0

			@param 	resistFallingAcceleration
			@parent 	regionWall
			@type 		number
			@text 		∟∟落下の空気抵抗
			@desc 		自動ジャンプで落下速度にかかる抵抗を設定します。小さいほど早く加速します。
			@default 	15
			@decimals	0
			@min 		1
			@max 		99999999

			@param 	inter_regionWall
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------


	@param 	encount
	@parent 	moving
	@type 		struct<Encount>
	@text 		∟エンカウント設定
	@desc 		エンカウント周りの仕様を設定します。

			@param 	inter_encount
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	fastTravel
	@parent 	moving
	@type 		struct<FastTravel>
	@text 		∟転送ライブラリ
	@desc 		ファストトラベルに関する設定です。

			@param 	inter_fasttravel
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	guide
	@parent 	moving
	@type 		struct<Guide>
	@text 		∟ガイド設定
	@desc 		ゲーム進行を導くガイドの設定です。

		@param 	guideConfig
		@parent 	guide
		@type 		struct<GuideConfig>
		@text 		∟∟ポップアップ設定
		@desc 		ガイドのポップアップ設定を行います。

		@param 	guideHUD
		@parent 	guide
		@type 		struct<GuideHUD>
		@text 		∟∟ガイドHUD設定
		@desc 		ガイドのHUD表示設定を行います。

		@param 	mainGuide
		@parent 	guide
		@type 		struct<GuideItems>[]
		@text 		∟∟メインガイド設定
		@desc 		ゲームのメインクエストを設定します。
	
		@param 	subGuide
		@parent 	guide
		@type 		struct<GuideItems>[]
		@text 		∟∟サブガイド設定
		@desc 		ゲームのサブクエストを設定します。

		@param 	mobGuide
		@parent 	guide
		@type 		struct<GuideItems>[]
		@text 		∟∟モブガイド設定
		@desc 		ゲームのモブ討伐クエストを設定します。

			@param 	inter_guide
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	jukebox
	@parent 	moving
	@type 		struct<Jukebox>
	@text 		∟ジュークボックス
	@desc 		戦闘BGMとマップBGMを鑑賞するサウンドテストモードの設定です。

	@param 	battleBgms
	@parent 	moving
	@type 		struct<BattleBgms>[]
	@text 		∟戦闘BGMライブラリ
	@desc 		条件によって変わる戦闘BGMの設定です。

	@param 	mapBgms
	@parent 	moving
	@type 		struct<MapBgms>[]
	@text 		∟マップBGMライブラリ
	@desc 		条件によって変わるマップBGMの設定です。

			@param 	mapBgmsCondition
			@parent 	mapBgms
			@type 		variable
			@text 		∟∟マップBGM変数
			@desc 		マップBGMの切り替えに使用する変数の設定です。0の時はライブラリ設定が無効になります。
			@default 	0

	@param 	mapSes
	@parent 	moving
	@type 		struct<MapSes>[]
	@text 		∟マップSEライブラリ
	@desc 		条件によって変わるマップSEの設定です。

			@param 	mapSesCondition
			@parent 	mapSes
			@type 		variable
			@text 		∟∟マップSE変数
			@desc 		マップSEの切り替えに使用する変数の設定です。0の時はライブラリ設定が無効になります。
			@default 	0

	@param 	mapMes
	@parent 	moving
	@type 		struct<MapMes>[]
	@text 		∟マップMEライブラリ
	@desc 		条件によって変わるマップMEの設定です。

			@param 	mapMesCondition
			@parent 	mapMes
			@type 		variable
			@text 		∟∟マップME変数
			@desc 		マップMEの切り替えに使用する変数の設定です。0の時はライブラリ設定が無効になります。
			@default 	0

	@param 	mapBgss
	@parent 	moving
	@type 		struct<MapBgss>[]
	@text 		∟マップBGSライブラリ
	@desc 		条件によって変わるマップBGSの設定です。

			@param 	mapBgssCondition
			@parent 	mapBgss
			@type 		variable
			@text 		∟∟マップBGS変数
			@desc 		マップBGSの切り替えに使用する変数の設定です。0の時はライブラリ設定が無効になります。
			@default 	0


@param inter
@text 	-------------------------

@param  action
@type		select
@text		A c t i o n
@desc		アクションゲーム用のコマンド内容を設定します。
@default	名前横の階層ボタンで展開・収納
@option	名前横の階層ボタンで展開・収納
@value		名前横の階層ボタンで展開・収納

	@param 	actionValid
	@parent 	action
	@type 		boolean
	@text 		∟有効化
	@desc 		On（true）にすると、下の設定を適用できます。
	@default 	false

				@param 	inter_actionValid
				@parent 	action
				@type 		select
				@text 		.
				@default	---------------------------
				@option	---------------------------
				@value		---------------------------

	@param 	alternateMenuKey
	@parent 	action
	@type 		boolean
	@text 		∟メニューキー切替
	@desc 		On（true）の時、escape/cancelキーではなくalt/optionキーでメニューが開きます。
	@default 	false

	@param 	restrictAction
	@parent 	action
	@type 		boolean
	@text 		∟アクション制限ステート
	@desc 		On（true）の時、行動不能のステートが付与されている間は移動やイベント起動などの操作を受け付けなくなります。
	@default 	true

	@param 	levelupDisplay
	@parent 	action
	@type 		boolean
	@text 		∟レベルアップ表示
	@desc 		Off（false）の時、レベルアップの表示がなくなります。スキルの習得は無条件に表示されます。
	@default 	false

	@param 	actionVisibleValid
	@parent 	action
	@type 		boolean
	@text 		∟ 判定の可視化
	@desc 		On（true）の時、攻撃判定の可視化を有効にします。
	@default 	false

	@param 	actionVisible
	@parent 	action
	@type 		text
	@text 		∟判定の色
	@desc 		可視化される攻撃判定の色を設定します。デフォルトはredで赤色です。
	@default 	red

	@param 	frameRate
	@parent 	action
	@type 		number
	@text 		∟フレームレート
	@desc 		アニメーションで１フレーム毎に必要な実フレームを設定します。初期値は4で、15fpsです。
	@decimals 	0
	@max 		4
	@min 		1
	@default 	4

	@param 	fixDirection
	@parent 	action
	@type 		select
	@text 		∟向き固定タイプ
	@desc 		プレイヤーの向きの固定設定を行います。シューティングの様に一方向で固定したい場合に設定して下さい。
	@default 	noFix

			@option デフォルト（固定なし）
			@value noFix
			
			@option 横スク型（右向き固定）
			@value scrollH

			@option 縦スク型（上向き固定）
			@value scrollV
			
			@option ロックオン型（条件付き固定）
			@value lockon

	@param 	doubleInterbal
	@parent 	action
	@type 		number
	@text 		∟連打猶予フレーム
	@desc 		二連押しと判定される猶予フレームを設定します。単押しの判定にも使うので注意して下さい。
	@default 	3
	@min 		1
	@decimals 	0

	@param 	chargeParam
	@parent 	action
	@type 		number
	@text 		∟溜め短縮能力
	@desc 		長押しアクションの判定時間を短縮する能力を設定します。2~7以外は拡張能力を未設定の場合、設定値を基本短縮フレームとします。
	@default 	0
	@max 		19
	@decimals 	0

				@param 	inter_actionBase
				@parent 	action
				@type 		select
				@text 		.
				@default	---------------------------
				@option	---------------------------
				@value		---------------------------

	@param 	hitStop
	@parent 	action
	@type 		struct<HitStop>
	@text 		∟ヒットストップ
	@desc 		アクションのヒットストップを設定します。

				@param 	inter_hitStop
				@parent 	action
				@type 		select
				@text 		.
				@default	---------------------------
				@option	---------------------------
				@value		---------------------------

	@param 	invincible
	@parent 	action
	@type 		struct<Invincible>
	@text 		∟被ダメージ判定
	@desc 		無敵判定やノックバックなどに関する諸設定をします。

				@param 	inter_invincible
				@parent 	action
				@type 		select
				@text 		.
				@default	---------------------------
				@option	---------------------------
				@value		---------------------------

	@param 	enemyActionHUD
	@parent 	action
	@type 		struct<EnemyActionHUD>
	@text 		∟敵HUDの設定
	@desc 		敵のHUDに関する設定を行います。「ボス」はメモ欄に<boss>を持つイベントを指します。

				@param 	inter_enemyHUD
				@parent 	action
				@type 		select
				@text 		.
				@default	---------------------------
				@option	---------------------------
				@value		---------------------------

	@param 	commands
	@parent 	action
	@type 		struct<Commands>[]
	@text 		∟コマンド設定
	@desc 		各キーに対応したアクションの実行内容を設定します。



@param inter
@text 	-------------------------

@param 	HUDcustom
@type		select
@text		H U D
@desc		プレイヤーのHUD設定を行います。
@default	名前横の階層ボタンで展開・収納
@option	名前横の階層ボタンで展開・収納
@value		名前横の階層ボタンで展開・収納

	@param 	HUDValid
	@parent 	HUDcustom
	@type 		select
	@text 		∟HUDの有効化
	@desc 		HUD、所持金HUDの実装可否を設定します
	@default 	none
		@option 実装しない	
		@value 	none
		@option 実装（コンフィグ非表示）
		@value 	onlySystem
		@option 実装（コンフィグ表示）
		@value 	introduce

	@param 	windowHUD
	@parent 	HUDcustom
	@type 		struct<WindowHUD>
	@text 		∟HUDの基本設定
	@desc 		HP、MP、TPをマップ上に表示するHUD設定です。

	@param 	goldHUD
	@parent 	HUDcustom
	@type 		struct<GoldHUD>
	@text 		∟所持金HUD
	@desc 		所持金HUDの表示に関する設定です。

	@param 	equipHUD
	@parent 	HUDcustom
	@type 		struct<EquipHUD>
	@text 		∟装備HUD
	@desc 		装備HUDやアイテムHUDの表示に関する設定です。

@param inter
@text 	-------------------------

@param 	windowCustom
@type		select
@text		W i n d o w
@desc		メッセージやメニューUIなどを設定します。
@default	名前横の階層ボタンで展開・収納
@option	名前横の階層ボタンで展開・収納
@value		名前横の階層ボタンで展開・収納

	@param 	windowBaseSet
	@parent 	windowCustom
	@type 		struct<WindowBaseSet>
	@text 		∟ウィンドウの基本設定
	@desc 		プラグインの統括管理や全体的な基本設定を行います。

	@param 	message
	@parent 	windowCustom
	@type 		struct<Message>
	@text 		∟セリフのウィンドウ設定
	@desc 		文章表示におけるメッセージのウィンドウに関する設定です。

			@param 	inter_windowBase
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	mapName
	@parent 	windowCustom
	@type 		struct<MapName>
	@text 		∟マップ名設定
	@desc 		マップ名表示に関する設定です。

			@param 	inter_mapName
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	debugCustom
	@parent 	windowCustom
	@type 		boolean
	@text 		∟デバッグ強化
	@desc 		On（true）の時、デバッグウィンドウでアイテムデバッグが利用できるようになります。
	@default 	true

			@param 	inter_debug
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	fravor
	@parent 	windowCustom
	@type 		struct<Fravor>
	@text 		∟フレーバーウィンドウ
	@desc 		世界観を掘り下げるフレーバーテキストウィンドウに関する設定です。

			@param 	inter_fravor
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	itemCategory
	@parent 	windowCustom
	@type 		struct<ItemCategory>
	@text 		∟カテゴリーメニュー設定
	@desc 		アイテムメニューのカテゴリー機能に関する設定です。

			@param 	inter_category
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	sortWindow
	@parent 	windowCustom
	@type 		struct<SortWindow>
	@text 		∟ソート機能搭載
	@desc 		アイテムを並び替えるソートウィンドウに関する設定です。

			@param 	inter_sortWindow
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	chest
	@parent 	windowCustom
	@type 		struct<Chest>
	@text 		∟倉庫システム
	@desc 		アイテムや通過を預ける倉庫機能に関する設定です。

			@param 	inter_chest
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	
	@param 	statusWindow
	@parent 	windowCustom
	@type 		struct<StatusWindow>
	@text 		∟ステータスウィンドウのカスタマイズ
	@desc 		ステータスウィンドウのレイアウトに関する設定です。「能力補正の基本設定」の有効化が必要です。
	
	@param 	traitCalc
	@parent 	windowCustom
	@type 		struct<TraitCalc>
	@text 		∟特徴表示の計算タイプ
	@desc 		特徴の表示に１手間加えるかどうかの設定です。「能力補正の基本設定」の有効化が必要です。
	
	@param 	traitsWindow
	@parent 	windowCustom
	@type 		struct<TraitsWindow>
	@text 		∟特徴ウィンドウの追加
	@desc 		ステータスウィンドウに追加可能な特徴欄に関する設定です。「能力補正の基本設定」の有効化が必要です。

	@param 	equipWindow
	@parent 	windowCustom
	@type  	struct<EquipWindow>
	@text 		∟装備画面のカスタマイズ
	@desc 		装備画面の表示項目に関する設定です。「能力補正の基本設定」の有効化が必要です。

			@param 	inter_statusWindow
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	stepPriceShop
	@parent 	windowCustom
	@type 		struct<StepPriceShop>
	@text 		∟段階売価ショップ
	@desc 		段階的に値段が上がっていくショップUIに関する設定です。

			@param 	inter_stepShop
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	shopMaterial
	@parent 	windowCustom
	@type 		boolean
	@text 		∟ショップ素材要求
	@desc 		On（true）の時、素材要求のメモタグが有効になります。
	@default 	true

		@param 	shopMemberOnlyCanEquip
		@parent 	shopMaterial
		@type 		boolean
		@text 		∟∟装備者のみ表示
		@desc 		On（true）の時、ショップのステータス画面で装備可能のアクターのみを表示します。
		@default 	true

		@param 	shopStatusCustom
		@parent 	shopMaterial
		@type 		boolean
		@text 		∟∟装備ステータス改変
		@desc 		On（true）の時、ショップのステータス画面でキャラクター・変動値の表示方法を変更します。
		@default 	true

		@param 	statusIcons
		@parent 	shopMaterial
		@type 		number[]
		@text 		∟∟基本能力のアイコン
		@desc 		最大HP〜運、防御軽減率と魔法軽減率を表すアイコンを設定します。0に設定すると非表示になります。
		@default 	["32","33","34","35","36","37","38","39","132","133","0","0","0","0","0","0","0","0","0","0"]
		@decimals 	0

		@param 	shopStatusTexts
		@parent 	shopMaterial
		@type 		struct<ShopStatusTexts>
		@text 		∟∟ショップ能力画面テキスト
		@desc 		ショップのステータス画面で表示するテキスト群を設定します。

			@param 	inter_shop
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------


	@param 	bookExtend
	@parent 	windowCustom
	@type 		struct<BookExtend>
	@text 		∟図鑑強化
	@desc 		公式プラグインのアイテム・エネミー図鑑を強化する設定です。

		@param 	enemyBookExtend
		@parent 	bookExtend
		@type 		struct<EnemyBookExtend>
		@text 		∟∟エネミー図鑑詳細
		@desc 		エネミー図鑑の強化に関する詳細設定です。

		@param 	termBook
		@parent 	bookExtend
		@type 		struct<TermBook>[]
		@text 		∟∟用語図鑑詳細
		@desc 		用語図鑑に関する詳細設定です。

		@param 	tutorialBook
		@parent 	bookExtend
		@type 		struct<TermBook>[]
		@text 		∟∟チュートリアル詳細
		@desc 		チュートリアル図鑑に関する詳細設定です。

		@param 	tutorialDialog
		@parent 	bookExtend
		@type 		string[]
		@text 		∟∟チュートリアルダイアログ
		@desc 		チュートリアル図鑑に関するダイアログ設定です。
		@default 	["チュートリアルを終了しますか？","はい","いいえ"]


@param inter
@text 	-------------------------

@param 	status
@type		select
@text		S t a t u s
@desc		能力の拡張や追加など、戦闘に関する要素を設定します。
@default	名前横の階層ボタンで展開・収納
@option	名前横の階層ボタンで展開・収納
@value		名前横の階層ボタンで展開・収納


	@param 	statusParameter
	@parent 	status
	@type 		struct<StatusParameter>
	@text 		∟能力補正の基本設定
	@desc 		バフや会心率などに関する諸設定を行います。
	

			@param 	inter_battleCustom
			@parent 	status
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	defeat
	@parent 	status
	@type 		common_event[]
	@text 		∟撃破演出
	@desc 		HPが０になった時のコモンイベントを設定します。[ザコ敵, ボス, 瞬間消滅]の順に適用されます。
	@default 	["0", "0", "0"]

			@param 	inter_defeat
			@parent 	status
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	states
	@parent 	status
	@type 		struct<States>
	@text 		∟ステート機能拡張
	@desc 		ステートの拡張設定を行います。

			@param 	inter_state
			@parent 	status
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	characterMake
	@parent 	status
	@type 		struct<CharacterMake>
	@text 		∟素性決定UI
	@desc 		キャラクターメイクのUIに必要な設定を行います。

			@param 	inter_charaMake
			@parent 	status
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------


	@param 	soulLevel
	@parent 	status
	@type 		struct<SoulLevel>
	@text 		∟ステ振りシステム
	@desc 		ステータスにポイントを振り分けるレベルシステムに関する設定です。

			@param 	inter_soulLevel
			@parent 	status
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	
	@param 	expansionBaseStatus
	@parent 	status
	@type 		struct<ExpansionBaseStatus>[]
	@text 		∟基本能力の拡張
	@desc 		デフォルトで実装されている基本能力に関する拡張設定です。上からHP MP ATK DEF MAT MDF SPD LUKとなります。

			@param 	inter_statusBase
			@parent 	status
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	
	@param 	expansionParam1
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟独自追加能力１
	@desc 		ユーザー定義のアクター能力を設定します。
	
	@param 	expansionParam2
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟独自追加能力２
	@desc 		ユーザー定義のアクター能力を設定します。
	
	@param 	expansionParam3
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟独自追加能力3
	@desc 		ユーザー定義のアクター能力を設定します。
	
	@param 	expansionParam4
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟独自追加能力4
	@desc 		ユーザー定義のアクター能力を設定します。
	
	@param 	expansionParam5
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟独自追加能力5
	@desc 		ユーザー定義のアクター能力を設定します。
	
	@param 	expansionParam6
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟独自追加能力6
	@desc 		ユーザー定義のアクター能力を設定します。
	
	@param 	expansionParam7
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟独自追加能力7
	@desc 		ユーザー定義のアクター能力を設定します。
	
	@param 	expansionParam8
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟独自追加能力8
	@desc 		ユーザー定義のアクター能力を設定します。
	
	@param 	expansionParam9
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟独自追加能力9
	@desc 		ユーザー定義のアクター能力を設定します。
	
	@param 	expansionParam10
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟独自追加能力10
	@desc 		ユーザー定義のアクター能力を設定します。

	@param endline
	@parent status
	@type 		select
	@text 		以上
	@desc 		MVでは以下にパラメーターが存在しますが、設定不要です。
	@default	---------------------------
	@option	---------------------------
	@value		---------------------------


			@param 	inter_end
			@parent 	status
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------


				@command speaker
				@text speaker -バルーン位置調整-
				@desc メッセージウィンドウを話者の近くに移動させます。

					@arg eventid
					@text 話者イベントID
					@desc 話者のイベントIDを設定します。
					@type number
					@default 0
					@decimals 0
					@min -1

					@arg position
					@text バルーン位置
					@desc メッセージ位置の配置場所を設定します。
					@type select
					@default right
						@option 左上
						@value upperLeft
						@option 上
						@value upperCenter
						@option 右上
						@value upperRight
						@option 左
						@value left
						@option 真ん中
						@value center
						@option 右（デフォルト）
						@value right
						@option 左下
						@value belowLeft
						@option 下
						@value belowCenter
						@option 右下
						@value belowRight

				
				@command growparam
				@text growParam -パラメーター成長-
				@desc アクターの能力を増減させます。
					@arg actorid
					@text 対象アクター
					@desc 0の時、パーティ全員が対象になります。
					@type actor
					@default 0

					@arg parameter
					@text 対象パラメーター
					@desc 10~19は追加能力を実装中に有効です。
					@type number
					@default 0
					@decimals 0
					@max 19

					@arg grow
					@text 増減ポイント
					@desc 増減する値を設定します。
					@type number
					@default 0
					@decimals 0
					@max 99999999
					@min -99999999


				@command difficulty
				@text difficulty -難易度操作-
				@desc offsetの値だけ難易度を操作します。

					@arg offset
					@text 変更値
					@desc 操作する値を設定します。
					@type number
					@decimals 1
					@default 1
					@min -10
					@max 10


				@command customizevehicle
				@text customizeVehicle -乗り物改造-
				@desc 乗り物の性能を変更します。

					@arg type
					@text 乗り物タイプ
					@desc 改造したい乗り物のタイプを設定します。
					@type string

					@arg parts
					@text 改造パーツ
					@desc 改造したい性能を設定します。
					@type select
					@default altitude
						@option 飛翔高度
						@value altitude
						@option 移動速度
						@value speed
						@option 可動領域
						@value passable
						@option エンカウント
						@value encount
						@option ダメージ床
						@value damagefloor
						@option 滑る床
						@value noslip
						@option 見た目
						@value body
						@option プレイヤープライオリティ
						@value priority

					@arg value
					@text 改造値
					@desc 変更したい値を設定します。
					@type string

					@arg index
					@text 画像インデックス
					@desc 乗り物の見た目にする画像ファイルのインデックスを設定します。
					@type number
					@decimals 0
					@default 0
					@max 7

				@command vehiclelocation
				@text vehicleLocation -乗り物の位置設定-
				@desc 乗り物の位置を変更します。追加したものも対象にできます。

					@arg type
					@text 乗り物タイプ
					@desc 移動する乗り物のタイプを設定します。
					@type string

					@arg direct
					@text 場所指定の方法
					@desc 0なら座標式、1なら変数式になります。
					@type number
					@decimals 0
					@default 0
					@max 1

					@arg mapid
					@text マップID
					@desc 移動先のマップID、あるいはそのための変数のIDを設定します。
					@type number
					@decimals 0
					@default 0

					@arg x
					@text X座標
					@desc 移動先のX座標、あるいはそのための変数のIDを設定します。
					@type number
					@decimals 0
					@default 0

					@arg y
					@text Y座標
					@desc 移動先のY座標、あるいはそのための変数のIDを設定します。
					@type number
					@decimals 0
					@default 0
									

				@command sealacce
				@text sealAcce -アクセサリースロット操作-
				@desc アクセサリースロットの解放・封印を行います。

					@arg seal
					@text 実行内容
					@desc スロットを封印するか、開放するかを選択します。
					@type select
					@default s
						@option 封印
						@value s
						@option 解放
						@value r

					@arg actorid
					@text 対象アクター
					@desc 対象のアクターを選択します。0の時、アクター全員を対象にします。
					@type actor
					@default 0

				
				@command forceencount
				@text forceEncount -強制エンカウント-
				@desc エンカウントを強制的に発生させます。

				
				@command equipbattle
				@text equipBattle -戦闘中装備画面-
				@desc 戦闘中に、装備画面を呼び出します。

				@command exchangeequips
				@text exchangeEquips -サブ装備入替え-
				@desc サブ装備とメイン装備を入替えます。変更可能部位が武器・盾（独立入替え式）のみslotIdが必要です。
					
					@arg actorid
					@text 		対象のアクターID
					@desc 		装備入替えを行うアクターのIDを設定します。0でリーダー、-1でバトル中のコマンド実行者になります。
					@type 		number
					@decimals 	0
					@default 	0
					@min 		-1

					@arg slotid
					@text 		変更する装備スロットID
					@desc 		武器か盾のどちらを変更するかを設定します。武器なら0、盾なら1を選択して下さい。
					@type 		number
					@decimals 	0
					@default 	0
					@max 		1


				@command endgameover
				@text endGameover -ゲームオーバー処理完了-
				@desc ゲームオーバーを自作時、処理を完了します。


				@command trophy
				@text trophy -トロフィー管理-
				@desc トロフィーの進捗を更新します。

					@arg id
					@text 対象のトロフィーID
					@desc トロフィーのIDを選択します。
					@type number
					@decimals 0
					@default 1
					@min 1

					@arg reset
					@text 更新タイプ
					@desc 進捗を進めるか、リセットするかを選択します。
					@type select
					@default gain
						@option 進行
						@value gain
						@option リセット
						@value reset


				@command multiparty
				@text multiParty -複数パーティ管理-
				@desc 複数パーティに関する処理を実行します。

					@arg exe
					@text 実行内容
					@desc 実行内容を選択します。
					@type select
					@default party
						@option パーティ数を変更します
						@value party
						@option 編成の継承可否を変更します。
						@value inherit
						@option メニューへのコマンド実装を変更します。
						@value addmenu
						@option リザーブパーティをリセットします
						@value resetreserve
						@option 編成シーンを開きます
						@value open
						@option パーティチェンジを行います。
						@value swap

					@arg value
					@text 引数
					@desc ブール変数、あるいはパーティIDを記入します。
					@type string


				@command stepshop
				@text stepShop -段階ショップ-
				@desc 段階売価ショップを展開します。

					@arg sellok
					@text 売却OK
					@desc Onの時、段階売価ショップで売却も可能になります。
					@type boolean
					@default false


				@command cswitch
				@text cSwitch -共有スイッチの管理-
				@desc 共有スイッチの処理を管理します。

					@arg exe
					@text 実行内容
					@desc 実行する挙動を選択します。
					@type select
					@default set
						@option 共有スイッチを更新します
						@value set
						@option 共有スイッチの情報を得ます
						@value read
						@option 全ての共有スイッチを初期化します。
						@value init

					@arg id
					@text 対象ID
					@desc 共有スイッチのIDを選択します。
					@type number
					@decimals 0
					@default 0

					@arg value
					@text 文字列
					@desc on off name flag あるいは適切な文字列を記入します。
					@type string
					@default on


				@command door
				@text door -ドア開閉-
				@desc ドアや宝箱の開閉を実行します。

					@arg exe
					@text 実行内容
					@desc 実行内容を選択します。
					@type select
					@default open
					 @option 開ける
					 @value open
					 @option 閉じる
					 @value close

					@arg weight
					@text ドアの重量感
					@desc 対象のドアの重量感を選択します。
					@type select
					@default light
						@option 軽いドア
						@value light
						@option 重いドア
						@value heavy

					@arg targetid
					@text 対象のイベントID
					@desc 対象のイベントIDを設定します。0の時、コマンドを実行するイベントになります。
					@type number
					@decimals 0
					@default 0


				@command autoopacity
				@text autoOpacity -自動透明化-
				@desc 透明化の処理を自動で行います。

					@arg id
					@text 対象ID
					@desc 透明化する対象を設定します。-1でプレイヤー、0でこのイベントになります。
					@type number
					@decimals 0
					@min 	-1
					@default 0

					@arg start
					@text 開始不透明度
					@desc 処理開始時の不透明度を0~255で設定します。
					@type number
					@decimals 0
					@max 	255
					@default 255

					@arg end
					@text 終了不透明度
					@desc 処理終了時の不透明度を0~255で設定します。
					@type number
					@decimals 0
					@max 	255
					@default 0

					@arg offset
					@text オフセット
					@desc 遷移する不透明度のオフセットを0~255で設定します。
					@type number
					@decimals 0
					@max 	255
					@default 30

					@arg wait
					@text ウェイトフレーム
					@desc 処理の間隔となるウェイトフレームを設定します。
					@type number
					@decimals 0
					@default 3


				@command autojump
				@text autoJump -自動ジャンプ-
				@desc 向きに合わせたジャンプを行います。

					@arg id
					@text 対象ID
					@desc ジャンプする対象を設定します。-1でプレイヤー、0でこのイベントになります。
					@type number
					@decimals 0
					@min 	-1
					@default 0

					@arg x
					@text X方向の移動距離
					@desc 下向き基準でX方向への移動距離を設定します。
					@type number
					@decimals 0
					@default 0

					@arg y
					@text Y方向の移動距離
					@desc 下向き基準でY方向への移動距離を設定します。
					@type number
					@decimals 0
					@default 0

					@arg dirfix
					@text 向き固定
					@desc ジャンプ中の向き固定状態を設定します。
					@type boolean
					@default true

					@arg jumpType
					@text ジャンプの種類
					@desc ジャンプにおける挙動の種類を選択します。
					@type select
					@default step
						@option ステップ(障害物で止まるジャンプ)
						@value step
						@option 跳躍(壁や海以外は飛び越えるジャンプ)
						@value ride
						@option 落下(壁に着地すると地面まで移動するジャンプ)
						@value fall
						@option 崖登り(壁にしがみつけるジャンプ)
						@value climb


				@command timer
				@text 	timer -タイマー操作-
				@desc 	タイマーの追加操作を行います

					@arg 	exe
					@text 	実行内容
					@desc 	タイマー処理の内容を設定します。
					@type 	select
					@default add
						@option 追加（second秒だけ延長）
						@value 	add
						@option 短縮（second秒だけ短縮）
						@value 	reduce
						@option 一時停止
						@value 	pause
						@option 再開
						@value 	restart
					@arg 	second
					@text 	秒数
					@desc 	延長・短縮する秒数を設定します。
					@type 	number
					@default 0
					@decimals 0


				@command jukebox
				@text jukebox -サウンドテスト展開-
				@desc サウンドテストを開きます。


				@command fasttravel
				@text fasttravel -ファストトラベル管理-
				@desc ファストトラベルに関する処理を管理します。

					@arg exe
					@text 処理内容
					@desc 管理を実行する内容を選択します。
					@type select
					@default call
						@option 転送シーンを呼び出します。
						@value call
						@option 拠点を解放します。
						@value base
						@option 指定の転送先を解放します。
						@value release
						@option 指定の転送先を封印します。
						@value seal
						@option 指定の転送先を一時的に封印します。
						@value sealtemp
						@option 指定の転送先の一時的な封印を解除します。
						@value releasetemp
						@option 全ての転送先を解放します。
						@value all
						@option 指定の転送先の名前を変更します。
						@value name
						@option 指定の転送先の画像を変更します。
						@value img
						@option 変数格納した拠点名を変更します。
						@value rename

					@arg areaid
					@text エリアID
					@desc 対象とする転送先のエリアIDを設定します。
					@type number
					@decimals 0
					@default 1

					@arg regionid
					@text キャンプID
					@desc 対象とする転送先のキャンプIDを設定します。
					@type number
					@decimals 0
					@default 0

					@arg name
					@text 名前
					@desc 上書きしたい転送先の名前、あるいは画像のファイル名を設定します。
					@type string


				@command partyrespawn
				@text partyRespawn -リスポーン地点更新-
				@desc パーティのリスポーン地点を任意の位置に更新します。

					@arg mapid
					@text マップID
					@desc 新たなリスポーン地点のマップIDを設定します。
					@type number
					@default 0
					@decimals 0

					@arg x
					@text マップX座標
					@desc 新たなリスポーン地点のX座標を設定します。
					@type number
					@default 0
					@decimals 0

					@arg y
					@text マップY座標
					@desc 新たなリスポーン地点のY座標を設定します。
					@type number
					@default 0
					@decimals 0

				@command transfer
				@text transfer -特殊な自動転送-
				@desc ファストトラベルやデスルーラを実行します。

					@arg exe
					@text 転送内容
					@desc 自動転送の内容を選択します。
					@type select
					@default fasttravel
						@option ファストトラベル
						@value fasttravel
						@option デスルーラ
						@value deathzoom


				@command originalfade
				@text originalFade -独立した画面のフェード-
				@desc 画面のフェードアウト/イン、あるいはホワイトアウト/インを実行します。

					@arg exe
					@text 実行内容
					@desc フェードの種類を選択します。
					@type select
					@default out
						@option アウト
						@value  out
						@option イン
						@value  in

					@arg duration
					@text 実行時間
					@desc フェードの時間(フレーム)を設定します。-1でデフォルトの時間になります。
					@type number
					@default 30
					@decimals 0
					@min -1
					@max 9999

					@arg wait
					@text 待機指示
					@desc 待機を選択すると、フェードが完了するまで次の実行を待機させます。
					@type select
					@default wait
						@option 待機
						@value  wait
						@option 待機しない
						@value  go

					@arg white
					@text ホワイト化
					@desc 白を選択すると、フェード画面が白くなります。
					@type select
					@default black
						@option 白
						@value  white
						@option 黒
						@value  black


				@command guide
				@text guide -ガイド管理-
				@desc ガイド機能の管理を行います。

					@arg target
					@text 対象ガイド
					@desc 管理を行う対象ガイドを選択します。
					@type select
					@default main
						@option メインガイド
						@value main
						@option サブガイド
						@value sub
						@option モブガイド
						@value mob

					@arg id
					@text ガイドID
					@desc 対象にするガイドのIDを選択します。
					@type number
					@decimals 0
					@default 1
					@min 1

					@arg exe
					@text 実行内容
					@desc 対象のガイドに行う処理を選択します。
					@type select
					@default show
						@option ガイド開始
						@value start
						@option ガイド進展
						@value gain
						@option ガイド自動進展
						@value autogain
						@otion ガイド表示切替
						@value show


				@command charamake
				@text charaMake -キャラクターメイク展開-
				@desc キャラクターメイクのシーンを呼び出します。


				@command chest
				@text chest -倉庫の展開-
				@desc 倉庫シーンを呼び出します。

					@arg chestid
					@text 倉庫ID
					@desc 呼び出したい倉庫のIDを設定します。
					@type number
					@decimals 0
					@default 0


				@command bank
				@text bank -銀行の展開-
				@desc 銀行シーンを呼び出します。

					@arg bankid
					@text 銀行ID
					@desc 呼び出したい銀行のIDを設定します。
					@type number
					@decimals 0
					@default 0


				@command allocate
				@text allocate -ステ振りUIの展開-
				@desc ステータスを振り分けるシーンを呼び出します。

					@arg id
					@text アクターID
					@desc 対象にするアクターのIDを設定します。0の時、パーティリーダーになります。
					@type actor
					@default 0


				@command resetallocate
				@text resetAllocate -ステ振りのリセット-
				@desc 振り分けたステータスをリセットします。

					@arg id
					@text アクターID
					@desc 対象にするアクターのIDを設定します。0の時、パーティリーダーになります。
					@type actor
					@default 0


				@command stopwarning
				@text stopWarning -警戒状態の解除-
				@desc イベントエネミーの警戒状態を解除します。

					@arg id
					@text 対象のイベントID
					@desc 解除するイベントIDを設定します。0の時、コマンドを実行するイベントになります。
					@type number
					@decimals 0
					@default 0

				@command stopcaution
				@text stopCaution -発見状態の解除-
				@desc イベントエネミーの発見状態を解除します。

					@arg id
					@text 対象のイベントID
					@desc 解除するイベントIDを設定します。0の時、コマンドを実行するイベントになります。
					@type number
					@decimals 0
					@default 0

				@command stopwc
				@text stopWC -警戒・発見状態の解除-
				@desc イベントエネミーの警戒状態・発見状態を解除します。

					@arg id
					@text 対象のイベントID
					@desc 解除するイベントIDを設定します。0の時、コマンドを実行するイベントになります。
					@type number
					@decimals 0
					@default 0


				@command actionend
				@text actionEnd -アクション実行の完了-
				@desc アクションのコモンイベントの完了をエンジンに伝えます。


				@command action
				@text action -アクションアニメーションの実行-
				@desc スキルと連動したアクションを演出します。

					@arg targetid
					@text 対象のキャラクター
					@desc イベントIDを設定します。0でこのイベント、-1でプレイヤーとなります。
					@type number
					@decimals 0
					@default 0
					@min -1

					@arg animeid
					@text アニメーションID
					@desc 実行するアニメーションのIDを選択します。
					@type animation
					@default 0

					@arg origin
					@text 原点調整
					@desc アニメーションを開始する原点を設定します。
					@type number
					@decimals 1
					@default 0
					@min -6

					@arg turn
					@text アニメーションの回転
					@desc キャラクターの向きに合わせた回転設定を行います。
					@type select
					@default 0
						@option 回転無し
						@value 0
						@option 原点位置のみ調整
						@value 1
						@option 回転角度のみ調整
						@value 2
						@option 原点位置・回転角度を調整
						@value 3

					@arg skillid
					@text スキルID
					@desc このアクションで紐付けるスキルのIDを設定します。
					@type skill
					@default 0

					@arg hiteffid
					@text ヒットエフェクト
					@desc 攻撃がヒット時に表示されるアニメーションを設定します。
					@type animation
					@default 0

					@arg isPlayer
					@text 	プレイヤーアクション
					@desc 	このアクションがプレイヤーから発せられたものかどうか設定します。
					@type 	boolean
					@default false

					@arg wait
					@text 	完了までウェイト
					@desc 	アニメーションが完了するまでウェイトするか設定します。
					@type 	boolean
					@default false
				
				@command shortcutitem
				@text shortcutItem -ショートカットアイテムの使用-
				@desc ショートカット設定されたアイテムを使用します。アクションの有効化とアイテムHUDの実装が必要です。

				@command nextshortcutitem
				@text nextShortcutItem -次のショートカットアイテム-
				@desc ショートカットのアイテムリストを１つ送ります。アクションの有効化とアイテムHUDの実装が必要です。

				@command previousshortcutitem
				@text previousShortcutItem -前のショートカットアイテム-
				@desc ショートカットのアイテムリストを１つ戻します。アクションの有効化とアイテムHUDの実装が必要です。


				@command lockon
				@text lockon -ロックオン-
				@desc ロックオンの管理をします。

					@arg exe
					@text 実行内容
					@desc ロックオンの実行内容を選択します。
					@type select
					@default on
						@option ロックオン状態にします
						@value on
						@option ロックオンを解除します
						@value off
						@option 現在の状態を逆にします
						@value auto


				@command evasion
				@text evasion -防御アクション-
				@desc 防御系のアクションを実行します。

					@arg target
					@text 対象キャラクター
					@desc イベントIDを設定します。0でこのイベント、-1でプレイヤーになります。
					@type number
					@decimals 0
					@default 0
					@min -1

					@arg act
					@text 防御行動
					@desc 実行したい防御アクションを選択します。
					@type select
					@default eva
						@option 回避行動を実行します。
						@value eva
						@option ガード行動を実行します。
						@value grd
						@option ガード行動を解除します。
						@value rem
						@option パリィ判定を付与します。
						@value parry
						@option 向き補正ありのパリィ判定を付与します。
						@value deflect

					@arg justActionSwitch
					@text 	ジャストアクションスイッチ
					@desc 	ジャストアクション発生時にOnにするスイッチを選択します。
					@type 	switch
					@default 	0


				@command defeat
				@text defeat -討伐演出-
				@desc エネミー討伐時のアニメーションを設定します。

					@arg animeid
					@text アニメーションID
					@desc 実行するアニメーションIDを選択します。
					@type animation
					@default 0

					@arg selfswitch
					@text セルフスイッチ
					@desc 討伐時にOnにするスイッチを選択します。
					@type select
						@option D
						@value D
						@option C
						@value C
						@option B
						@value B
						@option A
						@value A


				@command defeatend
				@text defeatEnd -討伐演出の完了-
				@desc バトルシーンで、討伐演出の完了をエンジンに伝えます。


				@command rewards
				@text rewards -撃破報酬の獲得・非戦闘報酬の入手-
				@desc イベントエネミーが保持する討伐報酬を入手します。または、イベントによるアイテム入手をサポートします。

					@arg displaypopup
					@text ポップアップ表示
					@desc Onの時、入手表示がポップアップになります。
					@type boolean
					@default false

					@arg itemtype
					@text アイテムタイプ
					@desc 続くgetidを指定する場合、アイテムの種類を選択します。（非戦闘報酬用）
					@type select
					@default item
						@option アイテム
						@value item
						@option 武器
						@value weapon
						@option 防具
						@value armor
						@option 変数
						@value variable

					@arg getid
					@text 入手ID
					@desc 入手するアイテムのIDを設定します。変数タイプの時は10000台なら武器、20000台なら防具のIDとなります。（非戦闘報酬用）
					@type number
					@decimals 0
					@min 0
					@max 29999
					@default 0

					@arg amouont
					@text 入手数
					@desc アイテムの入手数を示す変数のID設定します。0のときは１つだけ入手します。（非戦闘報酬用）
					@type number
					@decimals 0
					@min 0
					@max 9999
					@default 1


				@command respawn
				@text respawn -リスポーン-
				@desc イベントのリスポーン処理を実行します。

					@arg targetid
					@text リスポーン対象
					@desc 半角数字でイベントIDを、あるいは map か all を記入します。
					@type string
					@default 0


				@command bosshpbar
				@text bossHpBar -ボスHPバー出現-
				@desc マップ内ボスのHPバーを出現させます。

					@arg show
					@text 表示の是非
					@desc バーの出現状態を設定します。
					@type select
					@default show
						@option HPバーを表示
						@value show
						@option HPバーを非表示
						@value hide

					@arg id
					@text 対象のイベントID
					@desc 半角数字でイベントIDを、あるいは all を記入します。
					@type string
					@default all


				@command termbook
				@text TermBook -用語図鑑の管理-
				@desc 用語図鑑の管理を行います。

					@arg exe
					@text 実行内容
					@desc 実行する内容を選択します。
					@type select
					@default add
						@option 図鑑の追加、あるいは進行を行います
						@value add
						@option 図鑑を完成させます
						@value comp

					@arg category
					@text カテゴリーID
					@desc 用語が属するカテゴリーのIDを選択します。
					@type number
					@decimals 0
					@default 1
					@min 1

					@arg id
					@text 用語ID
					@desc 用語のIDを選択します。
					@type number
					@decimals 0
					@default 1
					@min 1


				@command tutorialbook
				@text TutorialBook -チュートリアル図鑑の管理-
				@desc チュートリアル図鑑の管理を行います。

					@arg exe
					@text 実行内容
					@desc 実行する内容を選択します。
					@type select
					@default add
						@option 図鑑の追加、あるいは進行を行います
						@value add
						@option 図鑑を完成させます
						@value comp

					@arg category
					@text カテゴリーID
					@desc チュートリアルが属するカテゴリーのIDを選択します。
					@type number
					@decimals 0
					@default 1
					@min 1

					@arg id
					@text チュートリアルID
					@desc チュートリアルのIDを選択します。
					@type number
					@decimals 0
					@default 1
					@min 1


				@command getallitems
				@text 	getAllItems -全アイテム取得-
				@desc 	アイテム、武器、防具を１つずつ入手します。

					@arg num
					@text 取得個数
					@desc 取得する個数を設定します。
					@type number
					@decimals 0
					@default 1
					@min 1
					@max 99


				@command weaponchoice
				@text 	weaponChoice -武器選択処理-
				@desc 	アイテム選択の処理を武器選択に変更します。


				@command armorchoice
				@text 	armorChoice -防具選択処理-
				@desc 	アイテム選択の処理を防具選択に変更します。


				@command resetchoice
				@text 	resetChoice -アイテム選択処理初期化-
				@desc 	アイテム選択の処理を元のアイテム選択に戻します。

			
				@command operate
				@text operate -パラメーター操作-
				@desc プラグインパラメーターの一部を操作します。

					@arg what
					@text 操作内容
					@desc 操作するパラメーターを選択します。
					@type select
					@default balloon
						@option バルーン化の切替
						@value balloon
						@option 歩幅の再設定
						@value stride
						@option 探索ヘルプの上書き
						@value searchHelp
						@option 固定リーダー変更
						@value leader
						@option 店名変更
						@value shopName

					@arg argument
					@text 引数
					@desc 詳細はreadmeを参照して下さい。
					@type string
			
*/
/*---------------------------------------------------------------------------------------------------*/

/*:
@target MV MZ
@plugindesc 【β4.3.1】You can enhance Movement, make Action System, operate parameters.
@author	Utoi Tozuka
*
@help
*****************【simplified chart】*****************************************************	
【escap characters】
\F 	:Make message speed faster
\S 	:Make message speed slower
\D 	:Make message speed more slower
\E 	:Change message color for enhancing
\W 	:Change message color for warning
\R 	:Reset message color


Read the online-manual to check details.

***************＜Notices＞*****************************************************

*！！Event Object's selfMovement in Action Games
	If it is warning, the selfMovement is ignored.

	--------------------------------------------------------------------------
*！！Customize animation's collider
	You can control the collider's radius by naming "name\number".
	The default radius is half of a sprite's width.

	（ex：slash\3
	     The collider's radius is one third of a sprite's width.）

	--------------------------------------------------------------------------
*！！PluginParameter "expansionBaseStatus"
	You can't override the function of Database.
	The parameter just controls status in gaming.

	--------------------------------------------------------------------------
*！！Calculation buff or debuff
	Add type ：The Default function ; 1 plus (or minus) "buffRate" multiplied by buff (or debuff) times.
	         (ex：When "buffRate" is 0.25, result is 1.25 by 1 time buff, 1.5 by 2 times buff.)
	Expo type：First 1 plus (or minus) "buffRate", then it is raised to the power of buff (or debuff) times.
	         (ex：When "buffRate" is 0.25, result is 1.25 by 1 time buff, 1.5625 by 2 times buff.)

	--------------------------------------------------------------------------
*！！ParameterId of status
	0:max Hp 1:max Mp

	2:Attack 3:Defence 4:Magic Attack 5:Magic Defence 6:Speed 7:Luck

	10 to 19:Your Definition in PluginParamter "expansionParam1 to 10"

	--------------------------------------------------------------------------
*！！Calculation type of traits for displaying
	percentage：a trait value is multiplied by 100.
	            If you turn off PluginParameter "traitCalc" in "windowCustom",
	            all traits is displayed by this type.

	resistance：a trait value is reduced from 1,
	            and then it is multiplied by 100.
	            It is easier for players to check the strength of resitance.
	
	rate      ：a trait value is displayed as it is.
		    This is used the following ;
	　　　　　　　　　Target Rate, Guard Effect, Recovery Effect, Pharmacology
	　　　　　　　　　TP Charge Rate, Experience

	--------------------------------------------------------------------------
*！！ParameterId of traits
	１：index of PluginParameter "traitsWindow" in "windowCustom" ;
		-1 	：not used
		0~9 	：Ex-Param
		10~19 	：Sp-Param（use the last digit）
		101~199 	：element rate（use the two lower digits）
		201~1200 	：state rate（ues after index minus 200）
	
	２：Items in xParam or sParam with Id are the following ;
	   ＜Ex-Param＞　　		　＜Sp-Param＞
	0　　Hit Rate		Target Rate
	1　　Evasion Rate		Guard Effect
	2　　Critical Rate		Recovery Effect
	3　　Critical Evasion		Pharmacology
	4　　Magic Evasion		MP Cost Rate
	5　　Magic Reflecrtion		TP Charge Rate
	6　　Counter Attack		Physical Damage
	7　　HP Regeneration		Magic Damage
	8　　MP Regeneration		Floor Damage
	9　　TP Regeneration		Experience
	--------------------------------------------------------------------------

Copyright (c) 2024 Utoi Tozuka
Released under the MIT license
https://opensource.org/license/mit-license.php
//end
***********************************************************************************

@param 	consoler
@type 		boolean
@text 		Consoler
@desc 		Output PluginParameters onto debugMode (F8) when this is true
@default 	false

@param inter
@text 	-------------------------

@param 	ConfigExtend
@type		select
@text		C o n f i g
@desc		Extend function of config and shareable datas among savefiles.
@default	open or close by pushing left button
@option	open or close by pushing left button
@value		open or close by pushing left button

	@param configTitleWindow
	@parent 	ConfigExtend
	@type 		struct<ConfigTitleWindow>
	@text 		∟customize Title Window
	@desc 		Settings of customized title window

			@param 	inter_configTitleWindow
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param configSaveLoad
	@parent 	ConfigExtend
	@type 		struct<ConfigSaveLoad>
	@text 		∟extend save and load
	@desc 		Settings of extended save and load

			@param 	inter_configSaveLoad
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param configGeneralCommands
	@parent 	ConfigExtend
	@type 		struct<ConfigGeneralCommands>
	@text 		∟General Option Command
	@desc 		Display or not option commands; auto dush or remember command

			@param 	inter_configGeneralCommands
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param eventSkip
	@parent 	ConfigExtend
	@type 		struct<EventSkip>
	@text 		∟event skip
	@desc 		Settings of Event Skip

			@param 	inter_eventSkip
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param initializedSwitches
	@parent 	ConfigExtend
	@type 		switch[]
	@text 		∟initialized switches
	@desc 		Select switches turned on when players starts this game

			@param 	inter_initializedSwitches
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	configDifficulty
	@parent 	ConfigExtend
	@type 		struct<ConfigDifficulty>
	@text 		∟ Difficulty
	@desc 		Introduce and control difficulty.
	
		@param 	difLevel
		@parent 	configDifficulty
		@type 		struct<DifLevel>
		@text 		∟∟ Difficulty Level
		@desc 		Detail settings of difficulty with level type

		@param 	difStepless
		@parent 	configDifficulty
		@type 		struct<DifStepless>
		@text 		∟∟ Difficulty Stepless
		@desc 		Detail settings of difficulty with stepless type

			@param 	inter_difficulty
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	
	@param 	configAudio
	@parent 	ConfigExtend
	@type 		struct<ConfigAudio>
	@text 		∟ Audio Config
	@desc 		Detail settings of audio config

			@param 	inter_configAudio
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------
	
	@param 	configMessageSpeed
	@parent 	ConfigExtend
	@type 		struct<ConfigMessageSpeed>
	@text 		∟ Message Speed
	@desc 		Introduce and control message speed in config

		@param 	attentionColor
		@parent 	configMessageSpeed
		@type 		struct<AttentionColor>
		@text 		∟∟ Message Color
		@desc 		Settings of message color to emphasize or warn
	

			@param 	inter_configMessage
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	commonSwitches
	@parent 	ConfigExtend
	@type 		string[]
	@text 		∟ Common Switches
	@desc 		Introduce common switches shareable among savefilses

			@param 	inter_commonSwitch
			@parent 	ConfigExtend
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	trophy
	@parent 	ConfigExtend
	@type 		struct<Trophy>[]
	@text 		∟ Achievement
	@desc 		Introduce achievements

		@param 	trophyConfig
		@parent 	trophy
		@type 		struct<TrophyConfig>
		@text 		∟∟ Achievement Settings
		@desc 		Common Settings about displaying achievement

		@param 	trophyGenre
		@parent 	trophy
		@type 		string[]
		@text 		∟∟ Achievement Genre
		@desc 		Settings of genre names to separate achievements


@param inter
@text 	-------------------------

@param moving
@type		select
@text		M o v e m e n t
@desc		Control and support player's movement
@default	open or close by pushing left button
@option	open or close by pushing left button
@value		open or close by pushing left button

	@param 	fieldBasic
	@parent 	moving
	@type 		struct<FieldBasic>
	@text 		∟ Player's Movement
	@desc 		Settings of enhancing player's movement

			@param 	inter_field
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	vehicleValid
	@parent 	moving
	@type 		boolean
	@text 		∟vehicle extend valid
	@desc 		Turn on the following list when this is true
	@default 	false

			@param 	vehicleList
			@parent 	vehicleValid
			@type 		struct<VehicleList>[]
			@text 		∟∟Settings of vehicles
			@desc 		Construct additional vehicle list

			@param 	inter_vehicles
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	staminaMode
	@parent 	moving
	@type 		boolean
	@text 		∟ Stamina
	@desc 		Need stamina cost for player's moving when this is true
	@default 	false
	
		@param 	staminaStatus
		@parent 	staminaMode
		@type 		select
		@text 		∟∟ Stamina Status
		@desc 		Select a status for stamina
		@default 	mp
		
			@option 	HP
			@value 	hp
			@option 	MP
			@value 	mp
			@option 	TP
			@value 	tp
			@option 	No Stamina
			@value 	none

		
		@param 	hpSpeedType
		@parent 	staminaMode
		@type 		select
		@text 		∟∟ Stamina Move Speed
		@desc 		Select an affection 
		@default 	fixed

			@option  	rate（current / max）
			@value  	rate

			@option  	fixed（current）
			@value  	fixed

			@option 	limited（none）
			@value 	limited
		
		@param 	heavyStatus
		@parent 	staminaMode
		@type 		struct<HeavyStatus>
		@text 		∟∟ stats for weight
		@desc 		Construct weight stats
		
		@param 	itemWeight
		@parent 	staminaMode
		@type 		boolean
		@text 		∟∟ Item Weight
		@desc 		Add weight to items by Note Tag <heave:n> when this is true
		@default 	true
		
			@param 	inter_stamina
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------
	
	@param 	dayNightConcept
	@parent 	moving
	@type 		boolean
	@text 		∟ Day and Night
	@desc 		Introduce day and night into your game when this is true
	@default 	false
	
		@param 	daySecond
		@parent 	dayNightConcept
		@type 		struct<DaySecond>
		@text		∟∟ Daytime Settings
		@desc 		Settings of duration and screen tone for daytime
		
		
		@param 	twilightSecond
		@parent 	dayNightConcept
		@type 		struct<DaySecond>
		@text		∟∟ Twilight Settings
		@desc 		Settings of duration and screen tone for twilight
		
		
		@param 	nightSecond
		@parent 	dayNightConcept
		@type 		struct<DaySecond>
		@text		∟∟ Night Settings
		@desc 		Settings of duration and screen tone for night
		
			@param 	inter_seconds
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	multiParty
	@parent 	moving
	@type 		struct<MultiParty>
	@text 		∟ Multi Parties
	@desc 		Settings of multi parties

			@param 	initialMembers
			@parent 	multiParty
			@type 		struct<initialMembers>[]
			@text		∟∟initial members in each party
			@desc 		Initialize each party when multiParty is valid

			@param 	inter_party
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	timer
	@parent 	moving
	@type 		struct<Timer>
	@text 		∟ Timer Sprite
	@desc 		Control a sprite for timer function

			@param 	inter_timer
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	searchHelp
	@parent 	moving
	@type 		struct<SearchHelp>
	@text 		∟ Search Help
	@desc 		Settings of supporter to find Event Objects
	
			@param 	inter_searchHelp
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	doorCommand
	@parent 	moving
	@type 		struct<DoorCommand>
	@text 		∟ Door
	@desc 		Settings for PluginCommand "door"

			@param 	inter_door
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	regionWall
	@parent 	moving
	@type 		number[]
	@text 		∟region for wall
	@desc 		Settings of regionId to stop jumpping
	@decimals 	0
	@default 	["0"]
	@max 		255

			@param 	fallingSwitch
			@parent 	regionWall
			@type 		switch
			@text 		∟∟switch for falling to death
			@desc 		Select a switch turned on when a character fell to death by jumpping
			@default 	0

			@param 	resistFallingAcceleration
			@parent 	regionWall
			@type 		number
			@text 		∟∟resist acceleration of falling
			@desc 		Control the power of resisting; acceleration gets faster as the power smaller
			@default 	15
			@decimals	0
			@min 		1
			@max 		99999999

			@param 	inter_regionWall
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------


	@param 	encount
	@parent 	moving
	@type 		struct<Encount>
	@text 		∟ Encount
	@desc 		Settings of encount 

			@param 	inter_encount
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	fastTravel
	@parent 	moving
	@type 		struct<FastTravel>
	@text 		∟ FastTravel
	@desc 		Settings of fastTravel

			@param 	inter_fasttravel
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	guide
	@parent 	moving
	@type 		struct<Guide>
	@text 		∟ Guide System
	@desc 		Common settings of guide system

		@param 	guideConfig
		@parent 	guide
		@type 		struct<GuideConfig>
		@text 		∟∟ Guide Popup
		@desc 		Setteings of popup for guide

		@param 	guideHUD
		@parent 	guide
		@type 		struct<GuideHUD>
		@text 		∟∟ Guide HUD
		@desc 		Settings of Guide HUD

		@param 	mainGuide
		@parent 	guide
		@type 		struct<GuideItems>[]
		@text 		∟∟ Main Guide
		@desc 		Settings of main guide
	
		@param 	subGuide
		@parent 	guide
		@type 		struct<GuideItems>[]
		@text 		∟∟ Sub Guide
		@desc 		Settings of sub guide

		@param 	mobGuide
		@parent 	guide
		@type 		struct<GuideItems>[]
		@text 		∟∟ Mob Guide
		@desc 		Settings of defeating mob guide

			@param 	inter_guide
			@parent 	moving
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	jukebox
	@parent 	moving
	@type 		struct<Jukebox>
	@text 		∟ Sound Test
	@desc 		Settings of sound test gathered from the libraries below 

	@param 	battleBgms
	@parent 	moving
	@type 		struct<BattleBgms>[]
	@text 		∟ Battle BGM
	@desc 		Settings of battle BGM

	@param 	mapBgms
	@parent 	moving
	@type 		struct<MapBgms>[]
	@text 		∟ Map BGM
	@desc 		Settings of map BGM

			@param 	mapBgmsCondition
			@parent 	mapBgms
			@type 		variable
			@text 		∟∟ Variable for Map BGM
			@desc 		Select a variable for map BGM
			@default 	0

	@param 	mapSes
	@parent 	moving
	@type 		struct<MapSes>[]
	@text 		∟ Map SE
	@desc 		Settings of map SE

			@param 	mapSesCondition
			@parent 	mapSes
			@type 		variable
			@text 		∟∟ Variable for Map SE
			@desc 		Select a variable for map SE
			@default 	0

	@param 	mapMes
	@parent 	moving
	@type 		struct<MapMes>[]
	@text 		∟ Map ME
	@desc 		Settings of map ME

			@param 	mapMesCondition
			@parent 	mapMes
			@type 		variable
			@text 		∟∟ Variable for Map ME
			@desc 		Select a variable for map ME
			@default 	0

	@param 	mapBgss
	@parent 	moving
	@type 		struct<MapBgss>[]
	@text 		∟ Map BGS
	@desc 		Settings of map BGS

			@param 	mapBgssCondition
			@parent 	mapBgss
			@type 		variable
			@text 		∟∟ Variable for Map BGS
			@desc 		Select variable for map BGS
			@default 	0


@param inter
@text 	-------------------------

@param  action
@type		select
@text		A c t i o n
@desc		Control and set up function for Action Games
@default	open or close by pushing left button
@option	open or close by pushing left button
@value		open or close by pushing left button

	@param 	actionValid
	@parent 	action
	@type 		boolean
	@text 		∟ Action Valid
	@desc 		Turn on the following settings of action system
	@default 	false

				@param 	inter_actionValid
				@parent 	action
				@type 		select
				@text 		.
				@default	---------------------------
				@option	---------------------------
				@value		---------------------------

	@param 	alternateMenuKey
	@parent 	action
	@type 		boolean
	@text 		∟alternate menu key
	@desc 		Open the menu window by pressing not escape / cancel but alt / option when this is true
	@default 	false

	@param 	restrictAction
	@parent 	action
	@type 		boolean
	@text 		∟action restricted by states
	@desc 		Unable to control player on affected by restricting states when this is true
	@default 	true

	@param 	levelupDisplay
	@parent 	action
	@type 		boolean
	@text 		∟ Display Level up
	@desc 		Stop displaying level up in a map when this is false
	@default 	false

	@param 	actionVisibleValid
	@parent 	action
	@type 		boolean
	@text 		∟ Visible Collider Valid
	@desc 		Turn on the actionVisible when this is true
	@default 	false

	@param 	actionVisible
	@parent 	action
	@type 		file
	@text 		∟ color of Visible Collider
	@desc 		Write a color name of Visible Collider; default color is red
	@default 	red

	@param 	frameRate
	@parent 	action
	@type 		number
	@text 		∟ Frame Rate
	@desc 		Setting of animation's frame rate; result is 60 / this (fps)
	@decimals 	0
	@max 		4
	@min 		1
	@default 	4

	@param 	fixDirection
	@parent 	action
	@type 		select
	@text 		∟ Fix Direction
	@desc 		Setting of fixing player's direction as scrolling shooters
	@default 	noFix

			@option default（no fixed）
			@value noFix
			
			@option horizontal type（fixed with right）
			@value scrollH

			@option vertical type（fixed with up）
			@value scrollV
			
			@option lockon type（fixed while key is pressed）
			@value lockon

	@param 	doubleInterbal
	@parent 	action
	@type 		number
	@text 		∟ Interbal for Mash
	@desc 		Setting of interbal frames for checking mash
	@default 	3
	@min 		1
	@decimals 	0

	@param 	chargeParam
	@parent 	action
	@type 		number
	@text 		∟ Shorten Charge
	@desc 		Setting of status to shorten charge frames: undeifined status shortens by the Id
	@default 	0
	@max 		19
	@decimals 	0

				@param 	inter_actionBase
				@parent 	action
				@type 		select
				@text 		.
				@default	---------------------------
				@option	---------------------------
				@value		---------------------------

	@param 	hitStop
	@parent 	action
	@type 		struct<HitStop>
	@text 		∟ Hit Stop
	@desc 		Settings of action's hit stop

				@param 	inter_hitStop
				@parent 	action
				@type 		select
				@text 		.
				@default	---------------------------
				@option	---------------------------
				@value		---------------------------

	@param 	invincible
	@parent 	action
	@type 		struct<Invincible>
	@text 		∟ Reaction to Damage
	@desc 		Settings of invincible, hit effect, and so on

				@param 	inter_invincible
				@parent 	action
				@type 		select
				@text 		.
				@default	---------------------------
				@option	---------------------------
				@value		---------------------------

	@param 	enemyActionHUD
	@parent 	action
	@type 		struct<EnemyActionHUD>
	@text 		∟ Enemy's HUD
	@desc 		Settings of HUD for Event Objects with Note Tag <enemy:n>

				@param 	inter_enemyHUD
				@parent 	action
				@type 		select
				@text 		.
				@default	---------------------------
				@option	---------------------------
				@value		---------------------------

	@param 	commands
	@parent 	action
	@type 		struct<Commands>[]
	@text 		∟ Player Commands
	@desc 		Settings of player commands in response to keys or buttons



@param inter
@text 	-------------------------

@param 	HUDcustom
@type		select
@text		H U D
@desc		Settings of player's HUD
@default	open or close by pushing left button
@option	open or close by pushing left button
@value		open or close by pushing left button

	@param 	HUDValid
	@parent 	HUDcustom
	@type 		select
	@text 		∟HUD valid
	@desc 		Select the type of introducing HUD (or goldHUD) 
	@default 	none
		@option not introdece	
		@value 	none
		@option introdece without config
		@value 	onlySystem
		@option introduce with config
		@value 	introduce

	@param 	windowHUD
	@parent 	HUDcustom
	@type 		struct<WindowHUD>
	@text 		∟ HUD Settings
	@desc 		Settings of HUD for player's status

	@param 	goldHUD
	@parent 	HUDcustom
	@type 		struct<GoldHUD>
	@text 		∟ Gold HUD
	@desc 		Settings of HUD for player's gold

	@param 	equipHUD
	@parent 	HUDcustom
	@type 		struct<EquipHUD>
	@text 		∟Equip HUD
	@desc 		Settings of HUD for player's equips and items

@param inter
@text 	-------------------------

@param 	windowCustom
@type		select
@text		W i n d o w
@desc		Control message and UI windows
@default	open or close by pushing left button
@option	open or close by pushing left button
@value		open or close by pushing left button

	@param 	windowBaseSet
	@parent 	windowCustom
	@type 		struct<WindowBaseSet>
	@text 		∟ Baseic Settings
	@desc 		Common settings of windows

	@param 	message
	@parent 	windowCustom
	@type 		struct<Message>
	@text 		∟ Message Window
	@desc 		Settings and Customizing message window

			@param 	inter_windowBase
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	mapName
	@parent 	windowCustom
	@type 		struct<MapName>
	@text 		∟ Map Name Window
	@desc 		Settings of map name window

			@param 	inter_mapName
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	debugCustom
	@parent 	windowCustom
	@type 		boolean
	@text 		∟ Debug Window
	@desc 		Introduce Item Debugger into F9 debug window when this is true
	@default 	true

			@param 	inter_debug
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	fravor
	@parent 	windowCustom
	@type 		struct<Fravor>
	@text 		∟ Fravor Text Window
	@desc 		Settings of fravor text window to deepen your world

			@param 	inter_fravor
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	itemCategory
	@parent 	windowCustom
	@type 		struct<ItemCategory>
	@text 		∟ Item Category
	@desc 		Settings of category of Items

			@param 	inter_category
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	sortWindow
	@parent 	windowCustom
	@type 		struct<SortWindow>
	@text 		∟ Sort Menu
	@desc 		Settings of sort menu for item menu

			@param 	inter_sortWindow
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	chest
	@parent 	windowCustom
	@type 		struct<Chest>
	@text 		∟ Chest and Bank
	@desc 		Settings of chest that keeps player's items

			@param 	inter_chest
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	
	@param 	statusWindow
	@parent 	windowCustom
	@type 		struct<StatusWindow>
	@text 		∟ Status Window
	@desc 		Settings of layout for status window; need "addon" in PluginParameter "statusParameter"
	
	@param 	traitCalc
	@parent 	windowCustom
	@type 		struct<TraitCalc>
	@text 		∟ Calculation Traits
	@desc 		Settings of added function for calculation traits; need "addon" in PluginParameter "statusParameter"
	
	@param 	traitsWindow
	@parent 	windowCustom
	@type 		struct<TraitsWindow>
	@text 		∟ Traits List
	@desc 		Settings of traits list added to status window; need "addon" in PluginParameter "statusParameter"

	@param 	equipWindow
	@parent 	windowCustom
	@type  	struct<EquipWindow>
	@text 		∟ Equip Window
	@desc 		Settings of customizing equip window; need "addon" in PluginParameter "statusParameter"

			@param 	inter_statusWindow
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	stepPriceShop
	@parent 	windowCustom
	@type 		struct<StepPriceShop>
	@text 		∟ StepPrice Shop
	@desc 		Setteings of shop in which good's price increase step by step

			@param 	inter_stepShop
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	shopMaterial
	@parent 	windowCustom
	@type 		boolean
	@text 		∟ Materials for Goods
	@desc 		Enable to use Note Tag <buyNeed:[]> when this is true
	@default 	true

		@param 	shopMemberOnlyCanEquip
		@parent 	shopMaterial
		@type 		boolean
		@text 		∟∟ Display Only Equippers
		@desc 		In shop's status window, display only actors enable to equip when this is true
		@default 	true

		@param 	shopStatusCustom
		@parent 	shopMaterial
		@type 		boolean
		@text 		∟∟ Displaying Equip Status
		@desc 		In shop's status window, change the way to display actor's status when this is true
		@default 	true

		@param 	statusIcons
		@parent 	shopMaterial
		@type 		number[]
		@text 		∟∟ Icons for Status
		@desc 		Settings of icons for status and damage cut rates in shop's status window
		@default 	["32","33","34","35","36","37","38","39","132","133","0","0","0","0","0","0","0","0","0","0"]
		@decimals 	0

		@param 	shopStatusTexts
		@parent 	shopMaterial
		@type 		struct<ShopStatusTexts>
		@text 		∟∟ text list for shop's status window
		@desc 		Settings of text list for displaying in shop's status window

			@param 	inter_shop
			@parent 	windowCustom
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------


	@param 	bookExtend
	@parent 	windowCustom
	@type 		struct<BookExtend>
	@text 		∟ Books
	@desc 		Settings of extending official plugins "ItemBook" "EnemyBook"

		@param 	enemyBookExtend
		@parent 	bookExtend
		@type 		struct<EnemyBookExtend>
		@text 		∟∟ details of EnemyBook
		@desc 		Settings of EnemyBook

		@param 	termBook
		@parent 	bookExtend
		@type 		struct<TermBook>[]
		@text 		∟∟ Introduce TermBook
		@desc 		Settings of book of terms

		@param 	tutorialBook
		@parent 	bookExtend
		@type 		struct<TermBook>[]
		@text 		∟∟ Introduce TutorialBook
		@desc 		Settings of book of tutorial

		@param 	tutorialDialog
		@parent 	bookExtend
		@type 		string[]
		@text 		∟∟Dialog messages of tutorial
		@desc 		Setting of the dialog
		@default 	["Finish this tutorial?","OK","Cancel"]



@param inter
@text 	-------------------------

@param 	status
@type		select
@text		S t a t u s
@desc		Customize status and elements for battle
@default	open or close by pushing left button
@option	open or close by pushing left button
@value		open or close by pushing left button


	@param 	statusParameter
	@parent 	status
	@type 		struct<StatusParameter>
	@text 		∟ Battle Parameters
	@desc 		Settings of parameters of buff, critical, and so on
	

			@param 	inter_battleCustom
			@parent 	status
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	defeat
	@parent 	status
	@type 		common_event[]
	@text 		∟ Perfomance of Enemy's Defeat
	@desc 		Settings of Common_Events for performing collapse; for default, boss, and vanish
	@default 	["0", "0", "0"]

			@param 	inter_defeat
			@parent 	status
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	states
	@parent 	status
	@type 		struct<States>
	@text 		∟ Enhance States
	@desc 		Enhance function of states

			@param 	inter_state
			@parent 	status
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	@param 	characterMake
	@parent 	status
	@type 		struct<CharacterMake>
	@text 		∟ Character Create
	@desc 		Settings of character create

			@param 	inter_charaMake
			@parent 	status
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------


	@param 	soulLevel
	@parent 	status
	@type 		struct<SoulLevel>
	@text 		∟ Stat Allocation
	@desc 		Settings of allocating stats

			@param 	inter_soulLevel
			@parent 	status
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	
	@param 	expansionBaseStatus
	@parent 	status
	@type 		struct<ExpansionBaseStatus>[]
	@text 		∟ Min and Max of status
	@desc 		Override min and max of HP, MP, ATK, DEF, MAT, MDF, SPD, and LUK

			@param 	inter_statusBase
			@parent 	status
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------

	
	@param 	expansionParam1
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟ Original Status1
	@desc 		Settings of your original status
	
	@param 	expansionParam2
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟ Original Status2
	@desc 		Settings of your original status
	
	@param 	expansionParam3
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟ Original Status3
	@desc 		Settings of your original status
	
	@param 	expansionParam4
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟ Original Status4
	@desc 		Settings of your original status
	
	@param 	expansionParam5
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟ Original Status5
	@desc 		Settings of your original status
	
	@param 	expansionParam6
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟ Original Status6
	@desc 		Settings of your original status
	
	@param 	expansionParam7
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟ Original Status7
	@desc 		Settings of your original status
	
	@param 	expansionParam8
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟ Original Status8
	@desc 		Settings of your original status
	
	@param 	expansionParam9
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟ Original Status9
	@desc 		Settings of your original status
	
	@param 	expansionParam10
	@parent 	status
	@type 		struct<ExpansionParam>
	@text 		∟ Original Status10
	@desc 		Settings of your original status

	@param endline
	@parent status
	@type 		select
	@text 		parameter end
	@desc 		In MV, you will see a parameter below this. Ignore it.
	@default	---------------------------
	@option	---------------------------
	@value		---------------------------


			@param 	inter_end
			@parent 	status
			@type 		select
			@text 		.
			@default	---------------------------
			@option	---------------------------
			@value		---------------------------


				@command speaker
				@text speaker -balloon position-
				@desc Select a speaker for whom message balloon is transfered

					@arg eventid
					@text event Id
					@desc Select the speaker's eventId
					@type number
					@default 0
					@decimals 0
					@min -1

					@arg position
					@text position of balloon
					@desc Select the position of message balloon
					@type select
					@default right
						@option upper left
						@value upperLeft
						@option upper
						@value upperCenter
						@option upper right
						@value upperRight
						@option left
						@value left
						@option center
						@value center
						@option right（default）
						@value right
						@option below left
						@value belowLeft
						@option below
						@value belowCenter
						@option below right
						@value belowRight

				
				@command growparam
				@text growParam -grow parameters-
				@desc Grow or weaken an actor's parameter
					@arg actorid
					@text actorId
					@desc When this is 0, all members is target
					@type actor
					@default 0

					@arg parameter
					@text target parameter
					@desc from 10 to 19 are for expansion parameters
					@type number
					@default 0
					@decimals 0
					@max 19

					@arg grow
					@text grow point
					@desc Control the point
					@type number
					@default 0
					@decimals 0
					@max 99999999
					@min -99999999


				@command difficulty
				@text difficulty -control difficulty-
				@desc operate config difficulty by offset

					@arg offset
					@text offset
					@desc Control the offset
					@type number
					@decimals 1
					@default 1
					@min -10
					@max 10


				@command customizevehicle
				@text customizeVehicle -customize vehicles-
				@desc change vehicle's properties

					@arg type
					@text vehicle type
					@desc Write a vehicle type to customize
					@type string

					@arg parts
					@text custom parts
					@desc Select a property to customize
					@type select
					@default altitude
						@option 飛翔高度
						@value altitude
						@option 移動速度
						@value speed
						@option 可動領域
						@value passable
						@option エンカウント
						@value encount
						@option ダメージ床
						@value damagefloor
						@option 滑る床
						@value noslip
						@option 見た目
						@value body
						@option プレイヤープライオリティ
						@value priority

					@arg value
					@text value
					@desc Write an ability to customize
					@type string

					@arg index
					@text file index
					@desc Select an index in vehicle's image file
					@type number
					@decimals 0
					@default 0
					@max 7


				@command vehiclelocation
				@text vehicleLocation -set location of a vehicle-
				@desc Change location of a vehicle, you can choose it from original ones

					@arg type
					@text vehicle type
					@desc Write a vehicle type of your target
					@type string

					@arg direct
					@text the way to locate
					@desc Select 0 or 1; by coordinate or by varialbes
					@type number
					@decimals 0
					@default 0
					@max 1

					@arg mapid
					@text map Id
					@desc Select a map ID of destination or a variable ID for it
					@type number
					@decimals 0
					@default 0

					@arg x
					@text X coordinate
					@desc Select a X coorinate of destination or a variable ID for it
					@type number
					@decimals 0
					@default 0

					@arg y
					@text Y coordinate
					@desc Select a Y coordinate of destination or a variable ID for it
					@type number
					@decimals 0
					@default 0


				@command sealacce
				@text sealAcce -control accessory's slot-
				@desc Seal or Release the slot

					@arg seal
					@text execute
					@desc Select seal or release
					@type select
					@default s
						@option seal
						@value s
						@option release
						@value r

					@arg actorid
					@text actor Id
					@desc Select an actor; when 0, all actors is the target
					@type actor
					@default 0

				
				@command forceencount
				@text forceEncount -force encount-
				@desc Force encount

				
				@command equipbattle
				@text equipBattle -equip change in battle-
				@desc Call equip scene in battle

				@command exchangeequips
				@text exchangeEquips -exchange equips for sub-
				@desc Exchange equips; need slotId only when equipable parts is "Weapon and Shield; exchanging separately"
					
					@arg actorid
					@text 		actor ID
					@desc 		Control actor's ID; 0 for Leader, -1 for Subject in battle
					@type 		number
					@decimals 	0
					@default 	0
					@min 		-1

					@arg slotid
					@text 		slotID to exchange
					@desc 		Select weapon or shield to exchange equips; 0 for weapon, 1 for shield
					@type 		number
					@decimals 	0
					@default 	0
					@max 		1


				@command endgameover
				@text endGameover -game over finished-
				@desc Tell this engine the game over is over


				@command trophy
				@text trophy -manage achievements-
				@desc Update achievements

					@arg id
					@text achievement Id
					@desc Select an achievement Id
					@type number
					@decimals 0
					@default 1
					@min 1

					@arg reset
					@text what to do
					@desc Select gain or reset achievement's condition
					@type select
					@default gain
						@option gain
						@value gain
						@option reset
						@value reset


				@command multiparty
				@text multiParty -manage multi parties-
				@desc Manage multi parties

					@arg exe
					@text what to do
					@desc Select an execution
					@type select
					@default party
						@option change the number of parties
						@value party
						@option change inherit or no-inherit party edit
						@value inherit
						@option change add or not command to menu
						@value addmenu
						@option reset reserve members
						@value resetreserve
						@option open scene to edit parties
						@value open
						@option swap parties
						@value swap

					@arg value
					@text argument
					@desc Write true or false or number of party Id
					@type string


				@command stepshop
				@text stepShop -step price shop-
				@desc Open the step price shop

					@arg sellok
					@text sell ok
					@desc when true, the shop accept sell command
					@type boolean
					@default false


				@command cswitch
				@text cSwitch -manage common switches-
				@desc Manage common switches

					@arg exe
					@text what to do
					@desc Select an execution
					@type select
					@default set
						@option update a common switch
						@value set
						@option get a common switch's properties
						@value read
						@option reset all common switches
						@value init

					@arg id
					@text switch Id
					@desc Select a target's Id
					@type number
					@decimals 0
					@default 0

					@arg value
					@text argument
					@desc Write on, off, name, flag, or correct text
					@type string
					@default on


				@command door
				@text door -door action-
				@desc Open or close a door

					@arg exe
					@text action
					@desc Select open or close
					@type select
					@default open
					 @option open
					 @value open
					 @option close
					 @value close

					@arg weight
					@text door's weight
					@desc Select the door's weight
					@type select
					@default light
						@option light door
						@value light
						@option heavy door
						@value heavy

					@arg targetid
					@text event Id
					@desc Select the door's Id; when 0, this event is the target
					@type number
					@decimals 0
					@default 0


				@command autoopacity
				@text autoOpacity -change opacity by self-
				@desc Change character's opacity by itself

					@arg id
					@text characterId
					@desc Select a number of characterId; -1 for player, 0 for this event
					@type number
					@decimals 0
					@min 	-1
					@default 0

					@arg start
					@text start opacity
					@desc Set a number for it between 0 and 255
					@type number
					@decimals 0
					@max 	255
					@default 255

					@arg end
					@text end opacity
					@desc Set a number for it between 0 and 255
					@type number
					@decimals 0
					@max 	255
					@default 0

					@arg offset
					@text offset
					@desc Set a number for it between 0 and 255
					@type number
					@decimals 0
					@max 	255
					@default 30

					@arg wait
					@text wait frames
					@desc Set a number for it
					@type number
					@decimals 0
					@default 3


				@command autojump
				@text autoJump -auto jump-
				@desc Jump by character's direction

					@arg id
					@text characterId
					@desc Select a number of characterId; -1 for player, 0 for this event
					@type number
					@decimals 0
					@min 	-1
					@default 0

					@arg x
					@text distance along x axis
					@desc Set a number for it based on down direction
					@type number
					@decimals 0
					@default 0

					@arg y
					@text distance along y axis
					@desc Set a number for it based on down direction
					@type number
					@decimals 0
					@default 0

					@arg dirfix
					@text direction fix
					@desc Fix direction in jummping when this is true
					@type boolean
					@default true

					@arg jumpType
					@text type of jump
					@desc Select how to jump
					@type select
					@default step
						@option Step ,colliding with impassable tiles
						@value step
						@option Ride, over the tiles excepted wall or sea
						@value ride
						@option Fall, move to ground tiles when landed on wall
						@value fall
						@option Climb, enable to land on wall
						@value climb


				@command timer
				@text 	timer -control timer-
				@desc 	Control timer

					@arg 	exe
					@text 	what to do
					@desc 	Select an execution
					@type 	select
					@default add
						@option extend time by "second"
						@value 	add
						@option shorten time by "second"
						@value 	reduce
						@option pause time
						@value 	pause
						@option restart time
						@value 	restart

					@arg 	second
					@text 	seconds
					@desc 	Control the time to extend or shorten
					@type 	number
					@default 0
					@decimals 0


				@command jukebox
				@text jukebox -open sound test-
				@desc Call a scene of sound test


				@command fasttravel
				@text fasttravel -manage fast travel-
				@desc Manage fast travel

					@arg exe
					@text what to do
					@desc Select an execution
					@type select
					@default call
						@option call a scene of fast travel
						@value call
						@option release base camp
						@value base
						@option release a target camp
						@value release
						@option seal a target camp
						@value seal
						@option seal a target camp temporarily
						@value sealtemp
						@option unlock the temporary sealing
						@value releasetemp
						@option release all camps
						@value all
						@option change a target camp's name
						@value name
						@option change a target camp's image
						@value img
						@option change base's name in the variable
						@value rename

					@arg areaid
					@text area Id
					@desc Select the target's area Id
					@type number
					@decimals 0
					@default 1

					@arg regionid
					@text camp Id
					@desc Select the target's camp Id
					@type number
					@decimals 0
					@default 0

					@arg name
					@text new name
					@desc Write a new name of camp or camp's image file
					@type string


				@command partyrespawn
				@text partyRespawn -update party's respawn-
				@desc Update party's respawn point

					@arg mapid
					@text mapId
					@desc Set the map ID of the new resawn point
					@type number
					@default 0
					@decimals 0

					@arg x
					@text map x coordinate
					@desc Set the map X of the new respawn point
					@type number
					@default 0
					@decimals 0

					@arg y
					@text map Y coordinate
					@desc Set the map Y of the new respawn point
					@type number
					@default 0
					@decimals 0


				@command transfer
				@text transfer -auto transfer-
				@desc Execute fast travel or deathzoom

					@arg exe
					@text what to do
					@desc Select an execution
					@type select
					@default fasttravel
						@option fast travel
						@value fasttravel
						@option deathzoom
						@value deathzoom


				@command originalfade
				@text originalFade -original fade-
				@desc Execute FadeOut/In or WhiteOut/In

					@arg exe
					@text fade out or in
					@desc Select fade out or in
					@type select
					@default out
						@option FadeOut
						@value  out
						@option FadeIn
						@value  in

					@arg duration
					@text duration for fade
					@desc Control the duration; when -1, default duration used
					@type number
					@default 30
					@decimals 0
					@min -1
					@max 9999

					@arg wait
					@text wait
					@desc When you select 'Wait', you'll keep next command until fade ends 
					@type select
					@default wait
						@option Wait
						@value  wait
						@option Go
						@value  go

					@arg white
					@text turn white
					@desc When you select 'White', you'll turn the color of fade screen white
					@type select
					@default black
						@option White
						@value  white
						@option Black
						@value  black


				@command guide
				@text guide -manage guide-
				@desc Manage guide system

					@arg target
					@text target guide
					@desc Select a target to manage
					@type select
					@default main
						@option main guide
						@value main
						@option sub guide
						@value sub
						@option mob guide
						@value mob

					@arg id
					@text guide Id
					@desc Select a guide's Id
					@type number
					@decimals 0
					@default 1
					@min 1

					@arg exe
					@text what to do
					@desc Select an exection
					@type select
					@default show
						@option start the guide
						@value start
						@option gain the guide
						@value gain
						@option gain the guide when conditions are cleared
						@value autogain
						@otion change displayed guide
						@value show


				@command charamake
				@text charaMake -open character create-
				@desc Call a scene of character create


				@command chest
				@text chest -open chest-
				@desc Call a scene of the chest

					@arg chestid
					@text chest Id
					@desc Select a chest Id
					@type number
					@decimals 0
					@default 0


				@command bank
				@text bank -open bank-
				@desc Call a scene of the bank

					@arg bankid
					@text bank Id
					@desc Select a bank Id
					@type number
					@decimals 0
					@default 0


				@command allocate
				@text allocate -open allocation-
				@desc Call a scene of stats allocation

					@arg id
					@text actor Id
					@desc Select an actor; when 0, leader is the target
					@type actor
					@default 0


				@command resetallocate
				@text resetAllocate -reset allocation-
				@desc Reset all stats allocation

					@arg id
					@text actor Id
					@desc Select an actor; when 0, leader is the target
					@type actor
					@default 0


				@command stopwarning
				@text stopWarning -stop the warning-
				@desc Stop an event enemy's warning

					@arg id
					@text event Id
					@desc Select an event Id; when 0, this event is the target
					@type number
					@decimals 0
					@default 0

				@command stopcaution
				@text stopCaution -stop the caution-
				@desc Stop an event enemy's caution

					@arg id
					@text event Id
					@desc Select an event Id; when 0, this event is the target
					@type number
					@decimals 0
					@default 0

				@command stopwc
				@text stopWC -stop the warning and caution-
				@desc Stop an event enemy's warning and caution

					@arg id
					@text event Id
					@desc Select an event Id; when 0, this event is the target
					@type number
					@decimals 0
					@default 0


				@command actionend
				@text  actionEnd -complete action-
				@desc Tell this engine an action has finished


				@command action
				@text action -display custom animations-
				@desc Display the animation linked to skills

					@arg targetid
					@text target character
					@desc Select an event Id; 0 for this event, -1 for player
					@type number
					@decimals 0
					@default 0
					@min -1

					@arg animeid
					@text animation Id
					@desc Select an animation to display
					@type animation
					@default 0

					@arg origin
					@text control origin
					@desc Control the animation's origin
					@type number
					@decimals 1
					@default 0
					@min -6

					@arg turn
					@text animation's rotation
					@desc Select a type of rotation along character's direction
					@type select
					@default 0
						@option no rotation
						@value 0
						@option only position
						@value 1
						@option only rotation angle
						@value 2
						@option both position and angle
						@value 3

					@arg skillid
					@text skill Id
					@desc Select a skill linked to this animation
					@type skill
					@default 0

					@arg hiteffid
					@text hit effect
					@desc Select an animation displayed on hit
					@type animation
					@default 0

					@arg isPlayer
					@text 	player's action
					@desc 	Select which the subject of this action is player or not
					@type 	boolean
					@default false

					@arg wait
					@text 	wait for ending animation
					@desc 	Select to wait or not for ending animation
					@type 	boolean
					@default false

				@command shortcutitem
				@text shortcutItem -use shortcut item-
				@desc Use the shortcut item; needs action valid and item HUD

				@command nextshortcutitem
				@text nextShortcutItem -next shortcut item-
				@desc set next item as shortcut; needs action valid and item HUD

				@command previousshortcutitem
				@text previousShortcutItem -previous shortcut item-
				@desc set previous item as shortcut; needs action valid and item HUD

				@command lockon
				@text lockon -lock on-
				@desc Control direction fix by lock on

					@arg exe
					@text what to do
					@desc Select an execution
					@type select
					@default on
						@option set lock on
						@value on
						@option remove lock on
						@value off
						@option turn the condition
						@value auto


				@command evasion
				@text evasion -guard action-
				@desc Set deffencive action

					@arg target
					@text event Id
					@desc Select an event Id; 0 for this event, -1 for player
					@type number
					@decimals 0
					@default 0
					@min -1

					@arg act
					@text action type
					@desc Select an type of deffence
					@type select
					@default eva
						@option evasion
						@value eva
						@option damage cut
						@value grd
						@option remove guard
						@value rem
						@option set parry
						@value parry
						@option set parry to deflect
						@value deflect

					@arg justActionSwitch
					@text 	switch on just action
					@desc 	Select a switch turned on when character succeeds just action
					@type 	switch
					@default 	0


				@command defeat
				@text defeat -defeat animation-
				@desc Set an animation of defeated enemies

					@arg animeid
					@text animation Id
					@desc Select an animation
					@type animation
					@default 0

					@arg selfswitch
					@text self switch
					@desc Select one; switched at defeated
					@type select
						@option D
						@value D
						@option C
						@value C
						@option B
						@value B
						@option A
						@value A


				@command defeatend
				@text defeatEnd -finish performance-
				@desc Tell this engine the defeat in battle scene has finished


				@command rewards
				@text rewards -get rewards or get items for non-battle rewards -
				@desc Get rewards an event enemy has

					@arg displaypopup
					@text display on popup
					@desc Display item name on popup when this is true
					@type boolean
					@default false

					@arg itemtype
					@text item type
					@desc Select a type of the item below: get ID (non-battle rewards)
					@type select
					@default item
						@option Item
						@value item
						@option Weapon
						@value weapon
						@option Armor
						@value armor
						@option Variable
						@value variable

					@arg getid
					@text get ID
					@desc Control ID of the item; when itemType is Variable, 10000s for weapons, 20000s for armors (non-battle rewards)
					@type number
					@decimals 0
					@min 0
					@max 1000
					@default 0

					@arg amouont
					@text amount
					@desc Control variable ID for the amount of gotten item, when this is 0, amount is 1 (non-battle rewards)
					@type number
					@decimals 0
					@min 0
					@max 99999999
					@default 1


				@command respawn
				@text respawn -respawn-
				@desc Respawn event objects

					@arg targetid
					@text target
					@desc Write a number of event Id, otherwise string of map or all
					@type string
					@default 0


				@command bosshpbar
				@text bossHpBar -show boss's HP gauge-
				@desc Call the HP gauge in map

					@arg show
					@text show or hide
					@desc Select the gauge's visible
					@type select
					@default show
						@option show
						@value show
						@option hide
						@value hide

					@arg id
					@text target
					@desc Write a number of event Id, or a string of all
					@type string
					@default all


				@command termbook
				@text TermBook -manage the term book-
				@desc Manage the term book

					@arg exe
					@text what to do
					@desc Select an execution
					@type select
					@default add
						@option add or gain a term
						@value add
						@option complete the book
						@value comp

					@arg category
					@text category Id
					@desc Select the category Id of the term
					@type number
					@decimals 0
					@default 1
					@min 1

					@arg id
					@text term Id
					@desc Select the term's Id
					@type number
					@decimals 0
					@default 1
					@min 1


				@command tutorialbook
				@text TutorialBook -manage the tutorial book-
				@desc Manage the tutorial book

					@arg exe
					@text what to do
					@desc Select an execution
					@type select
					@default add
						@option add or gain the tutorial
						@value add
						@option complete the book
						@value comp

					@arg category
					@text category Id
					@desc Select the category Id of the term
					@type number
					@decimals 0
					@default 1
					@min 1

					@arg id
					@text tutorial Id
					@desc Select the tutorial's Id
					@type number
					@decimals 0
					@default 1
					@min 1


				@command getallitems
				@text 	getAllItems -get each items, weapons, and armors-
				@desc 	Get each items, weapons, and armors
				
					@arg num
					@text amount
					@desc Control amount of each items
					@type number
					@decimals 0
					@default 1
					@min 1
					@max 99


				@command weaponchoice
				@text 	weaponChoice -choice system for weapons-
				@desc 	Change item choice to weapon choice


				@command armorchoice
				@text 	armorChoice -choice system for armors-
				@desc 	Change item choice to armor choice


				@command resetchoice
				@text 	resetChoice -choice system for items-
				@desc 	Reset item choice from weapon or armor choice

			
				@command operate
				@text operate -operate parameters of MELOS Engine-
				@desc Operate some Plugin Parameters

					@arg what
					@text what to do
					@desc Select an operation
					@type select
					@default balloon
						@option change balloon's switch
						@value balloon
						@option Set stride
						@value stride
						@option override an event's search help
						@value searchHelp
						@option change the fixed leader
						@value leader
						@option change a shop's name
						@value shopName

					@arg argument
					@text argument
					@desc refer to readme
					@type string
*/
/*-----------------------------------------------------------------------------*/


/**********************************************************************************************/
/*-------------------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------------------*/
/*********************************************************************************************/
var $dataFravorsItem  = null;
var $dataFravorsSkill = null;
var $gameStepPrice = null;
var $gameChests = null;
var $gameChest = null;
var $gameParty1 = null;
var $gameParty2 = null;
var $gameParty3 = null;
var $gameParty4 = null;
var $gameParty5 = null;
var $gameReserveParty = null;
var $gameFastTravel = null;
var $gameGuide = null;
var $gameCS = null;
var $gameJukebox = null;
var $gameReserveRespawn = [];
var commonSwitches = [{"name":'none', "flag":false}];
var commonSwitchesForInit = [{"name":'none', "flag":false}];

(()=>{
'use strict';

/********************************************************************************************/
/*--------------prepare--------------------------------------------
							事前準備
  --------------------------------------------------------------*/
/********************************************************************************************/

/*--------------------------------------------------------------------------
		プラグインコマンドの名前を定義＋小文字化
--------------------------------------------------------------------------*/

let plugin_speakerPosition = 'speaker';
	plugin_speakerPosition = plugin_speakerPosition.toLowerCase();

let plugin_growParameter = 'growParam';
	plugin_growParameter = plugin_growParameter.toLowerCase();

let plugin_difficulty = 'difficulty';
	plugin_difficulty = plugin_difficulty.toLowerCase();

let plugin_customizeVehicle = 'customizeVehicle';
	plugin_customizeVehicle = plugin_customizeVehicle.toLowerCase();

let plugin_vehicleLocation = 'vehicleLocation';
	plugin_vehicleLocation = plugin_vehicleLocation.toLowerCase();

let plugin_sealAcce = 'sealAcce';
	plugin_sealAcce = plugin_sealAcce.toLowerCase();

let plugin_endGO = 'endGameover';
	plugin_endGO = plugin_endGO.toLowerCase();

let plugin_multiParty = 'multiParty';
	plugin_multiParty = plugin_multiParty.toLowerCase();

let plugin_stepPrice = 'stepShop';
	plugin_stepPrice = plugin_stepPrice.toLowerCase();

let plugin_door = 'door';
	plugin_door = plugin_door.toLowerCase();

let plugin_autoOpacity = 'autoOpacity';
	plugin_autoOpacity = plugin_autoOpacity.toLowerCase();

let plugin_autoJump = 'autoJump';
	plugin_autoJump = plugin_autoJump.toLowerCase();

let plugin_timer = 'timer';
	plugin_timer = plugin_timer.toLowerCase();

let plugin_jukebox = 'jukebox';
	plugin_jukebox = plugin_jukebox.toLowerCase();

let plugin_fastTravel = 'fasttravel';
	plugin_fastTravel = plugin_fastTravel.toLowerCase();

let plugin_partyRespawn = 'partyRespawn';
	plugin_partyRespawn = plugin_partyRespawn.toLowerCase();

let plugin_transfer = 'transfer';
	plugin_transfer = plugin_transfer.toLowerCase();

let plugin_originalFade = 'originalFade';
	plugin_originalFade = plugin_originalFade.toLowerCase();

let plugin_guide = 'guide';
	plugin_guide = plugin_guide.toLowerCase();

let plugin_characterMake = 'charaMake';
	plugin_characterMake = plugin_characterMake.toLowerCase();

let plugin_callChest = 'chest';
	plugin_callChest = plugin_callChest.toLowerCase();

let plugin_callBank = 'bank';
	plugin_callBank = plugin_callBank.toLowerCase();

let plugin_allocate = 'allocate';
	plugin_allocate = plugin_allocate.toLowerCase();

let plugin_resetAllocate = 'resetAllocate';
	plugin_resetAllocate = plugin_resetAllocate.toLowerCase();

let plugin_forceEncount = 'forceEncount';
	plugin_forceEncount = plugin_forceEncount.toLowerCase();

let plugin_equipBattle = 'equipBattle';
	plugin_equipBattle = plugin_equipBattle.toLowerCase();

let plugin_exchangeEquips = 'exchangeEquips';
	plugin_exchangeEquips = plugin_exchangeEquips.toLowerCase();

let plugin_stopWarning = 'stopWarning';
	plugin_stopWarning = plugin_stopWarning.toLowerCase();

let plugin_stopCaution = 'stopCaution';
	plugin_stopCaution = plugin_stopCaution.toLowerCase();

let plugin_stopWC = 'stopWC';
	plugin_stopWC = plugin_stopWC.toLowerCase();

let plugin_actionEnd = 'actionEnd';
	plugin_actionEnd = plugin_actionEnd.toLowerCase();

let plugin_actionPlay = 'action';
	plugin_actionPlay = plugin_actionPlay.toLowerCase();

let plugin_lockonPlay = 'lockon';
	plugin_lockonPlay = plugin_lockonPlay.toLowerCase();

let plugin_evasionPlay = 'evasion';
	plugin_evasionPlay = plugin_evasionPlay.toLowerCase();

let plugin_shortcutItemPlay = 'shortcutItem';
	plugin_shortcutItemPlay = plugin_shortcutItemPlay.toLowerCase();

let plugin_nextShortcutItemPlay = 'nextShortcutItem';
	plugin_nextShortcutItemPlay = plugin_nextShortcutItemPlay.toLowerCase();

let plugin_previousShortcutItemPlay = 'previousShortcutItem';
	plugin_previousShortcutItemPlay = plugin_previousShortcutItemPlay.toLowerCase();

let plugin_defeat = 'defeat';
	plugin_defeat = plugin_defeat.toLowerCase();

let plugin_defeatEnd = 'defeatEnd';
	plugin_defeatEnd = plugin_defeatEnd.toLowerCase();

let plugin_respawn = 'respawn';
	plugin_respawn = plugin_respawn.toLowerCase();

let plugin_getRewards = 'rewards';
	plugin_getRewards = plugin_getRewards.toLowerCase();

let plugin_bossHpBar = 'bossHpBar';
	plugin_bossHpBar = plugin_bossHpBar.toLowerCase();

let plugin_trophy = 'trophy';
	plugin_trophy = plugin_trophy.toLowerCase();

let plugin_commonSwitch = 'cSwitch';
	plugin_commonSwitch = plugin_commonSwitch.toLowerCase();

let plugin_termbook = 'TermBook';
	plugin_termbook = plugin_termbook.toLowerCase();

let plugin_tutorialbook = 'TutorialBook';
	plugin_tutorialbook = plugin_tutorialbook.toLowerCase();

let plugin_getAllItems = 'getAllItems';
	plugin_getAllItems = plugin_getAllItems.toLowerCase();

let plugin_weaponChoice = 'weaponChoice';
	plugin_weaponChoice = plugin_weaponChoice.toLowerCase();

let plugin_armorChoice = 'armorChoice';
	plugin_armorChoice = plugin_armorChoice.toLowerCase();

let plugin_resetChoice = 'resetChoice';
	plugin_resetChoice = plugin_resetChoice.toLowerCase();

let plugin_operate = 'operate';
	plugin_operate = plugin_operate.toLowerCase();
/*********************************************************************************************************************/

/*-----------------------------------------------------------------------
		必要な情報を取得・定義。このプラグインにおける局地的グローバル変数化
		プラグインコマンドからも各設定を取得できるように、スコープ範囲を拡張。
-----------------------------------------------------------------------*/

const params = PluginManager.parameters('melosengine');
const RPGMAKER = Utils.RPGMAKER_NAME;
console.log('RPGMAKER: ', RPGMAKER);
const MV = RPGMAKER === 'MV';
const MZ = RPGMAKER === 'MZ';

/*------------------------------------------------------*/
//デバッグ用のアンカーファンクション
const OK = function(flag){console.log(flag ? `ok:${flag}` : 'ok')}; 

const OKALERT = function(flag){window.alert(flag ? `ok:${flag}` : 'ok')};

const consolerValid = params.consoler === 'true';
const consoler = function(name, obj, obj2){
	if(consolerValid){
		if(obj2){
			console.log(name, obj, obj2);	
		}else{
			console.log(name, obj);
		}
	}
};//*

/*------------------------------------------------------*/
//WindowsかMacかを判定するファンクション
const isWindows = function(){
	return  navigator.platform.includes('Win');
};//*

const isMac = function(){
	return navigator.platform.includes('Mac');
};//*

/*---------------------------------------------------------*/
//通行判定をチェックする上で、４ビットの数値に対して１が立っている個数を算出するファンクション
//numは事前に0~15までの値に変換済なのを想定
const bitCounter = function(num){
	const M = Math.floor(num / 4);
	const m = num % 4;
	return ( M - (M >> 1) ) + ( m - (m >> 1) );
};//*

/*-----------------------------------------------------------------------*/
//文字型・文字数値型が混在する構造体、オブジェクトに対して適切な型変換を行うファンクション
const stringToNumber = function(object){
			let keys = Object.keys(object);
								
			for(var i = 0; i < keys.length; i++){
				let value = object[keys[i]];
				if(typeof value === 'string' && value){
					value = value.match(/^[0-9]*$/) ? Number(value) : value ;	
				}
				object[keys[i]] = value;
			}
			return object;
};//* 

//文字型のブーリアンを持つ構造体、オブジェクトに対して適切な型変換を行うファンクション
const stringToBoolean = function(object){
			let keys = Object.keys(object);

			for(var i = 0; i < keys.length; i++){
				let value = object[keys[i]];
				switch(value){
					case 'true' : value = true;  break;
					case 'false': value = false; break;
				}
				object[keys[i]] = value;
			}
			return object;
};//*

//構造体が未設定の場合、強制的に有効化をOffにするファンクション
const makeNotValid = function(){
	return {"valid"			: false,
			"type" 			: 'none',
			"addon"			: false,
			"busy" 			: false,
			"configValid"	: false,
			"goldValid" 	: false,
			"party" 		: 1,
			"area" 			: [],
			"variableId" 	: 0,
			"exeTravel" 	: 0};
};//*

const makeInvalidTerm = function(){
	return 'Invalid !';
};//*

//未定義かつ必須のストラクトを解析し、漏れがあれば出力するファンクション
const parseJSONwithLeakcheck = function(obj, consolerName){
	if(obj){
		return JSON.parse(obj);
	}else{
		console.warn(consolerName + ' Leaked Struct!');
		return [];
	}
};//*

/*---------------------------------------------------------------------------*/
//ゲームパッドの接続状況に応じてキー名を返すファンクション

	/*~struct~KeyPad:ja
		@param enter
		@type 	struct<KeyPadNames>
		@text 	エンターキー(Z)
		@desc 	エンターキーとして表示するキー名およびゲームパッド名を設定します。未設定の場合、MELOS仕様になります。

		@param cancel
		@type 	struct<KeyPadNames>
		@text 	キャンセルキー(X)
		@desc 	キャンセルキーとして表示するキー名およびゲームパッド名を設定します。未設定の場合、MELOS仕様になります。

		@param shift
		@type 	struct<KeyPadNames>
		@text 	Shiftキー(shift)
		@desc 	Shiftキーとして表示するキー名およびゲームパッド名を設定します。未設定の場合、MELOS仕様になります。

		@param menu
		@type 	struct<KeyPadNames>
		@text 	メニューキー(menu)
		@desc 	メニューキーとして表示するキー名およびゲームパッド名を設定します。未設定の場合、MELOS仕様になります。

		@param direction
		@type 	struct<KeyPadNames>
		@text 	方向キー（↑ ↓ ← →）
		@desc 	方向キーとして表示するキー名およびゲームパッド名を設定します。未設定の場合、MELOS仕様になります。

		@param upDown
		@type 	struct<KeyPadNames>
		@text 	上下方向キー（↑ ↓）
		@desc 	上下方向キーとして表示するキー名およびゲームパッド名を設定します。未設定の場合、MELOS仕様になります。

		@param leftRight
		@type 	struct<KeyPadNames>
		@text 	左右方向キー（←　→）
		@desc 	左右方向キーとして表示するキー名およびゲームパッド名を設定します。未設定の場合、MELOS仕様になります。

		@param up
		@type 	struct<KeyPadNames>
		@text 	上方向キー（↑）
		@desc 	上方向キーとして表示するキー名およびゲームパッド名を設定します。未設定の場合、MELOS仕様になります。

		@param down
		@type 	struct<KeyPadNames>
		@text 	下方向キー（↓）
		@desc 	下方向キーとして表示するキー名およびゲームパッド名を設定します。未設定の場合、MELOS仕様になります。

		@param left
		@type 	struct<KeyPadNames>
		@text 	左方向キー（←）
		@desc 	左方向キーとして表示するキー名およびゲームパッド名を設定します。未設定の場合、MELOS仕様になります。

		@param right
		@type 	struct<KeyPadNames>
		@text 	右方向キー（→）
		@desc 	右方向キーとして表示するキー名およびゲームパッド名を設定します。未設定の場合、MELOS仕様になります。

		@param scroll
		@type 	struct<KeyPadNames>
		@text 	スクロールキー（Q W）
		@desc 	スクロールキーとして表示するキー名およびゲームパッド名を設定します。未設定の場合、MELOS仕様になります。

		@param pageup
		@type 	struct<KeyPadNames>
		@text 	左スクロールキー（Q）
		@desc 	左スクロールキーとして表示するキー名およびゲームパッド名を設定します。未設定の場合、MELOS仕様になります。

		@param pagedown
		@type 	struct<KeyPadNames>
		@text 	右スクロールキー（W）
		@desc 	右スクロールキーとして表示するキー名およびゲームパッド名を設定します。未設定の場合、MELOS仕様になります。
	*/
	/*-------------------------------------*/
	/*~struct~KeyPad:
		@param enter
		@type 	struct<KeyPadNames>
		@text 	Enter Key(Z)
		@desc 	Set names of enter key. When names are undefined, MELOS will fill the empty names.

		@param cancel
		@type 	struct<KeyPadNames>
		@text 	Cancel Key(X)
		@desc 	Set names of cancel key. When names are undefined, MELOS will fill the empty names.

		@param shift
		@type 	struct<KeyPadNames>
		@text 	Shift Key(shift)
		@desc 	Set names of shift key. When names are undefined, MELOS will fill the empty names.

		@param menu
		@type 	struct<KeyPadNames>
		@text 	Menu Key(menu)
		@desc 	Set names of menu key. When names are undefined, MELOS will fill the empty names.

		@param direction
		@type 	struct<KeyPadNames>
		@text 	Direction Key（↑ ↓ ← →）
		@desc 	Set names of direction key. When names are undefined, MELOS will fill the empty names.

		@param upDown
		@type 	struct<KeyPadNames>
		@text 	UpDown Key（↑ ↓）
		@desc 	Set names of upDown key. When names are undefined, MELOS will fill the empty names.

		@param leftRight
		@type 	struct<KeyPadNames>
		@text 	LeftRight Key（←　→）
		@desc 	Set names of leftRight key. When names are undefined, MELOS will fill the empty names.

		@param up
		@type 	struct<KeyPadNames>
		@text 	Up Key（↑）
		@desc 	Set names of up key. When names are undefined, MELOS will fill the empty names.

		@param down
		@type 	struct<KeyPadNames>
		@text 	Down Key（↓）
		@desc 	Set names of down key. When names are undefined, MELOS will fill the empty names.

		@param left
		@type 	struct<KeyPadNames>
		@text 	Left Key（←）
		@desc 	Set names of left key. When names are undefined, MELOS will fill the empty names.

		@param right
		@type 	struct<KeyPadNames>
		@text 	Right Key（→）
		@desc 	Set names of right key. When names are undefined, MELOS will fill the empty names.

		@param scroll
		@type 	struct<KeyPadNames>
		@text 	Scroll Key（Q W）
		@desc 	Set names of scroll key. When names are undefined, MELOS will fill the empty names.

		@param pageup
		@type 	struct<KeyPadNames>
		@text 	Pageup Key（Q）
		@desc 	Set names of pageup key. When names are undefined, MELOS will fill the empty names.

		@param pagedown
		@type 	struct<KeyPadNames>
		@text 	Pagedown（W）
		@desc 	Set names of pagedown key. When names are undefined, MELOS will fill the empty names.
	*/


	/*~struct~KeyPadNames:ja
		@param keyName
		@type 	string
		@text 	キー名
		@desc 	キーボードでのキーの名前を設定します。
		@default ？？？キー

		@param buttonName
		@type 	string
		@text 	ボタン名
		@desc 	ゲームパッドでのボタンの名前を設定します。
		@default ？？？ボタン
	*/
	/*-------------------------------------*/
	/*~struct~KeyPadNames:
		@param keyName
		@type 	string
		@text 	name of key
		@desc 	Write the name for keybord
		@default ？？？Key

		@param buttonName
		@type 	string
		@text 	name of button
		@desc 	Write the name for gamepad
		@default ？？？Button
	*/

	const parseKeyPad = s => JSON.parse(s, (key, value) => {
			switch(key){
				case 'enterKey' : return value;
				default 		: return value;
			};
		});//*

	const parseKeyPadNames = s => JSON.parse(s, (key, value) => {
			switch(key){
				case 'keyName' 		: return value;
				case 'buttonName' 	: return value;
				default 		: return value;
			};
		});//*

	let keyPad = params.keyPad;
	let consolerNameKeyPad = 'keyPad:';
	if(keyPad){
		keyPad = parseKeyPad(keyPad);
		const keys = Object.keys(keyPad);
		keys.forEach(name => {
			keyPad[name] = keyPad[name] ? parseKeyPadNames(keyPad[name]) :
								{"keyName": 'defaultName', "buttonName": 'defaultName'};
		});

		keyPad.valid = true;
	}else{
		keyPad = {};
		keyPad.valid = false;
	};
			
	consoler(consolerNameKeyPad, keyPad);

//引数として参照するコマンド名
const keyOfEnter 		= 'enter';
const keyOfCancel 		= 'cancel';
const keyOfShift 		= 'shift';
const keyOfMenu 		= 'menu';
const keyOfDirection 	= 'direction';
const keyOfArrowUD 		= 'upDown';
const keyOfArrowLR 		= 'leftRight';
const keyOfArrowUp		= 'up';
const keyOfArrowDown	= 'down';
const keyOfArrowLeft	= 'left';
const keyOfArrowRight	= 'right';
const keyOfScroll 		= 'scroll';
const keyOfPageUp 		= 'pageup';
const keyOfPageDown 	= 'pagedown';
const nameOfMenu 		= isMac() ? 'option' : 'alt';

const alternateMenuKey = params.alternateMenuKey === 'true';

const keyName = function(name){
	const gp = navigator.getGamepads()[0];
	const gpOk = gp && gp.connected ;
	return gpOk ? keyNameForGamePad(name) : keyNameForKeyBord(name);
};//*

const keyNameForGamePad = function(name){
	const target = keyPad[name];
	const paramOk = keyPad.valid && target && target.buttonName;
	return paramOk ? target.buttonName : keyNameForDefault(name, true);
};//*

const keyNameForKeyBord = function(name){
	const target = keyPad[name];
	const paramOk = keyPad.valid && target && target.keyName;
	return paramOk ? target.keyName : keyNameForDefault(name, false);
};//*

const keyNameForDefault = function(name, gpOk){
	switch(name){
		case keyOfEnter 		: return gpOk ? 'A' : 'Enter';	break;
		case keyOfCancel 		: return gpOk ? 'B' : 'Cancel'; break;
		case keyOfShift 		: return gpOk ? 'Y' : 'Shift'; 	break;
		case keyOfMenu 			: return gpOk ? 'X' : (alternateMenuKey ? nameOfMenu : 'Cancel'); break;
		case keyOfDirection 	: return '↑ ↓ ← →'; 			break;
		case keyOfArrowUD 		: return '↑ ↓'; 				break;
		case keyOfArrowLR 		: return '← →'; 				break;
		case keyOfArrowUp 		: return '↑'; 				break;
		case keyOfArrowDown 	: return '↓'; 				break;
		case keyOfArrowLeft 	: return '←'; 				break;
		case keyOfArrowRight 	: return '→'; 				break;
		case keyOfScroll 		: return gpOk ? 'L R' : 'Q W'; 	break;
		case keyOfPageUp 		: return gpOk ? 'L' : 'Q'; break;
		case keyOfPageDown 		: return gpOk ? 'R' : 'W'; break;
		default 				: return gpOk ? 'button' : 'key';
	}
};//*


/*-------------------------------------*/
//初期化するスイッチ群と変数群を取得する変数

			/*~struct~InitializedVariables:ja
				@param 	id
				@type 		variable
				@text 		対象の変数
				@desc 		初期値を代入したい変数を選択します。
				@default 	0

				@param 	value
				@type 		number
				@text 		変数の初期値
				@desc 		代入したい初期値を設定します。
				@default 	0
				@decimals 	0
				@max 		99999999
			*/
			/*-------------------------------------*/
			/*~struct~InitializedVariables:
				@param 	id
				@type 		variable
				@text 		target varabile
				@desc 		Select a varaible to set initial value
				@default 	0

				@param 	value
				@type 		number
				@text 		initial value
				@desc 		Control the value of the variable
				@default 	0
				@decimals 	0
				@max 		99999999
			*/

			const parseInitializedVariables = s => JSON.parse(s, (key, value) => {
				switch(key){
					case 'id' 		: return Number.parseFloat(value);
					case 'value' 	: return Number.parseFloat(value);
					default 		: return value;
				};
			});//*

	let initializedSwitches = params.initializedSwitches
	const consolerNameInitializedSwitches = 'initializedSwitches:';
	if(initializedSwitches){
		initializedSwitches = JSON.parse(initializedSwitches);
		initializedSwitches = initializedSwitches.map(sw => {return Number(sw)});
	}else{
		initializedSwitches = [];
	};

	consoler(consolerNameInitializedSwitches, initializedSwitches);

	let initializedVariables = params.initializedVariables;
	let consolerNameinitializedVariables = 'initializedVariables:';
	if(initializedVariables){
		initializedVariables = parseInitializedVariables(initializedVariables);
		initializedVariables = initializedVariables.map(obj => {
			obj = JSON.parse(obj);
			return stringToNumber(obj);
		});
	}else{
		initializedVariables = [];
	};
			
	consoler(consolerNameinitializedVariables, initializedVariables);



/*-------------------------------------------------------------------------------------------*/　
//HUDのコンフィグ項目追加を判定する変数
	let HUDValid = 0;  //HUDの基本的実装可否
	let HUDconfigValid = false; //ステータスHUDの実装可否
	let goldHUDValid = false; //所持金HUDの実装可否
	let equipHUDValid = false; //装備品HUDの実装可否
	let configHUD = 'HUD';
	let configHUDName = 'HUDの表示';
		switch(params.HUDValid){
			case 'none' 		: HUDValid = 0; break;
			case 'onlySystem' 	: HUDValid = 1; break;
			case 'introduce' 	: HUDValid = 2; break;
			default 			: HUDValid = 0;
		};
/*-------------------------------------*/
//装飾品の封印状況を管理する変数
	let sealingSlot; 
/*-------------------------------------*/
//特徴の計算タイプをMELOS内で使用できるようにする変数
	let traitCalcValid = false;
/*-------------------------------------*/
//乗り物拡張設定の有効状態を監視する変数
	let vehicleValid = params.vehicleValid === 'true';
/*-------------------------------------*/
//SE未設定時に付与する無音のSEオブジェクト
	const emptyBgm = {"name":'', "volume":90, "pitch":100, "pan":0, 
						 "track":-1, "title":'停止', "creator": '停止', "creatorMemo":''};
	let emptySE = {"name":'', "volume":70, "pitch":100, "pan":0};
/*-------------------------------------*/
//スタミナに関する変数
	let staminaMode = params.staminaMode === 'true';
	let staminaStatus = params.staminaStatus;
/*------------------------------------------*/
//時間の概念導入に関する変数
	let dayNightConcept = params.dayNightConcept === 'true';
/*------------------------------------------*/
//キャラメイクで名前シーンに遷移しても編集中のアクターを保存する変数
	let currentCharacterMaking = null;
/*-------------------------------------------*/
//パーティ編成でキャンセル処理の可否を判定する変数
	let cancelDistributeParty = false;
/*---------------------------------------------------------*/
//自動的に指定座標へ転送するコマンド用変数
	let travel = {"mapId": 0, "x": 0, "y": 0}; 
/*--------------------------------------------------*/
//ショップの真偽値・アイコンリストを解凍
	const shopMaterial = params.shopMaterial === 'true';
	const shopMemberOnlyCanEquip = params.shopMemberOnlyCanEquip === 'true';
	const shopStatusCustom = params.shopStatusCustom === 'true';
	const defaultIcons = ["0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0","0"]
	let statusIcons = params.statusIcons ? JSON.parse(params.statusIcons) : defaultIcons;
		statusIcons = statusIcons.map(n => {return Number(n)});
		statusIcons = statusIcons.filter((id, index) => {return index < 20});
	const statusIconOk = statusIcons.some(id => {return id !== 0});
/*--------------------------------------------------*/
//倉庫コマンドで使う倉庫ID格納変数
	let chestId = 0;
/*--------------------------------------------------*/
//オブジェクトのサーチ機能を制御するための変数
	let searchCount = 0; 
/*--------------------------------------------------*/
//装備画面で防具タイプのサブカテゴリーを判別するための変数
	let accessoryStart = 5 - 1;
/*-----------------------------------------------------------------*/
//バルーン化で使用する座標変数
	let eventFX =0;
	let eventFY =0; 
	let fukidashiX = 0;
	let fukidashiY = 0;
	let speakerChange = false; //話者プラグインコマンドの実行判定用
/*-----------------------------------------------------*/	
//アクションで無敵判定を行う際の文字型チェッカーと、アニメーションスプライトにダメージ判定を持たせるスイッチ群
	let actionValid = params.actionValid === 'true';
	let restrictActionValid = params.restrictAction === 'true';
	let actionVisibleValid = params.actionVisibleValid === 'true';
	let knock = 'knock';
	let avoid = 'avoid';
	let parry = 'parry';
	let animationDamage = true;
	let tempAnimationDamage;
/*---------------------------------------------------*/
//コンソーラーで未定義ストラクトを出力するための配列変数
	let undefinedStructs = [];


/***************************************************************************************************/

/*------enhancing----------------------------------------
					メソッド強化
---------------------------------------------------------------------*/

/*--------------------------------------------------------------*/
//変数代入ファンクションに小数を使えるよう強化
const _Game_Variables_prototype_setValue = Game_Variables.prototype.setValue;
Game_Variables.prototype.setValue = function(variableId, value, decimals) {
    if (variableId > 0 && variableId < $dataSystem.variables.length) {
        if (typeof value === 'number') {
        	if(decimals >= 1){
        		let pow = Math.pow(10, decimals);
        		value = Math.floor(value * pow)/pow;
        	}else {
        		value = Math.floor(value);
        	};
        };
        this._data[variableId] = value;
        this.onChange();
    }
};//*
/*-------------------------------------------------------*/
//パーティメンバーを全員全回復させるファンクションを追加
Game_Party.prototype.recoverAll = function(){
	const members = this.allMembers();
	members.forEach(actor => actor.recoverAll());
};//*

/*---------------------------------------------------------*/
//画面内のイベントを取得するファンクションを追加
Game_Map.prototype.screenEvents = function(){
	const originX = this.displayX();
	const originY = this.displayY();
	const widthX = originX + (Graphics.width / this.tileWidth() - 1);
	const heightY = originY + (Graphics.height / this.tileHeight() - 1);

	let events = this.events().filter(e => {
		return e.x >=originX && e.x <= widthX && e.y >= originY && e.y <= heightY
	});
	return events;
};//*

/*---------------------------------------------------------*/
//キャラクターを任意の位置に移動させるファンクションを追加
Game_CharacterBase.prototype.move = function(x, y){
	if(x){
		this.setDirection(x > 0 ? 6 : 4);
		this._x += x;
	}
	
	if(y){
		this.setDirection(y > 0 ? 2 : 8);
		this._y += y;
	}
};//*


/*--------------------------------------------------*/
//キャラクターが特定のリージョンID上にいるかを判定するファンクションを追加
Game_CharacterBase.prototype.isOnRegionId = function(id){
	return id === this.regionId();
};//*

/*-------------------------------------------------------------------*/
//キャラクター自身で大画像のキャラクターか否かを判定できるように
Game_CharacterBase.prototype.isBigCharacter = function(){
	return ImageManager.isBigCharacter(this.characterName());
};//*

/*-------------------------------------------------------------------*/
//イベントの特定セルフスイッチがOnか否かを判定するファンクション
Game_Event.prototype.isSelfSwitchOn = function(ss){
	return $gameSelfSwitches.value([this._mapId, this.eventId(), ss]) === true;
};//*

/*--------------------------------------------------*/
//アイテムの効果によるコモンイベント実行時、アイテムメニューに戻れるファンクションを追加
SceneManager.returnItemScene = function(){
	if(!$gameParty.inBattle()){
		if(this.isPreviousScene(Scene_Item) ){
			this._stack.push(Scene_Map, Scene_Menu);
			this.goto(this._previousClass);
		}
	}
};//*

/*--------------------------------------------------*/
//コスト消費に関して、自身を対象とした回復でHPやMPが満タン状態ではコストを消費しないように
Game_BattlerBase.prototype.checkVainRecover = function(item){
	//trueになるとコストの消費やスキルの使用を停止する
	const isForUser = item.scope === 11;
	const isHpRecover = item.damage.type === 3;
	const isMpRecover = item.damage.type === 4;
	if(isForUser){
		const user = $gameParty.leader();
		if(isHpRecover) return user.hp >= user.mhp;
		if(isMpRecover) return user.mp >= user.mmp;
		return false;
	}else{
		return false;
	}
};//*

/*-------------------------------------------------------*/
//SelectableクラスにShift挙動を追加。Shiftハンドラーとの連携で挙動制御。
//Menuハンドラーも同時に定義。ただし、こちらはエスケープとメニューの独立状態のみ可能
const _Window_Selectable_prototype_processHandling = Window_Selectable.prototype.processHandling;
Window_Selectable.prototype.processHandling = function() {
	_Window_Selectable_prototype_processHandling.apply(this, arguments);

	if (this.isOpenAndActive() && this.isShiftEnabled()) {
		if (Input.isTriggered('shift')) {
			   	this.processShift();
		}
	}
	if(this.isOpenAndActive() && this.isMenuEnabled()){
		if(Input.isTriggered('menu') && actionValid && alternateMenuKey){
			this.processMenu();
		}
	}
};//*

Window_Selectable.prototype.isShiftEnabled = function() {
    return this.isHandled('shift');
};//*

Window_Selectable.prototype.processShift = function() {
    	this.playOkSound();
        this.updateInputData();
        this.deactivate();
        this.callShiftHandler();
};//*

Window_Selectable.prototype.callShiftHandler = function() {
    this.callHandler('shift');
};//*

Window_Selectable.prototype.isMenuEnabled = function() {
    return this.isHandled('menu');
};//*

Window_Selectable.prototype.processMenu = function() {
    	this.playOkSound();
        this.updateInputData();
        this.deactivate();
        this.callMenuHandler();
};//*

Window_Selectable.prototype.callMenuHandler = function() {
    this.callHandler('menu');
};//*

/*---------------------------------------------------------------------*/

//起動時にシステムデータをロードするように強化

const _DataManager_createGameObjects_Enhance = DataManager.createGameObjects;
DataManager.createGameObjects = function() {
		_DataManager_createGameObjects_Enhance.apply(this, arguments);
		if(MZ){
			//MZではこれ以前に３ブーリアンが初期化済なので、ここでMELOSの初期値で上書きする
			ConfigManager.alwaysDash = configGeneralCommands.initialAlwaysDash || false;
			ConfigManager.commandRemember = configGeneralCommands.initialCommandRemember || false;
			ConfigManager.touchUI = configGeneralCommands.initialTouchUI || false;
		}
		ConfigManager.load();
		this.setAdditionalConfig();
};//*

DataManager.setAdditionalConfig = function(){};//*


/*------------------------------------------------------------------------*/
//ゲームシステムに敗北回数の項目を追加
//ゲームシステムにOnにしたいスイッチを予約できる機能を追加 for falling
//後述する報酬獲得フリーテキストの初期設定も行う

const _Game_System_prototype_initialize_A = Game_System.prototype.initialize;
Game_System.prototype.initialize = function(){
	_Game_System_prototype_initialize_A.apply(this, arguments);

	this._loseCount = 0;
	this._beatCount = 0;
	this._loseCountAuto = false;
	this._beatCountAuto = false;
	this._reservedSwitch = 0;

	this._rewardPopup_alignX = 'right';
	this._rewardPopup_y = 464;
	this._rewardPopup_fontSize = 18;
	this._rewardPopup_marginX = 20;
	this._rewardPopup_marginY = 4;
	this._rewardPopup_maxRows = 3;
	this._rewardPopup_duration = 50;
	this._rewardPopup_bgColor1 = 'white';
	this._rewardPopup_bgColor2 = 'grey';
};//*

Game_System.prototype.loseCount = function(){
	return this._loseCount;
};//*

Game_System.prototype.onBattleLose = function(autoMode) {
	if(autoMode && !this._loseCountAuto) return;

    this._loseCount++;
};

Game_System.prototype.beatCount = function(){
	return this._beatCount;
};//*

Game_System.prototype.onBattleBeat = function(autoMode){
	if(autoMode && !this._beatCountAuto) return;

	this._beatCount++;
};//*

Game_System.prototype.setLoseCountAuto = function(value){
	this._loseCountAuto = value;
};//*

Game_System.prototype.setBeatCountAuto = function(value){
	this._beatCountAuto = value;
};//*


Game_System.prototype.reservedSwitch = function(){
	return this._reservedSwitch > 0;
};//*

Game_System.prototype.setReservedSwitch = function(id){
	if(id >= 0) this._reservedSwitch = id;
};//*

Game_System.prototype.executeReservedSwitch = function(){
	if(this.reservedSwitch()){
		$gameSwitches.setValue(this._reservedSwitch, true);
		this.setReservedSwitch(0);
	}
};//*


Game_System.prototype.rewardPopup = function(){
	return {
		'alignX' 	: this._rewardPopup_alignX,
		'y' 		: this._rewardPopup_y,
		'fontSize' 	: this._rewardPopup_fontSize,
		'marginX'	: this._rewardPopup_marginX,
		'marginY' 	: this._rewardPopup_marginY,
		'maxRows' 	: this._rewardPopup_maxRows,
		'duration' 	: this._rewardPopup_duration,
		'bgColor1'	: this._rewardPopup_bgColor1,
		'bgColor2'	: this._rewardPopup_bgColor2};
};//*

Game_System.prototype.changeRewardPopup = function(alignX, y, fontSize, marginX, marginY, maxRows, duration, bgColor1, bgColor2){
	if(alignX) this.changeRewardAlignX(alignX);
	if(y) this.changeRewardY(y);
	if(fontSize) this.changeRewardFontSize(fontSize);
	if(marginX) this.changeRewardMarginX(marginX);
	if(marginY) this.changeRewardMarginY(marginY);
	if(maxRows) this.changeRewardMaxRows(maxRows);
	if(duration) this.changeRewardDuration(duration);
	if(bgColor1) this.changeRewardBgColor1(bgColor1);
	if(bgColor2) this.changeRewardBgColor2(bgColor2);
};//*

Game_System.prototype.changeRewardAlignX = function(position){
	this._rewardPopup_alignX = position;
};//*

Game_System.prototype.changeRewardY = function(y){
	this._rewardPopup_y = y;
};//*

Game_System.prototype.changeRewardFontSize = function(fontSize){
	this._rewardPopup_fontSize = fontSize;
};//*

Game_System.prototype.changeRewardMarginX = function(marginX){
	this._rewardPopup_marginX = marginX;
};//*

Game_System.prototype.changeRewardMarginY = function(marginY){
	this._rewardPopup_marginY = marginY;
};//*

Game_System.prototype.changeRewardMaxRows = function(maxRows){
	this._rewardPopup_maxRows = maxRows.clamp(1, 3);
};//*

Game_System.prototype.changeRewardDuration = function(duration){
	this._rewardPopup_duration = duration;
};//*

Game_System.prototype.changeRewardBgColor1 = function(color){
	this._rewardPopup_bgColor1 = color;
};//*

Game_System.prototype.changeRewardBgColor2 = function(color){
	this._rewardPopup_bgColor2 = color;
};//*



/*---------------------------------------------------------------------*/
//プラグインが存在しているかを判定するメソッド
PluginManager.containsPlugin = function(name){
	const id = $plugins.findIndex(obj => obj.name.toLowerCase() === name);
	if(id < 0){
		return false;
	}else{
		const status = $plugins[id].status;
		return status;
	}
};//*

/*---------------------------------------------------------------------*/
//画像ローディングを振り分けるメソッド
ImageManager.separateLoading = function(path, name){
	switch(path){
		case 'animations' 	: this.loadAnimation(name); 	break;
		case 'battlebacks1' : this.loadBattleback1(name); 	break;
		case 'battlebacks2' : this.loadBattleback2(name); 	break;
		case 'enemies' 		: this.loadEnemy(name); 		break;
		case 'characters' 	: this.loadCharacter(name); 	break;
		case 'faces' 		: this.loadFace(name); 			break;
		case 'parallaxes' 	: this.loadParallax(name); 		break;
		case 'pictures' 	: this.loadPicture(name); 		break;
		case 'sv_actors'  	: this.loadSvActor(name); 		break;
		case 'sv_enemies' 	: this.loadSvEnemy(name); 		break;
		case 'system' 		: this.loadSystem(name); 		break;
		case 'tilesets' 	: this.loadTileset(name); 		break;
		case 'titles1' 		: this.loadTitle1(name); 		break;
		case 'titles2' 		: this.loadTitle2(name); 		break;
	}
};//*

/*-------------------------------------------------------------------*/
//キー名を自動的にゲームパッドのボタン名に切り替えるメソッド

const _Window_Base_prototype_convertEscapeCharacters = Window_Base.prototype.convertEscapeCharacters;
Window_Base.prototype.convertEscapeCharacters = function(text) {
    let parentText = _Window_Base_prototype_convertEscapeCharacters.apply(this, arguments);
    parentText = parentText.replace(/\x1bPad\[(\w+)\]/gi, this.convertPadEscapeCharacters.bind(this));
    return parentText;
};//*

Window_Base.prototype.convertPadEscapeCharacters = function(){
	return keyName(arguments[1]);
};//*

/*-------------------------------------------------------------------*/
//シーンの任意の場所に、任意のテキストを描画するメソッド
//プラグインコマンドrewardsから呼び出される、報酬ポップアップの描画処理も設定する

SceneManager.drawFreeText = function(code, text, x, y, option){
	text = Window_Base.prototype.convertEscapeCharacters.call(this, text);
	const scene = this._scene;
	const parent = this.createFreeTextSprite(code, text, x, y, option);
	scene._freeTextList.push(parent);
	scene.addChild(parent);
	parent.bitmap.drawText(text, 0, 0, parent.width, parent.height);
};//*

SceneManager.setWordWrap = function(text){
	//for YEP_MessageCore
	return Window_Base.prototype.setWordWrap.call(this, text);
};//*

SceneManager.convertExtraEscapeCharacters = function(text){
	//for YEP_MessageCore
	return Window_Base.prototype.convertExtraEscapeCharacters.call(this, text);
};//*

SceneManager.convertPadEscapeCharacters = function(){
	return Window_Base.prototype.convertPadEscapeCharacters.apply(this, arguments);
};//*

SceneManager.convertMelosRubyEscapeCharacters = function(){
	return Window_Base.prototype.convertMelosRubyEscapeCharacters.apply(this, arguments);
};//*

SceneManager.convertMWCEscapeCharacters = function(){
	//MELOS_WordConverter.jsが必要
	return Window_Base.prototype.convertMWCEscapeCharacters.apply(this, arguments);
};//*

SceneManager.createFreeTextSprite = function(code, text, x, y, option){
	x = (x || 0).clamp(0, Graphics.boxWidth);
	y = (y || 0).clamp(0, Graphics.boxHeight);
	const fontSize = option && typeof option.fontSize === 'number' ? option.fontSize : 28;
	const opacity = option && typeof option.opacity  === 'number' ? option.opacity : 255;
	const scaleX = option && typeof option.scaleX  === 'number' ? option.scaleX : 1;
	const scaleY = option && typeof option.scaleY  === 'number' ? option.scaleY : 1;
	const anchorX = option && typeof option.anchorX  === 'number'? option.anchorX : 0;
	const anchorY = option && typeof option.anchorY  === 'number' ? option.anchorY : 0;
	const skewX = option && typeof option.skewX === 'number' ? Math.PI * option.skewX/180 : 0;
	const skewY = option && typeof option.skewY === 'number' ? Math.PI * option.skewY/180 : 0;
	const rotation = option && typeof option.rotation === 'number' ? Math.PI * option.rotation/180 : 0;

	const parent = new Sprite();
	parent.x = x;
	parent.y = y;
	parent.height = fontSize + 8;
	if(opacity < 255) parent.opacity = opacity;
	if(scaleX !== 1) parent.scale.scope.scale.x = scaleX;
	if(scaleY !== 1) parent.scale.scope.scale.y = scaleY;
	if(anchorX !== 0) parent.anchor.x = anchorX;
	if(anchorY !== 0) parent.anchor.y = anchorY;
	if(skewX !== 0) parent.skew.x = skewX;
	if(skewY !== 0) parent.skew.y = skewY;
	if(rotation !== 0) parent.rotation = rotation;
	parent._code = code;

	parent.bitmap = new Bitmap(Graphics.boxWidth, parent.height);
	parent.bitmap.fontSize = fontSize;
	const textWidth = parent.bitmap.measureTextWidth(text);
	parent.width = textWidth;
	return parent;
};//*

SceneManager.eraseFreeText = function(code){
	const scene = this._scene;
	if(!scene.children || !scene._freeTextList) return;

	const childId = scene.children.findIndex(child => {return child._code === code});
	scene.removeChild(scene.children[childId]);
	scene._freeTextList = scene._freeTextList.filter(text => {return text._code !== code});
};//*

SceneManager.updateFreeTextScale = function(code, goalScaleX, goalScaleY, duration){
	const scene = this._scene;
	if(!scene.children || !scene._freeTextList) return;
	const scale = { 'code': code,
					'goalScaleX': goalScaleX,
					'goalScaleY': goalScaleY,
					'duration': duration || 1,
					'needDeleteX':false,
					'needDeleteY':false};
	scene._reserveFreeTextScale.push(scale);
};//*

SceneManager.updateFreeTextOpacity = function(code, goalOpacity, duration){
	const scene = this._scene;
	if(!scene.children || !scene._freeTextList) return;
	const opacity = { 	'code': code,
						'goalOpacity': goalOpacity,
						'duration': duration || 1,
						'needDelete':false};
	scene._reserveFreeTextOpacity.push(opacity);
};//*

SceneManager.updateFreeTextPosition = function(code, goalX, goalY, duration){
	const scene = this._scene;
	if(!scene.children || !scene._freeTextList) return;
	const position = {	'code': code,
						'goalX': goalX,
						'goalY': goalY,
						'duration': duration || 1,
						'needDeleteX':false,
						'needDeleteY':false};
	scene._reserveFreeTextPosition.push(position);
};//*

SceneManager.updateFreeTextSkew = function(code, goalX, goalY, duration){
	const scene = this._scene;
	if(!scene.children || !scene._freeTextList) return;
	const skew = {	'code': code,
					'goalSkewX': goalX,
					'goalSkewY': goalY,
					'duration': duration || 1,
					'needDeleteX':false,
					'needDeleteY':false};
	scene._reserveFreeTextSkew.push(skew);
};//*

SceneManager.updateFreeTextRotation = function(code, goalRotation, duration, times){
	const scene = this._scene;
	if(!scene.children || !scene._freeTextList) return;
	const rotation = { 	'code': code,
						'goalRotation': Math.PI * goalRotation / 180,
						'duration': duration || 1,
						'times': times,
						'needDelete':false};
	scene._reserveFreeTextRotation.push(rotation);
};//*


SceneManager.prepareRewardsPopup = function(itemList, amount){
	if(itemList && itemList.length > 0){
		const scene = this._scene;
		const sceneList = scene.isDisplayingRewards() ? scene._rewardReservedList : scene._rewardItemList;
		itemList.forEach(item => {
			let obj = {"item": item, "amount": (amount || 1)};
			sceneList.push(obj);
		});
	}
};//*

	//Scene_Baseでの処理
const _Scene_Base_prototype_initialize = Scene_Base.prototype.initialize;
Scene_Base.prototype.initialize = function() {
	_Scene_Base_prototype_initialize.apply(this, arguments);
    this._freeTextList = [];
    this._reserveFreeTextScale = [];
    this._reserveFreeTextOpacity = [];
    this._reserveFreeTextPosition = [];
    this._reserveFreeTextSkew = [];
    this._reserveFreeTextRotation = [];

    this.clearRewardPopup();
};//*

const _Scene_Base_prototype_update = Scene_Base.prototype.update;
Scene_Base.prototype.update = function() {
    _Scene_Base_prototype_update.apply(this, arguments);
    if( this.needUpdateFreeTextScele() ) this.updateFreeTextScale();
    if( this.needUpdateFreeTextOpacity() ) this.updateFreeTextOpacity();
    if( this.needUpdateFreeTextPosition() ) this.updateFreeTextPosition();
    if( this.needUpdateFreeTextSkew() ) this.updateFreeTextSkew();
    if( this.needUpdateFreeTextRotation() ) this.updateFreeTextRotation();
    if( this.needUpdateRewardPopup() ) this.updateRewardPopup();
};//*

Scene_Base.prototype.needUpdateFreeTextScele = function(){
	return this._reserveFreeTextScale.length > 0;
};//*

Scene_Base.prototype.needUpdateFreeTextOpacity = function(){
	return this._reserveFreeTextOpacity.length > 0;
};//*

Scene_Base.prototype.needUpdateFreeTextPosition = function(){
	return this._reserveFreeTextPosition.length > 0;
};//*

Scene_Base.prototype.needUpdateFreeTextSkew = function(){
	return this._reserveFreeTextSkew.length > 0;
};//*

Scene_Base.prototype.needUpdateFreeTextRotation = function(){
	return this._reserveFreeTextRotation.length > 0;
};//*

Scene_Base.prototype.needUpdateRewardPopup = function(){
	return this._rewardItemList.length > 0;
};//*


Scene_Base.prototype.updateFreeTextScale = function(){
	this._reserveFreeTextScale.forEach(obj => {
		let textId = this._freeTextList.findIndex(list => {return list._code === obj.code});
		if(textId < 0){
			obj.needDeleteX = true;
			obj.needDeleteY = true;
		}else{
			let text = this._freeTextList[textId];
			if(obj.startScaleX === undefined){
				obj.startScaleX = text.scale.scope.scale.x;
				obj.startScaleY = text.scale.scope.scale.y;
			}

			let differenceX = (obj.goalScaleX - obj.startScaleX) / obj.duration;
			let differenceY = (obj.goalScaleY - obj.startScaleY) / obj.duration;
			if(!obj.needDeleteX) text.scale.scope.scale.x += differenceX;
			if(!obj.needDeleteY) text.scale.scope.scale.y += differenceY;

			if( (differenceX >= 0 && text.scale.scope.scale.x >= obj.goalScaleX) ||
				(differenceX < 0 && text.scale.scope.scale.x <= obj.goalScaleX) ){
				text.scale.scope.scale.x = obj.goalScaleX;
				obj.needDeleteX = true;
			}
			if( (differenceY >= 0 && text.scale.scope.scale.y >= obj.goalScaleY) ||
				(differenceY < 0 && text.scale.scope.scale.y <= obj.goalScaleY) ){
				text.scale.scope.scale.y = obj.goalScaleY;
				obj.needDeleteY = true;
			}
			
		}
	});
	this._reserveFreeTextScale = this._reserveFreeTextScale.filter(obj => {
											return !(obj.needDeleteX && obj.needDeleteY);
									});
};//*

Scene_Base.prototype.updateFreeTextOpacity = function(){
	this._reserveFreeTextOpacity.forEach(obj => {
		let textId = this._freeTextList.findIndex(list => {return list._code === obj.code});
		if(textId < 0){
			obj.needDelete = true;
		}else{
			let text = this._freeTextList[textId];
			if(obj.startOpacity === undefined) obj.startOpacity = text.opacity;

			let difference = (obj.goalOpacity - obj.startOpacity) / obj.duration;
			if(!obj.needDelete) text.opacity += difference;
			if( (difference >= 0 && text.opacity >= obj.goalOpacity) ||
				(difference < 0 && text.opacity <= obj.goalOpacity) ){
				text.opacity = obj.goalOpacity;
				obj.needDelete = true;
			}
		}
	});
	this._reserveFreeTextOpacity = this._reserveFreeTextOpacity.filter(obj => {return !obj.needDelete});
};//*

Scene_Base.prototype.updateFreeTextPosition = function(){
	this._reserveFreeTextPosition.forEach(obj => {
		let textId = this._freeTextList.findIndex(list => {return list._code === obj.code});
		if(textId < 0){
			obj.needDeleteX = true;
			obj.needDeleteY = true;
		}else{
			let text = this._freeTextList[textId];
			if(obj.startX === undefined){
				obj.startX = text.x;
				obj.startY = text.y;
			}

			let differenceX = (obj.goalX - obj.startX) / obj.duration;
			let differenceY = (obj.goalY - obj.startY) / obj.duration;
			if(!obj.needDeleteX) text.x += differenceX;
			if(!obj.needDeleteY) text.y += differenceY;
			if( (differenceX >= 0 && text.x >= obj.goalX) || (differenceX < 0 && text.x <= obj.goalX) ){
				text.x = obj.goalX;
				obj.needDeleteX = true;
			}
			if( (differenceY >= 0 && text.y >= obj.goalY) || (differenceY < 0 && text.y <= obj.goalY) ){
				text.y = obj.goalY;
				obj.needDeleteY = true;
			}
		}
	});
	this._reserveFreeTextPosition = this._reserveFreeTextPosition.filter(obj => {
															return !(obj.needDeleteX && obj.needDeleteY);
														});
};//*

Scene_Base.prototype.updateFreeTextSkew = function(){
	this._reserveFreeTextSkew.forEach(obj => {
		let textId = this._freeTextList.findIndex(list => {return list._code === obj.code});
		if(textId < 0){
			obj.needDeleteX = true;
			obj.needDeleteY = true;
		}else{
			let text = this._freeTextList[textId];
			if(obj.startSkewX === undefined){
				obj.startSkewX = text.skew.x;
				obj.startSkewY = text.skew.y;
			}

			let differenceX = (obj.goalSkewX - obj.startSkewX) / obj.duration;
			let differenceY = (obj.goalSkewY - obj.startSkewY) / obj.duration;
			if(!obj.needDeleteX) text.skew.x += differenceX;
			if(!obj.needDeleteY) text.skew.y += differenceY;

			if( (differenceX >= 0 && text.skew.x >= obj.goalSkewX) ||
				(differenceX < 0 && text.skew.x <= obj.goalSkewX) ){
				text.skew.x = obj.goalSkewX;
				obj.needDeleteX = true;
			}
			if( (differenceY >= 0 && text.skew.y >= obj.goalSkewY) ||
				(differenceY < 0 && text.skew.y <= obj.goalSkewY) ){
				text.skew.y = obj.goalSkewY;
				obj.needDeleteY = true;
			}
			
		}
	});
	this._reserveFreeTextSkew = this._reserveFreeTextSkew.filter(obj => {
											return !(obj.needDeleteX && obj.needDeleteY);
									});
};//*

Scene_Base.prototype.updateFreeTextRotation = function(){
	this._reserveFreeTextRotation.forEach(obj => {
		let textId = this._freeTextList.findIndex(list => {return list._code === obj.code});
		if(textId < 0){
			obj.needDelete = true;
		}else{
			let text = this._freeTextList[textId];
			if(obj.startRotation === undefined) obj.startRotation = text.rotation;

			let difference = (obj.goalRotation - obj.startRotation) / obj.duration;
			if(!obj.needDelete) text.rotation += difference;
			if( (difference >= 0 && text.rotation >= obj.goalRotation) ||
				(difference < 0 && text.rotation <= obj.goalRotation) ){
				obj.times --;
				if(obj.times > 0){
					text.rotation %= Math.PI * 2;
				}else if(obj.times === 0){
					text.rotation = obj.goalRotation;
					obj.needDelete = true;	
				}else if(obj.times < 0){
					obj.times %= 10;
					text.rotation %= Math.PI * 2;
				}	
			};
		}
	});
	this._reserveFreeTextRotation = this._reserveFreeTextRotation.filter(obj => {return !obj.needDelete});
};//*

	//---報酬ポップアップの処理

Scene_Base.prototype.createRewardsPopup = function(){
	const rp = $gameSystem.rewardPopup();
	const parent = new Sprite();
		parent.x = 0;
		parent.y = rp.y;
		parent.width = Graphics.boxWidth;
		parent.height = (rp.fontSize + rp.marginY) * rp.maxRows + rp.marginY;
	return parent;
};//*

Scene_Base.prototype.isDisplayingRewards = function(){
	return this._isDisplayingRewards;
};//*

Scene_Base.prototype.setDisplayingReards = function(value){
	this._isDisplayingRewards = !!value;
};//*

Scene_Base.prototype.clearRewardPopup = function(){
	this.removeChild(this._rewardsPopup);
	this._isDisplayingRewards = false;
	this._rewardsPopupOpened = false;
	this._rewardsPopup = null;
    this._rewardItemList = [];
    this._rewardReservedList = [];
    this._rewardCurrentIndex = -1;
    this._rewardUpdateCount = 0;
    this._rewardScrollCount = 0;
    this._rewardPopupTerminateX = 0;
    this._rewardPopupStartY = 0;
};//*

Scene_Base.prototype.updateRewardPopup = function(){
	if(this._rewardUpdateCount <= 0){
			this.checkRewardPopup();
	}else{
		this._rewardUpdateCount --;
		if(this._rewardUpdateCount <= 0){
			this.checkRewardPopup();
		}
	}
};//*

Scene_Base.prototype.checkRewardPopup = function(){
	if(this._rewardCurrentIndex === -1){
		this.setupRewardPopup();
	}else if(!this.isOpenedRewardPopup()){
		this.openRewardPopup();
	}else if( !this.isAllRewardsScrolled() ){
		this.checkRewardPopupScroll();
	}else{
		this.terminateRewardPopup();
	}
};//*

Scene_Base.prototype.isOpenedRewardPopup = function(){
	return this._rewardsPopupOpened;
};//*

Scene_Base.prototype.isAllRewardsScrolled = function(){
	return this._rewardCurrentIndex >= this._rewardItemList.length - $gameSystem.rewardPopup().maxRows;
};//*

Scene_Base.prototype.setupRewardPopup = function(){
	this._rewardCurrentIndex = 0;
	this.setDisplayingReards(true);

	const rp = $gameSystem.rewardPopup();
	const parent = this.createRewardsPopup();
		parent.opacity = 0;
		parent.bitmap = new Bitmap(parent.width, parent.height);
		parent.bitmap.fontSize = rp.fontSize;
	this._rewardPopupStartY += (rp.marginY - 1);

	this._rewardsPopup = parent;
	this.addChild(parent);
	this.drawAllRewardPopup();
};//*

Scene_Base.prototype.openRewardPopup = function(){
	const openDuration = $gameSystem.rewardPopup().marginX || 20;
	const align = $gameSystem.rewardPopup().alignX;
	if(this._rewardScrollCount <= 0) {
		this._rewardScrollCount = openDuration;
	}

	this._rewardScrollCount --;
	const itr = align === 'left' ? 1 : (align === 'right' ? -1 : 0);
	this._rewardPopupTerminateX += itr;
	this._rewardsPopup.opacity += Math.ceil(255 / openDuration);
	this.redrawRewardPopup();

	if(this._rewardScrollCount <= 0){
		this._rewardsPopupOpened = true;
		this.setupRewardUpdateCount();
	}
};//*

Scene_Base.prototype.checkRewardPopupScroll = function(){
	if(this._rewardScrollCount <= 0) this.setupRewardScrollCount();
		
	this._rewardScrollCount --;
	this._rewardPopupStartY --;
		
	if(this._rewardScrollCount <= 0){
			this._rewardCurrentIndex ++;
			this.setupRewardUpdateCount();	
	}
	this.redrawRewardPopup();
};//*

Scene_Base.prototype.terminateRewardPopup = function(){
	const clearDuration = $gameSystem.rewardPopup().marginX || 20;
	const align = $gameSystem.rewardPopup().alignX;
	if(this._rewardScrollCount <= 0) this._rewardScrollCount = clearDuration;

	this._rewardScrollCount --;
	const itr = align === 'left' ? -1 : (align === 'right' ? 1 : 0);
	this._rewardPopupTerminateX += itr;
	this._rewardsPopup.opacity -= Math.floor(255 / clearDuration);
	this.redrawRewardPopup();

	if(this._rewardScrollCount <= 0){
		let reservedList = [];
		if(this._rewardReservedList.length > 0){
			reservedList = this._rewardReservedList.map(obj => {return obj});
		}
		this.clearRewardPopup();
		if(reservedList.length > 0) this._rewardItemList = reservedList.map(obj => {return obj});
	}
};//*


Scene_Base.prototype.setupRewardUpdateCount = function(){
	this._rewardUpdateCount = $gameSystem.rewardPopup().duration;
};//*

Scene_Base.prototype.setupRewardScrollCount = function(){
	const rp = $gameSystem.rewardPopup();
	this._rewardScrollCount = rp.fontSize + rp.marginY;
};//*

Scene_Base.prototype.redrawRewardPopup = function(){
	this._rewardsPopup.bitmap.clear();
	this.drawAllRewardPopup();
};//*

Scene_Base.prototype.drawAllRewardPopup = function(){
	const itemList = this._rewardItemList;
	const rp = $gameSystem.rewardPopup();
	for(var i = 0; i < itemList.length; i++){
		let y = this._rewardPopupStartY + (rp.fontSize + rp.marginY) * i;
		this.drawRewardPopup(itemList[i], y);
	}
};//*

Scene_Base.prototype.drawRewardPopup = function(itemObj, y){
	const parent = this._rewardsPopup;
	const rp = $gameSystem.rewardPopup();
	const align = rp.alignX;
	const x = this._rewardPopupTerminateX;
	const leftX = align === 'left' ? rp.fontSize * 1.2 : 0; // used only for lefted align
	const x2 = x + leftX;
	const width = parent.width - rp.marginX * 2;

	const item = itemObj.item;
	const amount = itemObj.amount;
	const text = this.createRewardText(item.name, amount);

	this.drawRewardPopupBackground(text, x2, y, align);
	parent.bitmap.drawText(text, x2, y, width , rp.fontSize, align);
	this.drawRewardPopupIcon(item, text, x, y, width, align);
};//*

Scene_Base.prototype.createRewardText = function(name, amount){
	name = Window_Base.prototype.convertEscapeCharacters.call(this, name);
	return `${name} × ${amount}`;
};//*

Scene_Base.prototype.convertPadEscapeCharacters = function(){
	return Window_Base.prototype.convertPadEscapeCharacters.apply(this, arguments);
};//*

Scene_Base.prototype.convertMelosRubyEscapeCharacters = function(){
	return Window_Base.prototype.convertMelosRubyEscapeCharacters.apply(this, arguments);
};//*

Scene_Base.prototype.convertMWCEscapeCharacters = function(){
	//MELOS_WordConverter.jsが必要
	return Window_Base.prototype.convertMWCEscapeCharacters.apply(this, arguments);
};//*

Scene_Base.prototype.drawRewardPopupBackground = function(text,x, y, align){
	const rp = $gameSystem.rewardPopup();
	const parent = this._rewardsPopup;
	const tw = parent.bitmap.measureTextWidth(text);
	const width = (tw + rp.marginX) * (align === 'left' ? 1 : -1);
	const height = rp.fontSize;
	const x2 = x + (align === 'left' ? 0 : parent.width / (align === 'right' ? 1 : 2) - rp.marginX);
	const color1 = this.rewardPopupBackgroundColor1();
	const color2 = this.rewardPopupBackgroundColor2();

	if(align === 'center'){
		parent.bitmap.gradientFillRect(x2, y, width / 2, height, color1, color2, false);
		parent.bitmap.gradientFillRect(x2, y, width * -1 /2, height, color1, color2, false);
	}else{
		parent.bitmap.gradientFillRect(x2, y, width, height, color1, color2, false);
	}
};//*

Scene_Base.prototype.rewardPopupBackgroundColor1 = function(){
	return $gameSystem.rewardPopup().bgColor1;
};//*

Scene_Base.prototype.rewardPopupBackgroundColor2 = function(){
	return $gameSystem.rewardPopup().bgColor2;
};//*

Scene_Base.prototype.drawRewardPopupIcon = function(item, text, x, y, width, align){
	const bitmap = this._rewardsPopup.bitmap;
	const rp = $gameSystem.rewardPopup();

	const img = ImageManager.loadSystem('IconSet');
	const pw = Window_Base._iconWidth;
    const ph = Window_Base._iconHeight;
    const sx = item.iconIndex % 16 * pw;
    const sy = Math.floor(item.iconIndex / 16) * ph;

    const tw = bitmap.measureTextWidth(text);
    const dw = rp.fontSize;
    const adjustX = align === 'left' ? 0 : 
    				(align === 'right' ? width - (tw + dw) - rp.marginY :
    					( width - (tw + dw) ) / 2 - rp.fontSize * 1.2 );
    const dx = x + adjustX;
    const dy = y 
    bitmap.blt(img, sx, sy, pw, ph, dx, dy, dw, dw);
};//*


/*-------------------------------------------------------------------*/
//エンコードに対応していないウィンドウクラスを、セーブ対象から除外
//ここで除外したウィンドウはセーブ後・ロード後の双方で復元処理を行うこと。
/*
const skipEncoder = ['Window_HpBar',
					 'Window_HpName'];
*/
JsonEx._skipGenerating = function(value){
		//const constructor = MV ? this._getConstructorName(value) : value.constructor.name;
		return value.skipEncoder // || skipEncoder.contains(constructor);
};//*

if(MV){
		const _JsonEx_encode = JsonEx._encode;
		JsonEx._encode = function(value, circular, depth) {
		    depth = depth || 0;
		    if (++depth >= this.maxDepth) {
		        throw new Error('Object too deep');
		    }
		    var type = Object.prototype.toString.call(value);
		    if (type === '[object Object]' || type === '[object Array]') {
		    	if(this._skipGenerating(value)){return;}

		        value['@c'] = JsonEx._generateId();

		        var constructorName = this._getConstructorName(value);
		        if (constructorName !== 'Object' && constructorName !== 'Array') {
		            value['@'] = constructorName;
		        }
		        for (var key in value) {
		            if (value.hasOwnProperty(key) && !key.match(/^@./)) {
		                if(value[key] && typeof value[key] === 'object'){
		                    if(value[key]['@c']){
		                        circular.push([key, value, value[key]]);
		                        value[key] = {'@r': value[key]['@c']};
		                    }else{
		                        value[key] = this._encode(value[key], circular, depth + 1);

		                        if(value[key] instanceof Array){
		                            //wrap array
		                            circular.push([key, value, value[key]]);

		                            value[key] = {
		                                '@c': value[key]['@c'],
		                                '@a': value[key]
		                            };
		                        }
		                    }
		                }else{
		                    value[key] = this._encode(value[key], circular, depth + 1);
		                }
		            }
		        }
		    }
		    depth--;
		    return value;
		};//*	
};//MV encoder


if(MZ){
		JsonEx._encode = function(value, depth) {
		    // [Note] The handling code for circular references in certain versions of
		    //   MV has been removed because it was too complicated and expensive.
		    if (depth >= this.maxDepth) {
		        throw new Error("Object too deep");
		    }
		    const type = Object.prototype.toString.call(value);
		    if (type === "[object Object]" || type === "[object Array]") {
		    	if(this._skipGenerating(value)){return;}

		        const constructorName = value.constructor.name;
		        if (constructorName !== "Object" && constructorName !== "Array") {
		            value["@"] = constructorName;
		        }
		        for (const key of Object.keys(value)) {
		            value[key] = this._encode(value[key], depth + 1);
		        }
		    }
		    return value;
		};//*
};//MZ encoder

/*-----------------------------------------------------------------*/
//開発エンジン表示の設定。MVはプラグインMadeWithMVにて、MZは標準で搭載されるクラス。
if(MZ || PluginManager.containsPlugin('madewithmv')){
	const melosLogo = 'melosLogo';

	if(MV){
		const _Scene_Boot_loadSystemImages = Scene_Boot.prototype.loadSystemImages;
	    Scene_Boot.prototype.loadSystemImages = function() {
	        _Scene_Boot_loadSystemImages.call(this);
	        ImageManager.loadSystem(melosLogo);
	    };//*

	    const _Scene_Splash_prototype_initialize = Scene_Splash.prototype.initialize;
	    Scene_Splash.prototype.initialize = function() {
	        _Scene_Splash_prototype_initialize.apply(this, arguments);
	        this._melosSplash = null;
	        this._melosWaitTime = Liquidize.MadeWithMV.WaitTime;
	        this._melosFadeOut = false;
	        this._melosFadeIn = false;
	    };//*


		const _Scene_Splash_prototype_start = Scene_Splash.prototype.start;
		Scene_Splash.prototype.start = function() {
			_Scene_Splash_prototype_start.apply(this, arguments);
	        this.centerSprite(this._melosSplash);
	    };//*

	    const _Scene_Splash_prototype_createSplashes = Scene_Splash.prototype.createSplashes;
	    Scene_Splash.prototype.createSplashes = function() {
	    	_Scene_Splash_prototype_createSplashes.apply(this, arguments);
            this._melosSplash = new Sprite(ImageManager.loadSystem(melosLogo));
            this._melosSplash.opacity = 0;
            this.addChild(this._melosSplash);
    	};//*

    	//Liquidize is a groval variable of MadeWithMV.js
    	const _Scene_Splash_prototype_update = Scene_Splash.prototype.update;
    	Scene_Splash.prototype.update = function() {
	       	_Scene_Splash_prototype_update.apply(this, arguments);
	       	Scene_Base.prototype.update.call(this);
	       	this.updateMelosSplash();
	       	this.checkSkip();
	    };//*

	    const _Scene_Splash_prototype_gotoTitleOrTest = Scene_Splash.prototype.gotoTitleOrTest;
		Scene_Splash.prototype.gotoTitleOrTest = function() {
			if(this._melosFadeOut === true){
				_Scene_Splash_prototype_gotoTitleOrTest.apply(this, arguments);	
			}
	    };//*

		Scene_Splash.prototype.updateMelosSplash = function(){
			const shownMV = !Liquidize.MadeWithMV.ShowMV || this._mvFadeOut === true;
			const shownCustom = !Liquidize.MadeWithMV.ShowCustom || this._customFadeOut === true;
			if(shownMV && shownCustom){
					if (!this._melosFadeIn && this._fadeDuration === 0) {
	                    this._melosSplash.opacity = 255;
	                    this._melosWaitTime = Liquidize.MadeWithMV.WaitTime;
	                    this.startFadeIn(Liquidize.MadeWithMV.FadeInTime, false);
	                    this._melosFadeIn = true;
	                } else {
	                    if (this._melosWaitTime > 0 && this._melosFadeOut === false) {
	                        this._melosWaitTime--;
	                    } else {
	                        if (this._melosFadeOut === false) {
	                            this._melosFadeOut = true;
	                            this.startFadeOut(Liquidize.MadeWithMV.FadeOutTime, false);
	                        }
	                    }
	                };
			}
		};//*

		Scene_Splash.prototype.checkSkip = function() {
		    if (Input.isTriggered("ok") || TouchInput.isTriggered()) {
		        if(this._mvSplash && this._mvWaitTime > 0){
		        	this._mvWaitTime = 0;
		        }else if(this._customSplash && this._customWaitTime > 0){
		        	this._customWaitTime = 0;
		        }else if(this._melosSplash && this._melosWaitTime > 0){
		        	this._melosWaitTime = 0;
		        }
		    }
		};//*
	}else if(MZ){
		const _Scene_Splash_prototype_createBackground = Scene_Splash.prototype.createBackground;
		Scene_Splash.prototype.createBackground = function() {
			//MZではここでスプラッシュ画像を準備している
			_Scene_Splash_prototype_createBackground.apply(this, arguments);
			this._backSprite._fadeOut = false;

		    this._backMelosSprite = new Sprite();
		    this._backMelosSprite.bitmap = ImageManager.loadSystem(melosLogo);
		    this._backMelosSprite.opacity = 0;
		    this.addChild(this._backMelosSprite);
		    this._backMelosSprite._fadeOut = false;
		};//*


		const _Scene_Splash_prototype_adjustBackground = Scene_Splash.prototype.adjustBackground;
		Scene_Splash.prototype.adjustBackground = function() {
			_Scene_Splash_prototype_adjustBackground.apply(this, arguments);
		    this.scaleSpriteMelos(this._backMelosSprite);
		    this.centerSprite(this._backMelosSprite);
		};//*

		const _Scene_Splash_prototype_updateWaitCount = Scene_Splash.prototype.updateWaitCount;
		Scene_Splash.prototype.updateWaitCount = function() {
			const updating = _Scene_Splash_prototype_updateWaitCount.apply(this, arguments);
			if(updating) return true;

			if(this._backSprite){
				if(!this._backSprite._fadeOut){
					this._backSprite._fadeOut = true;
					this.initWaitCount();
					this._backSprite.opacity = 0;
					this._backMelosSprite.opacity = 255;
					return true;
				}else if(!this._backMelosSprite._fadeOut){
					this._backMelosSprite._fadeOut = true;
					this.initWaitCount();
					return true;
				}else{
					return false;
				}
			}else{
				return false;
			}
		};//*

		Scene_Base.prototype.scaleSpriteMelos = function(sprite) {
		    const ratioX = Graphics.width / sprite.bitmap.width;
		    const ratioY = Graphics.height / sprite.bitmap.height;
		    const scale = Math.max(ratioX, ratioY, 1.0);
		    sprite.scale.x = scale * 0.6;
		    sprite.scale.y = scale * 0.6;
		};//*
	};
}////


/*-----------------------------------------------------------------*/
//Game_Interpreterを拡張。イベントスキップするための設定

		/*~struct~EventSkip:ja
			@param 	valid
			@type 		boolean
			@text 		イベントスキップ有効化
			@desc 		On（true）の時、イベントスキップ機能が有効になります
			@default 	false

			@param geometry
			@type 		select
			@text 		ゲージの形
			@desc　		矩形か円形かを設定します。
			@default 	rect
				@option 矩形
				@value 	rect

				@option 円形
				@value 	circle

			@param x
			@type 		number
			@text 		ｘ座標
			@desc 		ゲージの原点のｘ座標を設定します。矩形なら左上、円形なら中心が原点です
			@default 	600
			@decimals 	0
			@min 		0
			@max 		2000

			@param y
			@type 		number
			@text 		ｙ座標
			@desc 		ゲージの原点のｙ座標を設定します。矩形なら左上、円形なら中心が原点です
			@default 	580
			@decimals 	0
			@min 		0
			@max 		2000

			@param width
			@type 		number
			@text 		ゲージ幅
			@desc 		ゲージの幅を設定します。円形の場合はスキップ開始までの基本時間となります
			@default 	100
			@decimals 	0
			@min 		1
			@max 		100

			@param height
			@type 		number
			@text 		ゲージ高さ・直径
			@desc 		ゲージの高さを設定します。円形の場合は直径となります
			@default 	30
			@decimals 	0
			@min 		1
			@max 		100

			@param offset
			@type 		number
			@text 		オフセット値
			@desc 		ゲージの変動値を設定します
			@default 	1
			@decimals 	0
			@min 		1
			@max 		100

			@param text
			@type 		string
			@text 		スキップ文字
			@desc 		スキップを表す文字列を設定します。ゲージの右側に配置されます
			@default 	スキップ

			@param 	skipButton
			@type 		select
			@text 		スキップボタン
			@desc 		イベントスキップのために使う入力ボタンを設定します
			@default 	shift
				@option shiftキー or Xボタン
				@value 	shift

				@option Qキー or Lボタン
				@value 	pageup

			@param fontSize
			@type 		number
			@text 		文字サイズ
			@desc 		スキップ文字とスキップボタンのサイズを設定します。
			@default 	21
			@decilams 	0
			@min 		12
			@max 		72

			@param fadeSpeed
			@type 		number
			@text 		フェード速度（フレーム）
			@desc 		スキップ時の画面フェードイン・アウトの時間を設定します。
			@default 	24
			@decimals 	0
			@min 		0
			@max 		120
		*/
		/*------------------------------------------------------------------*/
		/*~struct~EventSkip:
			@param 	valid
			@type 		boolean
			@text 		enable Event Skip
			@desc 		Enable Event Skip when this is true
			@default 	false

			@param geometry
			@type 		select
			@text 		geometry of Skip Gauge
			@desc　		Select the geometry
			@default 	rect
				@option Rectangle
				@value 	rect

				@option Circle
				@value 	circle

			@param x
			@type 		number
			@text 		x coordinate
			@desc 		Control the coordinate of Skip Gauge ; the origin is upper left in rect, center in circle
			@default 	600
			@decimals 	0
			@min 		0
			@max 		2000

			@param y
			@type 		number
			@text 		y coordinate
			@desc 		Control the coordinate of Skip Gauge ; the origin is upper left in rect, center in circle
			@default 	580
			@decimals 	0
			@min 		0
			@max 		2000

			@param width
			@type 		number
			@text 		gauge width or duration
			@desc 		Control the width; in circle, this is the duration for Skip Gauge max
			@default 	100
			@decimals 	0
			@min 		1
			@max 		100

			@param height
			@type 		number
			@text 		gauge height or radius
			@desc 		Control the height; in circle, this is the radius of Skip Gauge
			@default 	30
			@decimals 	0
			@min 		1
			@max 		100

			@param offset
			@type 		number
			@text 		offset
			@desc 		Control the offset of Skip Gauge gaining
			@default 	1
			@decimals 	0
			@min 		1
			@max 		100

			@param text
			@type 		string
			@text 		text for skip
			@desc 		Write a text for skip; this is on right of Skip Gauge
			@default 	Skip

			@param 	skipButton
			@type 		select
			@text 		skip button
			@desc 		Select a key for Event Skip
			@default 	shift
				@option shift key or X button
				@value 	shift

				@option Q key or L button
				@value 	pageup

			@param fontSize
			@type 		number
			@text 		font size
			@desc 		Control the font size of Skip Text
			@default 	21
			@decilams 	0
			@min 		12
			@max 		72

			@param fadeSpeed
			@type 		number
			@text 		fade speed (frames)
			@desc 		Control the speed of screen fading in or out when event skipping
			@default 	24
			@decimals 	0
			@min 		0
			@max 		120
		*/

		const parseEventSkip = s => JSON.parse(s, (key, value) => {
			switch(key){
				case 'valid' 		: return value;
				case 'geometry' 	: return value;
				case 'x' 			: return Number(value);
				case 'y' 			: return Number(value);
				case 'width' 		: return Number(value);
				case 'height' 		: return Number(value);
				case 'offset' 		: return Number(value);
				case 'text' 		: return value;
				case 'skipButton' 	: return value;
				case 'fontSize' 	: return Number(value);
				case 'fadeSpeed' 	: return Number(value);
				default 			: return value;
			};
		});//*

		let eventSkip = params.eventSkip;
		let consolerNameEventSkip = 'eventSkip:'
		if(eventSkip){
			eventSkip = parseEventSkip(eventSkip);
			eventSkip = stringToBoolean(eventSkip);
		}else{
			eventSkip = makeNotValid();
			undefinedStructs.push(consolerNameEventSkip);
			consolerNameEventSkip += makeInvalidTerm();
		};
		
		consoler(consolerNameEventSkip, eventSkip);

const _Game_Interpreter_prototype_initialize_A = Game_Interpreter.prototype.initialize;
Game_Interpreter.prototype.initialize = function(depth) {
    _Game_Interpreter_prototype_initialize_A.apply(this, arguments);
    this._skippable = false; 	//skipping作動のための前提条件
    this._skipping = false; 	//スキップ指示が出たか否か
    this._stopSkipping = false; //スキップを一時停止するか否か
    this._startFade = false; 	//スキップの画面フェードアウト・インが始まったか否か
    this._lastFadeIn = false;	//イベント終了時にフェードインするか
    this._skippableCommands = this.createSkippableCommands();
};//*

Game_Interpreter.prototype.createSkippableCommands = function(){
	return [105, 405, 204, 230,
			212, 213, 221, 222, 224, 225,
			249, 250, 251, 261, 337];
};//*

Game_Interpreter.prototype.abortSkip = function(){
	this.setSkipping(false);
	this.setSkippable(false);
	if(this._lastFadeIn) this.skipFadeIn();
};//*
if(!eventSkip.valid) Game_Interpreter.prototype.abortSkip = function(){};


Game_Interpreter.prototype.setSkippable = function(value){
	this._skippable = value;
};//*
if(!eventSkip.valid) Game_Interpreter.prototype.setSkippable = function(value){};


Game_Interpreter.prototype.isSkippable = function(){
	return this._skippable;
};//*
if(!eventSkip.valid) Game_Interpreter.prototype.isSkippable = function(){return false};


Game_Interpreter.prototype.reverseSkippable = function(){
	this.setSkippable(!this.isSkippable());
};//*
if(!eventSkip.valid) Game_Interpreter.prototype.reverseSkippable = function(){};


Game_Interpreter.prototype.setSkipping = function(value){
	if(this.isSkippable()) this._skipping = value;
};//*
if(!eventSkip.valid) Game_Interpreter.prototype.setSkipping = function(value){};


Game_Interpreter.prototype.isSkipping = function(){
	return this.isSkippable() && this._skipping && !this._stopSkipping;
};//*
if(!eventSkip.valid) Game_Interpreter.prototype.isSkipping = function(){return false};


Game_Interpreter.prototype.reverseSkipping = function(){
	this.setSkipping(!this.isSkipping());
};//*
if(!eventSkip.valid) Game_Interpreter.prototype.reverseSkipping = function(){};


Game_Interpreter.prototype.isInBattleScene = function(){
	return SceneManager._scene.constructor.name === 'Scene_Battle';
};//*
if(!eventSkip.valid) Game_Interpreter.prototype.isInBattleScene = function(){return false};


Game_Interpreter.prototype.sceneSkippable = function(){
	return this.isInBattleScene() ? $gameTroop.eventSkippable() : $gameMap.eventSkippable();
};//*
if(!eventSkip.valid) Game_Interpreter.prototype.sceneSkippable = function(){return false};


Game_Interpreter.prototype.sceneSkipping = function(){
	return this.isInBattleScene() ? $gameTroop.eventSkipping() : $gameMap.eventSkipping();
};//*
if(!eventSkip.valid) Game_Interpreter.prototype.sceneSkipping = function(){return false};


Game_Interpreter.prototype.sceneStopSkipping = function(){
	return this.isInBattleScene() ? $gameTroop.stopSkipping() : $gameMap.stopSkipping();
};//*
if(!eventSkip.valid) Game_Interpreter.prototype.sceneStopSkipping = function(){return false};


if(eventSkip.valid){
	const _Game_Interpreter_prototype_executeCommand = Game_Interpreter.prototype.executeCommand;
	Game_Interpreter.prototype.executeCommand = function() {
		if(!this.sceneSkipping()){
			return _Game_Interpreter_prototype_executeCommand.apply(this, arguments);
		}else{
			const command = this.currentCommand();
			if(command){
					if(this.skippableCommand(command)){
						this._index++;
					}else{
						return _Game_Interpreter_prototype_executeCommand.apply(this, arguments);
					}
			}else{
					this.terminate();
					this.abortSkip();
			}
			return true;
		}
	};//*
}////

Game_Interpreter.prototype.skippableCommand = function(command){
	return this._skippableCommands.contains(command.code);
};//*
if(!eventSkip.valid) Game_Interpreter.prototype.skippableCommand = function(command){return false};


Game_Interpreter.prototype.beforeEventCode = function(){
	const command = this._list[this._index - 1];
    if (command) {
        return command.code;
    } else {
        return 0;
    }
};//*
if(!eventSkip.valid) Game_Interpreter.prototype.beforeEventCode = function(){return 0};


Game_Interpreter.prototype.skipFadeOut = function(){
	this._startFade = true;
	const speed = eventSkip.fadeSpeed >= 0 ? eventSkip.fadeSpeed : this.fadeSpeed();
	$gameScreen.startFadeOut(speed);
    this.wait(speed);
};//*
if(!eventSkip.valid) Game_Interpreter.prototype.skipFadeOut = function(){};


Game_Interpreter.prototype.skipFadeIn = function(){
	this._startFade = true;
	const speed = eventSkip.fadeSpeed >= 0 ? eventSkip.fadeSpeed : this.fadeSpeed();
	$gameScreen.startFadeIn(speed);
    this.wait(speed);
};//*
if(!eventSkip.valid) Game_Interpreter.prototype.skipFadeIn = function(){};


if(eventSkip.valid){
	const _Game_Interpreter_prototype_updateWaitCount = Game_Interpreter.prototype.updateWaitCount;
	Game_Interpreter.prototype.updateWaitCount = function() {
		if(!this.sceneSkipping() || this._startFade){
			const waitCount = _Game_Interpreter_prototype_updateWaitCount.apply(this, arguments);
			if(this._startFade && this._waitCount === 0) this._startFade = false;
			return waitCount;
		}else{
			if (this._waitCount > 0) this._waitCount = 0;
			return false;	
		}
	};//*
}////

if(eventSkip.valid){
	//check aborting case in Show Text-----
	const _Game_Interpreter_prototype_command101 = Game_Interpreter.prototype.command101;
	Game_Interpreter.prototype.command101 = function(params) {
		//params はMZでのみ渡される引数。MVではthis._paramsから参照する。
		if(!this.sceneSkipping() || this.nextIsChoice()){
			if(this.sceneSkipping()) this.sceneStopSkipping();

			return _Game_Interpreter_prototype_command101.apply(this, arguments);
		}else{
		    return true;
		}
	};//*
}////


Game_Interpreter.prototype.nextIsChoice = function(){
	let nextIndex = this._index + 1;
	while(this._list[nextIndex] && this._list[nextIndex].code === 401){
		nextIndex++;
	}
	const command = this._list[nextIndex];
	if(command){
		return [102, 103, 104].contains(command.code);
	}else{
		return false;
	}
};//*
if(!eventSkip.valid) Game_Interpreter.prototype.nextIsChoice = function(){return false};


if(eventSkip.valid){
	//各選択肢系のコマンドは強制的にスキップを中断するように。そのため、再度スキップ設定が必要
	const _Game_Interpreter_prototype_setupChoices = Game_Interpreter.prototype.setupChoices;
	Game_Interpreter.prototype.setupChoices = function(params) {
		//params はMZでのみ渡される引数。MVではthis._paramsから参照する。
		if(this.sceneSkippable()) this.sceneStopSkipping();

	   _Game_Interpreter_prototype_setupChoices.apply(this, arguments);
	};//*

	const _Game_Interpreter_prototype_setupNumInput = Game_Interpreter.prototype.setupNumInput;
	Game_Interpreter.prototype.setupNumInput = function(params) {
		//params はMZでのみ渡される引数。MVではthis._paramsから参照する。
		if(this.sceneSkippable()) this.sceneStopSkipping();

	    _Game_Interpreter_prototype_setupNumInput.apply(this, arguments);
	};//*

	const _Game_Interpreter_prototype_setupItemChoice = Game_Interpreter.prototype.setupItemChoice;
	Game_Interpreter.prototype.setupItemChoice = function(params) {
		//params はMZでのみ渡される引数。MVではthis._paramsから参照する。
		if(this.sceneSkippable()) this.sceneStopSkipping();

	    _Game_Interpreter_prototype_setupItemChoice.apply(this, arguments);
	};//*


	const _Window_Message_prototype_isTriggered = Window_Message.prototype.isTriggered;
	Window_Message.prototype.isTriggered = function() {
	    const def = _Window_Message_prototype_isTriggered.apply(this, arguments);
	    return def || this.sceneSkipping();
	};//*

	const _Window_Message_prototype_terminateMessage = Window_Message.prototype.terminateMessage;
	Window_Message.prototype.terminateMessage = function() {
	    _Window_Message_prototype_terminateMessage.apply(this, arguments);
	    this.isInBattleScene() ? $gameTroop.restartSkipping() : $gameMap.restartSkipping();
	};//*


	const _Window_ScrollText_prototype_scrollSpeed = Window_ScrollText.prototype.scrollSpeed;
	Window_ScrollText.prototype.scrollSpeed = function() {
	    const defSpeed = _Window_ScrollText_prototype_scrollSpeed.apply(this, arguments);
	    return this.sceneSkipping() ? this.contentsHeight() : defSpeed;
	};//*
}////

Window_Message.prototype.isInBattleScene = function(){
	return SceneManager._scene.constructor.name === 'Scene_Battle';
};//*
if(!eventSkip.valid) Window_Message.prototype.isInBattleScene = function(){return false};


Window_Message.prototype.sceneSkipping = function(){
	return this.isInBattleScene() ? $gameTroop.eventSkipping() : $gameMap.eventSkipping();
};//*
if(!eventSkip.valid) Window_Message.prototype.sceneSkipping = function(){return false};


Window_ScrollText.prototype.isInBattleScene = function(){
	return Window_Message.prototype.isInBattleScene.call(this);
};//*
if(!eventSkip.valid) Window_ScrollText.prototype.isInBattleScene = function(){return false};


Window_ScrollText.prototype.sceneSkipping = function(){
	return Window_Message.prototype.sceneSkipping.call(this);
};//*
if(!eventSkip.valid) Window_ScrollText.prototype.sceneSkipping = function(){return false};
//show text end--------

if(eventSkip.valid){
	// check aborting case in Set Movement Route
	const _Game_Character_prototype_processMoveCommand = Game_Character.prototype.processMoveCommand;
	Game_Character.prototype.processMoveCommand = function(command) {
		if(!$gameMap.eventSkipping()){
			_Game_Character_prototype_processMoveCommand.apply(this, arguments);
		}else{
			var gc = Game_Character;
		    var params = command.parameters;
		    switch (command.code) {
		    case gc.ROUTE_END:
		        this.processRouteEnd();
		        break;
		    case gc.ROUTE_MOVE_DOWN:
		        this.moveSkipStraight(2);
		        break;
		    case gc.ROUTE_MOVE_LEFT:
		        this.moveSkipStraight(4);
		        break;
		    case gc.ROUTE_MOVE_RIGHT:
		        this.moveSkipStraight(6);
		        break;
		    case gc.ROUTE_MOVE_UP:
		        this.moveSkipStraight(8);
		        break;
		    case gc.ROUTE_MOVE_LOWER_L:
		        this.moveSkipDiagonally(4, 2);
		        break;
		    case gc.ROUTE_MOVE_LOWER_R:
		        this.moveSkipDiagonally(6, 2);
		        break;
		    case gc.ROUTE_MOVE_UPPER_L:
		        this.moveSkipDiagonally(4, 8);
		        break;
		    case gc.ROUTE_MOVE_UPPER_R:
		        this.moveSkipDiagonally(6, 8);
		        break;
		    case gc.ROUTE_MOVE_RANDOM:
		        this.moveSkipRandom();
		        break;
		    case gc.ROUTE_MOVE_TOWARD:
		        this.moveSkipTowardPlayer();
		        break;
		    case gc.ROUTE_MOVE_AWAY:
		        this.moveSkipAwayFromPlayer();
		        break;
		    case gc.ROUTE_MOVE_FORWARD:
		        this.moveSkipForward();
		        break;
		    case gc.ROUTE_MOVE_BACKWARD:
		        this.moveSkipBackward();
		        break;
		    case gc.ROUTE_JUMP:
		    	this.setPosition(this.x + params[0], this.y + params[1]);
		        break;
		    case gc.ROUTE_WAIT:
		        this._waitCount = 0;
		        break;
		    case gc.ROUTE_TURN_DOWN:
		        this.setDirection(2);
		        break;
		    case gc.ROUTE_TURN_LEFT:
		        this.setDirection(4);
		        break;
		    case gc.ROUTE_TURN_RIGHT:
		        this.setDirection(6);
		        break;
		    case gc.ROUTE_TURN_UP:
		        this.setDirection(8);
		        break;
		    case gc.ROUTE_TURN_90D_R:
		        this.turnRight90();
		        break;
		    case gc.ROUTE_TURN_90D_L:
		        this.turnLeft90();
		        break;
		    case gc.ROUTE_TURN_180D:
		        this.turn180();
		        break;
		    case gc.ROUTE_TURN_90D_R_L:
		        this.turnRightOrLeft90();
		        break;
		    case gc.ROUTE_TURN_RANDOM:
		        this.turnRandom();
		        break;
		    case gc.ROUTE_TURN_TOWARD:
		        this.turnTowardPlayer();
		        break;
		    case gc.ROUTE_TURN_AWAY:
		        this.turnAwayFromPlayer();
		        break;
		    case gc.ROUTE_SWITCH_ON:
		        $gameSwitches.setValue(params[0], true);
		        break;
		    case gc.ROUTE_SWITCH_OFF:
		        $gameSwitches.setValue(params[0], false);
		        break;
		    case gc.ROUTE_CHANGE_SPEED:
		        this.setMoveSpeed(params[0]);
		        break;
		    case gc.ROUTE_CHANGE_FREQ:
		        this.setMoveFrequency(params[0]);
		        break;
		    case gc.ROUTE_WALK_ANIME_ON:
		        this.setWalkAnime(true);
		        break;
		    case gc.ROUTE_WALK_ANIME_OFF:
		        this.setWalkAnime(false);
		        break;
		    case gc.ROUTE_STEP_ANIME_ON:
		        this.setStepAnime(true);
		        break;
		    case gc.ROUTE_STEP_ANIME_OFF:
		        this.setStepAnime(false);
		        break;
		    case gc.ROUTE_DIR_FIX_ON:
		        this.setDirectionFix(true);
		        break;
		    case gc.ROUTE_DIR_FIX_OFF:
		        this.setDirectionFix(false);
		        break;
		    case gc.ROUTE_THROUGH_ON:
		        this.setThrough(true);
		        break;
		    case gc.ROUTE_THROUGH_OFF:
		        this.setThrough(false);
		        break;
		    case gc.ROUTE_TRANSPARENT_ON:
		        this.setTransparent(true);
		        break;
		    case gc.ROUTE_TRANSPARENT_OFF:
		        this.setTransparent(false);
		        break;
		    case gc.ROUTE_CHANGE_IMAGE:
		        this.setImage(params[0], params[1]);
		        break;
		    case gc.ROUTE_CHANGE_OPACITY:
		        this.setOpacity(params[0]);
		        break;
		    case gc.ROUTE_CHANGE_BLEND_MODE:
		        this.setBlendMode(params[0]);
		        break;
		    case gc.ROUTE_PLAY_SE:
		        break;
		    case gc.ROUTE_SCRIPT:
		        eval(params[0]);
		        break;
		    }
		}
	};//*
}////

Game_CharacterBase.prototype.moveSkipStraight = function(d){
	this.setDirection(d);
	if(this.canPass(this.x, this.y, d)){	
        const x = $gameMap.roundXWithDirection(this._x, d);
        const y = $gameMap.roundYWithDirection(this._y, d);
        this.setPosition(x, y);
        this.increaseSteps();
	}
};//*
if(!eventSkip.valid) Game_CharacterBase.prototype.moveSkipStraight = function(d){};


Game_CharacterBase.prototype.moveSkipDiagonally = function(horz, vert) {
	if (this._direction === this.reverseDir(horz)) {
        this.setDirection(horz);
    }
    if (this._direction === this.reverseDir(vert)) {
        this.setDirection(vert);
    }
    if(this.canPassDiagonally(this._x, this._y, horz, vert)){
    	const x = $gameMap.roundXWithDirection(this._x, horz);
        const y = $gameMap.roundYWithDirection(this._y, vert);
        this.setPosition(x, y);
        this.increaseSteps();
    }
};//*
if(!eventSkip.valid) Game_CharacterBase.prototype.moveSkipDiagonally = function(horz, vert) {};


Game_Character.prototype.moveSkipRandom = function() {
    var d = 2 + Math.randomInt(4) * 2;
    this.moveSkipStraight(d);
};//*
if(!eventSkip.valid) Game_Character.prototype.moveSkipRandom = function() {};


Game_Character.prototype.moveSkipTowardPlayer = function() {
    this.turnTowardCharacter($gamePlayer);
    this.moveSkipStraight(this.direction());
};//*
if(!eventSkip.valid) Game_Character.prototype.moveSkipTowardPlayer = function() {};


Game_Character.prototype.moveSkipAwayFromPlayer = function() {
    this.turnAwayFromCharacter($gamePlayer);
    this.moveSkipStraight(this.direction());
};//*
if(!eventSkip.valid) Game_Character.prototype.moveSkipAwayFromPlayer = function() {};


Game_Character.prototype.moveSkipForward = function() {
	this.moveSkipStraight(this.direction());
};//*
if(!eventSkip.valid) Game_Character.prototype.moveSkipForward = function() {};


Game_Character.prototype.moveSkipBackward = function() {
    this.moveSkipStraight(this.reverseDir(this.direction()));
};//*
if(!eventSkip.valid) Game_Character.prototype.moveSkipBackward = function() {};
//set move route end-----

if(eventSkip.valid){
	//skip in Gather Followers
	const _Game_Interpreter_prototype_command217 = Game_Interpreter.prototype.command217;
	Game_Interpreter.prototype.command217 = function() {
		if(!$gameMap.eventSkipping()) return _Game_Interpreter_prototype_command217.apply(this, arguments);
	    
	    if (!$gameParty.inBattle()) {
	    	const followers = $gamePlayer._followers.visibleFollowers();
	        followers.every(function(follower) {
		        follower.setPosition($gamePlayer.x, $gamePlayer.y);
		    }, this);
	    }
	    return true;
	};//*
}////
//gather followers end

if(eventSkip.valid){
	//skip fade in Transfer Player
	const _Game_Interpreter_prototype_command201 = Game_Interpreter.prototype.command201;
	Game_Interpreter.prototype.command201 = function(params) {
		//params はMZでのみ渡される引数。MVではthis._paramsから参照する。
	    if(!$gameMap.eventSkipping()) return _Game_Interpreter_prototype_command201.apply(this, arguments);

	    if(MV){
	    		this._params[5] = 2;
	    		return _Game_Interpreter_prototype_command201.apply(this, arguments);
	    }else if(MZ){
	    		if ($gameParty.inBattle() || $gameMessage.isBusy()) {
			        return false;
			    }
			    let mapId, x, y;
			    if (params[0] === 0) {
			        // Direct designation
			        mapId = params[1];
			        x = params[2];
			        y = params[3];
			    } else {
			        // Designation with variables
			        mapId = $gameVariables.value(params[1]);
			        x = $gameVariables.value(params[2]);
			        y = $gameVariables.value(params[3]);
			    }
			    params[5] = 2;
			    $gamePlayer.reserveTransfer(mapId, x, y, params[4], params[5]);
			    this.setWaitMode("transfer");
			    return true;
	    }
	};//*


	// check aborting skip in screen events
	//in Tint Screen
	const _Game_Interpreter_prototype_command223 = Game_Interpreter.prototype.command223;
	Game_Interpreter.prototype.command223 = function(params) {
		//params はMZでのみ渡される引数。MVではthis._paramsから参照する。
		if(!this.sceneSkipping()) _Game_Interpreter_prototype_command223.apply(this, arguments);

		if(MV){
				this._params[1] = 1;
			    $gameScreen.startTint(this._params[0], this._params[1]);
			    if (this._params[2]) {
			        this.wait(this._params[1]);
			    }
		}else if(MZ){
				params[1] = 1;
				$gameScreen.startTint(params[0], params[1]);
			    if (params[2]) {
			        this.wait(params[1]);
			    }
		}
		
	    return true;
	};//*

	//in Move Picture
	const _Game_Interpreter_prototype_command232 = Game_Interpreter.prototype.command232;
	Game_Interpreter.prototype.command232 = function(params) {
		//params はMZでのみ渡される引数。MVではthis._paramsから参照する。
		if(!this.sceneSkipping()) return _Game_Interpreter_prototype_command232.apply(this, arguments);

		if(MV){
				var x, y;
			    if (this._params[3] === 0) {  // Direct designation
			        x = this._params[4];
			        y = this._params[5];
			    } else {  // Designation with variables
			        x = $gameVariables.value(this._params[4]);
			        y = $gameVariables.value(this._params[5]);
			    }
			    this._params[10] = 1;
			    $gameScreen.movePicture(this._params[0], this._params[2], x, y, this._params[6],
			        this._params[7], this._params[8], this._params[9], this._params[10]);
			    if (this._params[11]) {
			        this.wait(this._params[10]);
			    }	
		}else if(MZ){
				const point = this.picturePoint(params);
				params[10] = 1;
			    // prettier-ignore
			    $gameScreen.movePicture(
			        params[0], params[2], point.x, point.y, params[6], params[7],
			        params[8], params[9], params[10], params[12] || 0
			    );
			    if (params[11]) {
			        this.wait(params[10]);
			    }
		}
	    
	    return true;
	};//*

	//in Tint Picture
	const _Game_Interpreter_prototype_command234 = Game_Interpreter.prototype.command234;
	Game_Interpreter.prototype.command234 = function(params) {
		//params はMZでのみ渡される引数。MVではthis._paramsから参照する。
		if(!this.sceneSkipping()) return _Game_Interpreter_prototype_command234.apply(this, arguments);

		if(MV){
				this._params[2] = 1;
			    $gameScreen.tintPicture(this._params[0], this._params[1], this._params[2]);
			    if (this._params[3]) {
			        this.wait(this._params[2]);
			    }
		}else if(MZ){
				params[2] = 1;
				$gameScreen.tintPicture(params[0], params[1], params[2]);
			    if (params[3]) {
			        this.wait(params[2]);
			    }
		}
		
	    return true;
	};//*

	//in Set Weather Effect
	const _Game_Interpreter_prototype_command236 = Game_Interpreter.prototype.command236;
	Game_Interpreter.prototype.command236 = function(params) {
		//params はMZでのみ渡される引数。MVではthis._paramsから参照する。
		if(!$gameMap.eventSkipping()) return _Game_Interpreter_prototype_command236.apply(this, arguments);

		if(MV){
				if (!$gameParty.inBattle()) {
		    	this._params[2] = 1;
		        $gameScreen.changeWeather(this._params[0], this._params[1], this._params[2]);
		        if (this._params[3]) {
		            this.wait(this._params[2]);
		        }
		    }
		}else if(MZ){
				if (!$gameParty.inBattle()) {
					params[2] = 1;
			        $gameScreen.changeWeather(params[0], params[1], params[2]);
			        if (params[3]) {
			            this.wait(params[2]);
			        }
			    }
		}
	    
	    return true;
	};//*

	//screen events end--------

	//force to abort skipping in battle scene
	//in Battle Processing
	const _Game_Interpreter_prototype_command301 = Game_Interpreter.prototype.command301;
	Game_Interpreter.prototype.command301 = function(params) {
		//params はMZでのみ渡される引数。MVではthis._paramsから参照する。
	    if (!$gameParty.inBattle()) {
	    	if($gameMap.eventSkipping()) $gameMap.abortSkip();
	    	return _Game_Interpreter_prototype_command301.apply(this, arguments);
	    }
	    return true;
	};//*


	//in Force Action in battle
	const _Game_Interpreter_prototype_command339 = Game_Interpreter.prototype.command339;
	Game_Interpreter.prototype.command339 = function(params) {
		//params はMZでのみ渡される引数。MVではthis._paramsから参照する。
		if($gameTroop.eventSkipping()) $gameTroop.stopSkipping();
	    return _Game_Interpreter_prototype_command339.apply(this, arguments);
	};//*

	//force to abord skipping end

	const _Game_Interpreter_prototype_changeHp = Game_Interpreter.prototype.changeHp;
	Game_Interpreter.prototype.changeHp = function(target, value, allowDeath) {
		_Game_Interpreter_prototype_changeHp.apply(this, arguments);
	   
	    if (target.isDead() && target.collapseType() === 1) {
	        BattleManager.stopBeatingWait();
	    }
	    if(MV && $gameParty.inBattle() && $gameTroop.isAllDead()) BattleManager.processVictory();
	};//*

	// Change Enemy State
	if(MV){
		const _Game_Interpreter_prototype_command333 = Game_Interpreter.prototype.command333;
		Game_Interpreter.prototype.command333 = function() {
		    this.iterateEnemyIndex(this._params[0], function(enemy) {
		        var alreadyDead = enemy.isDead();
		        if (this._params[1] === 0) {
		            enemy.addState(this._params[2]);
		        } else {
		            enemy.removeState(this._params[2]);
		        }
		        if (enemy.isDead() && !alreadyDead) {
		            enemy.performCollapse();

		            if(enemy.collapseType() === 1 ){
		            	BattleManager.stopBeatingWait();
		            }
		        }
		        enemy.clearResult();
		    }.bind(this));

		    if(MV && $gameTroop.isAllDead()) BattleManager.processVictory();
		    return true;
		};
	}else if(MZ){
		const _Game_Interpreter_prototype_command333 = Game_Interpreter.prototype.command333;
		Game_Interpreter.prototype.command333 = function(params) {
		    this.iterateEnemyIndex(params[0], enemy => {
		        const alreadyDead = enemy.isDead();
		        if (params[1] === 0) {
		            enemy.addState(params[2]);
		        } else {
		            enemy.removeState(params[2]);
		        }
		        if (enemy.isDead() && !alreadyDead) {
		            enemy.performCollapse();

		            if(enemy.collapseType() === 1 ){
		            	BattleManager.stopBeatingWait();
		            }
		        }
		        enemy.clearResult();
		    });

		    if(MV && $gameTroop.isAllDead()) BattleManager.processVictory();
		    return true;
		};
	}
}////

	/*---マップシーンに、イベント中のスキップゲージを追加実装----*/


Game_Map.prototype.setSkippable = function(){
	if(this._interpreter){
		this._interpreter.setSkippable(true);
	}
};//*
if(!eventSkip.valid) Game_Map.prototype.setSkippable = function(){};

Game_Map.prototype.executeEventSkip = function(){
	if(this._interpreter){
		this._interpreter._lastFadeIn = true;
		this._interpreter.skipFadeOut();
		this._interpreter.setSkipping(true);
	}
};//*
if(!eventSkip.valid) Game_Map.prototype.executeEventSkip = function(){};


Game_Map.prototype.eventSkippable = function(){
	if(this._interpreter && this.isEventRunning()){
		return this._interpreter.isSkippable();
	}else{
		return false;
	}
};//*
if(!eventSkip.valid) Game_Map.prototype.eventSkippable = function(){return false};


Game_Map.prototype.eventSkipping = function(){
	if(this._interpreter && this.isEventRunning()){
		return this._interpreter.isSkipping();
	}else{
		return false;
	}
};//*
if(!eventSkip.valid) Game_Map.prototype.eventSkipping = function(){return false};


Game_Map.prototype.isStoppingSkipping = function(){
	if(this._interpreter && this.isEventRunning()){
		return this._interpreter._stopSkipping;
	}else{
		return false;
	}
};//*
if(!eventSkip.valid) Game_Map.prototype.isStoppingSkipping = function(){return false};


Game_Map.prototype.abortSkip = function(){
	if(this.eventSkipping()){
		this._interpreter.abortSkip();
		this._interpreter.skipFadeIn();
	}
};//*
if(!eventSkip.valid) Game_Map.prototype.abortSkip = function(){};


Game_Map.prototype.stopSkipping = function(){
	if(this._interpreter && this.isEventRunning()){
		this._interpreter._stopSkipping = true;

		this._interpreter.skipFadeIn();
	}
};//*
if(!eventSkip.valid) Game_Map.prototype.stopSkipping = function(){};


Game_Map.prototype.restartSkipping = function(){
	if(this.isStoppingSkipping()){
		if(this.eventSkipping()) this._interpreter.skipFadeOut();

		this._interpreter._stopSkipping = false;
	}
};//*
if(!eventSkip.valid) Game_Map.prototype.restartSkipping = function(){};
		

if(eventSkip.valid){
	const _Scene_Map_prototype_updateMain = Scene_Map.prototype.updateMain;
	Scene_Map.prototype.updateMain = function() {
	    _Scene_Map_prototype_updateMain.apply(this, arguments);

	    if($gameMap.eventSkippable() && !this.hasSkipGauge() ) this.callSkipGauge();	
	    if($gameMap.eventSkippable() &&  this.hasSkipGauge() ) this.updateSkipGauge();
	    if(!$gameMap.eventSkippable() && this.hasSkipGauge() ) this.clearSkipGauge();
	};//*
}////

Scene_Map.prototype.hasSkipGauge = function(){
	return !!this._skipBackGauge && !!this._skipGauge && !!this._skipText;
};//*
if(!eventSkip.valid) Scene_Map.prototype.hasSkipGauge = function(){return false};


Scene_Map.prototype.callSkipGauge = function(){
	const width = eventSkip.width;
	const height = eventSkip.height;
	const x = eventSkip.x;
	const y = eventSkip.y;
	this.setGaugeGeometryType(eventSkip.geometry);
	this.createSkipBackGauge(x, y, width, height);
	this.createSkipGauge(x, y, width, height);
	this.createSkipText(x, y, width, height);
};//*
if(!eventSkip.valid) Scene_Map.prototype.callSkipGauge = function(){};


Scene_Map.prototype.setGaugeGeometryType = function(type){
	this._gaugeGeometry = type || 'rect';
};//*
if(!eventSkip.valid) Scene_Map.prototype.setGaugeGeometryType = function(type){};


Scene_Map.prototype.gaugeGeometryType = function(){
	return this._gaugeGeometry;
};//*
if(!eventSkip.valid) Scene_Map.prototype.gaugeGeometryType = function(){return false};


Scene_Map.prototype.createSkipBackGauge = function(x, y, width, height){
	this._skipBackGauge = new Sprite();
	this._skipBackGauge.bitmap = new Bitmap(Graphics.boxWidth, Graphics.boxHeight);
	this._skipBackGauge.gaugeLength = width;
	if(this.gaugeGeometryType() === 'rect'){
			this._skipBackGauge.bitmap.fillRect(x-3, y-3, width+6, height+6, 'black');
			this._skipBackGauge.bitmap.fillRect(x, y, width, height, 'rgb(100,32,18)');
	}else if(this.gaugeGeometryType() === 'circle'){
			this._skipBackGauge.bitmap.drawCircle(x, y, (height+6)/2, 'black');
			this._skipBackGauge.bitmap.drawCircle(x, y, height/2, 'rgb(100,32,18)');
	}
	this.addChild(this._skipBackGauge);
	this._skipBackGauge.width = Graphics.boxWidth;
	this._skipBackGauge.height = Graphics.boxHeight;
};//*
if(!eventSkip.valid) Scene_Map.prototype.createSkipBackGauge = function(x, y, width, height){};


Scene_Map.prototype.createSkipGauge = function(x, y, width, height){
	this._skipGauge = new Sprite();
	this._skipGauge.bitmap = new Bitmap(Graphics.boxWidth, Graphics.boxHeight);
	this._skipGauge.gaugeX = x;
	this._skipGauge.gaugeY = y;
	this._skipGauge.gaugeLength = $gameMap.eventSkipping()? width : 0;
	this._skipGauge.gaugeHeight = height;
	this.drawSkipGauge();
	this.addChild(this._skipGauge);
	this._skipGauge.width = Graphics.boxWidth;
	this._skipGauge.height = Graphics.boxHeight;
};//*
if(!eventSkip.valid) Scene_Map.prototype.createSkipGauge = function(x, y, width, height){};


Scene_Map.prototype.createSkipText = function(x, y, width, height){
	this._skipText = new Sprite();
	this._skipText.bitmap = new Bitmap(Graphics.boxWidth, Graphics.boxHeight);
	this._skipText.bitmap.fontSize = eventSkip.fontSize || this._skipText.bitmap.fontSize;
	const geo = this.gaugeGeometryType();
	//key name
	const buttonName = keyName(eventSkip.skipButton);
	const buttonX = geo === 'rect' ? x : x - height/2;
	const buttonY = geo === 'rect' ? y : y - height/2;
	const buttonWidth = geo === 'rect' ? width : height;
	this._skipText.bitmap.drawText(buttonName, buttonX, buttonY, buttonWidth, height, 'center');

	//skip text
	const text = eventSkip.text;
	const textX = x + (geo === 'rect' ? width : height/2) + 10;
	const textY = buttonY;
	const textWidth = Graphics.boxWidth - x;
	this._skipText.bitmap.drawText(text, textX, textY, textWidth, height, 'left');
	this.addChild(this._skipText);
	this._skipText.width = Graphics.boxWidth;
	this._skipText.height = Graphics.boxHeight;
};//*
if(!eventSkip.valid) Scene_Map.prototype.createSkipText = function(x, y, width, height){};


Scene_Map.prototype.clearSkipGauge = function(){
	this.removeChild(this._skipBackGauge);
	this.removeChild(this._skipGauge);
	this.removeChild(this._skipText);
	this._skipBackGauge = null;
	this._skipGauge = null;
	this._skipText = null;
};//*
if(!eventSkip.valid) Scene_Map.prototype.clearSkipGauge = function(){};


Scene_Map.prototype.updateSkipGauge = function(){
	if(Input.isPressed(eventSkip.skipButton) && this.skipGaugeVisible()){
			this.gainSkipGauge(eventSkip.offset);
			if(this.isMaxSkipGauge()) $gameMap.executeEventSkip();		
	}else{
			if(!this.isMaxSkipGauge()) this.gainSkipGauge(-1 * eventSkip.offset);
	}

	if($gameMap.isStoppingSkipping() && this.skipGaugeVisible()){
		this.hideSkipGauge();
	}
	if(!$gameMap.isStoppingSkipping() && !this.skipGaugeVisible()){
		this.showSkipGauge();
	}
};//*
if(!eventSkip.valid) Scene_Map.prototype.updateSkipGauge = function(){};


Scene_Map.prototype.clampSkipGauge = function(){
	const maxWidth = this._skipBackGauge.gaugeLength;
	this._skipGauge.gaugeLength = this._skipGauge.gaugeLength.clamp(0, maxWidth);
};//*
if(!eventSkip.valid) Scene_Map.prototype.clampSkipGauge = function(){};


Scene_Map.prototype.gainSkipGauge = function(value){
	this._skipGauge.gaugeLength += value;
	this.clampSkipGauge();
	this.drawSkipGauge();
};//*
if(!eventSkip.valid) Scene_Map.prototype.gainSkipGauge = function(value){};


Scene_Map.prototype.drawSkipGauge = function(){
	const x = this._skipGauge.gaugeX;
	const y = this._skipGauge.gaugeY;
	const width = this._skipGauge.gaugeLength;
	const height = this._skipGauge.gaugeHeight;
	this._skipGauge.bitmap.clear();
	if(this.gaugeGeometryType() === 'rect'){	
			this._skipGauge.bitmap.fillRect(x, y, width, height, 'yellow');
	}else if(this.gaugeGeometryType() === 'circle'){
			const context = this._skipGauge.bitmap._context;
			context.beginPath(); //超重要工程！！
			context.moveTo(x, y); //超重要工程！！
			context.fillStyle = 'yellow';
			context.arc(x, y, height/2, -1 * Math.PI/2, this.gaugeAngle(), false);
			context.fill();
			this._skipGauge.bitmap.drawCircle(x, y, height/4, 'black');
	}
};//*
if(!eventSkip.valid) Scene_Map.prototype.drawSkipGauge = function(){};


Scene_Map.prototype.gaugeAngle = function(){
	const rate = this._skipGauge.gaugeLength / this._skipBackGauge.gaugeLength;
	return Math.PI * 2 * rate - Math.PI/2;
};//*
if(!eventSkip.valid) Scene_Map.prototype.gaugeAngle = function(){return 0};


Scene_Map.prototype.isMaxSkipGauge = function(){
	return this._skipGauge.gaugeLength >= this._skipBackGauge.gaugeLength;
};//*
if(!eventSkip.valid) Scene_Map.prototype.isMaxSkipGauge = function(){return false};


Scene_Map.prototype.skipGaugeVisible = function(){
	return this._skipGauge.visible;
};//*
if(!eventSkip.valid) Scene_Map.prototype.skipGaugeVisible = function(){return false};


Scene_Map.prototype.hideSkipGauge = function(){
	this._skipBackGauge.visible = false;
	this._skipGauge.visible = false;
	this._skipText.visible = false;
};//*
if(!eventSkip.valid) Scene_Map.prototype.hideSkipGauge = function(){};


Scene_Map.prototype.showSkipGauge = function(){
	this._skipBackGauge.visible = true;
	this._skipGauge.visible = true;
	this._skipText.visible = true;
};//*
if(!eventSkip.valid) Scene_Map.prototype.showSkipGauge = function(){};


	/*------------戦闘シーンにもイベントスキップを使えるように----------------*/

Game_Troop.prototype.setSkippable = function(){
	Game_Map.prototype.setSkippable.call(this);
};//*

Game_Troop.prototype.executeEventSkip = function(){
	Game_Map.prototype.executeEventSkip.call(this);
};//*

Game_Troop.prototype.eventSkippable = function(){
	return Game_Map.prototype.eventSkippable.call(this);
};//*

Game_Troop.prototype.eventSkipping = function(){
	return Game_Map.prototype.eventSkipping.call(this);
};//*

Game_Troop.prototype.isStoppingSkipping = function(){
	return Game_Map.prototype.isStoppingSkipping.call(this);
};//*

Game_Troop.prototype.abortSkip = function(){
	Game_Map.prototype.abortSkip.call(this);
};//*

Game_Troop.prototype.stopSkipping = function(){
	Game_Map.prototype.stopSkipping.call(this);
};//*

Game_Troop.prototype.restartSkipping = function(){
	Game_Map.prototype.restartSkipping.call(this);
};//*

if(eventSkip.valid){
	const _Scene_Battle_prototype_update = Scene_Battle.prototype.update;
	Scene_Battle.prototype.update = function() {
	    _Scene_Battle_prototype_update.apply(this, arguments);

	    if($gameTroop.eventSkippable() && !this.hasSkipGauge() ) this.callSkipGauge();	
	    if($gameTroop.eventSkippable() &&  this.hasSkipGauge() ) this.updateSkipGauge();
	    if(!$gameTroop.eventSkippable() && this.hasSkipGauge() ) this.clearSkipGauge();
	};//*
}////


Scene_Battle.prototype.hasSkipGauge = function(){
	return Scene_Map.prototype.hasSkipGauge.call(this);
};//*

Scene_Battle.prototype.callSkipGauge = function(){
	Scene_Map.prototype.callSkipGauge.call(this);
};//*

Scene_Battle.prototype.setGaugeGeometryType = function(type){
	Scene_Map.prototype.setGaugeGeometryType.call(this, type);
};//*

Scene_Battle.prototype.gaugeGeometryType = function(){
	return Scene_Map.prototype.gaugeGeometryType.call(this);
};//*

Scene_Battle.prototype.createSkipBackGauge = function(x, y, width, height){
	Scene_Map.prototype.createSkipBackGauge.call(this, x, y, width, height);
};//*

Scene_Battle.prototype.createSkipGauge = function(x, y, width, height){
	//これだけScene_Mapを使いまわそうとすると、"0に_skipGaugeのプロパティは作れません"と吐かれた
	this._skipGauge = new Sprite();
	this._skipGauge.bitmap = new Bitmap(Graphics.boxWidth, Graphics.boxHeight);
	this._skipGauge.gaugeX = x;
	this._skipGauge.gaugeY = y;
	this._skipGauge.gaugeLength = $gameTroop.eventSkipping()? width : 0;
	this._skipGauge.gaugeHeight = height;
	this.drawSkipGauge();
	this.addChild(this._skipGauge);
	this._skipGauge.width = Graphics.boxWidth;
	this._skipGauge.height = Graphics.boxHeight;
};//*
if(!eventSkip.valid) Scene_Battle.prototype.createSkipGauge = function(x, y, width, height){};


Scene_Battle.prototype.createSkipText = function(x, y, width, height){
	Scene_Map.prototype.createSkipText.call(this, x, y, width, height);
};//*

Scene_Battle.prototype.clearSkipGauge = function(){
	Scene_Map.prototype.clearSkipGauge.call(this);
};//*

Scene_Battle.prototype.updateSkipGauge = function(){
	if(Input.isPressed(eventSkip.skipButton)　&& this.skipGaugeVisible()){
			this.gainSkipGauge(eventSkip.offset);
			if(this.isMaxSkipGauge()) $gameTroop.executeEventSkip();		
	}else{
			if(!this.isMaxSkipGauge()) this.gainSkipGauge(-1 * eventSkip.offset);
	}

	if($gameTroop.isStoppingSkipping() && this.skipGaugeVisible()){
		this.hideSkipGauge();
	}
	if(!$gameTroop.isStoppingSkipping() && !this.skipGaugeVisible()){
		this.showSkipGauge();
	}
};//*

Scene_Battle.prototype.clampSkipGauge = function(){
	Scene_Map.prototype.clampSkipGauge.call(this);
};//*

Scene_Battle.prototype.gainSkipGauge = function(value){
	Scene_Map.prototype.gainSkipGauge.call(this, value);
};//*

Scene_Battle.prototype.drawSkipGauge = function(){
	Scene_Map.prototype.drawSkipGauge.call(this);
};//*

Scene_Battle.prototype.gaugeAngle = function(){
	return Scene_Map.prototype.gaugeAngle.call(this);
};//*

Scene_Battle.prototype.isMaxSkipGauge = function(){
	return Scene_Map.prototype.isMaxSkipGauge.call(this);
};//*

Scene_Battle.prototype.skipGaugeVisible = function(){
	return Scene_Map.prototype.skipGaugeVisible.call(this);
};//*

Scene_Battle.prototype.hideSkipGauge = function(){
	Scene_Map.prototype.hideSkipGauge.call(this);
};//*

Scene_Battle.prototype.showSkipGauge = function(){
	Scene_Map.prototype.showSkipGauge.call(this);
};//*


/*-----------------------------------------------------------------*/
//ピクチャの回転について、直下に角度を書いたラベルをつけることでウェイトを使わずに指定の角度へ調整できるように
const _Game_Interpreter_prototype_command233 = Game_Interpreter.prototype.command233;
Game_Interpreter.prototype.command233 = function(params) {
	//params はMZでのみ渡される引数。MVではthis._paramsから参照する。
	const command = this._list[this._index + 1];
	if(command && command.code === 118 && command.parameters[0]){
		const angle = Number(command.parameters[0]);
		if(typeof angle === 'number'){
				const id = MV ? this._params[0] : params[0];
				$gameScreen.picture(id)._angle = angle;
		}else{
				return _Game_Interpreter_prototype_command233.apply(this, arguments);
		}
			
	}else{
		return _Game_Interpreter_prototype_command233.apply(this, arguments);
	}
    return true;
};//*


/*--------------メソッド強化　end-------------------------------------*/

/*************************************************************************************************/

/*------------enhancing----------------------------------------------
						スーパークラスの生成
--------------------------------------------------------------------*/

//------------実行ダイアログの定義---------------------//
class Window_ExecuteCommand extends Window_HorzCommand{
	constructor(){
		super();
		this._resizeWidth = true;
		this.resizeWidth();
	};//*

	maxCols (){
		return 2;
	};//*

	makeCommandList (){
		//this.addCommand(, 'ok');
		//this.addCommand(, 'cancel');
	};//*

	needResizeWidth (){
		return this._resizeWidth;
	};//*

	resizeWidth (){
		if(MZ && this.needResizeWidth()){
			const scene = SceneManager._scene;
			if(!scene) return;
			
			const dialog = scene._executeDialog || scene._dialogWindow || scene._decideDialogWindow;
			if(!dialog) return;

			this.width = dialog.width;
			this.x = dialog.x;
			if(!this._height) this._height = this.windowHeight();
			this.refresh();
			this._resizeWidth = false;
		}
	};//*

	drawItem (index) {
	    var rect = this.itemRectForText(index);
		var align = this.itemTextAlign();
	    this.resetTextColor();
		this.changePaintOpacity(this.isCommandEnabled(index));
	    this.drawText(this.commandName(index), rect.x, rect.y, rect.width, align);
	};

};//*Window_ExecuteCommand

	window[Window_ExecuteCommand.name] = Window_ExecuteCommand;


class Window_ExecuteDialog extends Window_Base{
	constructor(){
		let width = Graphics.boxWidth / 2;
		let height = Graphics.boxHeight / 3;
		let x = width / 2;
		let y = (Graphics.boxHeight - height )/ 2;
		super(x, y, width, height);
	};//*

	refresh (){
		if(this.contents){
			this.contents.clear();
		}				
	};//*

	drawDialog (text){
		if(this.contents) this.contents.clear();
		const x = 0;
		const y = Math.floor(this.height / 2)  - this.lineHeight();
		this.drawText(text, x, y, this.contentsWidth(), 'center');
	};//*

};//*Window_ExecuteDialog

	window[Window_ExecuteDialog.name] = Window_ExecuteDialog;

//------------操作ヘルプウィンドウの定義---------------------//
class Window_OperatorBase extends Window_Base{
		constructor(){
			let width = Graphics.boxWidth;
			let height = Graphics.boxHeight;
			super(0, 0, width, height);
			if(MZ) this._padding = this.itemPadding();
		};//*

		standardFontSize (){
			return windowBaseSet.operatorFontSize || 18;
		};//*

		standardPadding (){
			return 6;
		};//*

		itemPadding (){
			return 6;
		};//* for MZ

		contentsHeight (){
			return this.height;
		};//*

		setRegionWindow (regionWindow){
			if(regionWindow){
				this._regionWindow = regionWindow;
			}
		};//*

		refresh (){
			if(this.contents){
				this.contents.clear();
				this.drawOperator();
			}
		};//*

		drawOperator (){
			if(this._regionWindow && this._regionWindow.active){
				const modeF 	= this._regionWindow.isFilter();
				const keyShift 	= keyName(keyOfShift) + ' : ';
				const id 		= !modeF ? 0 : 1;
				const shift 	= $gameGuide.operateShift(id);
				const keyLr 	= keyName(keyOfArrowLR) + ' : ';
				const lr 		= $gameGuide.operateCursor();
				const text = keyShift + shift + '　　　' + keyLr + lr;
				this.drawText(text, 0, 0, this.contentsWidth(), 'right');
			}
		};//*
};//*Window_OperatorBase

	window[Window_OperatorBase.name] = Window_OperatorBase;	

//------------操作ヘルプウィンドウを作るシーン挙動の定義---------------------//
Scene_Base.prototype.createOperatorWindow = function(){
	this._operatorWindow = new Window_OperatorBase();
	this.addChild(this._operatorWindow);
};//*

Scene_Item.prototype.createOperatorWindow = function(){
	this._operatorWindow = new Window_ItemOperator();
	this._operatorWindow.setRegionWindow(this._itemWindow);
	this._operatorWindow.width = this._itemWindow.width;
	this._operatorWindow.height = this._operatorWindow.lineHeight();
	this._operatorWindow.x = this._itemWindow.x;
	this._operatorWindow.y = Graphics.boxHeight - this._operatorWindow.height;
	this._itemWindow.height -= this._operatorWindow.height;
	if(MZ) this._helpWindow.y -= this._operatorWindow.height;
	this.addChild(this._operatorWindow);
	
	this._operatorWindow.setBackgroundType(1);
	if(this._fravorWindow) this._operatorWindow.setFravorWindow(this._fravorWindow);
};//*

class Window_ItemOperator extends Window_OperatorBase{
		constructor (){
			super();
			this._operatorWidth = 0;
			this._needRedraw = false;
		};//*

		setFravorWindow (fravorWindow){
			if(fravorWindow){
				this._fravorWindow = fravorWindow;
			}
		};//*

		update (){
			super.update();
			if(this.enableUpdate()){
				if(!this._needRedraw){
					this.refresh();
					this._needRedraw = true;
				}
			}else if(this.contents){
				this.contents.clear();
				this._operatorWidth = 0;
				this._needRedraw = false;
			}
		};//*

		enableUpdate (){
			return this._regionWindow && this._regionWindow.active;
			//regionWindow means itemWindow
		};//*

		drawOperator(){}

		operatorWidth (){
			return this.contentsWidth() - this._operatorWidth;
		};//*

		addOperatorWidth (text, keyText){
			this._operatorWidth += this.textWidth(text);
			if(keyText) this._operatorWidth += this.textWidth('000');
		};//*
}//*Window_ItemOperator

	window[Window_ItemOperator.name] = Window_ItemOperator;

Scene_Skill.prototype.createOperatorWindow = function(){
	this._operatorWindow = new Window_SkillOperator();
	this._operatorWindow.setRegionWindow(this._itemWindow);
	this._operatorWindow.width = this._itemWindow.width;
	this._operatorWindow.height = this._operatorWindow.lineHeight();
	this._operatorWindow.x = this._itemWindow.x;
	this._operatorWindow.y = Graphics.boxHeight - this._operatorWindow.height;
	this._itemWindow.height -= this._operatorWindow.height;
	if(MZ) this._helpWindow.y -= this._operatorWindow.height;
	this.addChild(this._operatorWindow);

	this._operatorWindow.setBackgroundType(1);
	if(this._fravorWindow) this._operatorWindow.setFravorWindow(this._fravorWindow);
};//*

class Window_SkillOperator extends Window_OperatorBase{
		constructor (){
			super();
			this._operatorWidth = 0;
			this._needRedraw = false;
		};//*

		setFravorWindow (fravorWindow){
			if(fravorWindow){
				this._fravorWindow = fravorWindow;
			}
		};//*

		update (){
			super.update();
			if(this.enableUpdate()){
				if(!this._needRedraw){
					this.refresh();
					this._needRedraw = true;	
				}
			}else if(this.contents){
				this.contents.clear();
				this._needRedraw = false;
				this._operatorWidth = 0;
			}
		};//*

		enableUpdate (){
			return this._regionWindow && this._regionWindow.active;
			//regionWindow means itemWindow
		};//*

		drawOperator(){}

		operatorWidth (){
			return this.contentsWidth() - this._operatorWidth;
		};//*

		addOperatorWidth (text, keyText){
			this._operatorWidth += this.textWidth(text);
			if(keyText) this._operatorWidth += this.textWidth('000');
		};//*
}//*Window_SkillOperator

	window[Window_SkillOperator.name] = Window_SkillOperator;


//------------シーンリフレッシュ用シーンの定義---------------------//
class Scene_Refresher extends Scene_Base{
			constructor(){
				super();
			};//*

			create (){
				this.createBackground();
			};//*

			createBackground () {
				this._backgroundSprite = new Sprite();
			    this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
			    this.addChild(this._backgroundSprite);
			};//*

			update (){
				super.update();
				this.popScene();
			};//*
	};//*Scene_Refresher

	window[Scene_Refresher.name] = Scene_Refresher;

/*------------------スーパークラスの生成 end----------------------------------------*/

/********************************************************************************************/
/*-------------------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------------------*/
/********************************************************************************************/


/*-------structing Config------------------------------------------
				コンフィグの拡張設定

			 ___ 	 ___ 			 ___ 		 ___
			|		|	|	|\	|	|		|	| 
			|		|	|	| \	|	|---	|	|  ___
			|___ 	|___|	|  \|	|		|	|___|

	--------------------------------------------------------------*/

/********************************************************************************************/
/*-------------------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------------------*/
/********************************************************************************************/

/*-------------一般オプションコマンドの設定-------------------*/
//この機能には統括スイッチが存在しないので、MELOS実装中はいつでも適用可能

		/*~struct~ConfigGeneralCommands:ja
		@param alwaysDash
		@type 	boolean
		@text 	常時ダッシュの表示
		@desc 	On（true）のとき、常時ダッシュの項目が表示されます。
		@default true

		@param initialAlwaysDash
		@type 	boolean
		@text 	常時ダッシュの初期値
		@desc 	初回ゲーム起動時、常時ダッシュのOn/Offを設定します。これは表示に関わらず有効です。
		@default false

		@param commandRemember
		@type 	boolean
		@text 	コマンド記憶の表示
		@desc 	On（true）のとき、コマンド記憶の項目が表示されます。
		@default true

		@param initialCommandRemember
		@type 	boolean
		@text 	コマンド記憶の初期値
		@desc 	初回ゲーム起動時、コマンド記憶のOn/Offを設定します。これは表示に関わらず有効です。
		@default false

		@param touchUI
		@type 	boolean
		@text 	タッチUIの表示
		@desc 	On（true）のとき、タッチUIの項目が表示されます。（MZ用）
		@default true

		@param initialTouchUI
		@type 	boolean
		@text 	タッチUIの初期値
		@desc 	初回ゲーム起動時、コマンド記憶のOn/Offを設定します。これは表示に関わらず有効です。（MZ用）
		@default false
		*/
		/*----------------------------------------------------------------------------------------------*/
		/*~struct~ConfigGeneralCommands:
		@param alwaysDash
		@type 	boolean
		@text 	display alwaysDash
		@desc 	Display the command of alwaysDash on Option Window when this is true
		@default true

		@param initialAlwaysDash
		@type 	boolean
		@text 	initial value of alwaysDash
		@desc 	Initialize alwaysDash; this is valid even when the command is not displayed
		@default false

		@param commandRemember
		@type 	boolean
		@text 	display commandRemember
		@desc 	Display the command of commandRemember on Option Window when this is true
		@default true

		@param initialCommandRemember
		@type 	boolean
		@text 	initial value of commandRemember
		@desc 	Initialize commandRemember; this is valid even when the command is not displayed
		@default true

		@param touchUI
		@type 	boolean
		@text 	display touchUI
		@desc 	Display the command of touchUI on Option Window when this is true (paremter for MZ)
		@default true

		@param initialTouchUI
		@type 	boolean
		@text 	initial value of touchUI
		@desc 	Initialize touchUI; this is valid even when the command is not displayed (parameter for MZ)
		@default false
		*/

		const parseConfigGeneralCommands = s => JSON.parse(s, (key, value) => {
			switch(key){
				case 'alwaysDash' 				: return value;
				case 'initialAlwaysDash'		: return value;
				case 'commandRemember' 			: return value;
				case 'initialCommandRemember' 	: return value;
				case 'touchUI' 					: return value;
				case 'initialTouchUI' 			: return value;
				default 						: return value;
			};
		});//*

		let configGeneralCommands = params.configGeneralCommands;
		let consolerNameGeneralCommands = 'generalCommands:'
		if(configGeneralCommands){
			configGeneralCommands = parseConfigGeneralCommands(configGeneralCommands);
			configGeneralCommands = stringToBoolean(configGeneralCommands);
		}else{
			configGeneralCommands = makeNotValid();
			undefinedStructs.push(consolerNameGeneralCommands);
			consolerNameGeneralCommands += makeInvalidTerm();
		};
		
		consoler(consolerNameGeneralCommands, configGeneralCommands);

const _Window_Options_prototype_addGeneralOptions = Window_Options.prototype.addGeneralOptions;
Window_Options.prototype.addGeneralOptions = function() {
    if(configGeneralCommands.alwaysDash) 		this.addCommand(TextManager.alwaysDash, 'alwaysDash');
    if(configGeneralCommands.commandRemember) 	this.addCommand(TextManager.commandRemember, 'commandRemember');
    if(configGeneralCommands.touchUI) 			this.addCommand(TextManager.touchUI, 'touchUI');
};//*

if(MV){
		const _ConfigManager_load = ConfigManager.load;
		ConfigManager.load = function() {
		    var json;
		    var config = {};
		    try {
		        json = StorageManager.load(-1);
		    } catch (e) {
		        console.error(e);
		    }
		    if (json) {
		        config = JSON.parse(json);
		    }else{
		    	config.alwaysDash        = configGeneralCommands.initialAlwaysDash || false;
				config.commandRemember   = configGeneralCommands.initialCommandRemember || false;
		    }
		    this.applyData(config);
		};//*
}//MZではプラグインを読み込んだ時点でConfigManager.loadの初回が済んでいるため、DataManager.createObjectsで上書き指示をする



ConfigManager.setAlwaysDash = function(value){
	this.alwaysDash = value;
	this.save();
};//*

ConfigManager.setCommandRemember = function(value){
	this.commandRemember = value;
	this.save();
};//*

ConfigManager.setTouchUI = function(value){
	this.touchUI = value;
	this.save();
};//*




/*-------------難易度設定の導入----------------------------------*/

		/*~struct~ConfigDifficulty:ja
		@param 	type
		@type 		select
		@text 		難易度のタイプ
		@desc 		難易度の種類を設定します。無しの時、MELOSによる難易度設定はOffになります。
		@default 	none

				@option 	無し（実装しません）
				@value 	none

				@option 	段階方式（easy hard 形式）
				@value 	level

				@option 	無段階方式 (1.0 ~ 9.9 形式)
				@value 	stepless
		
		@param 	displayOption
		@type 		boolean
		@text 		オプションへの表示
		@desc 		On（true）の時、オプションメニューに難易度の項目が追加されます。実装の是非とは関係ありません。
		@default 	true

		@param 	name
		@type 		string
		@text 		表示名
		@desc 		オプションウィンドウで表示する名前を設定します。
		@default 	難易度

		@param 	variable
		@type 		variable
		@text 		格納変数
		@desc 		難易度を値として格納する変数を設定します。段階方式は数値に変換されます。
		@default 	0
		*/
		/*----------------------------------------------------------------------------------------------*/
		/*~struct~ConfigDifficulty:
		@param 	type
		@type 		select
		@text 		type of difficulty
		@desc 		Select a type of difficulty
		@default 	none

				@option 	none（no difficulty in MELOS）
				@value 	none

				@option 	level（type of easy hard）
				@value 	level

				@option 	stepless (type of 1.0 ~ 9.9 )
				@value 	stepless

		@param 	displayOption
		@type 		boolean
		@text 		Added to option window
		@desc 		Add difficulty to option window when this is true
		@default 	true

		@param 	name
		@type 		string
		@text 		name of difficulty
		@desc 		Define difficulty's name displayed in option window
		@default 	Mode

		@param 	variable
		@type 		variable
		@text 		variable for difficulty
		@desc 		Select a variable for difficulty; value is exchanged for a number when "type" is level
		@default 	0
		*/

				
		const parseConfigDifficulty = s => JSON.parse(s, (key, value) => {
			switch(key){
				case 'type' 			: return value;
				case 'name' 			: return value;
				case 'variable' 		: return Number.parseFloat(value);
				case 'displayOption' 	: return value;
				default 		: return value;
			};
		});//*

		let configDifficulty = params.configDifficulty;
		let consolerNameDifficulty = 'difficulty:'
		if(configDifficulty){
			configDifficulty = parseConfigDifficulty(configDifficulty);
			configDifficulty = stringToBoolean(configDifficulty);
		}else{
			configDifficulty = makeNotValid();
			undefinedStructs.push(consolerNameDifficulty);
			consolerNameDifficulty += makeInvalidTerm();
		};
		
		consoler(consolerNameDifficulty, configDifficulty);

			//------段階方式における詳細設定

				/*~struct~DifLevel:ja
				@param 	initial
				@type 		number
				@text 		デフォルト難易度
				@desc 		ニューゲームでのデフォルト難易度を設定します。
				@max 		4
				@decimals 	0
				@default 	0

				@param 	name0
				@type 		string
				@text 		最低難易度名
				@desc 		該当する難易度の名前を設定します。空欄にすると、作中の難易度から除外されます。
				@default 	beginner

				@param 	name1
				@type 		string
				@text 		低難易度名
				@desc 		該当する難易度の名前を設定します。空欄にすると、作中の難易度から除外されます。
				@default 	easy

				@param 	name2
				@type 		string
				@text 		通常難易度名
				@desc 		該当する難易度の名前を設定します。空欄にすると、作中の難易度から除外されます。
				@default 	normal

				@param 	name3
				@type 		string
				@text 		高難易度名
				@desc 		該当する難易度の名前を設定します。空欄にすると、作中の難易度から除外されます。
				@default 	hard

				@param 	name4
				@type 		string
				@text 		最高難易度名
				@desc 		該当する難易度の名前を設定します。空欄にすると、作中の難易度から除外されます。
				@default 	lunatic
				*/
				/*---------------------------------------------------------------------------------------*/
				/*~struct~DifLevel:
				@param 	initial
				@type 		number
				@text 		initial difficulty
				@desc 		Control initial difficulty
				@max 		4
				@decimals 	0
				@default 	0

				@param 	name0
				@type 		string
				@text 		lowest difficulty name
				@desc 		Define the name; when empty name, the difficulty is excepted from the list
				@default 	beginner

				@param 	name1
				@type 		string
				@text 		lower difficulty name
				@desc 		Define the name; when empty name, the difficulty is excepted from the list
				@default 	easy

				@param 	name2
				@type 		string
				@text 		normal difficulty name
				@desc 		Define the name; when empty name, the difficulty is excepted from the list
				@default 	normal

				@param 	name3
				@type 		string
				@text 		higher difficulty name
				@desc 		Define the name; when empty name, the difficulty is excepted from the list
				@default 	hard

				@param 	name4
				@type 		string
				@text 		highest difficulty name
				@desc 		Define the name; when empty name, the difficulty is excepted from the list
				@default 	lunatic
				*/


			//-----無段階方式での詳細設定

				/*~struct~DifStepless:ja
				@param 	initial
				@type 		number
				@text 		デフォルト難易度
				@desc 		ニューゲームでのデフォルト難易度を設定します。
				@default 	1
				@decimals 	0

				@param 	offset
				@type 		number
				@text 		変動値
				@desc 		オプションでの１操作あたりの変動値を設定します。小数第1位まで使えます。
				@default 	1
				@decimals 	1

				@param 	max
				@type 		number
				@text 		難易度上限値
				@desc 		オプションで操作できる値の上限値を設定します。小数第1位まで使えます。
				@default 	10.0
				@decimals 	1

				@param 	min
				@type 		number
				@text 		難易度下限値
				@desc 		オプションで操作できる値の下限値を設定します。小数第1位まで使えます。
				@default 	0.0
				@decimals 	1
				*/
				/*---------------------------------------------------------------------------------------*/
				/*~struct~DifStepless:
				@param 	initial
				@type 		number
				@text 		initial difficulty
				@desc 		Control initial difficulty
				@default 	1
				@decimals 	0

				@param 	offset
				@type 		number
				@text 		offset of difficulty
				@desc 		Control offset of difficulty; enable the first decimal
				@default 	1
				@decimals 	1

				@param 	max
				@type 		number
				@text 		max value of difficulty
				@desc 		Control max value of difficulty; enable the first decimal
				@default 	10.0
				@decimals 	1

				@param 	min
				@type 		number
				@text 		minimum value of difficulty
				@desc 		Control minimum value of difficulty; enable the first decimal
				@default 	0.0
				@decimals 	1
				*/

		const parseDifficulty = s => JSON.parse(s, (key, value) => {
				switch(key){
					case 'initial' 	: return Number.parseFloat(value);
					case 'name0' 	: return value;
					case 'name1' 	: return value;
					case 'name2' 	: return value;
					case 'name3' 	: return value;
					case 'name4' 	: return value;

					case 'offset' 	: return Number.parseFloat(value);
					case 'max'  	: return Number.parseFloat(value);
					case 'min'  	: return Number.parseFloat(value);
					default 		: return value;
				};
		});//*

		let difLevel = params.difLevel;
		let consolerNameDifLevel = 'difficulty level:';
		if(difLevel){
				difLevel = parseDifficulty(params.difLevel);
		}else{
				difLevel = makeNotValid();
				undefinedStructs.push(consolerNameDifLevel);
				consolerNameDifLevel += makeInvalidTerm();
		};
		consoler(consolerNameDifLevel, difLevel);
		//--------------------------------------------//
		let difStepless = params.difStepless;
		let consolerNameDifStepless = 'difficulty stepless:';
		if(difStepless){
				difStepless = parseDifficulty(params.difStepless);
		}else{
				difStepless = makeNotValid();
				undefinedStructs.push(consolerNameDifStepless);
				consolerNameDifStepless += makeInvalidTerm();
		};
		consoler(consolerNameDifStepless, difStepless);

		let allDifficultyName = [ difLevel.name0,
						difLevel.name1,
						difLevel.name2,
						difLevel.name3,
						difLevel.name4];
		let difName = allDifficultyName.filter(name => {return name !== ''});

if(configDifficulty.type !== 'none'){
	const _DataManager_setAdditionalConfig = DataManager.setAdditionalConfig;
	DataManager.setAdditionalConfig = function(){
		_DataManager_setAdditionalConfig.apply(this, arguments);

		if(ConfigManager.currentDifficulty){
			$gameSystem.setDifficulty(ConfigManager.currentDifficulty);
		}
	};//*
				
	const _ConfigManager_makeData = ConfigManager.makeData;
	ConfigManager.makeData = function() {
		let config = _ConfigManager_makeData.apply(this, arguments);
			config.currentDifficulty = $gameSystem.currentDifficulty();
	    return config;
	};//*

	const _ConfigManager_applyData = ConfigManager.applyData;
	ConfigManager.applyData = function(config) {
		_ConfigManager_applyData.apply(this, arguments);

		this.currentDifficulty 	= config.currentDifficulty;
	};//*
			
	Object.defineProperty(ConfigManager, 'difficultySelectable', {
	   	get: function() {
	        return $gameSystem.currentDifficulty();
	    },
	    set: function(value) {
	        $gameSystem.setDifficulty(value);
	    },
	    configurable: true
	});
}////

const _Game_System_prototype_initialize_B = Game_System.prototype.initialize;
Game_System.prototype.initialize = function(){
	_Game_System_prototype_initialize_B.apply(this, arguments);

	this._difficulty;
	this._currentDifficulty;

	switch(configDifficulty.type){
		case 'level':
			let currentId = difName[difLevel.initial] ? difLevel.initial : 0;
			this._difficulty = difName;
			this._currentDifficulty = difName[currentId];
		break;

		case 'stepless':	
			this._difficulty 		= difStepless.initial;
			this._currentDifficulty = difStepless.initial;
		break;

	};				
};//*

Game_System.prototype.difficulty = function(){
	return this._difficulty;
};//*
if(configDifficulty.type === 'none') Game_System.prototype.difficulty = function(){return 0};


Game_System.prototype.currentDifficulty = function(){
	return this._currentDifficulty;
};//*
if(configDifficulty.type === 'none') Game_System.prototype.currentDifficulty = function(){return 0};


Game_System.prototype.setDifficulty = function(value){
	switch(configDifficulty.type){
		case 'level':
			const id = this.difficulty().indexOf(value);
			this._currentDifficulty = this.difficulty()[id];
		break;

		case 'stepless':
			this._difficulty 		= value;		
			this._currentDifficulty = value;
		break;
	};
};//*
if(configDifficulty.type === 'none') Game_System.prototype.setDifficulty = function(value){};


Game_System.prototype.changeDifficulty = function(offset, fromWindow){
	let type = configDifficulty.type;
  	let difficulty = this.difficulty();
   	if(type === 'stepless' && isNaN(difficulty)) difficulty = 1;
   	let newDifficulty;
   	let valueId = configDifficulty.variable;

    if(type === 'level'){
	    	let currentId = difficulty.indexOf(this.currentDifficulty());
	    	currentId += offset;
	   		currentId = currentId.clamp(0, difficulty.length - 1);
	   		newDifficulty = difficulty[currentId];
	   		if(valueId >= 1){ $gameVariables.setValue(valueId, currentId)};

  	}else {
		   	offset *= difStepless.offset ;
		   	difficulty = Math.round((difficulty + offset) * 10)/10;
				   	
		   	difficulty = difficulty.clamp(difStepless.min, difStepless.max);
		   	newDifficulty 	= difficulty;
		  	if(valueId >= 1){ $gameVariables.setValue(valueId, difficulty, 1)};
	};
	if(fromWindow){
	   		return newDifficulty;	
	}else{
	   		this.setDifficulty(newDifficulty);
	}
};//*
if(configDifficulty.type === 'none') Game_System.prototype.changeDifficulty = function(offset, fromWindow){};



//ニューゲーム時に難易度変数を継承。ニューゲーム処理のオーバーライドは後述。		
const difficultyInherit = function(){
	if(configDifficulty.type !== 'none'){
	    let type = configDifficulty.type;
	    let valueId = configDifficulty.variable;
	    let value;
	    	switch(type){
	   			case 'level':
	    			let bass = $gameSystem.difficulty();
	   				let name = $gameSystem.currentDifficulty();
	   				value = bass.indexOf(name);
	   			break;

	    		case 'stepless':
	    			value = $gameSystem.currentDifficulty();
	   			break;
	   		};
	   	let decimals = type === 'stepless' ? 1 : 0;
	    	
	    if($gameVariables && valueId > 0){
	   		$gameVariables.setValue(valueId, value, decimals);
	   	};
	};
};//*	

			
/**********************************************************************************************/

	/*-------------音量に関するコンフィグの拡張-----------------------*/

		/*~struct~ConfigAudio:ja
		@param 	valid
		@type 		boolean
		@text 		音量コンフィグ改造
		@desc 		On（true）の時、コンフィグの音量項目を好みの値に調整します。
		@default 	true

		@param masterValid
		@type 		boolean
		@text 		マスター音量の追加
		@desc 		On（true）の時、コンフィグの各音量を統括するマスター音量を追加します。変動値は単位変動値に従います。
		@default 	false

		@param masterName
		@type 		string
		@text 		マスター音量の名前
		@desc 		マスター音量として表示するための項目名を設定します。
		@default 	マスター音量

		@param 	offset
		@type 		number
		@text 		単位変動値
		@desc 		音量調節１回あたりに変動する値を設定します。初期値は20です。
		@default 	1
		@max 		100
		@decimals 	0

		@param 	bgmVol
		@type 		number
		@text 		BGM音量の初期値
		@desc 		初めてゲームを起動した時の、BGM音量を設定します。
		@default 	80
		@max 		100
		@decimals 	0

		@param 	bgsVol
		@type 		number
		@text 		BGS音量の初期値
		@desc 		初めてゲームを起動した時の、BGS音量を設定します。
		@default 	20
		@max 		100
		@decimals 	0

		@param 	meVol
		@type 		number
		@text 		ME音量の初期値
		@desc 		初めてゲームを起動した時の、ME音量を設定します。
		@default 	80
		@max 		100
		@decimals 	0

		@param 	seVol
		@type 		number
		@text 		SE音量の初期値
		@desc 		初めてゲームを起動した時の、se音量を設定します。
		@default 	40
		@max 		100
		@decimals 	0
		*/
		/*---------------------------------------------------------------------------------------*/
		/*~struct~ConfigAudio:
		@param 	valid
		@type 		boolean
		@text 		customize audio config
		@desc 		Control the following values when this is true
		@default 	true

		@param masterValid
		@type 		boolean
		@text 		add master volume
		@desc 		Add the command of master volume when this is true; offset is controlled by the following parameter
		@default 	false

		@param masterName
		@type 		string
		@text 		name of master volume
		@desc 		Define the name for master volume
		@default 	Master Volume

		@param 	offset
		@type 		number
		@text 		offset
		@desc 		Control offset for controlling volume; initial value is 20
		@default 	1
		@max 		100
		@decimals 	0

		@param 	bgmVol
		@type 		number
		@text 		initial volume of BGM
		@desc 		Control initial BGM volume
		@default 	80
		@max 		100
		@decimals 	0

		@param 	bgsVol
		@type 		number
		@text 		initial volume of BGS
		@desc 		Control initial BGS volume
		@default 	20
		@max 		100
		@decimals 	0

		@param 	meVol
		@type 		number
		@text 		initial volume of ME
		@desc 		Control initial ME volume
		@default 	80
		@max 		100
		@decimals 	0

		@param 	seVol
		@type 		number
		@text 		initial volume of SE
		@desc 		Control initial SE volume
		@default 	40
		@max 		100
		@decimals 	0
		*/

		const parseConfigAudio = s => JSON.parse(s, (key, value) => {
			switch(key){
				case 'valid' 		: return value;
				case 'masterValid' 	: return value;
				case 'masterName' 	: return value;
				case 'offset' 		: return Number.parseFloat(value);
				case 'bgmVol' 		: return Number.parseFloat(value);
				case 'bgsVol' 		: return Number.parseFloat(value);
				case 'meVol' 		: return Number.parseFloat(value);
				case 'seVol' 		: return Number.parseFloat(value);
				default 			: return value;
			}
		});//*

		let configAudio = params.configAudio;
		let consolerNameAudio = 'configAudio:';
		if(configAudio){
			configAudio = parseConfigAudio(configAudio);
			configAudio = stringToBoolean(configAudio);
		}else{
			configAudio = makeNotValid();
			undefinedStructs.push(consolerNameAudio);
			consolerNameAudio += makeInvalidTerm();
		};
		consoler(consolerNameAudio, configAudio);

if(configAudio.valid){
	AudioManager._masterVolume 	 = 100;
	if(MZ){
		//MZではConfigManagerのボリュームが起動時点で設定されるため、AudioManagerの初期値を操作する必要あり。
		AudioManager._bgmVolume      = configAudio.bgmVol;
		AudioManager._bgsVolume      = configAudio.bgsVol;
		AudioManager._meVolume       = configAudio.meVol;
		AudioManager._seVolume       = configAudio.seVol;

		//MZでは何故かマスターの定義だけ消されていたので追加
		Object.defineProperty(AudioManager, 'masterVolume', {
		    get: function() {
		        return this._masterVolume;
		    },
		    set: function(value) {
		        this._masterVolume = value;
		        WebAudio.setMasterVolume(this._masterVolume);
		        Graphics.setVideoVolume(this._masterVolume);
		    },
		    configurable: true
		});
	};

	Object.defineProperty(ConfigManager, 'masterVolume', {
	    get: function() {
	        return AudioManager._masterVolume;
	    },
	    set: function(value) {
	        AudioManager._masterVolume = value;
	        if(AudioManager._currentBgm) AudioManager.playBgm(AudioManager._currentBgm);
	        if(AudioManager._currentBgs) AudioManager.playBgs(AudioManager._currentBgs);
	        //meだけはcurrentMeが存在しない上に流れるのが数秒程度のため、オプションを操作しながら聞く機会がない
	    },
	    configurable: true
	});//*

	const _Window_Options_prototype_addVolumeOptions = Window_Options.prototype.addVolumeOptions;
	Window_Options.prototype.addVolumeOptions = function() {
		const name = configAudio.masterName || 'マスター';
	    if(configAudio.masterValid) this.addCommand(name, 'masterVolume');

	    _Window_Options_prototype_addVolumeOptions.apply(this,arguments);
	};//*

	const _ConfigManager_readVolume = ConfigManager.readVolume;
	ConfigManager.readVolume = function(config, name) {
		//_ConfigManager_readVolume.apply(this, arguments);

	    var value = config[name];
	    if (value !== undefined) {
	        return Number(value).clamp(0, 100);
	    } else {
	        switch(name){
	        	case 'masterVolume' : return 100; 					break;
	        	case 'bgmVolume' 	: return configAudio.bgmVol; 	break;
	        	case 'bgsVolume' 	: return configAudio.bgsVol; 	break;
	        	case 'meVolume' 	: return configAudio.meVol; 	break;
	        	case 'seVolume' 	: return configAudio.seVol; 	break;
	        	default : return 100;
	        };
	    }
	};//*

	const _Window_Options_prototype_volumeOffset = Window_Options.prototype.volumeOffset;
	Window_Options.prototype.volumeOffset = function() {
		_Window_Options_prototype_volumeOffset.apply(this, arguments);

	    return configAudio.offset;
	};//*

	const _AudioManager_updateBufferParameters = AudioManager.updateBufferParameters;
	AudioManager.updateBufferParameters = function(buffer, configVolume, audio) {
		_AudioManager_updateBufferParameters.apply(this,arguments);
	    if (configAudio.masterValid && buffer && audio) {
	        buffer.volume *= this._masterVolume / 100;
	    }
	};//*
};////
	

/**********************************************************************************************/

/*-----------------注意書き用の文字色設定----------------*/

			/*~struct~AttentionColor:ja
			@param 	emphasize
			@type 		string
			@text 		強調色
			@desc 		文字を強調するための色を設定します。制御文字\Eで実行します。
			@default 	yellow

			@param 	warning
			@type 		string
			@text 		危険色
			@desc 		文字に危機感を与えるための色を設定します。制御文字\Wで実行します。
			@default 	red
			*/
			/*---------------------------------------------------------------------------------------*/
			/*~struct~AttentionColor:
			@param 	emphasize
			@type 		string
			@text 		textColor for emphasizing
			@desc 		Define a name of color to emphasize text; by using escapeCode \E
			@default 	yellow

			@param 	warning
			@type 		string
			@text 		textColor for crisis
			@desc 		Define a name of color to give text crisis; by using escapeCode \W
			@default 	red
			*/

	const parseAttentionColor = s => JSON.parse(s, (key, value) => {
		switch(key){
			case 'emphasize' 	: return value;
			case 'warning' 		: return value;
			default 			: return value;
		};
	});//*

	let attentionColor = params.attentionColor;
	let consolerNameAttention = 'attentionColor:';
	if(attentionColor){
			attentionColor = parseAttentionColor(attentionColor);
	}else{
			attentionColor = {'emphasize': 'yellow', 'warning': 'red'};
	};
	consoler(consolerNameAttention, attentionColor);

	//制御文字の定義はメッセージ速度のものと同時に行う

/*********************************************************************************************/

/*-------------------------メッセージ速度の変更--------------------*/

		/*~struct~ConfigMessageSpeed:ja
		@param 	valid
		@type 		boolean
		@text 		コンフィグ有効化
		@desc 		On（true）の時、コンフィグにメッセージ速度の項目を追加し、速度調整をできるようにします。
		@default 	true

		@param 	type
		@type 		select
		@text 		調整方法
		@desc 		・数字方式：数字で速度を変更します　・言語方式：「遅い」「速い」などの言葉で速度を変更します
		@default 	none

			@option 	操作しない
			@value 	none

			@option 	数字方式
			@value 	direct

			@option 	言語方式
			@value 	language

		@param 	name
		@type 		string
		@text 		オプション名
		@desc 		オプション画面で表示される名前を設定します。
		@default 	メッセージ速度

		@param 	defSpeed
		@type 		number
		@text 		デフォルト速度
		@desc 		初回起動時のメッセージ速度を設定します。言語方式では、この番目の名前が表示されます。
		@default 	3
		@min 		1
		@decimals 	0

		@param 	min
		@type 		number
		@text 		速度の最速値
		@desc 		メッセージ速度の最も速い速度を設定します。0がデフォルトの速度です。言語方式でも適用されます。
		@default 	0
		@min 		0
		@decimals 	0

		@param 	max
		@type 		number
		@text 		速度の最遅値
		@desc 		メッセージ速度の最も遅い速度を設定します。言語方式では使いません。
		@default 	8
		@decimals 	0

		@param 	offset
		@type 		number
		@text 		オプションでの変動値
		@desc 		オプションで１操作あたりの変動値を設定します。言語方式でも適用されます。
		@default 	1
		@min 		1
		@decimals 	0

		@param 	faster
		@type 		number
		@text 		速度の加速値
		@desc 		メッセージ速度を速くする値を設定します。制御文字\Fで実行されます。
		@min 		1
		@default 	1
		@decimals 	0

		@param 	slower
		@type 		number
		@text 		速度の減速値
		@desc 		メッセージ速度を遅くする値を設定します。制御文字\Sで実行されます。
		@min 		1
		@default 	1
		@decimals 	0

		@param 	dying
		@type 		number
		@text 		速度の超減速値
		@desc 		メッセージ速度をとても遅くする値を設定します。制御文字\Dで実行されます。
		@min 		1
		@default 	2
		@decimals 	0

		@param 	name1
		@type 		string
		@text 		最速の表示名
		@desc 		言語方式で表示される、最速値の表示名を設定します。空欄にすると表示されません。
		@default 	最速

		@param 	name2
		@type 		string
		@text 		準速の表示名
		@desc 		言語方式で表示される、準速値の表示名を設定します。空欄にすると表示されません。
		@default 	準速

		@param 	name3
		@type 		string
		@text 		並速の表示名
		@desc 		言語方式で表示される、並速値の表示名を設定します。空欄にすると表示されません。
		@default 	並速

		@param 	name4
		@type 		string
		@text 		遅の表示名
		@desc 		言語方式で表示される、遅値の表示名を設定します。空欄にすると表示されません。
		@default 	遅

		@param 	name5
		@type 		string
		@text 		最遅の表示名
		@desc 		言語方式で表示される、最遅の表示名を設定します。空欄にすると表示されません。
		@default 	最遅

		*/
		/*---------------------------------------------------------------------------------------*/
		/*~struct~ConfigMessageSpeed:
		@param 	valid
		@type 		boolean
		@text 		Added to option window
		@desc 		Add and control message speed in option window when this is true
		@default 	true

		@param 	type
		@type 		select
		@text 		type of control
		@desc 		Select a type of controlling message speed
		@default 	none

			@option 	Not control
			@value 	none

			@option 	Number
			@value 	direct

			@option 	Word
			@value 	language

		@param 	name
		@type 		string
		@text 		system name of message speed
		@desc 		Define the name displayed in option window
		@default 	Message Speed

		@param 	defSpeed
		@type 		number
		@text 		initial speed
		@desc 		Control initial message speed; in Word type, the number indicates index of name list
		@default 	3
		@min 		1
		@decimals 	0

		@param 	min
		@type 		number
		@text 		the fastest speed
		@desc 		Control the fastest message speed or minimum index
		@default 	0
		@min 		0
		@decimals 	0

		@param 	max
		@type 		number
		@text 		the slowest speed
		@desc 		Control the slowest message speed
		@default 	8
		@decimals 	0

		@param 	offset
		@type 		number
		@text 		offset
		@desc 		Control offset to change message speed or index
		@default 	1
		@min 		1
		@decimals 	0

		@param 	faster
		@type 		number
		@text 		accelerator
		@desc 		Control accelerator's offset, whichi is used by escapeCode \F
		@min 		1
		@default 	1
		@decimals 	0

		@param 	slower
		@type 		number
		@text 		decelerator
		@desc 		Control decelerator's offset, which is used by escapeCode \S
		@min 		1
		@default 	1
		@decimals 	0

		@param 	dying
		@type 		number
		@text 		super decelerator
		@desc 		Control super decelerator's offset, which is used by escapeCode \D
		@min 		1
		@default 	2
		@decimals 	0

		@param 	name1
		@type 		string
		@text 		the fastest name
		@desc 		Define the name; when empty name, the speed is excepted from the list
		@default 	very fast

		@param 	name2
		@type 		string
		@text 		faster name
		@desc 		Define the name; when empty name, the speed is excepted from the list
		@default 	fast

		@param 	name3
		@type 		string
		@text 		normal name
		@desc 		Define the name; when empty name, the speed is excepted from the list
		@default 	normal

		@param 	name4
		@type 		string
		@text 		slower name
		@desc 		Define the name; when empty name, the speed is excepted from the list
		@default 	slow

		@param 	name5
		@type 		string
		@text 		the slowest name
		@desc 		Define the name; when empty name, the speed is excepted from the list
		@default 	very slow

		*/

	const parseMessageSpeed = s => JSON.parse(s, (key, value) => {
		switch(key){
			case 'valid' 		: return value;
			case 'type' 		: return value;
			case 'name' 		: return value;
			case 'defSpeed' 	: return Number.parseFloat(value);
			case 'min'		 	: return Number.parseFloat(value);
			case 'max' 		 	: return Number.parseFloat(value);
			case 'offset' 		: return Number.parseFloat(value);
			case 'faster' 		: return Number.parseFloat(value);
			case 'slower' 		: return Number.parseFloat(value);
			case 'dying' 		: return Number.parseFloat(value);

			case 'name1' 		: return value;
			case 'name2' 		: return value;
			case 'name3' 		: return value;
			case 'name4' 		: return value;
			case 'name5' 		: return value;
			default 			: return value;
		};
	});//*

	let configMessageSpeed = params.configMessageSpeed;
	let consolerNameMessageSpeed = 'messageSpeed:';
	if(configMessageSpeed){
			configMessageSpeed = parseMessageSpeed(configMessageSpeed);
			configMessageSpeed = stringToBoolean(configMessageSpeed);
	}else{
			configMessageSpeed = makeNotValid();
			undefinedStructs.push(consolerNameMessageSpeed);
			consolerNameMessageSpeed += makeInvalidTerm();
	};

	consoler(consolerNameMessageSpeed, configMessageSpeed);

	let allMessageSpeedName = [ configMessageSpeed.name1,
								configMessageSpeed.name2,
								configMessageSpeed.name3,
								configMessageSpeed.name4,
								configMessageSpeed.name5];
	let msName 	= allMessageSpeedName.filter(name => {return name !== ''});

if(configMessageSpeed.valid){
	if(configMessageSpeed.type === 'language'){
		let length  = msName.length;
		let def 	= configMessageSpeed.defSpeed;

		ConfigManager.messageSpeed = def <= length ? def : length;		
	}else {
		ConfigManager.messageSpeed = configMessageSpeed.defSpeed;
	};
	//don't erase them↓
	ConfigManager.messageSpeedAdjust = 0;
	ConfigManager.messageNames = msName;
	ConfigManager.currentMessageName = ConfigManager.messageNames[ConfigManager.messageSpeed - 1];



	Object.defineProperty(ConfigManager, 'messageSpeedSelectable', {
	    get: function() {
	    	if(configMessageSpeed.type === 'direct'){
	    		return $gameSystem.messageSpeed();
	    	}else{
	    		return $gameSystem.messageName();
	    	};       
	    },
		set: function(value) {
		   	if(configMessageSpeed.type === 'direct'){
	    		$gameSystem.setMessageSpeed(value);	
	    	}else{
	    		$gameSystem.setMessageName(value);
	    	};      
	    },
	    configurable: true
	});

	const _DataManager_setAdditionalConfig = DataManager.setAdditionalConfig;
	DataManager.setAdditionalConfig = function(){
		_DataManager_setAdditionalConfig.apply(this, arguments);

		if(ConfigManager.msSpeed){
				$gameSystem.setMessageSpeed(ConfigManager.msSpeed);
		}
		if(ConfigManager.msName){
				$gameSystem.setMessageName(ConfigManager.msName);
		}
	};//*
				

	const _ConfigManager_makeData = ConfigManager.makeData;
	ConfigManager.makeData = function() {
		let config = _ConfigManager_makeData.apply(this, arguments);
						
			config.msSpeed 	= $gameSystem.messageSpeed();
			config.msName 	= $gameSystem.messageName();
	    return config;
	};//*

	const _ConfigManager_applyData = ConfigManager.applyData;
	ConfigManager.applyData = function(config) {
		_ConfigManager_applyData.apply(this, arguments);

		this.msSpeed 	= config.msSpeed;
		this.msName 	= config.msName;
	};//*
}////

const _Game_System_prototype_initialize_C = Game_System.prototype.initialize;
Game_System.prototype.initialize = function(){
	_Game_System_prototype_initialize_C.apply(this, arguments);

	this._messageSpeedType 		= configMessageSpeed.type || 'none';
	this._messageSpeedAdjust 	= 0;
	this._messageSpeed 			= configMessageSpeed.defSpeed || 3;
	this._allMessageName 		= msName;
	this._messageName 			= msName[this._messageSpeed - 1];
};//*

Game_System.prototype.msType = function(){
	return this._messageSpeedType;
};//*
if(!configMessageSpeed.valid) Game_System.prototype.msType = function(){return 0};


Game_System.prototype.msAdjust = function(){
	return this._messageSpeedAdjust;
};//*
if(!configMessageSpeed.valid) Game_System.prototype.msAdjust = function(){return 0};


Game_System.prototype.adjustMsFaster = function(){
	this._messageSpeedAdjust = -1 * configMessageSpeed.faster;
};//*
if(!configMessageSpeed.valid) Game_System.prototype.adjustMsFaster = function(){};


Game_System.prototype.adjustMsSlower = function(){
	this._messageSpeedAdjust = configMessageSpeed.slower;
};//*
if(!configMessageSpeed.valid) Game_System.prototype.adjustMsSlower = function(){};


Game_System.prototype.adjustMsDying = function(){
	this._messageSpeedAdjust = configMessageSpeed.dying;
};//*
if(!configMessageSpeed.valid) Game_System.prototype.adjustMsDying = function(){};


Game_System.prototype.adjustMsZero = function(){
	this._messageSpeedAdjust = 0;
};//*
if(!configMessageSpeed.valid) Game_System.prototype.adjustMsZero = function(){};


Game_System.prototype.messageSpeed = function(){
	if(configMessageSpeed.type === 'language'){
			return this.allMsName().findIndex(name => name === this.messageName());
	}else{
			return this._messageSpeed;
	}
};//*
if(!configMessageSpeed.valid) Game_System.prototype.messageSpeed = function(){return 0};


Game_System.prototype.setMessageSpeed = function(value){
	this._messageSpeed = value;
};//*
if(!configMessageSpeed.valid) Game_System.prototype.setMessageSpeed = function(value){};


Game_System.prototype.allMsName = function(){
	return this._allMessageName;
};//*
if(!configMessageSpeed.valid) Game_System.prototype.allMsName = function(){return []};


Game_System.prototype.messageName = function(){
	return this._messageName;
};//*
if(!configMessageSpeed.valid) Game_System.prototype.messageName = function(){return false};


Game_System.prototype.setMessageName = function(value){
	this._messageName = value;
};//*
if(!configMessageSpeed.valid) Game_System.prototype.setMessageName = function(value){};


if(configMessageSpeed.valid){
	const _Window_Message_prototype_updateMessage = Window_Message.prototype.updateMessage;
	Window_Message.prototype.updateMessage = function() {
	    const result = _Window_Message_prototype_updateMessage.apply(this, arguments);
	    //MV、MZ共に元ファンクションはtextState
	    if(result){
	    	this.waitMessageSpeed();
	    	return result;
	    }else{
	    	return result;
	    }
	};//*
	

	const _Window_Message_prototype_processEscapeCharacter = Window_Message.prototype.processEscapeCharacter;
	Window_Message.prototype.processEscapeCharacter = function(code, textState){
		_Window_Message_prototype_processEscapeCharacter.apply(this, arguments);

		//message speed adjust
		switch(code){
			case 'F': $gameSystem.adjustMsFaster(); 	break;
			case 'S': $gameSystem.adjustMsSlower(); 	break;
			case 'D': $gameSystem.adjustMsDying(); 		break;
			default : $gameSystem.adjustMsZero();
		};

		//message color adjust
		switch(code){
			case 'E': this.changeTextColor(attentionColor.emphasize); 	break;
			case 'W': this.changeTextColor(attentionColor.warning); 	break;
			case 'R': this.resetTextColor(); 							break;
		};
	};//*

	const _Window_Message_prototype_terminateMessage = Window_Message.prototype.terminateMessage;
	Window_Message.prototype.terminateMessage = function() {
	    _Window_Message_prototype_terminateMessage.apply(this, arguments);
	    $gameSystem.adjustMsZero();
	};//*
}////

//計算方法はこのファンクションで一括管理
Window_Message.prototype.waitMessageSpeed = function(){
	let type = $gameSystem.msType();
		
	if(type !== 'none'){
		let speed = $gameSystem.messageSpeed() + $gameSystem.msAdjust();
		let max = type === 'direct' ? configMessageSpeed.max : $gameSystem.allMsName().length;
		let min = type === 'direct' ? configMessageSpeed.min : 1;
		speed = speed.clamp(min, max+1);

		if(type === 'language'){
			//選択中の速さを数値に変換
			let base = configMessageSpeed.min;
			let offset = configMessageSpeed.offset;

			speed = base + offset * (speed - 1);
		}
		//consoler('message speed:', speed);
		this.startWait(speed);
	};
};//*
if(!configMessageSpeed.valid) Window_Message.prototype.waitMessageSpeed = function(){};


			

/*************************************************************************************************/

/*------------------------共有スイッチの設定-----------------------------*/

	let tempCommonSwitches = params.commonSwitches;
	let consolerNameCommonSwitch = 'commonSwitch:';
	if(tempCommonSwitches){
			tempCommonSwitches = JSON.parse(tempCommonSwitches);

			if(tempCommonSwitches.length > 0){
				const copy = tempCommonSwitches.map(s => {return {"name": s, "flag": false}});
				commonSwitches = commonSwitches.concat(copy);
			};
	}else{
			tempCommonSwitches = [];
			consolerNameCommonSwitch += makeInvalidTerm();
	};
	consoler(consolerNameCommonSwitch, commonSwitches);

class Game_CommonSwitches{
		constructor(){
			this._data = commonSwitches;
		};//*

		initialize (){
			const copy = tempCommonSwitches.map(s => {return {"name": s, "flag": false}});
			commonSwitches = [{"name": 'none', "flag": false}].concat(copy);
			this.update();
		};//*

		update (){
			this._data = commonSwitches;
			ConfigManager.save();
		};//*

		updateParam(){
			if(this._data.length !== tempCommonSwitches.length){
					const tempData = this._data.map(data => {return data});
					const copy = tempCommonSwitches.map(s => {return {"name": s, "flag": false}});
					commonSwitches = [{"name": 'none', "flag": false}].concat(copy);
					this._data = commonSwitches;
					this._data.forEach((d,index) => {
						if(tempData[index]){
							d.name = tempData[index].name;
							d.flag = tempData[index].flag;
						}
					})
			}
		};//*

		setValue (id, value){
			if(id >= 0 && id < this._data.length){
					if(typeof value === 'boolean'){
							this._data[id].flag = value;
							consoler('cs set:', id, this._data[id].flag);	
					}else{
							this._data[id].name = value;
					};
					this.onChange();
					ConfigManager.save();
			};
		};//*

		value(id, key){
			if(id >= 0 && id < this._data.length){
					switch(key){
						case 'name' : 
							const name = this._data[id].name;
							consoler('cs name:', id, name);
							return name;
						break;

						case 'flag' :
							const flag = this._data[id].flag;
							consoler('cs flag:', id, flag);
							return flag;
						break;
					}
			};
		};//*

		onChange () {
			$gameMap.requestRefresh();
		};//*

};//*Game_CommonSwitches

	window[Game_CommonSwitches.name] = Game_CommonSwitches;


if(tempCommonSwitches.length > 0){
		const _DataManager_createGameObjects = DataManager.createGameObjects;
		DataManager.createGameObjects = function() {
			_DataManager_createGameObjects.apply(this, arguments);
				    
		    $gameCS = new Game_CommonSwitches();
		    if(ConfigManager.gameCS){
			    	$gameCS._data = ConfigManager.gameCS._data;
		    }else{
			    	ConfigManager.gameCS = $gameCS;
		    };
		};//*

		const _ConfigManager_makeData = ConfigManager.makeData;
		ConfigManager.makeData = function() {
			let config = _ConfigManager_makeData.apply(this, arguments);
			$gameCS.updateParam();
				config.gameCS = $gameCS; 
		    return config;
		};//*

		const _ConfigManager_applyData = ConfigManager.applyData;
		ConfigManager.applyData = function(config) {
			_ConfigManager_applyData.apply(this, arguments);

			this.gameCS = config.gameCS;
		};//*
};////
				

/**********************************************************************************************/

	/*------------------------トロフィーの設定----------------------------------*/

		/*~struct~TrophyConfig:ja
			@param 	imgValid
			@type 		boolean
			@text 		トロフィー画像の有効化
			@desc 		On（true）の時、トロフィーで設定した画像が表示されるようになります。
			@default 	true

			@param 	name
			@type 		string
			@text 		システム名
			@desc 		メニューで表示されるトロフィー機能の名前を設定します。
			@default 	トロフィー

			@param 	allText
			@type 		string
			@text 		ジャンルのシステム名
			@desc 		メニューで表示される「全トロフィー」を指すシステム名を設定します。
			@default 	すべて

			@param 	menuFontSize
			@type 		number
			@text 		メニュー文字サイズ（px）
			@desc 		トロフィーメニューの文字サイズを設定します。
			@default 	18
			@min 		12
			@decimals 	0

			@param 	gaugeText
			@type 		string
			@text 		ゲージ名
			@desc 		各トロフィーの達成率ゲージに付記する項目名を設定します。
			@default 	達成率

			@param 	hiddenText
			@type 		string
			@text 		隠しメッセージ
			@desc 		隠しトロフィーに設定した場合、隠し中に表示するメッセージを設定します。
			@default 	隠しトロフィー

			@param 	achieveText
			@type 		string
			@text 		取得欄の項目名
			@desc 		トロフィー取得率の欄に表示する項目名を設定します。
			@default 	取得率

			@param 	achieveIcon
			@type 		number
			@text 		取得アイコン
			@desc 	 	トロフィー取得後、メニューに表示するアイコンのIDを設定します。初期値は87です。
			@default 	87
			@decimals 	0

			@param 	display
			@type 		select
			@text 		表示方法
			@desc 		トロフィーウィンドウの表示方法を設定します。
			@default 	open-close
					@option 	展開・収束
					@value 	open-close

					@option 	スライド
					@value 	slide

			@param 	width
			@type 		number
			@text 		ウィンドウ幅（px）
			@desc 		トロフィーウィンドウの幅を設定します。100~400pxで設定できます。
			@default 	200
			@min 		100
			@max 		400
			@decimals 	0

			@param 	height
			@type 		number
			@text 		ウィンドウ高さ（px）
			@desc 		トロフィーウィンドウの高さを設定します。50~200pxで設定できます。
			@default 	80
			@min 		50
			@max 		200
			@decimals 	0

			@param 	position
			@type 		select
			@text 		ウィンドウ位置
			@desc 		トロフィーウィンドウを表示する場所を設定します。
			@default 	right
					@option 	右上
					@value 	right

					@option 	左上
					@value 	left

					@option 	上真ん中
					@value 	above

					@option 	画面中央
					@value 	center

			@param 	fontSize
			@type 		number
			@text 		文字サイズ（px）
			@desc 		トロフィー表示メッセージの文字サイズを設定します。
			@default 	18
			@min 		12
			@decimals 	0

			@param 	waitFrame
			@type 		number
			@text 		表示時間（フレーム）
			@desc 		ウィンドウを表示する時間を設定します。
			@default 	60
			@min 		1
			@decimals 	0

			@param 	openSpeed
			@type 		number
			@text 		展開速度
			@desc 		ウィンドウの展開速度を設定します。初期値は32で、大きいほど早くなります。
			@default 	32
			@min 		1
			@max 		255
			@decimals 	0

			@param 	closeSpeed
			@type 		number
			@text 		収束速度
			@desc 		ウィンドウの収束速度を設定します。初期値は32で、大きいほど早くなります。
			@default 	32
			@min 		1
			@max 		255
			@decimals 	0

			@param 	se
			@type 		file
			@text 		獲得SE
			@desc 		トロフィー獲得時に鳴らすSEを設定します。
			@dir 		audio/se
			@require 1

			@param 	volume
			@type 		number
			@text 		SE音量
			@desc 		獲得SEの音量を設定します。
			@default 	70
			@decimals 	0

			@param 	pitch
			@type 		number
			@text 		SEピッチ
			@desc 		獲得SEの高さを設定します。
			@default 	100
			@decimals 	0

			@param 	pan
			@type 		number
			@text 		SEパン
			@desc 		獲得SEの位相を設定します。
			@default 	0
			@decimals 	0
		*/
		/*---------------------------------------------------------------------------------------*/
		/*~struct~TrophyConfig:
			@param 	imgValid
			@type 		boolean
			@text 		use image of achievements
			@desc 		Display each image of achievements when this is true
			@default 	true

			@param 	name
			@type 		string
			@text 		system name
			@desc 		Define the name displayed in menu
			@default 	Achievements

			@param 	allText
			@type 		string
			@text 		system name of 'all achievements'
			@desc 		Define the name displayed as 'All' in genre window
			@default 	All

			@param 	menuFontSize
			@type 		number
			@text 		fontSize of achievement scene（px）
			@desc 		Control font size in achievement scene
			@default 	18
			@min 		12
			@decimals 	0

			@param 	gaugeText
			@type 		string
			@text 		name of gauge
			@desc 		Define gauge's name displayed on an achievement gauge
			@default 	condition

			@param 	hiddenText
			@type 		string
			@text 		hidden achievement
			@desc 		Define the name displayed as hidden achievement
			@default 	Hidden Achievement

			@param 	achieveText
			@type 		string
			@text 		name of achievement rate in all
			@desc 		Define the name displayed in score window
			@default 	Score

			@param 	achieveIcon
			@type 		number
			@text 		iconId for achievement
			@desc 	 	Define an icon index displayed on achieved items
			@default 	87
			@decimals 	0

			@param 	display
			@type 		select
			@text 		announce type
			@desc 		Select a type to announce that player has gotten an achievement
			@default 	open-close
					@option 	Open and close
					@value 	open-close

					@option 	Slide in and out
					@value 	slide

			@param 	width
			@type 		number
			@text 		width of announce window（px）
			@desc 		Control window's width between 100 and 400
			@default 	200
			@min 		100
			@max 		400
			@decimals 	0

			@param 	height
			@type 		number
			@text 		height of announce window（px）
			@desc 		Control window's height between 50 and 200
			@default 	80
			@min 		50
			@max 		200
			@decimals 	0

			@param 	position
			@type 		select
			@text 		position of announce window
			@desc 		Select window's position
			@default 	right
					@option 	upper right
					@value 	right

					@option 	upper left
					@value 	left

					@option 	upper center
					@value 	above

					@option 	center
					@value 	center

			@param 	fontSize
			@type 		number
			@text 		fontSize of announce window（px）
			@desc 		Control font size in window
			@default 	18
			@min 		12
			@decimals 	0

			@param 	waitFrame
			@type 		number
			@text 		duration of displaying（frames）
			@desc 		Control duration for displaying announce window
			@default 	60
			@min 		1
			@decimals 	0

			@param 	openSpeed
			@type 		number
			@text 		speed to open or slide-in
			@desc 		Control the speed; initial value is 32, and bigger makes speed faster
			@default 	32
			@min 		1
			@max 		255
			@decimals 	0

			@param 	closeSpeed
			@type 		number
			@text 		speed to close or slide-out
			@desc 		Control the speed; initial value is 32, and bigger makes speed faster
			@default 	32
			@min 		1
			@max 		255
			@decimals 	0

			@param 	se
			@type 		file
			@text 		achievement SE
			@desc 		Define SE played when player has got an achievement
			@dir 		audio/se
			@require 1

			@param 	volume
			@type 		number
			@text 		achievement SE volume
			@desc 		Define SE volume played when player has got an achievement
			@default 	70
			@decimals 	0

			@param 	pitch
			@type 		number
			@text 		achievement SE pitch
			@desc 		Define SE pitch played when player has got an achievement
			@default 	100
			@decimals 	0

			@param 	pan
			@type 		number
			@text 		achievement SE pan
			@desc 		Define SE pan played when player has got an achievement
			@default 	0
			@decimals 	0
		*/


		const parseTrophyConfig = s => JSON.parse(s, (key, value) => {
			switch(key){
				case 'imgValid' 		: return value;
				case 'name' 			: return value;
				case 'allText' 			: return value;
				case 'display' 			: return value;
 				case 'width' 			: return Number.parseFloat(value);
				case 'height' 			: return Number.parseFloat(value);
				case 'position' 		: return value;
				case 'fontSize' 		: return Number.parseFloat(value);
				case 'menuFontSize' 	: return Number.parseFloat(value);
				case 'waitFrame' 		: return Number.parseFloat(value);
				case 'openSpeed' 		: return Number.parseFloat(value);
				case 'closeSpeed' 		: return Number.parseFloat(value);
				case 'gaugeText' 		: return value;
				case 'hiddenText' 		: return value;
				case 'achieveText' 		: return value;
				case 'se' 				: return value;
				case 'volume' 			: return Number.parseFloat(value);
				case 'pitch' 			: return Number.parseFloat(value);
				case 'pan' 				: return Number.parseFloat(value);
				default 				: return value;
			}
		});//*

		/*~struct~Trophy:ja
			@param 	name
			@type 		string
			@text 		トロフィー名
			@desc 		このトロフィーの名前を設定します。
			@default 	トロフィー

			@param 	text
			@type 		string
			@text 		説明
			@desc 		このトロフィーの説明や達成条件を設定します。
			@default 	説明

			@param 	hidden
			@type 		boolean
			@text 		隠しトロフィー
			@desc 		On（true）の時、このトロフィーの説明を隠します。決定キーで可視化できます。
			@default 	false

			@param 	gaugeValid
			@type 		boolean
			@text 		達成率ゲージ化
			@desc 		On（true）の時、このトロフィーの達成状況をゲージとして表示します。
			@default 	false

			@param 	gaugeMax
			@type 		number
			@text 		達成率の最大値
			@desc 		このトロフィーが達成したと判定する値を設定します。
			@default 	1
			@min 		1
			@decimals 	0

			@param 	genre
			@type 		number
			@text 		分類ID
			@desc 		このトロフィーを分類するIDを設定します。IDはtrophyGenreに従います。0は未分類になります。
			@default 	1
			@min 		0
			@decimals 	0

			@param 	img
			@type 		file
			@text 		トロフィー画像
			@desc 		トロフィーメニューで表示する、このトロフィーの画像を設定します。共通設定で画像使用をOnにしてください。
			@dir 		img	
			@require 1
		*/
		/*---------------------------------------------------------------------------------*/
		/*~struct~Trophy:
			@param 	name
			@type 		string
			@text 		this achievement's name
			@desc 		Define the name
			@default 	Achievement 1

			@param 	text
			@type 		string
			@text 		explanation of this achievement
			@desc 		Write the explanation such as what to do
			@default 	You got all Achievements!!

			@param 	hidden
			@type 		boolean
			@text 		Hidden achievement
			@desc 		Hide this achievement's name when this is true; ok key turns it visible or hidden
			@default 	false

			@param 	gaugeValid
			@type 		boolean
			@text 		valid gauge
			@desc 		Show a gauge for achievement rate when this is true
			@default 	false

			@param 	gaugeMax
			@type 		number
			@text 		condition value
			@desc 		Control the condition value for achievement
			@default 	1
			@min 		1
			@decimals 	0

			@param 	genre
			@type 		number
			@text 		genre ID
			@desc 		Control the Id according to "trophyGenre"; when 0, this genre works as 'All'
			@default 	1
			@min 		0
			@decimals 	0

			@param 	img
			@type 		file
			@text 		image of achievement
			@desc 		Select an image displayed in achievement scene; only when PluginParameter "imgValid" in "trophyConfig" is true
			@dir 		img	
			@require 1
		*/
		
		const parseTrophy = s => JSON.parse(s, (key, value) => {
			switch(key){
				case 'name' 		: return value;
				case 'text' 		: return value;
				case 'hidden' 		: return value;
				case 'gaugeValid' 	: return value;
				case 'gaugeMax' 	: return value;
				case 'genre' 		: return Number.parseFloat(value);
				case 'img' 			: return value;
				default 			: return value;
			}
		});//*
	
		let trophyConfig = params.trophyConfig;
		let consolerNameTrophyConfig = 'trophyConfig:';
		if(trophyConfig){
				trophyConfig = parseTrophyConfig(trophyConfig);
				trophyConfig = stringToBoolean(trophyConfig);
		}else{
				trophyConfig = makeNotValid();
				undefinedStructs.push(consolerNameTrophyConfig);
				consolerNameTrophyConfig += makeInvalidTerm();
		};
		consoler(consolerNameTrophyConfig, trophyConfig);
		//------------------------------------------------//
		let trophyGenre = params.trophyGenre;
		if(trophyGenre){
				trophyGenre = JSON.parse(trophyGenre);
		}else{
				trophyGenre = [];
		};
		//-------------------------------------------------//
		let trophy = params.trophy;
		let consolerNameTrophy = 'trophy:';
		if(trophy){
				trophy = parseTrophy(trophy);
				trophy = Object.values(trophy).map( t =>{return JSON.parse(t)});			
				trophy.forEach(t =>{ t.hidden = t.hidden === 'true';
								 t.open = false;
								 t.gaugeValid = t.gaugeValid === 'true';
								 t.gaugeMax = Number(t.gaugeMax);
								 t.genre = trophyGenre[t.genre - 1] || '';
								 t.value = 0;
								 t.achieve = false; });
		}else{
				trophy = [];
				undefinedStructs.push(consolerNameTrophy);
				consolerNameTrophy += makeInvalidTerm();
		};
		consoler(consolerNameTrophy, trophy);
		let trophyPreserve = [];
						
class Game_Trophy {
		constructor(){};//*

		setValue (id){
			const target = trophy[id] || trophy[0];
			if(!target.achieve){
					target.value ++;
					target.value = target.value.clamp(0, target.gaugeMax);	
					if(target.value >= target.gaugeMax){
								target.achieve = true;
								if(trophyPreserve.length === 0){
										trophyPreserve.push(target.name);
										this.callTrophyWindow(target.name);
								}else{
										trophyPreserve.push(target.name);
								}
								if(trophy[0].genre === ''){
										//プラチナトロフィー
										this.setValue();
								}
					};

					ConfigManager.save();
			}
		};//*

		callTrophyWindow (name){
			this.callSe();
			let trophyWindow = new Window_Trophy();
			trophyWindow.initMembers();
			trophyWindow.addScene();
			trophyWindow.drawTrophy(name);
			trophyWindow.appear();
		};//*

		callSe (){
			const se = {"name" 		: trophyConfig.se,
						"volume" 	: trophyConfig.volume,
						"pitch" 	: trophyConfig.pitch,
						"pan" 		: trophyConfig.pan};
			AudioManager.playSe(se);
		};//*

		reset (id){
			if(id >= 0){
					const target = trophy[id];
					if(!target.achieve){
								target.value = 0;
					}
					ConfigManager.save();	
			}
		};//*

		allReset (){
			trophy.map(t => {
							t.value = 0;
							t.achieve = false;
						})
			ConfigManager.save();
		};//*
};//*Game_Trophy

	window[Game_Trophy.name] = Game_Trophy;

class Window_Trophy extends Window_Base{
		constructor(){
			const y = trophyConfig.position !== 'center' ? 0 : Math.floor((Graphics.boxHeight - height)/2);
			super(0, y, Graphics.boxWidth, Graphics.boxHeight);
			const width = trophyConfig.width;
			const height = trophyConfig.height;
			let x = Graphics.boxWidth - width;
			switch(trophyConfig.position){
					case 'left' : x = 0; break;
					case 'above' :
					case 'center' : x = Math.floor(x / 2); break;
					case 'right' : x = x; break;
			}
			this.width = width;
			this.height = height;
			this.x = x;
		};//*

		initMembers (){
			this._openness = 0;
			this._waitCount = 0;
			if(trophyConfig.display === 'slide'){
					this._goalX = this.x;
					switch(trophyConfig.position){
							case 'left' : this.x -= this.width; break;
							case 'right' : this.x += this.width; break;
					}
					this._startX = this.x;
			}
		};//*

		setWait (){
			this._waitCount = trophyConfig.waitFrame;
		};//*

		addScene (){
			this.close();
			SceneManager._scene.addChild(this);
		};//*

		update () {
			super.update();
		    this.updateClosing();
		};//*

		updateClosing (){
			if(this._waitCount){
					this._waitCount --;
					if(this._waitCount <= 0){
							this._waitCount = 0;
							this.close();
					}
			}
		};//*

		drawTrophy (name){
			this.drawText(name, 0 , 0, this.width);
		};//*

		appear (){
			this.open();
		};//*

		standardFontSize (){
			return trophyConfig.fontSize;
		};//*

		notMove (){
			return trophyConfig.position === 'above' || trophyConfig.position === 'center';
		};//*

		isOpen () {
			if(trophyConfig.display === 'open-close' || this.notMove()){
					return this._openness >= 255;
			}else{
					return this.x === this._goalX;
			}
		};//*

		updateOpen () {
			if (this._opening) {
					this.executeOpen();
			}
		};//*

		executeOpen (){
			if(trophyConfig.display === 'open-close' || this.notMove()){
					this.openness += trophyConfig.openSpeed;
			}else{
					this._openness = 255;
					let x = this.x;
					switch(trophyConfig.position){
							case 'left' :
								x += trophyConfig.openSpeed; 
								x = Math.min(x, this._goalX);
							break;

							case 'right' :
								x -= trophyConfig.openSpeed;
								x = Math.max(x, this._goalX);
							break;
					};
					this.move(x, this.y, this.width, this.height);
			};

			if (this.isOpen()) {
					this._opening = false;
					this.setWait();
			}
		};//*

		isClosed () {
		    if(trophyConfig.display === 'open-close' || this.notMove()){
					return this._openness <= 0;
			}else{
					return this.x === this._startX;
			}
		};//*

		updateClose () {
			if (this._closing) {
					this.executeClose();
					this.preserveLeft();
			}
		};//*

		executeClose (){
			if(trophyConfig.display === 'open-close' || this.notMove()){
					this.openness -= trophyConfig.closeSpeed;
			}else{
					let x = this.x;
					switch(trophyConfig.position){
							case 'left' :
								x -= trophyConfig.openSpeed; 
								x = Math.max(x, this._startX);
							break;
							
							case 'right' :
								x += trophyConfig.openSpeed;
								x = Math.min(x, this._startX);
							break;
					};
					this.move(x, this.y, this.width, this.height);
			};

			if (this.isClosed()) {
					this._closing = false;
			}
		};//*

		preserveLeft (){
			trophyPreserve.shift();
			if(trophyPreserve.length > 0){
					const achiever = new Game_Trophy();
					achiever.callTrophyWindow(trophyPreserve[0]);
			}
		};//*
};//*Window_Trophy

	window[Window_Trophy.name] = Window_Trophy;


	/*------------------トロフィーシーンの設定-------------------------------*/

class Scene_TrophyMenu extends Scene_Menu{
		constructor(){
			super();
		};//*

		create (){
			Scene_MenuBase.prototype.create.call(this);
			this.initializeTrophyHidden();
			this.createTitleWindow();								
			this.createCommandWindow();
		    this.createGoldWindow();
		    this.createStatusWindow();
		};//*

		initializeTrophyHidden (){
			trophy.forEach(t => t.open = false);
		};//*

		createTitleWindow (){
			this._titleWindow = new Window_TrophyMenuTitle();
			this._titleWindow.adjustHeight();
			this._titleWindow.drawTitle();
			this.addWindow(this._titleWindow);
		};//*

		createCommandWindow(){
			this._commandWindow = new Window_TrophyMenuCommand(0, this._titleWindow.height);	
			this._commandWindow.setHandler('ok', this.processOk.bind(this));
			this._commandWindow.setHandler('cancel', this.popScene.bind(this));
			this.addWindow(this._commandWindow);
		};//*

		createGoldWindow(){
			this._goldWindow = new Window_TrophyMenuAchievement(0, 0);
		    this._goldWindow.y = Graphics.boxHeight - this._goldWindow.height;
		   	this.addWindow(this._goldWindow);
		   	this._goldWindow.setCommandWindow(this._commandWindow);
		   	this._commandWindow.setGoldWindow(this._goldWindow);
		};//*

		createStatusWindow(){
			const width = this._commandWindow.width;
			const height = this._titleWindow.height;
			this._statusWindow = new Window_TrophyMenuStatus(width, height);
		    this._statusWindow.adjustHeight();
		    this._statusWindow.loadTrophyImages();
		    //this._statusWindow.setSprites();
			this._statusWindow.setHandler('ok', this.openHiddenText.bind(this));
			this._statusWindow.setHandler('cancel', this.cancelOk.bind(this));
			this.addWindow(this._statusWindow);
			this._statusWindow.setCommandWindow(this._commandWindow);
			this._commandWindow.setStatusWindow(this._statusWindow);
			this._statusWindow.refresh();
		};//*

		processOk (){
			this._commandWindow.deactivate();
			this._statusWindow.select(0);
			this._statusWindow.activate();
		};//*

		cancelOk (){
			this._statusWindow.deactivate();
			this._commandWindow.selectLast();
			this._commandWindow.activate();
		};//*

		openHiddenText (){
			this._statusWindow.processOk();
		};//*
};//*Scene_TrophyMenu

	window[Scene_TrophyMenu.name] = Scene_TrophyMenu;

class Window_TrophyMenuTitle extends Window_Base{
		constructor(){
			super(0, 0, Graphics.boxWidth, Graphics.boxHeight);
		};//*

		adjustHeight (){
			this.height = this.lineHeight() + this.standardPadding() * 2;
		};//*

		drawTitle (){
			this.drawText(trophyConfig.name, 0, 0, this.width, 'center');
		};//*
};//*Window_TrophyMenuTitle

	window[Window_TrophyMenuTitle.name] = Window_TrophyMenuTitle;

class Window_TrophyMenuCommand extends Window_MenuCommand{
		constructor(x, y){
			super(x, y);
		};//*

		makeCommandList(){
			this.addAllCommand();
			this.addGenreCommands();
		};//*

		addAllCommand (){
			this.addCommand(trophyConfig.allText, 'all');
		};//*

		addGenreCommands (){
			trophyGenre.map(g => this.addCommand(g, g));
		};//*

		update () {
		    super.update();
		    if(this._goldWindow){
		    	this._goldWindow.setCategory(this.currentSymbol());
		    }
			if (this._statusWindow) {
			    	this._statusWindow.setCategory(this.currentSymbol());
			}
		};//*

		setGoldWindow (goldWindow){
			if(goldWindow){
					this._goldWindow = goldWindow;
			}
		};//*

		setStatusWindow (statusWindow){
			if(statusWindow){
					this._statusWindow = statusWindow;
			}
		};//*
};//*Window_TrophyMenuCommand

	window[Window_TrophyMenuCommand.name] = Window_TrophyMenuCommand;

class Window_TrophyMenuAchievement extends Window_Gold{
		constructor(x, y){
			super(x, y);
			this._category;
		};//*

		setCommandWindow (commandWindow){
			this._commandWindow = commandWindow;
		};//*

		setCategory (category) {
			if (this._category !== category) {
					this._category = category;
					this.refresh();
			}
		};//*

		getTrophies (){
			if(this._commandWindow){
					const symbol = this._category;
					if(symbol === 'all'){
							return trophy;
					}else{
							return trophy.filter(t => {return t.genre === symbol});
					}
			}else{
				return [];
			}
		};//*

		refresh () {
			var x = this.textPadding();
			var width = MV ? this.contents.width : this.contentsWidth();
			width -= x * 2;
			this.contents.clear();
			this.drawText(trophyConfig.achieveText, x, 0, width/2);
			this.drawCurrencyValue(this.value(), this.currencyUnit(), x, 0, width);
		};//*

		value (){
			const trophies = this.getTrophies();
			const current = trophies.filter(t => {return t.achieve}).length;
			const max = trophies.length;
			if(current === 0){
					return 0;
			}else if(current === max){
					return 100;
			}else{
					let rate = Math.round(100 * current / max);
					return rate.clamp(1, 99);
			}
		};//*

		currencyUnit (){
			return '％';
		};//*
};//*Window_TrophyMenuAchievement

	window[Window_TrophyMenuAchievement.name] = Window_TrophyMenuAchievement;

class Window_TrophyMenuStatus extends Window_MenuStatus{
		constructor(x,y){
			super(x, y);
		};//*

		processOk (){
			const id = this.index();
			const target = this.getTrophies()[id];
			if(!target.open){
					target.open = true;
			}else{
					target.open = false;
			}
			this.refresh();
		};//*

		adjustHeight (){
			this.height = Graphics.boxHeight - this.y;
		};//*

		standardFontSize () {
			return trophyConfig.menuFontSize;
		};//*

		setSprites (){
			for(var i = 0; i < trophy.length; i++){
					const sprite = new Sprite();
					const path = trophy[i].img;
					sprite.bitmap = ImageManager.loadBitmap('img/', path);
					this.addChild(sprite);
			}
		};//*
		
		loadTrophyImages () {
			if(trophyConfig.imgValid){
					trophy.forEach(function(t) {
						if(t.img){
								ImageManager.loadBitmap('img/', t.img);	
						};
					}, this);	
			}
		};//*
		
		setCommandWindow (commandWindow){
			this._commandWindow = commandWindow;
		};//*

		setCategory (category) {
			if (this._category !== category) {
					this._category = category;
					this.refresh();
		   		    this.resetScroll();
			}
		};//*

		getTrophies (){
			if(this._commandWindow){
					const symbol = this._category;
					if(symbol === 'all'){
							return trophy;
					}else{
							return trophy.filter(t => {return t.genre === symbol});
					}
			}else{
				return [];
			}
		};//*

		maxItems () {
			if(this._commandWindow){
					const target = this.getTrophies();
					return target.length;
			}else{
					return 0;
			}
		};//*

		refresh () {
			if (this.contents) this.contents.clear();
			this.drawAllItems();
		};//*

		drawItemImage (index){
			if(trophyConfig.imgValid){
					var target = this.getTrophies()[index];
					var rect = this.itemRect(index);

					const path = target.img;
					const fw = Math.min(Window_Base._faceWidth, rect.width);
					const fh = Math.min(Window_Base._faceHeight, rect.height);

					if(path){
							const sprite = new Sprite();
							sprite.bitmap = ImageManager.loadBitmap('img/', path);
							const heightRate = fh / sprite.bitmap.height;
							const width = Math.floor(sprite.bitmap.width * heightRate);
							const height = Math.floor(sprite.bitmap.height * heightRate);
											
							this.drawTrophyImage(sprite, rect.x, rect.y, width, height);
				  	};

					this.changePaintOpacity(true);
			};	
		};//*

		drawTrophyImage (sprite, x, y, width, height){
			const img = sprite.bitmap;
			const sx = 0;
			const sy = 0;
			const sw = sprite.bitmap.width;
			const sh = sprite.bitmap.height;
			x += this.standardPadding();
			this.contents.blt(img, sx, sy, sw, sh, x, y, width, height);
		};//*

		getImgRate (width, height){
			if(width < 1 && height < 1){
					return Math.min(width, height);
			}else if(width >=1 && height >= 1){
					return Math.max(width, height);
			}else if(width < 1 && height >= 1){
					return width;
			}else{
					return height;
			}
		};//*

		drawItemStatus (index){	
			var target = this.getTrophies()[index];
			var rect = this.itemRect(index);
			var x = rect.x + (trophyConfig.imgValid ? 162 : this.textPadding());
			var y = rect.y + rect.height / 2 - this.lineHeight() * 1.5;
			var width = rect.width - x - this.textPadding();
			this.drawTrophyStatus(target, x, y, width);
		};//*

		drawTrophyStatus (target, x, y, width){
			var lineHeight = this.lineHeight();
			var x2 = (x + 180) + (trophyConfig.imgValid ? 0 : 144);
			var width2 = Math.min(200, width - 180 - this.textPadding());
			if(!target.hidden || target.open){
					this.drawTrophyName(target, x, y);
					this.drawTrophyText(target, x, y + lineHeight * 1);
					this.drawTrophyCondition(target, x2, y + lineHeight * 2, width2);	
			}else{
					this.changeTextColor(this.crisisColor());
					this.drawText(trophyConfig.hiddenText, x, y + lineHeight * 1);
			};
		};//*

		drawTrophyName (target, x, y, width){
			width = width || 168;
			this.changeTextColor(this.systemColor());
			this.drawText(target.name, x, y, width);
		};//*

		drawTrophyText (target, x, y, width){
			width = width || 270;
			this.resetTextColor();
			this.drawText(target.text, x + this.textWidth('0'), y, width);
		};//*

		drawTrophyCondition (target, x, y, width){
			width = width || 186;
			if(target.achieve){
					var color1 = this.hpGaugeColor1();
					var color2 = this.hpGaugeColor2();	
			}else{
					var color1 = this.mpGaugeColor1();
					var color2 = this.mpGaugeColor2();
			};
								    
			if(target.achieve){
					this.drawIcon(trophyConfig.achieveIcon, x - 40, y);
			}
			if(target.gaugeValid){
					this.drawGauge(x, y, width, this.trophyRate(target), color1, color2);
					this.changeTextColor(this.systemColor());
					this.drawText(trophyConfig.gaugeText, x, y, 44);
					this.drawCurrentAndMax(target.value, target.gaugeMax, x, y, width,
									        this.normalColor(), this.normalColor());	
			}
		};//*

		trophyRate (target){
			return target.value / target.gaugeMax;
		};//*

};//*Window_TrophyMenuStatus

	window[Window_TrophyMenuStatus.name] = Window_TrophyMenuStatus;


	/*-----------------メニューとタイトルにトロフィーの項目を追加-----------------------*/

if(params.trophy){
	const _Window_MenuCommand_prototype_addOriginalCommands = Window_MenuCommand.prototype.addOriginalCommands;
	Window_MenuCommand.prototype.addOriginalCommands = function() {
		_Window_MenuCommand_prototype_addOriginalCommands.apply(this, arguments);
		this.addCommand(trophyConfig.name, 'trophy', true);
	};//*

	const _Scene_Menu_prototype_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
	Scene_Menu.prototype.createCommandWindow = function(){
		_Scene_Menu_prototype_createCommandWindow.apply(this, arguments);
		this._commandWindow.setHandler('trophy', this.commandTrophy.bind(this));
	};//*

	Scene_Menu.prototype.commandTrophy = function(){
		SceneManager.push(Scene_TrophyMenu);
	};//*

	//-------------------------------------------------------
	const _Scene_Title_prototype_createCommandWindow = Scene_Title.prototype.createCommandWindow;
	Scene_Title.prototype.createCommandWindow = function() {
		_Scene_Title_prototype_createCommandWindow.apply(this, arguments);
		this._commandWindow.setHandler('trophy', this.commandTrophy.bind(this));
	};//*

	Scene_Title.prototype.commandTrophy = function(){
		this._commandWindow.close();
    	SceneManager.push(Scene_TrophyMenu);
	};//*

	const _Window_TitleCommand_prototype_makeCommandList = Window_TitleCommand.prototype.makeCommandList;
	Window_TitleCommand.prototype.makeCommandList = function() {
		_Window_TitleCommand_prototype_makeCommandList.apply(this, arguments);
		this.addCommand(trophyConfig.name, 'trophy');
	};//*
};////

if(params.trophy){
	const _DataManager_createGameObjects = DataManager.createGameObjects;
	DataManager.createGameObjects = function() {
		_DataManager_createGameObjects.apply(this, arguments);
					    
		if(ConfigManager.trophy && ConfigManager.trophy.length === trophy.length){
				trophy = ConfigManager.trophy;
		}else{
				ConfigManager.trophy = trophy;
		};
	};//*

	const _ConfigManager_makeData = ConfigManager.makeData;
	ConfigManager.makeData = function() {
		let config = _ConfigManager_makeData.apply(this, arguments);
			config.trophy = trophy;
		return config;
	};//*

	const _ConfigManager_applyData = ConfigManager.applyData;
	ConfigManager.applyData = function(config) {
		_ConfigManager_applyData.apply(this, arguments);

		this.trophy = config.trophy;
	};//*
};////
	
/**************************************************************************************************/

/*----------ここまでのコンフィグ内容のオプションウィンドウへの反映-------------------------*/
//特に統括スイッチがあるわけでもないので完全開放

const _Window_Options_prototype_makeCommandList = Window_Options.prototype.makeCommandList;
Window_Options.prototype.makeCommandList = function() {
	_Window_Options_prototype_makeCommandList.apply(this, arguments);
		   	
	this.addAdditionalOptions();
};//*

Window_Options.prototype.addAdditionalOptions = function(){
	if(configDifficulty.type !== 'none' && configDifficulty.displayOption){
			this.addCommand(configDifficulty.name, 'difficultySelectable');
	};
	if(configMessageSpeed.type !== 'none'){
			this.addCommand(configMessageSpeed.name, 'messageSpeedSelectable');
	};
	if(HUDValid > 1){
			this.addCommand(configHUDName, configHUD);
	};
};//*

const _Window_Options_prototype_statusText = Window_Options.prototype.statusText;
Window_Options.prototype.statusText = function(index) {
	var symbol = this.commandSymbol(index);
	var value = this.getConfigValue(symbol);
	if (this.isVolumeSymbol(symbol)) {
		    return this.volumeStatusText(value);
	} else if (this.isSelectableSymbol(symbol)) {
		    return this.selectableStatusText(symbol, value); //added
	} else {
		    return this.booleanStatusText(value);
	}
};//*
			
	//-----オプションテキストの記述に関して、分岐の判定を増設

Window_Options.prototype.isSelectableSymbol = function(symbol){
	return symbol.contains('Selectable');
};//*

Window_Options.prototype.selectableStatusText = function(symbol, value){
	switch(symbol){
		case 'difficultySelectable':
			if(configDifficulty.type === 'stepless'){
					let v = String(value);
					let i = String(difStepless.initial);
					let o = String(difStepless.offset);
					let M = String(difStepless.max);
					let m = String(difStepless.min);
					let decimalValid = i.contains('.') || o.contains('.') || M.contains('.') || m.contains('.');

					let newValue = decimalValid ? (v.contains('.') ? value : value + '.0') :  value;

					return newValue;
			}else{
					return value;
			}
		break;

		case 'messageSpeedSelectable':
			return value;
		break;

		default : return value;
	};
};//*

const _Window_Options_prototype_processOk = Window_Options.prototype.processOk;
Window_Options.prototype.processOk = function() {
	var index = this.index();
	var symbol = this.commandSymbol(index);
	var value = this.getConfigValue(symbol);
	if (this.isVolumeSymbol(symbol)) {
			value += this.volumeOffset();
			if (value > 100) {
			        value = 0;
			};
	        value = value.clamp(0, 100);
	        this.changeValue(symbol, value);

    } else if(this.isSelectableSymbol(symbol)){
			//選択式の項目では決定ボタンによる入力を受け付けない
	} else{
			 this.changeValue(symbol, !value);
	}
};//*

const _Window_Options_prototype_cursorRight = Window_Options.prototype.cursorRight;
Window_Options.prototype.cursorRight = function(wrap) {
    var index = this.index();
    var symbol = this.commandSymbol(index);
    var value = this.getConfigValue(symbol);
    if (this.isVolumeSymbol(symbol)) {
	        value += this.volumeOffset();
	        value = value.clamp(0, 100);
	        this.changeValue(symbol, value);

    } else if(this.isSelectableSymbol(symbol)){
			this.selectableCursor(symbol, 'right');
	} else {
			this.changeValue(symbol, true);
	}
};//*

const _Window_Options_prototype_cursorLeft = Window_Options.prototype.cursorLeft;
Window_Options.prototype.cursorLeft = function(wrap) {
    var index = this.index();
    var symbol = this.commandSymbol(index);
    var value = this.getConfigValue(symbol);
    if (this.isVolumeSymbol(symbol)) {
	        value -= this.volumeOffset();
	        value = value.clamp(0, 100);
	        this.changeValue(symbol, value);

    } else if(this.isSelectableSymbol(symbol)){
	    	this.selectableCursor(symbol, 'left');
    } else {
	        this.changeValue(symbol, false);
    }
};//*
		
	//選択式のオプションを増設する場合は、ここで選択処理を記述
Window_Options.prototype.selectableCursor = function(symbol, dir){
	let offset = dir === 'right' ? 1 : -1;
	let type;

	switch(symbol){
		case 'difficultySelectable':
		    	const fromWindow = true;
		    	const newDifficulty = $gameSystem.changeDifficulty(offset, fromWindow);
			    this.changeValue(symbol, newDifficulty);
	    break;

	    case 'messageSpeedSelectable':
	    		type = configMessageSpeed.type;
	    		let speed = ConfigManager.messageSpeed;
	    		let newSpeed;

	    		if(type === 'direct'){
	    				offset *= configMessageSpeed.offset;
	    				speed += offset;
	    				newSpeed = speed.clamp(configMessageSpeed.min, configMessageSpeed.max);
	    				ConfigManager.messageSpeed = newSpeed;
	    		}else{
	    				//配列IDの-1補正、およびパラメーターのoffset処理は実速度を求める時に行うので無視
	    				speed += offset;
	    				speed = speed.clamp(1, ConfigManager.messageNames.length);

	    				ConfigManager.messageSpeed = speed;
	    				newSpeed = ConfigManager.messageNames[speed - 1];
	    		};

	    		this.changeValue(symbol, newSpeed);

	    break;

	};
};//*


/**************************************************************************************************/
/*---------------タイトルウィンドウをカスタマイズ------------------------*/

		/*~struct~ConfigTitleWindow:ja
			@param 	valid
			@type 		boolean
			@text 		カスタマイズ有効化
			@desc 		On（true）の時、このカスタマイズを有効にします。
			@default 	false

			@param fontSize
			@type 		number
			@text 		フォントサイズ
			@desc 		タイトルウィンドウの文字サイズを設定します。
			@default 	28
			@min 		12
			@decimals 	0

			@param color
			@type 		string
			@text 		文字色
			@desc 		タイトルウィンドウの文字色を設定します。英語名、rgb(red, gree, blue)、HEX表記が使えます。
			@default 	white

			@param 	displayFrame
			@type 		boolean
			@text 		ウィンドウ枠表示
			@desc 		On（true）の時、ウィンドウの枠を表示します。
			@default 	true

			@param opacity
			@type 		number
			@text 		背景不透明度
			@desc 		タイトルウィンドウの背景の不透明度を設定します。
			@default 	192
			@min 		0
			@max 		255
			@decimals 	0

			@param 	width
			@type 		number
			@text 		ウィンドウ幅(px)
			@desc 		タイトルウィンドウの幅を設定します。初期値は240(px)です。
			@default 	240
			@min 		120
			@decimals 	0

			@param 	cols
			@type 		number
			@text 		列数
			@desc 		タイトルウィンドウ内の項目を並べる列数を設定します。
			@default 	1
			@min 		1
			@decimals 	0

			@param 	backRect
			@type 		boolean
			@text 		項目背景
			@desc 		On（true）の時、各選択肢の背景用の図形を生成します。MZ用のパラメーターです。
			@default 	true

			@param 	stepRows
			@type 		number
			@text 		階段式コマンド
			@desc 		0以外の値を設定すると、コマンドが階段状に並びます。この時、colsの設定は無視されます。
			@decimals 	0
			@default 	0
			@min 		-100
			@max 		100
		*/
		/*--------------------------------------------------------*/
		/*~struct~ConfigTitleWindow:
			@param 	valid
			@type 		boolean
			@text 		valid customize
			@desc 		Turn on the settings for Title Window when this is true
			@default 	false

			@param fontSize
			@type 		number
			@text 		font size
			@desc 		Control the font size of Title Window
			@default 	28
			@min 		12
			@decimals 	0

			@param color
			@type 		string
			@text 		text color
			@desc 		Write a color name for texts of Title Window in english, rgb(red, green, blue), or hex-color
			@default 	white

			@param 	displayFrame
			@type 		boolean
			@text 		display window frame
			@desc 		Display the frame of Title Window when this is true
			@default 	true

			@param opacity
			@type 		number
			@text 		back opacity
			@desc 		Control the back opacity of Title Window
			@default 	192
			@min 		0
			@max 		255
			@decimals 	0

			@param 	width
			@type 		number
			@text 		width of window(px)
			@desc 		Control the width of Title Window; initial width is 240px
			@default 	240
			@min 		120
			@decimals 	0

			@param 	cols
			@type 		number
			@text 		columns
			@desc 		Control the columns in Title Window
			@default 	1
			@min 		1
			@decimals 	0

			@param 	backRect
			@type 		boolean
			@text 		rectangles behind selectors
			@desc 		Display rectangles behind selectors when this is true; parameter for MZ
			@default 	true

			@param 	stepRows
			@type 		number
			@text 		display commands as step
			@desc 		Display commands as step when this is not 0; ignoring the parameter cols
			@decimals 	0
			@default 	0
			@min 		-100
			@max 		100
		*/

		const parseConfigTitleWindow = s => JSON.parse(s, (key, value)=> {
			switch(key){
				case 'valid'		: return value;
				case 'fontSize'		: return Number(value);
				case 'color' 		: return value;
				case 'displayFrame' : return value;
				case 'opacity' 		: return Number(value);
				case 'width' 		: return Number(value);
				case 'cols' 		: return Number(value);
				case 'backRect' 	: return value;
				case 'stepRows' 	: return Number(value);
				default 			: return value;
			}
		});

		let configTitleWindow = params.configTitleWindow;
		let consolerNameConfigTitleWindow = 'configTitleWindow :';
		if(configTitleWindow){
			configTitleWindow = parseConfigTitleWindow(configTitleWindow);
			configTitleWindow = stringToBoolean(configTitleWindow);
		}else{
			configTitleWindow = makeNotValid();
			undefinedStructs.push(consolerNameConfigTitleWindow);
			consolerNameConfigTitleWindow += makeInvalidTerm();
		}
		consoler(consolerNameConfigTitleWindow, configTitleWindow);


if(configTitleWindow.valid){
	const _Window_TitleCommand_prototype_standardFontSize = Window_TitleCommand.prototype.standardFontSize;
	Window_TitleCommand.prototype.standardFontSize = function(){
		return configTitleWindow.fontSize || _Window_TitleCommand_prototype_standardFontSize.apply(this, arguments);
	};//*

	const _Window_TitleCommand_prototype_refreshFrame = Window_TitleCommand.prototype._refreshFrame;
	Window_TitleCommand.prototype._refreshFrame = function() {
	    if(configTitleWindow.displayFrame){
	    	_Window_TitleCommand_prototype_refreshFrame.apply(this, arguments);
	    }
	};//*

	const _Window_TitleCommand_prototype_updateBackOpacity = Window_TitleCommand.prototype.updateBackOpacity;
	Window_TitleCommand.prototype.updateBackOpacity = function() {
		const c = configTitleWindow;
	    this.backOpacity = c.opacity >= 0 ? c.opacity : _Window_TitleCommand_prototype_updateBackOpacity.apply(this, arguments);
	};//*

	const _Window_TitleCommand_prototype_windowWidth = Window_TitleCommand.prototype.windowWidth;
	Window_TitleCommand.prototype.windowWidth = function() {
	    return configTitleWindow.width || _Window_TitleCommand_prototype_windowWidth.apply(this, arguments);
	};//* for MV

	const _Scene_Title_prototype_mainCommandWidth = Scene_Title.prototype.mainCommandWidth;
	Scene_Title.prototype.mainCommandWidth = function() {
	    return configTitleWindow.width || _Scene_Title_prototype_mainCommandWidth.apply(this, arguments);
	};//* for MZ

	const _Window_TitleCommand_prototype_maxCols = Window_TitleCommand.prototype.maxCols;
	Window_TitleCommand.prototype.maxCols = function(){
		const c = configTitleWindow;
		const cols = !c.stepRows ? c.cols : _Window_TitleCommand_prototype_maxCols.apply(this, arguments);
		return cols || _Window_TitleCommand_prototype_maxCols.apply(this, arguments);
	};//*

	const _Window_Selectable_prototype_drawBackgroundRect = Window_Selectable.prototype.drawBackgroundRect;
	Window_Selectable.prototype.drawBackgroundRect = function(rect) {
	    if(configTitleWindow.backRect){
	    	_Window_Selectable_prototype_drawBackgroundRect.apply(this, arguments);
	    }
	};//* for MZ

	const _Window_TitleCommand_prototype_itemTextAlign = Window_TitleCommand.prototype.itemTextAlign;
	Window_TitleCommand.prototype.itemTextAlign = function(){
		const center = _Window_TitleCommand_prototype_itemTextAlign.apply(this, arguments);
		return configTitleWindow.stepRows ? 'left' : center;
	};//*

	const _Window_TitleCommand_prototype_itemRect = Window_TitleCommand.prototype.itemRect;
	Window_TitleCommand.prototype.itemRect = function(index) {
	    const rect = _Window_TitleCommand_prototype_itemRect.apply(this, arguments);
	    if(configTitleWindow.stepRows){
	    	rect.width = this.commandName(index).length * this.standardFontSize();
	    	if(index === 0){
	    		const right = this.windowWidth() - this.standardPadding()*2 - rect.width;
	    		this._right = configTitleWindow.stepRows < 0 ? right : 0;
	    	}
	    	rect.x += configTitleWindow.stepRows * index + this._right;
	    }
	    return rect;
	};//*

	const _Window_TitleCommand_prototype_resetTextColor = Window_TitleCommand.prototype.resetTextColor;
	Window_TitleCommand.prototype.resetTextColor = function() {
		if(configTitleWindow.color){
			this.changeTextColor(configTitleWindow.color);
			if(MZ) this.changeOutlineColor(ColorManager.outlineColor());

		}else{
			_Window_TitleCommand_prototype_resetTextColor.apply(this, arguments);
		}
	};//*
}////

if(MZ){
	//MZではタイトルのコマンドウィンドウが３項目に限定されているので、リストに従うように強化
	const _Scene_Title_prototype_calcWindowHeight = Scene_Title.prototype.calcWindowHeight;
	Scene_Title.prototype.calcWindowHeight = function(numLines, selectable){
		numLines += params.trophy ? 1 : 0;
		numLines += $gameJukebox && $gameJukebox.isValid() ? 1 : 0;
		if (selectable) {
	       	const cols = configTitleWindow.valid && !configTitleWindow.stepRows ? configTitleWindow.cols || 1 : 1;
	       	return Window_Selectable.prototype.fittingHeight(Math.ceil(numLines / cols));
	    } else {
	        return Window_Base.prototype.fittingHeight(numLines);
	    }
	};//*
}////

/**************************************************************************************************/

/*--------セーブとロードを強化-----------*/

		/*~struct~ConfigSaveLoad:ja
		@param 	valid
		@type 		boolean
		@text 		強化有効化
		@desc 		On(true)にすると、このストラクトを有効にします。
		@default 	false

		@param 	menuLoad
		@type 		boolean
		@text 		メニューからロード
		@desc 		On（true）にすると、タイトルに戻ることなくデータをロードすることができます。
		@default 	false

		@param 	loadName
		@type 		string
		@text 		ロードのシステム名
		@desc 		メニューで表示するロードの項目名を設定します。
		@default 	ロード

		@param 	displayGameTitle
		@type 		boolean
		@text 		ゲームタイトル表示
		@desc 		On（true）の時、ゲームタイトルを表示します。MVのみ有効です。
		@default 	true

		@param 	displayDifficulty
		@type 		boolean
		@text 		難易度表示
		@desc 		On（true）の時、MELOSで設定した難易度を表示します。難易度を有効にしてください。
		@default 	false

		@param 	displayGuide
		@type 		boolean
		@text 		ガイド表示
		@desc 		On（true）の時、MELOSで設定したメインガイドの次の目標が表示されます。ガイドを有効にしてください。
		@default 	false

		@param 	displayMapName
		@type 		boolean
		@text 		マップ名表示
		@desc 		On（true）の時、セーブしたマップの表示名が表示されます。
		@default 	false

		@param 	partyGraphic
		@type 		select
		@text 		パーティ表示方法
		@desc 		パーティメンバーを表示する方法を設定します。
		@default 	character
				@option 	表示なし
				@value 	none

				@option 	キャラクター
				@value 	character

				@option 	顔グラフィック
				@value 	face
		
		@param 	displayActorLevel
		@type 		boolean
		@text 		アクターLv表示
		@desc 		On（true）の時、パーティの表示に際し各アクターのLvも表示します。
		@default 	false

		@param 	displayGold
		@type 		boolean
		@text 		所持金表示
		@desc 		On（true）の時、パーティの所持金を表示します。
		@default 	false

		@param 	displaySaveDate
		@type 		boolean
		@text 		セーブ日時表示
		@desc 		On（true）の時、セーブした日時が表示されます。
		@default 	false

		@param 	playtimeName
		@type 		string
		@text 		プレイタイム名
		@desc 		プレイタイムの表示に際し、項目名として表示する文字列を設定します。

		@param 	displayVariable
		@type 		variable
		@text 		表示する変数
		@desc 		設定すると、特定の変数の値が表示されるようになります。
		@default 	0

		@param 	variableName
		@type 		string
		@text 		変数名
		@desc 		変数の表示に際し、項目名として表示する文字列を設定します。

		@param 	variableComplete
		@type 		Number
		@text 		コンプリート値
		@desc 		設定した変数において、コンプリートと見なす値を設定します。
		*/
		/*--------------------------------------------------------------------------*/
		/*~struct~ConfigSaveLoad:
		@param 	valid
		@type 		boolean
		@text 		config save load valid
		@desc 		Turn on this struct when this is true
		@default 	false

		@param 	menuLoad
		@type 		boolean
		@text 		load a data from Menu
		@desc 		Enable to load a game data from Menu Window when this is true
		@default 	false

		@param 	loadName
		@type 		string
		@text 		system name of load
		@desc 		Write a system name of load displayed in Menu Window
		@default 	Load

		@param 	displayGameTitle
		@type 		boolean
		@text 		display Game Titile
		@desc 		Display Game Title in File Window when this is true; only for MV
		@default 	true

		@param 	displayDifficulty
		@type 		boolean
		@text 		display difficulty
		@desc 		Display difficulty of MELOS when this is true
		@default 	false

		@param 	displayGuide
		@type 		boolean
		@text 		display Guide
		@desc 		Display a guide of MELOS when this is true
		@default 	false

		@param 	displayMapName
		@type 		boolean
		@text 		display map name
		@desc 		Display map name where you saved when this is true
		@default 	false

		@param 	partyGraphic
		@type 		select
		@text 		how to display party members
		@desc 		Setting of the way of displaying party members
		@default 	character
				@option 	not display
				@value 	none

				@option 	display character
				@value 	character

				@option 	display faces
				@value 	face
		
		@param 	displayActorLevel
		@type 		boolean
		@text 		display actor's level
		@desc 		Display actor's level with actor graphic when this is true
		@default 	false

		@param 	displayGold
		@type 		boolean
		@text 		display gold
		@desc 		Display party's gold in File Window when this is true
		@default 	false

		@param 	displaySaveDate
		@type 		boolean
		@text 		display saved date
		@desc 		Display saved date in File Window when this is true
		@default 	false

		@param 	playtimeName
		@type 		string
		@text 		name of play time
		@desc 		Write a name displayed in File Window for play time

		@param 	displayVariable
		@type 		variable
		@text 		display a special variable
		@desc 		Select a variable displayed in File Window
		@default 	0

		@param 	variableName
		@type 		string
		@text 		variable name
		@desc 		Write a name displayed in File Window for special variable

		@param 	variableComplete
		@type 		Number
		@text 		value for judging variable completed
		@desc 		Control the number for judging the varialbe value completed
		@default 	0
		*/

		const parseConfigSaveLoad = s => JSON.parse(s, (key, value) => {
			switch(key){
				case 'valid' 			: return value;
				case 'menuLoad' 		: return value;
				case 'loadName' 		: return value;
				case 'displayGameTitle' : return value;
				case 'displayDifficulty': return value;
				case 'displayGuide'		: return value;
				case 'displayMapName' 	: return value;
				case 'partyGraphic'		: return value;
				case 'displayActorLevel': return value;
				case 'displayGold'		: return value;
				case 'displaySaveDate'	: return value;
				case 'playtimeName' 	: return value;
				case 'displayVariable'	: return Number(value);
				case 'variableName'		: return value;
				case 'variableComplete' : return Number(value);
				default 				: return value;
			}
		});

		let configSaveLoad = params.configSaveLoad;
		let consolerNameConfigSaveLoad= 'configSaveLoad :';
		if(configSaveLoad){
			configSaveLoad = parseConfigSaveLoad(configSaveLoad);
			configSaveLoad = stringToBoolean(configSaveLoad);
		}else{
			configSaveLoad = makeNotValid();
			undefinedStructs.push(consolerNameConfigSaveLoad);
			consolerNameConfigSaveLoad += makeInvalidTerm();
		}
		consoler(consolerNameConfigSaveLoad, configSaveLoad);


if(configSaveLoad.valid){
	const _Window_MenuCommand_prototype_addSaveCommand = Window_MenuCommand.prototype.addSaveCommand;
	Window_MenuCommand.prototype.addSaveCommand = function() {
		_Window_MenuCommand_prototype_addSaveCommand.apply(this, arguments);
		if(configSaveLoad.menuLoad){
			    const enabled = true;
			    this.addCommand(configSaveLoad.loadName || 'ロード', 'load', enabled);
		}
	};//*

	const _Scene_Menu_prototype_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
	Scene_Menu.prototype.createCommandWindow = function() {
		_Scene_Menu_prototype_createCommandWindow.apply(this, arguments);

	    this._commandWindow.setHandler('load',      this.commandLoad.bind(this));
	};//*

	Scene_Menu.prototype.commandLoad = function() {
	    SceneManager.push(Scene_Load);
	};//*

	const _DataManager_makeSavefileInfo = DataManager.makeSavefileInfo;
	DataManager.makeSavefileInfo = function() {
		const info = _DataManager_makeSavefileInfo.apply(this, arguments);
	    
	   	return DataManager.makeAddSavefileInfo(info);
	};//*

	DataManager.makeAddSavefileInfo = function(info){
		const c = configSaveLoad;
		if(c.displayDifficulty && configDifficulty.type !== 'none'){
			info.difficulty = $gameSystem.currentDifficulty();
		}
		if(c.displayGuide && guide.valid){
			const quests = $gameGuide.filterMainNotComp();
			const name = quests.length > 0 ? quests[0].name : '';
			const subChapters = quests.length > 0 ? quests[0].subChapters : [''];
			const phase = quests.length > 0 ? $gameGuide.getMainPhase(quests[0]) : 0;
			const subChapter = subChapters[phase].subChapterName;
			info.guideName = name;
			info.guideSubChapter = subChapter;
		}
		if(c.displayMapName){
			info.mapName = $dataMap.displayName;
		}
		if(c.displayActorLevel){
			info.actorLevels = $gameParty.levelsForSavefile();
		}
		if(c.displayGold){
			info.gold = $gameParty.gold();
		}
		if(c.displayVariable){
			info.variable = $gameVariables.value(c.displayVariable);
		}

		const timeStamps = Date(info.timestamp).split(' ');
	    const year = timeStamps[3];
	    const month = new Date().getMonth() + 1;
	    const headNum = month < 10 ? '0' : '';
	    const date = timeStamps[2];
	    const time = timeStamps[4];
		info.saveDate = `${year}/${headNum}${month}/${date}`;
		info.saveTime = time;

		return info;
	};//*

	Game_Party.prototype.levelsForSavefile = function() {
	    return this.battleMembers().map(function(actor) {
	        return actor.level;
	    });
	};//*

	//セーブファイルに項目を表示するファンクションたち
	const _Window_SavefileList_prototype_drawGameTitle = Window_SavefileList.prototype.drawGameTitle;
	Window_SavefileList.prototype.drawGameTitle = function(info, x, y, width) {
		const titleOk = configSaveLoad.displayGameTitle;
		this.resetFontSettings();
	    if (MV && titleOk) {	
	       	_Window_SavefileList_prototype_drawGameTitle.apply(this, arguments);
	    }
	    this.makeFontSmaller();
	    this.drawGuide(info, x, y, width, titleOk);

	    this.makeFontSmaller();
	    const leftX = x - 192;
	    const leftWidth = 168;
	    
	    this.drawDifficulty(info, leftX, y, leftWidth);
	  	this.drawVariable(info, leftX, y, leftWidth);
	};//*

	Window_SavefileList.prototype.drawGuide = function(info, x, y, width, titleOk){
		if(info.guideName){
	    	const subChapter = info.guideSubChapter ? '/'+info.guideSubChapter : '';
	    	if(MZ || titleOk){
	    		const guideY = y + this.lineHeight() - (MZ ? 10 : 0);
	    		const subGuideY = y + this.lineHeight() * 1.7 - (MZ ? 10 : 0);
	    		this.drawText(info.guideName, x + 280, guideY, width - 480);
	    		this.makeFontSmaller();
	    		this.drawText(subChapter, x + 280 + this.contents.fontSize, subGuideY, width - 480);
	    	}else{
	    		this.drawText(info.guideName + subChapter, x, y, width - 200);
	    	}
	    }
	};//*

	Window_SavefileList.prototype.drawDifficulty = function(info, leftX, y, leftWidth){
		if(configSaveLoad.displayDifficulty){
	  		const difY = y + this.lineHeight();
	  		this.changeTextColor(this.systemColor());
	  		this.drawText(configDifficulty.name, leftX, difY, leftWidth);
	  		this.resetTextColor();
	  		this.drawText(info.difficulty, leftX, difY, leftWidth, 'right');
	  	}
	};//*

	Window_SavefileList.prototype.drawVariable = function(info, leftX, y, leftWidth){
		if(configSaveLoad.displayVariable){
	    	const bottomY = y + this.itemHeight() - (MZ ? 40 : 30);
	    	this.changeTextColor(this.systemColor());
	    	this.drawText(`${configSaveLoad.variableName}:`, leftX, bottomY, leftWidth);
	    	const completed = info.variable === configSaveLoad.variableComplete;
	    	completed ? this.changeTextColor(this.crisisColor()) : this.resetTextColor();
	    	this.drawText(info.variable, leftX, bottomY, leftWidth, 'right');
	    	this.resetTextColor();
	    }
	};//*

	if(MZ){
		//MZではdrawGameTitleがオミットされ、ファイルIDを書くdrawTitleのみになっている。
		//そこで、drawContentsの処理に先立ってdrawGameTitleを実行する。
		const _Window_SavefileList_prototype_drawContents = Window_SavefileList.prototype.drawContents;
		Window_SavefileList.prototype.drawContents = function(info, rect) {
			this.drawGameTitle(info, rect.x + 192, rect.y, rect.width - 192);
	    
		    _Window_SavefileList_prototype_drawContents.apply(this, arguments);
		};//*
	}////

	const _Window_SavefileList_prototype_drawPartyCharacters = Window_SavefileList.prototype.drawPartyCharacters;
	Window_SavefileList.prototype.drawPartyCharacters = function(info, x, y) {
		//this.makeFontSmaller();
		const charaPadding = configSaveLoad.displayActorLevel ? 60 : 48;
		if(configSaveLoad.partyGraphic === 'character'){
				for (var i = 0; i < info.characters.length; i++) {
		            var data = info.characters[i];
			        this.drawCharacter(data[0], data[1], x + i * charaPadding, y);
			        if(info.actorLevels){
			        	this.drawText(`${TextManager.levelA} ${info.actorLevels[i]}`, x + i * charaPadding, y - 28, 36, 'right');
			        }
			    }
		}else if (configSaveLoad.partyGraphic === 'face'){
		        for (var i = 0; i < info.faces.length; i++) {
		            var data = info.faces[i];
			        this.drawFace(data[0], data[1], x + i * charaPadding, y);
			        if(info.actorLevels){
			        	this.drawText(`${TextManager.levelA} ${info.actorLevels[i]}`, x + i * charaPadding, y - 28, 36, 'right');
			        }
			    }
			    
		}
	};//*

	const _Window_SavefileList_prototype_drawFace = Window_SavefileList.prototype.drawFace;
	Window_SavefileList.prototype.drawFace = function(faceName, faceIndex, x, y, width, height) {
	    width = width || Window_Base._faceWidth;
	    height = height || Window_Base._faceHeight;
	    var bitmap = ImageManager.loadFace(faceName);
	    var pw = Window_Base._faceWidth;
	    var ph = Window_Base._faceHeight;
	    var sw = Math.min(width, pw);
	    var sh = Math.min(height, ph);
	    var dx = Math.floor(x + Math.max(width - pw, 0) / 2) - 20;
	    var dy = Math.floor(y + Math.max(height - ph, 0) / 2) - 60;
	    var sx = faceIndex % 4 * pw + (pw - sw) / 2;
	    var sy = Math.floor(faceIndex / 4) * ph + (ph - sh) / 2;
	    this.contents.blt(bitmap, sx, sy, sw, sh, dx, dy, 60, 60);
	};//*

	const _Window_SavefileList_prototype_drawPlaytime = Window_SavefileList.prototype.drawPlaytime;
	Window_SavefileList.prototype.drawPlaytime = function(info, x, y, width) {
		//drawContentsがMVとMZとで内容が違うため、マップ名、所持金、セーブ日時もここでまとめて設定する
		const coe = 0.68;
		let lines = 0;
		if(configSaveLoad.displaySaveDate){
	    	this.drawText(`${info.saveDate} ${info.saveTime}`, x, y, width, 'right');
	    	y -= this.lineHeight() * coe;
	    	lines ++;
	    }
	    if (info.playtime) {
	    	const name = configSaveLoad.playtimeName || '';
	    	this.changeTextColor(this.systemColor());
	    	this.drawText(name ? `${name}　` : name, x, y, width - 48, 'right');
	    	this.resetTextColor();
	        this.drawText(info.playtime, x, y, width, 'right');
	        y -= this.lineHeight() * coe;
	        lines ++;
	    }
		if(configSaveLoad.displayGold){
			this.drawCurrencyValue(info.gold, TextManager.currencyUnit, x, y, width);
			if( MV || (MZ && lines < 2) ) y -= this.lineHeight() * coe;
			lines ++;
		}	
		if(info.mapName){
			if(MZ && lines >= 3) width -= 200;
			this.drawText(info.mapName, x, y, width, 'right');
		}
	};//*
};////


/*----------------コンフィグの拡張設定　end-----------------------------*/


/********************************************************************************************/
/*-------------------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------------------*/
/********************************************************************************************/


/*----- structing Status----------------------------------------
  				アクター能力値の拡張に関する設定
			 ___ 	_____  	 ___ 	_____ 	  		  ___
			|___ 	  | 	|___| 	  | 	| 	| 	 |___
				| 	  | 	| 	| 	  | 	| 	| 		 |
			 ___|	  |		| 	|  	  | 	|___|	  ___|
  -------------------------------------------------------*/

/********************************************************************************************/
/*-------------------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------------------*/
/********************************************************************************************/

		/*~struct~StatusParameter:ja
		@param 	addon
		@type 		boolean
		@text 		拡張実行
		@desc 		On（true）にすると、この親子ブロックにおけるパラメーターを反映させます。
		@default 	true
		

		@param 	hpCost
		@type 		boolean
		@text 		スキルのコスト拡張
		@desc 		On（true）にすると、スキルにHPやアイテムの消費を設定できます。また、消費コストの表示も変更されます。
		@default 	false

		@param 	rotateLevelParam
		@type 		boolean
		@text 		ステータス循環
		@desc 		On（true）の時、Lv100以上になると循環してステータスを加算します。
		@default 	true

		@param 	levelUpHeal
		@type 		boolean
		@text 		レベルアップ後回復
		@desc 		On（true）にすると、レベルアップ後にHPとMPが全回復します。
		@default 	true

		@param 	maxDamage
		@type 		number
		@text 		ダメージ上限
		@desc 		ダメージ・回復の上限値を設定します。0にすると上限がなくなります。
		@default 	0
		@decimals 	0

		@param 	buffRate
		@type 		number
		@text 		バフの補正率（％）
		@desc 		スキルやアイテムの「使用効果」で付与できる強化・弱体の補正値を設定できます。初期値は25です。
		@default 	25
		@decimals 	0
		
		@param 	buffType
		@type 		select
		@text 		バフの補正方法
		@desc 		バフの上乗せ方法を設定します。詳細はプラグインヘルプをご覧ください。
		@default 	add
		 @option 	加算方式
		 @value 	add

		 @option 	累乗方式
		 @value 	expo

		
		@param 	buffMax
		@type 		number
		@text 		強化の上限回数
		@desc 		強化効果を重ねがけできる最大回数を設定します。初期値は2です。
		@default 	2
		@decimals 	0
		
		@param 	debuffMax
		@type 		number
		@text 		弱体の上限回数
		@desc 		弱体効果を重ねがけできる最大回数を設定します。初期値は2です。
		@default 	2
		@decimals 	0

		@param 	variance
		@type 		select
		@text 		ダメージ乱数
		@desc 		ダメージの乱数の計算方法を設定します。
		@default 	default
				@option 	デフォルト（計算式の設定通り）
				@value 		default

				@option 	乱数なし
				@value 		zero


		@param 	criticalPoint
		@type 		number
		@text 		クリティカル補正値
		@desc 		クリティカル時、ダメージ結果に掛ける補正値を設定します。初期値は3です。小数第２位まで設定できます。
		@default 	3
		@min 		1
		@decimals 	2

		@param 	criticalStatus
		@type 		number
		@text 		クリティカルステータス
		@desc 		クリティカルダメージを上昇させるステータスを設定します。追加能力のID　10~19から選んで下さい。20で無効にします。
		@default 	20
		@max 		20
		@min 		10
		@decimals 	0

		@param 	criticalCalc
		@type 		select
		@text 		ステータス計算方式
		@desc 		クリティカル補正値にクリティカルステータスを計算する方式を設定します。
		@default 	simpleAdd
			@option 	そのまま加算
			@value 	simpleAdd

			@option 	小数にして加算
			@value 	decimalAdd

			@option 	小数にして乗算
			@value 	decimalMulti

		@param 	criticalBonus
		@type 		select
		@text 		クリティカルボーナス
		@desc 		クリティカル時、ダメージ計算に与えるボーナス補正を設定します。
		@default 	none
			@option 	なし
			@value 	none

			@option 	敵バフ・味方デバフ無視
			@value 	ignoreBuff

			@option 	ダメージ軽減率無視
			@value 	passDefence

		@param 	criticalNoMax
		@type 		boolean
		@text 		クリティカル時上限無視
		@desc 		On（true）の時、クリティカル時にダメージ上限の設定を無視します。
		@default 	false

		*/
		/*----------------------------------------------------------------------------------------------------*/
		/*~struct~StatusParameter:
		@param 	addon
		@type 		boolean
		@text 		expansion status
		@desc 		Turn on all children of "statusParameter" when this is true
		@default 	true
		

		@param 	hpCost
		@type 		boolean
		@text 		Hp cost for skills
		@desc 		Available skill cost by hp or items, and displaying all costs when this is true 
		@default 	false

		@param 	rotateLevelParam
		@type 		boolean
		@text 		circulate Parameter
		@desc 		Add rotated Parameter to Lv.99 Parameter when this is true
		@default 	true

		@param 	levelUpHeal
		@type 		boolean
		@text 		healing after level up
		@desc 		Heal an actor's HP and MP whose level has rosen when this is true
		@default 	true

		@param 	maxDamage
		@type 		number
		@text 		max damage
		@desc 		Control max value of damage or heal, unless this is 0
		@default 	0
		@decimals 	0

		@param 	buffRate
		@type 		number
		@text 		rate of buff or debuff（％）
		@desc 		Control the rate by used counts; initial value is 25
		@default 	25
		@decimals 	0
		
		@param 	buffType
		@type 		select
		@text 		type of calculation buff or debuff
		@desc 		Select the type, refering to this help if you need
		@default 	add
		 @option 	Add type
		 @value 	add

		 @option 	Expo type
		 @value 	expo

		
		@param 	buffMax
		@type 		number
		@text 		max times of buff
		@desc 		Control max times to use buff; initial value is 2
		@default 	2
		@decimals 	0
		
		@param 	debuffMax
		@type 		number
		@text 		max times of debuff
		@desc 		Control max times to use debuff; initial value is 2
		@default 	2
		@decimals 	0

		@param 	variance
		@type 		select
		@text 		variance of damage
		@desc 		Select a type to calculate variance of damage
		@default 	default
				@option 	default（along formula）
				@value 		default

				@option 	no variance
				@value 		zero


		@param 	criticalPoint
		@type 		number
		@text 		critical adjuster
		@desc 		Control a number with the second decimals, by which critical damage is multiplied; initial value is 3
		@default 	3
		@min 		1
		@decimals 	2

		@param 	criticalStatus
		@type 		number
		@text 		status for critical damage
		@desc 		Select a parameterId of status for raising critical damage; 20 works invalid
		@default 	20
		@max 		20
		@min 		10
		@decimals 	0

		@param 	criticalCalc
		@type 		select
		@text 		type of calculation critical
		@desc 		Select a type of calculation "criticalPoint" with parameter of "criticalStatus"
		@default 	simpleAdd
			@option 	simpleAdd (former + later)
			@value 	simpleAdd

			@option 	decimalAdd(former + later * 0.01)
			@value 	decimalAdd

			@option 	decimalMulti(former * later * 0.01)
			@value 	decimalMulti

		@param 	criticalBonus
		@type 		select
		@text 		critical bonus
		@desc 		Select a bonus given to calculation when critical occurs
		@default 	none
			@option 	no bonus
			@value 	none

			@option 	ignore brocker's buff and attacker's debuff
			@value 	ignoreBuff

			@option 	ignore damage cut rate
			@value 	passDefence

		@param 	criticalNoMax
		@type 		boolean
		@text 		ignore max damage on critical
		@desc 		Exceed max damage by critical when this is true
		@default 	false

		*/

		const parseStatusParameter = s => JSON.parse(s, (key, value)=>{
			switch(key){
				case 'addon'			: 	return value;
				case 'hpCost' 			: 	return value;
				case 'rotateLevelParam' : 	return value;
				case 'levelUpHeal' 		: 	return value;
				case 'maxDamage' 		: 	return Number.parseFloat(value);
				case 'buffRate' 		: 	return Number.parseFloat(value);
				case 'buffType' 		: 	return value;
				case 'buffMax' 			: 	return Number.parseFloat(value);
				case 'debuffMax'		: 	return Number.parseFloat(value);
				case 'variance' 		: 	return value;
				case 'criticalPoint' 	: 	return Number.parseFloat(value);
				case 'criticalStatus' 	: 	return Number.parseFloat(value);
				case 'criticalCalc' 	: 	return value;
				case 'criticalBonus' 	: 	return value;
				case 'criticalNoMax' 	: 	return value;
				default 				: 	return value;
			}
		});//*

		let statusParameter = params.statusParameter;
		let consolerNameStatusParameter = 'status parameter:';
		if(statusParameter){
			statusParameter = parseStatusParameter(statusParameter);
			statusParameter = stringToBoolean(statusParameter);
		}else{
			statusParameter = makeNotValid();
			undefinedStructs.push(consolerNameStatusParameter);
			consolerNameStatusParameter += makeInvalidTerm();
		}
		consoler(consolerNameStatusParameter, statusParameter);

	/*---------HPコストの設定--------------------------*/
const _Game_BattlerBase_prototype_initMembers_A = Game_BattlerBase.prototype.initMembers;
Game_BattlerBase.prototype.initMembers = function(){
	_Game_BattlerBase_prototype_initMembers_A.apply(this, arguments);

	this._hpLater = 0;
	this._mpLater = 0;
	this._tpLater = 0;
	this._itemLater = [];
};//*

if(statusParameter.addon && statusParameter.hpCost){
	//skillHpCostはオリジナルファンクションなので、鍵の外で定義	

	const _Game_BattlerBase_prototype_skillMpCost = Game_BattlerBase.prototype.skillMpCost;
	Game_BattlerBase.prototype.skillMpCost = function(skill) {
		let meta;
		if(skill.meta.mpCost){
			meta = JSON.parse(skill.meta.mpCost);	
		}
				
		let metaCost = meta ? meta[0] : Math.floor(skill.mpCost * this.mcr);
		let cost;
		switch(metaCost){
			case 'all' 		: cost = this._mp; break;
			case 'almost' 	: cost = this._mp - 1; break;
			case 'half' 	: cost = Math.floor(this._mp / 2); break;
			case 'quarter' 	: cost = Math.floor(this._mp / 4); break;
			default 		: cost = Number(metaCost) || 0;
		}
	return cost;
	};//*

	const _Game_BattlerBase_prototype_skillTpCost = Game_BattlerBase.prototype.skillTpCost;
	Game_BattlerBase.prototype.skillTpCost = function(skill) {
		let meta;
		if(skill.meta.tpCost){
			meta = JSON.parse(skill.meta.tpCost);	
		}
				
		let metaCost = meta ? meta[0] : skill.tpCost;
		let cost;
		switch(metaCost){
			case 'all' 		: cost = this._tp; break;
			case 'almost' 	: cost = this._tp - 1; break;
			case 'half' 	: cost = Math.floor(this._tp / 2); break;
			case 'quarter' 	: cost = Math.floor(this._tp / 4); break;
			default 		: cost = Number(metaCost) * parseInt(this.maxTp() / 100) || 0;
		}
	    return cost;
	};//*

	const _Game_BattlerBase_prototype_canPaySkillCost = Game_BattlerBase.prototype.canPaySkillCost;
	Game_BattlerBase.prototype.canPaySkillCost = function(skill) {
		const baseConditionOk = _Game_BattlerBase_prototype_canPaySkillCost.apply(this, arguments);
		return baseConditionOk &&  this._hp >= this.skillHpCost(skill);
	    /*return this._tp >= this.skillTpCost(skill) && 
	    		this._mp >= this.skillMpCost(skill) && 
	    		this._hp >= this.skillHpCost(skill);*/
	};//*

	const _Game_BattlerBase_prototype_paySkillCost = Game_BattlerBase.prototype.paySkillCost;
	Game_BattlerBase.prototype.paySkillCost = function(skill) {
			this.paySkillHpCost(skill);
			this.paySkillMpCost(skill);	
			this.paySkillTpCost(skill);
			this.paySkillItemCost(skill);
	};//*
			
	const _Game_Battler_prototype_onAllActionsEnd = Game_Battler.prototype.onAllActionsEnd;
	Game_Battler.prototype.onAllActionsEnd = function() {
		this.paySkillCostLater();
		_Game_Battler_prototype_onAllActionsEnd.apply(this, arguments);
	};//*

	//MP,TP,HPの消費コストが一括表示できるように調整
	if(MV){
		const _Window_SkillList_prototype_itemHeight = Window_SkillList.prototype.itemHeight;
		Window_SkillList.prototype.itemHeight = function(){
			const defaultHeight = _Window_SkillList_prototype_itemHeight.apply(this, arguments);
			const addHeight = Math.max(12, this.contents.fontSize - 12);
			return defaultHeight + addHeight;
		};//*
	}else if(MZ){
		const _Window_SkillList_prototype_itemLineRect = Window_SkillList.prototype.itemLineRect;
		Window_SkillList.prototype.itemLineRect = function(index) {
		    const rect = _Window_SkillList_prototype_itemLineRect.apply(this, arguments);
		    const addHeight = Math.max(20, this.contents.fontSize - 12);
		    rect.height += addHeight;
		    return rect;
		};//*
	}

	const _Window_SkillList_prototype_drawSkillCost = Window_SkillList.prototype.drawSkillCost;
	Window_SkillList.prototype.drawSkillCost = function(skill, x, y, width) {
		const fontSize = this.contents.fontSize;
		const costInterval = this.costInterval();
		y += ( fontSize - 4 );
		this.contents.fontSize = Math.max(20, fontSize - 12);

		const tpCost = this._actor.skillTpCost(skill);
	    if (tpCost > 0) {
	        this.changeTextColor(this.tpCostColor());  
	        this.drawText(tpCost, x, y, width, 'right');
	        width -= this.textWidth(tpCost + '0');
	        this.drawText(TextManager.tpA, x, y, width, 'right');
	        width -= this.textWidth(TextManager.tpA + costInterval);
	    }

	    const mpCost = this._actor.skillMpCost(skill);
	    if (mpCost > 0) {
	    	if(tpCost > 0) this.drawSlash(x, y, width);
	        this.changeTextColor(this.mpCostColor());
	        this.drawText(mpCost, x, y, width, 'right');
	        width -= this.textWidth(mpCost + '0');
	        this.drawText(TextManager.mpA, x, y, width, 'right');
	        width -= this.textWidth(TextManager.mpA + costInterval);
	    }

	    const hpCost = this._actor.skillHpCost(skill);
	    if (hpCost > 0) {
	    	if(tpCost > 0 || mpCost > 0) this.drawSlash(x, y, width);
	        this.changeTextColor(this.hpGaugeColor2());
	        this.drawText(hpCost, x, y, width, 'right');
	        width -= this.textWidth(hpCost + '0');
	        this.drawText(TextManager.hpA, x, y, width, 'right');
	        width -= this.textWidth(TextManager.hpA + costInterval);
	    }

	    if(skill.meta.skillItems){
	    	const items = JSON.parse(skill.meta.skillItems);
	    	this.resetTextColor();
	    	if(tpCost > 0 || mpCost > 0 || hpCost > 0) this.drawSlash(x, y, width);
	    	for(var i = items.length - 1; i >= 0; i--){
	    		let item = $dataItems[items[i].id];
	    		let itemCost = items[i].cost;
	    		if(itemCost === 'all') itemCost = $gameParty.numItems(item);

	    		this.drawText(itemCost, x, y, width, 'right');
	    		width -= this.textWidth(itemCost + '0');
	    		this.contents.fontSize -= this.skillItemNameAdjuster();
	    		this.drawText(item.name, x, y, width, 'right');
	    		width -= this.textWidth(item.name + costInterval);
	    		this.contents.fontSize += this.skillItemNameAdjuster();
	    		if(i > 0)this.drawSlash(x, y, width);
	    	}
	    }

	    this.contents.fontSize = fontSize;
	    return {"skill": skill, "x": x, "y": y, "width": width};
	};//*

	//スキルにアイテムの消費条件を追加
	const _Game_Actor_prototype_meetsSkillConditions = Game_Actor.prototype.meetsSkillConditions;
	Game_Actor.prototype.meetsSkillConditions = function(skill) {
	    const baseConditionOk = _Game_Actor_prototype_meetsSkillConditions.apply(this, arguments);
	    if(!skill.meta.skillItems){
	    	return baseConditionOk;
	    }else{
	    	const itemConditionOk = this.meetsSkillConditionsByItem(skill);
	    	return baseConditionOk && itemConditionOk;
	    }
	};//*
}////


Game_Actor.prototype.meetsSkillConditionsByItem = function(skill){
	const items = JSON.parse(skill.meta.skillItems);
	const itemConditionOk = items.every(item => {
  		if(!$dataItems[item.id]) return false;

  		if(item.cost === 'all'){
  			return $gameParty.hasItem($dataItems[item.id])
  		}else{
  			return item.cost <= $gameParty.numItems($dataItems[item.id]);
  		}
  	})
  	return itemConditionOk;
};//*
if(!statusParameter.addon || !statusParameter.hpCost) Game_Actor.prototype.meetsSkillConditionsByItem  = function(){return false};

Window_SkillList.prototype.costInterval = function(){
	return this.costWidth();
};//*

Window_SkillList.prototype.skillItemNameAdjuster = function(){
	return 6;
};//*

Window_SkillList.prototype.drawSlash = function(x, y, width){
	this.resetTextColor();
	this.drawText('/', x, y, width + this.costInterval()/2, 'right');
};//*

Game_BattlerBase.prototype.skillHpCost = function(skill) {
	let meta;
	if(skill.meta.hpCost){
		meta = JSON.parse(skill.meta.hpCost);	
	}
				
	let metaCost = meta ? meta[0] : 0;
	let cost;
	switch(metaCost){
		case 'all' 		: cost = this._hp; break;
		case 'almost' 	: cost = this._hp - 1; break;
		case 'half' 	: cost = Math.floor(this._hp / 2); break;
		case 'quarter' 	: cost = Math.floor(this._hp / 4); break;
		default 		: cost = Number(metaCost) || 0;
	}
				
	return cost;
};//*
if(!statusParameter.addon || !statusParameter.hpCost) Game_BattlerBase.prototype.skillHpCost = function(skill) {return 0};


Game_BattlerBase.prototype.paySkillCostLater = function(){
	this._hp -= this._hpLater;
	this._mp -= this._mpLater;
	this._tp -= this._tpLater;
	this.paySkillItemCostLater();
				
	this._hpLater = 0;
	this._mpLater = 0;
	this._tpLater = 0;
	this._itemLater = [];
};//*
if(!statusParameter.addon || !statusParameter.hpCost) Game_BattlerBase.prototype.paySkillCostLater = function(){};



Game_BattlerBase.prototype.paySkillHpCost = function(skill){
	let hpLater = false;
	if(skill.meta.hpCost){
			hpLater = JSON.parse(skill.meta.hpCost);
			hpLater = hpLater[1];
	};

	if(!hpLater){
			this._hp -= this.skillHpCost(skill);	
	}else{
			this._hpLater = this.skillHpCost(skill);
	}
};//*
if(!statusParameter.addon || !statusParameter.hpCost) Game_BattlerBase.prototype.paySkillHpCost = function(skill){};


Game_BattlerBase.prototype.paySkillMpCost = function(skill){
	let mpLater = false;
	if(skill.meta.mpCost){
			mpLater = JSON.parse(skill.meta.mpCost);
			mpLater = mpLater[1];
	};

	if(!mpLater){
			this._mp -= this.skillMpCost(skill);	
	}else{
			this._mpLater = this.skillMpCost(skill);
	}
};//*
if(!statusParameter.addon || !statusParameter.hpCost) Game_BattlerBase.prototype.paySkillMpCost = function(skill){};


Game_BattlerBase.prototype.paySkillTpCost = function(skill){
	let tpLater = false;
	if(skill.meta.tpCost){
			tpLater = JSON.parse(skill.meta.tpCost);
			tpLater = tpLater[1];
	};
							
	if(!tpLater){
			this._tp -= this.skillTpCost(skill);		
	}else{
			this._tpLater = this.skillTpCost(skill);
	}
};//*
if(!statusParameter.addon || !statusParameter.hpCost) Game_BattlerBase.prototype.paySkillTpCost = function(skill){};

	//以下スキルのアイテム消費はhpCostがOnの時にしか呼び出されないので特に封印しない
Game_BattlerBase.prototype.paySkillItemCost = function(skill){};//useItemがBattler由来のため、ひとまず定義だけ

Game_Actor.prototype.paySkillItemCost = function(skill){
	if(skill.meta.skillItems){
		const items = JSON.parse(skill.meta.skillItems);
		let reloadItemId = 0;
		items.forEach((item, index) => {
			let itemPossession = $gameParty.numItems($dataItems[item.id]);
			let cost = item.cost === 'all' ? itemPossession : item.cost;
			if(index === 0 && item.cost === 1 && skill.meta.reloadItem){
				let reloadItem = JSON.parse(skill.meta.reloadItem);
				reloadItemId = reloadItem.id;
				let maxNum = $gameVariables.value(reloadItem.maxVid);
				let reloadPossession = $gameParty.numItems($dataItems[reloadItemId]);
				let needReloadNum = maxNum - reloadPossession;
				cost = Math.min(needReloadNum, itemPossession);
			}

			if(item.later){
				this._itemLater.push({"id": item.id, "cost": cost, "reloadId": reloadItemId});
			}else{
				for(var i = 0; i < cost; i++){
					this.consumeItem($dataItems[item.id]);
					if(reloadItemId > 0) $gameParty.gainItem($dataItems[reloadItemId], 1, false, true);
				}
			}
		});
	}
};//*

Game_BattlerBase.prototype.paySkillItemCostLater = function(){};

Game_Actor.prototype.paySkillItemCostLater = function(){
	if(this._itemLater.length > 0){
		this._itemLater.forEach(item => {
			for(var i = 0; i < item.cost; i++){
				this.consumeItem($dataItems[item.id]);
				if(reloadItemId > 0) $gameParty.gainItem($dataItems[reloadItemId], 1, false, true);
			}
		});
	}
};//*

	/*---------レベルアップに回復追加--------------------------*/
if(statusParameter.addon){

	const _Game_Actor_prototype_levelUp = Game_Actor.prototype.levelUp;
	Game_Actor.prototype.levelUp = function(){
		_Game_Actor_prototype_levelUp.apply(this, arguments);

		if(statusParameter.levelUpHeal){
			this._hp = this.mhp;
    		this._mp = this.mmp;
		}
	};//*
}////

	/*------------レベルの拡張----------------------------*/
const _Game_Enemy_prototype_initMembers = Game_Enemy.prototype.initMembers;
Game_Enemy.prototype.initMembers = function(){
	_Game_Enemy_prototype_initMembers.apply(this, arguments);
	this._level = 0;
	this._maxLevel = 0;
};//*

if(statusParameter.addon){
	const _Game_Actor_prototype_maxLevel = Game_Actor.prototype.maxLevel;
	Game_Actor.prototype.maxLevel = function() {
	    return this.actor().meta.level || _Game_Actor_prototype_maxLevel.apply(this, arguments);
	};//*
	//paramBaseは追加能力定義でオーバーライドしているので、そちらにLv99以上の処理をもたせる↓↓

	Object.defineProperty(Game_Enemy.prototype, 'level', {
	    get: function() {
	        return this._level;
	    },
	    configurable: true
	});

	const _Game_Enemy_prototype_setup = Game_Enemy.prototype.setup;
	Game_Enemy.prototype.setup = function(enemyId, x, y) {
	    _Game_Enemy_prototype_setup.apply(this, arguments);
	    this._level = this.setupLevel(enemyId);
	    this._maxLevel = Math.max(this._level, 99);
	};//*
}////	
	
Game_Enemy.prototype.setupLevel = function(enemyId){
	const data = this.enemy(enemyId);
	const level = data.meta.level;
	return level > 0 ? Number(level) : 1;
};//*
if(!statusParameter.addon) Game_Enemy.prototype.setupLevel = function(enemyId){return 0};


Game_Enemy.prototype.maxLevel = function(){
	return this._maxLevel;
};//*
if(!statusParameter.addon) Game_Enemy.prototype.maxLevel = function(){return 0};


Game_BattlerBase.prototype.isNTimesLevel = function(n){
	if(n < 2){
		return false;
	}else{
		const level = this._level;
		return level % n === 0;	
	}
};//*
if(!statusParameter.addon) Game_BattlerBase.prototype.isNTimesLevel = function(n){return false};


	/*---------バフ補正に関する設定--------------*/
Game_Action.prototype.changeIgnoreBuff = function(){};

const _Game_BattlerBase_prototype_initMembers_B = Game_BattlerBase.prototype.initMembers;
Game_BattlerBase.prototype.initMembers = function() {
    _Game_BattlerBase_prototype_initMembers_B.apply(this, arguments);
    this._ignoreBuff = false;
};//*


if(statusParameter.addon){
	const _Game_BattlerBase_prototype_paramBuffRate = Game_BattlerBase.prototype.paramBuffRate;
	Game_BattlerBase.prototype.paramBuffRate = function(paramId){
		_Game_BattlerBase_prototype_paramBuffRate.apply(this, arguments);

		const buffRate = statusParameter.buffRate / 100 ;
		switch(statusParameter.buffType){
			case 'add':
				return this._buffs[paramId] * buffRate + 1.0;
			break;

			case 'expo':
				return Math.pow(buffRate + 1.0, this._buffs[paramId]);
			break;
		}
	};//*

	const _Game_BattlerBase_prototype_isMaxBuffAffected = Game_BattlerBase.prototype.isMaxBuffAffected;
	Game_BattlerBase.prototype.isMaxBuffAffected = function(paramId){
		_Game_BattlerBase_prototype_isMaxBuffAffected.apply(this, arguments);

		return this._buffs[paramId] === statusParameter.buffMax;
	};//*

	const _Game_BattlerBase_prototype_isMaxDebuffAffected = Game_BattlerBase.prototype.isMaxDebuffAffected;
	Game_BattlerBase.prototype.isMaxDebuffAffected = function(paramId){
		_Game_BattlerBase_prototype_isMaxDebuffAffected.apply(this, arguments);

		return this._buffs[paramId] === statusParameter.debuffMax * -1;		
	};//*
}////
	
if(statusParameter.addon && statusParameter.criticalBonus === 'ignoreBuff'){
	Game_Action.prototype.changeIgnoreBuff = function(critical){
		if(critical){
				const subject = this.subject();
	    		subject.turnIgnoreBuff();
	   	}
	};//*

	Game_BattlerBase.prototype.ignoreBuff = function(){
		return this._ignoreBuff;
	};//*

	Game_BattlerBase.prototype.turnIgnoreBuff = function(){
		this._ignoreBuff = !this._ignoreBuff;
	};//*

	const _Game_BattlerBase_prototype_param = Game_BattlerBase.prototype.param;
	Game_BattlerBase.prototype.param = function(paramId) {
	    var value = this.paramBase(paramId) + this.paramPlus(paramId);
	    	if(this.ignoreBuff()){
	    		if(this.isActing()){
		    			if( this._buffs.some(buff => {return buff < 0}) ){
		    				value *= this.paramRate(paramId);
		    			}else{
		    				value *= this.paramRate(paramId) * this.paramBuffRate(paramId);
		    			};
		    	}else{
		    			if( this._buffs.some(buff => {return buff > 0}) ){
		    				value *= this.paramRate(paramId);
		    			}else{
		    				value *= this.paramRate(paramId) * this.paramBuffRate(paramId);
		    			};
		    	}
	    	}else{
	    		value *= this.paramRate(paramId) * this.paramBuffRate(paramId);
	    	};
	    var maxValue = this.paramMax(paramId);
	    var minValue = this.paramMin(paramId);
	    return Math.round(value.clamp(minValue, maxValue));
	};//*
}////

if(statusParameter.addon){
	const _Game_Action_prototype_makeDamageValue = Game_Action.prototype.makeDamageValue;
	Game_Action.prototype.makeDamageValue = function(target, critical) {
	    var item = this.item();
	   	this.changeIgnoreBuff(critical);
	    var baseValue = this.evalDamageFormula(target);
	   	this.changeIgnoreBuff(critical);

	    var value = baseValue * this.calcElementRate(target);
		   	value = this.calcDamageCutRate(target, value, critical);
	    if (baseValue < 0) {
	        value *= target.rec;
	    }

	    value = this.neoApplyCritical(target, value, critical);
		value = this.applyVariance(value, item.damage.variance);
	    value = this.applyGuard(value, target);
	    value = Math.round(value);
	    value = this.calcMaxDamage(value, critical);
	    return value;
	};//*

	Game_Action.prototype.calcDamageCutRate = function(target, value, critical){
		if (this.isPhysical() && !this.isPassedDefence(critical)) {
	        value *= target.pdr;
	    }
	    if (this.isMagical() && !this.isPassedDefence(critical)) {
	        value *= target.mdr;
	    }
	    return value;
	};//*

	Game_Action.prototype.neoApplyCritical = function(target, value, critical){
		if (critical) {
	    		//ダメージ率が100%以上＝ダメージが増大する場合は、軽減率無視の場合でもそのまま反映する
		    	if(this.isPhysical() && this.isPassedDefence(critical) && target.pdr > 1){
			    		value *= target.pdr;
		    	}else if(this.isMagical() && this.isPassedDefence(critical) && target.mdr > 1){
			    		value *= target.mdr;
		    	}

		        value = this.applyCritical(value);
		};
	    return value;
	};//*

	Game_Action.prototype.calcMaxDamage = function(value, critical){
		const item = this.item();
			const itemNoMax = item.meta.noMax;
			const itemCriNoMax = item.meta.criticalNoMax && critical;
			const criticalNoMax = statusParameter.criticalNoMax && critical;
		const noMax = itemNoMax || itemCriNoMax || criticalNoMax;
		if(!noMax && statusParameter.maxDamage){
				const max = statusParameter.maxDamage
				const min = -1 * statusParameter.maxDamage;
				value = value.clamp(min, max);
		}
		return value;
	};//*

	Game_Action.prototype.isPassedDefence = function(critical){
		return statusParameter.criticalBonus === 'passDefence' && critical;
	};//*
	//------------------------------------------------------------------//
	const _Game_Action_prototype_applyCritical = Game_Action.prototype.applyCritical;
	Game_Action.prototype.applyCritical = function(damage) {
		let critical = statusParameter.criticalPoint;
		if(statusParameter.criticalStatus !== 20){
				let criticalStatus = this.subject().param(statusParameter.criticalStatus);

				switch(statusParameter.criticalCalc){
						case 'simpleAdd' :
						//consoler('criticalRate:', criticalStatus);
							critical += criticalStatus;
						break;

						case 'decimalAdd' :
							critical += criticalStatus / 100;
						break;

						case 'decimalMulti' :
							critical *= (1 + criticalStatus / 100);
						break;
				}
		};
		return damage * critical;
	};//*

	const _Game_Action_prototype_applyVariance = Game_Action.prototype.applyVariance;
	Game_Action.prototype.applyVariance = function(damage, variance) {
		switch(statusParameter.variance){
			case 'zero' : variance = 0; break;
		};

		var amp = Math.floor(Math.max(Math.abs(damage) * variance / 100, 0));
		var v = Math.randomInt(amp + 1) + Math.randomInt(amp + 1) - amp;
		return damage >= 0 ? damage + v : damage - v;
	};//*
}////

	/*----------通常攻撃、防御、アイテムのコマンド強化--------------------*/
if(statusParameter.addon){
	const _Window_ActorCommand_prototype_addAttackCommand = Window_ActorCommand.prototype.addAttackCommand;
	Window_ActorCommand.prototype.addAttackCommand = function() {
		const skillId = this._actor.attackSkillId();
		if(skillId > 1){
			const skillName = $dataSkills[skillId].name;
			this.addCommand(skillName, 'attack', this._actor.canAttack());
		}else{
			_Window_ActorCommand_prototype_addAttackCommand.apply(this, arguments);
		}
	};//*

	const _Window_ActorCommand_prototype_addGuardCommand = Window_ActorCommand.prototype.addGuardCommand;
	Window_ActorCommand.prototype.addGuardCommand = function() {
	    const skillId = this._actor.guardSkillId();
		if(skillId > 2){
			const skillName = $dataSkills[skillId].name;
			this.addCommand(skillName, 'guard', this._actor.canGuard());
		}else{
			_Window_ActorCommand_prototype_addGuardCommand.apply(this, arguments);
		}
	};//*

	const _Game_BattlerBase_prototype_attackSkillId = Game_BattlerBase.prototype.attackSkillId;
	Game_BattlerBase.prototype.attackSkillId = function() {
	    return this.overriddenAttackSkillId() || _Game_BattlerBase_prototype_attackSkillId.apply(this, arguments);
	};//*

	const _Game_BattlerBase_prototype_guardSkillId = Game_BattlerBase.prototype.guardSkillId;
	Game_BattlerBase.prototype.guardSkillId = function() {
	    return  this.overriddenGuardSkillId() || _Game_BattlerBase_prototype_guardSkillId.apply(this, arguments);
	};//*

	const _Window_ActorCommand_prototype_addItemCommand = Window_ActorCommand.prototype.addItemCommand;
	Window_ActorCommand.prototype.addItemCommand = function() {
		const metaBase = this._actor.getAllMetas();
		if(metaBase.length === 0) _Window_ActorCommand_prototype_addItemCommand.apply(this, arguments);

		if(!metaBase[0].unusableItem && !metaBase[1].unusableItem){
			const metas = metaBase.filter(meta => {return meta.unusableItem});
			const usable = metas.length === 0;//falseの時、装備かステートによる一時的な封印状態
			this.addCommand(TextManager.item, 'item', usable);
		}
		//アクターかクラス由来のアイテム封印は、コマンド自体を非表示にするので処理なし
	};//*

	const _Window_BattleItem_prototype_isEnabled = Window_BattleItem.prototype.isEnabled;
	Window_BattleItem.prototype.isEnabled = function(item) {
	    const isEnabled = _Window_BattleItem_prototype_isEnabled.apply(this, arguments);
		if(!isEnabled) return false;

		const actor = BattleManager.actor();
	    const metaBase = actor.getAllMetas();
	    if(metaBase.length === 0) return true;

	    const metas = metaBase.filter(meta => {return meta.unusableItemIds});
	    if(metas.length === 0) return true;

	    const unusableItemIds = metas.map(meta => {return JSON.parse(meta.unusableItemIds)});
	    let ids = [];
	    unusableItemIds.forEach(meta => { meta.forEach( id => ids.push(id) ) });
	    return !ids.contains(item.id);
	};
}////

Game_BattlerBase.prototype.overriddenAttackSkillId = function(){
	const metaBase = this.getAllMetas();
	if(metaBase.length === 0) return 0;
	
	const metas = metaBase.filter(meta => {return meta.attackSkill});
	if(metas.length === 0) return 0;

	const attackIds = metas.map(meta => {return JSON.parse(meta.attackSkill)});
	const initialMeta = this.canUse($dataSkills[attackIds[0].id]) ? attackIds[0] : {};
	const attackId = attackIds.reduce((metaA, metaB) => {
		let priorityA = metaA.priority || 0;
		let priorityB = metaB.priority || 0;
		if(priorityA > priorityB) return metaA;

		if(!metaB.flex) return metaB;

		let canUseB = this.canUse($dataSkills[metaB.id]);
		return canUseB ? metaB : metaA;
	}, initialMeta);
	return attackId.id || 0;
};//*
if(!statusParameter.addon) Game_BattlerBase.prototype.overriddenAttackSkillId = function(){return 0};

Game_BattlerBase.prototype.overriddenGuardSkillId = function(){
	const metaBase = this.getAllMetas();
	if(metaBase.length === 0) return 0;
	
	const metas = metaBase.filter(meta => {return meta.guardSkill});
	if(metas.length === 0) return 0;

	const guardIds = metas.map(meta => {return JSON.parse(meta.guardSkill)});
	const initialMeta = this.canUse($dataSkills[guardIds[0].id]) ? guardIds[0] : {};
	const guardId = guardIds.reduce((metaA, metaB) => {
		let priorityA = metaA.priority || 0;
		let priorityB = metaB.priority || 0;
		if(priorityA > priorityB) return metaA;

		if(!metaB.flex) return metaB;

		let canUseB = this.canUse($dataSkills[metaB.id]);
		return canUseB ? metaB : metaA;
	}, guardIds[0]);
	return guardId.id > 2 ? guardId.id : 0;
};//*
if(!statusParameter.addon) Game_BattlerBase.prototype.overriddenGuardSkillId = function(){return 0};

Game_BattlerBase.prototype.getAllMetas = function(){
	return this.isActor() ? this.getActorMetas() : this.getEnemyMetas();
};//*
if(!statusParameter.addon) Game_BattlerBase.prototype.checkAllMetas = function(){return []};

Game_BattlerBase.prototype.getActorMetas = function(){
	const actorMeta = this.actor().meta;
	const classMeta = this.currentClass().meta;
	const equipMeta = this.equips().map(equip => {return equip ? equip.meta : null});
	const stateMeta = this.states().map(state => {return state ? state.meta : null});
	stateMeta.forEach(meta => equipMeta.push(meta));
	equipMeta.unshift(classMeta);
	equipMeta.unshift(actorMeta);
	return equipMeta.filter(meta => {return meta});
};//*


Game_BattlerBase.prototype.getEnemyMetas = function(){
	const enemyMeta = this.enemy().meta;
	const stateMeta = this.states().map(state => {return state ? state.meta : null});
	stateMeta.unshift(enemyMeta);
	return stateMeta.filter(meta => {return meta});
};//*


	/*----------討伐演出の設定---------------------------*/
if(statusParameter.addon){
	const defeatCommons = params.defeat ? JSON.parse(params.defeat) : ["0","0","0"];
	const collapseCommon = defeatCommons.map(num => {return Number(num)});
	//討伐演出の度にパース処理をかけるのも負担なので、ここで定義しておく

	const _Game_Enemy_prototype_performCollapse = Game_Enemy.prototype.performCollapse;
	Game_Enemy.prototype.performCollapse = function() {
		this.collapseEvent(collapseCommon[this.collapseType()]);
	    Game_Battler.prototype.performCollapse.call(this);
   
	  	switch (this.collapseType()) {
		    case 0:
		        this.requestEffect('collapse');
		        SoundManager.playEnemyCollapse();
		    break;

		    case 1:
		    	if(MV){
		    		BattleManager.bossBeating();
		    		BattleManager.beatingWait();	
		    	}	
		    	this.requestEffect('bossCollapse');
		        if(!$gameParty.inBattle()){
		       		SoundManager.playBossCollapse1(); 	
		        }
		    break;
			    
		    case 2:
		        this.requestEffect('instantCollapse');
		    break;
		}
	};//*

	const _BattleManager_updateEvent = BattleManager.updateEvent;
	BattleManager.updateEvent = function() {
	    switch (this._phase) {
	        case 'start':
	        case 'turn':
	        case 'turnEnd':
	            if (this.isActionForced()) {
		                this.processForcedAction();
		                return true;
	            } else {
		                return this.updateEventMain();
	            }
		    break;
		        //add action
		    case 'action' : 	
		       	if(this.isBossBeating()){
		  	     		return this.updateEventMain();
		       	}
		}
		return this.checkAbort();
	};//*
			
	const _BattleManager_updateAction = BattleManager.updateAction;
	BattleManager.updateAction = function() {
	    if(!this.isBossBeating()){
		    	_BattleManager_updateAction.apply(this, arguments);
	    }
	};//*

	const _BattleManager_checkBattleEnd = BattleManager.checkBattleEnd;
	BattleManager.checkBattleEnd = function() {
	    if (this._phase) {
	        if (this.checkAbort()) {
		            return true;
	        } else if ($gameParty.isAllDead()) {
		            this.processDefeat();
		            return true;
	        } else if ($gameTroop.isAllDead()) {
		        	if(this.isBossBeating()){return false};
		            this.processVictory();
		            return true;
	        }
	    };
	    return false;
	};//*

	const _Sprite_Enemy_prototype_updateEffect = Sprite_Enemy.prototype.updateEffect;
	Sprite_Enemy.prototype.updateEffect = function() {
		if(!BattleManager.isBeatingWait()){
		    this.setupEffect();
		    if (this._effectDuration > 0) {
			    	this.playBossCollapse1();
			        this._effectDuration--;
			        switch (this._effectType) {
				        case 'whiten'			: this.updateWhiten(); 			break;
				        case 'blink'			: this.updateBlink(); 			break;
				        case 'appear'			: this.updateAppear(); 			break;
				        case 'disappear'		: this.updateDisappear(); 		break;
				        case 'collapse'			: this.updateCollapse(); 		break;
				        case 'bossCollapse'		: this.updateBossCollapse(); 	break;
				        case 'instantCollapse'	: this.updateInstantCollapse(); break;
			        };
			        if (this._effectDuration === 0) {
			            this._effectType = null;
			            BattleManager.stopBossBeating();
			        };
			}
		}else if(MZ && $gameTroop._interpreter.isRunning()){
		    //in MZ, interpreter can't update by self
		    $gameTroop._interpreter.update();
		};
	};//*
}////

Game_Enemy.prototype.collapseEvent = function(commonId){
	if(MZ　&& this.collapseType() === 1 && commonId > 0){
			BattleManager.bossBeating();
	    	BattleManager.beatingWait();
	}
	if(commonId > 0){
			$gameTemp.reserveCommonEvent(commonId, true);
			if($gameParty.inBattle()){
				if(!$gameTroop._interpreter.isRunning()){
						$gameTroop.setupBattleEvent();
				}else{
						const list = $dataCommonEvents[commonId].list;
						$gameTroop._interpreter.setupChild(list);
				}
			}
	}
	$gameSystem.onBattleBeat(true);
};//*
if(!statusParameter.addon) Game_Enemy.prototype.collapseEvent = function(commonId){};


BattleManager.bossBeating = function(){
	this._bossBeating = true;
};//*
if(!statusParameter.addon) BattleManager.bossBeating = function(){};


BattleManager.stopBossBeating = function(){
	this._bossBeating = false;
};//*
if(!statusParameter.addon) BattleManager.stopBossBeating = function(){};


BattleManager.isBossBeating = function(){
	return this._bossBeating;
};//*
if(!statusParameter.addon) BattleManager.isBossBeating = function(){return false};


BattleManager.beatingWait = function(){
	this._beatingWait = true;
};//*
if(!statusParameter.addon) BattleManager.beatingWait = function(){};


BattleManager.stopBeatingWait = function(){
	this._beatingWait = false;
};//*
if(!statusParameter.addon) BattleManager.stopBeatingWait = function(){};


BattleManager.isBeatingWait = function(){
	return this._beatingWait;
};//*
if(!statusParameter.addon) BattleManager.isBeatingWait = function(){return false};


Sprite_Enemy.prototype.playBossCollapse1 = function(){
	if(this._effectDuration % 20 === 19){
		    SoundManager.playBossCollapse1();	
	}
};//*
if(!statusParameter.addon) Sprite_Enemy.prototype.playBossCollapse1 = function(){};



		/*---------------------ステートの拡張------------------*/

		/*~struct~States:ja
			@param 	stepTurn
			@type 		number
			@text 		再生率の歩数
			@desc 		移動中に再生率処理が実行されるための歩数を設定します。
			@default 	20
			@decimals 	0
			@min 		1
			
			@param 	removeStateContinuously
			@type 		boolean
			@text 		ステート時間解除
			@desc 		On（true）にすると、マップ上で歩数ではなく時間経過でステートの解除処理が行われます。
			@default 	false

			@param 	solidRegenerate
			@type 		boolean
			@text 		再生率の固定化
			@desc 		On（true）にすると、HPやMPの再生率をそのままの値で増減します（30%の場合は30ポイント再生）
			@default 	false

			@param 	floorDamageInBattle
			@type 		boolean
			@text 		戦闘中のダメージ床
			@desc 		On（true）にすると、ダメージ床上で戦闘になった際に床の影響を受けるようになります。
			@default 	false

			@param 	floorDamageCount
			@type 		number
			@text 		床ダメージ発生間隔(ﾌﾚｰﾑ)
			@desc 		ダメージ床上にいる時、ダメージの発生間隔を設定します。0の時は１歩ごとに発生します。
			@default 	0
			@max 		99999999
			@min 		0
			@decimals 	0

			@param 	floodedBody
			@type 		number
			@text 		ダメージ床発生浸水率
			@desc 		ダメージ床が発生する際に全身のうち何部位が床を踏んでいるべきかを1~4で設定します。
			@default 	2
			@max 		4
			@min 		1
			@decimals 	0

			@param 	damageFlash
			@type 	struct<DamageFlash>
			@text 	スリップダメージの色調
			@desc 	毒やダメージ床などマップ上でダメージを受けた際のフラッシュ色調を設定します。

			@param 	levelDifference
			@type 	boolean
			@text 	確率レベル補正
			@desc 	On（true）にするとステートの付加確率に対象とのレベル差を乗算します。
			@default false

			@param 	levelEffect
			@type 	number
			@text 	レベル補正率
			@desc 	レベル差の倍率を求めるための値を設定します。小数第３位まで有効です。
			@default 	0.01
			@decimals 	3

			@param 	lukEffect
			@type 	number
			@text 	運補正
			@desc 	ステート付加確率、およびドロップアイテム取得率に対する運の補正率を設定します。小数第３位まで有効です。
			@default 	0.001
			@decimals 	3
		*/
		/*-----------------------------------------------------------------------------------------*/
		/*~struct~States:
			@param 	stepTurn
			@type 		number
			@text 		steps for regeneration
			@desc 		Control steps for regeneration on map
			@default 	20
			@decimals 	0
			@min 		1

			@param 	removeStateContinuously
			@type 		boolean
			@text 		remove states continuously
			@desc 		Remove States on map by not steps but time when this is true
			@default 	false

			@param 	solidRegenerate
			@type 		boolean
			@text 		fixed regeneration
			@desc 		Fix regeneration of traits when this is true: if trait's value is 30%, battlers regenerate 30 points
			@default 	false

			@param 	floorDamageInBattle
			@type 		boolean
			@text 		floor damage in battle
			@desc 		Affected floor damage also in battle when this is true
			@default 	false

			@param 	floodedBody
			@type 		number
			@text 		flooded rate for damage floor
			@desc 		Control how many body parts between 1 and 4  must be on damage floor to damage
			@default 	2
			@max 		4
			@min 		1
			@decimals 	0

			@param 	floorDamageCount
			@type 		number
			@text 		Interbal of floor damage (frames)
			@desc 		Control the frames for characters on damage floors; when 0, damage occurs by steps
			@default 	0
			@max 		99999999
			@min 		0
			@decimals 	0

			@param 	damageFlash
			@type 	struct<DamageFlash>
			@text 	flash on map damage
			@desc 	Setting of map flash on damaged by poison or damage floors

			@param 	levelDifference
			@type 	boolean
			@text 	state rate width level
			@desc 	Multiply state rate by level difference when this is true
			@default false

			@param 	levelEffect
			@type 	number
			@text 	level effect
			@desc 	Control the effect to calculate the rate of level difference; available in three decimal places 
			@default 	0.01
			@decimals 	3

			@param 	lukEffect
			@type 	number
			@text 	effect of luck difference
			@desc 	Control the effect for adding state or an enemy's rewards; available in three decimal places
			@default 	0.001
			@decimals 	3
		*/
			/*~struct~DamageFlash:ja
				@param 	red
				@type 		number
				@text 		赤
				@desc 		フラッシュ色調の赤要素を-255~255の値で設定します。
				@decimals 	0
				@min 		-255
				@max 		255
				@default 	255

				@param 	green
				@type 		number
				@text 		緑
				@desc 		フラッシュ色調の緑要素を-255~255の値で設定します。
				@decimals 	0
				@min 		-255
				@max 		255
				@default 	0

				@param 	blue
				@type 		number
				@text 		青
				@desc 		フラッシュ色調の青要素を-255~255の値で設定します。
				@decimals 	0
				@min 		-255
				@max 		255
				@default 	0

				@param 	grey
				@type 		number
				@text 		グレー
				@desc 		フラッシュ色調のグレー要素を0~255の値で設定します。
				@decimals 	0
				@max 		255
				@default 	128

				@param 	duration
				@type 		number
				@text 		フラッシュ時間(ﾌﾚｰﾑ)
				@desc 		フラッシュ色調の継続時間を設定します。
				@decimals 	0
				@max 		9999
				@default 	8
			*/
			/*-----------------------------------------------------------------------------------------*/
			/*~struct~DamageFlash
				@param 	red
				@type 		number
				@text 		red
				@desc 		Control red tone in flash between -255 and 255
				@decimals 	0
				@min 		-255
				@max 		255
				@default 	255

				@param 	green
				@type 		number
				@text 		green
				@desc 		Control green tone in flash between -255 and 255
				@decimals 	0
				@min 		-255
				@max 		255
				@default 	0

				@param 	blue
				@type 		number
				@text 		blue
				@desc 		Control blue tone in flash between -255 and 255
				@decimals 	0
				@min 		-255
				@max 		255
				@default 	0

				@param 	grey
				@type 		number
				@text 		grey
				@desc 		Control grey tone in flash between 0 and 255
				@decimals 	0
				@max 		255
				@default 	128

				@param 	duration
				@type 		number
				@text 		duration (frames)
				@desc 		Control duration of flash
				@decimals 	0
				@max 		9999
				@default 	8
			*/

		const parseStates = s => JSON.parse(s, (key, value)=>{
			switch(key){
				case 'stepTurn'					: return Number.parseFloat(value);
				case 'removeStateContinuously'	: return value;
				case 'solidRegenerate' 			: return value;
				case 'floorDamageInBattle' 		: return value;
				case 'floorDamageCount'			: return Number.parseFloat(value);
				case 'floodedBody'				: return Number.parseFloat(value);
				case 'damageFlash' 				: return value;
				case 'levelDifference' 			: return value;
				case 'levelEffect'				: return Number.parseFloat(value);
				case 'lukEffect' 				: return Number.parseFloat(value);
				default 						: return value;
			}
		});//*

		let states = params.states;
		let consolerNameStates = 'states:';
		if(states){
				states = parseStates(params.states);
				states = stringToBoolean(states);
				if(states.damageFlash){
					states.damageFlash = JSON.parse(states.damageFlash);
					states.damageFlash = stringToNumber(states.damageFlash);
				}
		}else{
				states = makeNotValid();
				undefinedStructs.push(consolerNameStates);
				consolerNameStates += makeInvalidTerm();
		};
		consoler(consolerNameStates, states);

	//----------------再生率の設定-----------------------------------//
if(statusParameter.addon){
	const _Game_Actor_prototype_stepsForTurn = Game_Actor.prototype.stepsForTurn;
	Game_Actor.prototype.stepsForTurn = function() {
	    return states.stepTurn || _Game_Actor_prototype_stepsForTurn.apply(this, arguments);
	};//*

	const _Game_Battler_prototype_regenerateHp = Game_Battler.prototype.regenerateHp;
	Game_Battler.prototype.regenerateHp = function() {
		let value;
		if(this.solidRegenerate()){
				value = Math.floor(this.hrg * 100);
		}else{
				value = Math.floor(this.mhp * this.hrg);
		}

		value = Math.max(value, -this.maxSlipDamage());
		if (value !== 0) {
			    this.gainHp(value);
		}
	};//*

	const _Game_Battler_prototype_regenerateMp = Game_Battler.prototype.regenerateMp;
	Game_Battler.prototype.regenerateMp = function() {
		let value;
		if(this.solidRegenerate()){
				value = Math.floor(this.mrg * 100);
		}else{
				value = Math.floor(this.mmp * this.mrg);	
		}

		if (value !== 0) {
		       	this.gainMp(value);
		}
	};//*

	const _Game_Battler_prototype_regenerateTp = Game_Battler.prototype.regenerateTp;
	Game_Battler.prototype.regenerateTp = function() {
		let value;
		if(this.solidRegenerate()){
				value = Math.floor(this.trg * 100);
		}else{
				value = Math.floor(100 * this.trg);	
		}

		this.gainSilentTp(value);
	};//*

	Game_Battler.prototype.solidRegenerate = function(){
		return states.solidRegenerate;
	};//*
}////

	/*----------ステートを時間経過で解除する仕様--------------*/
const _Game_Battler_prototype_initMembers = Game_Battler.prototype.initMembers;
Game_Battler.prototype.initMembers = function() {
	_Game_Battler_prototype_initMembers.apply(this, arguments);
  	this.regeneCount = 0;
  	this._floorDamageCount = states.floorDamageCount || 0;
  	this._floorDamageCurrentCount = 0;
};//*

if(statusParameter.addon){
	const _Game_Actor_prototype_onPlayerWalk = Game_Actor.prototype.onPlayerWalk;
	Game_Actor.prototype.onPlayerWalk = function() {
		_Game_Actor_prototype_onPlayerWalk.apply(this, arguments);
	    if ($gamePlayer.isNormal()) {
	        this.updateBuffTurns(); //非バトル時かつコマンドバトル仕様なら内部で基本無視される
	    }
	};//*

	//バフはコマンドとアクションで処理を共存できるように
	const _Game_BattlerBase_prototype_updateBuffTurns = Game_BattlerBase.prototype.updateBuffTurns;
	Game_BattlerBase.prototype.updateBuffTurns = function() {
		if($gameParty.inBattle()){
			_Game_BattlerBase_prototype_updateBuffTurns.apply(this, arguments);
		}else{
			for (var i = 0; i < this._buffTurns.length; i++) {
		        if (this._buffTurns[i] > 0) {
		            this._buffTurns[i]--;
		            if(this._buffTurns[i] <= 0) this.eraseBuff(i);
		        }
		    }
		}
	};//*

	const _Game_Battler_prototype_onTurnEnd = Game_Battler.prototype.onTurnEnd;
	Game_Battler.prototype.onTurnEnd = function() {
	    this.clearResult();
	    this.regenerateAll();
	    if ($gameParty.inBattle() && !BattleManager.isForcedTurn()) {//condition inBattle added
	        this.updateStateTurns();
	        this.updateBuffTurns();
	    }
	    this.removeStatesAuto(2);
	};//*

	const _Game_BattlerBase_prototype_overwriteBuffTurns = Game_BattlerBase.prototype.overwriteBuffTurns;
	Game_BattlerBase.prototype.overwriteBuffTurns = function(paramId, turns) {
		if($gameParty.inBattle()){
			_Game_BattlerBase_prototype_overwriteBuffTurns.apply(this, arguments);
		}else{
			if(states.removeStateContinuously) turns *= 60;
			if (this._buffTurns[paramId] < turns) {
		        this._buffTurns[paramId] = turns;
		    }
		}
	};//*
}////

if(statusParameter.addon && states.removeStateContinuously){
	//onPlayerWalkの中にステートチェックや床ダメージチェックが入っている。
	const _Game_Player_prototype_updateNonmoving = Game_Player.prototype.updateNonmoving;
	Game_Player.prototype.updateNonmoving = function(wasMoving) {
	    if (!$gameMap.isEventRunning()) {
	        if (wasMoving) {
	            //$gameParty.onPlayerWalk(); deleated

	            this.checkEventTriggerHere([1,2]);
	            if ($gameMap.setupStartingEvent()) {
	                return;
	            }
	        }
	        if (this.triggerAction()) {
	            return;
	        }
	        if (wasMoving) {
	            this.updateEncounterCount();
	        } else {
	            $gameTemp.clearDestination();
	        }
	    }
	};//*

	const _Game_Player_prototype_update = Game_Player.prototype.update;
	Game_Player.prototype.update = function(sceneActive) {
	    _Game_Player_prototype_update.apply(this, arguments);
	    if($gamePlayer.isNormal()){
	    	$gameParty.onPlayerWalk();	
	    }
	};//*

	//onTurnEndの中身
	const _Game_Actor_prototype_checkFloorEffect = Game_Actor.prototype.checkFloorEffect;
	Game_Actor.prototype.checkFloorEffect = function() {
	    if ($gamePlayer.isOnDamageFloor()) {
	    	if(!states.floorDamageCount){
	    		if(!$gamePlayer.isMoving() && this._floorDamageCurrentCount === 0) {
	    			this._floorDamageCurrentCount ++;
	    			this.executeFloorDamage();
	    		}
	    		if($gamePlayer.isMoving() && this._floorDamageCurrentCount > 0){
	    			this._floorDamageCurrentCount = 0;
	    		}
	    	}else{
	    		if(this._floorDamageCurrentCount === 0) this._floorDamageCurrentCount = this._floorDamageCount;
	    		this._floorDamageCurrentCount --;
	    		if(this._floorDamageCurrentCount <= 0){
	    			this._floorDamageCurrentCount = 0;
	    			this.executeFloorDamage();	
	    		}
	    	}
	    }else if(this._floorDamageCurrentCount > 0){
	    	this._floorDamageCurrentCount = 0;
	    }
	};//*

	const _Game_Actor_prototype_resetStateCounts = Game_Actor.prototype.resetStateCounts;
	Game_Actor.prototype.resetStateCounts = function(stateId) {
	    _Game_Actor_prototype_resetStateCounts.apply(this, arguments);
	    this._stateSteps[stateId] *= 60;
	};//*

	const _Game_Actor_prototype_turnEndOnMap = Game_Actor.prototype.turnEndOnMap;
	Game_Actor.prototype.turnEndOnMap = function() {
		this.regeneCount ++;
	    if (this.regeneCount % this.stepsForTurn() === 0) {
	    	this.regeneCount = 0;
	        this.onTurnEnd();
	        if (this.result().hpDamage > 0) {
	            this.performMapDamage();
	        }
	    }
	};//*

	const _Game_Screen_prototype_startFlashForDamage = Game_Screen.prototype.startFlashForDamage;
	Game_Screen.prototype.startFlashForDamage = function() {
		if(states.damageFlash){
			const flash = states.damageFlash;
			const color = [flash.red, flash.green, flash.blue, flash.grey];
			this.startFlash(color, flash.duration);
		}else{
			//default flash [255, 0, 0, 128], duration 8 
			_Game_Screen_prototype_startFlashForDamage.apply(this, arguments);
		}
	};//*

	//for eventEnemy
	const _Game_Event_prototype_update = Game_Event.prototype.update;
	Game_Event.prototype.update = function(){
		_Game_Event_prototype_update.apply(this, arguments);

		if(this._eventEnemy){
			this.onEnemyWalk();
		}
	};//*

	const _Game_Enemy_prorotype_resetStateCounts = Game_Enemy.prototype.resetStateCounts;
	Game_Enemy.prototype.resetStateCounts = function(stateId){
		_Game_Enemy_prorotype_resetStateCounts.apply(this, arguments);
		this._stateSteps[stateId] = $dataStates[stateId].stepsToRemove * 60;
	};//*

	//for eventEnemy
	const _Game_Enemy_prototype_clearStates = Game_Enemy.prototype.clearStates;
	Game_Enemy.prototype.clearStates = function() {
		Game_Battler.prototype.clearStates.call(this);
	    this._stateSteps = {};
	    this._stateDamage = false;
	};//*
}////


Game_Event.prototype.onEnemyWalk = function() {
	const enemy = this.eventEnemy();
    enemy.clearResult();
    this.checkFloorEffect();
    if (!this.isMoveRouteForcing()) {
        enemy.turnEndOnMap();
        if(enemy._stateDamage){
        	this.refreshStatus();
        	this.showHpBar();
        	this.startDamagePopup();
        	this.updateDamagePopup();
        	enemy.setStateDamage(false);
        }
        enemy.states().forEach(function(state) {
            enemy.updateStateSteps(state);
        }, this);
        enemy.updateBuffTurns();
    }
};//*
if(!statusParameter.addon || !states.removeStateContinuously) Game_Event.prototype.onEnemyWalk = function() {};


Game_Event.prototype.checkFloorEffect = function(){
	if(this._eventEnemy) return;

    if (this.isOnDamageFloor()) {
    	const enemy = this.eventEnemy();
	    if(!states.floorDamageCount){
	   		if(!this.isMoving() && enemy._floorDamageCurrentCount === 0) {
	   			enemy._floorDamageCurrentCount ++;
	   			enemy.executeFloorDamage();
	   		}
	   		if(this.isMoving() && enemy._floorDamageCurrentCount > 0){
	   			enemy._floorDamageCurrentCount = 0;
	   		}
	   	}else{
	   		if(enemy._floorDamageCurrentCount === 0) enemy._floorDamageCurrentCount = enemy._floorDamageCount;
	   		enemy._floorDamageCurrentCount --;
	   		if(enemy._floorDamageCurrentCount <= 0){
	   			enemy._floorDamageCurrentCount = 0;
	   			enemy.executeFloorDamage();	
	   		}
	   	}
	}else if(enemy._floorDamageCurrentCount > 0){
    	enemy._floorDamageCurrentCount = 0;
    }
};//*
if(!statusParameter.addon || !states.removeStateContinuously) Game_Event.prototype.checkFloorEffect = function(){};


Game_Event.prototype.isOnDamageFloor = function(){
	return $gameMap.isDamageFloor(this.x, this.y);
};//*
if(!statusParameter.addon || !states.removeStateContinuously) Game_Event.prototype.isOnDamageFloor = function(){return false};


Game_Enemy.prototype.turnEndOnMap = function(){
	this.regeneCount++;
	if (this.regeneCount % this.stepsForTurn() === 0) {
        this.regeneCount = 0;
        this.onTurnEnd();
        if (this.result().hpDamage > 0) this.performMapDamage();
    }
};//*
if(!statusParameter.addon || !states.removeStateContinuously) Game_Enemy.prototype.turnEndOnMap = function(){};


Game_Enemy.prototype.stepsForTurn = function(){
	return Game_Actor.prototype.stepsForTurn.call(this);
};//*
if(!statusParameter.addon || !states.removeStateContinuously) Game_Enemy.prototype.stepsForTurn = function(){return false};


Game_Enemy.prototype.updateStateSteps = function(state) {
    Game_Actor.prototype.updateStateSteps.call(this, state);
};//*
if(!statusParameter.addon || !states.removeStateContinuously) Game_Enemy.prototype.updateStateSteps = function(state) {};


Game_Enemy.prototype.setStateDamage = function(value){
	this._stateDamage = value;
};//*
if(!statusParameter.addon || !states.removeStateContinuously) Game_Enemy.prototype.setStateDamage = function(value){};


	/*------------地形ダメージの変更-----------*/
if(statusParameter.addon){
	const _Game_Actor_prototype_basicFloorDamage = Game_Actor.prototype.basicFloorDamage;
	Game_Actor.prototype.basicFloorDamage = function() {
		const base = _Game_Actor_prototype_basicFloorDamage.apply(this, arguments);
		const meta = $dataMap.meta.floorDamage;
		if(meta){
			const fd = Number(meta);
			let damage = fd < 1 ? Math.floor(this.mhp * fd) : Math.floor(fd);
			return damage < 0 ? -1 * damage : damage;
		}else{
		    return base;
		}
	};//*

	const _Game_Actor_prototype_executeFloorDamage = Game_Actor.prototype.executeFloorDamage;
	Game_Actor.prototype.executeFloorDamage = function() {
		const elementRate = this.checkFloorElement();
	    var damage = Math.floor(this.basicFloorDamage() * elementRate * this.fdr);
	    damage = Math.min(damage, this.maxFloorDamage());
	    this.gainHp(-damage);
	    if (damage > 0) {
	        this.performMapDamage();
	    }
	};//*
}////


Game_Actor.prototype.checkFloorElement = function(){
	const meta  = $dataMap.meta.floorElement;
	if(!meta){
		return 1;
	}else{
		const elementId = Number(meta);
		return elementId >= 1 ? this.elementRate(elementId) : 1;
	}
};//*
if(!statusParameter.addon) Game_Actor.prototype.checkFloorElement = function(){return 0};


if(statusParameter.addon && states.floorDamageInBattle){
	const _Game_Battler_prototype_onTurnEnd = Game_Battler.prototype.onTurnEnd;
	Game_Battler.prototype.onTurnEnd = function() {
	    _Game_Battler_prototype_onTurnEnd.apply(this, arguments);
	    if($gameParty.inBattle() && this.isAlive() &&
	    	$dataMap && $gamePlayer.isOnDamageFloor()){
	    	this.executeFloorDamage();
	    }
	};//*
}////

Game_Enemy.prototype.basicFloorDamage = function(){
	return this._notEnemy ? 0 : Game_Actor.prototype.basicFloorDamage.call(this);
};//*
if(!statusParameter.addon) Game_Enemy.prototype.basicFloorDamage = function(){return 0};


Game_Enemy.prototype.executeFloorDamage = function(){
	Game_Actor.prototype.executeFloorDamage.call(this);
};//*
if(!statusParameter.addon) Game_Enemy.prototype.executeFloorDamage = function(){};


Game_Enemy.prototype.checkFloorElement = function(){
	return Game_Actor.prototype.checkFloorElement.call(this);
};//*


Game_Enemy.prototype.maxFloorDamage = function(){
	return Game_Actor.prototype.maxFloorDamage.call(this);
};//*
if(!statusParameter.addon) Game_Enemy.prototype.maxFloorDamage = function(){return 0};


Game_Enemy.prototype.performMapDamage = function(){
	//if(states.removeStateContinuously){
		this.setStateDamage(true);
	//}else{
	//	Game_Actor.prototype.performMapDamage.call(this);	
	//}
};//*
if(!statusParameter.addon) Game_Enemy.prototype.performMapDamage = function(){};


	/*------------ステートのレベル差補正、ラック値補正--------------------*/
if(statusParameter.addon){
	const _Game_Action_prototype_lukEffectRate = Game_Action.prototype.lukEffectRate;
	Game_Action.prototype.lukEffectRate = function(target) {
	    let defRate = Math.max(1.0 + (this.subject().luk - target.luk) * states.lukEffect, 0.0);
	    let levelRate = this.levelDifferenceRate(target);
	    return defRate * levelRate;
	};//*

	Game_Action.prototype.levelDifferenceRate = function(target){
		if(states.levelDifference){
	    	const subject = this.subject();
	    	const aLevel = subject.isActor() ? subject.level : ( Number(subject.enemy().meta.level) || 1);
	    	const bLevel = target.isActor() ? target.level : ( Number(target.enemy().meta.level) || 1);
	    	return (aLevel - bLevel) * states.levelEffect + 1;
	    }else{
	    	return 1;
	    }
	};//*

	const _Game_Enemy_prototype_dropItemRate = Game_Enemy.prototype.dropItemRate;
	Game_Enemy.prototype.dropItemRate = function() {
		const defRate = _Game_Enemy_prototype_dropItemRate.apply(this, arguments);
		const lukEffect = $gameParty.allLuk() + 1;
	    return lukEffect * defRate;
	};//*
}////

Game_Party.prototype.allLuk = function(){
	const members = this.members();
	if (members.length === 0) {
        return 1;
    }
    let sum = members.reduce(function(r, member) {
        return r + member.luk;
    }, 0);
    return sum * states.lukEffect || 0;
};//*
if(!statusParameter.addon) Game_Party.prototype.allLuk = function(){return 0};



		/*------------能力値の最大値・最小値の拡張----------------*/

			/*~struct~ExpansionBaseStatus:ja
				@param 	max
				@type 		number
				@text 		最大値
				@desc 		敵や味方のステータス上限を設定します。0にすると初期値となります。
				@default 	0
				@decimals 	0
				
				@param 	min
				@type 		number
				@text 		最小値
				@desc 		敵や味方のステータス下限を設定します。プラグインの初期値は全て0です。
				@default 	0
				@decimals 	0
			*/
			/*-----------------------------------------------------------------------------------------*/
			/*~struct~ExpansionBaseStatus:
				@param 	max
				@type 		number
				@text 		max parameter of status
				@desc 		Control max value of statuses; 0 works invalid
				@default 	0
				@decimals 	0
				
				@param 	min
				@type 		number
				@text 		minimum parameter of status
				@desc 		Control minimum value of statuses; 0 works invalid
				@default 	0
				@decimals 	0
			*/

		const parseExpansionBaseStatus = s => JSON.parse(s, (key, value) => {
			switch(key){
				case 'max' 	: return Number.parseFloat(value);
				case 'min' 	: return Number.parseFloat(value);
				default 	: return value;
			}
		});//*

		const baseParams = 8;
		const initialStatus = {"max": 0, "min": 0, "name":''};
		let expansionBaseStatus = params.expansionBaseStatus;
		let consolerNameExpansionStatus = 'expansionStatus:';
		if(expansionBaseStatus){
			expansionBaseStatus = parseExpansionBaseStatus(expansionBaseStatus);
			expansionBaseStatus = expansionBaseStatus.map(s => JSON.parse(s));
			expansionBaseStatus.forEach(function(element){
									element.max = Number(element.max);
									element.min = Number(element.min);
								});
			expansionBaseStatus = expansionBaseStatus.filter((obj, index) => {return index < baseParams});
		}else{
			expansionBaseStatus = [];
		};

		if(expansionBaseStatus.length < baseParams){
			let rest = baseParams - expansionBaseStatus.length;
			for(var i = 0; i < rest; i++){
				expansionBaseStatus.push(initialStatus);
			};
		};
			
		let expansionStatus = expansionBaseStatus.map(obj => {return obj});
			expansionStatus.push(initialStatus, initialStatus);

if(statusParameter.addon){
	//-1指定でのデフォルト採択ができなかったため、ソースに追記する形で記載している。
	const _Game_BattlerBase_prototype_paramMin = Game_BattlerBase.prototype.paramMin;
	Game_BattlerBase.prototype.paramMin = function(paramId){
		//_Game_BattlerBase_prototype_paramMin.apply(this, arguments);
		let paramValue = expansionStatus[paramId].min;
		if(paramValue === 0){
			return paramId === 0 ? 1 : paramValue; //HPだけ0だと困る
		}else{
			return paramValue;
		}
	};//*

	const _Game_BattlerBase_prototype_paramMax = Game_BattlerBase.prototype.paramMax;
	Game_BattlerBase.prototype.paramMax = function(paramId){
		//_Game_BattlerBase_prototype_paramMax.apply(this, arguments);
		let paramValue = expansionStatus[paramId].max;
		if(paramValue === 0){
			//デフォルト上限
			if (paramId === 0) {
			        return 999999;  // MHP
		    } else if (paramId === 1) {
			        return 9999;    // MMP
		    } else {
			        return 999;
			};		
		}else{
			return paramValue;
		};
	};//*

	Game_Actor.prototype.paramMax = function(paramId) {
		//アクターの最大HPがアクタークラスで上書きされるので、こちらも再調整
	    let paramValue = expansionStatus[paramId].max;
	   	if(paramValue === 0){
		   	if (paramId === 0) {
			        return 9999;    // MHP
		    }	
	   	}
	    return Game_Battler.prototype.paramMax.call(this, paramId);
	};//*
}////

		/*------------新規能力値の追加-----------------------------*/

			/*~struct~ExpansionParam:ja
			@param 	name
			@type 		string
			@text 		追加能力名
			@desc 		追加する能力の名前を設定します。ステータスの初期値は1になります。
			
			@param 	max
			@type 		number
			@text 		能力上限
			@desc 		追加する能力の上限値を設定します。
			@default 	999
			@decimals 	0
			
			@param 	min
			@type 		number
			@text 		能力下限
			@desc 		追加する能力の下限値を設定します。
			@default 	0
			@decimals 	0

			*/
			/*----------------------------------------------------------*/
			/*~struct~ExpansionParam:
			@param 	name
			@type 		string
			@text 		name of expansion status
			@desc 		Define the name; initial parameter of this status is 1
			
			@param 	max
			@type 		number
			@text 		max parameter of this status
			@desc 		Control the max parameter
			@default 	999
			@decimals 	0
			
			@param 	min
			@type 		number
			@text 		minimum parameter of this status
			@desc 		Control the minimum parameter
			@default 	0
			@decimals 	0
			
			*/

		const parseExpansionStatus = s => JSON.parse(s, (key, value)=>{
			switch(key){
				case 'name' : return value;
				case 'max'	: return Number.parseFloat(value);
				case 'min'	: return Number.parseFloat(value);
				default 	: return value;
			}
		});//*

		const exParams = [	 params.expansionParam1,
							 params.expansionParam2,
							 params.expansionParam3,
							 params.expansionParam4,
							 params.expansionParam5,
							 params.expansionParam6,
							 params.expansionParam7,
							 params.expansionParam8,
							 params.expansionParam9,
							 params.expansionParam10 ];

		exParams.forEach(exParam => {
			let p = exParam ? parseExpansionStatus(exParam) : initialStatus;
			expansionStatus.push(p);
		});

		consoler(consolerNameExpansionStatus, expansionBaseStatus,expansionStatus);

	Object.defineProperties(Game_BattlerBase.prototype, {
		exParam1:  {get:function(){return this.param(10);},configurable: true},
		exParam2:  {get:function(){return this.param(11);},configurable: true},
		exParam3:  {get:function(){return this.param(12);},configurable: true},
		exParam4:  {get:function(){return this.param(13);},configurable: true},
		exParam5:  {get:function(){return this.param(14);},configurable: true},
		exParam6:  {get:function(){return this.param(15);},configurable: true},
		exParam7:  {get:function(){return this.param(16);},configurable: true},
		exParam8:  {get:function(){return this.param(17);},configurable: true},
		exParam9:  {get:function(){return this.param(18);},configurable: true},
		exParam10: {get:function(){return this.param(19);},configurable: true}
	});
		
if(statusParameter.addon){			
	const _Game_BattlerBase_prototype_clearParamPlus = Game_BattlerBase.prototype.clearParamPlus;
	Game_BattlerBase.prototype.clearParamPlus = function() {
		_Game_BattlerBase_prototype_clearParamPlus.apply(this, arguments);

	    this._paramPlus = [0,0,0,0,0,0,0,0, 0,0, 0,0,0,0,0,0,0,0,0,0];
	};//*
				
	const _Game_BattlerBase_prototype_clearBuffs = Game_BattlerBase.prototype.clearBuffs;
	Game_BattlerBase.prototype.clearBuffs = function() {
		//_Game_BattlerBase_prototype_clearBuffs.apply(this, arguments);
			
		this._buffs = [0,0,0,0,0,0,0,0, 0,0, 0,0,0,0,0,0,0,0,0,0];
	    this._buffTurns = [0,0,0,0,0,0,0,0, 0,0, 0,0,0,0,0,0,0,0,0,0];
	};//*
				
	const _Game_BattlerBase_prototype_paramRate = Game_BattlerBase.prototype.paramRate;
	Game_BattlerBase.prototype.paramRate = function(paramId) {
		return paramId < 10 ? this.traitsPi(Game_BattlerBase.TRAIT_PARAM, paramId) : 1;
	};//*

	const _Game_Actor_prototype_paramBase = Game_Actor.prototype.paramBase;
	Game_Actor.prototype.paramBase = function(paramId) {
		if(paramId < 10){
			if(this._level <= 99){
					return this.currentClass().params[paramId][this._level];	
			}else if(this._level > 99 && !statusParameter.rotateLevelParam){
					return this.currentClass().params[paramId][99];
			}else{
					//rotate parameter
					const rotation = Math.floor( (this._level - 1) / 99);
					const rotatedLevel = this._level - 99 * rotation;
					const params = this.currentClass().params[paramId];
					return params[99] * rotation + params[rotatedLevel];
			};
		}else{
			return 1;
		}
	};//*

	Game_Actor.prototype.paramPlus = function(paramId) {
	    var value = Game_Battler.prototype.paramPlus.call(this, paramId);
	    const equips = this.equips();
		if(paramId < 10){
			    for (var i = 0; i < equips.length; i++) {
			        var item = equips[i];
			        if (item) {
				            value += item.params[paramId];
			        }
			    }
		}
		if(paramId >= 10){
			    let meta;
			    for (var i = 0; i < equips.length; i++) {
			        var item = equips[i];
			        if (item && item.meta.exParam) {
				        	meta = JSON.parse(item.meta.exParam);
				            value += Number(meta[paramId - 10]);
			        };
			    }
		}
	    return value;
	};//*

	//能力名の記述を追加能力にまで拡大
	const _TextManager_param = TextManager.param;
	TextManager.param = function(paramId) {
		if(paramId <10){
				return $dataSystem.terms.params[paramId] || '';
		}else{
				return expansionStatus[paramId] ? expansionStatus[paramId].name || '' : '';
		};  
	};//*

	//エネミーも独自ステータスを参照できるように
	const _Game_Enemy_prototype_paramBase = Game_Enemy.prototype.paramBase;
	Game_Enemy.prototype.paramBase = function(paramId) {
		if(paramId < 8){
				return _Game_Enemy_prototype_paramBase.apply(this, arguments);
		}else if(paramId >9){
				let meta = this.enemy().meta.exParam;
				if(meta){
						meta = JSON.parse(meta);
						return meta[paramId - 10];
				}else{
						return 0;
				}
		}
	};//*
}////
		/*--------ステータスウィンドウへの反映--------------*/

		/*~struct~StatusWindow:ja
			@param 	busy
			@type 		boolean
			@text 		拡張の実行
			@desc 		On（true）にすると、以下の設定が反映されます。
			@default 	true

			@param 	originX
			@type 		number
			@text 		描画原点のｘ座標（px）
			@desc 		ステータスを描画する原点のｘ座標を設定します。初期値は48です。
			@default 	48
			@decimals 	0

			@param 	cols
			@type 		number
			@text 		ステータスの列数
			@desc 		ステータスメニューで、ステータスを表示する列数を設定します。
			@default 	1
			@max 		2
			@min 		1
			@decimals 	0

			@param 	rows
			@type 		number
			@text 		ステータスの行数
			@desc 		ステータスメニューで、ステータスを表示する行数を設定します。
			@default 	8
			@min 		1
			@decimals 	0

			@param 	colsT
			@type 		number
			@text 		特徴の列数
			@desc 		ステータスメニューで、特徴を表示する列数を設定します。
			@default 	1
			@max 		2
			@min 		1
			@decimals 	0

			@param 	rowsT
			@type 		number
			@text 		特徴の行数
			@desc 		ステータスメニューで、特徴を表示する行数を設定します。
			@default 	8
			@min 		1
			@decimals 	0

			@param 	lineHeight
			@type 		number
			@text 		１行あたりの高さ（px）
			@desc 		ステータスメニューで、ステータスの１行あたりの高さを設定します。初期値は36です。能力・装備欄のみに適用されます。
			@default 	28
			@min 		18
			@decimals 	0

			@param 	fontSize
			@type 		number
			@text 		文字サイズ（px）
			@desc 		ステータスメニューで表示する文字のサイズを設定します。初期値は28です。
			@default 	18
			@min 		12
			@decimals 	0

			@param 	widthName
			@type 		number
			@text 		ステータス名の幅（px）
			@desc 		ステータス名の１列あたりの幅の最大値を設定します。初期値は160pxです。装備画面にも適用されます。
			@default 	70
			@decimals 	0

			@param 	widthPoint
			@type 		number
			@text 		ステータス値の幅（px）
			@desc 		ステータス値の１列あたりの幅の最大値を設定します。初期値は60pxです。装備画面にも適用されます。
			@default 	40
			@decimals 	0
			*/
		/*------------------------------------------------------------------------------------------*/
		/*~struct~StatusWindow:
			@param 	busy
			@type 		boolean
			@text 		extend status window
			@desc 		Turn on this children when this is true
			@default 	true

			@param 	originX
			@type 		number
			@text 		x-coordinate of origin（px）
			@desc 		Control x-coordinate where status starts to be drawn; initial value is 48
			@default 	48
			@decimals 	0

			@param 	cols
			@type 		number
			@text 		columns of status
			@desc 		Control the number of columns in status window
			@default 	1
			@max 		2
			@min 		1
			@decimals 	0

			@param 	rows
			@type 		number
			@text 		rows of status
			@desc 		Control the number of rows in status window
			@default 	8
			@min 		1
			@decimals 	0

			@param 	colsT
			@type 		number
			@text 		columns of trait
			@desc 		Control the number of trait's columns in status window
			@default 	1
			@max 		2
			@min 		1
			@decimals 	0

			@param 	rowsT
			@type 		number
			@text 		rows of trait
			@desc 		Control the number of trait's rows in status window
			@default 	8
			@min 		1
			@decimals 	0

			@param 	lineHeight
			@type 		number
			@text 		line height of status window（px）
			@desc 		Control line height of status window; initial value is 36
			@default 	28
			@min 		18
			@decimals 	0

			@param 	fontSize
			@type 		number
			@text 		font size（px）
			@desc 		Control font size of status window; initial value is 28
			@default 	18
			@min 		12
			@decimals 	0

			@param 	widthName
			@type 		number
			@text 		width of status's name（px）
			@desc 		Control max width of status's name; initial value is 160, and applied in equip scene
			@default 	70
			@decimals 	0

			@param 	widthPoint
			@type 		number
			@text 		width of status's parameter（px）
			@desc 		Control max width of status's parameter; initial value is 60, and applied in equip scene
			@default 	40
			@decimals 	0
		*/
		/**************************************************************************************/
		/*~struct~TraitCalc:ja
			@param 	busy
			@type 		boolean
			@text 		計算の実行
			@desc 		On（true）にすると、特徴の項目に適した計算で表示します。詳細は特記事項をご覧ください。
			@default 	true

			@param 	unit
			@type 		boolean
			@text 		単位の付記
			@desc 		On（true）にすると以下の項目を適用し、ステータス画面で特徴に適した単位を付記します。
			@default 	false

			@param 	unitPercent
			@type 		boolean
			@text 		百分率タイプの単位
			@desc 		On（true）にすると、計算タイプが「百分率」の項目に”％”を付記します。
			@default 	true

			@param 	unitGuard
			@type 		boolean
			@text 		耐性タイプの単位
			@desc 		On（true）にすると、計算タイプが「耐性」の項目に”％”を付記します。
			@default 	true
				
			@param 	unitRate
			@type 		boolean
			@text 		倍率タイプの単位
			@desc 		On（true）にすると、計算タイプが「倍率」の項目に”倍”を付記します。
			@default 	true
		*/
		/*------------------------------------------------------------------------------------------*/
		/*~struct~TraitCalc:
			@param 	busy
			@type 		boolean
			@text 		recalculate traits
			@desc 		Recalculate traits along their type when this is true; refer to this help if you need
			@default 	true

			@param 	unit
			@type 		boolean
			@text 		add units
			@desc 		Turn on the following when this is true
			@default 	false

			@param 	unitPercent
			@type 		boolean
			@text 		unit for type of percentage
			@desc 		Add "%" to traits of percentage type when this is true
			@default 	true

			@param 	unitGuard
			@type 		boolean
			@text 		unit for type of resistance
			@desc 		Add "%" to traits of resistance type when this is true
			@default 	true
				
			@param 	unitRate
			@type 		boolean
			@text 		unit for type of rate
			@desc 		Add "x" to traits of rate type when this is true
			@default 	true
		*/
		/*************************************************************************************/
		/*~struct~TraitsWindow:ja
			@param 	busy
			@type 		boolean
			@text 		拡張の実行
			@desc 		On（true）にすると、ステータスウィンドウに特徴の欄を追加します。
			@default 	true

			@param 	traitName1
			@type 		string
			@text 		特徴1の名前
			@desc 		表示したい特徴の名前を設定します。IDに-1を設定すると、表示名の設定は無効化されます。

			@param 	trait1
			@type 		number
			@text 		特徴1のID　
			@desc 		表示したい特徴のIDを設定します。詳細はヘルプの特記事項をご覧ください。
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName2
			@type 		string
			@text 		特徴2の名前
			@desc 		表示したい特徴の名前を設定します。IDに-1を設定すると、表示名の設定は無効化されます。

			@param 	trait2
			@type 		number
			@text 		特徴2のID
			@desc 		表示したい特徴のIDを設定します。詳細はヘルプの特記事項をご覧ください。
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName3
			@type 		string
			@text 		特徴3の名前
			@desc 		表示したい特徴の名前を設定します。IDに-1を設定すると、表示名の設定は無効化されます。

			@param 	trait3
			@type 		number
			@text 		特徴3のID
			@desc 		表示したい特徴のIDを設定します。詳細はヘルプの特記事項をご覧ください。
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName4
			@type 		string
			@text 		特徴4の名前
			@desc 		表示したい特徴の名前を設定します。IDに-1を設定すると、表示名の設定は無効化されます。

			@param 	trait4
			@type 		number
			@text 		特徴4のID　
			@desc 		表示したい特徴のIDを設定します。詳細はヘルプの特記事項をご覧ください。
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName5
			@type 		string
			@text 		特徴5の名前
			@desc 		表示したい特徴の名前を設定します。IDに-1を設定すると、表示名の設定は無効化されます。

			@param 	trait5
			@type 		number
			@text 		特徴5のID　
			@desc 		表示したい特徴のIDを設定します。詳細はヘルプの特記事項をご覧ください。
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName6
			@type 		string
			@text 		特徴6の名前
			@desc 		表示したい特徴の名前を設定します。IDに-1を設定すると、表示名の設定は無効化されます。

			@param 	trait6
			@type 		number
			@text 		特徴6のID　
			@desc 		表示したい特徴のIDを設定します。詳細はヘルプの特記事項をご覧ください。
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName7
			@type 		string
			@text 		特徴7の名前
			@desc 		表示したい特徴の名前を設定します。IDに-1を設定すると、表示名の設定は無効化されます。

			@param 	trait7
			@type 		number
			@text 		特徴7のID　
			@desc 		表示したい特徴のIDを設定します。詳細はヘルプの特記事項をご覧ください。
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName8
			@type 		string
			@text 		特徴8の名前
			@desc 		表示したい特徴の名前を設定します。IDに-1を設定すると、表示名の設定は無効化されます。

			@param 	trait8
			@type 		number
			@text 		特徴8のID　
			@desc 		表示したい特徴のIDを設定します。詳細はヘルプの特記事項をご覧ください。
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName9
			@type 		string
			@text 		特徴9の名前
			@desc 		表示したい特徴の名前を設定します。IDに-1を設定すると、表示名の設定は無効化されます。

			@param 	trait9
			@type 		number
			@text 		特徴9のID　
			@desc 		表示したい特徴のIDを設定します。詳細はヘルプの特記事項をご覧ください。
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName10
			@type 		string
			@text 		特徴10の名前
			@desc 		表示したい特徴の名前を設定します。IDに-1を設定すると、表示名の設定は無効化されます。

			@param 	trait10
			@type 		number
			@text 		特徴10のID　
			@desc 		表示したい特徴のIDを設定します。詳細はヘルプの特記事項をご覧ください。
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName11
			@type 		string
			@text 		特徴11の名前
			@desc 		表示したい特徴の名前を設定します。IDに-1を設定すると、表示名の設定は無効化されます。

			@param 	trait11
			@type 		number
			@text 		特徴11のID　
			@desc 		表示したい特徴のIDを設定します。詳細はヘルプの特記事項をご覧ください。
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName12
			@type 		string
			@text 		特徴12の名前
			@desc 		表示したい特徴の名前を設定します。IDに-1を設定すると、表示名の設定は無効化されます。

			@param 	trait12
			@type 		number
			@text 		特徴12のID　
			@desc 		表示したい特徴のIDを設定します。詳細はヘルプの特記事項をご覧ください。
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName13
			@type 		string
			@text 		特徴13の名前
			@desc 		表示したい特徴の名前を設定します。IDに-1を設定すると、表示名の設定は無効化されます。

			@param 	trait13
			@type 		number
			@text 		特徴13のID　
			@desc 		表示したい特徴のIDを設定します。詳細はヘルプの特記事項をご覧ください。
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName14
			@type 		string
			@text 		特徴14の名前
			@desc 		表示したい特徴の名前を設定します。IDに-1を設定すると、表示名の設定は無効化されます。

			@param 	trait14
			@type 		number
			@text 		特徴14のID　
			@desc 		表示したい特徴のIDを設定します。詳細はヘルプの特記事項をご覧ください。
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName15
			@type 		string
			@text 		特徴15の名前
			@desc 		表示したい特徴の名前を設定します。IDに-1を設定すると、表示名の設定は無効化されます。

			@param 	trait15
			@type 		number
			@text 		特徴15のID　
			@desc 		表示したい特徴のIDを設定します。詳細はヘルプの特記事項をご覧ください。
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName16
			@type 		string
			@text 		特徴16の名前
			@desc 		表示したい特徴の名前を設定します。IDに-1を設定すると、表示名の設定は無効化されます。

			@param 	trait16
			@type 		number
			@text 		特徴16のID　
			@desc 		表示したい特徴のIDを設定します。詳細はヘルプの特記事項をご覧ください。
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

		*/
		/*------------------------------------------------------------------------------------------*/
		/*~struct~TraitsWindow:
			@param 	busy
			@type 		boolean
			@text 		expansion valid
			@desc 		Add traits information to status window when this is true
			@default 	true

			@param 	traitName1
			@type 		string
			@text 		name of trait 1
			@desc 		Define the name of the trait; invalid when the following id is -1

			@param 	trait1
			@type 		number
			@text 		Id of trait 1
			@desc 		Select a number for trait's id; refer to this help if you need
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName2
			@type 		string
			@text 		name of trait 2
			@desc 		Define the name of the trait; invalid when the following id is -1

			@param 	trait2
			@type 		number
			@text 		Id of trait 2
			@desc 		Select a number for trait's id; refer to this help if you need
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName3
			@type 		string
			@text 		name of trait 3
			@desc 		Define the name of the trait; invalid when the following id is -1

			@param 	trait3
			@type 		number
			@text 		Id of trait 3
			@desc 		Select a number for trait's id; refer to this help if you need
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName4
			@type 		string
			@text 		name of trait 4
			@desc 		Define the name of the trait; invalid when the following id is -1

			@param 	trait4
			@type 		number
			@text 		Id of trait 4
			@desc 		Select a number for trait's id; refer to this help if you need
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName5
			@type 		string
			@text 		name of trait 5
			@desc 		Define the name of the trait; invalid when the following id is -1

			@param 	trait5
			@type 		number
			@text 		Id of trait 5
			@desc 		Select a number for trait's id; refer to this help if you need
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName6
			@type 		string
			@text 		name of trait 6
			@desc 		Define the name of the trait; invalid when the following id is -1

			@param 	trait6
			@type 		number
			@text 		Id of trait 6
			@desc 		Select a number for trait's id; refer to this help if you need
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName7
			@type 		string
			@text 		name of trait 7
			@desc 		Define the name of the trait; invalid when the following id is -1

			@param 	trait7
			@type 		number
			@text 		Id of trait 7
			@desc 		Select a number for trait's id; refer to this help if you need
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName8
			@type 		string
			@text 		name of trait 8
			@desc 		Define the name of the trait; invalid when the following id is -1

			@param 	trait8
			@type 		number
			@text 		Id of trait 8
			@desc 		Select a number for trait's id; refer to this help if you need
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName9
			@type 		string
			@text 		name of trait 9
			@desc 		Define the name of the trait; invalid when the following id is -1

			@param 	trait9
			@type 		number
			@text 		Id of trait 9
			@desc 		Select a number for trait's id; refer to this help if you need
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName10
			@type 		string
			@text 		name of trait 10
			@desc 		Define the name of the trait; invalid when the following id is -1

			@param 	trait10
			@type 		number
			@text 		Id of trait 10
			@desc 		Select a number for trait's id; refer to this help if you need
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0


			@param 	traitName11
			@type 		string
			@text 		name of trait 11
			@desc 		Define the name of the trait; invalid when the following id is -1

			@param 	trait11
			@type 		number
			@text 		Id of trait 11
			@desc 		Select a number for trait's id; refer to this help if you need
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0


			@param 	traitName12
			@type 		string
			@text 		name of trait 12
			@desc 		Define the name of the trait; invalid when the following id is -1

			@param 	trait12
			@type 		number
			@text 		Id of trait 12
			@desc 		Select a number for trait's id; refer to this help if you need
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0


			@param 	traitName13
			@type 		string
			@text 		name of trait 13
			@desc 		Define the name of the trait; invalid when the following id is -1

			@param 	trait13
			@type 		number
			@text 		Id of trait 13
			@desc 		Select a number for trait's id; refer to this help if you need
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0


			@param 	traitName14
			@type 		string
			@text 		name of trait 14
			@desc 		Define the name of the trait; invalid when the following id is -1

			@param 	trait14
			@type 		number
			@text 		Id of trait 14
			@desc 		Select a number for trait's id; refer to this help if you need
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName15
			@type 		string
			@text 		name of trait 15
			@desc 		Define the name of the trait; invalid when the following id is -1

			@param 	trait15
			@type 		number
			@text 		Id of trait 15
			@desc 		Select a number for trait's id; refer to this help if you need
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0

			@param 	traitName16
			@type 		string
			@text 		name of trait 16
			@desc 		Define the name of the trait; invalid when the following id is -1

			@param 	trait16
			@type 		number
			@text 		Id of trait 16
			@desc 		Select a number for trait's id; refer to this help if you need
			@default 	-1
			@min 		-1
			@max 		1200
			@decimals 	0
		*/

		//traitを増設した際は、parseファンクションとgetファンクションのcheckerも増設

		const parseWindowCustom = s => JSON.parse(s, (key, value)=>{
			switch(key){
					case 'busy' 		: return value;
					case 'originX' 		: return Number.parseFloat(value);
					case 'cols'			: return Number.parseFloat(value);
					case 'rows'			: return Number.parseFloat(value);
					case 'colsT'		: return Number.parseFloat(value);
					case 'rowsT'		: return Number.parseFloat(value);
					case 'lineHeight' 	: return Number.parseFloat(value);
					case 'fontSize'		: return Number.parseFloat(value);
					case 'widthName'	: return Number.parseFloat(value);
					case 'widthPoint' 	: return Number.parseFloat(value);

					case 'unit'			: return value;
					case 'unitPercent'	: return value;
					case 'unitGuard'	: return value;
					case 'unitRate'		: return value;

					case 'traitName1' 	: return value;
					case 'trait1' 		: return Number.parseFloat(value);
					case 'traitName2' 	: return value;
					case 'trait2' 		: return Number.parseFloat(value);
					case 'traitName3' 	: return value;
					case 'trait3' 		: return Number.parseFloat(value);
					case 'traitName4' 	: return value;
					case 'trait4' 		: return Number.parseFloat(value);
					case 'traitName5' 	: return value;
					case 'trait5' 		: return Number.parseFloat(value);
					case 'traitName6' 	: return value;
					case 'trait6' 		: return Number.parseFloat(value);
					case 'traitName7' 	: return value;
					case 'trait7' 		: return Number.parseFloat(value);
					case 'traitName8' 	: return value;
					case 'trait8' 		: return Number.parseFloat(value);
					case 'traitName9' 	: return value;
					case 'trait9' 		: return Number.parseFloat(value);
					case 'traitName10' 	: return value;
					case 'trait10' 		: return Number.parseFloat(value);
					case 'traitName11' 	: return value;
					case 'trait11' 		: return Number.parseFloat(value);
					case 'traitName12' 	: return value;
					case 'trait12' 		: return Number.parseFloat(value);
					case 'traitName13' 	: return value;
					case 'trait13' 		: return Number.parseFloat(value);
					case 'traitName14' 	: return value;
					case 'trait14' 		: return Number.parseFloat(value);
					case 'traitName15' 	: return value;
					case 'trait15' 		: return Number.parseFloat(value);
					case 'traitName16' 	: return value;
					case 'trait16' 		: return Number.parseFloat(value);
					default 			: return value;
			}
		});//*

		let statusWindow = params.statusWindow;
		let consolerNameStatusWindow = 'statusWindow:';
		if(statusWindow){
				statusWindow = parseWindowCustom(statusWindow);
				statusWindow = stringToBoolean(statusWindow);
		}else{
				statusWindow = makeNotValid();
				undefinedStructs.push(consolerNameStatusWindow);
				consolerNameStatusWindow += makeInvalidTerm();
		};
		//--------------------------------------------------//
		let traitsWindow = params.traitsWindow;
		let consolerNameTraitsWindow = 'traitsWindow:';
		if(traitsWindow){
				traitsWindow = parseWindowCustom(traitsWindow);
				traitsWindow = stringToBoolean(traitsWindow);
		}else{
				traitsWindow = makeNotValid();
				undefinedStructs.push(consolerNameTraitsWindow);
				consolerNameTraitsWindow += makeInvalidTerm();
		};
		//--------------------------------------------------//
		let traitCalc = params.traitCalc;
		let consolerNameTraitCalc = 'traitCalc:';
		if(traitCalc){
				traitCalc = parseWindowCustom(traitCalc);
				traitCalc = stringToBoolean(traitCalc);
		}else{
				traitCalc = makeNotValid();
				undefinedStructs.push(consolerNameTraitCalc);
				consolerNameTraitCalc += makeInvalidTerm();
		};
		//--------------------------------------------------//	
		//MELOS Global Variable override	
		traitCalcValid = traitCalc.busy;
		consoler(consolerNameStatusWindow, statusWindow);
		consoler(consolerNameTraitsWindow, traitsWindow);
		consoler(consolerNameTraitCalc, traitCalc);

		let traitSet = [];

//ステータス画面と装備画面で共有する、特性取得のファンクション
Window_Base.prototype.getTraits = function(who){
	let checker = this.getTraitsWindows();
	let id ;
	let actor = who === 'temp' ? this._tempActor || this._actor : this._actor ;

	for(var i = 0; i < checker.length; i++){
			id = checker[i].id;

			if(id === -1){
					traitSet.push({ name: 	'skip',
									value: 	'skip',
									calc: 	'skip',
									id: 	'skip'});
			}else if(id < 10){
					traitSet.push({ name: 	checker[i].name,
									value: 	actor.xparam(id),
									calc: 	'percent',
									id: 	checker[i].id});
			}else if(id < 20){
					id %= 10;
					let calcType = this.getCalcTypeforSparam(id);		
					traitSet.push({ name: 	checker[i].name,
									value: 	actor.sparam(id),
									calc: 	calcType,
									id: 	checker[i].id});
			}else if(id < 200 && id > 100){
					id -= 100;
					traitSet.push({ name: 	checker[i].name,
									value: 	actor.elementRate(id),
									calc: 	'guard',
									id: 	checker[i].id});
			}else if(id < 1200 && id > 200){
					id -= 200;
					traitSet.push({ name: 	checker[i].name,
									value: 	actor.stateRate(id),
									calc: 	'guard',
									id: 	checker[i].id});
			}else{
					//default
					traitSet.push({ name: 	'skip',
									value: 	'skip',
									calc: 	'skip',
									id: 	'skip'});
			}
	};
};//*

Window_Base.prototype.getTraitsWindows = function(){
	return [{name: traitsWindow.traitName1, id: traitsWindow.trait1},
			{name: traitsWindow.traitName2, id: traitsWindow.trait2},
			{name: traitsWindow.traitName3, id: traitsWindow.trait3},
			{name: traitsWindow.traitName4, id: traitsWindow.trait4},
			{name: traitsWindow.traitName5, id: traitsWindow.trait5},
			{name: traitsWindow.traitName6, id: traitsWindow.trait6},
			{name: traitsWindow.traitName7, id: traitsWindow.trait7},
			{name: traitsWindow.traitName8, id: traitsWindow.trait8},
			{name: traitsWindow.traitName9, id: traitsWindow.trait9},
			{name: traitsWindow.traitName10, id: traitsWindow.trait10},
			{name: traitsWindow.traitName11, id: traitsWindow.trait11},
			{name: traitsWindow.traitName12, id: traitsWindow.trait12},
			{name: traitsWindow.traitName13, id: traitsWindow.trait13},
			{name: traitsWindow.traitName14, id: traitsWindow.trait14},
			{name: traitsWindow.traitName15, id: traitsWindow.trait15},
			{name: traitsWindow.traitName16, id: traitsWindow.trait16} ];
};//*

Window_Base.prototype.getCalcTypeforSparam = function(id){
	switch(id){
			case 0:
			case 1:
			case 2:
			case 3:
			case 5:
			case 9:
				return 'rate';
			break;

			case 4:
			case 6:
			case 7:
				return 'guard';
			break;

			default : return 'percent';
	};
};//*


const calcTraitPoint = function(type, value){
	let result = getTraitValueWithType(type, value);
	let unit = traitCalc.busy && traitCalc.unit ? displayTraitUnit(type) : '';
	return result + unit;
};//*

const getTraitValueWithType = function(type, value){
	switch(type){
		case 'rate' 	: return Math.floor(value * 100)/100; break;
		case 'guard'	: return Math.floor((1 - value) * 100 * 100)/100; break;
		case 'percent' 	: return Math.floor(value * 100 * 100)/100; break;
		default 		: return  Math.floor(value * 100 * 100)/100;
	};
};//*

const displayTraitUnit = function(type){
	let timesText = '';
	if(type === 'rate') timesText = $gameSystem.isJapanese() ? '倍' : 'times';
	switch(type){
		case 'rate'		: return traitCalc.unitRate ? timesText : '';   break;
		case 'guard'	: return traitCalc.unitGuard ? '％' : '';   		break;
		case 'percent'	: return traitCalc.unitPercent ? '％' : ''; 		break;
		default 		: return '';
	};
};//*

if(statusParameter.addon && statusWindow.busy){
	let cols = statusWindow.cols;
	let rows = statusWindow.rows;
	let colsT = MV ? statusWindow.colsT : (traitsWindow.busy ? statusWindow.colsT : 0);
	let rowsT = MV ? statusWindow.rowsT : (traitsWindow.busy ? statusWindow.rowsT : 0);

	let fontSize = statusWindow.fontSize;
	let widthName = statusWindow.widthName;
	let widthPoint = statusWindow.widthPoint;
	let verticalWidth = 2;
	let colWidth = widthName * 1.5 + widthPoint;

	if(MV){
		Window_Status.prototype.standardFontSize = function(){
			return fontSize;
		};//*

		Window_Status.prototype.drawBlock3 = function(y){
			this.drawParameters(statusWindow.originX, y);

			let equipsX = statusWindow.originX + colWidth * cols + verticalWidth;
			this.drawEquipments(equipsX, y);

			if(traitsWindow.busy){
					let traitsX = this.width - widthPoint - colWidth * colsT;
					this.getTraits();
					this.drawTraits(traitsX, y);
			};
		};//*

		const _Window_Status_prototype_drawParameters = Window_Status.prototype.drawParameters;
		Window_Status.prototype.drawParameters = function(x, y) {
			let lineHeight = statusWindow.lineHeight;
			let paramIndex = 0;
		    let currentRow = 0;

		    for (var c = 0; c < cols; c++){
			    currentRow = 0;

			    for (var r = paramIndex; r < rows+paramIndex; r++) {
			        var paramId = r < 6 ? r + 2 : r + 4;
			        var y2 = y + lineHeight * currentRow;
			        if(TextManager.param(paramId) !== ''){
				        let iconWidth = 0;
				        if(statusIconOk){
					       		this.drawIcon(statusIcons[paramId], x, y2);
					       		iconWidth = 32;
				       	}
				       	this.changeTextColor(this.systemColor());
					    this.drawText(TextManager.param(paramId), x + iconWidth, y2, widthName - iconWidth);
				        this.resetTextColor();
				        this.drawText(this._actor.param(paramId), x + widthName, y2, widthPoint, 'right');

				        currentRow ++;
				    };		        
			    };//r end

				paramIndex += rows;
			    x += colWidth;
			};//c end

			this.drawVertical(x, y);
		};//*

		const _Window_Status_prototype_drawEquipments = Window_Status.prototype.drawEquipments;
		Window_Status.prototype.drawEquipments = function(x, y) {
			let equipMenuName = TextManager.command(6);
			this.drawText(`【${equipMenuName}】`, x, y );

		    var equips = this._actor.equips();
		    var count = Math.min(equips.length, this.maxEquipmentLines());
		    for (var i = 0; i < count; i++) {
		        this.drawItemName(equips[i], x, y + this.lineHeight() * (i + 1));
		    }
		};//*

		Window_Status.prototype.getTraits = function(who){
			Window_Base.prototype.getTraits.apply(this, arguments);
		};//*

		Window_Status.prototype.drawTraits = function(x, y){
			this.drawVertical(x, y);
			let x2 = x + this.standardPadding();
			let y2;
			let lineHeight = statusWindow.lineHeight;
			let currentRow = 0;
			let traitIndex = 0;
			let traitName;
			let traitValue;
				
			for(var c = 0; c < colsT; c++){
				currentRow = 0;

				for(var r = traitIndex; r < rowsT + traitIndex; r++){
					if(traitSet[r].value !== 'skip'){
							traitName = traitSet[r].name;
							traitValue = calcTraitPoint(traitSet[r].calc, traitSet[r].value);
							y2 = y + lineHeight * currentRow;

							this.changeTextColor(this.systemColor());
							this.drawText(traitName, x2, y2, widthName);
							this.resetTextColor();
							this.drawText(traitValue, x2 + widthName, y2, widthPoint, 'right');

							currentRow++;
					};
				};//r end

				traitIndex += rowsT;
				x2 += colWidth;
			};//c end
						
			traitSet = []; //初期化しないと、メニューを開く度に中身が増えていく
		};//*
						
					
		Window_Status.prototype.drawVertical = function(x, y) {
		    let lineX = x; //y + this.lineHeight() / 2 - 1;
		    let height = rows * (this.standardFontSize() + this.textPadding());

		    this.contents.paintOpacity = 48;
		    this.contents.fillRect(lineX, y, verticalWidth, height, this.lineColor());
		    this.contents.paintOpacity = 255;
		};//*
	};////

	if(MZ){
		const _Scene_Status_prototype_statusParamsWidth = Scene_Status.prototype.statusParamsWidth;
		Scene_Status.prototype.statusParamsWidth = function() {
		    return colWidth * Math.min(cols + colsT, 3) || 300;
		};//*

		const _Window_StatusParams_prototype_standardFontSize = Window_StatusParams.prototype.standardFontSize;
		Window_StatusParams.prototype.standardFontSize = function(){
			return fontSize;
		};//*

		const _Window_StatusParams_prototype_maxItems = Window_StatusParams.prototype.maxItems;
		Window_StatusParams.prototype.maxItems = function() {
		    return rows;
		};//*

		const _Window_StatusParams_prototype_lineHeight = Window_StatusParams.prototype.lineHeight;
		Window_StatusParams.prototype.lineHeight = function(){
			return statusWindow.lineHeight;
		};//*

		const _Window_StatusParams_prototype_drawItem = Window_StatusParams.prototype.drawItem;
		Window_StatusParams.prototype.drawItem = function(index) {
		    const rect = this.itemLineRect(index);
		    const paramId = index < 6 ? index + 2 : index + 4;
		    const name = TextManager.param(paramId);
		    const value = this._actor.param(paramId);
		    this.changeTextColor(ColorManager.systemColor());
		    this.drawText(name, rect.x, rect.y, widthName);
		    this.resetTextColor();
		    this.drawText(value, rect.x + widthName, rect.y, widthPoint, "right");

		    if(cols > 1){
		    		this.drawItem2(index, rect);
		    }
		    if(traitsWindow.busy){
		    		this.getTraits();
		    		this.drawTraits(index, rect, 1);
		    		if(colsT > 1){
		    			this.drawTraits(index, rect, 2);
		    		}
		    		traitSet = [];
		    };
		};//*

		Window_StatusParams.prototype.drawItem2 = function(index, rect){
			const bottomId = rows > 6 ? rows + 4 : rows + 2;
		    let paramId = bottomId + index;
		    if(rows < 7 && paramsId > 7) paramsId += 2;
		    const name = TextManager.param(paramId);
		    if(name){
		    		const value = this._actor.param(paramId);
				    const x2 = rect.x + colWidth;
				    this.changeTextColor(ColorManager.systemColor());
				    this.drawText(name, x2, rect.y, widthName);
				    this.resetTextColor();
				    this.drawText(value, x2 + widthName, rect.y, widthPoint, "right");
		    }
		};//*

		Window_StatusParams.prototype.drawTraits = function(index, rect, col){
			const traitId = Math.min(index + rowsT * (col - 1), traitSet.length - 1);
			const name = traitSet[traitId].name;
			const value = calcTraitPoint(traitSet[traitId].calc, traitSet[traitId].value);
			const x3 = rect.x + colWidth * (cols + col - 1);
			if(name && name !== 'skip'){
					this.changeTextColor(this.systemColor());
					this.drawText(name, x3, rect.y, widthName);
					this.resetTextColor();
					this.drawText(value, x3 + widthName, rect.y, widthPoint, 'right');
			}
		};//*

		//-------------------------------------------------------------------//

		Window_StatusEquip.prototype.standardFontSize = function(){
			return fontSize;
		};//*
	}////
}////

		/*--------装備画面にも追加能力や特性を反映------------*/
		/*~struct~EquipWindow:ja
			@param 	valid
			@type 		boolean
			@text 		装備画面変更
			@desc 		On（true）の時、以下の設定を反映します。
			@default 	true

			@param 	display
			@type 		select
			@text 		表示形式
			@desc 		装備ステータスのウィンドウで、能力の表示形式を設定します。
			@default 	normal

				@option 	デフォルト（１列表示）
				@value 	normal

				@option 	２列表示（通常能力＋追加能力）
				@value 	twoCols

				@option 	２列表示（通常能力＋特徴）
				@value 	addTraits

			@param 	optimizeValid
			@type 		boolean
			@text 		最強の有効化
			@desc 		Off（false）にすると、「最強」のコマンドを非表示にできます。能力ウィンドウに割きたい人向け。
			@default 	true

			@param 	nameValid
			@type 		boolean
			@text 		名前の表示設定
			@desc 		Off（false）にすると、能力ウィンドウにアクターの名前が表示されなくなります。
			@default 	true

			@param 	longSlotValid
			@type 		boolean
			@text 		装備スロット欄拡張
			@desc 		On(true)にすると、スロット数が多い場合にウィンドウの高さを拡張します。
			@default 	true

			@param 	slotNameWidth
			@type 		number
			@text 		スロット名の幅(px)
			@desc 		装備スロットのスロット名の幅を設定します。初期値は138です。
			@default 	138
			@decimals 	0

			@param 	statusWidth
			@type 		number
			@text 		能力ウィンドウの幅(px)
			@desc 		能力ウィンドウの幅を設定します。初期値は312です。
			@default 	312
			@min 		1
			@decimals 	0

			@param 	rows
			@type 		number
			@text 		能力ウィンドウの行数
			@desc 		能力ウィンドウで１列に表示する能力の数を設定します。初期値は7です。アクター名も含みます。
			@default 	7
			@min 		1
			@decimals 	0

			@param 	fontSize
			@type 		number
			@text 		文字サイズ(px)
			@desc 		装備のスロット画面での文字サイズを設定します。初期値は28です。
			@default 	28
			@min 		12
			@decimals 	0

			@param 	lineHeight
			@type 		number
			@text  	行の高さ(px)
			@desc 		１行あたりの行の高さを設定します。初期値は36です。
			@default 	36
			@min 		1
			@decimals 	0

			@param 	accessorySlot
			@type 		number[]
			@text 		装飾品のスロット数
			@desc 		装飾品を複数装備できるようにします。[装飾品の開始ID, 最大装備数, 開始時封印数]
			@default 	["5", "1", "2"]

			@param 	subEquipValid
			@type 		boolean
			@text 		装備のサブセット実装
			@desc 		On（true）の時、装備メニューにサブセットの項目を追加します。
			@default 	false

			@param 	subEquipCommandName
			@type 		string
			@text 		サブセットコマンド名
			@desc 		装備メニューで表示するサブセット項目の名前を設定します。
			@default 	サブ装備

			@param 	exchangeCommandName
			@type 		string
			@text 		装備入替えコマンド名
			@desc 		装備メニューで表示する装備入替え項目の名前を設定します。
			@default 	装備入替え

			@param 	subEquipableParts
			@type 		select
			@text 		サブ変更可能部位
			@desc 		サブ装備で変更を許可する部位を選択します。禁止部位はメイン装備と同じになります。
			@default 	all
				@option 全部位
				@value 	all
				@option 防具（武器・盾以外）
				@value 	armors
				@option 武器・盾（同時入替え式）
				@value 	bothHands
				@option 武器・盾（独立入替え式）
				@value 	eachHand

			@param 	subEquipableIcon
			@type 		boolean
			@text 		変更可能部位アイコン
			@desc 		On（true）の時、変更できる部位にメインなら1、サブなら2の数字アイコンが付記されます。
			@default 	true
		*/
		/*-------------------------------------------------------------------------------------*/
		/*~struct~EquipWindow:
			@param 	valid
			@type 		boolean
			@text 		valid equip scene custom
			@desc 		Apply the following when this is true
			@default 	true

			@param 	display
			@type 		select
			@text 		display status in equip
			@desc 		Select a type of displaying statuses in equip window
			@default 	normal

				@option 	default（only 1 column for statuses）
				@value 	normal

				@option 	2 columns（statuses and more expansion statuses）
				@value 	twoCols

				@option 	2 columns（statuses and traits）
				@value 	addTraits

			@param 	optimizeValid
			@type 		boolean
			@text 		display equip command "optimize"
			@desc 		Hide the command when this is false; helpful when you want more width of status window
			@default 	true

			@param 	nameValid
			@type 		boolean
			@text 		display actor's name
			@desc 		Hide the name in equip's status window when this is false
			@default 	true

			@param 	longSlotValid
			@type 		boolean
			@text 		extend slot window
			@desc 		Extend height of slot window when this is true
			@default 	true

			@param 	slotNameWidth
			@type 		number
			@text 		width of slot's name(px)
			@desc 		Control width of equip slot's name; initial value is 138
			@default 	138
			@decimals 	0

			@param 	statusWidth
			@type 		number
			@text 		width of status window in equip(px)
			@desc 		Control width of status window in equip scene; initial value is 312
			@default 	312
			@min 		1
			@decimals 	0

			@param 	rows
			@type 		number
			@text 		rows of status window in equip
			@desc 		Control the number of rows including actor's name; initial value is 7
			@default 	7
			@min 		1
			@decimals 	0

			@param 	fontSize
			@type 		number
			@text 		font size(px)
			@desc 		Control font size of slot window; initial value is 28
			@default 	28
			@min 		12
			@decimals 	0

			@param 	lineHeight
			@type 		number
			@text  	line height(px)
			@desc 		Control line height of slot window; initial value is 36
			@default 	36
			@min 		1
			@decimals 	0

			@param 	accessorySlot
			@type 		number[]
			@text 		amount of accessory slots
			@desc 		Enable to equip more accessories, constructed of [start of slot id, max equipable, initial banned]
			@default 	["5", "1", "2"]

			@param 	subEquipValid
			@type 		boolean
			@text 		sub set of equip
			@desc 		Enable to set sub equips when this is true
			@default 	false

			@param 	subEquipCommandName
			@type 		string
			@text 		command name of subEquip
			@desc 		Write the command name displayed in equip menu
			@default 	Sub Equip

			@param 	exchangeCommandName
			@type 		string
			@text 		command name of exchange equips
			@desc 		Write the command name displayed in equip menu
			@default 	Exchange Equips Set

			@param 	subEquipableParts
			@type 		select
			@text 		equipable parts of sub equips
			@desc 		Select the type of equipable parts; unchangable parts are same as main equips
			@default 	all
				@option All Parts
				@value 	all
				@option Armors; excepted Weapon and Shield
				@value 	armors
				@option Weapon and Shield; exchanging together
				@value 	bothHands
				@option Weapon and Shield; exchanging separately
				@value 	eachHand

			@param 	subEquipableIcon
			@type 		boolean
			@text 		icon on equipable parts
			@desc 		Add number icons on equipable parts when this is true; 1 for main parts, 2 for sub parts
			@default 	true
		*/

		const parseEquipWindow = s => JSON.parse(s, (key, value) => {
			switch(key){
				case 'valid' 			: return value;
				case 'display' 			: return value;
				case 'optimizeValid' 	: return value;
				case 'nameValid' 		: return value;
				case 'longSlotValid' 	: return value;
				case 'slotNameWidth' 	: return Number.parseFloat(value);
				case 'statusWidth' 		: return Number.parseFloat(value);
				case 'rows' 			: return Number.parseFloat(value);
				case 'fontSize' 		: return Number.parseFloat(value);
				case 'lineHeight' 		: return Number.parseFloat(value);
				case 'accessorySlot' 	: return JSON.parse(value);
				case 'subEquipValid' 	: return value;
				case 'subEquipCommandName' : return value;
				case 'exchangeCommandName' : return value;
				case 'subEquipableParts': return value;
				case 'subEquipableIcon'	: return value;
				default 				: return value;
			};
		});//*

		let equipWindow = params.equipWindow;
		let consolerNameEquipWindow = 'equipWindow';
		if(equipWindow){
				equipWindow = parseEquipWindow(equipWindow);
				equipWindow.accessorySlot[0] = Number(equipWindow.accessorySlot[0]);
				equipWindow.accessorySlot[1] = Number(equipWindow.accessorySlot[1]);
				equipWindow.accessorySlot[2] = Number(equipWindow.accessorySlot[2]);
				equipWindow = stringToBoolean(equipWindow);
		}else{
				equipWindow = makeNotValid();
				undefinedStructs.push(consolerNameEquipWindow);
				consolerNameEquipWindow += makeInvalidTerm();
		};
	
		consoler(consolerNameEquipWindow, equipWindow);

if(statusParameter.addon && equipWindow.valid){
	//MELOS Global Variable override
	if(!sealingSlot){
			sealingSlot = equipWindow.accessorySlot[2];
	};
	accessoryStart = equipWindow.accessorySlot[0] - 1; 	//装備画面で防具タイプ分けする際に利用

	Window_EquipSlot.prototype.standardFontSize = function(){
		return equipWindow.fontSize;
	};//*

	Window_EquipCommand.prototype.standardFontSize = function(){
		return equipWindow.fontSize;
	};//*

	Window_EquipItem.prototype.standardFontSize = function(){
		return equipWindow.fontSize;
	};//*

	const _Window_EquipSlot_prototype_drawItem = Window_EquipSlot.prototype.drawItem;
	Window_EquipSlot.prototype.drawItem = function(index) {
	    if (this._actor) {
	        var rect = this.itemRectForText(index);
	        this.changeTextColor(this.systemColor());
	        this.changePaintOpacity(this.isEnabled(index));
	        this.drawText(this.slotName(index), rect.x, rect.y, equipWindow.slotNameWidth, this.lineHeight());
	        this.drawItemName(this._actor.equips()[index], rect.x + equipWindow.slotNameWidth, rect.y);
	        this.changePaintOpacity(true);
	    }
	};//*
}////


if(statusParameter.addon && equipWindow.valid && statusWindow.busy){
	const _Window_EquipStatus_prototype_windowWidth = Window_EquipStatus.prototype.windowWidth;
	Window_EquipStatus.prototype.windowWidth = function() {
	    return equipWindow.statusWidth;
	};

	//for MZ
	const _Scene_Equip_prototype_statusWidth = Scene_Equip.prototype.statusWidth;
	Scene_Equip.prototype.statusWidth = function() {
	    return equipWindow.statusWidth || 312;
	};//*

	const _Window_EquipStatus_prototype_standardFontSize = Window_EquipStatus.prototype.standardFontSize;
	Window_EquipStatus.prototype.standardFontSize = function(){
		return equipWindow.fontSize;
	};//*

	const _Window_EquipStatus_prototype_lineHeight = Window_EquipStatus.prototype.lineHeight;
	Window_EquipStatus.prototype.lineHeight = function(){
		return equipWindow.lineHeight;
	};//*

	const _Window_EquipStatus_prototype_numVisibleRows = Window_EquipStatus.prototype.numVisibleRows;
	Window_EquipStatus.prototype.numVisibleRows = function() {
	    return equipWindow.rows || _Window_EquipStatus_prototype_numVisibleRows.apply(this, arguments); 
	};//*

	Window_EquipStatus.prototype.maxRows = function(){
		const rows = this.numVisibleRows();
		return equipWindow.nameValid ? rows - 1 : rows;
	};//*

	Window_EquipStatus.prototype.secondOrigin = function(x1){
		const width = Math.ceil(this.contentsWidth() / 2);
		const x2 = this.calcColWidth();
		return x1 + Math.max(width, x2);
	};//*

	const _Window_EquipStatus_prototype_refresh = Window_EquipStatus.prototype.refresh;
	Window_EquipStatus.prototype.refresh = function() {
	    this.contents.clear();

		let originX = 0;
		let originY = 0;
		if (this._actor) {
		    if(equipWindow.nameValid){
		    		if(MZ){
		    			const nameRect = this.itemLineRect(0);
				        this.drawActorName(this._actor, nameRect.x, 0, nameRect.width/2);
				        this.drawActorFace(this._actor, nameRect.x + nameRect.width/2, 0);
				        originY = this.adjustOriginY(originY);
			   		}else if(MV){
			   			this.drawActorName(this._actor, this.textPadding(), 0);
		    			originY = this.adjustOriginY(originY);
		    		}
		    };
					        
			switch(equipWindow.display){
		        case 'normal': this.drawStatus(originX, originY); break;
				case 'twoCols': this.draw2colsStatus(originY);break;
				case 'addTraits':
			        	this.drawStatus(originX, originY);
						const originX2 = this.secondOrigin(originX);
						this.drawTraits(originX2, originY);		
		        break;

				default:
			};
		};
	};//*

	Window_EquipStatus.prototype.adjustOriginY = function(originY){
		return originY + (MV ? 1 : 4);
	};//*

	Window_EquipStatus.prototype.drawStatus = function(x, y){
		//能力値を１列で表示する場合
		let paramId = 0;
		let currentRow = 0;

		for (var r = 0; r < this.maxRows(); r++) {
			paramId = r >= 6 ? 4 + r : 2 + r;
			if(TextManager.param(paramId) !== ''){
			        let iconWidth = 0;
				    if(statusIconOk){
				        this.drawIcon(statusIcons[paramId], x, this.lineHeight() * (y + currentRow));
				        iconWidth = 32;
				    }
			        this.drawItem(x + iconWidth, this.lineHeight() * (y + currentRow), paramId);
						        			
			       	currentRow ++;
			};
		}
	};//*

	Window_EquipStatus.prototype.draw2colsStatus = function(y){
		//能力値を2列にまたいで表示する場合
		let paramIndex = 0;
		let paramId = 0;
	    let currentRow = 0;
		let x = 0;
        let maxRows = 0;
        let cols = 2;

	    for(var c = 0; c < cols; c++){
			currentRow = 0;
			maxRows = Math.min(this.maxRows() + paramIndex, expansionStatus.length);

			for (var r = paramIndex; r < maxRows; r++) {
		      	paramId = r >= 6 ? 4 + r : 2 + r;

			   	if(TextManager.param(paramId) !== ''){
	        		let iconWidth = 0;
		        	if(statusIconOk){
			        		this.drawIcon(statusIcons[paramId], x, this.lineHeight() * (y + currentRow));
			        		iconWidth = 32;
		        	}
	        		this.drawItem(x + iconWidth, this.lineHeight() * (y + currentRow), paramId);
						        		
	        		currentRow ++;	
	        	};
	        	r += paramId >= expansionStatus.length - 1 ? expansionStatus.length : 0;
	        }//r end

	        paramIndex += maxRows;
	        x = this.secondOrigin(x);
		};//c end
	};//*

	Window_EquipStatus.prototype.drawTraits = function(x, y){
		//２列目に特性を表示する場合
		let paramId = 0;

		let x2 = x + this.standardPadding();
		let y2;
		let lineHeight = statusWindow.lineHeight;
		let currentRow = 0;

		let widthName = statusWindow.widthName;
		let widthPoint = statusWindow.widthPoint;
		let widthArrow = x2 + widthName + widthPoint + this.standardPadding();

		let traitIndex = 0;
		let traitName;
		let traitValue;

		for(var r = traitIndex; r < equipWindow.rows + traitIndex; r++){
			if(r === 0){
					this.getTraits();
					this.getTraits('temp');
			};

			if(traitSet[r].value !== 'skip'){
					traitName = traitSet[r].name;
					traitValue = calcTraitPoint(traitSet[r].calc, traitSet[r].value);
					y2 = this.lineHeight() * (y + currentRow);

					this.changeTextColor(this.systemColor());
					this.drawText(traitName, x2, y2, widthName);
					if(this._actor){
							this.resetTextColor();
							this.drawText(traitValue, x2 + widthName, y2, widthPoint, 'right');
					};
									
					this.drawRightArrow(widthArrow, y2);

					if(this._tempActor){
							let id = r + traitSet.length / 2;
							let originX = widthArrow + this.standardFontSize() + this.standardPadding();
							this.drawNewTraitParam(originX, y2, id, traitValue);
					};

					currentRow++;
			};
		};//r end
							
		traitSet = []; //初期化しないと、メニューを開く度に中身が増えていく
	};//*

	Window_EquipStatus.prototype.calcColWidth = function(){
		let widthName = statusWindow.widthName;
		let widthPoint = statusWindow.widthPoint;
		let widthArrow = 32;
		let padding = this.textPadding();
							
		return widthName + widthPoint * 2 + widthArrow + padding * 4;
	};//*


	const _Window_EquipStatus_prototype_drawItem = Window_EquipStatus.prototype.drawItem;
	Window_EquipStatus.prototype.drawItem = function(x, y, paramId) {
		let widthName = statusWindow.widthName;
		let widthArrow = widthName + statusWindow.widthPoint + this.standardPadding();
		let widthPoint = widthArrow + this.standardPadding();
						
		this.drawParamName(x + this.textPadding(), y, paramId);
		if (this._actor) {
		        this.drawCurrentParam(x + widthName, y, paramId); //default x+140
	    }
	    this.drawRightArrow(x + widthArrow, y); //default x+188
	    if (this._tempActor) {
		        this.drawNewParam(x + widthPoint, y, paramId); 	//default x+222
	    }
	};//*

	Window_EquipStatus.prototype.drawNewTraitParam = function(x, y, id, before) {
	    var newValue = calcTraitPoint(traitSet[id].calc, traitSet[id].value);
	    var diffvalue, noUnit, newValueNoUnit, beforeNoUnit;

	   	if(newValue.contains('倍') || newValue.contains('％')){
	    		noUnit = true;
	    		newValueNoUnit 	= newValue.replace(newValue.slice(-1), '');
		   		beforeNoUnit 	= before.replace(before.slice(-1), '');
		}

	    diffvalue = noUnit ? Number(newValueNoUnit) - Number(beforeNoUnit) : newValue - before;

		   this.changeTextColor(this.paramchangeTextColor(diffvalue));
		   this.drawText(newValue, x, y, 48, 'right');
	};//*		
}////

if(statusParameter.addon && equipWindow.valid){
	const _Window_EquipCommand_prototype_maxCols = Window_EquipCommand.prototype.maxCols;
	Window_EquipCommand.prototype.maxCols = function() {
	    return !equipWindow.optimizeValid ? 2 : _Window_EquipCommand_prototype_maxCols.apply(this, arguments);
	};//*

	const _Window_EquipCommand_prototype_makeCommandList = Window_EquipCommand.prototype.makeCommandList;
	Window_EquipCommand.prototype.makeCommandList = function() {
	    this.addCommand(TextManager.equip2,   'equip');
	    if(equipWindow.optimizeValid){
	    	this.addCommand(TextManager.optimize, 'optimize');
	    }else if(equipWindow.subEquipValid){
	    	this.addCommand(equipWindow.subEquipCommandName, 'subEquip');
	    	this.addCommand(equipWindow.exchangeCommandName, 'exchange');
	    }
	    this.addCommand(TextManager.clear,    'clear');
	};//*
}////

	/*--------装備のサブセットに関する設定-------------*/
const _Game_Actor_prototype_initMembersC = Game_Actor.prototype.initMembers;
Game_Actor.prototype.initMembers = function() {
	_Game_Actor_prototype_initMembersC.apply(this, arguments);
    this._subEquips = [];
    this._currentEquipCategory = 0; //only for Scene_Equip
};//*

if(statusParameter.addon && equipWindow.valid && equipWindow.subEquipValid){
	const _Scene_Equip_prototype_create = Scene_Equip.prototype.create;
	Scene_Equip.prototype.create = function() {
		this._equipCategory = 0;
	    _Scene_Equip_prototype_create.apply(this, arguments);
	};//*


	const _Scene_Equip_prototype_popScene = Scene_Equip.prototype.popScene;
	Scene_Equip.prototype.popScene = function(){
		_Scene_Equip_prototype_popScene.apply(this, arguments);
		this.resetEquipCategories();
	};//*

	Scene_Equip.prototype.resetEquipCategories = function(){
		$gameParty.members().forEach( actor => actor.changeEquipCategory(0) );
	};//*

	const _Scene_Equip_prototype_createCommandWindow = Scene_Equip.prototype.createCommandWindow;
	Scene_Equip.prototype.createCommandWindow = function() {
		_Scene_Equip_prototype_createCommandWindow.apply(this, arguments);
	    this._commandWindow.setHandler('subEquip',    this.commandEquip.bind(this));
	    this._commandWindow.setHandler('exchange',    this.commandExchange.bind(this));
	};//*

	Scene_Equip.prototype.commandExchange = function(){
		SoundManager.playEquip();
		this.actor().exchangeEquipsForSub();
		this.refreshActorByEquipCategory();
		this._commandWindow.activate();
	};//*	

	Scene_Equip.prototype.changeEquipCategory = function(symbol){
		if(symbol === 'equip' && this._equipCategory !== 0){
			this._equipCategory = 0;
			this.refreshActor();
			this.refreshActorByEquipCategory();
		}else if(symbol === 'subEquip' && this._equipCategory !== 1){
			this._equipCategory = 1;
			this.refreshActor();
			this.refreshActorByEquipCategory();
		}
	};//*

	Scene_Equip.prototype.refreshActorByEquipCategory = function(){
		this._statusWindow.refresh();
	    this._slotWindow.refresh();
	    this._itemWindow.refresh();
	};//*

	const _Scene_Equip_prototype_refreshActor = Scene_Equip.prototype.refreshActor;
	Scene_Equip.prototype.refreshActor = function() {
		this.actor().synchronizeSubEquips();
	   	this.actor().changeEquipCategory(this._equipCategory);
	    _Scene_Equip_prototype_refreshActor.apply(this, arguments);
	};//*

	//各装備ウィンドウの設定
	const _Window_EquipCommand_prototype_select = Window_EquipCommand.prototype.select;
	Window_EquipCommand.prototype.select = function(index) {
		_Window_EquipCommand_prototype_select.apply(this, arguments);
		this.updateEquipCategory();
	};//*

	Window_EquipCommand.prototype.updateEquipCategory = function(){
		const symbol = this.currentSymbol();
		const scene = SceneManager._scene;
		scene.changeEquipCategory(symbol);
	};//*

	const _Window_EquipSlot_prototype_drawItem = Window_EquipSlot.prototype.drawItem;
	Window_EquipSlot.prototype.drawItem = function(index) {
		_Window_EquipSlot_prototype_drawItem.apply(this, arguments);
	    if (this._actor && equipWindow.subEquipableIcon) {
	        const rect = this.itemRectForText(index);
	        this.drawEquipableIcon(index, rect.x, rect.y);
	    }
	};//*

	Window_EquipSlot.prototype.drawEquipableIcon = function(index, x, y){
		if( this.checkEquipableParts(index) ){
			this.changeTextColor(this.systemColor());
			const posY = y;
			const icon = this.createEquipableIcon();
			const lastFontSize = this.contents.fontSize;
			this.contents.fontSize = equipWindow.fontSize * 2 / 3;
			this.drawText(icon, x, posY, equipWindow.slotNameWidth, 'right');
			this.contents.fontSize = lastFontSize;
			this.resetTextColor();
		}
	};//*

	Window_EquipSlot.prototype.checkEquipableParts = function(index){
		switch(equipWindow.subEquipableParts){
			case 'all' 		: return true; 		break;
			case 'armors' 	: return index > 1; break;
			case 'bothHands': 
			case 'eachHand' : return index < 2; break;
		}
	};//*

	Window_EquipSlot.prototype.createEquipableIcon = function(){
		return this._actor._currentEquipCategory + 1;
	};//*

	//アクター側の設定//
	const _Game_Actor_prototype_setup = Game_Actor.prototype.setup;
	Game_Actor.prototype.setup = function(actorId) {
	    _Game_Actor_prototype_setup.apply(this, arguments);
	    this.initSubEquips();
	};//*

	Game_Actor.prototype.initSubEquips = function() {
	    var slots = this.equipSlots();
	    var maxSlots = slots.length;
	    this._subEquips = [];
	    for (var i = 0; i < maxSlots; i++) {
	        this._subEquips[i] = new Game_Item();
	    }
	    this.releaseUnequippableItems(true);
	    this.refresh();
	};//*

	Game_Actor.prototype.changeEquipCategory = function(categoryId){
		if(categoryId >= 0) this._currentEquipCategory = categoryId;
	};//*

	const _Game_Actor_prototype_equips = Game_Actor.prototype.equips;
	Game_Actor.prototype.equips = function() {
		if(this._currentEquipCategory === 0 ){
			return this._equips.map(function(item) {
		        return item ? item.object() : null;
		    });
		}else{
			return this._subEquips.map(function(item) {
		        return item ? item.object() : null;
		    });
		}
	};//*

	const _Game_Actor_prototype_changeEquip = Game_Actor.prototype.changeEquip;
	Game_Actor.prototype.changeEquip = function(slotId, item) {
	    if (this.tradeItemWithParty(item, this.equips()[slotId]) &&
	            (!item || this.equipSlots()[slotId] === item.etypeId)) {
	    	const equips = this._currentEquipCategory === 0 ? this._equips : this._subEquips;
	        equips[slotId].setObject(item);
	        this.refresh();
	    }
	};//*

	const _Game_Actor_prototype_forceChangeEquip = Game_Actor.prototype.forceChangeEquip;
	Game_Actor.prototype.forceChangeEquip = function(slotId, item) {
		const equips = this._currentEquipCategory === 0 ? this._equips : this._subEquips;
	    equips[slotId].setObject(item);
	    this.releaseUnequippableItems(true);
	    this.refresh();
	};//*

	Game_Actor.prototype.exchangeEquipsForSub = function(){
		const subEquips = this._subEquips.map(equip => {return equip});
		this._subEquips = this._equips.map(equip => {return equip});
		this._equips = subEquips;
	};//*

	Game_Actor.prototype.exchangeEquipsEachHand = function(slotId){
		if(slotId < 2){
			const subEquip = this._subEquips.map(equip => {return equip})[slotId];
			const mainEquip = this._equips.map(equip => {return equip})[slotId];
			this._equips[slotId] = subEquip;
			this._subEquips[slotId] = mainEquip;
		}
	};//*

	Game_Actor.prototype.synchronizeSubEquips = function(){
		switch(equipWindow.subEquipableParts){
			case 'armors' 	:
				this.synchronizeSubEquipsWithMain(0, 1);
			break;
			case 'bothHands':
			case 'eachHand' :
				this.synchronizeSubEquipsWithMain(2, this.equipSlots().length - 1);
		}
	};//*

	Game_Actor.prototype.synchronizeSubEquipsWithMain = function(startId, endId){
		for(var i = startId; i <= endId; i++){
			this._subEquips[i] = this._equips[i];
		}
	};//*
}////

//いつでも取得できるように鍵無し
Game_Actor.prototype.mainEquips = function(){
	return this._equips.map(function(item) {
        return item.object();
    });
};//*

Game_Actor.prototype.subEquips = function(){
	return this._subEquips.map(function(item) {
        return item ? item.object() : null;
	});
};//*

	/*--------装飾品を複数装備可能にする設定------------*/
const _Game_System_prototype_initialize_D = Game_System.prototype.initialize;
Game_System.prototype.initialize = function(){
	_Game_System_prototype_initialize_D.apply(this, arguments);
	this.initializeSealingSlot();
};//*

const _Game_Actor_prototype_initialize = Game_Actor.prototype.initialize;
Game_Actor.prototype.initialize = function(actorId){
	_Game_Actor_prototype_initialize.apply(this, arguments);
	this.initializeSealingSlot();
};//*

const sealingValid = statusParameter.addon && equipWindow.valid && equipWindow.accessorySlot[1] >= 2;
if(sealingValid){
	const _Game_Actor_prototype_initEquips = Game_Actor.prototype.initEquips;
	Game_Actor.prototype.initEquips = function(equips) {
		_Game_Actor_prototype_initEquips.apply(this, arguments);
		this._equipsInitialized = true;
	};//*

	const _Game_Actor_prototype_equipSlots = Game_Actor.prototype.equipSlots;
	Game_Actor.prototype.equipSlots = function() {
	    let slots = _Game_Actor_prototype_equipSlots.apply(this, arguments);//slots = [1, 2(or 1), 3, 4, ...]

	 	if(this._equipsInitialized) {
	 		let startSlotId 	= equipWindow.accessorySlot[0] - 1;//パラメーターはデーターベース由来のID
			let typeId 			= slots[startSlotId];
			let accessoryLength = Math.max( $gameSystem.maxAccessorySlot() - this.resultSealingSlot(), 1 );
	   		const equipLength = this._equips.length;
			for(var i = 1; i < accessoryLength; i++){
				slots.splice(startSlotId, 0, typeId);
		    };

		    const extensionNum = slots.length - equipLength;
		    if(extensionNum) this.transferEquips(startSlotId, accessoryLength, extensionNum);
	 	}
	    return slots;
	};//*

	Game_Actor.prototype.transferEquips = function(startSlotId, accessoryLength, extensionNum){
		if(extensionNum > 0){
			for(var i = 1; i < accessoryLength; i++){
				this._equips.splice(startSlotId + 1, 0, new Game_Item());
		    };
		}else{
			extensionNum *= -1
			const EndSlotId = startSlotId + accessoryLength;
			this._equips.splice(EndSlotId - extensionNum, extensionNum);
		}
		this.refresh();
	};//*

	const _Game_Actor_prototype_forceChangeEquip = Game_Actor.prototype.forceChangeEquip;
	Game_Actor.prototype.forceChangeEquip = function(slotId, item) {
		this.prepareExtendedEquipSlot(slotId);
		_Game_Actor_prototype_forceChangeEquip.apply(this, arguments);
	};//*

	const _Game_Actor_prototype_changeEquip = Game_Actor.prototype.changeEquip;
	Game_Actor.prototype.changeEquip = function(slotId, item) {
		this.prepareExtendedEquipSlot(slotId);
		_Game_Actor_prototype_changeEquip.apply(this, arguments);
	};//*

	Game_Actor.prototype.prepareExtendedEquipSlot = function(slotId){
		if(!this._equips[slotId]) this._equips[slotId] = new Game_Item();
		if(this._subEquips && !this._subEquips[slotId]) this._subEquips[slotId] = new Game_Item();
	};//*

	const _Game_Actor_prototype_changeEquipById = Game_Actor.prototype.changeEquipById;
	Game_Actor.prototype.changeEquipById = function(etypeId, itemId, forSingleSlot) {
		//スロット拡張に合わせてarguments[0]を修正。IDはデータベース由来のままにすることに注意。
		//forSingleSlotはキャラメイクのように重複スロットの空き参照をさせないためのブーリアン引数
		arguments[0] = this.adjustEtypeId(arguments[0], itemId, !!forSingleSlot);

		if(arguments[0] > 0) _Game_Actor_prototype_changeEquipById.apply(this, arguments);
	};//*

	Game_Actor.prototype.adjustEtypeId = function(etypeId, itemId, forSingleSlot){
		const startAcceId = equipWindow.accessorySlot[0];

		if(etypeId < startAcceId){
			return etypeId;
		}else if(etypeId > startAcceId){
			const extendedId = this.equipSlots().findIndex(id => {return id === etypeId});
			return extendedId >= 0 ? extendedId + 1 : 0;
		}else{
			if(forSingleSlot) return etypeId;

			const numAcce = Math.max( $gameSystem.maxAccessorySlot() - this.resultSealingSlot(), 1 );
			
			if(numAcce > 0){
				let emptySlotId = 0;
				if(itemId === 0){
					for(var i = 0; i < numAcce; i++){
						let slotId = (startAcceId - 1)+(numAcce - 1) - i;
						if(this.equips()[slotId]){
							emptySlotId = slotId + 1;
							break;
						}
					}
				}else{
					for(var i = 0; i < numAcce; i++){
						let slotId = (startAcceId - 1) + i;
						if(!this.equips()[slotId]){
							emptySlotId = slotId + 1;
							break;
						}
					};
				}
				return emptySlotId || etypeId;
			}else{
				return 0;
			}
		}
	};//*
}////

//装飾品の封印状況を取得するファンクション群
Game_System.prototype.initializeSealingSlot = function(){
	this._sealingSlot = this.initialSealingSlot();
};//*
if(!sealingValid) Game_System.prototype.initializeSealingSlot = function(){};


Game_System.prototype.initialSealingSlot = function(){
	return equipWindow.accessorySlot[2];
};//*
if(!sealingValid) Game_System.prototype.initialSealingSlot = function(){return 0};


Game_System.prototype.maxAccessorySlot = function(){
	return equipWindow.accessorySlot[1];
};//*
if(!sealingValid) Game_System.prototype.maxAccessorySlot = function(){return 0};


Game_System.prototype.sealingSlot = function(){
	return this._sealingSlot >= 0 ? this._sealingSlot : this.initialSealingSlot();
};//*
if(!sealingValid) Game_System.prototype.sealingSlot = function(){return 0};


Game_System.prototype.addSealingSlot = function(value){
	if(value > 0) $gameActors._data.forEach(actor => {if(actor) actor.removeEquipsBySealing()});
	this._sealingSlot += value;
	this._sealingSlot = this._sealingSlot.clamp(0, this.maxAccessorySlot());
};//*
if(!sealingValid) Game_System.prototype.addSealingSlot = function(value){};


Game_Actor.prototype.initializeSealingSlot = function(){
	const data = this.actor();
	this._sealingSlot = Number(data.meta.sealAccessory) || 0;
};//*
if(!sealingValid) Game_Actor.prototype.initializeSealingSlot = function(){};


Game_Actor.prototype.sealingSlot = function(){
	return this._sealingSlot;
};//*
if(!sealingValid) Game_Actor.prototype.sealingSlot = function(){return 0};


Game_Actor.prototype.addSealingSlot = function(value){
	if(value > 0) this.removeEquipsBySealing();
	this._sealingSlot += value;
	this._sealingSlot = this._sealingSlot.clamp(0, $gameSystem.maxAccessorySlot());
};//*
if(!sealingValid) Game_Actor.prototype.addSealingSlot = function(value){};


Game_Actor.prototype.resultSealingSlot = function(){
	return ( this.sealingSlot() + $gameSystem.sealingSlot() ).clamp(0, $gameSystem.maxAccessorySlot());
};//*
if(!sealingValid) Game_Actor.prototype.resultSealingSlot = function(){return 0};

Game_Actor.prototype.removeEquipsBySealing = function(){
	const slotId = equipWindow.accessorySlot[0];
	const numAcce = Math.max( $gameSystem.maxAccessorySlot() - this.resultSealingSlot(), 1 );
	for(var i = 0; i < numAcce; i++){
		this.changeEquipById(slotId, 0);
	}
};//*


	/*-----------装備スロット欄の伸長設定------------*/
if(statusParameter.addon && equipWindow.valid && equipWindow.longSlotValid){
	const _Scene_Equip_prototype_createSlotWindow = Scene_Equip.prototype.createSlotWindow;
	Scene_Equip.prototype.createSlotWindow = function() {
	    var wx = this._statusWindow.width;
	    var wy = this._commandWindow.y + this._commandWindow.height;
	    var ww = Graphics.boxWidth - this._statusWindow.width;
	    var wh = Graphics.boxHeight - wy; //changed
	    this._slotWindow = new Window_EquipSlot(wx, wy, ww, wh);
	    this._slotWindow.setHelpWindow(this._helpWindow);
	    this._slotWindow.setStatusWindow(this._statusWindow);
	    this._slotWindow.setHandler('ok',       this.onSlotOk.bind(this));
	    this._slotWindow.setHandler('cancel',   this.onSlotCancel.bind(this));
	    this.addWindow(this._slotWindow);
	};//*

	const _Scene_Equip_prototype_createItemWindow = Scene_Equip.prototype.createItemWindow;
	Scene_Equip.prototype.createItemWindow = function() {
		//xとwidthはサブカテゴリーの設定がOnの時に上書きされる。
	    var wx = MV ? 0 : this._statusWindow.width;
	    var wy = MV ? this._statusWindow.y + this._statusWindow.height : this._slotWindow.y;
	    //var ww = Graphics.boxWidth;
	    const otherWidth = MV ? this._slotWindow.width : this._statusWindow.width;
	    var ww = Graphics.boxWidth - otherWidth; //changed
		var wh = MV ? Graphics.boxHeight - wy : this._slotWindow.height;
	    this._itemWindow = new Window_EquipItem(wx, wy, ww, wh);
	    this._itemWindow.setHelpWindow(this._helpWindow);
	    this._itemWindow.setStatusWindow(this._statusWindow);
	    this._itemWindow.setHandler('ok',     this.onItemOk.bind(this));
	    this._itemWindow.setHandler('cancel', this.onItemCancel.bind(this));
	    this._slotWindow.setItemWindow(this._itemWindow);
	    this.addWindow(this._itemWindow);
	    if(MZ) this._itemWindow.hide();
	};//*

	if(MZ){
		//helpWindowが画面下に来るので、その幅をstatusWindowに合わせる
		const _Scene_Equip_prototype_createStatusWindow = Scene_Equip.prototype.createStatusWindow;
		Scene_Equip.prototype.createStatusWindow = function() {
		    _Scene_Equip_prototype_createStatusWindow.apply(this, arguments);
		    this._helpWindow.width = this._statusWindow.width;
		};//*
	}
}////


/*********************************************************************************************/
/*---------------キャラクターメイクの設定---------------------------------*/
	/*~struct~CharacterMake:ja
		@param 	actor
		@type 		actor[]
		@text 		対象のアクター
		@desc 		キャラクターメイクを行うアクターを設定します。未設定の時、UIの呼び出しはできません。
		@default 	["1"]

		@param 	exchangeMembers
		@type 		boolean
		@text 		メンバー入れ替え
		@desc 		On（true）にすると、対象のアクターを切り替える際にパーティの入れ替えも行います。
		@default 	false

		@param 	fontSize
		@type 		number
		@text 		文字サイズ（px）
		@desc 		UI全体の文字サイズを設定します。ステータスと装備ウィンドウは、装備画面の設定に従います。
		@default 	28
		@min 		12
		@decimals 	0

		@param 	name
		@type 		number
		@text 		名前入力の上限数
		@desc 		キャラクターの名前変更の際、入力上限数を設定します。0の時、名前は変更できません。
		@default 	0
		@decimals 	0
		@max 		16

		@param 	identityEquip
		@type 		boolean
		@text 		素性装備の有効化
		@desc 		On（true）の時、アクターの初期装備を１つ目の素性で設定した装備にします。（装備可能なものに限ります）
		@default 	true

		@param 	identityNickname
		@type 		boolean
		@text 		二つ名との連携
		@desc 		On（true）にすると、素性決定の際に素性の名前を二つ名としてセットします。
		@default 	true

		@param 	keepExp
		@type 		boolean
		@text 		職業変更時の経験値
		@desc 		On（true）の場合、素性変更時の職業設定の際に経験値を維持します。
		@default 	false

		@param 	identity
		@type 		struct<Identity>[]
		@text 		素性
		@desc 		素性の名前、装備構成を設定します。不要な箇所は「なし」にして下さい。装備スロットに関してはreadmeを参照して下さい。

		@param 	items
		@type 		item[]
		@text 		追加アイテム
		@desc 		最初に１つだけ持てるアイテムの選択肢を設定します。未設定、あるいは「なし」のみの場合はコマンドが表示されません。

		@param 	messages
		@type 		struct<CharaMakeMessages>
		@text 		UI用メッセージ
		@desc 		UIで用いる各種メッセージを設定します。
	*/
	/*----------------------------------------------------------------------------------------------*/
	/*~struct~CharacterMake:
		@param 	actor
		@type 		actor[]
		@text 		target actors
		@desc 		Select actors for created; no ones selected, you can't call this function
		@default 	["1"]

		@param 	exchangeMembers
		@type 		boolean
		@text 		swap members
		@desc 		Swap current target in party for the next one on changing targets when this is true
		@default 	false

		@param 	fontSize
		@type 		number
		@text 		font size（px）
		@desc 		Control font size of this almost windows, excepted status and equip windows
		@default 	28
		@min 		12
		@decimals 	0

		@param 	name
		@type 		number
		@text 		max length of name
		@desc 		Control the max length; when 0, player can't change actor's name
		@default 	0
		@decimals 	0
		@max 		16

		@param 	identityEquip
		@type 		boolean
		@text 		forced equip identity's items
		@desc 		Override target's equips by the equipable items when this is true
		@default 	true

		@param 	identityNickname
		@type 		boolean
		@text 		chain nickname
		@desc 		Override actor's nickname by selected identity when this is true
		@default 	true

		@param 	keepExp
		@type 		boolean
		@text 		keep Exp
		@desc 		Keep target's Exp on changing identity when this is true
		@default 	false

		@param 	identity
		@type 		struct<Identity>[]
		@text 		identities
		@desc 		Construct identity's list; about equips, refer to readme

		@param 	items
		@type 		item[]
		@text 		bonus items
		@desc 		Construct list of bonus items; if no items, the command is hidden in the window

		@param 	messages
		@type 		struct<CharaMakeMessages>
		@text 		text list for character create
		@desc 		Construct text list for character create
	*/
	/****************************************************************************************/
		/*~struct~Identity:ja
			@param 	name
			@type 		string
			@text 		素性の名前
			@desc 		この素性の名前を設定します。

			@param 	gold
			@type 		number
			@text 		所持金
			@desc 		素性選択時の、初期の所持金を設定します。
			@decimals 	0
			@default 	0

			@param 	classId
			@type 		class
			@text 		職業
			@desc 		この素性決定時にセットする職業を設定します。
			@default 	0

			@param 	memo
			@type 		note
			@text 		素性説明
			@desc 		ヘルプウィンドウに表示する素性の説明を設定します。

			@param 	slot0
			@type 		weapon
			@text 		スロット０
			@desc 		この素性で装備するメインの武器を設定します。
			@default 	0

			@param 	slot1W
			@type 		weapon
			@text 		スロット１（武器）
			@desc 		この素性で装備するサブの武器を設定します。二刀流設定時＆盾の設定なしの場合のみ有効です。
			@default 	0

			@param 	slot1A
			@type  	armor
			@text 		スロット１（盾）
			@desc 		この素性で装備する盾を設定します。
			@default 	0

			@param 	slot2
			@type 		armor
			@text 		スロット２
			@desc 		この素性で装備する防具（対応スロット）を設定します。
			@default 	0

			@param 	slot3
			@type 		armor
			@text 		スロット３
			@desc 		この素性で装備する防具（対応スロット）を設定します。
			@default 	0

			@param 	slot4
			@type 		armor
			@text 		スロット４
			@desc 		この素性で装備する防具（対応スロット）を設定します。
			@default 	0

			@param 	slot5
			@type 		armor
			@text 		スロット５
			@desc 		この素性で装備する防具（対応スロット）を設定します。
			@default 	0

			@param 	slot6
			@type 		armor
			@text 		スロット６
			@desc 		この素性で装備する防具（対応スロット）を設定します。
			@default 	0

			@param 	slot7
			@type 		armor
			@text 		スロット７
			@desc 		この素性で装備する防具（対応スロット）を設定します。
			@default 	0
		*/
		/*----------------------------------------------------------------------------------------------*/
		/*~struct~Identity:
			@param 	name
			@type 		string
			@text 		name of identity
			@desc 		Define the name of this identity

			@param 	gold
			@type 		number
			@text 		initial gold
			@desc 		Control initial gold this identity has
			@decimals 	0
			@default 	0

			@param 	classId
			@type 		class
			@text 		class
			@desc 		Select a class linked to this identity
			@default 	0

			@param 	memo
			@type 		note
			@text 		description of this identity
			@desc 		Write the description displayed in help window

			@param 	slot0
			@type 		weapon
			@text 		slot 0
			@desc 		Select a weapon for this identity
			@default 	0

			@param 	slot1W
			@type 		weapon
			@text 		slot 1（weapon）
			@desc 		Select a weapon for this identity; only when target is dual wield and no shield
			@default 	0

			@param 	slot1A
			@type  	armor
			@text 		slot 1（shield）
			@desc 		Select a shield for this identity
			@default 	0

			@param 	slot2
			@type 		armor
			@text 		slot 2
			@desc 		Select an armor (correct in the slot) for this identity
			@default 	0

			@param 	slot3
			@type 		armor
			@text 		slot 3
			@desc 		Select an armor (correct in the slot) for this identity
			@default 	0

			@param 	slot4
			@type 		armor
			@text 		slot 4
			@desc 		Select an armor (correct in the slot) for this identity
			@default 	0

			@param 	slot5
			@type 		armor
			@text 		slot 5
			@desc 		Select an armor (correct in the slot) for this identity
			@default 	0

			@param 	slot6
			@type 		armor
			@text 		slot 6
			@desc 		Select an armor (correct in the slot) for this identity
			@default 	0

			@param 	slot7
			@type 		armor
			@text 		slot 7
			@desc 		Select an armor (correct in the slot) for this identity
			@default 	0
		*/
	/*********************************************************************************************/
		/*~struct~CharaMakeMessages:ja
			@param 	commandRace
			@type 		string
			@text 		設定名”アクター”
			@desc 		アクターを設定する項目の名称を設定します。
			@default 	キャラクター

			@param 	helpRace
			@type 		string
			@text 		ヘルプ”アクター”
			@desc 		アクターを設定する項目を選択中、ヘルプに表示する文章を設定します。
			@default 	キャラクターを変更します。

			@param 	commandName
			@type 		string
			@text 		設定名”名前”
			@desc 		名前を設定する項目の名称を設定します。
			@default 	名前

			@param 	helpName
			@type 		string
			@text 		ヘルプ”名前”
			@desc 		名前を設定する項目を選択中、ヘルプに表示する文章を設定します。
			@default 	キャラクターの名前を変更します。

			@param 	commandIdentity
			@type 		string
			@text 		設定名”素性”
			@desc 		素性を設定する項目の名称を設定します。
			@default 	素性

			@param 	helpIdentity
			@type 		string
			@text 		ヘルプ”素性”
			@desc 		素性を設定する項目を選択中、ヘルプに表示する文章を設定します。
			@default 	初期装備を含めた素性を変更します。

			@param 	commandItem
			@type 		string
			@text 		設定名”アイテム”
			@desc 		ボーナスアイテムを設定する項目の名称を設定します。
			@default 	餞別品

			@param 	choiceNoItem
			@type 		string
			@text 		選択名”アイテム無し”
			@desc 		ボーナスアイテムでアイテム無しを選択した際の表示名を設定します。
			@default 	なし

			@param 	helpItem
			@type 		string
			@text 		ヘルプ”アイテム”
			@desc 		ボーナスアイテムを設定する項目を選択中、ヘルプに表示する文章を設定します。
			@default 	餞別として１つだけアイテムを選べます。

			@param 	helpNoItem
			@type 		string
			@text 		ヘルプ”アイテム無し”
			@desc 		ボーナスアイテムを設定中、「なし」を選ぶ際にヘルプに表示する文章を設定します。
			@default 	情けなど要らぬというマゾ仕様です。							

			@param 	commandDecision
			@type 		string
			@text 		設定名”決定”
			@desc 		UIを終了する項目の名称を設定します。
			@default 	決定

			@param 	helpDecision
			@type 		string
			@text 		ヘルプ”決定”
			@desc 		UIを終了する項目を選択中、ヘルプに表示する文章を設定します。
			@default 	キャラクターメイクを完了します。

			@param 	decideDialog
			@type 		string
			@text 		終了名”ダイアログ”
			@desc 		UI終了の確認ダイアログのダイアログメッセージを設定します。
			@default 	キャラクターメイクを\n終了しますか？
						
			@param 	decideOk
			@type 		string
			@text 		終了名”OK”
			@desc 		UI終了の確認ダイアログのOKコマンドの名称を設定します。
			@default 	はい

			@param 	decideCancel
			@type 		string
			@text 		終了名”キャンセル”
			@desc 		UI終了の確認ダイアログのキャンセルコマンドの名称を設定します。
			@default 	いいえ
		*/
		/*----------------------------------------------------------------------------------------------*/
		/*~struct~CharaMakeMessages:
			@param 	commandRace
			@type 		string
			@text 		system name of ”Actor”
			@desc 		Define the name for selecting actors
			@default 	Characters

			@param 	helpRace
			@type 		string
			@text 		help of ”Actor”
			@desc 		Define help message displayed in selecting "commandRace"
			@default 	Select a character

			@param 	commandName
			@type 		string
			@text 		system name of ”Name”
			@desc 		Define the name for setting name
			@default 	Name

			@param 	helpName
			@type 		string
			@text 		help of ”Name”
			@desc 		Define help message displayed in selecting "commandName"
			@default 	Change the character's name

			@param 	commandIdentity
			@type 		string
			@text 		system name of "Identity"
			@desc 		Define the name for selecting identities
			@default 	Identity

			@param 	helpIdentity
			@type 		string
			@text 		help of "Identity"
			@desc 		Define help message displayed in selecting "commandIdentity"
			@default 	Select the character's identity and equips

			@param 	commandItem
			@type 		string
			@text 		system name of "Bonus Item"
			@desc 		Define the name for selecting bonus items
			@default 	Bonus Item

			@param 	choiceNoItem
			@type 		string
			@text 		system name of no choice in "Bonus Item"
			@desc 		Define the name for displaying no items
			@default 	nothing

			@param 	helpItem
			@type 		string
			@text 		help of "Bonus Item"
			@desc 		Define help message displayed in selecting "commandItem"
			@default 	Choose one item as a gift

			@param 	helpNoItem
			@type 		string
			@text 		help of nothing in "Bonus Item" 
			@desc 		Define help message displayed in selecting "commandItem" and setting 'nothing'
			@default 	No regret ?						

			@param 	commandDecision
			@type 		string
			@text 		system name of "decision"
			@desc 		Define the name for selecting decision
			@default 	Decision

			@param 	helpDecision
			@type 		string
			@text 		help of "decision"
			@desc 		Define help message displayed in selecting "commandDecision"
			@default 	Finish creating Character

			@param 	decideDialog
			@type 		string
			@text 		system message for finish
			@desc 		Define system message displayed in decision dialog
			@default 	Complete the creation?
						
			@param 	decideOk
			@type 		string
			@text 		system message for finish "yes"
			@desc 		Define system message displayed as "yes" in decision dialog
			@default 	Yes

			@param 	decideCancel
			@type 		string
			@text 		system message for finish "no"
			@desc 		Define system message displayed as "no" in decision dialog
			@default 	No
		*/


		const parseCharacterMake = s => JSON.parse(s, (key, value)=>{
			switch(key){
					case 'actor' 			: return value;
					case 'exchangeMembers' 	: return value;
					case 'fontSize' 		: return Number.parseFloat(value);
					case 'name' 			: return Number.parseFloat(value);
					case 'identityEquip' 	: return value;
					case 'identityNickname' : return value;
					case 'keepExp' 			: return value;
					case 'identity' 		: return value;
					case 'gold' 			: return Number.parseFloat(value);
					case 'classId' 			: return Number.parseFload(value);
					case 'memo' 			: return value;
					case 'slot0' 	 		: return Number.parseFloat(value);
					case 'slot1W' 	 		: return Number.parseFloat(value);
					case 'slot1A' 			: return Number.parseFloat(value);
					case 'slot2' 			: return Number.parseFloat(value);
					case 'slot3' 			: return Number.parseFloat(value);
					case 'slot4' 	 		: return Number.parseFloat(value);
					case 'slot5' 	 		: return Number.parseFloat(value);
					case 'slot6' 	 		: return Number.parseFloat(value);
					case 'slot7' 			: return Number.parseFloat(value);
					case 'items' 		 	: return value;
					case 'messages' 		: return value;

					case 'commandRace' 		: return value;
					case 'heplRace' 		: return value;
					case 'commandName' 		: return value;
					case 'helpName' 		: return value;
					case 'commandIdentity' 	: return value;
					case 'helpIdentity' 	: return value;
					case 'commandItem' 		: return value;
					case 'choiceNoItem' 	: return value;
					case 'helpItem' 		: return value;
					case 'helpNoItem' 		: return value;
					case 'commandDecision' 	: return value;
					case 'helpDecision' 	: return value;
					case 'decideDialog' 	: return value;
					case 'decideOk' 		: return value;
					case 'decideCancel' 	: return value;
					default 				: return value;
			}
		});//*
	
		let characterMake = params.characterMake;
		let consolerNameCharacterMake = 'characterMake:';
		if(characterMake){
				characterMake = parseCharacterMake(characterMake);
				characterMake.actor = parseJSONwithLeakcheck(characterMake.actor, consolerNameCharacterMake + 'actor: ');
				characterMake.actor = characterMake.actor.map(a => Number(a));
				characterMake.identity = parseJSONwithLeakcheck(characterMake.identity, consolerNameCharacterMake + 'identity: ');
				characterMake.identity = characterMake.identity.map(s => JSON.parse(s));
				characterMake.identity = characterMake.identity.map(e => stringToNumber(e));
				characterMake.items = characterMake.items ? JSON.parse(characterMake.items) : [];
				characterMake.items = characterMake.items.map(e =>e = Number(e));
				characterMake.messages = parseJSONwithLeakcheck(characterMake.messages, consolerNameCharacterMake + 'messages: ');
				characterMake = stringToBoolean(characterMake);
		}else{
				characterMake = makeNotValid();
				undefinedStructs.push(consolerNameCharacterMake);
				consolerNameCharacterMake += makeInvalidTerm();
		};
					
		consoler(consolerNameCharacterMake, characterMake);

		let initGold = -1;

		/*------------------------------------------------------------------------------*/

Scene_Map.prototype.callCharacterMake = function(){
	SceneManager.push(Scene_CharacterMake);
	$gameTemp.clearDestination();
	this._mapNameWindow.hide();
	this._waitCount = 2;		
};//*
if(!characterMake.actor || characterMake.actor.length <= 0) Scene_Map.prototype.callCharacterMake = function(){};

class Scene_CharacterMake extends Scene_Equip{
		constructor(){
			super();
		};//*

		create (){
			this.createWindowLayer();
			this.createFaceWindow();
			this.createCommandWindow(); //not equipCommand !!
			this.createItemWindow(); 	//not equipItems !! need declare
			this.createChoiceWindow();

			this.createHelpWindow();
				this._helpWindow.hide();
		 	this.createStatusWindow();
		    this.createGoldWindow();
		    this.createSlotWindow();
		    this.createSubHelpWindow();
		    this.createExecuteDialog();
		    this.createExecuteWindow();

		    this.setIdentity();
		    this.refreshActor();
		};//*

		createFaceWindow (){
			this._faceWindow = new Window_CharaMakeFace();
			this._faceWindow.adjustSize();
			this.addWindow(this._faceWindow);
		};//*

		createCommandWindow (){
			this._commandWindow = new Window_CharaMakeCommand(this._faceWindow.width, 0);
			this._commandWindow.height = this._faceWindow.height;

			this._commandWindow.setHandler('cancel', this.commandCancel.bind(this));
			this._commandWindow.setHandler('race', this.commandChoices.bind(this));
			this._commandWindow.setHandler('name', this.commandName.bind(this));
			this._commandWindow.setHandler('identity', this.commandChoices.bind(this));
			this._commandWindow.setHandler('items', this.commandChoices.bind(this));
			this._commandWindow.setHandler('decision', this.onExecuteOk.bind(this));
			this.addWindow(this._commandWindow);
				
			this._commandWindow.setActor();
			this._commandWindow._item = 0;
			this._commandWindow.select(0);
			this._faceWindow.setCommandWindow(this._commandWindow);
		};//*

		//for MZ
		commandWindowRect () {
			let rect = super.commandWindowRect();
				rect.height = this._faceWindow.height;
			return rect
		};//*

		createItemWindow (){
			const x = this._commandWindow.x + this._commandWindow.width;
			const y = 0;
			this._itemWindow = new Window_CharaMakeItem(x, y);
			this._itemWindow.width = Graphics.boxWidth - this._itemWindow.x;
			this._itemWindow.height = this._commandWindow.height;
			this._itemWindow.setCommandWindow(this._commandWindow);
				//this._itemWindow.deselect();
				//this._itemWindow.deactivate();
			this.addWindow(this._itemWindow);
		};//*

		createChoiceWindow (){
			this._choiceWindow = new Window_CharaMakeChoice();
			this._choiceWindow.x = 0;
			this._choiceWindow.y = this._commandWindow.y;
			this._choiceWindow.height = this._commandWindow.height;
			this._choiceWindow.hide();
			this._choiceWindow._gold = 0;

			this._choiceWindow.setHandler('ok', this.onChoiceOk.bind(this));
			this._choiceWindow.setHandler('cancel', this.onCancelOk.bind(this));
			this.addWindow(this._choiceWindow);
		
			this._choiceWindow.setCommandWindow(this._commandWindow);
			this._choiceWindow.setFaceWindow(this._faceWindow);
		};//*

		createStatusWindow () {
			this._statusWindow = new Window_CharaMakeEquipStatus(0, this._commandWindow.height);
		    //this._statusWindow.hide();
		    const maxHeight = Graphics.boxHeight - this._statusWindow.y - this._statusWindow.fittingHeight(2);
		    this._statusWindow.height = Math.min(this._statusWindow.height, maxHeight);
		    this.addWindow(this._statusWindow);
		    if(this._choiceWindow){
			    	this._choiceWindow.setStatusWindow(this._statusWindow);
		    }
		};//*

		createGoldWindow (){
			this._goldWindow = new Window_Gold();
			this._goldWindow.width = Graphics.boxWidth - this._statusWindow.width;
			this._goldWindow.x = Graphics.boxWidth - this._goldWindow.width;
			this._goldWindow.y = this._itemWindow.height;
			this.addWindow(this._goldWindow);
			
			this._choiceWindow.setGoldWindow(this._goldWindow);			
		};//*

		//for MZ
		goldWindowRect (){
			return Scene_Shop.prototype.goldWindowRect.call(this);
		};//*

		createSlotWindow () {
			Scene_Equip.prototype.createSlotWindow.call(this);
		    this._slotWindow.x = this._statusWindow.width;
		    this._slotWindow.y = this._goldWindow.y + this._goldWindow.height;
		    this._slotWindow.height = Graphics.boxHeight - this._slotWindow.y;
		    this.addWindow(this._slotWindow);
		    
		    this._choiceWindow.setSlotWindow(this._slotWindow);
		};//*

		createSubHelpWindow () {
		    this._subHelpWindow = new Window_Help();
		    this._subHelpWindow.y = this._statusWindow.y + this._statusWindow.height;
		    this._subHelpWindow.width = Graphics.boxWidth - this._slotWindow.width;
		    this._subHelpWindow.height = Graphics.boxHeight - this._subHelpWindow.y;
		    this.addWindow(this._subHelpWindow);
		    if(this._commandWindow){
		    		this._commandWindow.setHelpWindow(this._subHelpWindow);
		    		this._commandWindow.updateHelp();
		    }
		    if(this._choiceWindow){
				   	this._choiceWindow.setHelpWindow(this._subHelpWindow);
		    }
		};//*

		createExecuteDialog (){
			this._executeDialog = new Window_ExecuteCharaMakeDialog();
			this._executeDialog.hide();
			this.addWindow(this._executeDialog);
		};//*

		createExecuteWindow (){
			this._executeWindow = new Window_ExecuteCharaMake();
			this._executeWindow.x = this._executeDialog.x +(this._executeDialog.width - this._executeWindow.width)/2;
			this._executeWindow.y = this._executeDialog.y + this._executeDialog.height;

			this._executeWindow.hide();
			this._executeWindow.deactivate();
			this._executeWindow.setHandler('ok', this.onCharaMakeOk.bind(this));
			this._executeWindow.setHandler('cancel', this.onCharaMakeCancel.bind(this));
			this.addWindow(this._executeWindow);
		};//*

		setIdentity (){
			const actorsId = characterMake.actor;
			const actors = actorsId.map(id => {return $gameActors.actor(id)});
			actors.forEach(actor => {
				if(!actor.identity){
						actor.identity = characterMake.identity[0];
						this.changeClass (actor.identity, actor);
						this.changeEquip(actor.identity, actor);
						this.changeNickname(actor.identity, actor);
						
				}
			});
		};//*

		changeEquip (identity, actor){
			if(!characterMake.identityEquip){return};
			this._choiceWindow.changeEquip(identity, actor);
			/*
			let keyGold = Object.keys(identity).indexOf('gold');
			let classId = Object.keys(identity).indexOf('classId');
			let exception = [];
				exception.push(keyGold, classId);
			let	equips = Object.values(identity).filter((e, index)=> {return !exception.includes(index)});
				equips = equips.filter(e => {return typeof e === 'number'});
				equips[1] = equips[2] ? equips[2] : equips[1];
				equips = equips.filter((e, index) => {return index !== 2});
		
			let maxSlotId = actor.equipSlots().reduce((a,b)=>Math.max(a,b));
			let length = Math.min(maxSlotId, equips.length - 1);
			let item;
			let currentEquip = null;
			for(var i =0; i < length; i++){
				currentEquip = actor.equips()[i];
				if(actor.equipSlots()[i] === 1){
						item = $dataWeapons[equips[i]];	
				}else{
						item = $dataArmors[equips[i]];
				};
				if(item){
					$gameParty.gainItem(item, 1 ,false);
					//actor.forceChangeEquip(i, item);
					actor.changeEquipById(i+1, item.id);
				}else if(!!currentEquip){
						actor.discardEquip(currentEquip);
						currentEquip = null;
				}
			}
			*/
		};//*

		changeNickname (identity, actor){
			if(!characterMake.identityNickname){return};

			actor.setNickname(identity.name);
		};//*

		refreshActor () {
			const actor = currentCharacterMaking || $gameActors.actor(characterMake.actor[0]);
		    this._statusWindow.setActor(actor);
		    this._slotWindow.setActor(actor);
		    this._itemWindow.refresh();
		};//*

		changeClass (identity, actor){
			const classId = Number(identity.classId);
			const keep = characterMake.keepExp;
			if(classId){
					actor.changeClass(classId, keep);
			}
		};//*

		/*-------------コマンド処理の設定---------------------*/
		commandCancel (){
			this._commandWindow.activate();
		};//*

		commandName (){
			this._actor = this._commandWindow._actor;
			this._actorId = this._actor._actorId;
			this._maxLength = characterMake.name;
			this._itemWindow.deactivate();
			this._commandWindow.deactivate();
						
			this.createNameEditWindow();
			this.createNameInputWindow();
			Scene_Name.prototype.start.call(this);
		};//*

		createNameEditWindow (){
			Scene_Name.prototype.createEditWindow.call(this);
		};//*

		//for MZ
		editWindowRect (){
			return Scene_Name.prototype.editWindowRect.call(this);
		};//*

		createNameInputWindow (){
			Scene_Name.prototype.createInputWindow.call(this);
		};//*

		//for MZ
		inputWindowRect (){
			return Scene_Name.prototype.inputWindowRect.call(this);
		};//*

		commandChoices (){
			const symbol = this._commandWindow.currentSymbol();
			let list;
			switch(symbol){
				case 'race' 	: 
						list = characterMake.actor; 
						this._commandWindow._previousActor = this._commandWindow._actor;
				break;

				case 'identity' : list = characterMake.identity; break;
				case 'items' 	: list = characterMake.items; break;
			}
			this._choiceWindow.refresh(symbol, list);
			this._choiceWindow.show();
			this._choiceWindow.activate();
			this._choiceWindow.select(0);
			this._itemWindow.deactivate();
		};//*

		onChoiceOk (){
			this._choiceWindow.determinChoice(this._commandWindow.currentSymbol());
			this._itemWindow.refresh();
			this._slotWindow.refresh();
			this._statusWindow.refresh();
			this.onCancelOk();
		};//*

		onCancelOk (){
			this._choiceWindow.deactivate();
			this._choiceWindow.hide();
			if(this._choiceWindow._goldWindow){
					$gameParty.loseGold($gameParty.gold());
					$gameParty.gainGold(this._choiceWindow._gold);
					this._choiceWindow._goldWindow.refresh();
			};
			if(this._choiceWindow._statusWindow){
					this._choiceWindow._statusWindow.setTempActor(null);
					this._choiceWindow._slotWindow.setActor(this._commandWindow._actor);
			};

			if(this._commandWindow.currentSymbol() === 'race'){
					this._commandWindow._actor = this._commandWindow._previousActor;
					this._faceWindow.refresh();
			}
			this._commandWindow.activate();
			this._itemWindow.activate();
		};//*

		onExecuteOk (){
			this._executeWindow.show();
			this._executeWindow.select(0);
			this._executeDialog.show();
			this._executeDialog.refresh();
			this._executeWindow.activate();
						
			this._commandWindow.deactivate();
			this._itemWindow.deactivate();
		};//*
							
		onCharaMakeOk (){
			this.popScene();
		};//*

		popScene (){
			this._commandWindow.discardEquipItems();
			//currentCharacterMaking = null;

			SceneManager.pop();
		};//*

		onCharaMakeCancel (){
			this._executeWindow.hide();
			this._executeDialog.hide();
			this._executeWindow.deactivate();
			this._executeDialog.deactivate();

			this._commandWindow.activate();
			this._itemWindow.activate();
		};//*

		//for nameInput command
		onInputOk () {
			this._actor.setName(this._editWindow.name());
			this._windowLayer.removeChild(this._editWindow);
			this._windowLayer.removeChild(this._inputWindow);
			this._commandWindow.activate();
			this._itemWindow.activate();
			this._itemWindow.refresh();
			this._statusWindow.refresh();
			this._slotWindow.refresh();
		};//*

};//*Scene_CharacterMake

	window[Scene_CharacterMake.name] = Scene_CharacterMake;

	//------------フェイスウィンドウの定義----------------------//
class Window_CharaMakeFace extends Window_Base{
		constructor(){
			const width = Graphics.boxWidth;
			const height = Graphics.boxHeight;
			const x = 0;
			const y = 0;
			super(x, y, width, height);
		};//*

		setCommandWindow (commandWindow){
			if(commandWindow){
					this._commandWindow = commandWindow;
					this.setFace();
			}
		};//*

		setFace (){
			if(this._commandWindow){
					const actor = this._commandWindow._actor;
					const width = Window_Base._faceWidth;
					const height = Window_Base._faceHeight;
					//consoler('actor faceImageName:', actor._faceName);
					if(actor){
						this.drawActorFace(actor, 0, 0, width, height);		
					}
			}	
		};//*

		refresh (){
			this.contents.clear();
			this.setFace();
		};//*

		adjustSize (){
			const faceWidth = MV ? Window_Base._faceWidth : ImageManager.faceWidth;
			const faceHeight = MV ? Window_Base._faceHeight : ImageManager.faceHeight;
			this.width = faceWidth + this.standardPadding() * 2;
			this.height = faceHeight + this.standardPadding() * 2;
		};//*

};//*Window_CharaMakeFace

	window[Window_CharaMakeFace.name] = Window_CharaMakeFace;

	//-----------コマンドウィンドウの定義---------------//
class Window_CharaMakeCommand extends Window_MenuCommand{
		constructor(x,y){
			super(x,y);
		};//*

		setHelpWindow (helpWindow){
			if(helpWindow){
					this._helpWindow = helpWindow;
			}
		};//*

		standardFontSize (){
			return characterMake.fontSize;
		};//*

		makeCommandList (){
			this.addActorCommand();
			this.addNameCommand();
			this.addIdentityCommand();
			this.addBonusItemCommand();
			this.addDecisionCommand();
		};//*

		addActorCommand (){
			if(characterMake.actor.length > 1){
					const name = characterMake.messages.commandRace;
					this.addCommand(name, 'race');
			}
		};//*

		addNameCommand (){
			let enabled = characterMake.name > 0;
			const name = characterMake.messages.commandName;
			this.addCommand(name, 'name', enabled);	
		};//*

		addIdentityCommand (){
			const name = characterMake.messages.commandIdentity;
			this.addCommand(name, 'identity');
		};//*

		addBonusItemCommand (){
			if(characterMake.items.length !== 0 &&
				characterMake.items.some(e => {return e !== 0}) ){
					const name = characterMake.messages.commandItem;
					this.addCommand(name, 'items');	
			}
		};//*

		addDecisionCommand (){
			const name = characterMake.messages.commandDecision;
			this.addCommand(name, 'decision');
		};//*

		setActor (actor){
			this._actor = currentCharacterMaking || actor || $gameActors.actor(characterMake.actor[0]);
			currentCharacterMaking = !currentCharacterMaking ? actor : currentCharacterMaking;
			if(!this._identity){
					this._identity = 0;	
			}
		};//*

		discardEquipItems (){
			const num = $gameParty.maxItems() * -1;
			const weapons = $gameParty.weapons();
			weapons.map((w)=>$gameParty.gainItem(w, num, false));
			const armors = $gameParty.armors();
			armors.map((a)=>$gameParty.gainItem(a, num, false));
		};//*

		updateHelp (){
			let text;
			let enabled = this.currentData().enabled;
			switch(this.currentSymbol()){
				case 'race' :
						text = characterMake.messages.helpRace;
				break;

				case 'name' :
						if(enabled){
							text = characterMake.messages.helpName;
						}else{
							const support = $gameSystem.isJapanese() ? 'キャラクターの名前は固定です。' : 'unable to change Name';
							text = characterMake.messages.helpName || support;
						};					
				break;

				case 'identity' :
						text = characterMake.messages.helpIdentity;
				break;

				case 'items' :
						text = characterMake.messages.helpItem;
				break;

				case 'decision' :
						text = characterMake.messages.helpDecision;
				break;

				default : text = '';
			}
			if(this._helpWindow){
					this._helpWindow.setText(text);
			}
		};//*

};//*Window_CharaMakeCommand

	window[Window_CharaMakeCommand.name] = Window_CharaMakeCommand;


	//------------アイテムウィンドウの定義----------------------------//
class Window_CharaMakeItem extends Window_Command{
		constructor(x,y){
				super(x,y);	
		};//*

		standardFontSize (){
			return characterMake.fontSize;
		};//*

		maxItems (){
			return this._list ? super.maxItems() : 5;
		};//*

		setCommandWindow (commandWindow){
			if(commandWindow){
					this._commandWindow = commandWindow;							
			}
		};//*

		makeCommandList (){
			if(this._commandWindow){
					for(var i = 0; i < this._commandWindow._list.length; i++){
						let symbol = this._commandWindow._list[i].symbol;
						switch(symbol){
							case 'race' 	: this.addActorCommand(symbol); 	break;
							case 'name' 	: this.addNameCommand(symbol); 		break;
							case 'identity' : this.addIdentityCommand(symbol); 	break;
							case 'items' 	: this.addBonusItemCommand(symbol); break;
							case 'decision' : this.addDecisionCommand(symbol);	break;
						}
					};
			};
		};//*

		addActorCommand (symbol){
			if(characterMake.actor.length > 1){
					if(this._commandWindow){
							const id = this._commandWindow._actor.actorId();
							this.addCommand($dataActors[id].name, symbol);	
					}else{
							this.addCommand('', symbol);
					};
			}
		};//*

		addNameCommand (symbol){
			if(this._commandWindow){
					const name = this._commandWindow._actor.name();
					this.addCommand(name, symbol);	
			}
		};//*

		addIdentityCommand (symbol){
			if(this._commandWindow){
					const actor = this._commandWindow._actor;
					const identity = actor.identity || characterMake.identity[this._commandWindow._identity];
					this.addCommand(identity.name, symbol);
			}
		};//*

		addBonusItemCommand (symbol){
			if(this._commandWindow && characterMake.items.length > 0 &&
				characterMake.items.some(e => {return e !==0}) ){
					const id = this._commandWindow._item;
					let name;
					if(id === 0){
							name = characterMake.messages.choiceNoItem;
					}else{
							name = $dataItems[id].name;
					}
					this.addCommand(name, symbol);
			};
		};//*

		addDecisionCommand (symbol){
			this.addCommand('', symbol);
		};//*

};//*Window_CharaMakeItem

	window[Window_CharaMakeItem.name] = Window_CharaMakeItem;


	//---------------選択肢ウィンドウの定義-----------------------------//
class Window_CharaMakeChoice extends Window_HorzCommand{
		constructor(x, y){
			super(x, y);
		};//*

		standardFontSize (){
			return characterMake.fontSize;
		};//*

		setFaceWindow (faceWindow){
			if(faceWindow){
					this._faceWindow = faceWindow;
			}
		};//*

		setCommandWindow (commandWindow){
			if(commandWindow){
					this._commandWindow = commandWindow;
			}
		};//*

		setStatusWindow (statusWindow){
			if(statusWindow){
					this._statusWindow = statusWindow;
			}
		};//*

		setHelpWindow (helpWindow){
			if(helpWindow){
					this._helpWindow = helpWindow;
			}
		};//*

		setSlotWindow (slotWindow){
			if(slotWindow){
					this._slotWindow = slotWindow;
			}
		};//*

		setGoldWindow (goldWindow){
			if(goldWindow){
					this._goldWindow = goldWindow;
			}
		};//*

		refresh (symbol, list) {
			this.clearCommandList();
		    this.makeCommandList(symbol, list);
		    this.createContents();
		    Window_Selectable.prototype.refresh.call(this);
		};//*

		makeCommandList (symbol, list){
			switch(symbol){
				case 'race' :
						this.x = this._commandWindow.x;
						this.width = Graphics.boxWidth - this.x;
						const actors = list.map((a)=> {return $gameActors.actor(a).name()});
						for(var i = 0; i < actors.length; i++){
							this.addCommand(actors[i], actors[i]);
						}
				break;

				case 'identity' :
						this.x = 0;
						this.width = Graphics.boxWidth - this.x;
						const names = list.map((e) => {return e.name});
						for(var i = 0; i < names.length; i++){
							this.addCommand(names[i], names[i]);
						}
				break;

				case 'items' :
						this.x = 0;
						this.width = Graphics.boxWidth - this.x;
						const textNone = characterMake.messages.choiceNoItem;
						this.addCommand(textNone, textNone);
						const items = list.map((e) => {return $dataItems[e].name});
						for(var i = 0; i < items.length; i++){
								this.addCommand(items[i], items[i]);
						}
				break;
			}
		};//*

		windowWidth () {
		    return Graphics.boxWidth;
		};//*

		numVisibleRows () {
			const numItems = this._list ? this._list.length : 0;
			const cols = this.maxCols();
			return Math.ceil(numItems / cols);
		};//*

		maxCols (){
			return 6;
		};//*

		determinChoice (category){
			switch(category){
				case 'race' 	: this.changeActor(); 		break;
				case 'identity' : this.changeIdentity(); 	break;
				case 'items' 	: this.changeBonusItem(); 	break;
			}
		};//*

		changeActor (){
			const symbol = this.currentSymbol();
			const id = characterMake.actor.findIndex((id)=>$gameActors.actor(id).name()===symbol);
			const actor = $gameActors.actor(characterMake.actor[id]);
			currentCharacterMaking = actor;
			if(this._commandWindow){
					this.exchangeMembers(actor);
					this._commandWindow._previousActor = actor;
					this._commandWindow._actor = actor;
					this._faceWindow.refresh();
			}
			if(this._statusWindow){
					this._statusWindow.setActor(actor);
			}
			if(this._slotWindow){
					this._slotWindow.setActor(actor);
			}
		};//*

		exchangeMembers (actor){
			if(characterMake.exchangeMembers){
					const previousId = this._commandWindow._previousActor.actorId();
					const previousIndex = $gameParty._actors.findIndex(id => id === previousId);
					const addId = actor.actorId();
					$gameParty.addActor(addId);
					const addIndex = $gameParty._actors.findIndex(id => id === addId);
					$gameParty.swapOrder(previousIndex, addIndex);
					$gameParty.removeActor(previousId);
			}
		};//*

		changeIdentity (){
			const symbol = this.currentSymbol();
			const id = characterMake.identity.findIndex((element)=>element.name === symbol);
			const identity = characterMake.identity[id];
			if(this._goldWindow){
					this._gold = $gameParty.gold();
			}

			if(this._commandWindow){
					this._commandWindow._identity = id;	
					this.setIdentityforActor(identity);
			};
			this.changeClass(identity, this._commandWindow._actor);
			this.changeEquip(identity, this._commandWindow._actor);
			this.changeNickname(identity, this._commandWindow._actor);

			if(this._statusWindow){
					this._statusWindow.setTempActor(null);
					this._slotWindow.setActor(this._commandWindow._actor);
			}
		};//*

		setIdentityforActor (identity){
			const actor = this._commandWindow._actor;
			actor.identity = identity;
		};//*

		changeEquip (identity, actor){
			let keyGold = Object.keys(identity).indexOf('gold');
			let classId = Object.keys(identity).indexOf('classId');
			let exception = [];
				exception.push(keyGold, classId);
			let	equips = Object.values(identity).filter((e, index)=> {return !exception.contains(index)});
				equips = equips.filter(e => {return typeof e === 'number'});
				equips[1] = equips[2] ? equips[2] : equips[1];
				equips = equips.filter((e, index) => {return index !== 2});

			//let maxSlotId = actor.equipSlots().reduce((a,b)=>Math.max(a,b));
			let maxSlotId = actor.equipSlots().length;
			let length = Math.min(maxSlotId, equips.length);//最大で８枠

			for(var j = 0; j < length; j++){
				let currentEquip = actor.equips()[j];
				if(!!currentEquip){
					actor.discardEquip(currentEquip);
				}
			}
			
			let item = null;
			for(var i =0; i < length; i++){
				if(actor.equipSlots()[i] === 1){
						item = $dataWeapons[equips[i]];
				}else{
						item = $dataArmors[equips[i]];
				}
				if(item){
					$gameParty.gainItem(item, 1 ,false);
					actor.changeEquipById(i+1, item.id, true);
					item = null;
				}
			}
		};//*

		changeNickname (identity, actor){
			if(characterMake.identityNickname){
					actor.setNickname(identity.name);
			}
		};//*

		changeClass (identity, actor){
			const classId = Number(identity.classId);
			const keep = characterMake.keepExp;
			if(classId){
					actor.changeClass(classId, keep);
			}
		};//*

		changeBonusItem (){
			const symbol = this.currentSymbol();
			const id = characterMake.items.findIndex((num)=>$dataItems[num].name === symbol);
			if(this._commandWindow._item !==0 ){
					$gameParty.gainItem($dataItems[this._commandWindow._item], -1);
			}
			if(id >= 0){
					$gameParty.gainItem($dataItems[characterMake.items[id]], 1);
			}

			this._commandWindow._item =  id>=0 ? characterMake.items[id] : 0;	
		};//*

		updateHelp (){
			Window_Selectable.prototype.updateHelp.call(this);

			if(this._commandWindow.currentSymbol() === 'race' && this.currentSymbol()){
					this.helpRace();

			}else if(this._commandWindow.currentSymbol() === 'identity' && this.currentSymbol()){
					this.helpIdentity();

			}else if(this._commandWindow.currentSymbol() === 'items' && this.currentSymbol()){
					this.helpItems();
			};
		};//*

		helpRace (){
			const symbol = this.currentSymbol();
			const id = characterMake.actor.findIndex((element)=>$gameActors.actor(element).name() === symbol);
			const actor = $gameActors.actor(characterMake.actor[id]);

			if(this._faceWindow){
					this._commandWindow._actor = actor;
					this._faceWindow.refresh();
			}
			if(this._helpWindow){
					this._helpWindow.setText(actor.profile());
			}
			if(this._statusWindow){
					const dummyActor =JsonEx.makeDeepCopy(actor);
					this._statusWindow.setTempActor(dummyActor);
					this._slotWindow.setActor(dummyActor);
			}
 		};//*

		helpIdentity (){
			const symbol = this.currentSymbol();
			const id = characterMake.identity.findIndex((element)=>element.name === symbol);
			const identity = characterMake.identity[id];

			if(this._goldWindow){
					$gameParty.loseGold($gameParty.gold());
					const amount = identity.gold;
					$gameParty.gainGold(amount);
					this._goldWindow.refresh();
			}

			if(this._statusWindow && this._slotWindow && this._commandWindow._actor){
					const actor = JsonEx.makeDeepCopy(this._commandWindow._actor);
					this.changeClass(identity, actor);
					this.changeEquip(identity, actor);
					this._statusWindow.setTempActor(actor);	
					this._slotWindow.setActor(actor);
			}

			if(this._helpWindow && identity.memo){
					this._helpWindow.setText(identity.memo);
			}
		};//*

		helpItems (){
			if(this._helpWindow){
					const symbol = this.currentSymbol();
					const id = characterMake.items.findIndex((num)=>$dataItems[num].name === symbol);
					let text;
					if(id < 0 ){
							text = characterMake.messages.helpNoItem;
					}
					if(id >= 0){
							text = $dataItems[characterMake.items[id]].description;
					}
					this._helpWindow.setText(text);
			}
		};//*

};//*Window_CharaMakeChoice

	window[Window_CharaMakeChoice.name] = Window_CharaMakeChoice;

class Window_CharaMakeEquipStatus extends Window_EquipStatus {
		constructor (x, y){
			super(x, y);
		};//*

		drawActorName (){};//*

		drawActorFace (){};//*

		adjustOriginY (originY){
			return originY;
		};//*

};//*

	//------------実行ダイアログの定義---------------------//
class Window_ExecuteCharaMake extends Window_ExecuteCommand{
		constructor(){
			super();
		};//*
						
		makeCommandList (){
			this.addCommand(characterMake.messages.decideOk, 'ok');
			this.addCommand(characterMake.messages.decideCancel, 'cancel');
		};//*

		drawItem (index) {
			var rect = this.itemRectForText(index);
		    var align = this.itemTextAlign();
		    this.resetTextColor();
		    this.changePaintOpacity(this.isCommandEnabled(index));
		    this.drawText(this.commandName(index), rect.x, rect.y, rect.width, align);
		};
};//*Window_ExecuteCharaMake

	window[Window_ExecuteCharaMake.name] = Window_ExecuteCharaMake;


class Window_ExecuteCharaMakeDialog extends Window_ExecuteDialog{
		constructor(){
			super();
		};//*

		refresh (){
			super.refresh();
			let text = characterMake.messages.decideDialog;
			let realText = text.split('\\n');
			for(var i = 0; i < realText.length; i++){
				let y = (i + 1) * this.lineHeight();
				this.drawText(realText[i], 0, y, this.width, 'center');	
			}
		};//*

		standardFontSize (){
			return $gameFastTravel ? $gameFastTravel.fontSize() : 21;
		};//*

};//*Window_ExecuteFastTravelDialog

	window[Window_ExecuteCharaMakeDialog.name] = Window_ExecuteCharaMakeDialog;


//----アクター能力値の拡張に関する設定　end---------------------------------------//


/********************************************************************************************/
/*-------------------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------------------*/
/********************************************************************************************/


/*--------structing HUD---------------------------------------------
					HUDに関する設定
					 	 	 	 ___
				| 	|	|	| 	|   \
				|---|	|	| 	| 	 |
				|	|  	|___| 	|___/
	-----------------------------------------------------*/


/********************************************************************************************/
/*-------------------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------------------*/
/********************************************************************************************/

		/*~struct~WindowHUD:ja
			@param 	configValid
			@type 		boolean
			@text 		ステータスHUD有効化
			@desc 		On（true）の時、ステータスHUDを表示します。
			@default 	true

			@param 	HUDinit
			@type 		boolean
			@text 		HUD表示の初期値
			@desc 		ゲーム起動時の、HUD表示に関する初期値を設定します。
			@default 	true

			@param 	configName
			@type 		string
			@text 		コンフィグ名
			@desc 		コンフィグで表示するHUD項目の名称を設定します。
			@default 	HUDの表示

			@param 	members
			@type 		number
			@text 		ウィンドウ最大人数
			@desc 		HUDを表示する人数を設定します。１つ目は必ずリーダーのHUDとなります。
			@default 	4
			@min 		1
			@decimals 	0

			@param 	rcType
			@type 		select
			@text 		ゲージ配置タイプ
			@desc 		ゲージの並べ方を設定します。
			@default 	row
				@option 	縦型
				@value 	row

				@option 	横型
				@value 	col

			@param 	hpValid
			@type 		boolean
			@text 		HPゲージ表示
			@desc 		On（true）の時、HUDウィンドウにHPゲージを表示します。
			@default 	true

			@param 	mpValid
			@type 		boolean
			@text 		MPゲージ表示
			@desc 		On（true）の時、HUDウィンドウにMPゲージを表示します。
			@default 	true

			@param 	tpValid
			@type 		boolean
			@text 		TPゲージ表示
			@desc 		On（true）の時、HUDウィンドウにTPゲージを表示します。
			@default 	true

			@param 	gaugeName
			@type 		boolean
			@text 		ゲージ名表示
			@desc 		On（true）の時、ゲージの左側に参照する能力名か表示されます。名前はデータベースの用語「基本ステータス（略）」を取得します。
			@default 	true

			@param 	gaugeNowMax
			@type 		boolean
			@text 		ゲージ値表示
			@desc 		On（true）の時、ゲージの右側に現在値と最大値を表示します。
			@default 	true

			@param 	actorName
			@type 		boolean
			@text 		アクター名表示
			@desc 		On（true）の時、ウィンドウ上部に対象のアクター名を表示します。Offの時、レベルも非表示になります。
			@default 	true

			@param 	actorLevel
			@type 		boolean
			@text 		レベル表示
			@desc 		On（true）の時、アクター名の横に対象のレベルを表示します。アクター名のOnが必要です。
			@default 	true

			@param 	actorExp
			@type 		boolean
			@text 		経験値表示
			@desc 		On（true）の時、ゲージの最下部にアクターの経験値を表示します。
			@default 	true

			@param 	limitSteps
			@type 		number
			@text 		ステート解除のカウントダウン（秒/歩数）
			@desc 		ステートが解除される前に表示されるカウントダウンの開始値を設定します。
			@default 	10
			@max 		99
			@decimals 	0

			@param 	background
			@type 		number
			@text 		背景の透明度
			@desc 		HUDの背景の透明度を設定します。0＝不透明　1=半透明　2=透明　です。
			@default 	0
			@max 		2
			@decimals 	0

			@param 	direction
			@type 		select
			@text 		ウィンドウの配置方向
			@desc 		複数のHUDウィンドウを表示する際に、ウィンドウを並べる方向を設定します。
			@default 	vertical
				@option 	縦型
				@value 	vertical

				@option 	横型
				@value 	horizontal

			@param 	width
			@type 		number
			@text 		ウィンドウ幅(px)
			@desc 		ウィンドウの幅を設定します。初期値は200です。
			@default 	200
			@decimals 	0

			@param 	height
			@type 		number
			@text 		ウィンドウ高さ(px)
			@desc 		ウィンドウの高さを設定します。初期値は120です。
			@default 	120	
			@decimals 	0

			@param 	positionX
			@type 		number
			@text 		ウィンドウｘ座標(px)
			@desc 		ウィンドウの左上原点のｘ座標を設定します。初期値は0です。
			@default 	0
			@decimals 	0

			@param 	positionY
			@type 		number
			@text 		ウィンドウY座標(px)
			@desc 		ウィンドウの左上原点のY座標を設定します。初期値は0です。
			@default 	0
			@decimals 	0

			@param 	margin
			@type 		number
			@text 		マージン(px)
			@desc 		複数のHUDウィンドウを表示する際に、ウィンドウの空間を設定します。初期値は0です。
			@default 	0
			@decimals 	0

			@param 	padding
			@type 		number
			@text 		パディング(px)
			@desc 		コンテンツの余白を設定します。初期値は12です。
			@default 	12
			@decimals 	0

			@param 	fontSize
			@type 		number
			@text 		文字サイズ(px)
			@desc 		コンテンツの文字サイズを設定します。初期値は18です。
			@default 	18
			@decimals 	0

			@param 	decreaser
			@type 		boolean
			@text 		HPゲージ簡易減少
			@desc 		On（true）の時、HP第２ゲージがなくなり、HP第１ゲージのみ表示されます。
			@default 	false

			@param 	gaugeSpeed
			@type 		number
			@text 		ゲージ増減速度(フレーム)
			@desc 		ゲージの増減完了に必要なフレーム数を設定します。初期値は30です。
			@default 	30
			@min 		1
			@decimals 	0

			@param 	updateFrame
			@type 		number
			@text 		再描画時間（フレーム）
			@desc 		コンテンツ再描画までの時間を設定します。処理が重たい時に値を大きくしてみて下さい。
			@decimals 	0
			@default 	0
		*/
		/*------------------------------------------------------------------------------------------*/
		/*~struct~WindowHUD:
			@param 	configValid
			@type 		boolean
			@text 		stats HUD valid
			@desc 		Display stats HUD windows in maps when this is true
			@default 	true

			@param 	HUDinit
			@type 		boolean
			@text 		initial display
			@desc 		Select the initial value of displaying HUD
			@default 	true

			@param 	configName
			@type 		string
			@text 		system name
			@desc 		Define the name displayed in option window
			@default 	HUDの表示

			@param 	members
			@type 		number
			@text 		amount of HUD
			@desc 		Control how many windows of HUD are displayed; for how many members
			@default 	4
			@min 		1
			@decimals 	0

			@param 	rcType
			@type 		select
			@text 		type of setting gauges
			@desc 		Select the type to set up gauges of HP, MP, and so on
			@default 	row
				@option 	set up vertical
				@value 	row

				@option 	set up horizontal
				@value 	col

			@param 	hpValid
			@type 		boolean
			@text 		display HP gauge
			@desc 		Display it in HUD when this is true
			@default 	true

			@param 	mpValid
			@type 		boolean
			@text 		display MP gauge
			@desc 		Display it in HUD when this is true
			@default 	true

			@param 	tpValid
			@type 		boolean
			@text 		display TP gauge
			@desc 		Display it in HUD when this is true
			@default 	true

			@param 	gaugeName
			@type 		boolean
			@text 		display gauge names
			@desc 		Display them in HUD when this is true; names refers to Terms of Database
			@default 	true

			@param 	gaugeNowMax
			@type 		boolean
			@text 		display gauge values
			@desc 		Display current and max values in HUD when this is true
			@default 	true

			@param 	actorName
			@type 		boolean
			@text 		display Actor name
			@desc 		Display it in HUD when this is true; when false, Actor level is also hidden
			@default 	true

			@param 	actorLevel
			@type 		boolean
			@text 		display Actor level
			@desc 		Display it in HUD when this is true; "actorName" needs to be true
			@default 	true

			@param 	actorExp
			@type 		boolean
			@text 		display Actor Exp
			@desc 		Display it in HUD when this is true
			@default 	true

			@param 	limitSteps
			@type 		number
			@text 		countdown for removing states（seconds or steps）
			@desc 		Control the start number of countdown displayed before states removed
			@default 	10
			@max 		99
			@decimals 	0

			@param 	background
			@type 		number
			@text 		opacity of window's background
			@desc 		Control the background; 0: opaque, 1: darken, and　2: clear
			@default 	0
			@max 		2
			@decimals 	0

			@param 	direction
			@type 		select
			@text 		type to set up HUD
			@desc 		Select a type to set up some HUD windows
			@default 	vertical
				@option 	set up vertical
				@value 	vertical

				@option 	set up horizontal
				@value 	horizontal

			@param 	width
			@type 		number
			@text 		width of windows(px)
			@desc 		Control the width; initial value is 200
			@default 	200
			@decimals 	0

			@param 	height
			@type 		number
			@text 		height of windows(px)
			@desc 		Control the height; initial value is 120
			@default 	120	
			@decimals 	0

			@param 	positionX
			@type 		number
			@text 		x-coordinate of the first window(px)
			@desc 		Control the x-coordinate; initial value is 0
			@default 	0
			@decimals 	0

			@param 	positionY
			@type 		number
			@text 		y-coordinate of the first window(px)
			@desc 		Control the y-coordinate; initial value is 0
			@default 	0
			@decimals 	0

			@param 	margin
			@type 		number
			@text 		margin between windows(px)
			@desc 		Control the margin; initial value is 0 
			@default 	0
			@decimals 	0

			@param 	padding
			@type 		number
			@text 		padding of windows(px)
			@desc 		Control the padding; initial value is 12
			@default 	12
			@decimals 	0

			@param 	fontSize
			@type 		number
			@text 		font size of windows(px)
			@desc 		Control the font size; initial value is 18
			@default 	18
			@decimals 	0

			@param 	decreaser
			@type 		boolean
			@text 		simple HP gauge
			@desc 		Omit red gauge back of HP gauge , when this is true
			@default 	false

			@param 	gaugeSpeed
			@type 		number
			@text 		duration of gauge movement(frames)
			@desc 		Control the duration; initial value is 30
			@default 	30
			@min 		1
			@decimals 	0

			@param 	updateFrame
			@type 		number
			@text 		duration for redraw（frames）
			@desc 		Control the frames to redraw contents; try long frames to improve processing
			@decimals 	0
			@default 	0
		*/

		const parseWindowHUD = s => JSON.parse(s, (key, value)=>{
			switch(key){
				case 'configValid' 	: return value;
				case 'HUDinit' 		: return value;
				case 'configName' 	: return value;
				case 'members' 		: return Number.parseFloat(value);
				case 'rcType' 		: return value;
				case 'hpValid' 		: return value;
				case 'mpValid' 		: return value;
				case 'tpValid' 		: return value;
				case 'gaugeName' 	: return value;
				case 'gaugeNowMax' 	: return value;
				case 'actorName' 	: return value;
				case 'actorLevel' 	: return value;
				case 'actorExp' 	: return value;
				case 'limitSteps' 	: return Number.parseFloat(value);
				case 'background' 	: return Number.parseFloat(value);
				case 'direction' 	: return value;
				case 'width' 		: return Number.parseFloat(value);
				case 'height' 		: return Number.parseFloat(value);
				case 'positionX' 	: return Number.parseFloat(value);
				case 'positionY' 	: return Number.parseFloat(value);
				case 'margin' 		: return Number.parseFloat(value);
				case 'padding' 		: return Number.parseFloat(value);
				case 'fontSize' 	: return Number.parseFloat(value);
				case 'decreaser' 	: return value;
				case 'gaugeSpeed' 	: return Number.parseFloat(value);
				case 'updateFrame' 	: return Number.parseFloat(value);
				default 			: return value;
			}
		});//*

		/*~struct~GoldHUD:ja
			@param 	goldValid
			@type 		boolean
			@text 		所持金HUDの表示
			@desc 		On（true）の時、所持金HUDを表示します。
			@default 	true

			@param 	x
			@type 		number
			@text 		原点ｘ座標（px）
			@desc 		所持金HUDを表示する原点のｘ座標を設定します。初期値は576（= 816 - 240）です。
			@default 	576
			@decimals 	0

			@param 	y
			@type 		number
			@text 		原点ｙ座標（px）
			@desc 		所持金HUDを表示する原点のｙ座標を設定します。初期値は552（= 624 - 72）です。
			@default 	552
			@decimals 	0
		*/
		/*-----------------------------------------------------------------------------------------*/
		/*~struct~GoldHUD:
			@param 	goldValid
			@type 		boolean
			@text 		gold HUD valid
			@desc 		Display gold HUD in maps when this is true
			@default 	true

			@param 	x
			@type 		number
			@text 		x-coordinate of HUD window（px）
			@desc 		Control the x-coordinate; initial value is 576 because the width is 240
			@default 	576
			@decimals 	0

			@param 	y
			@type 		number
			@text 		y-coordinate of HUD window（px）
			@desc 		Control the y-coordinate; initial value is 552 because the height is 72
			@default 	552
			@decimals 	0
		*/

		const parseGoldHUD = s => JSON.parse(s, (key, value)=>{
			switch(key){
				case 'goldValid' 	: return value;
				case 'x' 			: return Number.parseFloat(value);
				case 'y' 			: return Number.parseFloat(value);
				default 			: return value;
			}
		});//*

		/*~struct~EquipHUD:ja
			@param 	equipValid
			@type 		boolean
			@text 		装備HUD・アイテムHUDの表示
			@desc 		On（true）の時、装備HUDやアイテムHUDを表示します。
			@default 	true

			@param 	weaponHUD
			@type 		struct<EachEquipHUD>
			@text 		武器HUDの設定
			@desc 		武器HUDの実装や位置、サイズなどを設定します。オススメ{x:100 y:430 width:100 height:100}

			@param 	shieldHUD
			@type 		struct<EachEquipHUD>
			@text 		盾HUDの設定
			@desc 		盾HUDの実装や位置、サイズなどを設定します。オススメ{x:0 y:430 width:100 height:100}

			@param 	armorHUD
			@type 		struct<EachEquipHUD>
			@text 		防具HUDの設定
			@desc 		防具HUDの実装や位置、サイズなどを設定します。オススメ{x:0 y:380 width:50 height:50}

			@param 	itemHUD
			@type 		struct<EachEquipHUD>
			@text 		アイテムHUDの設定
			@desc 		アイテムHUDの実装や位置、サイズなどを設定します。オススメ{x:60 y:530 width:80 height:80}

			@param 	itemSubHUD
			@type 		struct<EachEquipHUD>
			@text 		アイテムサブHUDの設定
			@desc 		２つ目のアイテムHUDの実装や位置、サイズなどを設定します。オススメ{x:140 y:540 width:40 height:40}

			@param 	itemThirdHUD
			@type 		struct<EachEquipHUD>
			@text 		アイテムサードHUDの設定
			@desc 		３つ目のアイテムHUDの実装や位置、サイズなどを設定します。オススメ{x:160 y:570 width:40 height:40}

			@param 	fontSize
			@type 		number
			@text 		文字サイズ（px）
			@desc 		装備・アイテムHUDに表示する文字のサイズを設定します。初期値は18です。
			@default 	18
			@decimals 	0
			@min 		12
			@max 		96

			@param 	mainPadding
			@type 		number
			@text 		メインパディングサイズ（px）
			@desc 		装備・アイテムHUDに表示する余白サイズを設定します。初期値は4です。
			@default 	4
			@decimals 	0

			@param 	subPadding
			@type 		number
			@text 		サブパディングサイズ（px）
			@desc 		アイテムサブ・サードHUDに表示する余白サイズを設定します。初期値は0です。
			@default 	0
			@decimals 	0

			@param 	nameBottomPosition
			@type 		number
			@text 		名前のボトム位置（px）
			@desc 		装備・アイテムの名前の、高さにおける表示位置を設定します。ウィンドウの下からの距離になります。
			@default 	18
			@decimals 	0
			@min 		0
			@max 		624

			@param 	itemBottomPosition
			@type 		number
			@text 		所持数のボトム位置（px）
			@desc 		アイテムの所持数の、高さにおける表示位置を設定します。ウィンドウの下からの距離になります。
			@default 	36
			@decimals 	0
			@min 		0
			@max 		624

			@param 	possessionPosition
			@type 		select
			@text 		所持数表示位置
			@desc 		アイテムの所持数を表示する横方向位置を選択します。
			@default 	right
					@option 左
					@value  left
					@option 真ん中
					@value  center
					@option 右
					@value  right

			@param 	itemPossessionColor
			@type 		string
			@text 		リンクアイテム最大値色
			@desc 		武器、盾にリンクされたアイテム所持数が指定変数の値と同値の際に表示する色を設定します。
			@default 	yellow

			@param 	armorStart
			@type 		number
			@text 		防具HUD開始ID
			@desc 		防具HUDで最初に表示するスロットIDを3~20で設定します。
			@decimals 	0
			@min 		3
			@max 		20
			@default 	3

			@param 	armorEnd
			@type 		number
			@text 		防具HUD終了ID
			@desc 		防具HUDで最後に表示するスロットIDを3~20で設定します。
			@decimals 	0
			@min 		3
			@max 		20
			@default 	5

			@param 	armorCols
			@type 		number
			@text 		防具HUD列数
			@desc 		防具HUDの列数を設定します。
			@decimals 	0
			@min 		1
			@max 		20
			@default 	3


			@param 	itemThirdType
			@type 		select
			@text 		アイテムサードHUDタイプ
			@desc 		アイテムサードHUDでアイテムを参照する形式を選択します。
			@default 	list
					@option リスト型（２つ隣のアイテム）
					@value  list
					@option カルーセル型（１つ前のアイテム）
					@value  carousel

			@param 	dimmerOpacity
			@type 		number
			@text 		入力不可の不透明度
			@desc 		プレイヤーのアクション入力が出来ないときに変更するHUDの不透明度を設定します。
			@decimals 	0
			@min 		0
			@max 		255
			@default 	192
		*/
		/*-----------------------------------------------------------------------------------------*/
		/*~struct~EquipHUD:
			@param 	equipValid
			@type 		boolean
			@text 		introduce HUD of equips or items
			@desc 		Display HUD of equips or items when this is true
			@default 	true

			@param 	weaponHUD
			@type 		struct<EachEquipHUD>
			@text 		weaponHUD
			@desc 		Settings of weapon HUD; for example{x:100 y:430 width:100 height:100}

			@param 	shieldHUD
			@type 		struct<EachEquipHUD>
			@text 		shieldHUD
			@desc 		Settings of shield HUD; for example{x:0 y:430 width:100 height:100}

			@param 	armorHUD
			@type 		struct<EachEquipHUD>
			@text 		armorHUD
			@desc 		Settings of armor HUD; for example{x:0 y:380 width:50 height:50}

			@param 	itemHUD
			@type 		struct<EachEquipHUD>
			@text 		itemHUD
			@desc 		Settings of item HUD; for example{x:60 y:530 width:80 height:80}

			@param 	itemSubHUD
			@type 		struct<EachEquipHUD>
			@text 		itemSubHUD
			@desc 		Settings of item second HUD; for example{x:140 y:540 width:40 height:40}

			@param 	itemThirdHUD
			@type 		struct<EachEquipHUD>
			@text 		itemThirdHUD
			@desc 		Settings of item third HUD; for example{x:160 y:570 width:40 height:40}

			@param 	fontSize
			@type 		number
			@text 		font size（px）
			@desc 		Control the font size of HUD; initial value is 18
			@default 	18
			@decimals 	0
			@min 		12
			@max 		96

			@param 	mainPadding
			@type 		number
			@text 		main padding（px）
			@desc 		Control the padding of weapon, shield, item HUD; intial value is 4
			@default 	4
			@decimals 	0

			@param 	subPadding
			@type 		number
			@text 		sub padding（px）
			@desc 		Control the padding of item sub and third HUD; intial value is 0
			@default 	0
			@decimals 	0

			@param 	nameBottomPosition
			@type 		number
			@text 		bottom position of name（px）
			@desc 		Control the name position of equips or items from bottom of the window
			@default 	18
			@decimals 	0
			@min 		0
			@max 		624

			@param 	itemBottomPosition
			@type 		number
			@text 		bottom position of possession（px）
			@desc 		Control the possession position of equips or items from bottom of the window
			@default 	36
			@decimals 	0
			@min 		0
			@max 		624

			@param 	possessionPosition
			@type 		select
			@text 		position of possession
			@desc 		Select the alignment to display possession of the item
			@default 	right
					@option Left
					@value  left
					@option Center
					@value  center
					@option Right
					@value  right

			@param 	itemPossessionColor
			@type 		string
			@text 		max link item color
			@desc 		Write a color name used when the amount of item linked to weapon or shield is equal to value of variable
			@default 	yellow

			@param 	armorStart
			@type 		number
			@text 		start slot of armorHUD
			@desc 		Control the start slot ID to draw equips in armorHUD between 3 and 20
			@decimals 	0
			@min 		3
			@max 		20
			@default 	3

			@param 	armorEnd
			@type 		number
			@text 		end slot of armorHUD
			@desc 		Control the last slot ID to draw equips in armorHUD between 3 and 20
			@decimals 	0
			@min 		3
			@max 		20
			@default 	5

			@param 	armorCols
			@type 		number
			@text 		columns of armorHUD
			@desc 		Control the columns of armorHUD
			@decimals 	0
			@min 		1
			@max 		20
			@default 	3

			@param 	itemThirdType
			@type 		select
			@text 		type of item third HUD
			@desc 		Select what item is displayed in the HUD; two doors down or one previous item 
			@default 	list
					@option List type
					@value  list
					@option Carousel type
					@value  carousel

			@param 	dimmerOpacity
			@type 		number
			@text 		opacity of untouchable equipHUD
			@desc 		Control the opacity for showing player no permission to input action commands
			@decimals 	0
			@min 		0
			@max 		255
			@default 	192
		*/
		/****************************************************************************************/
				/*~struct~EachEquipHUD:ja
				@param 	eachEquipValid
				@type 		boolean
				@text 		HUDの実装
				@desc 		On（true）の時、編集中の装備HUD、アイテムHUDを実装します。
				@default 	true

				@param 	x
				@type 		number
				@text 		原点ｘ座標（px）
				@desc 		編集中のHUDを表示する原点のｘ座標を設定します。
				@default 	0
				@decimals 	0

				@param 	y
				@type 		number
				@text 		原点ｙ座標（px）
				@desc 		編集中のHUDを表示する原点のｙ座標を設定します。
				@default 	500
				@decimals 	0

				@param 	width
				@type 		number
				@text 		ウィンドウ幅（px）
				@desc 		編集中のHUDの幅を設定します。
				@default 	100
				@decimals 	0

				@param 	height
				@type 		number
				@text 		ウィンドウ高さ（px）
				@desc 		編集中のHUDの高さを設定します。
				@default 	100
				@decimals 	0

				@param 	displayName
				@type 		boolean
				@text 		アイテム名表示
				@desc 		On(true)の時、装備やアイテムの名前がHUDに表示されます。
				@default 	false
			*/
			/*------------------------------------------------------------*/
			/*~struct~EachEquipHUD:
				@param 	eachEquipValid
				@type 		boolean
				@text 		introduce this HUD
				@desc 		Display this HUD when this is true
				@default 	true

				@param 	x
				@type 		number
				@text 		x coordinate of this origin（px）
				@desc 		Control the x coordinate
				@default 	0
				@decimals 	0

				@param 	y
				@type 		number
				@text 		y coordinate of this origin（px）
				@desc 		Control the y coordinate
				@default 	500
				@decimals 	0

				@param 	width
				@type 		number
				@text 		width of this HUD（px）
				@desc 		Control the width
				@default 	100
				@decimals 	0

				@param 	height
				@type 		number
				@text 		height of this HUD（px）
				@desc 		Control the height
				@default 	100
				@decimals 	0

				@param 	displayName
				@type 		boolean
				@text 		display item name
				@desc 		Display the item name in HUD when this is true
				@default 	false
			*/


			const parseEachEquipHUD = s => JSON.parse(s, (key, value)=>{
			switch(key){
				case 'equipValid' 			: return value;
				case 'weaponHUD' 			: return value;
				case 'shieldHUD' 			: return value;
				case 'armorHUD' 			: return value;
				case 'itemHUD' 				: return value;
				case 'itemSubHUD' 			: return value;
				case 'itemThirdHUD' 		: return value;
				case 'displayGraphic' 		: return value;
				case 'fontSize' 			: return Number.parseFloat(value);
				case 'mainPadding' 			: return Number.parseFloat(value);
				case 'subPadding' 			: return Number.parseFloat(value);
				case 'nameBottomPosition' 	: return Number.parseFloat(value);
				case 'itemBottomPosition' 	: return Number.parseFloat(value);
				case 'possessionPosition' 	: return value;
				case 'itemPossessionColor' 	: return value;
				case 'armorStart' 			: return Number.parseFloat(value);
				case 'armorEnd' 			: return Number.parseFloat(value);
				case 'armorCols' 			: return Number.parseFloat(value);
				case 'itemThirdType' 		: return value;
				case 'dimmerOpacity' 		: return Number.parseFloat(value);
				default 			: return value;
			}
		});//*

				const parseEquipHUD = s => JSON.parse(s, (key, value)=>{
					switch(key){
						case 'eachEquipValid' 	: return value;
						case 'x' 				: return Number.parseFloat(value);
						case 'y' 				: return Number.parseFloat(value);
						case 'width' 			: return Number.parseFloat(value);
						case 'height' 			: return Number.parseFloat(value);
						case 'displayName' 		: return value;
						default 			: return value;
					}
				});//*


		let windowHUD = params.windowHUD;
		let consolerNameHUD = 'windowHUD:';
		if(windowHUD){
				windowHUD  = parseWindowHUD(windowHUD);
				windowHUD = stringToBoolean(windowHUD);
		}else{
				windowHUD = makeNotValid();
				undefinedStructs.push(consolerNameHUD);
				consolerNameHUD += makeInvalidTerm();
		};
		//--------------------------------------------------//
		let goldHUD = params.goldHUD;
		let consolerNameGoldHUD = 'goldHUD:';
		if(goldHUD){
				goldHUD = parseGoldHUD(goldHUD);
				goldHUD = stringToBoolean(goldHUD);	
		}else{
				goldHUD = makeNotValid();
				undefinedStructs.push(consolerNameGoldHUD);
				consolerNameGoldHUD += makeInvalidTerm();
		};
		//--------------------------------------------------//
		let equipHUD = params.equipHUD;
		let consolerNameEquipHUD = 'equipHUD:';
		if(equipHUD){
			equipHUD = parseEquipHUD(equipHUD);
			equipHUD = stringToBoolean(equipHUD);
			if(equipHUD.weaponHUD) {
				equipHUD.weaponHUD = parseEachEquipHUD(equipHUD.weaponHUD);
				equipHUD.weaponHUD = stringToBoolean(equipHUD.weaponHUD);
				equipHUD.weaponHUD = stringToNumber(equipHUD.weaponHUD);
			}
			if(equipHUD.shieldHUD) {
				equipHUD.shieldHUD = parseEachEquipHUD(equipHUD.shieldHUD);
				equipHUD.shieldHUD = stringToBoolean(equipHUD.shieldHUD);
				equipHUD.shieldHUD = stringToNumber(equipHUD.shieldHUD);
			}
			if(equipHUD.armorHUD) {
				equipHUD.armorHUD = parseEachEquipHUD(equipHUD.armorHUD);
				equipHUD.armorHUD = stringToBoolean(equipHUD.armorHUD);
				equipHUD.armorHUD = stringToNumber(equipHUD.armorHUD);
			}
			if(equipHUD.itemHUD) {
				equipHUD.itemHUD = parseEachEquipHUD(equipHUD.itemHUD);
				equipHUD.itemHUD = stringToBoolean(equipHUD.itemHUD);
				equipHUD.itemHUD = stringToNumber(equipHUD.itemHUD);
			}
			if(equipHUD.itemSubHUD) {
				equipHUD.itemSubHUD = parseEachEquipHUD(equipHUD.itemSubHUD);
				equipHUD.itemSubHUD = stringToBoolean(equipHUD.itemSubHUD);
				equipHUD.itemSubHUD = stringToNumber(equipHUD.itemSubHUD);
			}
			if(equipHUD.itemThirdHUD) {
				equipHUD.itemThirdHUD = parseEachEquipHUD(equipHUD.itemThirdHUD);
				equipHUD.itemThirdHUD = stringToBoolean(equipHUD.itemThirdHUD);
				equipHUD.itemThirdHUD = stringToNumber(equipHUD.itemThirdHUD);
			}
			equipHUD = stringToNumber(equipHUD);
		}else{
			equipHUD = makeNotValid();
			undefinedStructs.push(consolerNameEquipHUD);
			consolerNameEquipHUD += makeInvalidTerm();
		};
		//--------------------------------------------------//		
		consoler(consolerNameHUD, windowHUD);
		consoler(consolerNameGoldHUD, goldHUD);
		consoler(consolerNameEquipHUD, equipHUD);
		//MELOS Global Variable override
		HUDconfigValid = windowHUD.configValid;
		goldHUDValid = goldHUD.goldValid;
		equipHUDValid = equipHUD.equipValid;

//HUD設定なしでファストトラベルを行う時用に、空のファンクションを準備
Game_System.prototype.temporaryHideHUD = function(){};//*

const _Game_System_prototype_initialize_E = Game_System.prototype.initialize;
Game_System.prototype.initialize = function(){
	_Game_System_prototype_initialize_E.apply(this, arguments);

	this._configHUD = windowHUD.HUDinit;
	this._temporaryHiddenHUD = false;
};//*

const _Game_Actor_prototype_initMembers_A = Game_Actor.prototype.initMembers;
Game_Actor.prototype.initMembers = function(){
	_Game_Actor_prototype_initMembers_A.apply(this, arguments);
	this.allResetHUDchange();
};//*

const _Game_Party_prototype_initialize_A = Game_Party.prototype.initialize;
Game_Party.prototype.initialize = function(){
	_Game_Party_prototype_initialize_A.apply(this, arguments);
	this.allResetHUDchange();
};//*


if(HUDValid > 0){
	const _DataManager_setAdditionalConfig = DataManager.setAdditionalConfig;
	DataManager.setAdditionalConfig = function(){
		_DataManager_setAdditionalConfig.apply(this, arguments);

		if(typeof ConfigManager.configHUD === 'boolean'){
			$gameSystem.setDisplayConfigHUD(ConfigManager.configHUD);
		}
	};//*
					
	const _ConfigManager_makeData = ConfigManager.makeData;
	ConfigManager.makeData = function() {
		let config = _ConfigManager_makeData.apply(this, arguments);
			config.configHUD 	= $gameSystem.displayConfigHUD();
	    return config;
	};//*

	const _ConfigManager_applyData = ConfigManager.applyData;
	ConfigManager.applyData = function(config) {
		_ConfigManager_applyData.apply(this, arguments);

		this.configHUD 	= config.configHUD;
	};//*

	Object.defineProperty(ConfigManager, configHUD, {
	    get: function() {
	    	return $gameSystem.displayConfigHUD();       
	    },
		set: function(value) {
		   	$gameSystem.setDisplayConfigHUD(value);      
	    },
	    configurable: true
	});

	const _Game_Player_prototype_clearTransferInfo = Game_Player.prototype.clearTransferInfo;
	Game_Player.prototype.clearTransferInfo = function() {
	    _Game_Player_prototype_clearTransferInfo.apply(this, arguments);
	    if($gameSystem.temporaryHiddenHUD()){
	    	$gameSystem.setDisplayConfigHUD(true);
	    	$gameSystem.setTemporaryHiddenHUD(false);
	    }
	};//*
}////


Game_System.prototype.displayConfigHUD = function(){
	return this._configHUD;
};//*
if(HUDValid <= 0) Game_System.prototype.displayConfigHUD = function(){return false};


Game_System.prototype.setDisplayConfigHUD = function(value){
	this._configHUD = value;
};//*
if(HUDValid <= 0) Game_System.prototype.setDisplayConfigHUD = function(value){};


Game_System.prototype.temporaryHiddenHUD = function(){
	return this._temporaryHiddenHUD;
};//*
if(HUDValid <= 0) Game_System.prototype.temporaryHiddenHUD = function(){return false};


Game_System.prototype.setTemporaryHiddenHUD = function(value){
	this._temporaryHiddenHUD = value;
};//*
if(HUDValid <= 0) Game_System.prototype.setTemporaryHiddenHUD = function(value){};
	

Game_System.prototype.temporaryHideHUD = function(){
	if (HUDconfigValid && this.displayConfigHUD()){
		this.setDisplayConfigHUD(false);
		this.setTemporaryHiddenHUD(true);
	}; 
};//*
if(HUDValid <= 0) Game_System.prototype.temporaryHideHUD = function(){};

//$gameSystemのshowHUD hideHUDはユーザー用のスクリプトも想定した処理
Game_System.prototype.showHUD = function(forced){
	const sceneMap = SceneManager._scene;
	if(forced === 'forced'){
		//obey creators
		sceneMap.commandShowHUDs();
	}else{
		//obey players
		if(ConfigManager[configHUD]){
			sceneMap.commandShowHUDs();
		}
	}
};//*
if(HUDValid <= 0) Game_System.prototype.showHUD = function(forced){};


Scene_Map.prototype.commandShowHUDs = function(){
	if(HUDconfigValid){
		this._HUDWindows ? this.showHUD() : this.createHUD();
	}			
	if(goldHUDValid){
		this._goldHUDWindow ? this.showGoldHUD() : this.createGoldHUD();
	}
	if(equipHUDValid){
		const needEquipHUD = this._weaponHUDWindow || this._shieldHUDWindow ||
								this._armorHUDWindows || this._itemHUDWindow;
		needEquipHUD ? this.showEquipHUD() : this.createEquipHUD();
	}
};//*
if(HUDValid <= 0) Scene_Map.prototype.commandShowHUDs = function(){};


Game_System.prototype.hideHUD = function(forced){
	const sceneMap = SceneManager._scene;
	if(forced === 'forced'){
		//obey creators
		sceneMap.commandHideHUDs();
	}else{
		//obey players
		if(!ConfigManager[configHUD]){
			sceneMap.commandHideHUDs();
		}
	}
};//*
if(HUDValid <= 0) Game_System.prototype.hideHUD = function(forced){};


Scene_Map.prototype.commandHideHUDs = function(){
	if(HUDconfigValid && this._HUDWindows){
		this.hideHUD();
	}
	if(goldHUDValid && this._goldHUDWindow){
		this.hideGoldHUD();
	}
	if(equipHUDValid){
		const hasEquipHUD = this._weaponHUDWindow || this._shieldHUDWindow ||
							this._armorHUDWindows || this._itemHUDWindow;
		if(hasEquipHUD) this.hideEquipHUD();
	}
};//*
if(HUDValid <= 0) Scene_Map.prototype.commandHideHUDs = function(){};


		//------------------HUDの実装と描画管理--------------------------------//
if(HUDValid > 0){
	const _Scene_Map_prototype_update2 = Scene_Map.prototype.update;
	Scene_Map.prototype.update = function(){
		_Scene_Map_prototype_update2.apply(this, arguments);
		if(ConfigManager[configHUD] && !this._HUDWindows){
			this.createHUD();
		}
		if(ConfigManager[configHUD] && !this._goldHUDWindow){
			this.createGoldHUD();
		}
		if(ConfigManager[configHUD] && this.needEquipHUD()){
			this.createEquipHUD();
		}

		if(ConfigManager[configHUD] && $gameMap.needsHideHUD() && !this._tempHUDHide){
			this._tempHUDHide = true;
			$gameSystem.hideHUD('forced');
		}
		if(ConfigManager[configHUD] && !$gameMap.needsHideHUD() && this._tempHUDHide){
			this._tempHUDHide = false;
			$gameSystem.showHUD();
		}
	};//*

	Scene_Map.prototype.needEquipHUD = function(){
		const eh = equipHUD;
		const needWeapon = eh.weaponHUD && eh.weaponHUD.eachEquipValid && !this._weaponHUDWindow;
		const needShield = eh.shieldHUD && eh.shieldHUD.eachEquipValid && !this._shieldHUDWindow;
		const needArmor = eh.armorHUD && eh.armorHUD.eachEquipValid && !this._armorHUDWindows;
		const needItem = eh.itemHUD && eh.itemHUD.eachEquipValid && !this._itemHUDWindow;
		return needWeapon || needShield || needArmor || needItem;
	};//*

	//アクターのステータス変動処理をHUD対応
	const _Game_Actor_prototype_gainHp = Game_Actor.prototype.gainHp;
	Game_Actor.prototype.gainHp = function(value) {
	    _Game_Actor_prototype_gainHp.apply(this, arguments);
	   	this.permitHUDChange(value, 'hp');
	};//*

	const _Game_Actor_prototype_gainMp = Game_Actor.prototype.gainMp;
	Game_Actor.prototype.gainMp = function(value) {
	    _Game_Actor_prototype_gainMp.apply(this, arguments);
	    this.permitHUDChange(value, 'mp');
	};//*

	const _Game_Actor_prototype_gainTp = Game_Actor.prototype.gainTp;
	Game_Actor.prototype.gainTp = function(value) {
	    _Game_Actor_prototype_gainTp.apply(this, arguments);
	    this.permitHUDChange(value, 'tp');
	};//*

	const _Game_Actor_prototype_gainSilentTp = Game_Actor.prototype.gainSilentTp;
	Game_Actor.prototype.gainSilentTp = function(value) {
	    _Game_Actor_prototype_gainSilentTp.apply(this, arguments);
	    this.permitHUDChange(value, 'tp');
	};//*

	const _Game_Actor_prototype_gainExp = Game_Actor.prototype.gainExp;
	Game_Actor.prototype.gainExp = function(exp) {
	    _Game_Actor_prototype_gainExp.apply(this, arguments);
	    this.permitHUDChange(exp, 'exp');
	};//*

		//pay系は上記のgainファンクションを使っていないため個別対応
	const _Game_Actor_prototype_paySkillCost = Game_Actor.prototype.paySkillCost;
	Game_Actor.prototype.paySkillCost = function(){
		_Game_Actor_prototype_paySkillCost.apply(this, arguments);
		this.allPermitHUDchange();
	};//*

	const _Game_Actor_prototype_paySkillCostLater = Game_Actor.prototype.paySkillCostLater;
	Game_Actor.prototype.paySkillCostLater = function(){
		_Game_Actor_prototype_paySkillCostLater.apply(this, arguments);
		this.allPermitHUDchange();
	};//*

	const _Game_Actor_prototype_setName = Game_Actor.prototype.setName;
	Game_Actor.prototype.setName = function(name) {
	    _Game_Actor_prototype_setName.apply(this, arguments);
	    this.permitHUDChange(1, 'name');
	};//*

	const _Game_Actor_prototype_levelUp = Game_Actor.prototype.levelUp;
	Game_Actor.prototype.levelUp = function() {
	    _Game_Actor_prototype_levelUp.apply(this, arguments);
	    this.permitHUDChange(1, 'level');
	};//*

	const _Game_Actor_prototype_levelDown = Game_Actor.prototype.levelDown;
	Game_Actor.prototype.levelDown = function() {
	    _Game_Actor_prototype_levelDown.apply(this, arguments);
	    this.permitHUDChange(-1, 'level');
	};//*

	const _Game_Actor_prototype_addState = Game_Actor.prototype.addState;
	Game_Actor.prototype.addState = function(stateId) {
		const needRefreshHUD = this.isStateAddable(stateId);
	    _Game_Actor_prototype_addState.apply(this, arguments);
	    if(needRefreshHUD) this.allPermitHUDchange();
	};//*

	const _Game_Actor_prototype_removeState = Game_Actor.prototype.removeState;
	Game_Actor.prototype.removeState = function(stateId) {
	    const needRefreshHUD = this.isStateAffected(stateId);
	    _Game_Actor_prototype_removeState.apply(this, arguments);
	    if(needRefreshHUD) this.allPermitHUDchange();
	};//*

	const _Game_Actor_prototype_addBuff = Game_Actor.prototype.addBuff;
	Game_Actor.prototype.addBuff = function(paramId, turns) {
	    const needRefreshHUD = this.isAlive();
	    _Game_Actor_prototype_addBuff.apply(this, arguments);
	    if(needRefreshHUD) this.allPermitHUDchange();
	};//*

	const _Game_Actor_prototype_addDebuff = Game_Actor.prototype.addDebuff;
	Game_Actor.prototype.addDebuff = function(paramId, turns) {
	    const needRefreshHUD = this.isAlive();
	    _Game_Actor_prototype_addDebuff.apply(this, arguments);
	    if(needRefreshHUD) this.allPermitHUDchange();
	};//*

	const _Game_Actor_prototype_removeBuff = Game_Actor.prototype.removeBuff;
	Game_Actor.prototype.removeBuff = function(paramId) {
	    const needRefreshHUD = this.isAlive() && this.isBuffOrDebuffAffected(paramId);
	    _Game_Actor_prototype_removeBuff.apply(this, arguments);
	    if(needRefreshHUD) this.allPermitHUDchange();
	};//*

	/*--------------------------------------------------------------------*/
	const _Game_Party_prototype_gainGold = Game_Party.prototype.gainGold;
	Game_Party.prototype.gainGold = function(amount) {
	    _Game_Party_prototype_gainGold.apply(this, arguments);
	    this.permitHUDChange(amount, 'gold');
	};//*
}////

//並列はisEventRunningに認められないため、アクションのCEVを並列としてみなさせる必要がある。
//ガイドHUDにも適用できるように鍵はかけない
Game_Map.prototype.needsHideHUD = function(){
	return this.isEventRunning() && !this.isRunningActionEvent();
};//*


Game_Map.prototype.isRunningActionEvent = function(){
	return this._interpreter && this._interpreter._actionCommon;
};//*


//SceneにHUDを生成するファンクション群
Scene_Map.prototype.createHUD = function(){
	const width = windowHUD.width || 200;
	const height = windowHUD.height || 120;
	const members = Math.min(windowHUD.members, $gameParty.members().length);
	this._HUDWindows = [];

	if(HUDconfigValid){
			for(var i = 0 ; i < members; i++){
				let x = windowHUD.positionX || 0;
				let y = windowHUD.positionY || 0;
				switch(windowHUD.direction){
					case 'vertical' 	: y += (height + windowHUD.margin) * i; break;
					case 'horizontal' 	: x += (width + windowHUD.margin) * i; break;
				}
		
				this._HUDWindows[i] = new Window_HUD(x, y, width, height, i);
			    this._HUDWindows[i].drawContents();
			    this._HUDWindows[i].setBackgroundType();

			    this.addChild(this._HUDWindows[i]);	
			}
		    $gameTemp.clearDestination();
		    this._waitCount = 2;
	}
};//*
if(HUDValid <= 0) Scene_Map.prototype.createHUD = function(){};


Scene_Map.prototype.createGoldHUD = function(){
	if(goldHUDValid){
		const x = goldHUD.x || 576;
		const y = goldHUD.y || 552;
		this._goldHUDWindow = new Window_GoldHUD(x, y);

		this.addChild(this._goldHUDWindow);
	}
};//*
if(HUDValid <= 0) Scene_Map.prototype.createGoldHUD = function(){};


Scene_Map.prototype.createEquipHUD = function(){
	if(equipHUDValid){
		this.createWeaponHUD();	
		this.createShieldHUD();
		this.createArmorHUD();
		this.createItemHUD();
	}
};//*
if(HUDValid <= 0) Scene_Map.prototype.createEquipHUD = function(){};

Scene_Map.prototype.createWeaponHUD = function(){
	const eh = equipHUD;
	if(eh.weaponHUD.eachEquipValid){
		const wx = eh.weaponHUD ? eh.weaponHUD.x : 100;
		const wy = eh.weaponHUD ? eh.weaponHUD.y : 430;
		this._weaponHUDWindow = new Window_WeaponHUD(wx, wy);
		this.addChild(this._weaponHUDWindow);	
	}	
};//*
if(HUDValid <= 0) Scene_Map.prototype.createWeaponHUD = function(){};

Scene_Map.prototype.createShieldHUD = function(){
	const eh = equipHUD;
	if(eh.shieldHUD.eachEquipValid){	
		const sx = eh.shieldHUD ? eh.shieldHUD.x : 0;
		const sy = eh.shieldHUD ? eh.shieldHUD.y : 430;
		this._shieldHUDWindow = new Window_ShieldHUD(sx, sy);
		this.addChild(this._shieldHUDWindow);
	}
};//*
if(HUDValid <= 0) Scene_Map.prototype.createShieldHUD = function(){};

Scene_Map.prototype.createArmorHUD = function(){
	this._armorHUDWindows = [];
	const eh = equipHUD;
	if(eh.armorHUD.eachEquipValid){
		const ax = eh.armorHUD ? eh.armorHUD.x : 0;
		const ay = eh.armorHUD ? eh.armorHUD.y : 380;
		const width = eh.armorHUD.width || 50;
		const height = eh.armorHUD.height || 50;
		const startId = (eh.armorStart || 3) - 1;
		const endId = (eh.armorEnd || 5) - 1;
		const cols = eh.armorCols || 3;
		
		for(var i = startId; i < endId + 1; i++){
			let x = ax + width * ( (i - startId) % cols );
			let y = ay + height * Math.floor( (i - startId) / cols )
			this._armorHUDWindows[i - startId] = new Window_ArmorHUD(x, y, i);

			this.addChild(this._armorHUDWindows[i - startId]);
		}
	}
};//*
if(HUDValid <= 0) Scene_Map.prototype.createArmorHUD = function(){};

Scene_Map.prototype.createItemHUD = function(){
	const eh = equipHUD;
	if(eh.itemHUD.eachEquipValid){
		const ix = eh.itemHUD ? eh.itemHUD.x : 60;
		const iy = eh.itemHUD ? eh.itemHUD.y : 530;
		const iw = eh.itemHUD ? eh.itemHUD.width : 80;
		const ih = eh.itemHUD ? eh.itemHUD.height : 80;
		this._itemHUDWindow = new Window_ItemHUD(ix, iy);

		const isx = eh.itemSubHUD ? eh.itemSubHUD.x : ix + iw;
		const isy = eh.itemSubHUD ? eh.itemSubHUD.y : iy + 10;
		const isw = eh.itemSubHUD ? eh.itemSubHUD.width : 40;
		const ish = eh.itemSubHUD ? eh.itemSubHUD.height : 40;
			
		const itx = eh.itemThirdHUD ? eh.itemThirdHUD.x : ix + iw + isw/2;
		const ity = eh.itemThirdHUD ? eh.itemThirdHUD.y : iy + ih * 3/4;
		if(eh.itemSubHUD.eachEquipValid){
			if(eh.itemThirdHUD.eachEquipValid){
				this._itemThirdHUDWindow = new Window_ItemThirdHUD(itx, ity);
				this._itemThirdHUDWindow.setItemHUDWindow(this._itemHUDWindow);
				this._itemHUDWindow.setItemThirdHUDWindow(this._itemThirdHUDWindow);
				this.addChild(this._itemThirdHUDWindow);
			}
			this._itemSubHUDWindow = new Window_ItemSubHUD(isx, isy);
			this._itemSubHUDWindow.setItemHUDWindow(this._itemHUDWindow);
			this._itemHUDWindow.setItemSubHUDWindow(this._itemSubHUDWindow);
			this.addChild(this._itemSubHUDWindow);
		}
		this.addChild(this._itemHUDWindow);		
	}
};//*
if(HUDValid <= 0) Scene_Map.prototype.createItemHUD = function(){};


Scene_Map.prototype.dimmerEquipHUD = function(dimmer){
	//入力不可を伝えるためにHUD不透明度を下げるファンクション
	const dim = dimmer ? equipHUD.dimmerOpacity : 255;
	this.dimmerWeaponHUD(dim);
	this.dimmerShieldHUD(dim);
	this.dimmerArmorHUD(dim);
	this.dimmerItemHUD(dim);
};//*
if(HUDValid <= 0) Scene_Map.prototype.dimmerEquipHUD = function(opacity){};

Scene_Map.prototype.dimmerWeaponHUD = function(dim){
	if(this._weaponHUDWindow) this._weaponHUDWindow.opacity = dim;
};//*
if(HUDValid <= 0) Scene_Map.prototype.dimmerWeaponHUD = function(dim){};

Scene_Map.prototype.dimmerShieldHUD = function(dim){
	if(this._shieldHUDWindow) this._shieldHUDWindow.opacity = dim;
};//*
if(HUDValid <= 0)Scene_Map.prototype.dimmerShieldHUD = function(dim){};

Scene_Map.prototype.dimmerArmorHUD = function(dim){
	if(this._armorHUDWindows){
		let length = this._armorHUDWindows.length;
		for(var i = 0; i < length; i++){
			this._armorHUDWindows[i].opacity = dim;
		}
	}
};//*
if(HUDValid <= 0) Scene_Map.prototype.dimmerArmorHUD = function(dim){};

Scene_Map.prototype.dimmerItemHUD = function(dim){
	if(this._itemHUDWindow) 	this._itemHUDWindow.opacity = dim;
	if(this._itemSubHUDWindow)	this._itemSubHUDWindow.opacity = dim;
	if(this._itemThirdHUDWindow)this._itemThirdHUDWindow.opacity = dim;
};//*
if(HUDValid <= 0) Scene_Map.prototype.dimmerItemHUD = function(dim){};


Scene_Map.prototype.showHUD = function(){
	if(this._HUDWindows){
		let length = this._HUDWindows.length;
		for(var i = 0; i < length; i++){
			this._HUDWindows[i].show();
		}
	}
};//*
if(HUDValid <= 0) Scene_Map.prototype.showHUD = function(){};


Scene_Map.prototype.hideHUD = function(){
	if(this._HUDWindows){
		let length = this._HUDWindows.length;
		for(var i = 0; i < length; i++){
			this._HUDWindows[i].hide();
		}
	}
};//*
if(HUDValid <= 0) Scene_Map.prototype.hideHUD = function(){};


Scene_Map.prototype.showGoldHUD = function(){
	if(this._goldHUDWindow) this._goldHUDWindow.show();
};//*
if(HUDValid <= 0) Scene_Map.prototype.showGoldHUD = function(){};


Scene_Map.prototype.hideGoldHUD = function(){
	if(this._goldHUDWindow) this._goldHUDWindow.hide();
};//*
if(HUDValid <= 0) Scene_Map.prototype.hideGoldHUD = function(){};


Scene_Map.prototype.showEquipHUD = function(){
	if(this._weaponHUDWindow) this._weaponHUDWindow.show();
	if(this._shieldHUDWindow) this._shieldHUDWindow.show();
	if(this._armorHUDWindows){
		let length = this._armorHUDWindows.length;
		for(var i = 0; i < length; i++){
			this._armorHUDWindows[i].show();
		}
	}
	if(this._itemHUDWindow) 	this._itemHUDWindow.show();
	if(this._itemSubHUDWindow)	this._itemSubHUDWindow.show();
	if(this._itemThirdHUDWindow)this._itemThirdHUDWindow.show();
};//*
if(HUDValid <= 0) Scene_Map.prototype.showEquipHUD = function(){};


Scene_Map.prototype.hideEquipHUD = function(){
	if(this._weaponHUDWindow) this._weaponHUDWindow.hide();
	if(this._shieldHUDWindow) this._shieldHUDWindow.hide();
	if(this._armorHUDWindows){
		let length = this._armorHUDWindows.length;
		for(var i = 0; i < length; i++){
			this._armorHUDWindows[i].hide();
		}
	}
	if(this._itemHUDWindow) 	this._itemHUDWindow.hide();
	if(this._itemSubHUDWindow)	this._itemSubHUDWindow.hide();
	if(this._itemThirdHUDWindow)this._itemThirdHUDWindow.hide();
};//*
if(HUDValid <= 0) Scene_Map.prototype.hideEquipHUD = function(){};

//アクター側のHUDに関する設定
Game_Actor.prototype.permitHUDChange = function(value, param){
	if(ConfigManager[configHUD] && SceneManager._scene._HUDWindows){
		if(value !== 0) {
				switch(param){
					case 'hp' : this._HpHUDchange = windowHUD.hpValid; break;
					case 'mp' : this._MpHUDchange = windowHUD.mpValid; break;
					case 'tp' : this._TpHUDchange = windowHUD.tpValid; break;
					case 'exp': this._ExpHUDchange = windowHUD.actorExp; break;
					case 'name': this._NameHUDChange = windowHUD.actorName; break;
					case 'level' : this._LevelHUDChange = windowHUD.actorLevel; break;
					default : this.allPermitHUDchange();
				}
		};
	}
};//*
if(HUDValid <= 0) Game_Actor.prototype.permitHUDChange = function(value, param){};


Game_Actor.prototype.allPermitHUDchange = function(){
	this._HpHUDchange = windowHUD.hpValid;
	this._MpHUDchange = windowHUD.mpValid;
	this._TpHUDchange = windowHUD.tpValid;
	this._ExpHUDchange = windowHUD.actorExp;
	this._NameHUDChange = windowHUD.actorName;
	this._LevelHUDChange = windowHUD.actorLevel;
};//*
if(HUDValid <= 0) Game_Actor.prototype.allPermitHUDchange = function(){};


Game_Actor.prototype.resetHUDchange = function(param){
	if(this.enableHUDchange()){
		switch(param){
			case 'hp' : this._HpHUDchange = false; break;
			case 'mp' : this._MpHUDchange = false; break;
			case 'tp' : this._TpHUDchange = false; break;
			case 'exp': this._ExpHUDchange = false; break;
			case 'name': this._NameHUDChange = false; break;
			case 'level': this._LevelHUDChange = false; break;
			default : this.allResetHUDchange();
		}
	}
};//*
if(HUDValid <= 0) Game_Actor.prototype.resetHUDchange = function(param){};


Game_Actor.prototype.allResetHUDchange = function(){
	this._HpHUDchange = false;
	this._MpHUDchange = false;
	this._TpHUDchange = false;
	this._ExpHUDchange = false;
	this._NameHUDChange = false;
	this._LevelHUDChange = false;
};//*
if(HUDValid <= 0) Game_Actor.prototype.allResetHUDchange = function(){};


Game_Actor.prototype.enableHUDchange = function(){
	return this._HpHUDchange || this._MpHUDchange || this._TpHUDchange ||
			this._ExpHUDchange || this._NameHUDChange || this._LevelHUDChange;
};//*
if(HUDValid <= 0) Game_Actor.prototype.enableHUDchange = function(){return false};


//パーティの所持金HUDに関する設定
Game_Party.prototype.permitHUDChange = function(value, param){
	if(ConfigManager[configHUD] && SceneManager._scene._goldHUDWindow){
		if(value !== 0) {
				switch(param){
					case 'gold' : this._GoldHUDchange = goldHUD.goldValid; break;
					default : this.allPermitHUDchange();
				}
		};
	}
};//*
if(HUDValid <= 0) Game_Party.prototype.permitHUDChange = function(value, param){};

Game_Party.prototype.allPermitHUDchange = function(){
	this._GoldHUDchange = goldHUD.goldValid;
};//*
if(HUDValid <= 0) Game_Party.prototype.allPermitHUDchange = function(){};


Game_Party.prototype.resetHUDchange = function(param){
	if(this.enableHUDchange()){
		switch(param){
			case 'hp' : this._GoldHUDchange = false; break;
			default : this.allResetHUDchange();
		}
	}
};//*
if(HUDValid <= 0) Game_Party.prototype.resetHUDchange = function(param){};


Game_Party.prototype.allResetHUDchange = function(){
	this._GoldHUDchange = false;
};//*
if(HUDValid <= 0) Game_Party.prototype.allResetHUDchange = function(){};


Game_Party.prototype.enableHUDchange = function(){
	return this._GoldHUDchange;
};//*
if(HUDValid <= 0) Game_Party.prototype.enableHUDchange = function(){return false};

//パーティのショートカットアイテムに関する設定
const _Game_Party_prototype_initAllItems = Game_Party.prototype.initAllItems;
Game_Party.prototype.initAllItems = function() {
    _Game_Party_prototype_initAllItems.apply(this, arguments);
    this._shortcutItem = null;
};//*


Game_Party.prototype.setShortcutItem = function(item){
	const isItem = DataManager.isItem(item);
	if(isItem) this._shortcutItem = item;
};//*
if(HUDValid <= 0) Game_Party.prototype.setShortcutItem = function(){};

Game_Party.prototype.shortcutItem = function(){
	return this._shortcutItem;
};//*
if(HUDValid <= 0) Game_Party.prototype.shortcutItem = function(){return null};

Game_Party.prototype.numShortcutItem = function(){
	return this.numItems(this.shortcutItem());
};//*
if(HUDValid <= 0) Game_Party.prototype.numShortcutItem = function(){return 0};

Game_Party.prototype.useShortcutItem = function(){
	const item = this.shortcutItem();
	if(item){
		const actor = this.leader();
		const action = new Game_Action(actor);
	    action.setItemObject(item);
	    if(!actor.checkVainRecover(item)){
	    		actor.useItem(item);
			    for (var i = 0; i < action.numRepeats(); i++) {
			        action.apply(actor);
		        }
			    item.effects.forEach(function(effect) {
			        if (effect.code === Game_Action.EFFECT_COMMON_EVENT) {
			            $gameTemp.reserveCommonEvent(effect.dataId, true);
			        }
			    });
	    }
	}
};//*


//---------------------------------------------//

class Window_GoldHUD extends Window_Gold{
		constructor(x, y){
			super(x, y);
			this._gold = $gameParty.gold() || 0;
		};//*

		update (){
			super.update();
			this.updateGold();
		};//*

		updateGold (){
			if(this._gold !== this.value()){
				if($gameParty.enableHUDchange())
					this.refresh();
			}
		};//*

		drawCurrencyValue (value, unit, x, y, width) {
			var unitWidth = Math.min(80, this.textWidth(unit));
		    this.resetTextColor();
		    this.updateMyGold(value);
			this.drawText(this._gold, x, y, width - unitWidth - 6, 'right');
		    this.changeTextColor(this.systemColor());
		    this.drawText(unit, x + width - unitWidth, y, unitWidth, 'right');
		};//*

		updateMyGold (value){
			const speed = windowHUD.gaugeSpeed;
			let difference = value - this._gold;
			if(difference < 0 ){
					difference = Math.floor(difference / speed);
					this._gold += difference;
					this._gold = Math.max(value, this._gold);
			}else if(difference > 0){
					difference = Math.ceil(difference / speed);
					this._gold += difference;
					this._gold = Math.min(value, this._gold);
			}else{
					this._gold = value;
					$gameParty.resetHUDchange('gold');
			}
		};//*
};//*Window_GoldHUD

	window[Window_GoldHUD.name] = Window_GoldHUD;

//weapon, shield, item 用のスーパークラス
class Window_EquipHUD extends Window_HorzCommand{
		constructor(x, y, index){
			super(x, y);
			this._slotId = index || this.slotId();
			this.deselect();
			if(MZ){
				//MZではhorzCommandWindowの幅と高さで初期化設定されるため、後から上書き
				this.width = this.windowWidth();
				this.height = this.windowHeight();
			}
			this.clearEquip();
		};//*

		slotId (){
			return 0;
		};//*

		isHandEquip (){
			return this.slotId() === 0 || this.slotId() === 1;
		};//*

		itemName (){
			return this._itemName;
		};//*

		setItemName (name){
			this._itemName = name;
		};//*

		itemIndex (){
			return 0; //itemHUDではオーバーライド
		};//*

		updateItemIndex(index){
			if(this._itemIndex !== index) this._itemIndex = index;
		};//*

		numItems (){
			return 1;
		};//*

		actor (){
			return $gameParty.leader();
		};//*

		actorEquip (){
			return this.actor().equips()[this.slotId()];	
		};//*

		meetsItemConditions(){};//* 各継承先で上書き

		equip (){
			return this._equip;
		};//*

		setEquip (){
			const equip = this.actorEquip();
			this._equip = equip ? equip : null;
		};//*

		clearEquip (){
			this._equip = null;
		};//*

		maxCols (){
			return 1;
		};//*

		windowWidth (){
			return 100;
		};//*

		windowHeight (){
			return 100;
		};//*

		contentsWidth (){
			return this.width - (MZ ? 0 : this.standardPadding() * 2);//MZでは余白はPatch管理
		};//*

		contentsHeight (){
			return this.height - (MZ ? 0 : this.standardPadding() * 2);
		};//*

		makeCommandList (){
			this.setEquip();
			if(this.equip()) this.addCommand(this.equip().name, 'equip', true);	
		};//*

		drawItem (index){
			const item = this.slotId() >= 0 ? this.equip() : this.equip()[this.itemIndex()];
			const rect = this.itemRectForText(index);
		    if(item){
		    	this.drawIcon(item.iconIndex, rect.x, rect.y);	
				this.drawEquipName(index, rect);

				if(this.isHandEquip() && item.meta.itemPossession){
					this.drawItemPossession(item, rect);
				}
			}
		};//*

		drawIcon (iconIndex, x, y){
			const bitmap = ImageManager.loadSystem('IconSet');
		    const pw = Window_Base._iconWidth;
		    const ph = Window_Base._iconHeight;
		    const sx = iconIndex % 16 * pw;
		    const sy = Math.floor(iconIndex / 16) * ph;

		    const adjustH = MZ ? (this.needName() ? this.lineHeight() : 0) : this.lineHeight();
		    const adjustRate = MZ ? 0.7 : (this.needName() ? 1 : 0.7);
		    const rate = Math.min(this.contentsWidth() /pw, (this.contentsHeight() - adjustH) / ph);
		    const dw = pw * rate * adjustRate;
		    const dh = ph * rate * adjustRate;
		    const dx = (this.contentsWidth() - dw) * 0.4;
		    const dy = (this.contentsHeight() - adjustH - dh) * 0.4;
		    this.contents.blt(bitmap, sx, sy, pw, ph, dx, dy, dw, dh);
		};//*

		drawEquipName (index, rect){
			this.resetTextColor();
			this.changePaintOpacity(this.isCommandEnabled(index));
		    const y = this.contentsHeight() - ( equipHUD ? equipHUD.nameBottomPosition : this.lineHeight() );
		    const align = this.itemTextAlign();

		    this.drawText(this.commandName(index), rect.x, y, rect.width, align);	
		};//*

		itemRectForText (index) {
		    const rect = this.itemRect(index);
		    rect.x += this.standardPadding();
		    if(MV) rect.width -= rect.x * 2;
		    rect.height = this.windowHeight();
		    return rect;
		};//*

		needName(){return true};// override in children

		drawItemPossession (item, rect){
			const meta = JSON.parse(item.meta.itemPossession);
			const id = Number(meta.id);
			const maxVid = Number(meta.maxVid);
			if(id <= 0 || maxVid <= 0) return;
			
			const targetItem = $dataItems[id];
			const possession = $gameParty.numItems(targetItem);
			const max = $gameVariables.value(maxVid);
			const maxColor = equipHUD.itemPossessionColor;

			const y = this.contentsHeight() - ( equipHUD ? equipHUD.itemBottomPosition : this.lineHeight() );
			const align = this.possessionAlign();
			if(max > 0){
				let width = rect.width;
				if(item.meta.reloadItem){
					const reloadItem = JSON.parse(item.meta.reloadItem);
					const reloadPossession = $gameParty.numItems($dataItems[reloadItem.id]);
					const maxText = ` / ${possession}`;
					const posWidth = align === 'left' ? this.textWidth(reloadPossession) : 0;
					const maxVWidth = align === 'right' ? this.textWidth(maxText) : 0;

					this.drawText(maxText, rect.x + posWidth, y, width - posWidth, align);
					if(reloadPossession === max) this.changeTextColor(maxColor);
					this.changePaintOpacity(possession);
					this.drawText(reloadPossession, rect.x, y, width - maxVWidth, align);
					this.setPartyNumItems(reloadPossession);
				}else{
					const maxText = ` / ${max}`;
					const posWidth = align === 'left' ? this.textWidth(possession) : 0;
					const maxVWidth = align === 'right' ? this.textWidth(maxText) : 0;

					this.drawText(maxText, rect.x + posWidth, y, width - posWidth, align);
					if(possession === max) this.changeTextColor(maxColor);
					this.changePaintOpacity(possession);
					this.drawText(possession, rect.x, y, width - maxVWidth, align);
					this.setPartyNumItems(possession);
				}
				this.resetTextColor();
			}else{
				this.changePaintOpacity(possession);
				this.drawText(possession, rect.x, y, rect.width, align);
				this.setPartyNumItems(possession);
			}
		};//*

		standardFontSize (){
			return equipHUD ? equipHUD.fontSize : 18;
		};//*

		standardPadding (){
			if(!equipHUD) return 4;

			const basePadding = equipHUD.mainPadding >= 0 ? equipHUD.mainPadding : 4;
			const isLarger = this.windowWidth() >  Window_Base._iconWidth + basePadding * 2;
			return isLarger ? equipHUD.mainPadding : equipHUD.subPadding;
		};//*

		lineHeight (){
			return MZ ? super.lineHeight() : (this.needName() ? super.lineHeight() : 1);
		};//*

		possessionAlign (){
			return 'right';
		};//*

		activate(){}; //don't activate

		update (){
			if(this.equip() !== this.actorEquip()) {
				//super.update();
				this.refresh();
			}
		};//*

		setPartyNumItems (num){
			if(this._partyNumItems >= 0){
				this._partyNumItems = num || 0;
			}else{
				this._partyNumItems = 0;
			}
		};//*
}////Window_EquipHUD

	window[Window_EquipHUD.name] = Window_EquipHUD;

class Window_WeaponHUD extends Window_EquipHUD{
		constructor(x, y, index){
			super(x, y, index);
		};//*

		windowWidth (){
			const hud = equipHUD.weaponHUD;
			return hud && hud.width >= 0 ? hud.width : 100;
		};//*

		windowHeight (){
			const hud = equipHUD.weaponHUD;
			return hud && hud.height >= 0 ? hud.height : 100;
		};//*

		drawEquipName (index, rect){
			if(this.needName()) super.drawEquipName(index, rect);
		};//*

		needName (){
			return equipHUD.weaponHUD.displayName;
		};//*

		update(){
			const item = this.equip();
			if(item && item.meta.itemPossession){
				if(item.meta.reloadItem){
					const meta = JSON.parse(item.meta.reloadItem);
					const id = Number(meta.id);

					if(id > 0 && this._partyNumItems !== $gameParty.numItems($dataItems[id])){
						this.refresh();
					}
				}else{
					const meta = JSON.parse(item.meta.itemPossession);
					const id = Number(meta.id);

					if(id > 0 && this._partyNumItems !== $gameParty.numItems($dataItems[id])){
						this.refresh();
					}
				}
			}else{
				super.update();
			}
		};//*
};//*Window_WeaponHUD

	window[Window_WeaponHUD.name] = Window_WeaponHUD;

class Window_ShieldHUD extends Window_EquipHUD{
		constructor(x, y, index){
			super(x, y, index);
		};//*

		slotId (){
			return 1;
		};//*

		windowWidth (){
			const hud = equipHUD.shieldHUD;
			return hud && hud.width >= 0 ? hud.width : 100;
		};//*

		windowHeight (){
			const hud = equipHUD.shieldHUD;
			return hud && hud.height >= 0 ? hud.height : 100;
		};//*

		drawEquipName (index, rect){
			if(this.needName()) super.drawEquipName(index, rect);
		};//*

		needName (){
			return equipHUD.shieldHUD.displayName;
		};//*

		possessionAlign (){
			return 'left';
		};//*

		update(){
			const item = this.equip();
			if(item && item.meta.itemPossession){
				const meta = JSON.parse(item.meta.itemPossession);
				const id = Number(meta.id);
				if(id > 0 && this._partyNumItems !== $gameParty.numItems($dataItems[id])){
					this.refresh();
				}
			}else{
				super.update();
			}
		};//*
};//*Window_ShieldHUD

	window[Window_ShieldHUD.name] = Window_ShieldHUD;

class Window_ArmorHUD extends Window_EquipHUD{
		constructor(x, y, index){
			super(x, y, index);
		};//*

		slotId (){
			return this._slotId;
		};//*

		windowWidth (){
			const hud = equipHUD.armorHUD;
			return hud && hud.width >= 0 ? hud.width : 50;
		};//*

		windowHeight (){
			const hud = equipHUD.armorHUD;
			return hud && hud.height >= 0 ? hud.height : 50;
		};//*

		drawEquipName (index, rect){
			if(this.needName()) super.drawEquipName(index, rect);
		};//*

		needName (){
			return equipHUD.armorHUD.displayName;
		};//*
};//*Window_ArmorHUD

	window[Window_ArmorHUD.name] = Window_ArmorHUD;


class Window_ItemHUD extends Window_EquipHUD{
		constructor(x, y, index){
			super(x, y, index);
		};//*

		slotId (){
			return -1;
		};//*

		actorEquip (){
			let items = $gameParty.items().filter(item => {return this.meetsItemConditions(item)});
				items = this.sortEquips(items);
			return items;
		};//*

		meetsItemConditions (item){
			return item.occasion < 3 && !$gameSystem.exceptedShortcutItem(item);
		};//*

		sortEquips (items){
			switch($gameSystem.currentSortType()){
				case 'name' : items = this.sortByName(items); break;
				case 'newGet' : items = this.sortByNewGet(items); break;
			}
			return items;
		};//*

		sortByName (list){
			const isJa = $gameSystem.isJapanese();
			const locales = sortWindow.namingLocale || (isJa ? 'ja' : 'en');
			list.sort((item1, item2) => {
				let name1 = item1.meta.sortName ? item1.meta.sortName : item1.name;
				let name2 = item2.meta.sortName ? item2.meta.sortName : item2.name;
				return name1.localeCompare(name2, locales);
			});
			return list;
		};//*

		sortByNewGet (list){
			const container = $gameSystem.includesCategory('item');
			list.sort((item1, item2) => {
				let item1GetId = container[item1.id];
				let item2GetId = container[item2.id];
				return item1GetId - item2GetId;
			});
			return list;
		};//*

		itemSubHUDWindow (){
			return this._itemSubHUDWindow;
		};//*

		setItemSubHUDWindow (itemSubHUDWindow){
			if(itemSubHUDWindow) this._itemSubHUDWindow = itemSubHUDWindow;
		};//*

		itemThirdHUDWindow (){
			return this._itemThirdHUDWindow;
		};//*

		setItemThirdHUDWindow (itemThirdHUDWindow){
			if(itemThirdHUDWindow) this._itemThirdHUDWindow = itemThirdHUDWindow;
		};//*

		windowWidth (){
			const hud = equipHUD.itemHUD;
			return hud && hud.width >= 0 ? hud.width : 80;
		};//*

		windowHeight (){
			const hud = equipHUD.itemHUD;
			return hud && hud.height >= 0 ? hud.height : 80;
		};//*

		numItems (){
			return !!this.equip() ? this.equip().length : 0;
		};//*

		itemIndex (){
			if(!this.equip())  return -1;
			let index = this.equip().findIndex(item => {return item.name === this.itemName()});
			return index;
		};//*

		makeCommandList(){
			this.updateItemName();
			const equip = this.equip()[this.itemIndex()];
			if(equip) {
				this.addCommand(equip.name, 'equip', true);
				this.setShortcutItem(equip);
				this.updateChildrenWindows();
			}
		};//*

		drawItem (index){
			super.drawItem(index);

			if(this.slotId() === -1){
				const num = $gameParty.numItems(this.equip()[this.itemIndex()]);
				const y = this.contentsHeight() - ( equipHUD ? equipHUD.itemBottomPosition : this.lineHeight() );
				const width = this.contentsWidth() - this.standardPadding() * (MZ ? 4 : 2);
				const position = equipHUD ? equipHUD.possessionPosition : 'right';
				this.drawText(num, 0, y, width, position);
				this.setPartyNumItems(num);
			}
		};//*

		drawEquipName (index, rect){
			if(this.needName()) super.drawEquipName(index, rect);
		};//*

		needName (){
			return equipHUD.itemHUD.displayName;
		};//*

		update (){
			if(this._equip){
				if(this.equip().length !== this.actorEquip().length){
					this.updateItemName();
					super.update();
					return;
				}

				const equip = this.equip()[this.itemIndex()];
				if(equip !== this.actorEquip()[this.itemIndex()]) {
					super.update();
				}else if(this._partyNumItems !== $gameParty.numItems(equip) ){
					super.update();
					this.setPartyNumItems($gameParty.numItems(equip));
				}
			}else if(this.actorEquip().length > 0){
				super.update();
				this.setShortcutItem($gameParty.shortcutItem() || this.equip()[0]);
			}
		};//*

		updateItemName (){
			this.setEquip();
			if(this.equip().length === 0){
				this.setItemName('');
			}else{
				if(!this.itemName()){
					const id = Math.abs(this.slotId()) - 1;
					const equip = this.equip()[id];
					const pi = $gameParty.shortcutItem();
					const name = pi ? pi.name : (equip ? equip.name : '');
					this.setItemName(name);
					this.updateItemIndex(id);
				}else{
					const item = this.equip()[this.itemIndex()];
					if(item){
						this.updateItemIndex(this.itemIndex());
					}else{
						const nextId = this._itemIndex % this.numItems();
						const item = this.equip()[nextId];
						this.setItemName(item.name);
						this.updateItemIndex(nextId);
					}
				}
			}
			this.updateChildrenWindows();
		};//*

		updateChildrenWindows (){
			if(this.itemSubHUDWindow()) this.itemSubHUDWindow().refresh();
			if(this.itemThirdHUDWindow()) this.itemThirdHUDWindow().refresh();
		};//*

		setShortcutItem (item){
			if(this.slotId() === -1) $gameParty.setShortcutItem(item);
		};//*

		nextItem(){
			const num = this.numItems();
			if(num > 1){
				const nextId = ( this.itemIndex() + 1 ) % num;
				const item = this.equip()[nextId];
				this.setItemName(item.name);
				this.refresh();
			}
		};//*

		previousItem(){
			if(equipHUD && equipHUD.itemThirdType === 'carousel'){
				const num = this.numItems();
				if(num > 1){
					const preId = ( this.itemIndex() - 1 + num ) % num;
					const item = this.equip()[preId];
					this.setItemName(item.name);
					this.refresh();
				}
			}
		};//*
};//*Window_ItemHUD

	window[Window_ItemHUD.name] = Window_ItemHUD;

class Window_ItemSubHUD extends Window_ItemHUD{
		constructor(x, y, index){
			super(x, y, index);
		};//*

		itemHUDWindow (){
			return this._itemHUDWindow;
		};//*

		setItemHUDWindow (itemHUDWindow){
			if(itemHUDWindow) this._itemHUDWindow = itemHUDWindow;
		};//*

		slotId (){
			return -2;
		};//*

		itemIndex (){
			const num = this.numItems();
			if(num < Math.abs(this.slotId())) return -1;
			if(!this.itemHUDWindow()) return -1;

			const index = this.itemHUDWindow().itemIndex();
			return (index + 1) % num;
		};//*

		windowWidth (){
			const hud = equipHUD.itemSubHUD;
			return hud && hud.width >= 0 ? hud.width : 40;
		};//*

		windowHeight (){
			const hud = equipHUD.itemSubHUD;
			return hud && hud.height >= 0 ? hud.height : 40;
		};//*

		needName (){
			return equipHUD.itemSubHUD.displayName;
		};//*

		standardPadding (){
			return equipHUD ? equipHUD.subPadding : 0;
		};//*

		update (){
			if(this.actorEquip().length > Math.abs(this.slotId())){
				super.update();
			}
		};//*
};//*Window_ItemSubHUD
	
	window[Window_ItemSubHUD.name] = Window_ItemSubHUD;

class Window_ItemThirdHUD extends Window_ItemSubHUD{
		constructor(x, y, index){
			super(x, y, index);
		};//*

		slotId (){
			return -3;
		};//*

		windowWidth (){
			const hud = equipHUD.itemThirdHUD;
			return hud && hud.width >= 0 ? hud.width : 40;
		};//*

		windowHeight (){
			const hud = equipHUD.itemThirdHUD;
			return hud && hud.height >= 0 ? hud.height : 40;
		};//*

		itemIndex (){
			const num = this.numItems();
			if(num < Math.abs(this.slotId())) return -1;
			if(!this.itemHUDWindow()) return -1;

			const param = equipHUD ? equipHUD.itemThirdType : 'list';
			const index = this.itemHUDWindow().itemIndex();
			const adjust = param === 'list' ? 2 : -1 + num;
			return (index + adjust) % num;
		};//*

		needName (){
			return equipHUD.itemThirdHUD.displayName;
		};//*
};//*Window_ItemThirdHUD
	
	window[Window_ItemThirdHUD.name] = Window_ItemThirdHUD;


class Window_HUD extends Window_Base {
		constructor (x, y, width, height, memberId){
			super(x, y, width, height);
			this._enableRedraw = 0;
			if(memberId === 0){
					this._actor = $gameParty.leader();
			}else{
					this._actor = $gameParty.allMembers()[memberId];
			};

			this.currentHp = this._actor.hp;
			this.currentRedHp = this._actor.hp;
			this.currentMp = this._actor.mp;
			this.currentTp = this._actor.tp;
			this.currentExp = this._actor.currentExp() - this._actor.currentLevelExp();
			this.currentNextExp = this._actor.nextLevelExp() - this._actor.currentLevelExp();
			this.currentLevel = this._actor.level;
			this.buryingLevel = false;
			this.hpDamageMovable = true;
			this.hpDecreaseWait = 0;
		};//*

		standardPadding (){
			return windowHUD.padding || 18;
		};//*

		standardFontSize (){
			return windowHUD.fontSize || 28;
		};//*

		lineHeight (){
			return this.standardFontSize() + 3;
		};//*

		setBackgroundType (){
			const type = windowHUD.background;
			super.setBackgroundType(type);
		};//*

		update (){
			super.update();
			this.updateGauge();
		};//*

		updateGauge (){
			if(this._enableRedraw === 0){
				if(this._actor.enableHUDchange()){
					this.contents.clear();
					this.drawContents();
					this._enableRedraw = windowHUD.updateFrame;
				}	
			}else{
					this._enableRedraw --;
					if(this._enableRedraw <= 0){
							this._enableRedraw = 0;
					}
			}
		};//*

		drawContents (){
			const nameWidth = this.getMaxNameWidth();
			const width = this.contentsWidth();
			switch(windowHUD.rcType){
				case 'row' 	: this.drawVerticalContents(width, nameWidth); break;
				case 'col' 	: this.drawHorizontalContents(width); break;
				default 	: this.drawVerticalContents(width, nameWidth);
			}
		};//*

		getMaxNameWidth (){
			if(windowHUD.gaugeName){
					const hp = windowHUD.hpValid ? TextManager.hpA : ' ';
					const mp = windowHUD.mpValid ? TextManager.mpA : ' ';
					const tp = windowHUD.tpValid ? TextManager.tpA : ' ';
					const exp = windowHUD.actorExp ? TextManager.expA : ' ';
					return Math.max(this.textWidth(hp), this.textWidth(mp), this.textWidth(tp), this.textWidth(exp));
			}
		};//*

		drawVerticalContents (width, nameWidth){
			let row = 0;
			if(windowHUD.actorName){
					this.drawActorName(this._actor, 0 , this.lineHeight() * row, width)
					if(windowHUD.actorLevel){
							this.drawActorLevel(this._actor, 0, this.lineHeight() * row);
					}
					row ++;
			};
			if(windowHUD.hpValid){
					if(!windowHUD.decreaser){
						this.drawActorDamageHp(this._actor, 0, this.lineHeight() * row, width, nameWidth);
					}
					this.drawActorHp(this._actor, 0, this.lineHeight() * row, width, nameWidth);
					row ++;
			};
			if(windowHUD.mpValid){
					this.drawActorMp(this._actor, 0, this.lineHeight() * row, width, nameWidth);
					row ++;
			};
			if(windowHUD.tpValid){
					this.drawActorTp(this._actor, 0, this.lineHeight() * row, width, nameWidth);
					row ++;
			};
			if(windowHUD.actorExp){
					this.drawActorExp(this._actor, 0, this.lineHeight() * row, width, nameWidth);
					row ++;
			}
			this.drawActorIcons(this._actor, 0, this.lineHeight() * row, width);
		};//*

		drawHorizontalContents (width){
			let row = 0;
			let newStart = 0;
			let nameWidth = this.getNameWidth(width);
			let hpWidth = this.getHpWidth(width);
			let mpWidth = this.getMpWidth(width);
			let tpWidth = this.getTpWidth(width);
			let expWidth = this.getExpWidth(width);
			if(windowHUD.actorName){
					this.drawActorName(this._actor, newStart, this.lineHeight() * row, nameWidth);
					newStart += (nameWidth + this.standardFontSize());
			};

			if(windowHUD.actorLevel){
					this.drawActorLevel(this._actor, newStart, this.lineHeight() * row);
					newStart += ( nameWidth + this.standardFontSize() );
			}

			if(windowHUD.actorExp){
					this.drawActorExp(this._actor, newStart, this.lineHeight() * row, expWidth); 	
			};
							
			newStart = 0;
			row ++;

			if(windowHUD.hpValid){
					if(!windowHUD.decreaser){
						this.drawActorDamageHp(this._actor, newStart, this.lineHeight() * row, hpWidth);
					}
					this.drawActorHp(this._actor, newStart, this.lineHeight() * row, hpWidth);
					newStart += (hpWidth + this.standardFontSize());
			};

			if(windowHUD.mpValid){
					this.drawActorMp(this._actor, newStart, this.lineHeight() * row, mpWidth);
					newStart += (mpWidth + this.standardFontSize());
			};

			if(windowHUD.tpValid){
					this.drawActorTp(this._actor, newStart, this.lineHeight() * row, tpWidth);
			};

			newStart = 0;
			row ++;
			this.drawActorIcons(this._actor, newStart, this.lineHeight() * row, width);
		};//*

		getNameWidth (width){
			if(!windowHUD.actorName){
					return 0;
			}else{
					return Math.floor(width / 6);
			}
		};//*
				
		getHpWidth (width){
			if(!windowHUD.hpValid){
					return 0;
			}else{
					if(windowHUD.mpValid && windowHUD.tpValid){
							return Math.floor(width / 3) - this.standardFontSize();
					}else if(windowHUD.mpValid || windowHUD.tpValid){
							return Math.floor(width / 2) - this.standardFontSize();
					}else{
							return width - this.standardFontSize() - this.getNameWidth();
					}
			};
		};//*

		getMpWidth (width){
			if(!windowHUD.mpValid){
					return 0;
			}else{
					if(windowHUD.hpValid && windowHUD.tpValid){
							return Math.floor(width / 4) - this.standardFontSize();
					}else if(windowHUD.hpValid){
							return Math.floor(width / 2) - this.getNameWidth() - this.standardFontSize();
					}else if(windowHUD.tpValid){
							return Math.floor((width - this.getNameWidth())/ 2) - this.standardFontSize();
					}else{
							return width - this.getNameWidth() - this.standardFontSize();
					}
			};
		};//*

		getTpWidth (width){
			if(!windowHUD.tpValid){
					return 0;
			}else{
				if(windowHUD.hpValid && windowHUD.mpValid){
						return Math.floor(width / 4) - this.standardFontSize();
				}else if(windowHUD.hpValid){
						return Math.floor(width / 2) - this.getNameWidth() - this.standardFontSize();
				}else if(windowHUD.mpValid){
						return Math.floor((width - this.getNameWidth())/ 2) - this.standardFontSize();
				}else{
						return width - this.getNameWidth() - this.standardFontSize();
				};
			};
		};//*

		getExpWidth (width){
			if(!windowHUD.actorExp){
					return 0;
			}else{
					return width - this.getNameWidth();
			};
		};//*

		drawActorLevel (actor, x, y) {
			let width = this.width;
			const tWidth = this.textWidth('0000');
			switch(windowHUD.rcType){
				case 'row' 	: width = this.contentsWidth() - tWidth; break;
				case 'col' 	: width = this.getNameWidth(width) - tWidth; break;
				default 	: width = this.contentsWidth() - tWidth; break;
			} 
			this.changeTextColor(this.systemColor());
			this.drawText(TextManager.levelA, x, y, width, 'right');
		    this.resetTextColor();
		    const level = this.buryingLevel ? this.currentLevel : actor.level;
		    this.drawText(level, x , y, width + tWidth, 'right');
		};//*

		gaugeMovable (windowCurrent, actorCurrent){
			windowCurrent = windowCurrent ? windowCurrent : 0;
			return windowCurrent !== actorCurrent;
		};//*

		drawActorHp (actor, x, y, width, nameWidth){
			const noback = !windowHUD.decreaser;
			width = width || 186;
			nameWidth = nameWidth ? nameWidth : this.textWidth(' ' + TextManager.hpA);
			var color1 = this.hpGaugeColor1();
			var color2 = this.hpGaugeColor2();
					
			if(this.gaugeMovable(this.currentHp, actor.hp)){
					this.drawGauge(x + nameWidth, y, width - nameWidth,
					    				 this.hpRate(actor, false), color1, color2, noback);
				    this.changeTextColor(this.systemColor());
				    this.drawText(TextManager.hpA, x, y, 44);
				    this.drawCurrentAndMax(this.currentHp, actor.mhp, x, y, width,
					                           this.hpColor(actor), this.normalColor());
				    this.updateCurrentHp(this.currentHp, actor);	
			}else{
					this.drawGauge(x + nameWidth, y, width - nameWidth,
					    				 actor.hpRate(), color1, color2, noback);
				    this.changeTextColor(this.systemColor());
				    this.drawText(TextManager.hpA, x, y, 44);
				    this.drawCurrentAndMax(actor.hp, actor.mhp, x, y, width,
					                           this.hpColor(actor), this.normalColor());
				    this.damageCheck();
				    if(windowHUD.decreaser) this._actor.resetHUDchange('hp');
			}
		};//*

		damageCheck (){
			if(this.currentHp !== this.currentRedHp){
					if(!windowHUD.decreaser && !this.hpDamageMovable && this.hpDecreaseWait === 0){
				    		this.hpDecreaseWait = windowHUD.gaugeSpeed
			    	}
			    	this.hpDamageMovable = true;
			};
		};//*

		drawActorDamageHp (actor, x, y, width, nameWidth){
			width = width || 186;
			nameWidth = nameWidth ? nameWidth : this.textWidth(' ' + TextManager.hpA);
			var color1 = this.deathColor();
			var color2 = this.deathColor();
					
			if(this.hpDamageMovable && this.gaugeMovable(this.currentRedHp, actor.hp)){	
				    this.drawGauge(x + nameWidth, y, width - nameWidth,
					    				 this.hpRate(actor, true), color1, color2);
				    this.updateCurrentHp(this.currentRedHp, actor, true);	
			}else{
				    this.drawGauge(x + nameWidth, y, width - nameWidth,
					    				 this.hpRate(actor, true), color1, color2);
				    if(this.hpDamageMovable){
				   		this.hpDamageMovable = false;
				    	this._actor.resetHUDchange('hp'); 	
				    }
			}
		};//*

		hpRate (actor, redGauge){
			const current = redGauge ? this.currentRedHp : this.currentHp;
			return current / actor.mhp;
		};//*

		updateCurrentHp (windowHp, actor, redGauge){
			let speed = windowHUD.gaugeSpeed;
			let difference = actor.hp - windowHp;

			if(redGauge && this.hpDecreaseWait === 0){		
					if(difference < 0){
							difference = Math.floor(difference / speed);
							this.currentRedHp += difference;
							this.currentRedHp = Math.max(actor.hp, this.currentRedHp);	
					}else if(difference > 0){
							difference = Math.ceil(difference / speed);
							this.currentRedHp += difference;
							this.currentRedHp = Math.min(actor.hp, this.currentRedHp);
					}else{
							this.currentRedHp = actor.hp;
					};
			}else{
				if(difference < 0){
						if(!windowHUD.decreaser){
								difference = actor.hp - windowHp;
						}else{
								difference = Math.floor(difference / speed);
						};
						this.currentHp += difference;
						this.currentHp = Math.max(actor.hp, this.currentHp);	
				}else if(difference > 0){

						difference = Math.ceil(difference / speed);
						this.currentHp += difference;
						this.currentHp = Math.min(actor.hp, this.currentHp);
				}else{
						this.currentHp = actor.hp;
				}
			};
			this.updateDecreaseWait();
		};//*

		updateDecreaseWait (){
			if(this.hpDecreaseWait > 0){
					this.hpDecreaseWait --;
					if(this.hpDecreaseWait <= 0){
							this.hpDecreaseWait = 0;
					}
			}
		};//*

		drawActorMp (actor, x, y, width, nameWidth){
			width = width || 186;
			nameWidth = nameWidth ? nameWidth : this.textWidth(' ' + TextManager.mpA);
			var color1 = this.mpGaugeColor1();
			var color2 = this.mpGaugeColor2();

			if(this.gaugeMovable(this.currentMp, actor.mp)){
				    this.drawGauge(x + nameWidth, y, width - nameWidth,
					    				 this.mpRate(actor), color1, color2);
				    this.changeTextColor(this.systemColor());
				    this.drawText(TextManager.mpA, x, y, 44);
				    this.drawCurrentAndMax(this.currentMp, actor.mmp, x, y, width,
					                           this.mpColor(actor), this.normalColor());
				    this.updateCurrentMp(this.currentMp, actor);
			}else{
				    this.drawGauge(x + nameWidth, y, width - nameWidth,
					    				 actor.mpRate(), color1, color2);
				    this.changeTextColor(this.systemColor());
				    this.drawText(TextManager.mpA, x, y, 44);
				    this.drawCurrentAndMax(actor.mp, actor.mmp, x, y, width,
					                           this.mpColor(actor), this.normalColor());
				    this._actor.resetHUDchange('mp');
			}
		};//*

		mpRate (actor){
			return this.currentMp / actor.mmp;
		};//*

		updateCurrentMp (windowMp, actor){
			let speed = windowHUD.gaugeSpeed;
			let difference = actor.mp - windowMp;
	
			if(difference < 0){
					difference = Math.floor(difference / speed);
					this.currentMp += difference;
					this.currentMp = Math.max(actor.mp, this.currentMp);
			}else if(difference > 0){
					difference = Math.ceil(difference / speed);
					this.currentMp += difference;
					this.currentMp = Math.min(actor.mp, this.currentMp);
			}else{
					this.currentMp = actor.mp;
			}
		};//*

		drawActorTp (actor, x, y, width, nameWidth){
			width = width || 96;
			nameWidth = nameWidth ? nameWidth : this.textWidth(' ' + TextManager.tpA);
			var color1 = this.tpGaugeColor1();
			var color2 = this.tpGaugeColor2();

			if(this.gaugeMovable(this.currentTp, actor.tp)){
					this.drawGauge(x + nameWidth, y, width - nameWidth,
					    				 this.tpRate(actor), color1, color2);
				    this.changeTextColor(this.systemColor());
				    this.drawText(TextManager.tpA, x, y, 44);
				    this.changeTextColor(this.tpColor(actor));
				    this.drawCurrentAndMax(this.currentTp, actor.maxTp(), x , y, width,
					    					this.tpColor(actor), this.normalColor());
				    this.updateCurrentTp(this.currentTp, actor);
			}else{
					this.drawGauge(x + nameWidth, y, width - nameWidth,
					    				 actor.tpRate(), color1, color2);
				    this.changeTextColor(this.systemColor());
				    this.drawText(TextManager.tpA, x, y, 44);
				    this.changeTextColor(this.tpColor(actor));
				    this.drawCurrentAndMax(actor.tp, actor.maxTp(), x , y, width,
					    					this.tpColor(actor), this.normalColor());
				    this._actor.resetHUDchange('tp');
			}
		};//*

		tpRate(actor){
			return this.currentTp / actor.maxTp();
		};//*

		updateCurrentTp (windowTp, actor){
			let speed = windowHUD.gaugeSpeed;
			let difference = actor.tp - windowTp;
							
			if(difference < 0){
					difference = Math.floor(difference / speed);
					this.currentTp += difference;
					this.currentTp = Math.max(actor.tp, this.currentTp);	
			}else if(difference > 0){
					difference = Math.ceil(difference / speed);
					this.currentTp += difference;
					this.currentTp = Math.min(actor.tp, this.currentTp);
			}else{
					this.currentTp = actor.tp;
			}
		};//*

		drawActorExp (actor, x, y, width, nameWidth){
			width = width || 186;
			nameWidth = nameWidth ? nameWidth : this.textWidth(' ' + TextManager.exp);
			var color1 = this.tpGaugeColor1();
			var color2 = this.tpGaugeColor2();

			if( this.gaugeMovable(this.currentExp, this.currentActorExp(actor)) || this.buryingLevel ){

					this.drawGauge(x + nameWidth, y, width - nameWidth,
					    				 this.expRate(), color1, color2);
				   	this.changeTextColor(this.systemColor());
				    this.drawText(TextManager.expA, x, y, 44);
				    this.resetTextColor();
				    this.drawCurrentAndMax(this.currentExp, this.currentNextExp, x , y, width,
					    					this.normalColor(), this.normalColor(), 'exp');
				    this.updateCurrentExp(this.currentExp, actor);
			}else{
					this.drawGauge(x + nameWidth, y, width - nameWidth,
				    				 this.expRate(), color1, color2);
				   	this.changeTextColor(this.systemColor());
				    this.drawText(TextManager.expA, x, y, 44);
				    this.resetTextColor();
				    this.drawCurrentAndMax(this.currentExp, this.currentNextExp, x , y, width,
				    					this.normalColor(), this.normalColor(), 'exp');
				    this.setNextExp(actor);
				    //this.updateCurrentExp(this.currentExp, actor, true);
				    this._actor.resetHUDchange('exp');
			}
		};//*

		currentActorExp (actor){
			return actor.currentExp() - actor.currentLevelExp();
		};//*

		setNextExp (actor){
			this.currentNextExp = actor.nextLevelExp() - actor.currentLevelExp();
		};//*

		expRate (){
			return this.currentExp / this.currentNextExp;
		};//*

		updateCurrentExp (windowExp, actor){
			if(actor.level - this.currentLevel >= 1){
					this.buryingLevel = true;
					this.updateBuryLevel(windowExp, actor);
			}else{
					this.buryingLevel = false;
					let speed = windowHUD.gaugeSpeed;
					let difference =　this.currentActorExp(actor) - windowExp;
					if(difference < 0){
						let newDifference = Math.ceil( (this.currentNextExp - windowExp) / speed );
						this.currentExp = newDifference > 0 ? this.currentExp + newDifference : 0;
						this.currentExp = Math.min(actor.currentLevelExp(), this.currentExp);	
					}else if(difference > 0){
						difference = Math.ceil(difference / speed);
						this.currentExp += difference;
						this.currentExp = Math.min(this.currentNextExp, this.currentExp);
					}else{
						this.currentExp = this.currentActorExp(actor);
						//this.setNextExp(actor);
					}
			};	
		};//*

		updateBuryLevel (windowExp, actor){
			let speed = windowHUD.gaugeSpeed;
			let nextRequiredExp = actor.expForLevel(this.currentLevel + 1) - actor.expForLevel(this.currentLevel);
			let difference = nextRequiredExp - windowExp;
			if(difference < 0){
					difference = Math.floor( difference / speed ) * (actor.level - this.currentLevel);
					this.currentExp -= difference;
					this.currentExp = Math.min(nextRequiredExp, this.currentExp);	
			}else if(difference > 0){
					difference = Math.ceil(difference / speed) * (actor.level - this.currentLevel);
					this.currentExp += difference;
					this.currentExp = Math.min(nextRequiredExp, this.currentExp);
			}else{
					this.currentLevel ++;
					this.currentExp = windowExp - nextRequiredExp;
					this.currentNextExp = actor.expForLevel(this.currentLevel + 1) - actor.expForLevel(this.currentLevel)
					//this.setNextExp(actor);
			}
		};//*

		drawGauge (x, y, width, rate, color1, color2, noBack) {
			var fillW = Math.floor(width * rate);
		    var gaugeY = y + this.lineHeight() - 8;
		    if(!noBack){
			    	this.contents.fillRect(x, gaugeY, width, 6, this.gaugeBackColor());	
		    }
		    this.contents.gradientFillRect(x, gaugeY, fillW, 6, color1, color2);
		};//*

		drawCurrentAndMax (current, max, x, y, width, color1, color2, type) {
			if(!windowHUD.gaugeNowMax){return};

		 	var labelWidth = this.textWidth('HP');
		    var valueWidth = type === 'exp' ? this.textWidth(max) : this.textWidth('0000');
		    var slashWidth = this.textWidth('/');
			var x1 = x + width - valueWidth;
		    var x2 = x1 - slashWidth;
		    var x3 = x2 - valueWidth;
		    if (x3 >= x + labelWidth || type === 'exp') {
			        this.changeTextColor(color1);
			        this.drawText(current, x3, y, valueWidth, 'right');
			        this.changeTextColor(color2);
			        this.drawText('/', x2, y, slashWidth, 'right');
			        this.drawText(max, x1, y, valueWidth, 'right');
		    } else {
			        this.changeTextColor(color1);
			        this.drawText(current, x1, y, valueWidth, 'right');
		    }
		};//*

		drawActorIcons (actor, x, y, width) {
		    width = width || this.contentsWidth();
		    const iw = Window_Base._iconWidth;
		    const ih = Window_Base._iconHeight;
		    var icons = actor.allIcons().slice(0, Math.floor(width / iw));
		    const steps = actor.iconSteps();
		    const buffTurns = actor.iconBuffTurns();
		    for (var i = 0; i < icons.length; i++) {
		    	const x2 = x + Window_Base._iconWidth * i
		        this.drawIcon(icons[i], x2, y + 2);
		        this.contents.fontSize -= this.iconTurnSize();
		        this.drawIconTurn(i, actor, x2, y, iw, ih, steps, buffTurns);
		        this.contents.fontSize += this.iconTurnSize();
		    };
		};//*

		drawIcon (iconIndex, x, y){
			var bitmap = ImageManager.loadSystem('IconSet');
		    var pw = Window_Base._iconWidth;
		    var ph = Window_Base._iconHeight;
		    var sx = iconIndex % 16 * pw;
		    var sy = Math.floor(iconIndex / 16) * ph;
		    this.contents.blt(bitmap, sx, sy, pw, ph, x, y, pw * 3/4, ph * 3/4);
		};//*

		iconTurnSize (){
			return 4;
		};//*

		drawIconTurn (index, actor, x, y, iw, ih, steps, buffTurns){
			let limit = windowHUD.limitSteps >= 0 ? windowHUD.limitSteps : 10;
			let times = states.removeStateContinuously ? 60 : 1;
			limit *= times;

		    if(index < steps.length){
		    	let id = steps[index].id;
		       	if(actor._stateSteps[id] <= limit){
		        	let second = Math.ceil(actor._stateSteps[id]/times);
		        	this.drawText(second, x, y + ih * 3/4, iw, 'center');
		        }	
	    	}else{
		       	if(buffTurns[index - steps.length] <= limit){
		       		let second = Math.ceil(buffTurns[index - steps.length]/times);
		        	this.drawText(second, x, y + ih * 3/4, iw,'center');
	        	}
	        }
		};//*
};//*Window_HUD

	window[Window_HUD.name] = Window_HUD;

Game_Actor.prototype.iconSteps = function(){
	return this.states().filter(state => {return state.iconIndex > 0});
};//*

Game_Actor.prototype.iconBuffTurns = function(){
	let buffs = [];
    for (var i = 0; i < this._buffs.length; i++) {
        if (this._buffs[i] !== 0) {
            buffs.push(this._buffTurns[i]);
        }
    }
    return buffs;
};//*

//--------------------------HUDに関する設定　end-----------------------------//


/********************************************************************************************/
/*-------------------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------------------*/
/********************************************************************************************/


/*------------structing Movement--------------------------------------------
						移動に関する設定

						 ___ 		  ___ 	 		 ___ 		 _____
				|\ 	/| 	|	| \	   / | 		|\	/| 	| 	  |\  |    |
				| \/ | 	|	|  \  /	 |--- 	| \/ | 	|---  | \ |    |
				|	 | 	|___| 	\/	 |___ 	|	 | 	|___  |  \|    |
	-----------------------------------------------------------------------*/

/********************************************************************************************/
/*-------------------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------------------*/
/********************************************************************************************/

		/*~struct~FieldBasic:ja
			@param 	valid
			@type 		boolean
			@text 		移動強化の有効化
			@desc 		On（true）の時、以下の設定を有効にします。
			@default 	true

			@param 	defaultSpeed
			@type 		number
			@text 		基本移動速度
			@desc 		非ダッシュ状態＆HP残量による速度補正無しの移動速度です。
			@default 	4
			@min 		1
			@decimals 	0
			
			
			@param 	boostSpeed
			@type 		number
			@text 		ブースト速度
			@desc 		ダッシュ中の速度補正値です。この値がダッシュ速度に加算されます。
			@default 	0
			@min 		0
			@decimals 	0

			@param 	changeShiftDash
			@type 		select
			@text 		シフトダッシュの変更
			@desc 		ダッシュ判定に使うキーを設定します。
			@default 	shift
				@option Shiftキー / Xボタン
				@value 	shift
				@option Xキー / Bボタン
				@value 	cancel
				@option キー不要
				@value 	nobutton
			
			
			@param 	stride
			@type 		select
			@text 		歩幅
			@desc 		１歩当たりの歩幅を設定します。
			@default 	1
				@option 一歩
				@value 	1

				@option 半歩
				@value 	0.5

			@param shapingRegions
			@type 		number[]
			@text 		立体表現用リージョンID
			@desc 		順に立体始点・立体実行点・立体交差始点・立体交差中点（横型・縦型）のリージョンIDを設定します。
			@decimals 	0
			@min 		0
			@max 		255
			

			@param 	touchDistance
			@type 		number
			@text 		接触判定距離
			@desc 		歩幅が半歩以下の時、イベントや乗り物のトリガー判定距離を設定します。
			@default 	1
			@max 		1.5
			@min 		0.25
			@decimals 	2

			@param 	restrictEvents
			@type 		boolean
			@text 		イベント同時実行の制限
			@desc 		On（true）の時、決定トリガーで発動するイベントが１つに限定されます。
			@default 	true
			

			@param 	turnAround
			@type 		number
			@text 		振り向きフレーム
			@desc 		方向キーを短く入力した際、振り向きを許可するフレームを設定します。0の時は振り向かずそのまま移動します。
			@default 	0
			@decimals 	0
			@decimals 	0

			@param upperShader
			@type 		boolean
			@text 		影レイヤー浮上
			@desc 		On（true）の時、影のｚ値が上昇します。
			@default 	false

			@param 	leader
			@type 		actor
			@text 		パーティリーダー
			@desc 		マップ上で先頭を歩くリーダーの画像を固定設定します。「なし」の場合、先頭のアクターに応じて画像が変わります。
			@default 	0

			@param 	gameOverEvent
			@type 		common_event
			@text 		ゲームオーバー処理
			@desc 		ゲームオーバー時に実行するコモンイベントを設定します。未設定時はデフォルトの処理を行います。
			@default 	0

			@param 	stepSEValid
			@type 		boolean
			@text 		足音の有効化
			@desc 		On（true）の時、次の足音設定が適用されるようになります。
			@default 	true

			@param 	stepSE
			@type 		struct<StepSE>[]
			@text 		足音
			@desc 		移動する際の足音を設定します。地形タグ０〜７の順の設定になります。
			@dir 		audio/se

			@param 	hearingStatus
			@type 		number
			@text 		足音発生ステータス
			@desc 		足音の範囲を決めるステータスを設定します。パーティのリーダーの能力が参照されます。
			@decimals 	0
			@default 	7
			@min 		2
			@max 		19

			@param 	searchLimitHearing
			@type 		number
			@text 		イベント聴覚範囲
			@desc 		イベントがプレイヤーの足音を検知するデフォルトの範囲を設定します。視覚はアクションで設定します。
			@default 	2
			@decimals 	0
		*/
		/*----------------------------------------------------------------------------------------------------*/
		/*~struct~FieldBasic:
			@param 	valid
			@type 		boolean
			@text 		valid field basic移動強化の有効化
			@desc 		Turn on the following when this is true
			@default 	true

			@param 	defaultSpeed
			@type 		number
			@text 		player's move speed
			@desc 		Control the speed on no-dash and max-stamina
			@default 	4
			@min 		1
			@decimals 	0
			
			
			@param 	boostSpeed
			@type 		number
			@text 		player's boost speed
			@desc 		Control the speed added to dash Speed
			@default 	0
			@min 		0
			@decimals 	0

			@param 	changeShiftDash
			@type 		select
			@text 		change key or button for dash
			@desc 		Select the button
			@default 	shift
				@option Shift key / X button
				@value 	shift
				@option X key / B button
				@value 	cancel
				@option not use keys or buttons
				@value 	nobutton
			
			
			@param 	stride
			@type 		select
			@text 		stride
			@desc 		Select a character's stride
			@default 	1
				@option one step
				@value 	1

				@option half step
				@value 	0.5

			@param shapingRegions
			@type 		number[]
			@text 		region IDs for shaping as 3D
			@desc 		Control the IDs; from former, beginning, execution, start of overpass, horizontal bridge of overpass, and vertical bridge
			@decimals 	0
			@min 		0
			@max 		255
			

			@param 	touchDistance
			@type 		number
			@text 		distance for touching
			@desc 		Control the distance in which events or vehicles is triggerd; on less than half stride
			@default 	1
			@max 		1.5
			@min 		0.25
			@decimals 	2

			@param 	restrictEvents
			@type 		boolean
			@text 		allow just one event
			@desc 		allow just one event to happen by decision when this is true
			@default 	true

			@param 	turnAround
			@type 		number
			@text 		durations permit player to turn around(frames)
			@desc 		Control the durations from movement keys inputted, unless this is 0
			@default 	0
			@decimals 	0
			@decimals 	0

			@param upperShader
			@type 		boolean
			@text 		raise Shader Layer
			@desc 		Raise the z-index of Shader Layer when this is true
			@default 	false

			@param 	leader
			@type 		actor
			@text 		leader of party
			@desc 		Select the leader which fixes player's image on maps
			@default 	0
			
			@param 	gameOverEvent
			@type 		common_event
			@text 		GameOver event
			@desc 		Select an common_event for executing GameOver, or default function is called
			@default 	0

			@param 	stepSEValid
			@type 		boolean
			@text 		play the step SE
			@desc 		Play the SE with character's movement when this is true
			@default 	true

			@param 	stepSE
			@type 		struct<StepSE>[]
			@text 		stepSE list
			@desc 		Construct the list; the each index is linked to terrain tag 0 to 7
			@dir 		audio/se

			@param 	hearingStatus
			@type 		number
			@text 		status of affect SE range
			@desc 		Select the status of leader for calculating step SE radius
			@decimals 	0
			@default 	7
			@min 		2
			@max 		19

			@param 	searchLimitHearing
			@type 		number
			@text 		hearing range of events
			@desc 		Control the range events find player; sight is controlled in "enemyActionHUD"
			@default 	2
			@decimals 	0
		*/
		/**************************************************************************************/
				/*~struct~StepSE:ja
					@param 	name
					@type 		file
					@text 		使用SE
					@desc 		足音にするSEを設定します。
					@dir 		audio/se
					@require 1

					@param 	volume
					@type  	number
					@text 		SEボリューム
					@desc 		足音SEの音量を設定します。
					@default 	40
					@decimals 	0
					@max 		100

					@param 	pitch
					@type  	number
					@text 		SEピッチ
					@desc 		足音SEの高さを設定します。
					@default 	100
					@decimals 	0

					@param 	pan
					@type  	number
					@text 		SEパン
					@desc 		足音SEの位相を設定します。
					@default 	0
					@decimals 	0
				*/
				/*----------------------------------------------------------------------------------------------------*/
				/*~struct~StepSE:
					@param 	name
					@type 		file
					@text 		SE file
					@desc 		Select a file for step SE
					@dir 		audio/se
					@require 1

					@param 	volume
					@type  	number
					@text 		SE volume
					@desc 		Control the volume
					@default 	40
					@decimals 	0
					@max 		100

					@param 	pitch
					@type  	number
					@text 		SE pitch
					@desc 		Control the pitch
					@default 	100
					@decimals 	0

					@param 	pan
					@type  	number
					@text 		SE pan
					@desc 		Control the pan
					@default 	0
					@decimals 	0
				*/


		const parseFieldBasic = s => JSON.parse(s, (key, value)=>{
			switch(key){
				case 'valid' 		 	: return value;
				case 'defaultSpeed'  	: return Number.parseFloat(value);
				case 'boostSpeed' 	 	: return Number.parseFloat(value);
				case 'changeShiftDash' 	: return value;
				case 'stride' 		 	: return Number.parseFloat(value);
				case 'shapingRegions'	: return value;
				case 'touchDistance' 	: return Number.parseFloat(value);
				case 'restrictEvents'	: return value;
				case 'turnAround' 	 	: return Number.parseFloat(value);
				case 'upperShader'	 	: return value;
				case 'leader' 		 	: return Number.parseFloat(value);
				case 'gameOverEvent' 	: return Number.parseFloat(value);
				case 'stepSEValid' 	 	: return value;
				case 'stepSE' 		 	: return value;
				case 'hearingStatus' 	: return Number.parseFloat(value);
				case 'searchLimitHearing' : return Number.parseFloat(value);
				default 			 	: return value;
			};
		});//*

		let fieldBasic = params.fieldBasic;
		let consolerNameFieldBasic = 'fieldBasic:';
		if(fieldBasic){
			fieldBasic = parseFieldBasic(fieldBasic);
			if(fieldBasic.shapingRegions){
				fieldBasic.shapingRegions = JSON.parse(fieldBasic.shapingRegions);
				fieldBasic.shapingRegions = fieldBasic.shapingRegions.map(id => {return Number(id)});
			}else{
				fieldBasic.shapingRegions = [];
			}
			fieldBasic = stringToBoolean(fieldBasic);
		}else{
			fieldBasic = makeNotValid();
			undefinedStructs.push(consolerNameFieldBasic);
			consolerNameFieldBasic += makeInvalidTerm();
		}

		consoler(consolerNameFieldBasic, fieldBasic);
		const fieldValid = fieldBasic.valid;

		const sr = fieldBasic.shapingRegions
		const overpassPrepared = sr ? (sr.length >= 5 && sr[3] > 0 && sr[4] > 0) : false;


/*-----歩幅調整時の接触判定を行う距離取得用ファンクション群--------*/
Game_Map.prototype.touchDistance = function(){
	return fieldValid ? fieldBasic.touchDistance || 1 : 1; 
};//*
if(!fieldValid) Game_Map.prototype.touchDistance = function(){return 1};


Game_Map.prototype.getTouchRange = function(){
	return this.touchDistance() ** 2;
};//*
if(!fieldValid) Game_Map.prototype.getTouchRange = function(){return 1};


Game_CharacterBase.prototype.touchDistance = function(){
	return  fieldValid ? fieldBasic.touchDistance || 1 : 1; 
};//*
if(!fieldValid) Game_CharacterBase.prototype.touchDistance = function(){return 1};


Game_CharacterBase.prototype.getTouchRange = function(){
	return this.touchDistance() ** 2;
};//*
if(!fieldValid) Game_CharacterBase.prototype.getTouchRange = function(){return 1};


/*----キャラクターベースの初期化をMELOS用に強化------*/
 //Object.definePropertiesでGame_CharacterBaseが読める定義を追加
Object.defineProperties(Game_CharacterBase.prototype, {
    x: { get: function() { return this._x; }, configurable: true },
    y: { get: function() { return this._y; }, configurable: true },
    isPlayer: { get: function(){return this._isPlayer}, configurable: true }
});

const _Game_CharacterBase_prototype_initMembers_A = Game_CharacterBase.prototype.initMembers;
Game_CharacterBase.prototype.initMembers = function(){
	_Game_CharacterBase_prototype_initMembers_A.apply(this, arguments);
	
	this._isPlayer = false;//プレイヤーかどうかの判定に使う。
	this._enableStamina = 0;//スタミナ消費量
	this._boostSpeed = 0;	//ダッシュ時の速度補正
	this.initializeAutoOpacity();//setAutoChangeOpacity用のプロパティ。プラグインコマンド設計時に宣言。

	//後述の半歩マップチップでの移動領域不具合に対応するプロパティ
	this._biosTurn = 0;//for bios turning at left or right tile is not passible, 1 left -1 right
	this._isOnHill = false;
	this._startOnHill = false;

	//ジャンプのタイプを設定するプロパティ
	this._autoJumpType = 'step';
	this._fallCount = 0;
	this._resistFallingAcceleration = 0;
	this._moveSpeedBeforeFalling = this._moveSpeed;

	//足踏みを好みの画像に固定できるプロパティ　処理自体は簡易挙動のところで
	this._fixPattern = false;
	this._motionPattern = 0;
	this._motionWaits = [];
	this._motionIndex = 0;
	this._tempLeaderId = 0;
	this._originalCharacterName = '';
	this._originalCharacterIndex = 0;
};//*

	/*-----------------昼夜の実装------------------------*/

		/*~struct~DaySecond:ja
		@param 	red
		@type 		number
		@desc 		-255 ~ 255の値で設定します。目安として、昼: 0 夕: 68 夜: -68です。
		@default 	0
		@min 		-255
		@max 		255
		@decimals 	0
		
		@param 	green
		@type 		number
		@desc 		-255 ~ 255の値で設定します。目安として、昼: 0 夕: -34 夜: -68です。
		@default 	0
		@min 		-255
		@max 		255
		@decimals 	0
		
		@param 	blue
		@type 		number
		@desc 		-255 ~ 255の値で設定します。目安として、昼: 0 夕: -34 夜: 0です。
		@default 	0
		@min 		-255
		@max 		255
		@decimals 	0
		
		@param 	grey
		@type 		number
		@desc 		0 ~ 255の値で設定します。目安として、昼: 0 夕: 0 夜: 68です。
		@default 	0
		@max 		255
		@decimals 	0
		
		@param 	time
		@type 		number
		@text 		継続時間（秒）
		@desc 		この時間を継続させる長さを設定します。
		@default 	540
		@min 		1
		@decimals 	0
		
		@param 	duration
		@type 		number
		@text 		色調変更の時間（ﾌﾚｰﾑ）
		@desc 		自分の色調変更に必要な時間を設定します。
		@default 	1800
		@min 		1
		@decimals 	0
		*/
		/*----------------------------------------------------------------------------------------------------*/
		/*~struct~DaySecond:
		@param 	red
		@type 		number
		@desc 		Control tone between -255 and 255; for example, day: 0 twilight: 68 night: -68
		@default 	0
		@min 		-255
		@max 		255
		@decimals 	0
		
		@param 	green
		@type 		number
		@desc 		Control tone between -255 and 255; for example, day: 0 twilight: -34 night: -68
		@default 	0
		@min 		-255
		@max 		255
		@decimals 	0
		
		@param 	blue
		@type 		number
		@desc 		Control tone between -255 and 255; for example, day: 0 twilight: -34 night: 0
		@default 	0
		@min 		-255
		@max 		255
		@decimals 	0
		
		@param 	grey
		@type 		number
		@desc 		Control tone between -255 and 255; for example, day: 0 twilight: 0 night: 68
		@default 	0
		@max 		255
		@decimals 	0
		
		@param 	time
		@type 		number
		@text 		duration for next time zone（seconds）
		@desc 		Control this time's duration; be careful the unit is seconds
		@default 	540
		@min 		1
		@decimals 	0
		
		@param 	duration
		@type 		number
		@text 		duration for changing tone（frames）
		@desc 		Control the duration; be careful the unit is frames
		@default 	1800
		@min 		1
		@decimals 	0
		*/

		
		const parseSunshine = s => JSON.parse(s, (key, value)=>{
			switch (key){
				case 'red' 		: return Number.parseFloat(value);
				case 'green'	: return Number.parseFloat(value);
				case 'blue' 	: return Number.parseFloat(value);
				case 'grey' 	: return Number.parseFloat(value);
				case 'time' 	: return Number.parseFloat(value);
				case 'duration' : return Number.parseFloat(value);
				default 		: return value;
			}	
		});//*

	let daySecond = params.daySecond;
	let consolerNameDay = 'daySecond:';
	let dayNightArray = [];
	if(daySecond){
		daySecond = parseSunshine(daySecond);
		dayNightArray.push(daySecond);
	}else{
		daySecond = makeNotValid();
		undefinedStructs.push(consolerNameDay);
		consolerNameDay += makeInvalidTerm();
	}
	//-------------------------------------------//
	let twilightSecond = params.twilightSecond;
	let consolerNameTwilight = 'twilightSecond:';
	if(twilightSecond){
		twilightSecond = parseSunshine(twilightSecond);
		dayNightArray.push(twilightSecond);
	}else{
		twilightSecond = makeNotValid();
		undefinedStructs.push(consolerNameTwilight);
		consolerNameTwilight += makeInvalidTerm();
	}
	//-------------------------------------------//
	let nightSecond = params.nightSecond;
	let consolerNameNight = 'nightSecond:';
	if(nightSecond){
		nightSecond = parseSunshine(nightSecond);
		dayNightArray.push(nightSecond);
	}else{
		nightSecond = makeNotValid();
		undefinedStructs.push(consolerNameNight);
		consolerNameNight += makeInvalidTerm();
	}
	//-------------------------------------------//
	consoler(consolerNameDay, daySecond);
	consoler(consolerNameTwilight, twilightSecond);
	consoler(consolerNameNight, nightSecond);

const _Game_System_prototype_initialize_F = Game_System.prototype.initialize;
Game_System.prototype.initialize = function(){
	_Game_System_prototype_initialize_F.apply(this, arguments);
	this.prepareDayNight();
};//*

if(fieldValid && dayNightConcept){
	const _Game_Player_prototype_update = Game_Player.prototype.update;
	Game_Player.prototype.update = function(sceneActive) {
	    _Game_Player_prototype_update.apply(this, arguments);

	    $gameSystem.dayTimer();
	};//*
};////

Game_System.prototype.prepareDayNight = function(){
	this._dayNightConcept = dayNightConcept;
	this._dayTimeCounter = 0;
	this._dayTimeSeconder = 0;
	this._dayNightIndex = 0;
	this._dayNight = dayNightArray;
	this._day = 0; //日数
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.prepareDayNight = function(){};


Game_System.prototype.enableDayNight = function(){
	return this._dayNightConcept;
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.enableDayNight = function(){return false};

Game_System.prototype.stopDayNight = function(){
	this._dayNightConcept = false;
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.stopDayNight = function(){};

Game_System.prototype.startDayNight = function(){
	this._dayNightConcept = true;
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.startDayNight = function(){};


Game_System.prototype.addDayTimeCounter = function(){
	this._dayTimeCounter ++;
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.addDayTimeCounter = function(){};


Game_System.prototype.checkSecondPassed = function(){
	return this._dayTimeCounter >= 60;
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.checkSecondPassed = function(){return false};


Game_System.prototype.secondPassed = function(){
	this._dayTimeCounter = 0;
	this._dayTimeSeconder ++;
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.secondPassed = function(){};


Game_System.prototype.currentDayNightIndex = function(){
	return this._dayNightIndex;
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.currentDayNightIndex = function(){return 0};


Game_System.prototype.canChangeDayNight = function(){
	const index = this.currentDayNightIndex();
	const currentTime = this._dayNight[index];
	return this._dayTimeSeconder >= currentTime.time;
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.canChangeDayNight = function(){return false};


Game_System.prototype.changeDayNightIndex = function(){
	this._dayNightIndex ++;
	this._dayNightIndex %= this._dayNight.length; 
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.changeDayNightIndex = function(){};


Game_System.prototype.currentDayNightObj = function(){
	return this._dayNight[this.currentDayNightIndex()] || this._dayNight[0];
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.currentDayNightObj = function(){return {}};


Game_System.prototype.resetDayTimeSeconder = function(){
	this._dayTimeSeconder = 0;
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.resetDayTimeSeconder = function(){};


Game_System.prototype.currentDay = function(){
	consoler('currentDay:', this._day);
	return this._day;
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.currentDay = function(){return 0};


Game_System.prototype.dayPassed = function(){
	if(this.currentDayNightIndex() === 0){
		this.addDay();
	}
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.dayPassed = function(){};


Game_System.prototype.dayTimer = function(){
	if(this.enableDayNight()){
		this.manageDayNight();
	};
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.dayTimer = function(){};


Game_System.prototype.manageDayNight = function(){
	this.addDayTimeCounter();

	if(this.checkSecondPassed()){
			this.secondPassed();
			if(this.canChangeDayNight()){
					this.changeDayNight();
					this.dayPassed();
			}
	};
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.manageDayNight = function(){};


Game_System.prototype.changeDayNight = function(){
	this.changeDayNightIndex();
	const timeObj = this.currentDayNightObj();
	this.resetDayTimeSeconder();
	if( !$gameMap.mapTone() ){
		$gameScreen.startTint([ timeObj.red,
								timeObj.green, 
								timeObj.blue, 
								timeObj.grey], 
								timeObj.duration);
	}else{
		$gameScreen._tempTone = [timeObj.red, timeObj.green, timeObj.blue, timeObj.grey];
	}
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.changeDayNight = function(){};


//スクリプトとしてプロパティを変更するためのファンクション
Game_System.prototype.changeDayNightConcept = function(value){
	value = !!value;
	this._dayNightConcept = value;
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.changeDayNightConcept = function(value){};


Game_System.prototype.forceChangeDayNight = function(index){
	if(typeof index === 'number' && index > 0){
		index --;
		index %= this._dayNight.length;
		this._dayNightIndex = index;
		const timeObj = this.currentDayNightObj();
		this.resetDayTimeSeconder();
		$gameScreen.startTint([ timeObj.red,
								timeObj.green, 
								timeObj.blue, 
								timeObj.grey], 
								1);
		this.dayPassed();
	}
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.forceChangeDayNight = function(index){};


Game_System.prototype.addDay = function(value){
	this._day += value || 1;
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.addDay = function(value){};


Game_System.prototype.checkCurrentDayTimeRate = function(){
	const rate = this._dayTimeSeconder / this.currentDayNightObj().time;
	return Math.floor(rate * 100)/100;
};//*
if(!fieldValid || !dayNightConcept) Game_System.prototype.checkCurrentDayTimeRate = function(){return 0};


/*25.04.08追記　マップのタグを頼りに、時間色調を変更するかどうかを分岐させる*/
const _Game_Map_prototype_initializeA = Game_Map.prototype.initialize;
Game_Map.prototype.initialize = function() {
    _Game_Map_prototype_initializeA.apply(this, arguments);
    this._mapTone;
};//*

if(fieldValid && dayNightConcept){
	const _Game_Map_prototype_setup = Game_Map.prototype.setup;
	Game_Map.prototype.setup = function(mapId) {
	    _Game_Map_prototype_setup.apply(this, arguments);
	    this.checkDayNight();
	    this.setMapTone();
	};//*

	const _Game_Player_prototype_clearTransferInfo = Game_Player.prototype.clearTransferInfo;
	Game_Player.prototype.clearTransferInfo = function() {
	  _Game_Player_prototype_clearTransferInfo.apply(this, arguments);
	  $gameMap.checkMapTone();
	};//*
}

Game_Map.prototype.checkDayNight = function(){
	const meta = $dataMap.meta;
	if(meta.stopDayNight){
		$gameSystem.stopDayNight();
	}else{
		$gameSystem.startDayNight();
	}
};//*
if(!fieldValid || !dayNightConcept) Game_Map.prototype.checkDayNight = function(){};

Game_Map.prototype.setMapTone = function(){
	const meta = $dataMap.meta;
	if(meta.tone){
		this._mapTone = JSON.parse(meta.tone);
	}else{
		this._mapTone = undefined;
	}
};//*
if(!fieldValid || !dayNightConcept) Game_Map.prototype.setMapTone = function(){};

Game_Map.prototype.mapTone = function(){
	return this._mapTone;
};//*
if(!fieldValid || !dayNightConcept) Game_Map.prototype.mapTone = function(){return false};

Game_Map.prototype.checkMapTone = function(){
	const fadeSpeed = this._interpreter.fadeSpeed();
	if(this.mapTone()){
		if(!$gameScreen._tempTone) $gameScreen._tempTone = $gameScreen._tone.clone();
		$gameScreen.startTint(this.mapTone(), fadeSpeed);
	}else if($gameScreen._tempTone){
		const tone = $gameScreen._tempTone;
		$gameScreen._tempTone = undefined;
		$gameScreen.startTint(tone, fadeSpeed);
	}
};//*
if(!fieldValid || !dayNightConcept) Game_Map.prototype.checkMapTone = function(){};

	/*-------------重量ステータスの設定----------------------------------*/

		/*~struct~HeavyStatus:ja
			@param 	heavy
			@type 		number
			@text		重さとして使うステータス
			@desc 		2:攻撃力　3:防御力 4:魔法力 5:魔防力 6:敏捷性 7:運 10~19:追加能力
			@default 	10
			@max 		19
			@min 		2
			@decimals 	0
			
			@param 	physique
			@type 		number
			@text		体格として使うステータス
			@desc 		2:攻撃力　3:防御力 4:魔法力 5:魔防力 6:敏捷性 7:運 10~19:追加能力
			@default 	10
			@max 		19
			@min 		2
			@decimals 	0

			@param 	weightFormula
			@type 		string
			@text 		重量の計算式
			@desc 		重さと体格から重量を求める式を設定します。heavy physiqueは指定したパラメーターを指します。
			@default 	heavy / (physique * 3)

			@param 	baseCost
			@type 		number
			@text 		重量基本値
			@desc 		計算式の結果を乗算する基本の消費量を設定します。小数第一位まで使用できます。
			@decimals 	1
			@min 		0
			@default 	4
			
			@param 	weightRate
			@type 		number[]
			@text 		重量割合
			@desc 		軽装・中装・重装とみなす重量割合を設定します。計算式の値が設定値以下の時、各状態と見なします。
			@decimals 	0
			@max 		100
			@default 	["30", "70", "100"]

			@param 	regene
			@type 		number
			@text		自然回復として使うステータス
			@desc 		2:攻撃力　3:防御力 4:魔法力 5:魔防力 6:敏捷性 7:運　10~19:追加能力
			@default 	11
			@max 		19
			@min 		2
			@decimals 	0

			@param 	staminaInterbal
			@type 		number
			@text		スタミナ回復までのウェイト
			@desc 		ダメージを受けたりアクション実行時、スタミナ回復までのウェイトフレームを設定します。
			@default 	60
			@min 		1
			@decimals 	0

			@param 	walkStamina
			@type 		boolean
			@text 		徒歩スタミナ
			@desc 		On（true）の時、徒歩での移動にもスタミナを消費します。
			@default 	false

			@param 	vehicleStamina
			@type 		boolean
			@text 		乗り物スタミナ
			@desc 		On（true）の時、乗り物での移動にもスタミナを消費します。
			@default 	false
		*/
		/*-----------------------------------------------------------------------------------*/
		/*~struct~HeavyStatus:
			@param 	heavy
			@type 		number
			@text		stat of heavy
			@desc 		2:ATK　3:DEF 4:MAT 5:MDF 6:AGI 7:LUK 10~19:Additional
			@default 	10
			@max 		19
			@min 		2
			@decimals 	0
			
			@param 	physique
			@type 		number
			@text		stat of physique
			@desc 		2:ATK　3:DEF 4:MAT 5:MDF 6:AGI 7:LUK 10~19:Additional
			@default 	10
			@max 		19
			@min 		2
			@decimals 	0

			@param 	weightFormula
			@type 		string
			@text 		weight formula
			@desc 		Write the formula; heavy and physique refer to upper parameters
			@default 	heavy / (physique * 3)

			@param 	baseCost
			@type 		number
			@text 		base cost
			@desc 		Control the cost multiplied by weightFormula; enable the first decimal
			@decimals 	1
			@min 		0
			@default 	4
			
			@param 	weightRate
			@type 		number[]
			@text 		weight rate
			@desc 		Define the rates of light, middle, or heavy, when weightFormula is less than each element
			@decimals 	0
			@max 		100
			@default 	["30", "70", "100"]

			@param 	regene
			@type 		number
			@text		stat to regenerate stamina
			@desc 		2:ATK　3:DEF 4:MAT 5:MDF 6:AGI 7:LUK 10~19:Additional
			@default 	11
			@max 		19
			@min 		2
			@decimals 	0

			@param 	staminaInterbal
			@type 		number
			@text		wait frames for starting stamina regeneration
			@desc 		Control the frames which start to count on player damaged or executing action
			@default 	60
			@min 		1
			@decimals 	0

			@param 	walkStamina
			@type 		boolean
			@text 		walk stamina
			@desc 		Pay stamina on walking when this is true
			@default 	false

			@param 	vehicleStamina
			@type 		boolean
			@text 		vehicle stamina
			@desc 		Pay stamina in vehicle when this is true
			@default 	false
		*/

		const parseHeavyStatus = s => JSON.parse(s, (key, value) =>{
			switch(key){
				case 'heavy' 			: return Number.parseFloat(value);
				case 'physique' 		: return Number.parseFloat(value);
				case 'weightFormula' 	: return value;
				case 'baseCost' 		: return Number.parseFloat(value);
				case 'weightRate' 		: return JSON.parse(value);
				case 'regene' 			: return Number.parseFloat(value);
				case 'staminaInterbal' 	: return Number.parseFloat(value);
				case 'walkStamina' 		: return value;
				case 'vehicleStamina' 	: return value;
				default 				: return value;
			}
		});//*

		let heavyStatus = params.heavyStatus;
		let consolerHeavy = 'heavyStatus:';
		if(heavyStatus){
				heavyStatus = parseHeavyStatus(heavyStatus);
				heavyStatus.weightRate = heavyStatus.weightRate.map(num => {return Number(num)});
				heavyStatus.weightRate = heavyStatus.weightRate.map(num => {return num / 100});
				heavyStatus = stringToBoolean(heavyStatus);
		}else{
				heavyStatus = makeNotValid();
				undefinedStructs.push(consolerHeavy);
				consolerHeavy += makeInvalidTerm();
		}

		consoler(consolerHeavy, heavyStatus);

	const heavyId = heavyStatus.heavy || 3;
	const physiqueId = heavyStatus.physique || 5;
	const regeneId = heavyStatus.regene || 7;

if(fieldValid && staminaMode){
	const _Game_Player_prototype_update = Game_Player.prototype.update;
	Game_Player.prototype.update = function(sceneActive) {
	    _Game_Player_prototype_update.apply(this, arguments);

	    this.updateStamina();
	};//*

	/*--------アイテム入手・消費時に、重量への計算をする処理を追加
	ロストや消費はgainItemファンクションを流用しているので、一括指定でOK---------*/

	const calcItemWeight = function(item, amount){
		let itemWeight = params.itemWeight === 'true';
		if(itemWeight && DataManager.isItem(item)){
			const point = item.meta.heavy ? JSON.parse(item.meta.heavy) : 0;

			$gameParty.members().forEach(function(actor){
				actor.addParam(heavyId, Math.round(point * 10 * amount) / 10);
			});
		}
	};//*

	const _Game_Party_prototype_gainItem = Game_Party.prototype.gainItem;
	Game_Party.prototype.gainItem = function(item, amount, includeEquip){
		_Game_Party_prototype_gainItem.apply(this, arguments);

		calcItemWeight(item, amount);
	}//*
}////

Game_Player.prototype.updateStamina = function(){
	if(this._enableStamina === 0){
		this.staminaDamage();
	}else{
		this._enableStamina --;
		if(this._enableStamina <= 0){
			this._enableStamina = 0;
		}
	}
};//*
if(!fieldValid || !staminaMode) Game_Player.prototype.updateStamina = function(){};


	/*-----スタミナへダメージ・回復を与える独立ファンクション。疲労システムと連動------*/
Game_Player.prototype.staminaDamage = function(){
		let target = $gameParty.leader();
		let damageRate = 0;

	    if(this.hasStamina() && this.enableCostStamina()){
	    	damageRate = this.evalWeightFormula(target);
	    	damageRate *= heavyStatus.baseCost >= 0 ? heavyStatus.baseCost : 1;
	    	damageRate *= this.stopStamina(damageRate) ? 0 : -1;
	    }else{
	    	if(this._staminaInterbal === 0){
	    		const regeneOk = (regeneId < 8 || regeneId > 9) && this.isEnableAction();
	    		damageRate = !this.isClimbing() && 
	    					regeneOk && this.calcGaugeRate() < 1 ? target.param(regeneId) : 0;	
	    	}else{
	    		this._staminaInterbal--;
	    		if(this._staminaInterbal <= 0) this._staminaInterbal = 0;
	    		return;
	    	}
	    }

	    if(damageRate){
	    	damageRate = damageRate > 0 ? Math.max(1, damageRate) : Math.min(-1, damageRate);
	    	damageRate = Math.trunc(damageRate);
	   		this.executeStaminaDamage(target, damageRate);  
	    	this.setEnableStaminaWithDamage(damageRate); 	
	    }
};//*
if(!fieldValid || !staminaMode) Game_Player.prototype.staminaDamage = function(){};

Game_Player.prototype.setStaminaInterbal = function(){
	this._staminaInterbal = heavyStatus.staminaInterbal || 60;
};//*
if(!fieldValid || !staminaMode) Game_Player.prototype.setStaminaInterbal = function(value){};

Game_Player.prototype.hasStamina = function(){
	return this.getStaminaStatus() > 0;
};//*
if(!fieldValid || !staminaMode) Game_Player.prototype.hasStamina = function(){return false};


Game_Player.prototype.enableCostStamina = function(){
	let vehicleOk = heavyStatus.vehicleStamina ? true : !this.isInVehicle();
	let walkOk = heavyStatus.walkStamina ? this.isMoving() : this.isMoving() && this.isDashing();
	//if unable dash in the map, isDashing returns false.
	return vehicleOk && walkOk;
};//*
if(!fieldValid || !staminaMode) Game_Player.prototype.enableCostStamina = function(){return false};


Game_Player.prototype.stopStamina = function(damage){
	let targetStatus = this.getStaminaStatus();
	return staminaStatus === 'hp' && damage > targetStatus;
};//*
if(!fieldValid || !staminaMode) Game_Player.prototype.stopStamina = function(damage){return false};


Game_Player.prototype.evalWeightFormula = function(target){		
	return this.evalWeightRate(target);
};//*
if(!fieldValid || !staminaMode) Game_Player.prototype.evalWeightFormula = function(target){return 0};


Game_Player.prototype.evalWeightRate = function(target){
	const heavy = heavyId === 8 || heavyId === 9 ? 0 : target.param(heavyId);
	const physique = physiqueId === 8 || physiqueId === 9 ? 1 : target.param(physiqueId);
	if(heavyStatus.weightFormula){
			let rate = eval(heavyStatus.weightFormula);
			if(isNaN(rate)) rate = heavy / physique;
			return rate;
	}else{
			return heavy / physique;
	}
};//*
if(!fieldValid || !staminaMode) Game_Player.prototype.evalWeightRate = function(target){return 0};


Game_Player.prototype.getStaminaStatus = function(){
	switch(staminaStatus){
	    case 'hp': return $gameParty.members()[0]._hp; break;
	    case 'mp': return $gameParty.members()[0]._mp; break;
	    case 'tp': return $gameParty.members()[0]._tp; break;
	    default  : return 0;
	};
	return 0;
};//*
if(!fieldValid || !staminaMode) Game_Player.prototype.getStaminaStatus = function(){return 0};


Game_Player.prototype.executeStaminaDamage = function(target, damage){
	switch(staminaStatus){
	    case 'hp': target.gainHp(damage); break;
	    case 'mp': target.gainMp(damage); break;
	    case 'tp': target.gainTp(damage); break;	
	    default  : target.gainMp(damage);
	};
};//*
if(!fieldValid || !staminaMode) Game_Player.prototype.executeStaminaDamage = function(target, damage){};


Game_Player.prototype.setEnableStaminaWithDamage = function(damage){
	if(damage < 0){
		const gaugeRate = this.calcGaugeRate();
		this._enableStamina = gaugeRate > 0.25 ? 4 : 8;
	}else{
		this._enableStamina = 1;
	}
};//*
if(!fieldValid || !staminaMode) Game_Player.prototype.setEnableStaminaWithDamage = function(damage){};


Game_Player.prototype.isLightWeight = function(){
	const weight = this.evalWeightRate($gameParty.leader());
	return weight <= heavyStatus.weightRate[0];
};//*
if(!fieldValid || !staminaMode) Game_Player.prototype.isLightWeight = function(){return false};


Game_Player.prototype.isMiddleWeight = function(){
	const weight = this.evalWeightRate($gameParty.leader());
	return weight <= heavyStatus.weightRate[1];
};//*
if(!fieldValid || !staminaMode) Game_Player.prototype.isMiddleWeight = function(){return false};


Game_Player.prototype.isHeavyWeight = function(){
	const weight = this.evalWeightRate($gameParty.leader());
	return weight <= heavyStatus.weightRate[2];
};//*
if(!fieldValid || !staminaMode) Game_Player.prototype.isHeavyWeight = function(){return false};


Game_Player.prototype.isOverWeight = function(){
	const weight = this.evalWeightRate($gameParty.leader());
	return weight > heavyStatus.weightRate[2];
};//*
if(!fieldValid || !staminaMode) Game_Player.prototype.isOverWeight = function(){return false};


	//define names
	const lightWeight 	= 'light';
	const middleWeight 	= 'middle';
	const heavyWeight 	= 'heavy';
	const overWeight 	= 'over';
	const noWeight 		= 'noWeight';

Game_Player.prototype.checkWeightRate = function(){
	if(this.isLightWeight()){
		return lightWeight;
	}else if(this.isMiddleWeight()){
		return middleWeight;
	}else if(this.isHeavyWeight()){
		return heavyWeight;
	}else if(this.isOverWeight()){
		return overWeight;
	}else{
		return noWeight;
	}
};//*
if(!fieldValid || !staminaMode) Game_Player.prototype.checkWeightRate = function(){};


	/*---------コマンドRPG用に、アクターにも重量ステータスを参照できるように----------*/

Game_BattlerBase.prototype.evalWeightFormula = function(){		
	let base = heavyStatus.baseCost || 1;
	let rate = this.evalWeightRate();
	return Math.max(0, Math.ceil(base * rate));
};//*
if(!fieldValid || !staminaMode) Game_BattlerBase.prototype.evalWeightFormula = function(){return 0};


Game_BattlerBase.prototype.evalWeightRate = function(){
	const heavy = heavyId === 8 || heavyId === 9 ? 0 : this.param(heavyId);
	const physique = physiqueId === 8 || physiqueId === 9 ? 1 : this.param(physiqueId);
	if(heavyStatus.weightFormula){
			let rate = eval(heavyStatus.weightFormula);
			if(isNaN(rate)) rate = heavy / physique;
			return rate;
	}else{
			return heavy / physique;
	}
};//*
if(!fieldValid || !staminaMode) Game_BattlerBase.prototype.evalWeightRate = function(){return 0};


Game_BattlerBase.prototype.isLightWeight = function(){
	const weight = this.evalWeightRate();
	return weight <= heavyStatus.weightRate[0];
};//*
if(!fieldValid || !staminaMode) Game_BattlerBase.prototype.isLightWeight = function(){return false};


Game_BattlerBase.prototype.isMiddleWeight = function(){
	const weight = this.evalWeightRate();
	return weight <= heavyStatus.weightRate[1];
};//*
if(!fieldValid || !staminaMode) Game_BattlerBase.prototype.isMiddleWeight = function(){return false};


Game_BattlerBase.prototype.isHeavyWeight = function(){
	const weight = this.evalWeightRate();
	return weight <= heavyStatus.weightRate[2];
};//*
if(!fieldValid || !staminaMode) Game_BattlerBase.prototype.isHeavyWeight = function(){return false};


Game_BattlerBase.prototype.isOverWeight = function(){
	const weight = this.evalWeightRate();
	return weight > heavyStatus.weightRate[2];
};//*
if(!fieldValid || !staminaMode) Game_BattlerBase.prototype.isOverWeight = function(){return false};


Game_BattlerBase.prototype.checkWeightRate = function(){
	if(this.isLightWeight()){
		return lightWeight;
	}else if(this.isMiddleWeight()){
		return middleWeight;
	}else if(this.isHeavyWeight()){
		return heavyWeight;
	}else if(this.isOverWeight()){
		return overWeight;
	}else{
		return noWeight;
	}
};//*
if(!fieldValid || !staminaMode) Game_BattlerBase.prototype.checkWeightRate = function(){return false};



	/*------------移動速度の強化-------------------------*/

const Game_Player_prototype_initMembers_A = Game_Player.prototype.initMembers;
Game_Player.prototype.initMembers = function(){
	Game_Player_prototype_initMembers_A.apply(this, arguments);
	//追加されたプロパティへの修正と、移動速度の変更を行う。
	this._isPlayer = true;
	this._staminaInterbal = 0;
	this.setInitialSpeed();
	this.setInitialBoostSpeed();
	this.setInitialStride(); //stride は後述の歩幅パートで設計
	this._stayCount = 0;
	//以下で設定するファストトラベル用に、リスポーンデータも準備
	this._respownMapId = 0;
	this._respownX = 0;
	this._respownY = 0;
};//*

Game_Player.prototype.initialSpeed = function(){
	return fieldValid ? fieldBasic.defaultSpeed || 4 : 4
};//*
if(!fieldValid) Game_Player.prototype.initialSpeed = function(){return 4};


Game_Player.prototype.setInitialSpeed = function(){
	this._moveSpeed = this.initialSpeed();
};//*

Game_Player.prototype.setInitialBoostSpeed = function(){
	this._boostSpeed = fieldValid ? fieldBasic.boostSpeed || 0 : 0;
};//*

if(fieldValid){
	const _Game_CharacterBase_prototype_realMoveSpeed = Game_CharacterBase.prototype.realMoveSpeed;
	Game_CharacterBase.prototype.realMoveSpeed = function() {
	    return this.moveSpeed() + this.boostOn();
	};//*

	const _Game_CharacterBase_prototype_distancePerFrame = Game_CharacterBase.prototype.distancePerFrame;
	Game_CharacterBase.prototype.distancePerFrame = function() {
		//プレイヤーならば特殊な計算式を追加
		let rate = this.isPlayer ? this.hpSpeedType() : 1 ;
	    const speed = Math.pow(2, this.realMoveSpeed()) / (256 / rate);
	    const minSpeed = 1 / 256;
	    return Math.max(speed, minSpeed);
	};//*

	const _Game_Player_prototype_isDashButtonPressed = Game_Player.prototype.isDashButtonPressed;
	Game_Player.prototype.isDashButtonPressed = function() {
		switch(fieldBasic.changeShiftDash){
			case 'shift' 	: return _Game_Player_prototype_isDashButtonPressed.apply(this, arguments); break;
			case 'cancel'	: return this.isEscapeDashButtonPressed(); break;
			case 'nobutton' : return ConfigManager.alwaysDash; break;
			case 'default' 	: return _Game_Player_prototype_isDashButtonPressed.apply(this, arguments);
		}
	};//*

	Game_Player.prototype.isEscapeDashButtonPressed = function(){
		const escape = Input.isPressed('escape');
	    return ConfigManager.alwaysDash ? !escape : escape;
	};//*

	const _Game_Player_prototype_updateNonmoving = Game_Player.prototype.updateNonmoving;
	Game_Player.prototype.updateNonmoving = function(wasMoving) {
		_Game_Player_prototype_updateNonmoving .apply(this, arguments);
	    if (!$gameMap.isEventRunning()) {
	        if (!wasMoving) {
	        	if(this._stayCount < Number.MAX_SAFE_INTEGER) this._stayCount++;
	        }
	    }
	};//*

	const _Game_Player_prototype_executeMove = Game_Player.prototype.executeMove;
	Game_Player.prototype.executeMove = function(direction) {
		_Game_Player_prototype_executeMove.apply(this, arguments);
	    this._stayCount = 0;
	};//*
}////

Game_Player.prototype.isStaying = function(count){
	return this._stayCount >= count;
};//*
if(!fieldValid) Game_Player.prototype.isStaying = function(){return false};

Game_CharacterBase.prototype.boostOn = function(){
	return this.isDashing() ? this.boostSpeed() + 1 : 0 ;
};//*
if(!fieldValid) Game_CharacterBase.prototype.boostOn = function(){return 0};


Game_CharacterBase.prototype.boostSpeed = function(){
	return this._boostSpeed;
};//*
if(!fieldValid) Game_CharacterBase.prototype.boostSpeed = function(){return 0};


Game_CharacterBase.prototype.setBoostSpeed = function(value){
	this._boostSpeed = value;
};//*
if(!fieldValid) Game_CharacterBase.prototype.setBoostSpeed = function(value){};


Game_CharacterBase.prototype.hpSpeedType = function(){
	if(fieldValid && staminaMode){
		let speedMode = params.hpSpeedType;

		switch(speedMode){
			case 'rate': return this.calcGaugeRate(); break;	//最大HPに対する現在HPの割合を参照する		
			case 'fixed': return this.hpSpeedFixedType(); break;//現在の実数値を参照する
			default: return 1;
		}
	}else{
		return 1;
	}
};//*
if(!fieldValid) Game_CharacterBase.prototype.hpSpeedType = function(){return 1};


Game_CharacterBase.prototype.calcGaugeRate = function(){
	//％表示にしたい場合、このファンクションに100を乗算すること！
	let actor = $gameParty.leader();

	switch(staminaStatus){
			case 'hp'	: return actor._hp / actor.param(0); break;
			case 'mp'	: return actor._mp / actor.param(1); break;
			case 'tp'	: return actor._tp / actor.maxTp(); break;
			default 	: return 1;
	}
	return 1;
};//*
if(!fieldValid) Game_CharacterBase.prototype.calcGaugeRate = function(){return 1};


Game_CharacterBase.prototype.hpSpeedFixedType = function(){
	switch(staminaStatus){
			case 'hp': return $gameParty.leader()._hp / 100; break;
			case 'mp': return $gameParty.leader()._mp / 100; break;
			case 'tp': return $gameParty.leader()._tp / 100; break;
			default  : return $gameParty.leader()._mp / 100;
	}
	return $gameParty.leader()._mp / 100;
};//*
if(!fieldValid) Game_CharacterBase.prototype.hpSpeedFixedType = function(){return 1};


/******************************************************************************************/
/*---------------------乗り物の拡張設定------------------------------*/

	/*~struct~VehicleList:ja
		@param 	type
		@type 		string
		@text 		乗り物タイプ
		@desc 		乗り物のタイプ名を設定します。walk, boat, ship, airship,および他のタイプ以外に設定して下さい。
		@default 	car

		@param 	collide
		@type 		boolean
		@text 		衝突判定
		@desc 		On（true）の時、船のようにプレイヤーが乗り物を通行できなくなります。
		@default 	false

		@param 	speed
		@type 		number
		@text 		乗り物の速度
		@desc 		プレイヤーの速度に上乗せする速度を設定します。
		@decimals 	0
		@max 		6
		@min 		-6
		@default 	0

		@param 	altitude
		@type 		number
		@text 		乗り物の高度（px）
		@desc 		地面からの高度を設定します。たとえば、飛行船は48です。
		@decimals 	0
		@default 	0

		@param 	transparent
		@type 		boolean
		@text 		プレイヤー透明化
		@desc 		On（true）の時、搭乗中はプレイヤーを透明にします。
		@default 	true

		@param 	priority
		@type 		number[]
		@text 		プレイヤーの表示優先
		@desc 		乗り物の向きに合わせたプレイヤーのプライオリティを0〜3で設定します。下、左、右、上で構成されます。
		@decimals 	0
		@max 		3
		@default 	["2", "3", "3", "3"]

		@param 	bush
		@type 		boolean
		@text 		茂み化
		@desc 		On（true）の時、搭乗中にプレイヤーの下半身が茂みに隠れた状態になります。
		@default 	false

		@param 	passableType
		@type  	select
		@text 		移動領域
		@desc 		この乗り物の移動可能タイプを設定します。
		@default 	car
				@option 	陸上乗り物
				@value 	car

				@option 	山岳乗り物
				@value 	buggy

				@option 	水上乗り物
				@value 	riverboat

				@option 	海上乗り物
				@value 	seaship

				@option 	空中乗り物
				@value 	skyship

				@option 	低空乗り物（海不可）
				@value 	carpet

				@option 	低空乗り物（海可）
				@value 	dragon
		
		@param 	encount
		@type 		boolean
		@text 		エンカウント発生
		@desc 		On（true）の時、搭乗中でもエンカウントが発生します。
		@default 	false

		@param 	damageFloor
		@type 		boolean
		@text 		ダメージ床
		@desc 		On（true）の時、搭乗中でもダメージ床の影響を受けます。
		@default 	false

		@param 	noSlip
		@type 		boolean
		@text 		滑る床無視
		@desc 		On（true）の時、YEP_SlipperyTiles.jsで設定された滑る床を無効化します。
		@default 	false

		@param 	playerDirection
		@type 		boolean
		@text 		向き矯正
		@desc 		On（true）の時、搭乗時に乗り物の向きをプレイヤーに合わせます
		@default 	false

		@param 	characterName
		@type 		file
		@text 		乗り物画像ファイル
		@desc 		乗り物の画像にしたいファイルを設定します。
		@dir 		img/characters
		@require 1

		@param 	characterIndex
		@type 		number
		@text 		乗り物の画像インデックス
		@desc 		ファイルの中で画像にセットしたいIDを0〜7で設定します。左上が0です。
		@decimals 	0
		@max 		7
		@default 	0

		@param 	startMapId
		@type 		number
		@text 		初期配置マップ
		@desc 		この乗り物を配置する初期マップを設定します。
		@decimals 	0
		@default 	0

		@param 	startX
		@type 		number
		@text 		初期配置X座標
		@desc 		この乗り物を配置する初期X座標を設定します。
		@decimals 	0
		@default 	0

		@param 	startY
		@type 		number
		@text 		初期配置Y座標
		@desc 		この乗り物を配置する初期Y座標を設定します。
		@decimals 	0
		@default 	0

		@param 	startDirection
		@type 		select
		@text 		初期配置向き
		@desc 		この乗り物を配置する初期向きを設定します。
		@default 	4
				@option 	下
				@value 	2

				@option 	左
				@value 	4

				@option 	右
				@value 	6

				@option 	上
				@value 	8

		@param 	bgm
		@type 		struct<VehicleBgm>
		@text 		乗り物BGM
		@desc 		乗り物に搭乗中のBGMを設定します。

		@param 	stepSE
		@type 		struct<StepSE>[]
		@text 		乗り物　移動SE
		@desc 		乗り物に搭乗中の足音SEを設定します。fieldBasicの足音SEを有効にして下さい。
	*/
	/*-----------------------------------------------------------------------------------*/
	/*~struct~VehicleList:
		@param 	type
		@type 		string
		@text 		vehicle type
		@desc 		Define the type name; avoid the following, walk, boat, ship, airship, or the others
		@default 	car

		@param 	collide
		@type 		boolean
		@text 		collision of vehicle
		@desc 		Unable to pass through the vehicle when this is true
		@default 	false

		@param 	speed
		@type 		number
		@text 		vehicle speed
		@desc 		Control the speed added to player's move speed
		@decimals 	0
		@max 		6
		@min 		-6
		@default 	0

		@param 	altitude
		@type 		number
		@text 		vehicle altitude（px）
		@desc 		Control the height from ground; for example, airship's altitude is 48px
		@decimals 	0
		@default 	0

		@param 	transparent
		@type 		boolean
		@text 		player's transparent
		@desc 		Hide player in the vehicle when this is true
		@default 	true

		@param 	priority
		@type 		number[]
		@text 		player's priority
		@desc 		Construct the priorities between 0 and 3 for the vehicle's direction; down, left, right, and up
		@decimals 	0
		@max 		3
		@default 	["2", "3", "3", "3"]

		@param 	bush
		@type 		boolean
		@text 		player's bush
		@desc 		make player's lower body translucent when this is true
		@default 	false

		@param 	passableType
		@type  	select
		@text 		vehicle passable
		@desc 		Select the passable type
		@default 	car
				@option 	drive on the ground
				@value 	car

				@option 	drive excepting the sea or river
				@value 	buggy

				@option 	sail the river
				@value 	riverboat

				@option 	sail the ocean
				@value 	seaship

				@option 	fly in the sky
				@value 	skyship

				@option 	fly at low altitude, excepting the ocean
				@value 	carpet

				@option 	fly at low altitude
				@value 	dragon
		
		@param 	encount
		@type 		boolean
		@text 		canEncount
		@desc 		Can encount even in driving when this is true
		@default 	false

		@param 	damageFloor
		@type 		boolean
		@text 		damage floor
		@desc 		Affected by damage floor even in driving when this is true
		@default 	false

		@param 	noSlip
		@type 		boolean
		@text 		no slippery floor
		@desc 		Ignore the slippery in driving when this is true; need YEP_SlipperyTiles.js
		@default 	false

		@param 	playerDirection
		@type 		boolean
		@text 		correct player's direction
		@desc 		Correct player's direction with vehicle's when this is true
		@default 	false

		@param 	characterName
		@type 		file
		@text 		vehicle's image file
		@desc 		Select a file for vehicle's image
		@dir 		img/characters
		@require 1

		@param 	characterIndex
		@type 		number
		@text 		vehicle's image index
		@desc 		Select index of vehicle's image between 0 and 7; upper left is 0
		@decimals 	0
		@max 		7
		@default 	0

		@param 	startMapId
		@type 		number
		@text 		start map id
		@desc 		Select the map id of this vehicle
		@decimals 	0
		@default 	0

		@param 	startX
		@type 		number
		@text 		start x coordinate
		@desc 		Select the x coordinate of this vehicle
		@decimals 	0
		@default 	0

		@param 	startY
		@type 		number
		@text 		start y coordinate
		@desc 		Select the y coordinate of this vehicle
		@decimals 	0
		@default 	0

		@param 	startDirection
		@type 		select
		@text 		start direction
		@desc 		Select the initial direction of this vehicle
		@default 	4
				@option 	down
				@value 	2

				@option 	left
				@value 	4

				@option 	right
				@value 	6

				@option 	up
				@value 	8

		@param 	bgm
		@type 		struct<VehicleBgm>
		@text 		vehicle BGM
		@desc 		Construct the BGM in driving

		@param 	stepSE
		@type 		struct<StepSE>[]
		@text 		step SE for vehicle
		@desc 		Construct the SE in driving; need to turn on "stepSEValid" of "fieldBasic
	*/

				/*~struct~VehicleBgm:ja
					@param 	libraryId
					@type 		number
					@text 		ライブラリ同期
					@desc 		１以上のIDを設定すると、マップBGMライブラリの該当BGMを乗り物BGMとします。
					@default 	0
					@decimals 	0

					@param 	name
					@type 		file
					@text 		BGMファイル
					@desc 		演奏したいBGMを設定します。
					@dir 		audio/bgm
					@require 1

					@param 	volume
					@type 		number
					@text 		BGM音量
					@desc 		BGMのボリュームを設定します。
					@decimals 	0
					@max 		100
					@default 	90

					@param 	pitch
					@type 		number
					@text 		BGMピッチ
					@desc 		BGMのピッチを設定します。
					@decimals 	0
					@default 	100

					@param 	pan
					@type 		number
					@text 		BGM位相
					@desc 		BGMのパンを設定します。
					@decimals 	0
					@max 		100
					@min 		-100
					@default 	0

					@param 	mapAudio
					@type 		boolean
					@text 		マップBGM継続
					@desc 		On（true）の時、搭乗中もマップBGMをそのまま流します。
					@default 	false
				*/
				/*---------------------------------------------------------------*/
				/*~struct~VehicleBgm:
					@param 	libraryId
					@type 		number
					@text 		library track Id
					@desc 		Play the BGM in "mapBgms" when this is more than one
					@default 	0
					@decimals 	0

					@param 	name
					@type 		file
					@text 		BGM file
					@desc 		Select a file for vehicle BGM
					@dir 		audio/bgm
					@require 1

					@param 	volume
					@type  	number
					@text 		SE volume
					@desc 		Control the volume
					@default 	40
					@decimals 	0
					@max 		100

					@param 	pitch
					@type  	number
					@text 		SE pitch
					@desc 		Control the pitch
					@default 	100
					@decimals 	0

					@param 	pan
					@type  	number
					@text 		SE pan
					@desc 		Control the pan
					@default 	0
					@decimals 	0

					@param 	mapAudio
					@type 		boolean
					@text 		not override map audio
					@desc 		play the map BGM even in driving when this is true
					@default 	false
				*/


		const parseVehicleList = s => JSON.parse(s, (key, value) =>{
			switch(key){
				case 'type' 			: return value;
				case 'collide' 			: return value;
				case 'speed' 			: return Number.parseFloat(value);
				case 'altitude' 		: return Number.parseFloat(value);
				case 'transparent' 		: return value;
				case 'priority' 		: return JSON.parse(value);
				case 'bush' 			: return value;
				case 'passableType' 	: return value;
				case 'encount' 			: return value;
				case 'damageFloor' 		: return value;
				case 'noSlip' 			: return value;
				case 'playerDirection' 	: return value;
				case 'characterName'	: return value;
				case 'characterIndex'	: return Number.parseFloat(value);
				case 'startMapId'		: return Number.parseFloat(value);
				case 'startX' 			: return Number.parseFloat(value);
				case 'startY'			: return Number.parseFloat(value);
				case 'startDirection'	: return Number.parseFloat(value);
				case 'bgm' 				: return value ? JSON.parse(value) : emptyBgm;
				case 'stepSE' 			: return value ? JSON.parse(value) : [];
				default 				: return value;
			}
		});//*	

		let vehicleList = params.vehicleList;
		let consolerNameVehicles = 'vehicleList:';
		if(vehicleList){
			vehicleList = JSON.parse(vehicleList);
			vehicleList = vehicleList.map(struct => {return parseVehicleList(struct)});
			vehicleList = vehicleList.map(obj => {
								obj.priority = stringToNumber(obj.priority);
								obj.bgm = stringToNumber(obj.bgm);
								obj.stepSE = obj.stepSE.map(se => {return se ? JSON.parse(se) : emptySE});
								return obj;
							});
			vehicleList = vehicleList.map(obj => {
								obj.bgm = stringToBoolean(obj.bgm);
								obj.stepSE = obj.stepSE.map(se => {return stringToNumber(se)});
								return obj;
							});
			vehicleList = vehicleList.map(obj => {return stringToBoolean(obj)});	
		}else{
			vehicleList = [];
			undefinedStructs.push(consolerNameVehicles);
			consolerNameVehicles += makeInvalidTerm();
		}
		
		consoler(consolerNameVehicles, vehicleList);
		//check to contain other plugin
		const YEPSlipValid = PluginManager.containsPlugin('yep_slipperytiles');

const _Game_CharacterBase_prototype_initMembers_B = Game_CharacterBase.prototype.initMembers;
Game_CharacterBase.prototype.initMembers = function(){
	_Game_CharacterBase_prototype_initMembers_B.apply(this, arguments);
	this._vehicleBush = false;
	this._noSlip = false;
};//*

const _Game_Player_prototype_initMembers_B = Game_Player.prototype.initMembers;
Game_Player.prototype.initMembers = function() {
   _Game_Player_prototype_initMembers_B.apply(this, arguments);
   this._vehicleShift = 0;
   this._vehiclePassableType = 'walk';
   this._noSlip = false;
   this._followersTempVisible = false;
};//*


//for Game_Map
if(fieldValid && vehicleValid){
	const _Game_Map_prototype_createVehicles = Game_Map.prototype.createVehicles;
	Game_Map.prototype.createVehicles = function() {
	    _Game_Map_prototype_createVehicles.apply(this, arguments);
	    const initId = this._vehicles.length;
	    vehicleList.map((vehicle, index) => {this._vehicles[initId + index] = new Game_Vehicle(vehicle.type)});
	};//*

	const _Game_Map_prototype_vehicle = Game_Map.prototype.vehicle;
	Game_Map.prototype.vehicle = function(type) {
		let vehicle = _Game_Map_prototype_vehicle.apply(this, arguments);
		if(vehicle){
			return vehicle;
		}else{
			const vehicles = this.vehicles();
			const id = vehicles.findIndex(obj => obj._type === type);
			if(id >= 0){
				return vehicles[id];
			}else{
				return null;
			}
		}
	};//*
}////

Game_Map.prototype.collideVehicles = function(){
	let vehicles = this.vehicles().filter((obj, index) => {return index > 2});
	return vehicles.filter(vehicle => {return vehicle._collide});
};//*
if(!fieldValid || !vehicleValid) Game_Map.prototype.collideVehicles = function(){return false};


Game_Map.prototype.airships = function(){
	return this.vehicles().filter(vehicle => {return vehicle.isSomeAirships()});
};//*
if(!fieldValid || !vehicleValid) Game_Map.prototype.airships = function(){return false};


Game_Map.prototype.currentAirship = function(){
	const airships = this.airships();
	const id = airships.findIndex(ship => ship._driving);
	return id >= 0 ? airships[id] : null;
};//*
if(!fieldValid || !vehicleValid) Game_Map.prototype.currentAirship = function(){return null};

if(fieldValid && vehicleValid){
	const _Game_Map_prototype_updateVehicles = Game_Map.prototype.updateVehicles;
	Game_Map.prototype.updateVehicles = function() {
	    this._vehicles.forEach(function(vehicle) {
	        if(vehicle.isPlayerVehicle()) vehicle.update(); //不都合が出れば、この条件式をvehicleのupdateに移動
	    });
	};//*
}////


//for Game_CharacterBase	
if(fieldValid && vehicleValid){
	const _Game_CharacterBase_prototype_isCollidedWithVehicles = Game_CharacterBase.prototype.isCollidedWithVehicles;
	Game_CharacterBase.prototype.isCollidedWithVehicles = function(x, y) {
		const BoatOrShip = _Game_CharacterBase_prototype_isCollidedWithVehicles.apply(this, arguments);
		if(BoatOrShip){
			const sameHillBoat = this.checkOnHillWithCharacter($gameMap.boat());
			const sameHillShip = this.checkOnHillWithCharacter($gameMap.ship());
			return sameHillBoat || sameHillShip;
		}else{
			const vehicles = $gameMap.collideVehicles();
			if(vehicles.length > 0){
				return vehicles.some(vehicle => {
					return vehicle.posNt(x, y) && this.checkOnHillWithCharacter(vehicle);
				});
			}else{
				return false;
			}
		}
	};//*

	const _Game_CharacterBase_prototype_refreshBushDepth = Game_CharacterBase.prototype.refreshBushDepth;
	Game_CharacterBase.prototype.refreshBushDepth = function() {
		if(this._vehicleBush){
			this._bushDepth = 12;
		}else{
			_Game_CharacterBase_prototype_refreshBushDepth.apply(this, arguments);
		}
	};//*
}////

Game_CharacterBase.prototype.setVehicleBush = function(value){
	this._vehicleBush = value;
	this.refreshBushDepth();
};//*
if(!fieldValid || !vehicleValid) Game_CharacterBase.prototype.setVehicleBush = function(value){};


Game_CharacterBase.prototype.setSlipMode = function(value){
	this._noSlip = value;
};//*
if(!fieldValid || !vehicleValid) Game_CharacterBase.prototype.setSlipMode = function(value){};


Game_CharacterBase.prototype.noSlip = function(){
	return this._noSlip;
};//*
if(!fieldValid || !vehicleValid) Game_CharacterBase.prototype.noSlip = function(){return false};


//for Game_Player

if(fieldValid){
	// //**ファンクションをfieldValid下で常時使えるようにするため、一部ファンクションの条件を緩和
	const _Game_Player_prototype_getOnVehicle = Game_Player.prototype.getOnVehicle;
	Game_Player.prototype.getOnVehicle = function() {
	    var direction = this.direction();
	    var x1 = this.x;
	    var y1 = this.y;
	    var x2 = $gameMap.roundXWithDirection(x1, direction);
	    var y2 = $gameMap.roundYWithDirection(y1, direction);
	    this.updateVehicleType(x1, y1, x2, y2); //**

	    if (this.isInVehicle()) {
	        this._vehicleGettingOn = true;
	       if (this.vehicle()._collide || !this.isInSomeAirships()) {
	            this.forceMoveForward();
	        }
	        this.gatherFollowers();
	        this.tempHideFollowers(); //executed only when vehicleValid is true
	    }
	    return this._vehicleGettingOn;
	};//*

	const _Game_Player_prototype_updateVehicleGetOn = Game_Player.prototype.updateVehicleGetOn;
	Game_Player.prototype.updateVehicleGetOn = function() {
	    if (!this.areFollowersGathering() && !this.isMoving()) {
	    	const vehicle = this.vehicle();
	    	if(vehicle._obeyDirection){
	    		vehicle.setDirection(this.direction());
	    	}else{
	    		this.setDirection(vehicle.direction());	
	    	}
	        this.setMoveSpeed(vehicle.moveSpeed());
	        this._vehicleGettingOn = false;
	        this.copyPositionOnStride(this.vehicle()); //**
	        this.setTransparent(vehicle.needTransparent());
	        if (this.isInAirship() || this.isInOriginalAirship()) {
	            this.setThrough(true);
	        }
	        vehicle.getOn();
	    }
	};//*
}////

if(fieldValid && vehicleValid){
	const _Game_Player_prototype_shiftY = Game_Player.prototype.shiftY;
	Game_Player.prototype.shiftY = function() {
		let shift = _Game_Player_prototype_shiftY.apply(this, arguments);
		return shift + this._vehicleShift;
	};//*

	const _Game_Player_prototype_isInVehicle = Game_Player.prototype.isInVehicle;
	Game_Player.prototype.isInVehicle = function(){
		return $gameMap.vehicles().some(vehicle => {return this._vehicleType === vehicle._type}); 
	};//*


	const _Game_Player_prototype_getOffVehicle = Game_Player.prototype.getOffVehicle;
	Game_Player.prototype.getOffVehicle = function() {
		if (this.vehicle().isLandOk(this.x, this.y, this.direction())) {
	        if (!this.vehicle()._collide && this.isInSomeAirships()) {
	            this.setDirection(2);
	        }
	        this._followers.synchronize(this.x, this.y, this.direction());
	        this.vehicle().getOff();
	        this.setMoveSpeed(this.initialSpeed());
	        if (!this.isInSomeAirships()) {
	            this.forceMoveForward();
	            this.setTransparent(false);
	            this.setVehicleShift(0);
	        }
	        this._vehicleGettingOff = true;
	        this.setVehicleBush(false);
	        this.setThrough(false);
	        this.setPriorityType(1);
	        this.makeEncounterCount();
	        this.gatherFollowers();
	        this.tempShowFollowers();
	        
	    }
	    return this._vehicleGettingOff;
	};//*	

	const _Game_Player_prototype_updateVehicleGetOff = Game_Player.prototype.updateVehicleGetOff;
	Game_Player.prototype.updateVehicleGetOff = function() {
	    if (!this.areFollowersGathering() && this.vehicle().isLowest()) {
	        if (!this.isTransparent() && this.isInSomeAirships()) {
	            this.forceMoveForward();
	            this.setVehicleShift(0);
	        }
	        this._vehiclePassableType = 'walk';
	    };
	    _Game_Player_prototype_updateVehicleGetOff.apply(this, arguments);
	};//*

	const _Game_Player_prototype_canStartLocalEvents = Game_Player.prototype.canStartLocalEvents;
	Game_Player.prototype.canStartLocalEvents = function() {
		const inAirship = _Game_Player_prototype_canStartLocalEvents.apply(this, arguments);
	    return inAirship ? !this.isInOriginalAirship() : inAirship;
	};//*

	const _Game_Player_prototype_canEncounter = Game_Player.prototype.canEncounter;
	Game_Player.prototype.canEncounter = function() {
	    const encount = _Game_Player_prototype_canEncounter.apply(this, arguments);
	    if(encount && this.isInVehicle()){
	    	return !this.isInAirship() && this.vehicle()._encount;
	    }else{
	    	return encount;
	    }
	};//*

	const _Game_Player_prototype_isOnDamageFloor = Game_Player.prototype.isOnDamageFloor;
	Game_Player.prototype.isOnDamageFloor = function() {
	   	const damage = _Game_Player_prototype_isOnDamageFloor.apply(this, arguments);
	    if(damage && this.isInVehicle()){
	    	return !this.isInAirship() && this.vehicle()._damageFloor;
	    }else{
	    	return damage;
	    }
	};//*
}////

Game_Player.prototype.setVehicleShift = function(shiftY){
	this._vehicleShift = shiftY;
};//*
if(!fieldValid || !vehicleValid) Game_Player.prototype.setVehicleShift = function(shiftY){};


Game_Player.prototype.isInSomeAirships = function(){
	return this.isInAirship() || this.isInOriginalAirship() || this.isInCarpet() || this.isInDragon();
};//*
if(!fieldValid || !vehicleValid) Game_Player.prototype.isInSomeAirships = function(){return false};


Game_Player.prototype.isInOriginalBoat = function(){
	return this._vehiclePassableType === 'riverboat';
};//*
if(!fieldValid || !vehicleValid) Game_Player.prototype.isInOriginalBoat = function(){return false};


Game_Player.prototype.isInOriginalShip = function(){
	return this._vehiclePassableType === 'seaship';
};//*
if(!fieldValid || !vehicleValid) Game_Player.prototype.isInOriginalShip = function(){return false};


Game_Player.prototype.isInOriginalAirship = function(){
	return this._vehiclePassableType === 'skyship';
};//*
if(!fieldValid || !vehicleValid) Game_Player.prototype.isInOriginalAirship = function(){return false};


Game_Player.prototype.isInCarpet = function(){
	return this._vehiclePassableType === 'carpet';
};//*
if(!fieldValid || !vehicleValid) Game_Player.prototype.isInCarpet = function(){return false};


Game_Player.prototype.isInDragon = function(){
	return this._vehiclePassableType === 'dragon';
};//*
if(!fieldValid || !vehicleValid) Game_Player.prototype.isInDragon = function(){return false};


Game_Player.prototype.isInBuggy = function(){
	return this._vehiclePassableType === 'buggy';
};//*
if(!fieldValid || !vehicleValid) Game_Player.prototype.isInBuggy = function(){return false};


Game_Player.prototype.isInCar = function(){
	return this._vehiclePassableType === 'car';
};//*
if(!fieldValid || !vehicleValid) Game_Player.prototype.isInCar = function(){return false};


Game_Player.prototype.tempHideFollowers = function(){
	if(this.followers().isVisible()){
		this._followersTempVisible = true;
		this.followers().hide();
		this.followers().refresh();
	}
};//*
if(!fieldValid || !vehicleValid) Game_Player.prototype.tempHideFollowers = function(){};


//vehicleValidの影響を追加乗り物のみに抑えるため、無条件ファンクションとする
Game_Player.prototype.updateVehicleType = function(x, y, dirX, dirY){
	if ($gameMap.airship().getonRange(x, y)) {
	        this._vehicleType = 'airship';
	} else if ($gameMap.ship().getonRange(dirX, dirY)) {
	        this._vehicleType = 'ship';
    } else if ($gameMap.boat().getonRange(dirX, dirY)) {
	        this._vehicleType = 'boat';
    }else if(vehicleValid){
	    	let vehicles = $gameMap.vehicles().filter(vehicle => {return !vehicle.isDefaultType()});
	    	let id = vehicles.findIndex(vehicle => vehicle._collide ? vehicle.getonRange(dirX, dirY) : vehicle.getonRange(x, y));
	    	if(id >= 0) {
	    		this._vehicleType = vehicles[id]._type;
	    		this._vehiclePassableType = vehicles[id]._passableType;
	    		this.setVehicleBush(vehicles[id]._playerBush);
	    		if(!this.isInSomeAirships() && !vehicles[id].needTransparent()){
	    			this.setVehicleShift(vehicles[id].maxAltitude() + 24);
	    		};
	    	}
	}
};//*


Game_Player.prototype.tempShowFollowers = function(){
	if(this._followersTempVisible){
		this._followersTempVisible = false;
		this.followers().show();
		this.followers().refresh();
	}
};//*
if(!fieldValid || !vehicleValid) Game_Player.prototype.tempShowFollowers = function(){};


//updateVehicleGetonで自由に使えるように、vehicleValid条件を解除
Game_Player.prototype.copyPositionOnStride = function(vehicle){
	if(this.strideBase() !== 0){
		this._x = vehicle._x;
		this._y = vehicle._y;
		this._realX = vehicle._realX;
		this._realY = vehicle._realY;	
	}
};//*
if(!fieldValid) Game_Player.prototype.copyPositionOnStride = function(vehicle){};


Game_Player.prototype.noSlip = function(){
	if(this.vehicle()){
		return this.vehicle().noSlip();
	}else{
		return Game_CharacterBase.prototype.noSlip.call(this);
	}
};//*
if(!fieldValid || !vehicleValid) Game_Player.prototype.noSlip = function(){return false};


if(fieldValid && YEPSlipValid){
		Game_Player.prototype.onSlipperyFloor = function() {
			if(this.noSlip()) return false;
		    return Game_CharacterBase.prototype.onSlipperyFloor.call(this);
		};//*
};////


//for Game_Vehicle
if(fieldValid && vehicleValid){
	const _Game_Vehicle_prototype_initMoveSpeed = Game_Vehicle.prototype.initMoveSpeed;
	Game_Vehicle.prototype.initMoveSpeed = function() {
		let speed = $gamePlayer ? $gamePlayer.initialSpeed() : fieldBasic.defaultSpeed || 4;
	    if (this.isBoat()) {
	        speed += 0;
	    } else if (this.isShip()) {
	       speed += 1;
	    } else if (this.isAirship()) {
	        speed += 2;
	    }else{
	    	const vehicle = this.getVehicleData();
	    	if(vehicle) speed += vehicle.speed;
	    }
	    this.setMoveSpeed(speed);
	};//*

	const _Game_Vehicle_prototype_vehicle = Game_Vehicle.prototype.vehicle;
	Game_Vehicle.prototype.vehicle = function() {
	    let vehicle = _Game_Vehicle_prototype_vehicle.apply(this, arguments);
	    if(vehicle){
	    	return vehicle;
	    }else{
	    	vehicle = this.getVehicleData();
	    	return vehicle ? vehicle : null;
	    }
	};//*

	const _Game_Vehicle_prototype_loadSystemSettings = Game_Vehicle.prototype.loadSystemSettings;
	Game_Vehicle.prototype.loadSystemSettings = function() {
	    var vehicle = this.vehicle();
	    if(vehicle){
		    _Game_Vehicle_prototype_loadSystemSettings.apply(this, arguments); 
		    this._maxAltitude = vehicle.altitude >= 0 ? vehicle.altitude : 48;
		    this._collide = !!vehicle.collide;
		    if(this.isBoat() || this.isShip()) this._collide = true;
		    this._passableType = vehicle.passableType || this._type;
		    this._needTransparent = this.setNeedTransparent(vehicle);
		    this._directionPriority = vehicle.priority ? vehicle.priority : [0, 0, 0, 0];
		    this._playerBush = this.setVehicleBush(vehicle);
		   	this._encount = this.setVehicleEncount(vehicle);
		   	this._damageFloor = this.setVehicleDamageFloor(vehicle);
		   	this._noSlip = this.setVehicleNoSlip(vehicle);
		   	this._obeyDirection = this.setVehicleObeyDirection(vehicle);
		   	this._stepSE = vehicle.stepSE ? vehicle.stepSE : [emptySE];
		   	if(vehicle.startDirection) this.setDirection(vehicle.startDirection);
	    }
	};//*

	const _Game_Vehicle_prototype_refresh = Game_Vehicle.prototype.refresh;
	Game_Vehicle.prototype.refresh = function() {
		_Game_Vehicle_prototype_refresh.apply(this, arguments);
		if(!this.isDefaultType()){
			this._collide ? this.setPriorityType(1) : this.setPriorityType(this._driving ? 2 : 0);
		}
	};//*

	const _Game_Vehicle_prototype_isMapPassable = Game_Vehicle.prototype.isMapPassable;
	Game_Vehicle.prototype.isMapPassable = function(x, y, d) {
	    var x2 = $gameMap.roundXWithDirection(x, d);
	    var y2 = $gameMap.roundYWithDirection(y, d);
	
	    if (this.isBoat() || this.isOriginalBoat()) {
	        	return $gameMap.isBoatPassable(x2, y2);

	    } else if (this.isShip() || this.isOriginalShip()) {
	        	return $gameMap.isShipPassable(x2, y2);

	    } else if (this.isAirship() || this.isOriginalAirship() ) {
	        	return true;

	    } else if (this.isDragon()){
	    		return this.isDragonPassable(x, y, x2, y2, d);

	    } else if (this.isCarpet()){
	    		return this.isCarpetPassable(x, y, x2, y2, d);

	    } else if (this.isBuggy()){
	    		return this.isBuggyPassable(x2, y2);

	    } else if (this.isCar() ){
	    		return Game_CharacterBase.prototype.isMapPassable.call(this, x, y, d);

	    }else{
	        	return false;
	    }
	};//*

	const _Game_Vehicle_prototype_playBgm = Game_Vehicle.prototype.playBgm;
	Game_Vehicle.prototype.playBgm = function() {
		const bgm = this.vehicle().bgm;
		if(!bgm.mapAudio){
			if(mapBgmsCondition && bgm.libraryId && mapBgms[bgm.libraryId]){
				$gameVariables.setValue(mapBgmsCondition, bgm.libraryId);
			}else{
				_Game_Vehicle_prototype_playBgm.apply(this, arguments);	
			}
		}
	};//*

	const _Game_Vehicle_prototype_maxAltitude = Game_Vehicle.prototype.maxAltitude;
	Game_Vehicle.prototype.maxAltitude = function() {
	    if(this.isDefaultType()){
	    	return _Game_Vehicle_prototype_maxAltitude.apply(this, arguments);
	    }else{
	    	return this._maxAltitude;
	    }
	};//*

	const _Game_Vehicle_prototype_update = Game_Vehicle.prototype.update;
	Game_Vehicle.prototype.update = function() {
	    Game_Character.prototype.update.call(this);
	    if (this.isSomeAirships() || this.isAirship()) {
	        this.updateAirship();
	    }
	    if(!this.needTransparent()){
	    	this.updatePlayerPriority();
	    }
	};//*

	const _Game_Vehicle_prototype_updateAirshipAltitude = Game_Vehicle.prototype.updateAirshipAltitude;
	Game_Vehicle.prototype.updateAirshipAltitude = function() {
		_Game_Vehicle_prototype_updateAirshipAltitude.apply(this, arguments);
		if(this.isSomeAirships() && !this.needTransparent()){
			$gamePlayer.setVehicleShift(this._altitude + (this.isLowest() ? 0 : 24));
		}
	};//*

	/*---------------*/
	const _Spriteset_Map_prototype_updateShadow = Spriteset_Map.prototype.updateShadow;
	Spriteset_Map.prototype.updateShadow = function() {
	    var airship = $gameMap.currentAirship();
	    if(airship){
	    	this._shadowSprite.x = airship.shadowX();
		    this._shadowSprite.y = airship.shadowY();
		    this._shadowSprite.opacity = airship.shadowOpacity();	
	    }else{
	    	_Spriteset_Map_prototype_updateShadow.apply(this, arguments);
	    }
	};//*
};////

Game_Vehicle.prototype.isOriginalBoat = function() {
	const vehicle = this.getVehicleData();
   	return vehicle ? vehicle.passableType === 'riverboat' : false;
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.isOriginalBoat = function() {return false};


Game_Vehicle.prototype.isOriginalShip = function() {
  	const vehicle = this.getVehicleData();
   	return vehicle ? vehicle.passableType === 'seaship' : false; 
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.isOriginalShip = function() {return false};


Game_Vehicle.prototype.isOriginalAirship = function() {
   	return this._passableType === 'skyship';
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.isOriginalAirship = function() {return false};


Game_Vehicle.prototype.isDefaultType = function(){
	return this.isBoat() || this.isShip() || this.isAirship();
};//*
//乗り物のパラメーターが不十分の時にプレイヤーを透明化できるよう、非適用時は常にtrueを返す
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.isDefaultType = function(){return true};


Game_Vehicle.prototype.isSomeAirships = function(){
	return this.isAirship() || this.isOriginalAirship() || this.isCarpet() || this.isDragon();
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.isSomeAirships = function(){return false};


Game_Vehicle.prototype.isCarpet = function(){
	return this._passableType === 'carpet';
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.isCarpet = function(){return false};


Game_Vehicle.prototype.isDragon = function(){
	return this._passableType === 'dragon';
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.isDragon = function(){return false};


Game_Vehicle.prototype.isBuggy = function(){
	return this._passableType === 'buggy';
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.isBuggy = function(){return false};


Game_Vehicle.prototype.isCar = function(){
	return this._passableType === 'car';
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.isCar = function(){return false};


Game_Vehicle.prototype.getVehicleData = function(){
	const id = vehicleList.findIndex(vehicle => vehicle.type === this._type);
	return id >= 0 ? vehicleList[id] : null;	
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.getVehicleData = function(){return null};


Game_Vehicle.prototype.isPlayerVehicle = function(){
	return $gamePlayer.isInVehicle() && $gamePlayer.vehicle() === this;
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.isPlayerVehicle = function(){return false};


Game_Vehicle.prototype.setNeedTransparent = function(vehicle){
	return typeof vehicle.transparent === 'boolean' ? vehicle.transparent : true;
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.setNeedTransparent = function(vehicle){return true};


Game_Vehicle.prototype.setVehicleBush = function(vehicle){
	return typeof vehicle.bush === 'boolean' ? vehicle.bush : false;
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.setVehicleBush = function(vehicle){return false};


Game_Vehicle.prototype.setVehicleEncount = function(vehicle){
	return typeof vehicle.encount === 'boolean' ? vehicle.encount : true;
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.setVehicleEncount = function(vehicle){return true};


Game_Vehicle.prototype.setVehicleDamageFloor = function(vehicle){
	return typeof vehicle.damageFloor === 'boolean' ? vehicle.damageFloor : true;
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.setVehicleDamageFloor = function(vehicle){return true};


Game_Vehicle.prototype.setVehicleNoSlip = function(vehicle){
	return typeof vehicle.noSlip === 'boolean' ? vehicle.noSlip : false;
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.setVehicleNoSlip = function(vehicle){return false};


Game_Vehicle.prototype.setVehicleObeyDirection = function(vehicle){
	return typeof vehicle.playerDirection === 'boolean' ? vehicle.playerDirection : false;
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.setVehicleObeyDirection = function(vehicle){return false};


//updateVehicleTypeで使えるように、こちらも無条件ファンクションとする
Game_Vehicle.prototype.getonRange = function(x, y){
	if($gamePlayer.stride() < 1){
		if(!this.isAirship() && this._collide){
			//x and y is player's dirX and dirY
			x = $gamePlayer._x;
			y = $gamePlayer._y;
		}
		return $gameMap.radiusDistance(x, y, this._x, this._y) < this.getTouchRange();
	}else{
		return this.pos(x, y);
	}
};//*


Game_Vehicle.prototype.isDragonPassable = function(x, y, x2, y2, d){
	return $gameMap.isBoatPassable(x2, y2) ||
			$gameMap.isShipPassable(x2, y2) ||
			this.isLandOk(x, y, d);
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.isDragonPassable = function(x, y, x2, y2, d){return false};


Game_Vehicle.prototype.isCarpetPassable = function(x, y, x2, y2, d){
	return $gameMap.isBoatPassable(x2, y2) || this.isLandOk(x, y, d);
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.isCarpetPassable = function(x, y, x2, y2, d){return false};


Game_Vehicle.prototype.isBuggyPassable = function(x2, y2){
	return !$gameMap.isBoatPassable(x2, y2) && !$gameMap.isShipPassable(x2, y2);
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.isBuggyPassable = function(x2, y2){return false};


Game_Vehicle.prototype.needTransparent = function(){
	return this.isDefaultType() || this._needTransparent;
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.needTransparent = function(){return true};


Game_Vehicle.prototype.updatePlayerPriority = function(){
	const dir = this.direction() / 2 - 1;
	const dp = this.directionPriority(dir);
	if(dp !== $gamePlayer._priorityType){
		$gamePlayer.setPriorityType(dp);
	}
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.updatePlayerPriority = function(){};


Game_Vehicle.prototype.directionPriority = function(dir){
	const dp = this._directionPriority;
	return dp ? dp[Math.max(0, dir)] : $gamePlayer._priorityType;
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.directionPriority = function(dir){return false};


Game_Vehicle.prototype.stepSE = function(){
	return this._stepSE.length > 0 ? this._stepSE : [emptySE];
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.stepSE = function(){return null};


Game_Vehicle.prototype.customize = function(parts, value, index){
	if(typeof parts === 'string') parts = parts.toLowerCase();
	switch(parts){
		case 'altitude' 	: this.customizeAltitude(value); 	break;
		case 'speed' 		: this.customizeSpeed(value); 		break;
		case 'passable' 	: this.customizePassable(value); 	break;
		case 'encount' 		: this.customizeEncount(value); 	break;
		case 'damagefloor' 	: this.customizeDamageFloor(value); break;
		case 'noslip' 		: this.customizeNoSlip(value); 		break;
		case 'body' 		: this.customizeBody(value, index); break;
		case 'priority' 	: this.customizePriority(value); 	break;
	}
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.customize = function(parts, value, index){};


Game_Vehicle.prototype.customizeAltitude = function(altitude){
	altitude = Number(altitude);
	if(!isNaN(altitude) && altitude >= 0){
		this._maxAltitude = altitude;
	}
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.customizeAltitude = function(altitude){};


Game_Vehicle.prototype.customizeSpeed = function(speed){
	speed = Number(speed);
	if(!isNaN(speed)){
		speed += this.moveSpeed();
		this.setMoveSpeed(speed);
	}
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.customizeSpeed = function(speed){};


Game_Vehicle.prototype.customizePassable = function(type){
	switch(type){
		case 'car':
		case 'buggy':
		case 'riverboat':
		case 'seaship':
		case 'skyship':
		case 'carpet':
		case 'dragon':
			this._passableType = type;
		break;
	}
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.customizePassable = function(type){};


Game_Vehicle.prototype.customizeEncount = function(value){
	value = value !== 'false' ? true : false;
	this._encount = value;
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.customizeEncount = function(value){};


Game_Vehicle.prototype.customizeDamageFloor = function(value){
	value = value !== 'false' ? true : false;
	this._damageFloor = value;
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.customizeDamageFloor = function(value){};


Game_Vehicle.prototype.customizeNoSlip = function(value){
	value = value !== 'false' ? true : false;
	this._noSlip = value;
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.customizeNoSlip = function(value){};


Game_Vehicle.prototype.customizeBody = function(name, index){
	index = Number(index);
	if(!isNaN(index) && index >= 0 && index <= 7){
		this.setImage(name, index);
	}
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.customizeBody = function(name, index){};


Game_Vehicle.prototype.customizePriority = function(array){
	array = array ? JSON.parse(array) : null;
	if(!array) return;
	array = array.map(num => {return Number(num)});
	this._directionPriority = array;
};//*
if(!fieldValid || !vehicleValid) Game_Vehicle.prototype.customizePriority = function(array){};



/*---------------------足音の設定----------------------------------*/

	let stepSE = fieldBasic.valid ? fieldBasic.stepSE : null;
	let consolerNameStepSE = 'stepSE:';
	if(stepSE){
		stepSE = JSON.parse(stepSE);
		stepSE = stepSE.map(se => JSON.parse(se));
		stepSE = stepSE.map(element =>{
							element.volume 	= Number(element.volume);
							element.pitch 	= Number(element.pitch);
							element.pan 	= Number(element.pan);
							return element;
						});
	}else{
		stepSE = [];
		undefinedStructs.push(consolerNameStepSE);
		consolerNameStepSE += makeInvalidTerm();
	}
		
	consoler(consolerNameStepSE, stepSE);

const stepSEValid = fieldValid && fieldBasic.stepSEValid && stepSE.length > 0;
if(stepSEValid){
	const _Game_Player_prototype_moveStraight = Game_Player.prototype.moveStraight;
	Game_Player.prototype.moveStraight = function(d) {
		_Game_Player_prototype_moveStraight.apply(this, arguments);
		if(this.isMovementSucceeded() && !this.isNoStepSe()){
			this.playStepSE();
		}
	};//*

	const _Game_Event_prototype_moveStraight = Game_Event.prototype.moveStraight;
	Game_Event.prototype.moveStraight = function(d) {
		_Game_Event_prototype_moveStraight.apply(this, arguments);
	  	if( this.isMovementSucceeded() && !this.isNoStepSe() ){
	  		this.playStepSE();
		} 
	};//*

	const _Game_CharacterBase_prototype_initMembers_C = Game_CharacterBase.prototype.initMembers;
	Game_CharacterBase.prototype.initMembers = function(){
		_Game_CharacterBase_prototype_initMembers_C.apply(this, arguments);
		this._caution = false;
	};//*
};////

Game_Player.prototype.isNoStepSe = function(){
	const members = $gameParty.battleMembers();
	let hasNoStepSe = false;
	members.forEach(actor => {
		if(!hasNoStepSe) hasNoStepSe = actor.checkNoStepSe();
	})
	return hasNoStepSe;
};//*
if(!stepSEValid) Game_Player.prototype.isNoStepSe = function(){return false};

Game_Actor.prototype.checkNoStepSe = function(){
	const actorNoStepSe = !!this.actor().meta.noStepSe;
	const classNoStepSe = !!this.currentClass().meta.noStepSe;
	const equipNoStepSe = this.equips().some(equip => {return equip && equip.meta.noStepSe});
	const stateNoStepSe = this.states().some(state => {return state && state.meta.noStepSe});
	
	return actorNoStepSe || classNoStepSe || equipNoStepSe || stateNoStepSe;
};//*
if(!stepSEValid) Game_Actor.prototype.checkNoStepSe = function(){return false};

Game_Event.prototype.isNoStepSe = function(){
	return this.event().meta.noStepSe;
};//*
if(!stepSEValid) Game_Event.prototype.isNoStepSe = function(){return false};

Game_Player.prototype.playStepSE = function(){
	const terTag = this.terrainTag();
	const SEs = vehicleValid && this.isInVehicle() ? this.vehicle().stepSE() : stepSE;
	const SE = SEs[terTag] ? SEs[terTag] : SEs[0];
	if(SE.name){
		AudioManager.playSe(SE);
		this.makeStepHearing();
	}
};//*
if(!stepSEValid) Game_Player.prototype.playStepSE = function(){};


Game_Player.prototype.makeStepHearing = function(){
	const leader = $gameParty.leader();
	const paramId = fieldBasic.hearingStatus;
	if(leader.param(paramId) > 0){
		const x = (this.scrolledX() + 0.5) * $gameMap.tileWidth();
		const y = (this.scrolledY() + 0.5) * $gameMap.tileHeight();
		let radius = leader.param(paramId) * $gameMap.tileWidth();
		this.makeStepCollider(x, y, radius);
	}
};//*
if(!stepSEValid) Game_Player.prototype.makeStepHearing = function(){};


Game_Player.prototype.makeStepCollider = function(x, y, radius){
	const events = $gameMap.screenEvents();
	events.map(e => {
		if(!e.isPlayingAction()){
				const defHearing = fieldBasic.searchLimitHearing;
				const enemy = e.event().meta.enemy ? e.eventEnemy() : null;
				const hearing = enemy ? $dataEnemies[enemy.enemyId()].meta.hearing : e.event().meta.hearing;
				const range = (hearing >= 0 ? hearing : defHearing) * $gameMap.tileWidth();
				if(range > 0){
					const eX = (e.scrolledX() + 0.5) * $gameMap.tileWidth();
					const eY = (e.scrolledY() + 0.5) * $gameMap.tileHeight();
					if(Math.pow(x - eX, 2) + Math.pow(y - eY, 2) <= Math.pow(radius + range, 2)){
						e.findPlayerWithHearing();
					} 
				}
		}
	});
};//*
if(!stepSEValid) Game_Player.prototype.makeStepCollider = function(x, y, radius){};


Game_Event.prototype.findPlayerWithHearing = function(){
	this.turnTowardPlayer();
	this.setCaution();
};//*
if(!stepSEValid) Game_Event.prototype.findPlayerWithHearing = function(){};


Game_Event.prototype.playStepSE = function(){
	const terTag = this.terrainTag();
	const SE = stepSE[terTag] ? stepSE[terTag] : stepSE[0];
	AudioManager.playSe(SE);
};//*
if(!stepSEValid) Game_Event.prototype.playStepSE = function(){};



Game_Event.prototype.setCaution = function(){
	if(!this.isCaution()){
		this._caution = true;
		this.powerfulHearing();	
	}	
};//*
if(!stepSEValid) Game_Event.prototype.setCaution = function(){};


Game_Event.prototype.isCaution = function(){
	return this._caution;
};//*
if(!stepSEValid) Game_Event.prototype.isCaution = function(){return false};


Game_Event.prototype.stopCaution = function(){
	if(this.isCaution()){
		this._caution = false;	
	}
};//*
if(!stepSEValid) Game_Event.prototype.stopCaution = function(){};


Game_Event.prototype.powerfulHearing = function(){
	if(this._eventEnemy){
		const enemy = this.eventEnemy();
		const meta = $dataEnemies[enemy.enemyId()].meta.powerfulHearing;
		if(meta){
			this.setWarning();
		}
	}
};//*
if(!stepSEValid) Game_Event.prototype.powerfulHearing = function(){};




/******************************************************************************************/
/*---------------------移動歩幅の調整--------------------------------------*/
	
Game_Player.prototype.setInitialStride = function(){
	this._strideBase = fieldValid && fieldBasic.stride ? 1/fieldBasic.stride - 1 : 0; //指数部分
	this._stride = this.calcStride(); //実際の歩数
};//*


Game_Player.prototype.stride = function(){
	return this.isInVehicle() && !this._vehicleGettingOn ? 1 : this._stride;
};//*
if(!fieldValid) Game_Player.prototype.stride = function(){return 1};


Game_Player.prototype.strideBase = function(){
	return this._strideBase;
};//*
if(!fieldValid) Game_Player.prototype.strideBase = function(){return 0};


Game_Player.prototype.calcStride = function(){
	return 1 / Math.pow(2, this.strideBase());
};//*
if(!fieldValid) Game_Player.prototype.calcStride = function(){return 1};


Game_Player.prototype.changeStride = function(value){
	if(value){
		this._strideBase += value;
	}else{
		this._strideBase = (this._strideBase + 1) % 2;
	}
	this._strideBase = this._strideBase.clamp(0, 1);
	this._stride = this.calcStride();
};//*
if(!fieldValid) Game_Player.prototype.changeStride = function(value){};

if(fieldValid){
	Game_Map.prototype.isNormalStride = function(x,y){
		return $gamePlayer.stride() === 1 || this.isIntCoordinate(x,y);
	};//*

	Game_Map.prototype.isIntCoordinate = function(x, y){
		return this.isIntCoordinateX(x) && this.isIntCoordinateY(y);
	};//*

	Game_Map.prototype.isIntCoordinateX = function(x){
		return (x * 10) % 10 === 0;
	};//*

	Game_Map.prototype.isIntCoordinateY = function(y){
		return (y * 10) % 10 === 0;
	};//*

	Game_Map.prototype.makeArroundCoordinate = function(x, y){
		//小数持ちの座標を周囲の整数座標の配列オブジェクトに変換する
		const fx = Math.floor(x);
		const cx = Math.ceil(x);
		const fy = Math.floor(y);
		const cy = Math.ceil(y);
		return [{'x': fx, 'y': fy},
				{'x': cx, 'y': fy},
				{'x': fx, 'y': cy},
				{'x': cx, 'y': cy}];
	};//*

	Game_Map.prototype.makeArroundCoordinateWithDirection = function(x, y, d){
		const fx = Math.floor(x);
		const cx = Math.ceil(x);
		const fy = Math.floor(y);
		const cy = Math.ceil(y);
		switch(d){
			case 2 : return [{'x':fx, 'y':cy}, {'x':cx,'y':cy}]; break;
			case 4 : return [{'x':fx, 'y':fy}, {'x':fx,'y':cy}]; break;
			case 6 : return [{'x':cx, 'y':fy}, {'x':cx,'y':cy}]; break;
			case 8 : return [{'x':fx, 'y':fy}, {'x':cx,'y':fy}]; break;
			default: return [{'x':fx, 'y':cy}, {'x':cx,'y':cy}];
		}
	};//*

	const _Game_Map_prototype_isLadder = Game_Map.prototype.isLadder;
	Game_Map.prototype.isLadder = function(x, y) {	
		const flags = this.tilesetFlags();
		
		if(this.isNormalStride(x,y)){
			let events = this.tileEventsXy(x,y);
			return _Game_Map_prototype_isLadder.apply(this, arguments) ||
					events.some(e => {return (flags[e._tileId] & 0x20) !== 0});
		}else{
			const arround = this.makeArroundCoordinateWithDirection(x, y, 8);
			return arround.some(arr =>{
				if(!this.isValid(arr.x, arr.y)) return false;

				let events = this.tileEventsXy(arr.x, arr.y);
				if(events.length > 0 && 
					events.some(e => {return (flags[e._tileId] & 0x20) !== 0})) return true;
				
				return this.checkLayeredTilesFlags(arr.x, arr.y, 0x20);
			});	
		}
	};//*

	const _Game_Map_prototype_isBush = Game_Map.prototype.isBush;
	Game_Map.prototype.isBush = function(x, y) {
		if(this.isNormalStride(x,y)){
			return _Game_Map_prototype_isBush.apply(this, arguments);
		}else{
			const arround = this.makeArroundCoordinateWithDirection(x,y,2);
			return arround.some(arr => {
				return this.isValid(arr.x, arr.y) &&
						this.checkLayeredTilesFlags(arr.x, arr.y, 0x40);
			});
		}
	};//*

	const _Game_Map_prototype_isCounter = Game_Map.prototype.isCounter;
	Game_Map.prototype.isCounter = function(x, y) {
		if(this.isNormalStride(x,y)){
			return _Game_Map_prototype_isCounter.apply(this, arguments);
		}else{
			const arround = this.makeArroundCoordinateWithDirection(x, y, $gamePlayer.direction());
			return arround.some(arr => {
				return this.isValid(arr.x, arr.y) &&
						this.checkLayeredTilesFlags(arr.x, arr.y, 0x80);
			});
		}
	};//*

	const _Game_Map_prototype_isDamageFloor = Game_Map.prototype.isDamageFloor;
	Game_Map.prototype.isDamageFloor = function(x, y) {
		if(this.isNormalStride(x,y)){
			return _Game_Map_prototype_isDamageFloor.apply(this, arguments);
		}else{
			let floodedBody = 0;
			const arround = this.makeArroundCoordinate(x,y);
			arround.forEach(arr =>{
				if( this.isValid(arr.x, arr.y) &&
						this.checkLayeredTilesFlags(arr.x, arr.y, 0x100) ){
					floodedBody ++;
				}
			});

			return floodedBody >= ( states.floodedBody || 2 );
		}
	};//*

	const _Game_Map_prototype_terrainTag = Game_Map.prototype.terrainTag;
	Game_Map.prototype.terrainTag = function(x, y){
		if($gamePlayer.stride() === 1){
			return _Game_Map_prototype_terrainTag.apply(this, arguments);
		}else{
			x = Math.floor(x);
			y = Math.floor(y);
			if (this.isValid(x, y)) {
		        var flags = this.tilesetFlags();
		        var tiles = this.layeredTiles(x, y);
		        for (var i = 0; i < tiles.length; i++) {
		            var tag = flags[tiles[i]] >> 12;
		            if (tag > 0) {
		                return tag;
		            }
		        }
		    }
		    return 0;
		}
	};//*

	const _Game_Map_prototype_regionId = Game_Map.prototype.regionId;
	Game_Map.prototype.regionId = function(x, y) {
		if($gamePlayer.stride() === 1){
			return _Game_Map_prototype_regionId.apply(this, arguments);
		}else{
			const arround = this.makeArroundCoordinate(x,y);
			for(var i = 0; i < arround.length; i++){
				let regionId = this.tileId(arround[i].x, arround[i].y, 5);
				if(regionId > 0 && this.isValid(arround[i].x, arround[i].y)) return regionId;
			}
		    return 0;	
		}
	};//*

		//キャラクターの方向から移動先・元の座標を割り出す。デフォルトはstride = 1
		//this._realXでは前者２つ、this.xでは後者２つを計算に用いる。
		//roundはマップのループ設定への対応用
	const _Game_Map_prototype_xWithDirection = Game_Map.prototype.xWithDirection;
	Game_Map.prototype.xWithDirection = function(x, d) {
	    return x + (d === 6 ? $gamePlayer.stride() : d === 4 ? -1 * $gamePlayer.stride() : 0);
	};

	const _Game_Map_prototype_yWithDirection = Game_Map.prototype.yWithDirection;
	Game_Map.prototype.yWithDirection = function(y, d) {
	    return y + (d === 2 ? $gamePlayer.stride() : d === 8 ? -1 * $gamePlayer.stride() : 0);
	};

	const _Game_Map_prototype_roundXWithDirection = Game_Map.prototype.roundXWithDirection;
	Game_Map.prototype.roundXWithDirection = function(x, d) {
	    return this.roundX(x + (d === 6 ? $gamePlayer.stride() : d === 4 ? -1 * $gamePlayer.stride() : 0));
	};

	const _Game_Map_prototype_roundYWithDirection = Game_Map.prototype.roundYWithDirection;
	Game_Map.prototype.roundYWithDirection = function(y, d) {
	    return this.roundY(y + (d === 2 ? $gamePlayer.stride() : d === 8 ? -1 * $gamePlayer.stride() : 0));
	};

		//タイルの通行判定を読むために、座標の小数点四捨五入を追記。
		//タイル情報は整数座標でしか設定されていないらしく、これが無いと通行不可で返される。
		/*24.08.26追記　半歩・四半移動でイベントすり抜けや実行、座標判定に対応修正*/

	const _Game_Map_prototype_isPassable = Game_Map.prototype.isPassable;
	Game_Map.prototype.isPassable = function(x, y, d, character, reversing) {
    	return this.checkPassage(x, y, (1 << (d / 2 - 1)) & 0x0f, character, reversing);
	};//*

	const _Game_Map_prototype_checkPassage = Game_Map.prototype.checkPassage;
	Game_Map.prototype.checkPassage = function(x, y, bit, character, reversing) {
		if($gamePlayer.stride()===1){return _Game_Map_prototype_checkPassage.apply(this, arguments)};
		
		if(reversing === undefined) reversing = character ? false : true;
		//bitから検証中の方角は推察可能。1：下、2：左、4：右、8：上、10：＊、ソレ以上は特殊なチップが対象
		//characterは屋根上にいるかの判定、あるいはbiosする際に必要
		const w = this.width();
		const h = this.height();
		const d = bit < 10 ? Math.log2(bit) * 2 + 2 : 0;
		const tileXY = this.passageCooridinate( Math.floor(x).mod(w),
												Math.ceil(x).mod(w),
												Math.floor(y).mod(h),
												Math.ceil(y).mod(h),
												d);
		return (d === 4 || d === 6) ? this.checkHorizontalPassage(x, y, w, h, tileXY, bit, d, character, reversing) :
					this.checkVerticalPassage(x, y, w, h, tileXY, bit, d, character, reversing);
	};//*

	Game_Map.prototype.checkHorizontalPassage = function(x, y, w, h, tileXY, bit, d, character, reversing){
		//横向きの時はY方向は片方が通れればOK、Xは不通過タイルにめり込まないように。ただしB側にはいくらか制限あり。
		const flags = this.tilesetFlags();
		const tilesLeft1 	= this.allTiles(tileXY.x1, tileXY.y1);
		const tilesRight1 	= this.allTiles(tileXY.x2, tileXY.y2);
	    const tilesLeft2 	= this.allTiles(tileXY.x3, tileXY.y3);
	    const tilesRight2 	= this.allTiles(tileXY.x4, tileXY.y4);
	    //allTilesで取得されるタイルIDは[イベント・B~E層１・B~E層２・A装飾層・A層・影・リージョン]

		x = ( d === 4 ? Math.ceil(x) : Math.floor(x) ).mod(w);
		const y1 = Math.floor(y).mod(h);
		const y2 = Math.ceil(y).mod(h);
		const tilesA = this.allTiles(x, y1);
		const tilesB = this.allTiles(x, y2);//小数座標にいる時の壁の引っかかりを判定
		const regionA = this.regionId(x, y1);
		const regionB = this.regionId(x, y2);

		if(y === y1 && !this.checkPassageTile(x, y1, flags, tilesA, 0x08)) return false;
		if(this.checkWallSideTile(tilesB)) return false;
	    if(this.checkRegionWall(regionA, reversing) ||
	    	this.checkRegionWall(regionB, reversing)) return false;
	    if(this.checkWallTopCorner(tilesLeft1, tilesRight1, tilesLeft2, tilesRight2))return false;
		    
	    let tilesAPassable = this.checkPassageTile(x, y1, flags, tilesA, bit);
	    let tilesBPassable = this.checkPassageTile(x, y2, flags, tilesB, bit);
	    if(this.checkWaterTile(tilesB) && !tilesBPassable) return false;
	    if(!tilesAPassable && this.checkTilesAWallTop(tilesA) && 
	    	(character && !character.isOnHill()) ) return false; //凸内頂点の移動防止
		    
	    return tilesAPassable || tilesBPassable;
	};//*

	Game_Map.prototype.checkVerticalPassage = function(x, y, w, h, tileXY, bit, d, character, reversing){
		//縦向きの時は不通過タイルの角にぶつかった際、めり込まないよう自動的に避ける。
		const flags = this.tilesetFlags();
		const tilesLeft1 	= this.allTiles(tileXY.x1, tileXY.y1);
		const tilesRight1 	= this.allTiles(tileXY.x2, tileXY.y2);
	    const tilesLeft2 	= this.allTiles(tileXY.x3, tileXY.y3);
	    const tilesRight2 	= this.allTiles(tileXY.x4, tileXY.y4);
	    //allTilesで取得されるタイルIDは[イベント・B~E層１・B~E層２・A装飾層・A層・影・リージョン]

		let left1Check = this.checkPassageTile(tileXY.x1, tileXY.y1, flags, tilesLeft1, bit);
	    let right1Check = this.checkPassageTile(tileXY.x2, tileXY.y2, flags, tilesRight1, bit);
	    let left2Check = this.checkPassageTile(tileXY.x3, tileXY.y3, flags, tilesLeft2, bit);
	    let right2Check = this.checkPassageTile(tileXY.x4, tileXY.y4, flags, tilesRight2, bit);
		   
	    if(d === 2 && character){
	    	//tiles3 is used for destination
	    	y = ( Math.floor(y) + 1 ).mod(h);
	    	const x1 = tileXY.x1.mod(w);
	    	const x2 = tileXY.x2.mod(w);
	    	const tilesLeft3 = this.allTiles(x1, y);
	    	const tilesRight3 = this.allTiles(x2, y);
	    	const left3Check = this.checkPassageTile(x1, y, flags, tilesLeft3, bit);
	    	const right3Check = this.checkPassageTile(x2, y, flags, tilesRight3, bit);
	    	
	    	if( this.checkWallSideTile(tilesLeft3) && this.checkWallSideTile(tilesRight3) ){
	    		if(!this.checkPassageTile(x1, y, flags, tilesLeft3, bit) &&
	    			!this.checkPassageTile(x2, y, flags, tilesRight3, bit) ) return false;
	    	}

	    	if( this.checkWaterOnlyTile(tilesLeft3) && this.checkWaterOnlyTile(tilesRight3)){
	    		const WOT_L2 = this.checkWaterOnlyTile(tilesLeft2);
	    		const WOT_R2 = this.checkWaterOnlyTile(tilesRight2);
	    		const WOT_L1 = this.checkWaterOnlyTile(tilesLeft1);
	    		const WOT_R1 = this.checkWaterOnlyTile(tilesRight1);
	    		//walk in water_only_tile like as lava
	    		if( WOT_L2 || WOT_R2 || WOT_L1 || WOT_R1) return left1Check || right1Check;
	    		//walk into water_only_tile
	    		if( !WOT_L2 && !WOT_R2 && !WOT_L1 && !WOT_R1) {
	    			return (left3Check && left1Check) || (right3Check && right1Check);
	    		}

	    		//prevent from leaning out of bridges
	    		return !left1Check || !right1Check;
	    	}

	    	const regionLeft = this.regionId(x1, y);
	    	const regionRight = this.regionId(x2, y);
	    	if( this.checkRegionWall(regionLeft, reversing) &&
	    	 this.checkRegionWall(regionRight, reversing) ) return false;

	    	const left1Wall = this.checkWallTopTileWithLR(tilesLeft1, tilesRight1, tilesLeft2, tilesRight2, 'left');
	    	const right1Wall = this.checkWallTopTileWithLR(tilesLeft1, tilesRight1, tilesLeft2, tilesRight2, 'right');
	    	if(left1Wall) left1Check = false;
	    	if(right1Wall) right1Check = false;
	    }
		   
	    //wall top corner check
	    if(this.checkWallTopCorner(tilesLeft1, tilesRight1, tilesLeft2, tilesRight2)){
	    	left1Check = this.checkWallTopTile(tilesLeft1);
	    	right1Check = this.checkWallTopTile(tilesRight1);
	    	left2Check = this.checkWallTopTile(tilesLeft2);
	    	right2Check = this.checkWallTopTile(tilesRight2);
	   	}

	    return this.checkPassageWithBios(left1Check, right1Check, left2Check, right2Check, character);
	};//*

	Game_Map.prototype.checkFallingTile = function(tiles){
		return this.checkWaterfallTile(tiles) || this.checkWallSideTile(tiles);
	};//*

	Game_Map.prototype.checkWaterTile = function(tiles){
		let isWater = false;
		for(var i = 0; i < tiles.length; i++){
			if(Tilemap.isWaterTile(tiles[i])){
				isWater = true;
				break;
			}
		}
		return isWater;
	};//*

	Game_Map.prototype.checkWaterOnlyTile = function(tiles){
		const isWater = this.checkWaterTile(tiles);
		if(!isWater) return false;

		for(var i = 0; i < tiles.length - 1; i++){
			if(tiles[i] > 0){
				return false;
			}
		}
		return true;
	};//*

	Game_Map.prototype.checkWaterfallTile = function(tiles){
		let isWaterfall = false;
		for(var i = 0; i < tiles.length; i++){
			if(Tilemap.isWaterfallTile(tiles[i])){
				isWaterfall = true;
				break;
			}
		}
		return isWaterfall;
	};//*

	Game_Map.prototype.checkTilesAWallTop = function(tiles){
		//キャラクター上半身側のタイルにおいてチップの状況を返す
		return ( !this.checkWallSideTile(tiles) && this.checkWallTopTile(tiles) ) ||
				this.checkA5WallTopTileLR(tiles);
	};//*

	Game_Map.prototype.checkWallSideTile = function(tiles){
		let isWall = false;
		const flags = this.tilesetFlags();
		for(var i = 0; i < tiles.length; i++){
			let tileId = tiles[i];
			if(Tilemap.isWallSideTile(tileId) || Tilemap.isA5WallSideTile(tileId, flags[tileId])){
				isWall = true;
				break;
			}
		}
		return isWall;
	};//*

	Game_Map.prototype.checkWallTopTile = function(tiles){
		let isWallTop = false;
		const flags = this.tilesetFlags();
		for(var i = 0; i < tiles.length; i++){
			let tileId = tiles[i];
			if(Tilemap.isWallTopTile(tileId) || Tilemap.isA5WallTopTile(tileId, flags[tileId])){
				isWallTop = true;
				break;
			}
		}
		return isWallTop;
	};//*

	Game_Map.prototype.checkA5WallTopTileLR = function(tiles){
		const flags = this.tilesetFlags();
		for(var i = 0; i < tiles.length; i++){
			let tileId = tiles[i];
			if(Tilemap.isTileA5(tileId)){
				let flag = (flags[tileId] & 0x0f);
				if(bitCounter(flag) === 1){
					//３方向が通れる時のみ判定を行う
					return ( flag & 0x02 ) === 0x02 || (flag & 0x04) === 0x04;
				}
			}
		}
		return false;
	};//*

	Game_Map.prototype.checkWallTopCorner = function(tilesL1, tilesR1, tilesL2, tilesR2){
		let corner = 0;
		if(this.checkWallTopTile(tilesL1)) corner++;
		if(this.checkWallTopTile(tilesR1)) corner++;
		if(this.checkWallTopTile(tilesL2)) corner++;
		if(this.checkWallTopTile(tilesR2)) corner++;
		return corner === 3;
	};//*

	Game_Map.prototype.checkWallTopTileWithLR = function(tilesL1, tilesR1, tilesL2, tilesR2, dir){
		//trueになるとbios対象
		if(dir === 'left'){
			return this.checkWallTopTile(tilesL1) && !this.checkWallTopTile(tilesR1)
					&& !this.checkWallTopTile(tilesL2) && !this.checkWallTopTile(tilesR2);
		}else{
			return !this.checkWallTopTile(tilesL1) && this.checkWallTopTile(tilesR1)
					&& !this.checkWallTopTile(tilesL2) && !this.checkWallTopTile(tilesR2);
		}
	};//*

	Game_Map.prototype.checkRegionWall = function(regionId, reversing){
		//reversingはキャラクターの向いている先からの判定チェック時にtrueが入る
		const regionWall = params.regionWall;
		if(reversing && regionWall.length > 0 && regionId > 0){
			return regionWall.contains(regionId);
		}else{
			return false;
		}
	};//*

	Game_Map.prototype.checkPassageTile = function(tileX, tileY, flags, tiles, bit){
		if(this.checkRegionWall( this.regionId(tileX, tileY) )) return false;

		for (var i = 0; i < tiles.length; i++) {
	        var flag = flags[tiles[i]];
	        if ((flag & 0x10) !== 0)  // [*] No effect on passage
	            continue;
	        if ((flag & bit) === 0)   // [o] Passable
	            return true;
	        if ((flag & bit) === bit) // [x] Impassable
	            return false; 
	    }
	    return false;
	};//*

	Game_Map.prototype.passageCooridinate = function (fx, cx, fy, cy, d){
		//船から降りる際は向きが反転していたので、歩幅は１固定となりこの処理は見ないことに
		switch(d){
			case 2: return this.makePassageCoordinate(cx,cy, fx,cy, cx,fy, fx,fy); break;
			case 4: return this.makePassageCoordinate(fx,cy, fx,fy, cx,cy, cx,fy); break;
			case 6: return this.makePassageCoordinate(cx,fy, cx,cy, fx,fy, fx,cy); break;
			case 8: return this.makePassageCoordinate(fx,fy, cx,fy, fx,cy, cx,cy); break;
			default:return this.makePassageCoordinate(cx,cy, fx,cy, cx,fy, fx,fy);
		}
	};//*

	Game_Map.prototype.makePassageCoordinate = function(x1,y1,x2,y2,x3,y3,x4,y4){
		return {'x1': x1, 'y1': y1, 'x2': x2, 'y2': y2, 'x3': x3, 'y3': y3, 'x4': x4, 'y4': y4};
	};//*

	Game_Map.prototype.checkPassageWithBios = function(left1Ok, right1Ok, left2Ok, right2Ok, character){
		if(!character){
			return left1Ok || right1Ok;
		}else if(!left1Ok && !right1Ok){
			return false;
		}else if (left1Ok && right1Ok){
			return true;
		}else if(left1Ok){//right1Ok isfalse
			if(!right2Ok) return true;//any left2Ok
			if(!left2Ok) return false;

			character.setBiosTurn(1);
			return true;
		}else if (right1Ok){//left1Ok isfalse
			if(!left2Ok) return true;//any right2Ok
			if(!right2Ok) return false;

			character.setBiosTurn(-1);
			return true;
		};
	};//*

	const _Game_CharacterBase_prototype_isMapPassable = Game_CharacterBase.prototype.isMapPassable;
	Game_CharacterBase.prototype.isMapPassable = function(x, y, d) {
	    var x2 = $gameMap.roundXWithDirection(x, d);
	    var y2 = $gameMap.roundYWithDirection(y, d);
	    var d2 = this.reverseDir(d);
	    const overpassPassable = this.checkOverpassPassable(x2, y2, d);
	    if(overpassPassable){
	    	return $gameMap.isPassable(x, y, d, this) && $gameMap.isPassable(x2, y2, d2, undefined, true);
	    }else{
	    	return false;
	    }
	};//*

	Game_CharacterBase.prototype.checkOverpassPassable = function(x, y, d){
		//x y is the coordinates of character's opposit position, d is character's direction
	    if(this.isOnOverPass()){
			if(this.isOnHill()){
				const vertical = this.regionId() === fieldBasic.shapingRegions[4];
				if(vertical && !this.isIntXCoordinate(x) && (d===4 || d===6)) {
					const x2 = d===4 ? x - 1 : x + 1;
					return $gameMap.regionId(x2, y);
				}else if(!vertical && !this.isIntYCoordinate(y) && d===2){
					return $gameMap.regionId(x, y+1);
				}

				x = d === 4 ? Math.ceil(x) : d === 6 ? Math.floor(x) : x;
				y = Math.ceil(y);
				const oppositId = $gameMap.regionId(x, y);
	    		return this.isInOverpass(oppositId);
			}else{
				x = d === 4 ? Math.floor(x) : d === 6 ? Math.ceil(x) : x;
				const oppositId = $gameMap.regionId(x, y);
				return oppositId !== fieldBasic.shapingRegions[2];
			}
		}else if(this.isOnStartOverpass()){
			const horizontal = $gameMap.regionId(x, y) === fieldBasic.shapingRegions[3];
			const horzDir = d === 4 || d === 6;
			const isIntY = this.isIntYCoordinate(y);
			const oppositIdDir2 = $gameMap.regionId(
									Math.floor(x) + (d===6 ? 1 : 0), Math.floor(y) + 1);
			const isInOverpass = this.isInOverpass(oppositIdDir2);
			if(horizontal && horzDir && !isIntY && !isInOverpass) return false;
		}
		return true;
	};//*

	Game_CharacterBase.prototype.isOnOverPass = function(){
		if(!overpassPrepared) return false;

		const regionIds = [fieldBasic.shapingRegions[3], fieldBasic.shapingRegions[4]]
		return regionIds.contains(this.regionId());
	};//*

	Game_CharacterBase.prototype.isOnStartOverpass = function(){
		if(!overpassPrepared) return false;

		return this.regionId() === fieldBasic.shapingRegions[2];
	};//*

	Game_CharacterBase.prototype.isInOverpass = function(id){
		if(!overpassPrepared) return false;

		const overPassIds = [fieldBasic.shapingRegions[2],
							 fieldBasic.shapingRegions[3],
							 fieldBasic.shapingRegions[4]];
	    return overPassIds.contains(id);	
	};//*

	const _Game_Player_prototype_startMapEvent = Game_Player.prototype.startMapEvent;
	Game_Player.prototype.startMapEvent = function(x, y, triggers, normal) {
	    if (!$gameMap.isEventRunning()) {
	        $gameMap.eventsXy(x, y).forEach(function(event) {
	            if (event.isTriggerIn(triggers) &&
	            	event.isNormalPriority() === normal &&
	            	event.checkOnHillWithCharacter($gamePlayer)) {
	                event.start();
	            }
	        });
	    }
	};//*

	Game_CharacterBase.prototype.checkOnHillWithCharacter = function(character){
		return this.isOnHill() === character.isOnHill();
	};//*

	const _Game_CharacterBase_prototype_moveStraight = Game_CharacterBase.prototype.moveStraight;
	Game_CharacterBase.prototype.moveStraight = function(d) {
	    this.setMovementSuccess(this.canPass(this._x, this._y, d));
	    if (this.isMovementSucceeded()) {
	        d = this.biosTurn() ? this.executeBiosTurn() : d;
	        this.setDirection(d);
	        this._x = $gameMap.roundXWithDirection(this._x, d);
	        this._y = $gameMap.roundYWithDirection(this._y, d);
	        this._realX = $gameMap.xWithDirection(this._x, this.reverseDir(d));
	        this._realY = $gameMap.yWithDirection(this._y, this.reverseDir(d));
	        this.increaseSteps();
	    } else {
	        this.setDirection(d);
	        this.checkEventTriggerTouchFront(d);
	    }
	};//*


		//24.11.07追記　屋根や崖の後ろに半歩入った際、下半身を隠してより立体的になるように。
		//MZではShaderTilemapクラスがオミットされている上、Tilemapの処理自体変わっているので独立分岐。
		//25.09.18追記　一部ファンクションがMVのみになっていたので、共通処理は外に出した。
	Tilemap.isA5WallTopTile = function(tileId, flag){
		if(this.isTileA5(tileId) && flag > 0){
			return (flag & 0x0f) >= 8 && (flag & 0x01) === 0;
			//上方向の移動が禁止されており、かつ下方向の移動が許可されているチップが対象
		}else{
			return false;
		}
	};//*//MV兼用

	Tilemap.isA5WallSideTile = function(tileId, flag){
		return this.isTileA5(tileId) && flag & 0x0f === 15;
	};//*


	if(MV){
		const _Tilemap_prototype_createLayers = Tilemap.prototype._createLayers;
		Tilemap.prototype._createLayers = function() {
			_Tilemap_prototype_createLayers.apply(this, arguments);

		    const width = this._width;
		    const height = this._height;
		    const margin = this._margin;
		    const tileCols = Math.ceil(width / this._tileWidth) + 1;
		    const tileRows = Math.ceil(height / this._tileHeight) + 1;
		    const layerWidth = tileCols * this._tileWidth;
		    const layerHeight = tileRows * this._tileHeight;
		   
		    this._lowerMiddleBitmap = new Bitmap(layerWidth, layerHeight);
		    this._lowerMiddleLayer = new Sprite();
		    this._lowerMiddleLayer.move(-margin, -margin, width, height);
		    this._lowerMiddleLayer.z = 2;

		    for(var i = 0; i < 4; i++){
		    	this._lowerMiddleLayer.addChild(new Sprite(this._lowerMiddleBitmap));
		    }
		    this.addChild(this._lowerMiddleLayer);

		    this._upperMiddleBitmap = new Bitmap(layerWidth, layerHeight);
		    this._upperMiddleLayer = new Sprite();
		    this._upperMiddleLayer.move(-margin, -margin, width, height);
		    this._upperMiddleLayer.z = 6;

		    for(var i = 0; i < 4; i++){
		    	this._upperMiddleLayer.addChild(new Sprite(this._upperMiddleBitmap));
		    }
		    this.addChild(this._upperMiddleLayer);
		};//*

		Tilemap.prototype._updateLayerPositions = function(startX, startY) {
		    var m = this._margin;
		    var ox = Math.floor(this.origin.x);
		    var oy = Math.floor(this.origin.y);
		    var x2 = (ox - m).mod(this._layerWidth);
		    var y2 = (oy - m).mod(this._layerHeight);
		    var w1 = this._layerWidth - x2;
		    var h1 = this._layerHeight - y2;
		    var w2 = this._width - w1;
		    var h2 = this._height - h1;

		    for (var i = 0; i < 2; i++) {
		        var children;
		        if (i === 0) {
		            children = this._lowerLayer.children;
		        } else {
		            children = this._upperLayer.children;
		        }
		        children[0].move(0, 0, w1, h1);
		        children[0].setFrame(x2, y2, w1, h1);
		        children[1].move(w1, 0, w2, h1);
		        children[1].setFrame(0, y2, w2, h1);
		        children[2].move(0, h1, w1, h2);
		        children[2].setFrame(x2, 0, w1, h2);
		        children[3].move(w1, h1, w2, h2);
		        children[3].setFrame(0, 0, w2, h2);
		    }
		};//*

		Tilemap.prototype._paintTiles = function(startX, startY, x, y) {
		    var tableEdgeVirtualId = 10000;
		    var mx = startX + x;
		    var my = startY + y;
		    var dx = (mx * this._tileWidth).mod(this._layerWidth);
		    var dy = (my * this._tileHeight).mod(this._layerHeight);
		    var lx = dx / this._tileWidth;
		    var ly = dy / this._tileHeight;
		    var tileId0 = this._readMapData(mx, my, 0);
		    var tileId1 = this._readMapData(mx, my, 1);
		    var tileId2 = this._readMapData(mx, my, 2);
		    var tileId3 = this._readMapData(mx, my, 3);
		    var shadowBits = this._readMapData(mx, my, 4);
		    var upperTileId1 = this._readMapData(mx, my - 1, 1);
		    var lowerTiles = [];
		    var upperTiles = [];

		    if (this._isHigherTile(tileId0)) {
		        upperTiles.push(tileId0);
		    } else {
		        lowerTiles.push(tileId0);
		    }
		    if (this._isHigherTile(tileId1)) {
		        upperTiles.push(tileId1);
		    } else {
		        lowerTiles.push(tileId1);
		    }

		    lowerTiles.push(shadowBits);

		    if (this._isTableTile(upperTileId1) && !this._isTableTile(tileId1)) {
		        if (!Tilemap.isShadowingTile(tileId0)) {
		            lowerTiles.push(tableEdgeVirtualId + upperTileId1);
		        }
		    }

		    if (this._isOverpassPosition(mx, my)) {
		        upperTiles.push(tileId2);
		        upperTiles.push(tileId3);
		    } else {
		        if (this._isHigherTile(tileId2)) {
		            upperTiles.push(tileId2);
		        } else {
		            lowerTiles.push(tileId2);
		        }
		        if (this._isHigherTile(tileId3)) {
		            upperTiles.push(tileId3);
		        } else {
		            lowerTiles.push(tileId3);
		        }
		    }

		    var lastLowerTiles = this._readLastTiles(0, lx, ly);
		    if (!lowerTiles.equals(lastLowerTiles) ||
		            (Tilemap.isTileA1(tileId0) && this._frameUpdated)) {
		        this._lowerBitmap.clearRect(dx, dy, this._tileWidth, this._tileHeight);
		        for (var i = 0; i < lowerTiles.length; i++) {
		            var lowerTileId = lowerTiles[i];
		            if (lowerTileId < 0) {
		                this._drawShadow(this._lowerBitmap, shadowBits, dx, dy);
		            } else if (lowerTileId >= tableEdgeVirtualId) {
		                this._drawTableEdge(this._lowerBitmap, upperTileId1, dx, dy);
		            } else {
		                this._drawTile(this._lowerBitmap, lowerTileId, dx, dy);
		            }
		        }
		        this._writeLastTiles(0, lx, ly, lowerTiles);
		    }

		    var lastUpperTiles = this._readLastTiles(1, lx, ly);
		    if (!upperTiles.equals(lastUpperTiles)) {
		        this._upperBitmap.clearRect(dx, dy, this._tileWidth, this._tileHeight);
		        for (var j = 0; j < upperTiles.length; j++) {
		            this._drawTile(this._upperBitmap, upperTiles[j], dx, dy);
		        }
		        this._writeLastTiles(1, lx, ly, upperTiles);
		    }
		};//*

		const _Tilemap_prototype_isOverpassPosition = Tilemap.prototype._isOverpassPosition;
		Tilemap.prototype._isOverpassPosition = function(mx, my) {
			const regionIds = [fieldBasic.shapingRegions[3], fieldBasic.shapingRegions[4]];
		    return overpassPrepared && regionIds.contains($gameMap.regionId(mx, my));
		};//*

			//----------for ShaderTilemap------------------//

		const _ShaderTilemap_prototype_refreshTileset = ShaderTilemap.prototype.refreshTileset;
		ShaderTilemap.prototype.refreshTileset = function() {
		    const bitmaps = this.bitmaps.map(function(x) { return x._baseTexture ? new PIXI.Texture(x._baseTexture) : x; } );
		    this.lowerMiddleLayer.setBitmaps(bitmaps);
		    this.upperMiddleLayer.setBitmaps(bitmaps);
		    this.shadowLayer.setBitmaps(bitmaps);
		    this.shadowUpperLayer.setBitmaps(bitmaps);
		    _ShaderTilemap_prototype_refreshTileset.apply(this, arguments);
		};//*

		const _ShaderTilemap_prototype_createLayers = ShaderTilemap.prototype._createLayers;
		ShaderTilemap.prototype._createLayers = function() {
			_ShaderTilemap_prototype_createLayers.apply(this, arguments);
			
		    if(!this.lowerMiddleZLayer){
		    	//@hackerham: create layers only in initialization. Doesn't depend on width/height
		    	const shadeZ1 = fieldBasic.upperShader ? 2.5 : 0;
		    	const shadeZ2 = shadeZ1 ? 6.5 : 0;
		        this.addChild(this.lowerMiddleZLayer = new PIXI.tilemap.ZLayer(this, 2));
		        this.addChild(this.upperMiddleZLayer = new PIXI.tilemap.ZLayer(this, 6));
		        this.addChild(this.shadowZLayer = new PIXI.tilemap.ZLayer(this, shadeZ1));
		        this.addChild(this.shadowZUpperLayer = new PIXI.tilemap.ZLayer(this, shadeZ2));
		        var parameters = PluginManager.parameters('ShaderTilemap');
		        var useSquareShader = Number(parameters.hasOwnProperty('squareShader') ? parameters['squareShader'] : 0);
		        this.lowerMiddleZLayer.addChild(this.lowerMiddleLayer = new PIXI.tilemap.CompositeRectTileLayer(2, [], useSquareShader));
		        this.upperMiddleZLayer.addChild(this.upperMiddleLayer = new PIXI.tilemap.CompositeRectTileLayer(6, [], useSquareShader));
		        this.shadowZLayer.addChild(this.shadowLayer = new PIXI.tilemap.CompositeRectTileLayer(shadeZ1, [], useSquareShader));
		    	this.shadowZUpperLayer.addChild(this.shadowUpperLayer = new PIXI.tilemap.CompositeRectTileLayer(shadeZ2, [], useSquareShader));
		    }
		};//*

		const _ShaderTilemap_prototype_updateLayerPositions = ShaderTilemap.prototype._updateLayerPositions;
		ShaderTilemap.prototype._updateLayerPositions = function(startX, startY) {
			_ShaderTilemap_prototype_updateLayerPositions.apply(this, arguments);
		   	
		    const ox = this.roundPixels ? Math.floor(this.origin.x) : this.origin.x;
		    const oy = this.roundPixels ? Math.floor(this.origin.y) : this.origin.y;

		    this.lowerMiddleZLayer.position.x = startX * this._tileWidth - ox;
		    this.lowerMiddleZLayer.position.y = startY * this._tileHeight - oy;
		    this.upperMiddleZLayer.position.x = startX * this._tileWidth - ox;
		    this.upperMiddleZLayer.position.y = startY * this._tileHeight - oy;
		    this.shadowZLayer.position.x = startX * this._tileWidth - ox;
		    this.shadowZLayer.position.y = startY * this._tileHeight - oy;
		    this.shadowZUpperLayer.position.x = startX * this._tileWidth - ox;
		    this.shadowZUpperLayer.position.y = startY * this._tileHeight - oy;
		};//*

		const _ShaderTilemap_prototype_paintAllTiles = ShaderTilemap.prototype._paintAllTiles;
		ShaderTilemap.prototype._paintAllTiles = function(startX, startY) {
			this.lowerMiddleZLayer.clear();
			this.upperMiddleZLayer.clear();
			this.shadowZLayer.clear();
			this.shadowZUpperLayer.clear();
			_ShaderTilemap_prototype_paintAllTiles.apply(this, arguments);
		};//*

		const _ShaderTilemap_prototype_paintTiles = ShaderTilemap.prototype._paintTiles;
		ShaderTilemap.prototype._paintTiles = function(startX, startY, x, y) {
		    var mx = startX + x;
		    var my = startY + y;
		    var dx = x * this._tileWidth, dy = y * this._tileHeight;
		    var tileId0 = this._readMapData(mx, my, 0);
		    var tileId1 = this._readMapData(mx, my, 1);
		    var tileId2 = this._readMapData(mx, my, 2);
		    var tileId3 = this._readMapData(mx, my, 3);
		    var shadowBits = this._readMapData(mx, my, 4);
		    //const upperTileId0 = this._readMapData(mx, my - 1, 0);
		    var upperTileId1 = this._readMapData(mx, my - 1, 1);
		    var lowerLayer = this.lowerLayer.children[0];
		    var upperLayer = this.upperLayer.children[0];
		    const lowerMiddleLayer = this.lowerMiddleLayer.children[0];
		    const upperMiddleLayer = this.upperMiddleLayer.children[0];
		    const shadowLayer = this.shadowLayer.children[0];
		    const shadowUpperLayer = this.shadowUpperLayer.children[0];

		    const flags = $gameMap.tilesetFlags();
		    let onHill = !$dataMap.meta.noHill && Tilemap.isWallTopTile(tileId0);

		    if(this._isHigherTile(tileId0) || Tilemap.isRoofTile(tileId0) || onHill){
		    	this._drawTile(upperLayer, tileId0, dx, dy);
		    }else if(Tilemap.isA5WallTopTile(tileId0, flags[tileId0])){
		    	this._drawTile(lowerMiddleLayer, tileId0, dx, dy);
			}else{
		    	this._drawTile(lowerLayer, tileId0, dx, dy);
		    }

		    if(this._isHigherTile(tileId1) || onHill){
		    	this._drawTile(upperLayer, tileId1, dx, dy);
		    }else if(this.isPassableTile(flags[tileId1])){
		    	this._drawTile(lowerLayer, tileId1, dx, dy);
		    }else{
		    	this._drawTile(lowerMiddleLayer, tileId1, dx, dy);
		    }
		    this._drawShadow( (onHill ? shadowUpperLayer : shadowLayer), shadowBits, dx, dy);
		    if (this._isTableTile(upperTileId1) && !this._isTableTile(tileId1)) {
		    	const isShadowing = Tilemap.isShadowingTile(tileId0);
		        if (!isShadowing) this._drawTableEdge(lowerLayer, upperTileId1, dx, dy);
		    }

		    if (this._isOverpassPosition(mx, my)) {
		    	//default always false
		        this._drawTile(upperLayer, tileId2, dx, dy);
		        this._drawTile(upperLayer, tileId3, dx, dy);
		    } else {
		        if (this._isHigherTile(tileId2)) {
		            this._drawTile(upperLayer, tileId2, dx, dy);
		        }else if(this.isPassableTile(flags[tileId2])){
		        	const layer = onHill ? upperLayer : lowerLayer;
		        	this._drawTile(layer, tileId2, dx, dy);
		        }else{
		        	const layer = onHill ? upperMiddleLayer : lowerMiddleLayer;
		        	this._drawTile(layer, tileId2, dx, dy);
		        }

		        if (this._isHigherTile(tileId3)) {
		            this._drawTile(upperLayer, tileId3, dx, dy);
		        }else if(this.isPassableTile(flags[tileId3])){
		        	const layer = onHill ? upperLayer : lowerLayer;
		        	this._drawTile(layer, tileId3, dx, dy);
		        }else{
		        	const layer = onHill ? upperMiddleLayer : lowerMiddleLayer;
		        	this._drawTile(layer, tileId3, dx, dy);
		        }
		    }  
		};//*

		ShaderTilemap.prototype.isPassableTile = function(flag){
			return (flag & 0x0f)===0;
		};//*

		ShaderTilemap.prototype.isSomePassableTile = function(flag){
			return flag && (flag & 0x0f) !== 0;
			//念のため定義
		};//*
	}////
	if(MZ){
		const _Tilemap_prototype_updateTransform = Tilemap.prototype.updateTransform;
		Tilemap.prototype.updateTransform = function() {
		    const ox = Math.ceil(this.origin.x);
		    const oy = Math.ceil(this.origin.y);
		    const startX = Math.floor((ox - this._margin) / this.tileWidth);
		    const startY = Math.floor((oy - this._margin) / this.tileHeight);

		    if(this._lowerMiddleLayer){
		    	this._lowerMiddleLayer.x = startX * this.tileWidth - ox;
		    	this._lowerMiddleLayer.y = startY * this.tileHeight - oy;
		    }
		    if(this._upperMiddleLayer){
		    	this._upperMiddleLayer.x = startX * this.tileWidth - ox;
		    	this._upperMiddleLayer.y = startY * this.tileHeight - oy;
		    }
		    if(this._shadowLayer){
		    	this._shadowLayer.x = startX * this.tileWidth - ox;
		    	this._shadowLayer.y = startY * this.tileHeight - oy;
		    }
		    if(this._shadowUpperLayer){
		    	this._shadowUpperLayer.x = startX * this.tileWidth - ox;
		    	this._shadowUpperLayer.y = startY * this.tileHeight - oy;
		    }
		    _Tilemap_prototype_updateTransform.apply(this, arguments);
		};//*

		const _Tilemap_prototype_createLayers = Tilemap.prototype._createLayers;
		Tilemap.prototype._createLayers = function() {
		    _Tilemap_prototype_createLayers.apply(this, arguments);

		    if(!this.lowerMiddleLayer){
		    	//@hackerham: create layers only in initialization. Doesn't depend on width/height
		    	const shadeZ1 = fieldBasic.upperShader ? 2.5 : 0;
		    	const shadeZ2 = shadeZ1 ? 6.5 : 0;

		    	this._lowerMiddleLayer = new Tilemap.CombinedLayer();
		    	this._lowerMiddleLayer.z = 2;
		    	this._upperMiddleLayer = new Tilemap.CombinedLayer();
		    	this._upperMiddleLayer.z = 6;
		    	this._shadowLayer = new Tilemap.CombinedLayer();
		    	this._shadowLayer.z = shadeZ1;
		    	this._shadowUpperLayer = new Tilemap.CombinedLayer();
		    	this._shadowUpperLayer.z = shadeZ2;


			    this.addChild(this._lowerMiddleLayer);
			    this.addChild(this._upperMiddleLayer);
			    this.addChild(this._shadowLayer);
			    this.addChild(this._shadowUpperLayer);
			    // this._needsRepaint = true はapply内で実行済み
		    }
		};//*

		const _Tilemap_prototype_addAllSpots = Tilemap.prototype._addAllSpots;
		Tilemap.prototype._addAllSpots = function(startX, startY) {
			this._lowerMiddleLayer.clear();
			this._upperMiddleLayer.clear();
			this._shadowLayer.clear();
			this._shadowUpperLayer.clear();

			_Tilemap_prototype_addAllSpots.apply(this, arguments);
		};//*

		const _Tilemap_prototype_addSpot = Tilemap.prototype._addSpot;
		Tilemap.prototype._addSpot = function(startX, startY, x, y) {
		    const mx = startX + x;
		    const my = startY + y;
		    const dx = x * this.tileWidth;
		    const dy = y * this.tileHeight;
		    const tileId0 = this._readMapData(mx, my, 0);
		    const tileId1 = this._readMapData(mx, my, 1);
		    const tileId2 = this._readMapData(mx, my, 2);
		    const tileId3 = this._readMapData(mx, my, 3);
		    const shadowBits = this._readMapData(mx, my, 4);
		    const upperTileId1 = this._readMapData(mx, my - 1, 1); 
		    //MVでは各レイヤーのchildren[0]を取得していたが、MZではaddSpotTile内で直接参照する
		    let onHill = !$dataMap.meta.noHill && Tilemap.isWallTopTile(tileId0);

		    this._addSpotTile(tileId0, dx, dy, 0, onHill);
		    this._addSpotTile(tileId1, dx, dy, 1, onHill);
		    const shadowLayer = onHill ? this._shadowUpperLayer : this._shadowLayer;
		    this._addShadow(shadowLayer, shadowBits, dx, dy);
		    if (this._isTableTile(upperTileId1) && !this._isTableTile(tileId1)) {
		    	const isShadowing = Tilemap.isShadowingTile(tileId0);
		        if (!isShadowing) this._addTableEdge(this._lowerLayer, upperTileId1, dx, dy);
		    }
		    if (this._isOverpassPosition(mx, my)) {
		        this._addTile(this._upperLayer, tileId2, dx, dy);
		        this._addTile(this._upperLayer, tileId3, dx, dy);
		    } else {
		        this._addSpotTile(tileId2, dx, dy, 2, onHill);
		        this._addSpotTile(tileId3, dx, dy, 3, onHill);
		    }
		};//*

		const _Tilemap_prototype_addSpotTile = Tilemap.prototype._addSpotTile;
		Tilemap.prototype._addSpotTile = function(tileId, dx, dy, id, onHill) {
			const flags = $gameMap.tilesetFlags();

			if(id === 0){
				//const upperTileId0 = this._readMapData(mx, my - 1, 0);
				/*
				if (this._isHigherTile(tileId) || Tilemap.isRoofTile(tileId)) {
			        this._addTile(this._upperLayer, tileId, dx, dy);
			    } else if(Tilemap.isWallTopTile(tileId) && Tilemap.isGroundTile(upperTileId0)){
			    	//ここの条件式がなくても機能するか要確認！
			    	this._addTile(this._upperLayer, tileId, dx, dy);
			    }else{
			        this._addTile(this._lowerLayer, tileId, dx, dy);
			    }
			    */
			    if(this._isHigherTile(tileId) || Tilemap.isRoofTile(tileId) || onHill){
			    	this._addTile(this._upperLayer, tileId, dx, dy);
			    }else if(Tilemap.isA5WallTopTile(tileId, flags[tileId])){
			    	this._addTile(this._lowerMiddleLayer, tileId, dx, dy);
				}else{
			    	this._addTile(this._lowerLayer, tileId, dx, dy);
			    }
			}else if(id === 1){
				if(this._isHigherTile(tileId) || onHill){
			    	this._addTile(this._upperLayer, tileId, dx, dy);
			    }else if(this.isPassableTile(flags[tileId])){
			    	this._addTile(this._lowerLayer, tileId, dx, dy);
			    }else{
			    	this._addTile(this._lowerMiddleLayer, tileId, dx, dy);
			    }
			}else if(id > 1){
				if (this._isHigherTile(tileId)) {
		            this._addTile(this._upperLayer, tileId, dx, dy);
		        }else if(this.isPassableTile(flags[tileId])){
		        	const layer = onHill ? this._upperLayer : this._lowerLayer;
		        	this._addTile(layer, tileId, dx, dy);
		        }else{
		        	const layer = onHill ? this._upperMiddleLayer : this._lowerMiddleLayer;
		        	this._addTile(layer, tileId, dx, dy);
		        }
			}else{
				_Tilemap_prototype_addSpotTile.apply(this, arguments);
			}
		};//*

		Tilemap.prototype.isPassableTile = function(flag){
			return (flag & 0x0f)===0;
		};//*

		Tilemap.prototype.isSomePassableTile = function(flag){
			return flag && (flag & 0x0f) !== 0;
			//念のため定義
		};//*
	}////


	const _Game_CharacterBase_prototype_screenZ = Game_CharacterBase.prototype.screenZ;
	Game_CharacterBase.prototype.screenZ = function(){
		if($gamePlayer.stride() === 1){
			return _Game_CharacterBase_prototype_screenZ.apply(this, arguments);
		}else{
			const z = this._priorityType + (this.isOnHill() ? 5 : 1 );
			const isRear = !$gameMap.isPassable(Math.floor(this._x), this._y + 0.5, 2) ||
							!$gameMap.isPassable(Math.ceil(this._x), this._y + 0.5, 2) ||
							this.isUnderA5Hill();
			return z - (isRear ? 0.5 : 0);
		}
	};//*

	Game_CharacterBase.prototype.isUnderA5Hill = function(){
		const tileIdL = $gameMap.tileId(Math.floor(this._x), this._y + 0.5, 0);
		const tileIdR = $gameMap.tileId(Math.ceil(this._x), this._y + 0.5, 0);
		const flags = $gameMap.tilesetFlags();
		return Tilemap.isA5WallTopTile(tileIdL, flags[tileIdL]) || Tilemap.isA5WallTopTile(tileIdR, flags[tileIdR]);
	};//*

	const _Game_CharacterBase_prototype_updateMoveA = Game_CharacterBase.prototype.updateMove;
	Game_CharacterBase.prototype.updateMove = function() {
		_Game_CharacterBase_prototype_updateMoveA.apply(this, arguments);
	    if (!this.isMoving()) this.checkOnHill();
	};//*

	const _Game_CharacterBase_prototype_updateStop = Game_CharacterBase.prototype.updateStop;
	Game_CharacterBase.prototype.updateStop = function() {
		 if(this._stopCount === 0) this.checkOnHill();
		 
		_Game_CharacterBase_prototype_updateStop.apply(this, arguments);
	};//*
}////

Game_CharacterBase.prototype.isOnHill = function(){
	return this._isOnHill;
};//*
if(!fieldValid) Game_CharacterBase.prototype.isOnHill = function(){return false};

Game_Event.prototype.isOnHill = function(){
	return this.event().meta.onHill || Game_CharacterBase.prototype.isOnHill.call(this);
};//*
if(!fieldValid) Game_Event.prototype.isOnHill = function(){return false};

Game_CharacterBase.prototype.startingOnHill = function(){
	return this._startOnHill;
};//*
if(!fieldValid) Game_CharacterBase.prototype.startingOnHill = function(){return false};

Game_CharacterBase.prototype.checkOnHill = function(){
	if($dataMap.meta.noHill || fieldBasic.shapingRegions.length < 2) return false;

	const beginningId = fieldBasic.shapingRegions[0];
	const executionId = fieldBasic.shapingRegions[1];
	const region = this.regionId();
	if(region === beginningId){
		this.setOnHill();
	}else if( region < executionId && this.startingOnHill() ){
		this.cancelOnHill();
	}else if( region === executionId && this.startingOnHill() ){
		this._startOnHill = false;
	}
};//*
if(!fieldValid) Game_CharacterBase.prototype.checkOnHill = function(){};

Game_CharacterBase.prototype.setOnHill = function(){
	this._isOnHill = true;
	this._startOnHill = true;
};//*
if(!fieldValid) Game_CharacterBase.prototype.setOnHill = function(){};

Game_CharacterBase.prototype.cancelOnHill = function(){
	this._isOnHill = false;
	this._startOnHill = false;
};//*
if(!fieldValid) Game_CharacterBase.prototype.cancelOnHill = function(){};

Game_CharacterBase.prototype.setBiosTurn = function(value){
	this._biosTurn = value;
};//*
if(!fieldValid) Game_CharacterBase.prototype.setBiosTurn = function(value){};


Game_CharacterBase.prototype.biosTurn = function(){
	return this._biosTurn;
};//*
if(!fieldValid) Game_CharacterBase.prototype.biosTurn = function(){return false};


Game_CharacterBase.prototype.biosTurnLeft = function(){
	return this._biosTurn > 0;
};//*
if(!fieldValid) Game_CharacterBase.prototype.biosTurnLeft = function(){return false};


Game_CharacterBase.prototype.biosTurnRight = function(){
	return this._biosTurn < 0;
};//*
if(!fieldValid) Game_CharacterBase.prototype.biosTurnRight = function(){return false};


Game_CharacterBase.prototype.executeBiosTurn = function(){
	let d = this._isPlayer ? Input._dir8 : this.direction();
	if(this.biosTurnLeft()) d = d === 8 ? 4 : 6;
	if(this.biosTurnRight()) d = d === 8 ? 6 : 4;	
	this.setBiosTurn(0); 
	return d;
};//*
if(!fieldValid) Game_CharacterBase.prototype.executeBiosTurn = function(){return 0};


Game_Map.prototype.radiusDistance = function (x1, y1, x2, y2){
	//２乗値のまま返るので、比較する距離は２乗を忘れないように
	return this.distance(x1, y1, x2, y2) ** 2 - 2 * Math.abs(this.deltaX(x1, x2)) * Math.abs(this.deltaY(y1, y2));
};//*
if(!fieldValid) Game_Map.prototype.radiusDistance = function (x1, y1, x2, y2){return 0};



		//24.08.27追記　イベントの右半身が通り抜け可能な状態を防ぐため、イベントの衝突判定を円形に調整
if(fieldValid){
	//25.06.20追記　ボタン押下中、方向切替を伴う衝突判定でイベントをすり抜ける不具合あり。万が一のときはcanPassからdirectionを引き継ぐこと。

	const _Game_CharacterBase_prototype_isCollidedWithEvents = Game_CharacterBase.prototype.isCollidedWithEvents;
	Game_CharacterBase.prototype.isCollidedWithEvents = function(x, y) {
		const self = this;
	    var events = $gameMap.eventsXyNt(x, y);
	    return events.some(function(event) {
	        return event.isNormalPriority() && event.checkOnHillWithCharacter(self);
	    });
	};//*

	const _Game_Player_prototype_isCollidedWithEvents = Game_Player.prototype.isCollidedWithEvents;
	Game_Player.prototype.isCollidedWithEvents = function(x, y) {
	    if($gamePlayer.stride() < 1){
	    	const dir = Input._dir4;
	    	const pm = dir % 8 < 4 ? 1 : 3;
	    	const dirs = [dir - pm, dir, dir + pm];
	    	let eventIds = dirs.map((d)=>{return this.checkArroundEventId(d, 'stride', 0)});
	    	return this.checkCollidedEvents(eventIds, dir);
	    }else{
	    	return Game_CharacterBase.prototype.isCollidedWithEvents.call(this, x, y);
	    }
	};//*

	Game_Player.prototype.checkCollidedEvents =function(eventIds, dir){
		if(eventIds[1]) {
			const e = $gameMap.event(eventIds[1]);
			return e.isNormalPriority() && e.checkOnHillWithCharacter(this);
		}
		
		const leftId = dir % 4 === 0 ? eventIds[0] : eventIds[2];
		const rightId = dir % 4 === 0 ? eventIds[2] : eventIds[0];
		const eL = $gameMap.event(leftId);
		const eR = $gameMap.event(rightId);
		if(leftId && rightId){
			return eL.isNormalPriority() && eL.checkOnHillWithCharacter(this) &&
					eR.isNormalPriority() && eR.checkOnHillWithCharacter(this);
		}

		if(this.biosTurnLeft() && leftId){
			return eL.isNormalPriority() && eL.checkOnHillWithCharacter(this);
		}
		if(this.biosTurnRight() && rightId){
			return eR.isNormalPriority() && eR.checkOnHillWithCharacter(this);
		}
		
		return false;
	};//*

	const _Game_Event_prototype_isCollidedWithEvents = Game_Event.prototype.isCollidedWithEvents;
	Game_Event.prototype.isCollidedWithEvents = function(x, y) {
		const meta = this.event().meta.eventThrough;
		if(meta){
			return Game_CharacterBase.prototype.isCollidedWithEvents.call(this, x, y);
		}else{
			const events = $gameMap.eventsXyNt(x, y);
			if(events.length === 0) return false;
			//not need check priority
		    return events.some(event => { return event.checkOnHillWithCharacter(this) });
		}
	};//*

	const _Game_CharacterBase_prototype_pos = Game_CharacterBase.prototype.pos;
	Game_CharacterBase.prototype.pos = function(x, y) {
		if(this.isBigCharacter()){
			//x and y are mover's coordinate and already adjusted by direction, 'this' is target
			const st = $gamePlayer.stride();
	    	const x2 = this.x;
	    	const y2 = this.y;
	    	const arround = [[x2-st,y2],[x2,y2], [x2+st,y2], [x2-st,y2-st], [x2,y2-st], [x2+st,y2-st]];
	    	return arround.some( coordinate => {
	    		return x === $gameMap.roundX(coordinate[0]) &&
	    				y === $gameMap.roundY(coordinate[1]);
	    		});
		}else{
			return _Game_CharacterBase_prototype_pos.apply(this, arguments);
		}
	};//*


		//イベントは歩幅によっては判定がシビアになるため、２点間距離からイベントを検索する。
		//24.08.27追記　同時に２つ以上のイベントが起動され得る問題へ対処。最もPLに距離が近いイベント１つに限定する。
	const _Game_Map_prototype_eventsXy = Game_Map.prototype.eventsXy;
	Game_Map.prototype.eventsXy = function(x, y) {
		if($gamePlayer.stride() < 1){
			let events = this.events().filter(function(event) {
		        return $gameMap.radiusDistance(x, y, event._x, event._y) <= $gameMap.getTouchRange();
		    });
		    if(events.length < 2 || !fieldBasic.restrictEvents){
		    	return events;
		    }else{
		    	const target = events.reduce((resultEv, compareEv) => {
		    		let resultDis = $gameMap.radiusDistance(x, y, resultEv._x, resultEv._y);
		    		let compareDis = $gameMap.radiusDistance(x, y, compareEv._x, compareEv._y);
		    		return compareDis < resultDis ? compareEv : resultEv;
		    	}, events[0]);
		 
		    	return [target];
		    }
		}else{
			return _Game_Map_prototype_eventsXy.apply(this, arguments);
		}
	};//*

	const _Game_Player_prototype_moveStraight = Game_Player.prototype.moveStraight;
	Game_Player.prototype.moveStraight = function(d) {
	   	_Game_Player_prototype_moveStraight.apply(this, arguments);
	    if (this.stride() < 1){
	    	if(this.isMovementSucceeded()){
	    		this.checkEventTriggerTouchFront(d);	
	    	}else if(this.biosTurn()){
	    		this.setBiosTurn(0);
	    	}
	    }
	};//*

	const _Game_Event_prototype_moveStraight = Game_Event.prototype.moveStraight;
	Game_Event.prototype.moveStraight = function(d) {
	   	_Game_Event_prototype_moveStraight.apply(this, arguments);
	    if ($gamePlayer.stride() < 1 && this.isMovementSucceeded()) {
	    	this.checkEventTriggerTouchFront(d);
	    }
	};//*

	const _Game_Event_prototype_checkEventTriggerTouch = Game_Event.prototype.checkEventTriggerTouch;
	Game_Event.prototype.checkEventTriggerTouch = function(x, y) {
	    if (!$gameMap.isEventRunning()) {
	    	if($gamePlayer.stride() < 1){
	    		if (this._trigger === 2 && $gamePlayer.eventRange(this._x, this._y)) {
		            if (!this.isJumping() && this.isNormalPriority()) {
		                this.start();
		            }
		        }
	    	}else{
	    		_Game_Event_prototype_checkEventTriggerTouch.apply(this, arguments);
	    	};
	    }
	};//*
}////

Game_Player.prototype.eventRange = function(eventX, eventY){
	return $gameMap.radiusDistance(this._x, this._y, eventX, eventY) <= this.getTouchRange();
}
if(!fieldValid) Game_Player.prototype.eventRange = function(eventX, eventY){return false};


		/*24.08.24追記　イベントがリージョンIDや地形タグを読み取った際、整数マスに収まっているかを判定する処理*/
Game_CharacterBase.prototype.isIntCoordinate = function(real){
	let x = real === 'real' ? this._realX : this.x;
	let y = real === 'real' ? this._realY : this.y;
	return this.isIntXCoordinate(x) && this.isIntYCoordinate(y);
};//*
if(!fieldValid) Game_CharacterBase.prototype.isIntCoordinate = function(real){return false};


Game_CharacterBase.prototype.isIntXCoordinate = function (x){
	return ( x * 10 ) % 10 === 0;
};//*
if(!fieldValid) Game_CharacterBase.prototype.isIntXCoordinate = function (x){return false};


Game_CharacterBase.prototype.isIntYCoordinate = function (y){
	return ( y * 10 ) % 10 === 0;
};//*
if(!fieldValid) Game_CharacterBase.prototype.isIntYCoordinate = function (y){return false};


	/*---------動くイベントと合致したかどうかを見る処理を追加。小数点座標への対策。--------------*/
Game_CharacterBase.prototype.checkArroundEventId = function(direction, distance, forPlayer){
	const dir = Number(direction) || this.direction();
	const range = distance === 'stride' ? $gamePlayer.stride() : (Number(distance) >= 0 ? Number(distance) : 1);
	const x = $gameMap.roundX( this.x + range * (dir % 3 === 1 ? -1 : (dir % 3 === 0 ? 1 : 0) ) );
	const y = $gameMap.roundY( this.y + range * (dir % 10 >= 7  ? -1 : (dir % 10 <=3 ? 1 : 0) ) );
	if(forPlayer){
		//event searches for player
		return x === $gamePlayer.x && y === $gamePlayer.y ? -1 : 0;
	}else{
		if(this.isPlayer){
			const events = $gameMap.screenEvents().filter((event)=>{ return event.pos(x,y) });
			return events.length > 0 ? events[0].eventId() : 0;		
		}else{
			const events = $gameMap.events().filter((event)=>{return event.pos(x,y)});
			const others = events.filter((event)=>{return event.eventId() !== this.eventId()});
			return others.length > 0 ? others[0].eventId() : 0;	
		}
	}
};//*
if(!fieldValid) Game_CharacterBase.prototype.checkArroundEventId = function(direction, distance, forPlayer){return 0};


Game_CharacterBase.prototype.getArroundEventIds = function(range, isCross){
	let eventIds = [];
	const t = Number(isCross) ? 2 : 1;
	for (var i = 1; i < 10/t; i++){
		eventIds.push(this.checkArroundEventId(i*t, range));
	}
	return eventIds;
};//*
if(!fieldValid) Game_CharacterBase.prototype.getArroundEventIds = function(range, isCross){return []};


Game_CharacterBase.prototype.isInTargetEvent = function(eventId, distance, isCross){
	const targetId = Number(eventId) > 0 ? Number(eventId) : 0;
	const range = distance === 'stride' ? $gamePlayer.stride() : Number(distance) >= 0 ? Number(distance) : 1;
	if(targetId > 0){
		const eventIds = this.getArroundEventIds(range, isCross);
		return eventIds.some( id => {return id === targetId});
	}else{
		//search player
		return this.isArroundPlayer(range, isCross);
	}
};//*
if(!fieldValid) Game_CharacterBase.prototype.isInTargetEvent = function(eventId, distance, isCross){return false};


Game_CharacterBase.prototype.isArroundPlayer = function(range, isCross){
	let playerIds = [];
	const t = Number(isCross) ? 2 : 1;
	for (var i = 1; i < 10/t; i++){
		playerIds.push(this.checkArroundEventId(i*t, range, true));
	}
	return playerIds.some( id => {return id === -1});
};//*
if(!fieldValid) Game_CharacterBase.prototype.isArroundPlayer = function(range, isCross){return false};



	/*-----------イベントの出現条件の１つ変数を強化。＝条件や２つ目の変数条件を付与できるように。-----------*/
if(fieldValid) {
	const _Game_Event_prototype_findProperPageIndex = Game_Event.prototype.findProperPageIndex;
	Game_Event.prototype.findProperPageIndex = function() {
	    var pages = this.event().pages;
	    for (var i = pages.length - 1; i >= 0; i--) {
	        var page = pages[i];
	        //add argument to meetConditions function
	        if (this.meetsConditions(page, i)) {
	            return i;
	        }
	    }
	    return -1;
	};//*


	const _Game_Event_prototype_meetsConditions = Game_Event.prototype.meetsConditions;
	Game_Event.prototype.meetsConditions = function(page, pageIndex) {
	    const formerResult = _Game_Event_prototype_meetsConditions.apply(this, arguments);
	    if(!formerResult){
	    	return formerResult;
	    }else{
	    	//added conditions
	    	return this.meetsAddedConditions(page, pageIndex);
	    }
	};//*
}////

Game_Event.prototype.meetsAddedConditions = function(page, pageIndex){
	let c = page.conditions;
	    
    if (c.variableValid) {
    	let meta = this.event().meta;
    	//justVariable
    	if(meta.justVariable){
    		const jvResult = this.checkJustVariableCondition(pageIndex, c, meta.justVariable);
    		if(!jvResult){
    			return false;	
    		}
    	}
    	//secondVariable
    	if(meta.secondVariable){
    		const svResult = this.checkSecondVariableCondition(pageIndex, meta.secondVariable);
    		if(!svResult){
    			return false;
    		}
    	}
    }
	    
    return true;
};//*
if(!fieldValid) Game_Event.prototype.meetsAddedConditions = function(page, pageIndex){return true};


Game_Event.prototype.checkJustVariableCondition = function(pageIndex, c, jv){
	const targets = JSON.parse(jv);
	if(targets.contains(pageIndex + 1)){
		return $gameVariables.value(c.variableId) === c.variableValue;
	}

	return true;
};//*
if(!fieldValid) Game_Event.prototype.checkJustVariableCondition = function(pageIndex, c, jv){return true};


Game_Event.prototype.checkSecondVariableCondition = function(pageIndex, sv){
   	const obj = JSON.parse(sv);
   	const index = obj.findIndex(o => o.page === pageIndex + 1);
   	if(index >= 0){
   		const id = obj[index].id;
	   	const operator = obj[index].op;
	   	const value = obj[index].value;
	   	if(typeof id !== 'number' || typeof value !== 'number' || id < 0){
	    		return false; //cannot ignore this condition
	    }else{
		    	const variable = $gameVariables.value(id);
			    switch(operator){
			    	case '＞'	: case 'g' 	: return variable > value; break;
			    	case '＞＝' 	: case 'ge'	: return variable >= value; break;
			    	case '＝'	: case 'e'	: return variable === value; break;
			    	case '＜＝'	: case 'le' : return variable <= value; break; 
			    	case '＜'	: case 'l' 	: return variable < value; break;
			    	default 	: return false;
			    }
	    }
	}
   	
    return true;
};//*
if(!fieldValid) Game_Event.prototype.checkSecondVariableCondition = function(pageIndex, sv){return true};





/******************************************************************************************/
/*----------------振り向き設定---------------------------------*/
const directionKeys = ['down', 'left', 'right', 'up'];
const nonDirectionKeys = Object.values(Input.keyMapper).filter(key => {return !directionKeys.contains(key)});

if(fieldValid) {
	const _Game_Player_prototype_getInputDirection = Game_Player.prototype.getInputDirection;
	Game_Player.prototype.getInputDirection = function() {
		if( this.canTurnByInput() && !this.isOnLadder()){
				this.setDirection(Input.dir4);
				return 0;
		}else{
				return _Game_Player_prototype_getInputDirection.apply(this, arguments);	
		}
	};//*
}////

Game_Player.prototype.canTurnByInput = function(){
	return fieldValid &&
			fieldBasic.turnAround > 0 &&
			Input.isPressedDirection() &&
			Input._pressedTime <= fieldBasic.turnAround;
};//*
if(!fieldValid) Game_Player.prototype.canTurnByInput = function(){return false};


Input.isPressedDirection = function(){
	return directionKeys.some( dir => {return Input.isPressed(dir)} ) &&
				!nonDirectionKeys.some( key => {return Input.isPressed(key)} );
};//*
if(!fieldValid) Input.isPressedDirection = function(){return false};



/******************************************************************************************/
/*---------------リーダー画像の設定-------------------*/

Game_Party.prototype.leaderId = function(){
	if(!this._leaderId) this.setLeaderId(fieldBasic.leader);
	return this._leaderId;
};//*
if(!fieldValid) Game_Party.prototype.leaderId = function(){return 0};


Game_Party.prototype.setLeaderId = function(id){
	this._leaderId = id;
};//*
if(!fieldValid) Game_Party.prototype.setLeaderId = function(id){};


if(fieldValid){
	const _Game_Party_prototype_leader = Game_Party.prototype.leader;
	Game_Party.prototype.leader = function() {
		const id = this.leaderId();
		if(fieldValid && id > 0 ){
				const leader = $gameActors.actor(id);
				const inParty = this._actors.indexOf(id) >= 0;
				return inParty ? leader : this.battleMembers()[0];
		}else{
				return this.battleMembers()[0];
		}
	};//*
}////

/******************************************************************************************/
/*------------------------複数パーティの設定----------------------------------*/

		/*~struct~MultiParty:ja
			@param 	party
			@type 		number
			@text 		パーティの数
			@desc 		2以上にすると複数パーティが使用可能になります。1の時はデフォルトのままです。
			@default 	1
			@min 		1
			@max 		5
			@decimals 	0

			@param 	startId
			@type 		number
			@text 		パーティの初期ID
			@desc 		ゲーム開始時のパーティのIDを0〜5で設定します。0は1と同じ扱いですが、ファストトラベルの解放情報を共有します。
			@default 	0
			@min 		0
			@max 		5
			@decimals 	0

			@param 	commonItems
			@type 		boolean
			@text 		アイテムの共有
			@desc 		On（true）の時、複数パーティの間で所持品やお金が共有されます。
			@default 	true

			@param 	editInherit
			@type 		boolean
			@text 		編成引き継ぎ
			@desc 		On（true）の時、パーティ編成UIを呼び出す際に既存のパーティ構成も呼び出します。
			@default 	false

			@param 	addMenu
			@type 		boolean
			@text 		メニューへの追加
			@desc 		On（true）の時、メニューにパーティ選択のコマンドを追加します。編成UIはプラグインコマンドからのみ開けます。
			@default 	true

			@param 	fontSize
			@type 		number
			@text 		編成UI　ヘルプ文字サイズ
			@desc 		編成UIにおいて、ヘルプウィンドウの文字サイズを設定します。
			@default 	21
			@decimals 	0
			@min 		12
			@max 		28

			@param 	messages
			@type 		struct<MultiPartyMessages>
			@text 		編成UI　テキストリスト
			@desc 		編成UIで表示するテキストのリストを設定します。

			@param 	messagesSelector
			@type 		struct<MultiPartyMessagesSelector>
			@text 		選択UI　テキストリスト
			@desc 		選択UIで表示するテキストのリストを設定します。
		*/
		/*----------------------------------------------------------------------------------------------------------*/
		/*~struct~MultiParty:
			@param 	party
			@type 		number
			@text 		number of parties
			@desc 		Control the number of parties
			@default 	1
			@min 		1
			@max 		5
			@decimals 	0

			@param 	startId
			@type 		number
			@text 		initial ID of Party
			@desc 		Control the ID between 0 and 5; 0 works as 1 for Party, but works to share released camps for FastTravel
			@default 	0
			@min 		0
			@max 		5
			@decimals 	0

			@param 	commonItems
			@type 		boolean
			@text 		share items among parties
			@desc 		Share items and gold among parties when this is true
			@default 	true

			@param 	editInherit
			@type 		boolean
			@text 		inherit members
			@desc 		Inherit members on editing parties when this is true
			@default 	false

			@param 	addMenu
			@type 		boolean
			@text 		add selector to menu
			@desc 		Add a command for selecting a pary to menu when this is true
			@default 	true

			@param 	fontSize
			@type 		number
			@text 		editor help font size
			@desc 		Control the font size
			@default 	21
			@decimals 	0
			@min 		12
			@max 		28

			@param 	messages
			@type 		struct<MultiPartyMessages>
			@text 		text list for the editor UI
			@desc 		Define texts displayed in editor

			@param 	messagesSelector
			@type 		struct<MultiPartyMessagesSelector>
			@text 		text list for the selector UI
			@desc 		Define texts displayed in selector
		*/
		/******************************************************************************************/
				/*~struct~MultiPartyMessages:ja
					@param 	direction
					@type 		string
					@text 		指示メッセージ
					@desc 		編成UIのヘルプウィンドウにおいて、振り分けの指示を行うメッセージを設定します。
					@default 	パーティを振り分けて下さい

					@param 	editHelpSelectParty
					@type 		string
					@text 		編成UI　ヘルプ　選択
					@desc 		編成UIにおいて、パーティ選択時のヘルプテキストを設定します。
					@default 	編成するパーティを選択します

					@param 	operatePartyScroll
					@type 		string
					@text 		編成UI　操作説明　スクロール
					@desc 		編成UIにおいて、パーティ選択中のスクロールキーの説明を設定します。
					@default 	パーティ選択

					@param 	operatePartyEnter
					@type 		string
					@text 		編成UI　操作説明　決定
					@desc 		編成UIにおいて、パーティ選択中の決定キーの説明を設定します。
					@default 	決定

					@param 	operatePartyCancel
					@type 		string
					@text 		編成UI　操作説明　キャンセル
					@desc 		編成UIにおいて、パーティ選択中のキャンセルキーの説明を設定します。
					@default 	戻る

					@param 	editCommandParty
					@type 		string
					@text 		編成UI　コマンド　選択
					@desc 		編成UIにおいて、パーティ選択時のコマンド名を設定します。
					@default 	パーティ選択

					@param 	editHelpSelectChara
					@type 		string
					@text 		編成UI　ヘルプ　編成
					@desc 		編成UIにおいて、メンバー編成時のヘルプテキストを設定します。
					@default 	パーティを編成します

					@param 	operateCharaScroll
					@type 		string
					@text 		編成UI　操作説明　スクロール
					@desc 		編成UIにおいて、メンバー編成時のスクロールキーの説明を設定します。
					@default 	ウィンドウ切替

					@param 	operateCharaShift
					@type 		string
					@text 		編成UI　操作説明　シフト
					@desc 		編成UIにおいて、メンバー編成時のシフトキーの説明を設定します。
					@default 	並び替え

					@param 	operateCharaEnter
					@type 		string
					@text 		編成UI　操作説明　決定
					@desc 		編成UIにおいて、メンバー編成時の決定キーの説明を設定します。
					@default 	編成

					@param 	operateCharaCancel
					@type 		string
					@text 		編成UI　操作説明　キャンセル
					@desc 		編成UIにおいて、メンバー編成時のキャンセルキーの説明を設定します。
					@default 	戻る

					@param 	editCommandChara
					@type 		string
					@text 		編成UI　コマンド　編成
					@desc 		編成UIにおいて、メンバー編成時のコマンド名を設定します。
					@default 	編成

					@param 	editHelpSelectDecide
					@type 		string
					@text 		編成UI　ヘルプ　決定
					@desc 		編成UIにおいて、UI終了時のヘルプテキストを設定します。
					@default 	パーティ編成を完了します

					@param 	editCommandDecide
					@type 		string
					@text 		編成UI　コマンド　決定
					@desc 		編成UIにおいて、UI終了時のコマンド名を設定します。
					@default 	決定

					@param 	editDialogCommandOk
					@type 		string
					@text 		編成UI　ダイアログ　OK
					@desc 		編成UIにおいて、UI終了時のダイアログコマンド（OK）を設定します。
					@default 	はい

					@param 	editDialogCommandCancel
					@type 		string
					@text 		編成UI　ダイアログ　Cancel
					@desc 		編成UIにおいて、UI終了時のダイアログコマンド（Cancel）を設定します。
					@default 	いいえ

					@param 	editDialogMessageCheck
					@type 		string
					@text 		編成UI　ダイアログ　確認
					@desc 		編成UIにおいて、UI終了時のダイアログコマンド（確認）を設定します。
					@default 	パーティ編成を終了しますか？

					@param 	editDialogMessageCancel
					@type 		string
					@text 		編成UI　ダイアログ　キャンセル
					@desc 		編成UIにおいて、UI終了時のダイアログコマンド（中止）を設定します。
					@default 	パーティ編成を中止しますか？

					@param 	editDialogMessageCaution
					@type 		string
					@text 		編成UI　ダイアログ　注意
					@desc 		編成UIにおいて、パーティに空きがある際の注意メッセージを設定します。
					@default 	メンバーがいないパーティがあります！
				*/
				/*----------------------------------------------------------------------------------------------------------*/
				/*~struct~MultiPartyMessages:
					@param 	direction
					@type 		string
					@text 		editor help of default
					@desc 		Define initial help text in editor
					@default 	Distribute members to parties

					@param 	editHelpSelectParty
					@type 		string
					@text 		editor help of selecting party
					@desc 		Define help text to select a party
					@default 	Select a party

					@param 	operatePartyScroll
					@type 		string
					@text 		editor help of scroll's operator
					@desc 		Define help text for scroll keys in selecting party
					@default 	Select a party

					@param 	operatePartyEnter
					@type 		string
					@text 		editor help of enter's operator
					@desc 		Define help text for enter key in selecting party
					@default 	Decide

					@param 	operatePartyCancel
					@type 		string
					@text 		editor help of cancel's operator
					@desc 		Define help text for cancel key in selecting party
					@default 	Back

					@param 	editCommandParty
					@type 		string
					@text 		editor command of selecting party
					@desc 		Define the command name to select party
					@default 	Party

					@param 	editHelpSelectChara
					@type 		string
					@text 		editor help of editting members
					@desc 		Define help text to edit members
					@default 	Edit members of the party

					@param 	operateCharaScroll
					@type 		string
					@text 		editor help of scroll's operator
					@desc 		Define help text for scroll keys in editting members
					@default 	Change window

					@param 	operateCharaShift
					@type 		string
					@text 		editor help of shift's operator
					@desc 		Define help text for shift key in editting members
					@default 	Swap

					@param 	operateCharaEnter
					@type 		string
					@text 		editor help of enter's operator
					@desc 		Define help text for enter key in editting members
					@default 	Choose

					@param 	operateCharaCancel
					@type 		string
					@text 		editor help of cancel's operator
					@desc 		Define help text for cancel key in editting members
					@default 	Back

					@param 	editCommandChara
					@type 		string
					@text 		editor command of editting members
					@desc 		Define the command name to edit members
					@default 	Members

					@param 	editHelpSelectDecide
					@type 		string
					@text 		editor help of decision
					@desc 		Define help text to close editor
					@default 	Complete editting parties

					@param 	editCommandDecide
					@type 		string
					@text 		editor command of decision
					@desc 		Define the command name to close editor
					@default 	Decision

					@param 	editDialogCommandOk
					@type 		string
					@text 		editor dialog Ok
					@desc 		Define dialog Ok on closing editor
					@default 	OK

					@param 	editDialogCommandCancel
					@type 		string
					@text 		editor dialog Cancel
					@desc 		Define dialog Cancel on closing editor
					@default 	Cancel

					@param 	editDialogMessageCheck
					@type 		string
					@text 		editor dialog Message
					@desc 		Define dialog Message on closing editor
					@default 	Complete editting parties

					@param 	editDialogMessageCancel
					@type 		string
					@text 		editor dialog Cancel
					@desc 		Define dialog Message on canceling
					@default 	Cancel editting parties

					@param 	editDialogMessageCaution
					@type 		string
					@text 		editor dialog Caution
					@desc 		Define dialog Caution on closing editor displayed if an empty party exists
					@default 	Error : Empty party!
				*/
				/********************************************************************/
				/*~struct~MultiPartyMessagesSelector:ja
					@param 	changeMenuCommand
					@type 		string
					@text 		選択UI　メニューコマンド名
					@desc 		選択UIにおいて、メニューに表示するコマンド名を設定します。
					@default 	パーティ切替

					@param 	changeHelp
					@type 		string
					@text 		選択UI　ヘルプ
					@desc 		選択UIにおいて、パーティ選択を促すヘルプメッセージを設定します。
					@default 	変更したいパーティを選択して下さい

					@param 	changePartyName
					@type 		string
					@text 		選択UI　パーティ名
					@desc 		選択UIにおいて、パーティのシステム名を設定します。（例：「パーティ」の時　パーティ1 パーティ2…）
					@default 	パーティ
				*/
				/*----------------------------------------------------------------------------------------------------------*/
				/*~struct~MultiPartyMessagesSelector:
					@param 	changeMenuCommand
					@type 		string
					@text 		selector command in menu
					@desc 		Define a command displayed in menu
					@default 	Party Change

					@param 	changeHelp
					@type 		string
					@text 		selector help text
					@desc 		Define help text displayed in selector
					@default 	Select a main party

					@param 	changePartyName
					@type 		string
					@text 		selector party name
					@desc 		Define system name（ex：when this is "Party", displayed in window as "Party1", "Party2"...）
					@default 	Party
				*/

		const parseMultiParty = s => JSON.parse(s, (key, value)=>{
			switch(key){
				case 'party'			: return Number.parseFloat(value);
				case 'startId'			: return Number.parseFloat(value);
				case 'commonItems' 		: return value;
				case 'editInherit' 		: return value;
				case 'addMenu' 			: return value;
				case 'fontSize' 		: return Number.parseFloat(value);
				case 'messages' 		: return value ? JSON.parse(value) : makeNotValid();
				case 'messagesSelector' : return value ? JSON.parse(value) : makeNotValid();
 				default 			: return value;
			}
		});//*

		let multiParty = params.multiParty;
		let consolerNameMultiParty = 'multiParty:';
		if(multiParty){
				multiParty = parseMultiParty(multiParty);
				multiParty = stringToBoolean(multiParty);
		}else{
				multiParty = makeNotValid();
				undefinedStructs.push(consolerNameMultiParty);
				consolerNameMultiParty += makeInvalidTerm();
		};
			
		consoler(consolerNameMultiParty, multiParty);

		/*~struct~initialMembers:ja
			@param actors
			@type actor[]
			@text 初期パーティメンバー
			@desc このパーティIDの初期メンバーを設定します

			@param gold
			@type 	number
			@text 	初期の所持金
			@desc 	このパーティIDが最初から持っている所持金を設定します
			@decimals 0
			@min 	0
			@max 	99999999
			@default 0

			@param items
			@type 	item[]
			@text 	初期アイテム
			@desc 	このパーティIDが最初から持っているアイテムを設定します

			@param weapons
			@type 	weapon[]
			@text 	初期武器
			@desc 	このパーティIDが最初から持っている武器を設定します

			@param armors
			@type 	armor[]
			@text 	初期防具
			@desc 	このパーティIDが最初から持っている防具を設定します

			@param startMapId
			@type 	number
			@text 	開始時のマップID
			@desc 	このパーティの開始位置となるマップIDを設定します。0にするとデータベースを参照します。
			@decimals 0
			@min 	0
			@max 	999
			@default 0

			@param startMapX
			@type 	number
			@text 	開始時のマップX座標
			@desc 	このパーティの開始位置となるマップのX座標を設定します。マップIDが1以上の時のみ有効です。
			@decimals 0
			@min 	0
			@max 	999
			@default 0

			@param startMapY
			@type 	number
			@text 	開始時のマップY座標
			@desc 	このパーティの開始位置となるマップのY座標を設定します。マップIDが1以上の時のみ有効です。
			@decimals 0
			@min 	0
			@max 	999
			@default 0
		*/
		/*--------------------------------------------------------------------------*/
		/*~struct~initialMembers
			@param actors
			@type actor[]
			@text initial party member
			@desc Edit initial actors in the party of this ID

			@param gold
			@type 	number
			@text 	initial gold
			@desc 	Control initial gold the party of this ID has
			@decimals 0
			@min 	0
			@max 	99999999
			@default 0

			@param items
			@type 	item[]
			@text 	initial items
			@desc 	Edit initial items the party of this ID has

			@param weapons
			@type 	weapon[]
			@text 	initial weapons
			@desc 	Edit initial weapons the party of this ID has

			@param armors
			@type 	armor[]
			@text 	initial armors
			@desc 	Edit initial armors the party of this ID has

			@param startMapId
			@type 	number
			@text 	start map ID
			@desc 	Control map ID the party of this ID starts in; when 0, the party starts in the ID of Database
			@decimals 0
			@min 	0
			@max 	999
			@default 0

			@param startMapX
			@type 	number
			@text 	start map X
			@desc 	Control map X coordinate the party of this ID starts in; this is valid only when startMapId above is over 1
			@decimals 0
			@min 	0
			@max 	999
			@default 0

			@param startMapY
			@type 	number
			@text 	start map Y
			@desc 	Control map Y coordinate the party of this ID starts in; this is valid only when startMapId above is over 1
			@decimals 0
			@min 	0
			@max 	999
			@default 0
		*/

		let initialMembers = params.initialMembers;
		let consolerNameInitialMembers = 'initialMembers';
		if(initialMembers){
				initialMembers = JSON.parse(initialMembers);
				initialMembers = initialMembers.map(data => {
					data = JSON.parse(data);
					data.actors = data.actors ? JSON.parse(data.actors) : [];
					data.actors = data.actors.map(a => {return Number(a)});
					data.gold = Number(data.gold) || 0;
					let items = data.items ? JSON.parse(data.items) : [];
						items = items.map(i => {return Number(i)});
					let itemList = {};
						items.forEach(id => {
							itemList[id] ? itemList[id] ++ : itemList[id] = 1;
						})
					data.items = itemList;
					let weapons = data.weapons ? JSON.parse(data.weapons) : [];
						weapons = weapons.map(w => {return Number(w)});
					let weaponList = {};
						weapons.forEach(id => {
							weaponList[id] ? weaponList[id] ++ : weaponList[id] = 1;
						})
					data.weapons = weaponList;
					let armors = data.armors ? JSON.parse(data.armors) : [];
						armors = armors.map(a => {return Number(a)});
					let armorList = {};
						armors.forEach(id => {
							armorList[id] ? armorList[id] ++ : armorList[id] = 1;
						})
					data.armors = armorList;
					data.startMapId = Number(data.startMapId) || 0;
					data.startMapX = Number(data.startMapX) || 0;
					data.startMapY = Number(data.startMapY) || 0;
					return data;
				})
		}else{
				initialMembers = makeNotValid();
				undefinedStructs.push(consolerNameInitialMembers);
				consolerNameInitialMembers += makeInvalidTerm();
		};

		consoler(consolerNameInitialMembers, initialMembers);

		/*----------*/

const multiPartyValid = fieldValid &&　multiParty.party > 1;


//25.03.24追記　複数パーティの初期設定
Game_Party.prototype.setInitialMembers = function(partyId){
	const data = initialMembers[(partyId || this._id) - 1];
	if(data){
		this._actors = [];
		data.actors.forEach(id => {if($gameActors.actor(id)) this._actors.push(id)});
		this._gold = data.gold;
		this._items = data.items;
		this._weapons = data.weapons;
		this._armors = data.armors;
		if(data.startMapId){
			this._mapId = data.startMapId;
			this._x = data.startMapX;
			this._y = data.startMapY;
			this._respawnMapId = data.startMapId;
			this._respawnX = data.startMapX;
			this._respawnY = data.startMapY;
		}
	}
};//*

const _Game_Player_prototype_reserveTransfer = Game_Player.prototype.reserveTransfer;
Game_Player.prototype.reserveTransfer = function(mapId, x, y, d, fadeType) {
	if(!d && mapId === $dataSystem.startMapId && x === $dataSystem.startX && y === $dataSystem.startY){
		//ニューゲームでの初期位置移動で、データベースの位置に強制移動されるのを上書き
		this._transferring = true;
	    this._newMapId = $gameParty._mapId;
	    this._newX = $gameParty._x;
	    this._newY = $gameParty._y;
	    this._newDirection = d;
	    this._fadeType = fadeType;
	}else{
		_Game_Player_prototype_reserveTransfer.apply(this, arguments);
	}
};//*

//複数パーティ未設定の際、ファストトラベル用にファンクションを準備
Game_Party.prototype.setRespawn = function(mapId, x, y){
	this._respawnMapId = mapId || $gameMap.mapId();
	this._respawnX = x || $gamePlayer._realX;
	this._respawnY = y || $gamePlayer._realY;
};//*
if(!multiPartyValid) Game_Party.prototype.setRespawn = function(mapId, x, y){};


Game_Party.prototype.mapId = function(){
	return this._mapId;
};//*
if(!multiPartyValid) Game_Party.prototype.mapId = function(){return 0};


Game_Party.prototype.setMapId = function(id){
	this._mapId = id ? id : $gameMap.mapId();
};//*
if(!multiPartyValid) Game_Party.prototype.setMapId = function(id){};
			

Game_Party.prototype.x = function(){
	return this._x;
};//*
if(!multiPartyValid) Game_Party.prototype.x = function(){return 0};


Game_Party.prototype.setX = function(x){
	this._x = x ? x : $gamePlayer._realX;
};//*
if(!multiPartyValid) Game_Party.prototype.setX = function(x){};


Game_Party.prototype.y = function(){
	return this._y;
};//*
if(!multiPartyValid) Game_Party.prototype.y = function(){return 0};


Game_Party.prototype.setY = function(y){
	this._y = y ? y : $gamePlayer._realY;
};//*
if(!multiPartyValid) Game_Party.prototype.setY = function(y){};


Game_Party.prototype.respawnMapId = function(){
	return this._respawnMapId;
};//*
if(!multiPartyValid) Game_Party.prototype.respawnMapId = function(){return 0};


Game_Party.prototype.respawnX = function(){
	return this._respawnX;
};//*
if(!multiPartyValid) Game_Party.prototype.respawnX = function(){return 0};


Game_Party.prototype.respawnY = function(){
	return this._respawnY;
};//*
if(!multiPartyValid) Game_Party.prototype.respawnY = function(){return 0};


if(multiPartyValid){
		const _DataManager_createGameObjects = DataManager.createGameObjects;
		DataManager.createGameObjects = function(){
			_DataManager_createGameObjects.apply(this, arguments);
			$gameParty1 = new Game_Party1();
			$gameParty2 = new Game_Party2();
			$gameParty3 = new Game_Party3();
			$gameParty4 = new Game_Party4();
			$gameParty5 = new Game_Party5();
			$gameReserveParty = new Game_ReserveParty();

			$gameParty1.setInitialMembers();
		  	$gameParty2.setInitialMembers();
		  	$gameParty3.setInitialMembers();
		  	$gameParty4.setInitialMembers();
		  	$gameParty5.setInitialMembers();
		};//*

		const _DataManager_makeSaveContents = DataManager.makeSaveContents;
		DataManager.makeSaveContents = function(){
			var contents = _DataManager_makeSaveContents.call(this);
			contents.gameParty1 = $gameParty1;
			contents.gameParty2 = $gameParty2;
			contents.gameParty3 = $gameParty3;
			contents.gameParty4 = $gameParty4;
			contents.gameParty5 = $gameParty5;
			contents.gameReserveParty = $gameReserveParty;
			return contents;
		};//*

		const _DataManager_extractSaveContents = DataManager.extractSaveContents;
		DataManager.extractSaveContents = function(contents){
			_DataManager_extractSaveContents.call(this, contents);
			$gameParty1 = contents.gameParty1;
			$gameParty2 = contents.gameParty2;
			$gameParty3 = contents.gameParty3;
			$gameParty4 = contents.gameParty4;
			$gameParty5 = contents.gameParty5;
			$gameReserveParty = contents.gameReserveParty;
		};//*
}////

const _Game_Party_prototype_initialize_B = Game_Party.prototype.initialize;
Game_Party.prototype.initialize = function(){
	_Game_Party_prototype_initialize_B.apply(this, arguments);
	const valid = multiPartyValid;

	this._id =  valid ? (multiParty.startId || 1) : 1;
	this._mapId = $dataSystem.startMapId;
	this._x = $dataSystem.startX;
	this._y = $dataSystem.startY;
	this._respawnMapId = $dataSystem.startMapId;
	this._respawnX = $dataSystem.startX;
	this._respawnY = $dataSystem.startY;
	this._maxParty = valid ? multiParty.party : 1;

	this._partyNumber = valid ? multiParty.party : 1;
	this._editInherit = valid ? multiParty.editInherit : false;
	this._addSelectMenuCommand = valid ? multiParty.addMenu : false;
};//*

//初期アイテムのことも鑑みて、メンバーのセットアップのみは無条件に使えるように
const _Game_Party_prototype_setupStartingMembers = Game_Party.prototype.setupStartingMembers;
Game_Party.prototype.setupStartingMembers = function() {
	if(initialMembers.length > 0){
		this.setInitialMembers(this._id);
	}else{
		_Game_Party_prototype_setupStartingMembers.apply(this, arguments);
	}
};//*

Game_Party.prototype.setPartyNumber = function(value){
	value = value.clamp(2, 5);
	this._partyNumber = value;
};//*
if(!multiPartyValid) Game_Party.prototype.setPartyNumber = function(value){};


Game_Party.prototype.partyNumber = function(){
	return this._partyNumber;
};//*
if(!multiPartyValid) Game_Party.prototype.partyNumber = function(){return 0};


Game_Party.prototype.setEditInherit = function(value){
	this._editInherit = value;
};//*
if(!multiPartyValid) Game_Party.prototype.setEditInherit = function(value){};


Game_Party.prototype.editInherit = function(){
	return this._editInherit;
};//*
if(!multiPartyValid) Game_Party.prototype.editInherit = function(){return false};


Game_Party.prototype.setSelectMenuCommand = function(value){
	this._addSelectMenuCommand = value;
};//*
if(!multiPartyValid) Game_Party.prototype.setSelectMenuCommand = function(value){};


Game_Party.prototype.selectMenuCommand = function(){
	return this._addSelectMenuCommand;
};//*
if(!multiPartyValid) Game_Party.prototype.selectMenuCommand = function(){return false};

Game_Party.prototype.setAllSelectMenuCommand = function(value){
	this.setSelectMenuCommand(value);
	$gameParty1.setSelectMenuCommand(value);
	$gameParty2.setSelectMenuCommand(value);
	$gameParty3.setSelectMenuCommand(value);
	$gameParty4.setSelectMenuCommand(value);
	$gameParty5.setSelectMenuCommand(value);
};//*
if(!multiPartyValid) Game_Party.prototype.setAllSelectMenuCommand = function(value){};


Game_Party.prototype.swapParty = function(id2){
	id2 = id2 ? id2 : this.setSwapId();
	if(id2 === this.partyId()){return};

	const swapParty = this.setSwapParty(id2);
	const tempParty = $gameParty;
	const id = $gameParty.partyId();
	$gameParty = swapParty
	switch(id){
		case 1 	: $gameParty1 = tempParty; break;
		case 2 	: $gameParty2 = tempParty; break;
		case 3 	: $gameParty3 = tempParty; break;
		case 4 	: $gameParty4 = tempParty; break;
		case 5 	: $gameParty5 = tempParty; break;
		default : $gameParty1 = tempParty;
	}
	if(multiParty.commonItems){
			this.inheritPartyItems(swapParty, tempParty);
	}
	if($gameFastTravel){
			$gameFastTravel.setPartyId($gameFastTravel.relativeMultiParty() ? id2 : 0);
	}

	this.transferSwap(swapParty, tempParty);
};//*
if(!multiPartyValid) Game_Party.prototype.swapParty = function(id2){};


Game_Party.prototype.setSwapId = function(){
	let currentId = this.partyId();
	let max = this.partyNumber();
	let checker;
	let party;
	let id = 0;
	let times = 0;
	while(!checker){
		id = currentId % max + 1;
		switch(id){
			case 1 : party = $gameParty1.exists(); break;
			case 2 : party = $gameParty2.exists(); break;
			case 3 : party = $gameParty3.exists(); break;
			case 4 : party = $gameParty4.exists(); break;
			case 5 : party = $gameParty5.exists(); break;
		}
		currentId ++;
		times ++;
		checker = party;
		if(times > 5){
				checker = true;
				id = 0;
		}
	};
	return id > 0 ? id : this.partyId();
};//*
if(!multiPartyValid) Game_Party.prototype.setSwapId = function(){};


Game_Party.prototype.setSwapParty = function(id){
	switch(id){
		case 1 	: return $gameParty1; break;
		case 2 	: return $gameParty2; break;
		case 3 	: return $gameParty3; break;
		case 4 	: return $gameParty4; break;
		case 5 	: return $gameParty5; break;
		default : return $gameParty;
	}
};//*
if(!multiPartyValid) Game_Party.prototype.setSwapParty = function(id){return null};


Game_Party.prototype.transferSwap = function(swapParty, tempParty){
	const mapId = swapParty.mapId() || tempParty.mapId();
	const x = swapParty.x() || tempParty.x();
	const y = swapParty.y() || tempParty.y();

	this.rememberTempPartyPosition(tempParty);

	const d = 2;
	const fadeType = 0;
	$gamePlayer.reserveTransfer(mapId, x, y, d, fadeType);
	$gameMap.refresh();
};//*
if(!multiPartyValid) Game_Party.prototype.transferSwap = function(swapParty, tempParty){};


Game_Party.prototype.rememberTempPartyPosition = function(tempParty){
	tempParty.setMapId();
	tempParty.setX();
	tempParty.setY();
};//*
if(!multiPartyValid) Game_Party.prototype.rememberTempPartyPosition = function(tempParty){};


Game_Party.prototype.partyId = function(){
	return this._id;
};//*
if(!multiPartyValid) Game_Party.prototype.partyId = function(){return 0};


Game_Party.prototype.tempPartyId = function(){
	this._id = 0; //for swapping from DistributeMenu
};//*
if(!multiPartyValid) Game_Party.prototype.tempPartyId = function(){};


Game_Party.prototype.setCurrentPosition = function(id, x, y){
	this.setMapId(id);
	this.setX(x);
	this.setY(y);
};//*
if(!multiPartyValid) Game_Party.prototype.setCurrentPosition = function(id, x, y){};


Game_Party.prototype.inheritPartyItems = function(swapParty, tempParty){
	swapParty._gold = tempParty._gold;
	swapParty._items = tempParty._items;
	swapParty._weapons = tempParty._weapons;
	swapParty._armors = tempParty._armors;
};//*
if(!multiPartyValid) Game_Party.prototype.inheritPartyItems = function(swapParty, tempParty){};


Game_Party.prototype.gatherMembers = function(){
	let v0 = $gameParty._actors;
	let v1 = $gameParty1._actors 
	let v2 = $gameParty2._actors;
	let v3 = $gameParty3._actors;
	let v4 = $gameParty4._actors;
	let v5 = $gameParty5._actors;
	let r0 = $gameReserveParty._actors;

	let ids = v0.concat(v1, v2, v3, v4, v5, r0);
	return ids.filter((id, index, self) => {return self.indexOf(id) === index});
};//*
if(!multiPartyValid) Game_Party.prototype.gatherMembers = function(){return null};


Game_Party.prototype.gatherGold = function(){
	if(multiParty.commonItems){return $gameParty.gold()};

	let v1 = $gameParty1.gold();
	let v2 = $gameParty2.gold();
	let v3 = $gameParty3.gold();
	let v4 = $gameParty4.gold();
	let v5 = $gameParty5.gold();
	let total = v1 + v2 + v3 + v4 + v5;
		total = total.clamp(0, this.maxGold());
	return total;
};//*
if(!multiPartyValid) Game_Party.prototype.gatherGold = function(){return 0};


Game_Party.prototype.gatherItemsWithoutType = function(v1, v2, v3, v4, v5){
	let tempIds = [...new Set(Object.keys(v1).concat(Object.keys(v2), Object.keys(v3), Object.keys(v4), Object.keys(v5)))];
	let ids = tempIds.reduce((v, value)=>{
		const a = v1[value] === undefined ? 0 : v1[value];
		const b = v2[value] === undefined ? 0 : v2[value];
		const c = v3[value] === undefined ? 0 : v3[value];
		const d = v4[value] === undefined ? 0 : v4[value];
		const e = v5[value] === undefined ? 0 : v5[value];
		v[value] = a + b + c + d + e;
		v[value] = v[value].clamp(0, this.maxItems());
		return v;
	}, {});
	return ids;
};//*
if(!multiPartyValid) Game_Party.prototype.gatherItemsWithoutType = function(v1, v2, v3, v4, v5){return []};


Game_Party.prototype.gatherItems = function(){
	if(multiParty.commonItems){return $gameParty._items};

	let v1 = $gameParty1._items || $gameParty._items;
	let v2 = $gameParty2._items;
	let v3 = $gameParty3._items;
	let v4 = $gameParty4._items;
	let v5 = $gameParty5._items;
						
	return this.gatherItemsWithoutType(v1, v2, v3, v4, v5);
};//*
if(!multiPartyValid) Game_Party.prototype.gatherItems = function(){return []};


Game_Party.prototype.gatherWeapons = function(){
	if(multiParty.commonItems){return $gameParty._weapons};

	let v1 = $gameParty1._weapons || $gameParty._weapons;
	let v2 = $gameParty2._weapons;
	let v3 = $gameParty3._weapons;
	let v4 = $gameParty4._weapons;
	let v5 = $gameParty5._weapons;
						
	return this.gatherItemsWithoutType(v1, v2, v3, v4, v5);
};//*
if(!multiPartyValid) Game_Party.prototype.gatherWeapons = function(){return []};


Game_Party.prototype.gatherArmors = function(){
	if(multiParty.commonItems){return $gameParty._armors};

	let v1 = $gameParty1._armors || $gameParty._armors;
	let v2 = $gameParty2._armors;
	let v3 = $gameParty3._armors;
	let v4 = $gameParty4._armors;
	let v5 = $gameParty5._armors;
						
	return this.gatherItemsWithoutType(v1, v2, v3, v4, v5);
};//*
if(!multiPartyValid) Game_Party.prototype.gatherArmors = function(){return []};


Game_Party.prototype.gatherFastTravel = function(){
	if($gameFastTravel) $gameFastTravel.gatherMultiCamp();
};//*
if(!multiPartyValid) Game_Party.prototype.gatherFastTravel = function(){};


Game_Party.prototype.allGather = function(){
	this._actors = this.gatherMembers();
	this._gold = this.gatherGold();
	this._items = this.gatherItems();
	this._weapons = this.gatherWeapons();
	this._armors = this.gatherArmors();
	this.gatherFastTravel();
	this.setPartyId(1);
	this.setSelectMenuCommand(false);
};//*

Game_Party.prototype.maxParty = function(){
	return this._maxParty;
};//*
if(!multiPartyValid) Game_Party.prototype.maxParty = function(){return 0};


Game_Party.prototype.currentPartyNumber = function(){
	let num = 0;
		num += $gameParty1.exists() ? 1 : 0;
		num += $gameParty2.exists() ? 1 : 0;
		num += $gameParty3.exists() ? 1 : 0;
		num += $gameParty4.exists() ? 1 : 0;
		num += $gameParty5.exists() ? 1 : 0;
	return num;
};//*
if(!multiPartyValid) Game_Party.prototype.currentPartyNumber = function(){return 0};


class Game_Party1 extends Game_Party {
		constructor(){
			super();
			this._id = 1;
		};//*

		addActor (actorId){
			if (!this._actors.contains(actorId)) {
       				this._actors.push(actorId);
       				$gameActors.actor(actorId);
       		}
		};//*

		setCurrentPosition (id, x, y){
			this.setMapId(id > 0 ? id : $gameMap.mapId());
			this.setX(x >= 0 ? x : $gamePlayer._realX);
			this.setY(y >= 0 ? y : $gamePlayer._realY);
		};//*
};//*Game_Party1

	window[Game_Party1.name] = Game_Party1;

class Game_Party2 extends Game_Party1 {
		constructor(){
			super();
			this._id = 2;
		};//*
};//*Game_Party2

	window[Game_Party2.name] = Game_Party2;

class Game_Party3 extends Game_Party1 {
		constructor(){
			super();
			this._id = 3;
		};//*
};//*Game_Party3

	window[Game_Party3.name] = Game_Party3;

class Game_Party4 extends Game_Party1 {
		constructor(){
			super();
			this._id = 4;
		};//*
};//*Game_Party4

	window[Game_Party4.name] = Game_Party4;

class Game_Party5 extends Game_Party1 {
		constructor(){
			super();
			this._id = 5;
		};//*
};//*Game_Party5

	window[Game_Party5.name] = Game_Party5;

class Game_ReserveParty extends Game_Party1 {
		constructor(){
			super();
			this._id = 0;
			this._reservable = false;
		};//*

		givenReserveActors (actors){
			this._actors = actors;
		};//*

		setReservable (value){
			this._reservable = value;
		};//*

		reserveOk (){
			return this._reservable;
		};//*
};//*Game_ReserveParty

	window[Game_ReserveParty.name] = Game_ReserveParty;

	/******************パーティ分けのシーン生成*********************/	

class Scene_DistributeParty extends Scene_Menu {
		constructor(){
			super();
			this._subId = 0;
			this._currentWindow = 'member';
			this._enableCancel = cancelDistributeParty === true;
		};//*

		create (){
			Scene_MenuBase.prototype.create.call(this);
			this.createHelpWindow();
		    this.createCommandWindow();
		    this.createMainPartyWindow();
		    this.createStatusWindow();
		    this.createAllMemberWindow();
		    this.createSubPartyWindow();
		    this.treeStatusWithWindows();

		    this.createDecideDialog();
		    this.createDecideCommand();
		};//*

		createHelpWindow (){
			this._helpWindow = new Window_DistributeHelp(1);
			const text = multiParty.messages.direction || 'パーティを振り分けて下さい';
			this._helpWindow.setText(text);
			this.addWindow(this._helpWindow);
		};//*

		helpAreaTop () {
			//for MZ
		    return 0;
		};//*

		createCommandWindow (){
			this._commandWindow = new Window_DistributeCommand();
			this._commandWindow.y = this._helpWindow.height;
			this._commandWindow.setHandler('party',     this.commandParty.bind(this));
			this._commandWindow.setHandler('member',    this.commandMember.bind(this));
			this._commandWindow.setHandler('decide',    this.commandDecide.bind(this));
			this._commandWindow.setHandler('cancel',    this.commandPop.bind(this));
			this.addWindow(this._commandWindow);
			this._commandWindow.activate();

			this._helpWindow.setCommandWindow(this._commandWindow);
		};//*

		categoryWindowRect (){
			//for MZ
			return Scene_Item.prototype.categoryWindowRect.call(this);
		};//*

		createMainPartyWindow (){
			const y = this._helpWindow.height + this._commandWindow.height;
			this._mainWindow = new Window_DistributeParty(0, y);
			this._mainWindow.width = Graphics.boxWidth * 4 / 17;
			this._mainWindow.setPartyId(this._subId + 1);
			this._mainWindow.setWindowType('main');

			this._mainWindow.setHandler('pageup', 	this.transferMemberWindow.bind(this));
			this._mainWindow.setHandler('pagedown', this.transferMemberWindow.bind(this));
			this._mainWindow.setHandler('ok', 		this.onMainOk.bind(this));
			this._mainWindow.setHandler('shift', 	this.commandFormation.bind(this));
			this._mainWindow.setHandler('cancel', 	this.onBacktoCommand.bind(this));
			this.addWindow(this._mainWindow);
			this._mainWindow.deactivate();
		};//*

		createStatusWindow (){
			const x = this._mainWindow.width;
			const y = this._mainWindow.y;
			this._statusWindow = new Window_DistributeStatus(x, y);
			this._statusWindow.width = Graphics.boxWidth - this._statusWindow.x;
			this._statusWindow.height = 144 + 24;
			this._statusWindow.reserveFaceImages();
			this.addWindow(this._statusWindow);
		    this._statusWindow.deactivate();
		};//*

		createAllMemberWindow (){
			const x = this._statusWindow.x;
			const y = this._statusWindow.y + this._statusWindow.height;
			this._memberWindow = new Window_DistributeParty(x, y);
			this._memberWindow.width = this._statusWindow.width;
			this._memberWindow.height = Math.floor((Graphics.boxHeight - y) / 2 );
			if($gameParty.editInherit() && $gameReserveParty.reserveOk()){
					this._memberWindow.setActors($gameReserveParty._actors);
			}else{
					this._memberWindow.setActors($gameParty.gatherMembers());	
			}
			this._memberWindow.setWindowType('member');

			this._memberWindow.setHandler('pageup', 	this.transferMainWindow.bind(this));
			this._memberWindow.setHandler('pagedown', 	this.transferMainWindow.bind(this));
			this._memberWindow.setHandler('ok', 		this.onMemberOk.bind(this));
			this._memberWindow.setHandler('shift', 		this.commandFormation.bind(this));
			this._memberWindow.setHandler('cancel', 	this.onBacktoCommand.bind(this));
			this.addWindow(this._memberWindow);
			this._memberWindow.refresh();
			this._memberWindow.deactivate();
		};//*

		createSubPartyWindow (){
			const x = 0;
			const y = this._memberWindow.y + this._memberWindow.height;
			const num = $gameParty.partyNumber();
			const width = Math.floor(Graphics.boxWidth/num);
			const height = Graphics.boxHeight - y
			this._mainWindow.height = y - this._mainWindow.y;

			this._subWindow = [];
			for(var i = 0; i < num; i++){
				this._subWindow[i] = new Window_DistributeParty(x + width * i, y);
				this._subWindow[i].width = width;
				this._subWindow[i].height = height;
				this._subWindow[i].setPartyId(i + 1);
				this._subWindow[i].setWindowType('sub');
				if($gameParty.editInherit()){
						this._subWindow[i].setActors(this.getInheritParty(i + 1));
				}

				this._subWindow[i].setHandler('right', 		this.onRightSubWindow.bind(this));
				this._subWindow[i].setHandler('pagedown', 	this.onRightSubWindow.bind(this));
				this._subWindow[i].setHandler('left', 		this.onLeftSubWindow.bind(this));
				this._subWindow[i].setHandler('pageup', 	this.onLeftSubWindow.bind(this));
				this._subWindow[i].setHandler('ok', 		this.onSubWindowOk.bind(this));
				this._subWindow[i].setHandler('cancel', 	this.onBacktoCommand.bind(this));
				this.addWindow(this._subWindow[i]);
				this._subWindow[i].deactivate();
				this._mainWindow.setActors(this._subWindow[0].actors());
				this._mainWindow.refresh();	
			}
		};//*

		getInheritParty (id){
			switch(id){
				case 1 : return $gameParty1._actors; break;
				case 2 : return $gameParty2._actors; break;
				case 3 : return $gameParty3._actors; break;
				case 4 : return $gameParty4._actors; break;
				case 5 : return $gameParty5._actors; break;
			}
		};//*

		treeStatusWithWindows (){
			this._statusWindow.setMainWindow(this._mainWindow);
			this._statusWindow.setMemberWindow(this._memberWindow);
		};//*

		createDecideDialog (){
			this._decideDialogWindow = new Window_DistributeDecideDialog();
			this.addWindow(this._decideDialogWindow);

			this._decideDialogWindow.hide();
			this._decideDialogWindow.deactivate();
			this._decideDialogWindow.setCommandWindow(this._commandWindow);
		};//*

		createDecideCommand (){
			this._decideCommandWindow = new Window_DistributeDecideCommand();
			const adjusterX = (this._decideDialogWindow.width - this._decideCommandWindow.width)/2;
			this._decideCommandWindow.x = this._decideDialogWindow.x + adjusterX;
			this._decideCommandWindow.y = this._decideDialogWindow.y + this._decideDialogWindow.height;
			this._decideCommandWindow.setHandler('ok', 		this.onDecideOk.bind(this));
			this._decideCommandWindow.setHandler('cancel', 	this.onDecideCancel.bind(this));

			this.addWindow(this._decideCommandWindow);
			this._decideCommandWindow.hide();
			this._decideCommandWindow.deactivate();
		};//*

		enableCancel (){
			return this._enableCancel;
		};//*

		/***********シーンの挙動設定***************/
		commandParty (){
			this._commandWindow.deactivate();
			this._subWindow[this._subId].activate();
			this._subWindow[this._subId].setCursorAll(true);
			this._subWindow[this._subId].select(0);
			this._helpWindow.setOperator();
		};//*

		commandMember (){
			this.setWindowName('member');
			this._commandWindow.deactivate();
			this._memberWindow.activate();
			this._memberWindow.select(0);
			this._helpWindow.setOperator();
		};//*

		commandDecide (){
			this.decideMembers();
		};//*

		commandPop (){
			this.commandDecide();
		};//*

		decideMembers (){
			const noEmpty = this.checkNoEmptyParty();
			if(noEmpty){
					this.callDialog(noEmpty);
			}else if(this.enableCancel()){
					this.callDialog(noEmpty, this.enableCancel());
			}else{
					this._decideDialogWindow.show();
					this._decideDialogWindow.drawDialog(noEmpty, this.enableCancel());
					this._decideDialogWindow.setAutoClose();
			}
		};//*

		callDialog (noEmpty, enableCancel){
			this._commandWindow.deactivate();

			this._decideDialogWindow.show();
			this._decideDialogWindow.drawDialog(noEmpty, enableCancel);
			this._decideCommandWindow.show();
			this._decideCommandWindow.activate();
			this._decideCommandWindow.select(0);
		};//*

		onDecideOk (){
			//this.mainTakeActorsforSub();
			if(this.checkNoEmptyParty()) this.updateGameParty();	
			this.popScene();
		};//*

		onDecideCancel (){
			this._decideDialogWindow.hide();
			this._decideCommandWindow.hide();
			this._decideCommandWindow.deactivate();

			this._commandWindow.activate();
			this._commandWindow.selectLast();
		};//*

		mainTakeActorsforSub (){
			const mainParty = this._mainWindow.partyId();
			this._subWindow.map(w => {
				if(w.partyId() === mainParty){
						w._actors = this._mainWindow._actors;
						w.refresh();
				}
			});
		};//*

		checkNoEmptyParty (){
			return !this._subWindow.some(w => {return w._actors.length === 0});
		};//*

		updateGameParty (){
			$gameReserveParty.givenReserveActors(this._memberWindow._actors);
			$gameReserveParty.setReservable(true);
			$gameParty._actors 	= this._subWindow[0] ? this._subWindow[0]._actors : [];
			$gameParty1._actors = this._subWindow[0] ? this._subWindow[0]._actors : [];
			$gameParty2._actors = this._subWindow[1] ? this._subWindow[1]._actors : [];
			$gameParty3._actors = this._subWindow[2] ? this._subWindow[2]._actors : [];
			$gameParty4._actors = this._subWindow[3] ? this._subWindow[3]._actors : [];
			$gameParty5._actors = this._subWindow[4] ? this._subWindow[4]._actors : [];

			this.updateAllPartyPosition();
			$gameParty.tempPartyId();
			$gameParty.swapParty(1);
		};//*

		updateAllPartyPosition (){
			$gameParty.setCurrentPosition();
			$gameParty.setRespawn();
			$gameParty1.setCurrentPosition();
			$gameParty1.setRespawn();
			$gameParty2.setCurrentPosition();
			$gameParty2.setRespawn();
			$gameParty3.setCurrentPosition();
			$gameParty3.setRespawn();
			$gameParty4.setCurrentPosition();
			$gameParty4.setRespawn();
			$gameParty5.setCurrentPosition();
			$gameParty5.setRespawn();
		};//*

		setWindowName (name){
			this._currentWindow = name;
		};//*

		windowName (){
			return this._currentWindow;
		};//*

		onMainOk (){
			this.transferActorFromParty();
			this._mainWindow.activate();
			this._mainWindow.select(0);
		};//*

		transferActorFromParty (){
			let actors = this._mainWindow.actors();
			let id = actors[this._mainWindow._index];
			this._memberWindow.addActorId(id);
			this._mainWindow.removeActorId(id);
			this.mainTakeActorsforSub();
		};//*

		onMemberOk (){
			this.transferActorFromMember();
			this._memberWindow.activate();
			this._memberWindow.select(0);
		};//*

		transferActorFromMember (){
			const currentMembers = this._mainWindow.actors().length;
			const fullMembers = this.fullMember(this._mainWindow.partyId());
			if(currentMembers < fullMembers){
					let actors = this._memberWindow.actors()
					let id = actors[this._memberWindow._index];
					this._mainWindow.addActorId(id);
					this._memberWindow.removeActorId(id);
					this.mainTakeActorsforSub();
			}
		};//*

		fullMember (id){
			switch(id){
				case 1 : return $gameParty1.maxBattleMembers(); break;
				case 2 : return $gameParty2.maxBattleMembers(); break;
				case 3 : return $gameParty3.maxBattleMembers(); break;
				case 4 : return $gameParty4.maxBattleMembers(); break;
				case 5 : return $gameParty5.maxBattleMembers(); break;
				default: return $gameParty.maxBattleMembers();
			}
		};//*

		commandFormation (){
			if(this.windowName() === 'main'){	
					this._mainWindow.setFormationMode(true);
					this._mainWindow.setPendingIndex(this._mainWindow.index());
					this._mainWindow.activate();
			}else{
					this._memberWindow.setFormationMode(true);
					this._memberWindow.setPendingIndex(this._memberWindow.index());
					this._memberWindow.activate();
			};

			this._mainWindow.setHandler('ok',     this.onFormationOk.bind(this));
		    this._mainWindow.setHandler('shift',  this.onFormationOk.bind(this));
		    this._mainWindow.setHandler('cancel', this.onFormationCancel.bind(this));
		    this._memberWindow.setHandler('ok',     this.onFormationOk.bind(this));
		    this._memberWindow.setHandler('shift',  this.onFormationOk.bind(this));
		    this._memberWindow.setHandler('cancel', this.onFormationCancel.bind(this));
		};//*

		onFormationOk () {
			const main = this._mainWindow;
			const member = this._memberWindow;
			let currentMain = this.windowName() === 'main';
			let modeMain = main.formationMode();

			let index = currentMain ? main.index() : member.index();	
			let actorId = currentMain ? main.actorId(index) : member.actorId(index);
			let	pendingIndex = modeMain ? main.pendingIndex() : member.pendingIndex();
						   
			if (pendingIndex >= 0) {
					this.swapOrder(index, pendingIndex, currentMain, modeMain);
			} else {
					if(modeMain){
					    	main.setPendingIndex(index);
					}else{
					    	member.setPendingIndex(index);
			    	}
		    };
			this.onFormationCancel();
		};//*

		swapOrder (index, pendingIndex, currentMain, modeMain){
			const main = this._mainWindow;
			const member = this._memberWindow;
			let temp;
			let swap;
			if(currentMain && modeMain){
					//パーティウィンドウ内で入れ替え
					temp = main.actors()[pendingIndex];
					swap = main.actors()[index];
					main.actors()[pendingIndex] = swap;
					main.actors()[index] = temp;
					this.mainTakeActorsforSub();

					main.setPendingIndex(-1);
					main.redrawItem(index);
			}else if(!currentMain && modeMain){
					//パーティウィンドウからメンバーウィンドウへ
					temp = main.actors()[pendingIndex];
					swap = member.actors()[index];
					main.actors()[pendingIndex] = swap;
					member.actors()[index] = temp;
					this.mainTakeActorsforSub();

					main.setPendingIndex(-1);
					member.redrawItem(index);
			}else if(currentMain && !modeMain){
					//メンバーウィンドウからパーティウィンドウへ
					temp = member.actors()[pendingIndex];
					swap = main.actors()[index];
					member.actors()[pendingIndex] = swap;
					main.actors()[index] = temp;
					this.mainTakeActorsforSub();

					member.setPendingIndex(-1);
					main.redrawItem(index);
			}else{
					//メンバーウィンドウ内で入れ替え
					temp = member.actors()[pendingIndex];
					swap = member.actors()[index];
					member.actors()[pendingIndex] = swap;
					member.actors()[index] = temp;

					member.setPendingIndex(-1);
					member.redrawItem(index);
			};

			main.refresh();
			member.refresh();
		};//*

		onFormationCancel () {
			this._mainWindow.setFormationMode(false);
			this._memberWindow.setFormationMode(false);
								
			if(this.windowName() === 'main'){
					this._mainWindow.activate();
					this._mainWindow.selectLast();
					this._memberWindow.deselect();
			}else{
					this._memberWindow.activate();
					this._memberWindow.selectLast();
					this._mainWindow.deselect();
			};

			this._mainWindow.setHandler('ok', 		this.onMainOk.bind(this));
			this._mainWindow.setHandler('shift', 	this.commandFormation.bind(this));
			this._mainWindow.setHandler('cancel', 	this.onBacktoCommand.bind(this));
			this._memberWindow.setHandler('ok', 		this.onMemberOk.bind(this));
			this._memberWindow.setHandler('shift', 		this.commandFormation.bind(this));
			this._memberWindow.setHandler('cancel', 	this.onBacktoCommand.bind(this));
		};//*


		transferMemberWindow (){
			this.setWindowName('member');
			this._mainWindow.deactivate();
			this._mainWindow.deselect();
			this._memberWindow.activate();
			this._memberWindow.select(0);
		};//*

		transferMainWindow (){
			this.setWindowName('main');
			this._memberWindow.deactivate();
			this._memberWindow.deselect();
			this._mainWindow.activate();
			this._mainWindow.select(0);
		};//*

		onSubWindowOk (){
			this.mainTakeActorsforSub();
			this._subWindow[this._mainWindow.partyId()-1].refresh();

			this._mainWindow.setActors(this._subWindow[this._subId].actors());
			this._mainWindow.setPartyId(this._subId + 1);
			this._mainWindow.refresh();

			this._subWindow[this._subId].deactivate();
			this._commandWindow.activate();
			this._commandWindow.selectLast();
		};//*

		onRightSubWindow (){
			this.deactivateSubWindow();
			this.updateSubId(true);
		};//*

		onLeftSubWindow (){
			this.deactivateSubWindow();
			this.updateSubId(false);
		};//*

		onBacktoCommand (){
			this._mainWindow.deactivate();
			this._mainWindow.deselect();
			this._memberWindow.deactivate();
			this._memberWindow.deselect();
			this._subWindow[this._subId].deactivate();
			this._subId = this._mainWindow.partyId() - 1;

			this._commandWindow.activate();
			this._commandWindow.selectLast();
		};//*

		deactivateSubWindow (){
			this._subWindow[this._subId].deactivate();
			this._subWindow[this._subId].setCursorAll(false);
			this._subWindow[this._subId].deselect();
		};//*
						
		updateSubId (right){
			const num = this._subWindow.length;
			if(right){
					this._subId ++;
			}else{
					this._subId += (num - 1);
			};
			this._subId %= num;
							
			this._subWindow[this._subId].activate();
			this._subWindow[this._subId].setCursorAll(true);
			this._subWindow[this._subId].select(0);
		};//*

};//*Scene_DistributeParty

		window[Scene_DistributeParty.name] = Scene_DistributeParty;


class Window_DistributeHelp extends Window_Help {
		constructor(numLines){
			super(numLines);
		};//*

		standardFontSize (){
			return multiParty.fontSize;
		};//*

		setCommandWindow (commandWindow){
			if(commandWindow){
					this._commandWindow = commandWindow;	
			}
		};//*

		symbol (){
			if(this._commandWindow){
					return this._commandWindow.currentSymbol();	
			}
		};//*

		update(){
			super.update();
			if(this._commandWindow && this._commandWindow.active){
				let text = '';
				const messages = multiParty.messages;
				switch(this.symbol()){
					case 'party' 	: text = messages.editHelpSelectParty || '入れ替えするパーティを選択します'; break;
					case 'member' 	: text = messages.editHelpSelectChara || 'メンバーの編成を行います'; 		break;
					case 'decide' 	: text = messages.editHelpSelectDecide ||'編成を決定し　メニューを閉じます'; break;
				}
				this.setText(text);
			}
		};//*

		setOperator (){
			if(this._commandWindow){
				let text = '';
				const messages = multiParty.messages;
				const shiftKey = keyName(keyOfShift) + ':';
				let shiftText = '';
				let shift = '';
				const enterKey = keyName(keyOfEnter) + ':';
				let enterText = '';
				let enter = '';
				const cancelKey = keyName(keyOfCancel) + ':';
				let cancelText = '';
				let cancel = '';
				const scrollKey = keyName(keyOfScroll) + ':';
				let scrollText = '';
				let scroll = '';
				const slash = ' / ';
				switch(this.symbol()){
					case 'party' :
						scrollText = messages.operatePartyScroll || 'パーティ選択';
						enterText = messages.operatePartyEnter || '決定';
						cancelText = messages.operatePartyCancel || '戻る';
						scroll = scrollKey + scrollText + slash;
						enter = enterKey + enterText + slash;
						cancel = cancelKey + cancelText;
						text = scroll + enter + cancel;
					break;

					case 'member' :
						scrollText = messages.operateCharaScroll || 'ウィンドウ切替';
						shiftText = messages.operateCharaShift || '並び替え'
						enterText = messages.operateCharaEnter || '選択';
						cancelText = messages.operateCharaCancel || '戻る';
						scroll = scrollKey + scrollText + slash;
						shift = shiftKey + shiftText + slash;
						enter = enterKey + enterText + slash;
						cancel = cancelKey + cancelText;
						text = scroll + shift + enter + cancel;
					break;
				};
				this.setText(text);
			}
		};//*

		drawTextEx (text, x, y, width) {
			if(MZ){
				//this.resetFontSettings();
			    const textState = this.createTextState(text, x, y, width);
			    this.processAllText(textState);
			    return textState.outputWidth;
			}else if(MV){
				super.drawTextEx(text, x, y, width);
			}
		};//*
};//*Window_DistributeHelp

		window[Window_DistributeHelp.name] = Window_DistributeHelp;


class Window_DistributeCommand extends Window_ItemCategory {
		constructor(){
			super();
		};//*

		makeCommandList (){
			const messages = multiParty.messages;
			this.addCommand(messages.editCommandParty || 'パーティ選択', 'party');
			this.addCommand(messages.editCommandChara || 'メンバー入れ替え', 'member');
			this.addCommand(messages.editCommandDecide || '決定', 'decide');
		};//*

		selectLast (){
			this.selectSymbol(this.currentSymbol());
		};//*

};//*Window_DistributeCommand

		window[Window_DistributeCommand.name] = Window_DistributeCommand;

class Window_DistributeParty extends Window_MenuStatus {
		constructor(x, y){
			super(x, y);
			this._actors = [];
			this._partyId = 0;
			this._windowType = '';
		};//*

		setWindowType (type){
			this._windowType = type;
		};//*

		processOk () {
			Window_Selectable.prototype.processOk.call(this);
			//$gameParty.setMenuActor($gameParty.members()[this.index()]);
		};//*

		partyId (){
			return this._partyId;
		};//*

		setPartyId (id){
			if(id > 0){
					this._partyId = id;	
			}
		};//*

		actors (){
			return this._actors;
		};//*

		setActors (actors){
			this._actors = actors;
			this.refresh();
		};//*

		actorId (index){
			index = index >= 0 ? index : this._index;
			if(this._actors && index >= 0){
					return this._actors[index];
			}
		};//*

		actor (index){
			index = index >= 0 ? index : this._index;
			if(this._actors && index >= 0){
					return $gameActors.actor(this.actorId(index));
			}else{
					return null;
			}
		};//*

		addActorId (id){
			if(id > 0){
					this._actors.push(id);
					this.refresh();
			}
		};//*

		removeActorId (id){
			if(id > 0){
					this._actors = this._actors.filter(aId => {return aId !== id});
					this.refresh();
			}
		};//*

		exceptVoidActors (){
			let actors = this.actors();
			if(actors && actors.length > 0){
					this._actors = actors.filter(aId => {return aId > 0});	
			}
		};//*

		maxCols(){
			switch(this._windowType){
				case 'main' : return 2; break;
				case 'sub' :
					const numCols = Math.floor(this.width / 50);
					if(numCols < 4){
							return 2;
					}else{
							return 4;
					}
				break;

				default : return Math.floor(this.width / 50);
			}
		};//*

		numVisibleRows (){
			switch(this._windowType){
				case 'main' 	: return 2; break;
				case 'member' 	: return 4; break;
				case 'sub' 		: return 2; break;
				default 		: return 4;
			}
		};//*


		itemHeight () {
			const clientHeight = this.height - this.padding * 2;
		 	const height = Math.floor(clientHeight / this.numVisibleRows());
			switch(this._windowType){
				case 'main' 	: return Math.floor(clientHeight / this.numVisibleRows()); 	break;
				case 'member' 	: return Math.max(height, 50); 								break;
				case 'sub' 		: return clientHeight; 										break;
				default 		: return Math.max(height, 50);
			}
		};//*

		maxPageRows (){
			if(this._windowType === 'sub'){
					return this.numVisibleRows();
			}else{
					return super.maxPageRows();
			}
		};//*

		maxItems (){
			if(this.actors()){
					return this.actors().length || $gameParty.gatherMembers().length;	
			}else{
					return $gameParty.gatherMembers().length;
			}
		};//*

		drawItem (index){
			this.drawItemBackground(index);
			this.drawItemCharacter(index);
		};//*

		drawItemCharacter (index) {
			var actor = this.actor(index);
		    var rect = this.itemRect(index);
		    if(actor){
					//座標はスプライト左下を原点にしていることに注意！
					let x = this.characterX(rect);
					let y = this.characterY(rect);
					this.drawActorCharacter(actor, x, y);
					this.changePaintOpacity(true); 	
			}
		};//*

		characterX (rect){
			switch(this._windowType){
				case 'main' 	: return rect.x + Math.floor(this.itemWidth()/2); 	break;
				case 'member' 	: return rect.x + 1 + 20; 							break;
				case 'sub' 		: return rect.x + 1 + 24; 							break;
				default 		: return rect.x + 1 + 20;
			}
		};//*

		characterY (rect){
			switch(this._windowType){
				case 'main' : 
						return rect.y + 1 + + Math.floor(this.itemHeight()/2) + 24;
				break;
				
				case 'member' :	
						return rect.y + 1 + 48;
				break;

				case 'sub' :
						let lines = rect.y === 0 ? 1 : 2; 
						return  1 + 48 * lines + this.spacing() * (lines - 1);
				break;

				default : return rect.y + 1 + 48;
			}
		};//*

		refresh(){
			if(this.contents){
					this.contents.clear();
			}
			this.exceptVoidActors();
			this.createContents();
			this.drawAllItems();
		}
};//*Window_DistributeParty

	window[Window_DistributeParty.name] = Window_DistributeParty;


class Window_DistributeStatus extends Window_MenuStatus {
		constructor(x, y){
			super(x, y);
			this._actorId = 0;
		};//*

		numVisibleRows () {
		    return 1;
		};//*

		setMainWindow (mainWindow){
			if(mainWindow){
					this._mainWindow = mainWindow;
			}
		};//*

		setMemberWindow (memberWindow){
			if(memberWindow){
					this._memberWindow = memberWindow;
			}
		};//*

		update (){
			super.update();
			if(this.actorId() !== this._actorId){
					this._actorId = this.actorId();
					this.drawItem();
			}
		};//*

		actorId (){
			if(this._mainWindow && this._mainWindow.active){
					return this._mainWindow.actorId();
			}else if(this._memberWindow && this._memberWindow.active){
					return this._memberWindow.actorId();
			}
		};//*

		actor (){
			if(this._mainWindow && this._mainWindow.active){
					return this._mainWindow.actor();
			}else if(this._memberWindow && this._memberWindow.active){
					return this._memberWindow.actor();
			}
		};//*

		drawItem (){
			this.contents.clear();
			super.drawItem();
		};//*

		drawItemImage () {
			var actor = this.actor();
		    if(actor){
					var rect = this.itemRect(0);
					//this.changePaintOpacity(actor.isBattleMember());
				    this.drawActorFace(actor, rect.x + 1, rect.y + 1, Window_Base._faceWidth, Window_Base._faceHeight);
				    this.changePaintOpacity(true);	
			}else{
					//this.contents.clear();
			}
		};//*

		drawItemStatus () {
			var actor = this.actor();
		    if(actor){
			    	var rect = this.itemRect(0);
				    var x = rect.x + 162;
				    //var y = MV ? rect.y + rect.height / 2 : rect.y;
				    var y = rect.y;
				    var width = rect.width - x - this.textPadding();
				    this.drawActorSimpleStatus(actor, x, y, width);
			}else{
			    	//this.contents.clear();
		    }
		};//*

		//for MZ
		placeBasicGauges (actor, x, y) {
			const width = Math.min(200, this.itemRect(0).width - 180 - this.textPadding());
		    this.drawActorHp(actor, x, y, width);
		    this.drawActorMp(actor, x, y + this.gaugeLineHeight(), width);
		    if ($dataSystem.optDisplayTp) {
		        this.drawActorTp(actor, x, y + this.gaugeLineHeight() * 2, width);
		    }
		};//*

};//*Window_DistributeStatus

	window[Window_DistributeStatus.name] = Window_DistributeStatus;


class Window_DistributeDecideCommand extends Window_ExecuteCommand{
		constructor(){
			super();
		};//*

		makeCommandList (){
			const messages = multiParty.messages;
			this.addCommand(messages.editDialogCommandOk || 'はい', 'ok');
			this.addCommand(messages.editDialogCommandCancel || 'いいえ', 'cancel');
		};//*

		drawItem (index) {
			var rect = this.itemRectForText(index);
		    var align = this.itemTextAlign();
		    this.resetTextColor();
		    this.changePaintOpacity(this.isCommandEnabled(index));
		    this.drawText(this.commandName(index), rect.x, rect.y, rect.width, align);
		};
};//*Window_DistributeDecideCommad

	window[Window_DistributeDecideCommand.name] = Window_DistributeDecideCommand;

class Window_DistributeDecideDialog extends Window_ExecuteDialog {
		constructor(){
			super();
			this._autoClose = 0;
		};//*

		setCommandWindow (commandWindow){
			if(commandWindow){
					this._commandWindow = commandWindow;
			}
		};//*

		drawDialog(noEmpty, enableCancel){
			this.contents.clear();
			let text = '';
			let y = Math.floor(this.height / 2) - this.lineHeight();
			const messages = multiParty.messages;
			if(noEmpty){
					text = messages.editDialogMessageCheck || 'パーティ編成を完了しますか？';
			}else if(enableCancel){
					text = messages.editDialogMessageCancel || 'パーティ編成を中止しますか？';
			}else{
					text = messages.editDialogMessageCaution || 'パーティに空きがあります';
			}
						
			this.drawText(text, 0, y, this.width, 'center');
		};//*

		standardFontSize (){
			return 18;
		};//*

		update(){
			super.update();
			this.autoClose();
		};//*

		autoClose (){
			if(this._autoClose > 0){
					this._autoClose --;
					if(this._autoClose <= 0){
							this.hide();
							this._commandWindow.activate();
							this._commandWindow.selectLast();
					}
			}
		};//*

		setAutoClose(){
			this._autoClose = 60;
		};//*
};//*Window_DistributeDecideDialog 

	window[Window_DistributeDecideDialog.name] = Window_DistributeDecideDialog;


if(multiParty.addMenu){
	const _Window_MenuCommand_prototype_addOriginalCommands = Window_MenuCommand.prototype.addOriginalCommands;
	Window_MenuCommand.prototype.addOriginalCommands = function() {
		if($gameParty.selectMenuCommand()){
				const messages = multiParty.messagesSelector;
				const enabled = $gameParty.currentPartyNumber() >= 2;
				this.addCommand(messages.changeMenuCommand || 'パーティ', 'chooseParty', enabled);	
		}
							
		_Window_MenuCommand_prototype_addOriginalCommands.apply(this,arguments);
	};//*

	const _Scene_Menu_prototype_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
	Scene_Menu.prototype.createCommandWindow = function() {
		_Scene_Menu_prototype_createCommandWindow.apply(this, arguments);
		this._commandWindow.setHandler('chooseParty', this.commandChooseParty.bind(this));
	};//*

	Scene_Menu.prototype.commandChooseParty = function(){
		SceneManager.push(Scene_ChooseParty);
	};//*
}////

class Scene_ChooseParty extends Scene_Load {
		constructor(){
			super();
		};//*

		mainAreaTop () {
			//for MZ
		    return 0;
		};//*

		createListWindow () {
			this.currentPartyUpdateMap();

			var x = 0;
			var y = this._helpWindow.height;
			var width = Graphics.boxWidth;
			var height = Graphics.boxHeight - y;
		    this._listWindow = new Window_ChooseParty(x, y, width, height);
		    this._listWindow.setHandler('ok',     this.onSavefileOk.bind(this));
		    this._listWindow.setHandler('cancel', this.popScene.bind(this));
		    this._listWindow.select(this.firstSavefileIndex());
		    this._listWindow.setTopRow(this.firstSavefileIndex() - 2);
		    this._listWindow.setMode(this.mode());
		    this._listWindow.refresh();
		    this.addWindow(this._listWindow);
		};//*

		currentPartyUpdateMap (){
			const partyId = $gameParty.partyId();
			const mapId = $gameMap.mapId();
			const x = $gamePlayer._realX;
			const y = $gamePlayer._realY;
			$gameParty.setCurrentPosition(mapId, x, y);
			this.setPartyMap(partyId, mapId, x, y);
		};//*

		setPartyMap (partyId, mapId, x, y){
			switch(partyId){
				case 1 : $gameParty1.setCurrentPosition(mapId, x, y); break;
				case 2 : $gameParty2.setCurrentPosition(mapId, x, y); break;
				case 3 : $gameParty3.setCurrentPosition(mapId, x, y); break;
				case 4 : $gameParty4.setCurrentPosition(mapId, x, y); break;
				case 5 : $gameParty5.setCurrentPosition(mapId, x, y); break;
			}
		};//*

		terminate () {
			Scene_File.prototype.terminate.call(this);
		    //if (this._loadSuccess) {$gameSystem.onAfterLoad();}//
		};//*

		helpWindowText () {
			const messages = multiParty.messagesSelector;
		    return messages.changeHelp || 'パーティを選択して下さい';
		};//*

		firstSavefileIndex () {
		    return 0;
		};//*

		onSavefileOk () {
		    Scene_File.prototype.onSavefileOk.call(this);
		    if (this.enableChange(this.savefileId())) {
		        	this.onLoadSuccess();
		    } else {
			        this.onLoadFailure();
		    }
		};//*

		enableChange (id){
			const currentId = $gameParty.partyId();
			if(id !== currentId){
					switch(id){
						case 1 : return $gameParty1.exists(); break;
						case 2 : return $gameParty2.exists(); break;
						case 3 : return $gameParty3.exists(); break;
						case 4 : return $gameParty4.exists(); break;
						case 5 : return $gameParty5.exists(); break;
						default: return false;
					}	
			}else{
					return false;
			};//*
		};//*

		onLoadSuccess () {
		    SoundManager.playLoad();
		    //this.fadeOutAll();
		    SceneManager.goto(Scene_Map);
		    this._loadSuccess = true;
		    this.swapParty();
		};//*

		swapParty (){
			const partyId = this.savefileId();
			$gameParty.swapParty(partyId);
		};//*

};//*Scene_ChooseParty

	window[Scene_ChooseParty.name] = Scene_ChooseParty;

class Window_ChooseParty extends Window_SavefileList{
		constructor(x, y, width, height){
			super(x, y, width, height);
		};//*

		maxItems () {
		    return $gameParty.currentPartyNumber();
		};//*

		drawItem (index) {
		    var id = index + 1;
		    var valid = this.rangeinPartyNumber(id);
		    var info = this.party(id);
		    var rect = this.itemRectForText(index);
		    this.resetTextColor();
		    if (this._mode === 'load') {
				    this.changePaintOpacity(valid);
			}
			if (info.exists()) {
					this.drawFileId(id, rect.x, rect.y);
					this.changePaintOpacity(valid);
					this.drawContents(info, rect, valid);
					this.changePaintOpacity(true);
			}
		};//*

		rangeinPartyNumber (id){
			return id <= $gameParty.currentPartyNumber();
		};//*

			party (id){
			switch(id){
				case 1 : return $gameParty1; break;
				case 2 : return $gameParty2; break;
				case 3 : return $gameParty3; break;
				case 4 : return $gameParty4; break;
				case 5 : return $gameParty5; break;
			}
		};//*

		drawFileId (id, x, y) {
			let text = '';
			let iconWidth = 32;
			const messages = multiParty.messagesSelector;
			let name = messages.changePartyName || 'パーティ';
			if(this.party(id).exists()){
				text = name + ' ' + id;
			}
			if($gameParty.partyId() === id){
				this.drawIcon(87, x, y);
			}
			this.drawText(text, x + iconWidth, y, 180);
		};//*

		drawContents (info, rect, valid) {
		    var bottom = rect.y + rect.height;
		    if (rect.width >= 420) {
				   	this.drawGameTitle(info, rect.x + 192, rect.y, rect.width - 192);
					if (valid) {
					       	this.drawPartyCharacters(info, rect.x + 220, bottom - 4);
			        }
		    }	
		};//*

		drawGameTitle (info, x, y, width) {
			const mapInfo = $dataMapInfos[info.mapId()];
			const name = mapInfo['name'];
			if (name) {
				    this.drawText(name, x, y, width);
		    }
		};//*

		drawPartyCharacters (info, x, y) {
			const members = info.battleMembers();
			if (members) {
					const leaderName = info.leader().name();
					this.drawText(leaderName, x - 180, y - this.lineHeight() * 3/2, 180);

				    for (var i = 0; i < members.length; i++) {
					    var data = members[i];
					    const name = data.characterName();
			            const index = data.characterIndex();
			            this.drawCharacter(name, index, x + i * 48, y);
			        }
		    }
		};//*
};//*Window_ChooseParty

	window[Window_ChooseParty.name] = Window_ChooseParty;




					
/***********************************************************************************************/
/*--------------タイマーの設定-------------------------*/

		/*~struct~Timer:ja
			@param 	x
			@type 		number
			@text 		原点ｘ座標（px）
			@desc 		タイマーを表示する原点のｘ座標を設定します。座標軸は画面の右から左に向かいます。
			@default 	96
			@decimals 	0
			@min 		-2000
			@max 		2000

			@param 	y
			@type 		number
			@text 		原点ｙ座標（px）
			@desc 		タイマーを表示する原点のｙ座標を設定します。
			@default 	0
			@decimals 	0
			@min 		-2000
			@max 		2000

			@param 	width
			@type 		number
			@text 		タイマー幅(px)
			@desc 		タイマーの表示幅を設定します。
			@default 	96
			@decimals 	0
			@min 		1
			@max 		2000

			@param 	height
			@type 		number
			@text 		タイマー高さ(px)
			@desc 		タイマーの表示高さを設定します。
			@default 	37
			@decimals 	0
			@min 		1
			@max 		2000
		*/
		/*--------------------------------------------------------------------------------------------------*/
		/*~struct~Timer:
			@param 	x
			@type 		number
			@text 		x-coordinate（px）
			@desc 		Control timer's x-coordinate; direction is from right to left
			@default 	96
			@decimals 	0
			@min 		-2000
			@max 		2000

			@param 	y
			@type 		number
			@text 		y-coordinate（px）
			@desc 		Control timer's y-coordinate
			@default 	0
			@decimals 	0
			@min 		-2000
			@max 		2000

			@param 	width
			@type 		number
			@text 		width of Game Timer(px)
			@desc 		Control the width
			@default 	96
			@decimals 	0
			@min 		1
			@max 		2000

			@param 	height
			@type 		number
			@text 		height of Game Timer(px)
			@desc 		Control the height
			@default 	37
			@decimals 	0
			@min 		1
			@max 		2000
		*/

		const parseTimer = s => JSON.parse(s, (key, value)=>{
			switch(key){
				case 'x' 		: return Number.parseFloat(value);
				case 'y' 		: return Number.parseFloat(value);
				case 'width' 	: return Number.parseFloat(value);
				case 'height' 	: return Number.parseFloat(value);
				default 		: return value;
			}
		});//*

		let timer = params.timer;
		let consolerNameTimer = 'timer:';
		if(timer){
				timer = parseTimer(timer);
		}else{
				timer = makeNotValid();
				undefinedStructs.push(consolerNameTimer);
				consolerNameTimer += makeInvalidTerm();
		};
	
		consoler(consolerNameTimer, timer);
	/*---------------タイマースプライトに関する設定---------------*/
if(fieldValid){
	const _Sprite_Timer_prototype_createBitmap = Sprite_Timer.prototype.createBitmap;
	Sprite_Timer.prototype.createBitmap = function() {
		this.bitmap = new Bitmap(Graphics.boxWidth, Graphics.boxHeight);
		const timerSize = this.timerSize();
		if(MV){
			this.bitmap.fontSize = timerSize;
		}else if(MZ){
			this.bitmap.fontFace = this.fontFace();
		    this.bitmap.fontSize = timerSize;
		    this.bitmap.outlineColor = ColorManager.outlineColor();
		}
	};//*

	const _Sprite_Timer_prototype_redraw = Sprite_Timer.prototype.redraw;
	Sprite_Timer.prototype.redraw = function() {
	    var text = this.timerText();
	    this.updateSize();
	    this.bitmap.clear();
	    this.bitmap.textColor = $gameTimer.textColor || 'white';
	    this.bitmap.drawText(text, 0, 0, $gameTimer.width, $gameTimer.height, 'center');
	    if($gameTimer.whChanged) $gameTimer.whChanged = false;
	};//*

	const _Sprite_Timer_prototype_timerText = Sprite_Timer.prototype.timerText;
	Sprite_Timer.prototype.timerText = function() {
		if($gameTimer.secondDisplay){
			return this._seconds;
		}else{
			return _Sprite_Timer_prototype_timerText.apply(this,arguments);
		}
	};//*

	const _Sprite_Timer_prototype_updatePosition = Sprite_Timer.prototype.updatePosition;
	Sprite_Timer.prototype.updatePosition = function() {
		if($gameTimer){
			let needUpdate = 0;
			if(this.x !== $gameTimer.x) needUpdate += 1;
			if(this.y !== $gameTimer.y) needUpdate += 10;
			if($gameTimer.whChanged) 	needUpdate += 100;
			if(needUpdate){
				if(needUpdate % 10 === 1) this.x = $gameTimer.x;
				if( (needUpdate / 10)%10 === 1 ) this.y = $gameTimer.y;
				this.redraw();
			}
		}else{
			_Sprite_Timer_prototype_updatePosition.apply(this, arguments);
		}
	};//*

	Sprite_Timer.prototype.timerSize = function(){
		const defSize = MV ? 32 : this.fontSize();
		return $gameTimer ? Math.min($gameTimer.width, $gameTimer.height) : defSize;
	};//*

	Sprite_Timer.prototype.updateSize = function(){
		if($gameTimer){
			const fontSize = this.timerSize();
			this.bitmap.fontSize = fontSize;
		}
	};//*
}////

	/*---------------タイマー操作に関するファンクション追加-----------------------------------*/

const _Game_Timer_prototype_initialize = Game_Timer.prototype.initialize;
Game_Timer.prototype.initialize = function() {
    _Game_Timer_prototype_initialize.apply(this, arguments);
    this._pausing = false;
    this._visible = true;
    this.x = timer.x;
    this.y = timer.y;
    this.width = timer.width;
    this.height = timer.height;
    this.whChanged = false;
    this.secondDisplay = false;
    this.textColor = 'white';
};//*

if(fieldValid){
	const _Game_Timer_prototype_update = Game_Timer.prototype.update;
	Game_Timer.prototype.update = function(sceneActive) {
	    if(!this._pausing){
	    	if (sceneActive && this._working && this._frames !== 0) {
			        this._frames--;
			        if (this._frames <= 0) {
				            this.onExpire();
				            this.reshow();
			        }
		    };
	    }
	};//*

	const _Game_Timer_prototype_stop = Game_Timer.prototype.stop;
	Game_Timer.prototype.stop = function() {
	    _Game_Timer_prototype_stop.apply(this, arguments);
	    this.restart();
	};//*

	const _Game_Timer_prototype_isWorking = Game_Timer.prototype.isWorking;
	Game_Timer.prototype.isWorking = function() {
	    return this.isHidden() ? this._visible : this._working;
	};//*
}////

Game_Timer.prototype.addCount = function(count) {
	if(typeof count === 'number') this._frames += count;
};//*
if(!fieldValid) Game_Timer.prototype.addCount = function(count) {};


Game_Timer.prototype.reduceCount = function(count){
	if(typeof count === 'number') this._frames -= count;
};//*
if(!fieldValid) Game_Timer.prototype.reduceCount = function(count){};


Game_Timer.prototype.pause = function(){
	this._pausing = true;
};//*
if(!fieldValid) Game_Timer.prototype.pause = function(){};


Game_Timer.prototype.restart = function(){
	this._pausing = false;
};//*
if(!fieldValid) Game_Timer.prototype.restart = function(){};


Game_Timer.prototype.isHidden = function(){
	return !this._visible;
};//*
if(!fieldValid) Game_Timer.prototype.isHidden = function(){return false};


Game_Timer.prototype.show = function(){
	this._visible = true;
};//*
if(!fieldValid) Game_Timer.prototype.show = function(){};


Game_Timer.prototype.hide = function(){
	this._visible = false;
};//*
if(!fieldValid) Game_Timer.prototype.hide = function(){};


Game_Timer.prototype.reshow = function(){
	if(this.isHidden()) this.show();
};//*
if(!fieldValid) Game_Timer.prototype.reshow = function(){};


//for Sprite 
Game_Timer.prototype.updateX = function(value){
	if(typeof value === 'number') this.x = (Graphics.boxWidth - value).clamp(-2000, 2000);
};//*
if(!fieldValid) Game_Timer.prototype.updateX = function(value){};


Game_Timer.prototype.updateY = function(value){
	if(typeof value === 'number') this.y = value.clamp(-2000, 2000);
};//*
if(!fieldValid) Game_Timer.prototype.updateY = function(value){};


Game_Timer.prototype.updateWidth = function(value){
	if(typeof value === 'number') {
		this.width = value.clamp(1, 2000);
		this.whChanged = true;
	}
};//*
if(!fieldValid) Game_Timer.prototype.updateWidth = function(value){};


Game_Timer.prototype.updateHeight = function(value){
	if(typeof value === 'number') {
		this.height = value.clamp(1, 2000);
		this.whChanged = true;
	}
};//*
if(!fieldValid) Game_Timer.prototype.updateHeight = function(value){};


Game_Timer.prototype.updatePosition = function(xPos, yPos, width, height, displayChange, color){
	let x = 0;
	let y = 0;
	switch(xPos){
		case 'left' 	: x = Graphics.boxWidth; break;
		case 'center' 	: x = Graphics.boxWidth/2 + (width || this.width)/2; break;
		case 'right' 	: x = width || this.width; break;
		default 		: x = Graphics.boxWidth - this.x;
	}
	if(typeof xPos === 'number') x = Graphics.boxWidth - xPos;

	switch(yPos){
		case 'upper' 	: y = 0; break;
		case 'center' 	: y = Graphics.boxHeight/2 - (height || this.height)/2; break;
		case 'bottom' 	: y = Graphics.boxHeight - (height || this.height); break;
		default 		: y = this.y;
	}
	if(typeof yPos === 'number') y = yPos;

	if(displayChange) this.secondDisplay = !this.secondDisplay;
	if(color) this.textColor = color;
	this.updateX(x);
	this.updateY(y);
	if(width) this.updateWidth(width);
	if(height) this.updateHeight(height);
};//*

/***********************************************************************************************/
	/*----------プラグインコマンド door　のパラメーター設定-------------*/
		/*~struct~DoorCommand:ja
			@param 	light
			@type 		number
			@text 		軽挙動（フレーム）
			@desc 		weightの値を'light'にした場合、向き変更に必要なウェイトフレームを設定します。初期値は3です。
			@default 	3
			@min 		1
			@decimals 	0

			@param 	heavy
			@type 		number
			@text 		重挙動（フレーム）
			@desc 		weightの値を'heavy'にした場合、向き変更に必要なウェイトフレームを設定します。初期値は15です。
			@default 	15
			@min 		1
			@decimals 	0	
		*/
	/*------------------------------------------------------------------------------------------------------*/
		/*~struct~DoorCommand:
			@param 	light
			@type 		number
			@text 		wait frames of light doors（frames）
			@desc 		Control the frames for turning used when 'light' doors; initial value is 3
			@default 	3
			@min 		1
			@decimals 	0

			@param 	heavy
			@type 		number
			@text 		wait frames of heavy doors（frames）
			@desc 		Control the frames for turning used when 'heavy' doors; initial value is 15
			@default 	15
			@min 		1
			@decimals 	0	
		*/

	const parseDoorCommand = s => JSON.parse(s, (key, value)=>{
		switch(key){
			case 'light' 	: return Number.parseFloat(value);
			case 'heavy' 	: return Number.parseFloat(value);
			default 		: return value;
		}
	});//*

	let doorCommand = params.doorCommand;
	let consolerNameDoor = 'door:';
	if(doorCommand){
		doorCommand = parseDoorCommand(doorCommand);
	}else{
		doorCommand = {"light": 3, "heavy": 15};
	};

	consoler(consolerNameDoor, doorCommand);

/***********************************************************************************************/
	/*----------探索ヘルプメッセージの実装-----------------------*/

		/*~struct~SearchHelp:ja
		@param 	valid
		@type 		boolean
		@text 		サーチ機能の有効化
		@desc 		On（true）にすると、特定のオブジェクトに近づいた際にヒントが表示されるようになります。
		@default 	true

		@param 	targetTreasure
		@type 		select
		@text  	表示対象（宝）
		@desc 		アイテムやフレーバーオブジェクトなどを発見時、ヒントを表示させる対象を設定します。
		@default 	player
			@option 	プレイヤー
			@value 	player

			@option 	オブジェクト
			@value 	object

		@param 	targetFlag
		@type 		select
		@text  	表示対象（フラグ）
		@desc 		イベントメモ<search:event>を発見時、ヒントを表示させる対象を設定します。
		@default 	player
			@option 	プレイヤー
			@value 	player

			@option 	オブジェクト
			@value 	object

		@param 	rangeTreasure
		@type 		number
		@text 		サーチ範囲（宝）
		@desc 		プレイヤーを中心に、どこまでの範囲をサーチするか設定します。(0~8)
		@default 	5
		@max 		8
		@decimals 	0

		@param 	rangeFlag
		@type 		number
		@text 		サーチ範囲（フラグ）
		@desc 		イベントフラグに関して、どこまでの範囲をサーチするか設定します。(0~28)
		@default 	8
		@max 		28
		@decimals 	0

		@param 	item
		@type 		number
		@text 		アイテムのID
		@desc 		イベントメモ<search:item>を発見した時のフキダシアイコンのIDを設定します。
		@default 	2
		@decimals 	0

		@param 	keyItem
		@type 		number
		@text 		大事なもののID
		@desc 		イベントメモ<search:keyItem>を発見した時のフキダシアイコンのIDを設定します。
		@default 	2
		@decimals 	0

		@param 	weapon
		@type 		number
		@text 		武器のID
		@desc 		イベントメモ<search:weapon>を発見した時のフキダシアイコンのIDを設定します。
		@default 	2
		@decimals 	0

		@param 	armor
		@type 		number
		@text 		防具のID
		@desc 		イベントメモ<search:armor>を発見した時のフキダシアイコンのIDを設定します。
		@default 	2
		@decimals 	0

		@param 	talk
		@type 		number
		@text 		会話のID
		@desc 		イベントメモ<search:talk>を発見した時のフキダシアイコンのIDを設定します。
		@default 	2
		@decimals 	0

		@param 	eventBalloon
		@type 		number
		@text 		イベントのID
		@desc 		イベントメモ<search:event>を発見した時のフキダシアイコンのIDを設定します。
		@default 	1
		@decimals 	0
		*/
		/*----------------------------------------------------------------------------------------------*/
		/*~struct~SearchHelp:
		@param 	valid
		@type 		boolean
		@text 		function valid
		@desc 		Available hints to search Event Objects around player when this is true
		@default 	true

		@param 	targetTreasure
		@type 		select
		@text  	target of icons（for treasures）
		@desc 		Select a target where a hint shows when player has found Event Objects for items
		@default 	player
			@option 	Player
			@value 	player

			@option 	Event Objects
			@value 	object

		@param 	targetFlag
		@type 		select
		@text  	target of icons（for event flags）
		@desc 		Select a target where a hint shows when player has found Event Objects with Tag <search:event>
		@default 	player
			@option 	Player
			@value 	player

			@option 	Event Objects
			@value 	object

		@param 	rangeTreasure
		@type 		number
		@text 		range of searching（for treasures）
		@desc 		Control the range from player between 0 and 8
		@default 	5
		@max 		8
		@decimals 	0

		@param 	rangeFlag
		@type 		number
		@text 		range of searching（for Event flags）
		@desc 		Control the range from Event Objects between 0 and 28
		@default 	8
		@max 		28
		@decimals 	0

		@param 	item
		@type 		number
		@text 		balloonId of items
		@desc 		Control the Id when player searched Note Tag <search:item>
		@default 	2
		@decimals 	0

		@param 	keyItem
		@type 		number
		@text 		balloonId of keyItems
		@desc 		Control the Id when player searched Note Tag <search:keyItem>
		@default 	2
		@decimals 	0

		@param 	weapon
		@type 		number
		@text 		balloonId of weapons
		@desc 		Control the Id when player searched Note Tag <search:weapon>
		@default 	2
		@decimals 	0

		@param 	armor
		@type 		number
		@text 		balloonId of armors
		@desc 		Control the Id when player searched Note Tag <search:armor>
		@default 	2
		@decimals 	0

		@param 	talk
		@type 		number
		@text 		balloonId of peaple
		@desc 		Control the Id when player searched Note Tag <search:talk>
		@default 	2
		@decimals 	0

		@param 	eventBalloon
		@type 		number
		@text 		balloonId of events
		@desc 		Control the Id when player searched Note Tag <search:event>
		@default 	1
		@decimals 	0
		*/

		const parseSearchHelp = s => JSON.parse(s, (key, value) =>{
			switch(key){
				case 'valid' 			: return value;
				case 'targetTreasure' 	: return value;
				case 'targetFlag' 		: return value;
				case 'rangeTreasure' 	: return Number.parseFloat(value);
				case 'rangeFlag'	 	: return Number.parseFloat(value);
				case 'item' 			: return Number.parseFloat(value);
				case 'keyItem' 			: return Number.parseFloat(value);
				case 'weapon' 			: return Number.parseFloat(value);
				case 'armor' 			: return Number.parseFloat(value);
				case 'talk' 			: return Number.parseFloat(value);
				case 'eventBalloon' 	: return Number.parseFloat(value);
				default 				: return value;
			};
		});//*

		let searchHelp = params.searchHelp;
		let consolerNameSearchHelp = 'searchHelp:';
		if(searchHelp){
				searchHelp = parseSearchHelp(searchHelp);
				searchHelp = stringToBoolean(searchHelp);
		}else{
				searchHelp = makeNotValid();
				undefinedStructs.push(consolerNameSearchHelp);
				consolerNameSearchHelp += makeInvalidTerm();
		}
		consoler(consolerNameSearchHelp, searchHelp);

if(fieldValid && searchHelp.valid) ConfigManager.searchHelp = true;


const _Game_System_prototype_initialize_G = Game_System.prototype.initialize;
Game_System.prototype.initialize = function(){
	_Game_System_prototype_initialize_G.apply(this, arguments);
	this._searchHelp = [];
};//*

const _Game_Event_prototype_initializeA = Game_Event.prototype.initialize;
Game_Event.prototype.initialize = function(mapId, eventId) {
    _Game_Event_prototype_initializeA.apply(this, arguments);
    this.refreshSearchTag();
};//*


if(fieldValid && ConfigManager.searchHelp){
	const _Scene_Map_prototype_onMapLoaded = Scene_Map.prototype.onMapLoaded;
	Scene_Map.prototype.onMapLoaded = function() {
	    _Scene_Map_prototype_onMapLoaded.apply(this, arguments);
	    if(!this._transfer){
		    	if($gameMap && $dataMap){
		    		$gameMap.events().map(e => e.refreshSearchTag());
		    	}
	    }
	};//*

	const _Game_Map_prototype_update = Game_Map.prototype.update ;
	Game_Map.prototype.update = function(sceneActive){
		_Game_Map_prototype_update.apply(this, arguments);

		if($gamePlayer.isMoving() && searchCount === 0){
			searchCount += 1;
			this.searchEvent();			
		}else if($gamePlayer.isStopping() && searchCount !== 0){
			searchCount = 0;
		}
	};//*
}////

const searchBalloon = function(id, tag, flag){
	let balloonId = getSearchTag(tag);
	let target = flag ? searchHelp.targetFlag : searchHelp.targetTreasure;

	if(balloonId === -1){return};

	if(target === 'player'){
		if(MV){
			$gamePlayer.requestBalloon(balloonId);
		}else if(MZ){
			$gameTemp.requestBalloon($gamePlayer, balloonId);
		};
	}else if(target === 'object'){
		if(MV){
			$gameMap.event(id).requestBalloon(balloonId);
		}else if(MZ){
			$gameTemp.requestBalloon($gameMap.event(id), balloonId);
		};
	};
};//*

const getSearchTag = function(tag){
	switch(tag){
		case 'item'		: return searchHelp.item; 		break;
		case 'keyItem'	: return searchHelp.keyItem; 	break;
		case 'weapon'	: return searchHelp.weapon; 	break;
		case 'armor'	: return searchHelp.armor; 		break;
		case 'talk'		: return searchHelp.talk; 		break;
		case 'event'	: return searchHelp.eventBalloon;break;
		default 		: return -1; 				//フラグ消滅時
	};//*
};//*


Game_System.prototype.searchHelp = function(mapId){
	const help = this._searchHelp.filter(obj => {return obj['mapId'] === mapId});
	return help;
};//*
if(!fieldValid || !ConfigManager.searchHelp) Game_System.prototype.searchHelp = function(mapId){return false};


Game_System.prototype.searchHelpTag = function(eventId){
	const mapId = $gameMap.mapId();
	let help = this.searchHelp(mapId);
	if(help.length > 0){
			const tag = help[0][eventId];
			return tag;
	}
};//*
if(!fieldValid || !ConfigManager.searchHelp) Game_System.prototype.searchHelpTag = function(eventId){return false};


Game_System.prototype.addChangedSearchHelp = function(eventId, tagName){
	const mapId = $gameMap.mapId();
	let help = this.searchHelp(mapId);
	if(help.length > 0){
			help[0][eventId] = tagName;
	}else{
			this._searchHelp.push({"mapId":mapId});
			this.searchHelp(mapId)[0][eventId] = tagName;
	}
};//*
if(!fieldValid || !ConfigManager.searchHelp) Game_System.prototype.addChangedSearchHelp = function(eventId, tagName){};


Game_Event.prototype.refreshSearchTag = function(){
	const eventId = this.eventId();
	const tagName = $gameSystem.searchHelpTag(eventId);
	if(tagName === undefined){
			return;
	}else{
			this.event().meta.search = tagName;
	}
};//*
if(!fieldValid || !ConfigManager.searchHelp) Game_Event.prototype.refreshSearchTag = function(){};


Game_Map.prototype.searchEvent = function(){
	const xP = $gamePlayer.x;
	const yP = $gamePlayer.y;
	const events = this.screenEvents();
	const searchRange 	= searchHelp.rangeTreasure;
	const flagRange 	= searchHelp.rangeFlag

	let targets = events.filter(event => {return this.distance(xP, yP, event.x, event.y) <= searchRange});
		targets = targets.filter(event => {return event.event().meta.search});	
	let targetsFlag = events.filter(event => {return this.distance(xP, yP, event.x, event.y) <= flagRange});
		targetsFlag = targetsFlag.filter(event => {return event.event().meta.search === 'event'});

	if(targets.length > 0){
		let tag;
		let tagBase;
		targets.forEach(function(event){
							tagBase = event.event().meta.search;
							tag = tagBase !== 'event' ? tagBase : '';
							searchBalloon(event._eventId, tag, false);
						});
	};

	if(targetsFlag.length > 0){
		let tag;
		targetsFlag.forEach(function(event){
								tag = event.event().meta.search;
								searchBalloon(event._eventId, tag, true);
							});
	};
};//*
if(!fieldValid || !ConfigManager.searchHelp) Game_Map.prototype.searchEvent = function(){};



/***********************************************************************************************/
	/*-------------ゲームオーバー処理のオーバーライド-------------------*/

const _Game_System_prototype_initialize_H = Game_System.prototype.initialize;
Game_System.prototype.initialize = function(){
	_Game_System_prototype_initialize_H.apply(this, arguments);
	this._executingGameOver = false;
	this._gameOverEvent = fieldBasic.gameOverEvent || 0;
};//*

if(fieldValid){
	const _Scene_Base_prototype_checkGameover = Scene_Base.prototype.checkGameover;
	Scene_Base.prototype.checkGameover = function() {
	    if ($gameParty.isAllDead()) {
	    	if(!$gameSystem.enableOriginalGameOver()){
	    		SceneManager.goto(Scene_Gameover);	
	    	}else if(!$gameSystem.isExecutingGameOver()){
	    		$gameSystem.setExecutingGameOver(true);
	    		$gameTemp.reserveCommonEvent($gameSystem.gameOverEvent()); 
	    		$gameSystem.onBattleLose(true);
	    	};
	    }
	};//*

	const _BattleManager_updateBattleEnd = BattleManager.updateBattleEnd;
	BattleManager.updateBattleEnd = function() {
	    if (this.isBattleTest()) {
	        AudioManager.stopBgm();
	        SceneManager.exit();
	    } else if (!this._escaped && $gameParty.isAllDead()) {
	        if (this._canLose) {
	            $gameParty.reviveBattleMembers();
	            SceneManager.pop();
	        } else {
	        	if(!$gameSystem.enableOriginalGameOver()){
	        		SceneManager.goto(Scene_Gameover);	
	        	}else{
	        		SceneManager.pop(); //added !! cannot execute commonEvent here
	        	};
	        }
	    } else {
	        SceneManager.pop();
	    }
	    this._phase = null;
	    animationDamage = tempAnimationDamage;
	};//*
}////

Game_System.prototype.isExecutingGameOver = function(){
	return this._executingGameOver;
};//*
if(!fieldValid) Game_System.prototype.isExecutingGameOver = function(){return false};


Game_System.prototype.setExecutingGameOver = function(value){
	this._executingGameOver = value;
};//*
if(!fieldValid) Game_System.prototype.setExecutingGameOver = function(value){};


Game_System.prototype.gameOverEvent = function(){
	return fieldBasic.gameOverEvent || this._gameOverEvent;
};//*
if(!fieldValid) Game_System.prototype.gameOverEvent = function(){return 0};


Game_System.prototype.enableOriginalGameOver = function(){
	return this.gameOverEvent() > 0;
};//*
if(!fieldValid) Game_System.prototype.enableOriginalGameOver = function(){return false};


Game_System.prototype.setGameOverEvent = function(value){
	if(value > 0) this._gameOverEvent = value;
};//*
if(!fieldValid) Game_System.prototype.setGameOverEvent = function(value){};


/***********************************************************************************************/
	/*-------------------ファストトラベルの設定--------------------------------*/

				/*~struct~FastTravel:ja
					@param needUpdate
					@type 	boolean
					@text 	転送パラメーターの随時更新
					@desc 	On(true)の時、制作中に変動した拠点や転送エリアの設定を反映させます。デプロイ時にはOff(false)にして下さい。
					@default false

					@param 	name
					@type 		string
					@text 		ファストトラベル名
					@desc 		世界観に応じて、ファストトラベルの呼び方を設定します。
					@default 	転送

					@param 	exeTravel
					@type 		common_event
					@text 		演出コモンイベント
					@desc 		ファストトラベルの実行を演出するコモンイベントを設定します。「なし」の時、ファストラベルの設定は無効になります。
					@default 	0

					@param 	fontSize
					@type 		number
					@text 		文字サイズ
					@desc 		ファストトラベルメニューの文字サイズを設定します。エリアやファストトラベル名は0.8倍にします。
					@default 	28
					@min 		12
					@decimals 	0

					@param 	base
					@type 		struct<BaseFastTravel>
					@text 		拠点設定
					@desc 		拠点に関する設定を行います。

					@param 	area
					@type 		struct<AreaFastTravel>[]
					@text 		転送エリア
					@desc 		ファストトラベル先にする各エリアを設定します。

					@param 	background
					@type  	boolean
					@text 		背景の不透明化
					@desc 		On（true）の時、メニューのように背景がぼやけます。Off（false）にすると真っ暗の背景になります。
					@default 	true

					@param 	dialogMessage
					@type 		string
					@text 		転送メッセージ
					@desc 		転送ダイアログのメッセージを設定します。行き先変数がOnの時、このメッセージの前に行き先を表示します。
					@default 	移動しますか？

					@param 	destination
					@type 		boolean
					@text 		行き先表示
					@desc 		On（true）の時、転送メッセージの直前に行き先を表示します。目的の「へ」は自動で付与されます。
					@default 	true

					@param 	checkMessage
					@type  	string[]
					@text 		確認メッセージ
					@desc 		転送時の確認メッセージを設定します。１つ目が決定、２つ目がキャンセルになります。
					@default 	["はい", "いいえ"]

					@param 	sealingMessage
					@type 		string
					@text 		封印メッセージ
					@desc 		トラベル先が一時的に封印されている時、説明欄に表示する注意メッセージを設定します。制御文字は使えません。
					@default 	※今は封印されています
				*/
				/*----------------------------------------------------------------------------------------------------------------*/
				/*~struct~FastTravel:
					@param needUpdate
					@type 	boolean
					@text 	need to update
					@desc 	Update informations of base or areas when this is true; switch off when you deploy this game!
					@default false

					@param 	name
					@type 		string
					@text 		system name
					@desc 		Define system name of fastTravel
					@default 	Fast Travel

					@param 	exeTravel
					@type 		common_event
					@text 		common_event for performing
					@desc 		Select a common_event to perform fastTravel; Not selected, fastTravel settings turn invalid
					@default 	0

					@param 	fontSize
					@type 		number
					@text 		font size
					@desc 		Control main font size in fastTravel window; areas or system name are multiplied 0.8
					@default 	28
					@min 		12
					@decimals 	0

					@param 	base
					@type 		struct<BaseFastTravel>
					@text 		setting of base
					@desc 		Construct a setting of base

					@param 	area
					@type 		struct<AreaFastTravel>[]
					@text 		setting of areas and regions
					@desc 		Construct settings of areas and regions

					@param 	background
					@type  	boolean
					@text 		opacity of background of fastTravel scene
					@desc 		When this is true, background is displayed blurry; otherwise black
					@default 	true

					@param 	dialogMessage
					@type 		string
					@text 		dialog message for execution
					@desc 		Define the message; when "destination" is true, name of destination is added below this
					@default 	Execute to transfer

					@param 	destination
					@type 		boolean
					@text 		display destination
					@desc 		Add destination below "dialogMessage" when this is true
					@default 	true

					@param 	checkMessage
					@type  	string[]
					@text 		command to select
					@desc 		Define command names for dialog; the former for OK, the later for Cancel
					@default 	["OK", "Cancel"]

					@param 	sealingMessage
					@type 		string
					@text 		message for temporary sealing
					@desc 		Define text to announce that destination is temporary sealing
					@default 	Now unavailable
				*/
		/***********************************************************************************************/
							/*~struct~BaseFastTravel:ja
								@param 	name
								@type 		string
								@text 		拠点名
								@desc 		拠点の名前を設定します。
								@default 	マイキャッスル

								@param 	nameValue
								@type 		variable
								@text 		自由拠点名
								@desc 		プレイヤーが拠点名を決める場合、格納する変数を設定します。未設定時は上の拠点名で途中変更不可となります。
								@default 	0

								@param 	alwaysBase
								@type 		boolean
								@text 		常時表示
								@desc 		On（true）かつ解禁状態の時、全てのエリアの最下段に拠点が表示されるようになります。
								@default 	true
	
								@param 	mapId
								@type 		number
								@text 		拠点のマップID
								@desc 		拠点としてファストトラベル先にするマップのIDを設定します。
								@default 	1
								@min 		0
								@decimals 	0

								@param 	x
								@type 		number
								@text 		拠点のｘ座標
								@desc 		拠点としてファストトラベル先にするマップのｘ座標を設定します。
								@default 	0
								@decimals 	0

								@param 	y
								@type 		number
								@text 		拠点のｙ座標
								@desc 		拠点としてファストトラベル先にするマップのｙ座標を設定します。
								@default 	0
								@decimals 	0

								@param 	image
								@type 		file
								@text 		イメージ画像
								@desc 		選択中に表示する、転送先のイメージ画像を設定します。設定しなくても問題ありません。
								@dir 		img
								@require 1

								@param 	memo
								@type 		note
								@text 		トラベル先解説
								@desc 		トラベル先にカーソルが合っているときに表示する地理解説を設定します。

								@param 	release
								@type 		boolean
								@text 		解禁状態
								@desc 		On（true）時、ファストトラベル先として表示されます。この設定はプラグインコマンドで変更可能です。
								@default 	false
							*/
							/*------------------------------------------------------------------------------------------------------*/
							/*~struct~BaseFastTravel:
								@param 	name
								@type 		string
								@text 		base name
								@desc 		Define the name of base
								@default 	My Castle

								@param 	nameValue
								@type 		variable
								@text 		variable for base name
								@desc 		Select a variable for player's base name; if no varialbe, player can't change the name
								@default 	0

								@param 	alwaysBase
								@type 		boolean
								@text 		display base always
								@desc 		Display base name at the last of region's list in fasttravel scene when this is true
								@default 	true
	
								@param 	mapId
								@type 		number
								@text 		mapId of base
								@desc 		Control the mapId
								@default 	1
								@min 		0
								@decimals 	0

								@param 	x
								@type 		number
								@text 		x-coordinate of base
								@desc 		Control the x-coordinate
								@default 	0
								@decimals 	0

								@param 	y
								@type 		number
								@text 		y-coordinate of base
								@desc 		Control the y-coordinate
								@default 	0
								@decimals 	0

								@param 	image
								@type 		file
								@text 		image of base
								@desc 		Select the image if you need
								@dir 		img
								@require 1

								@param 	memo
								@type 		note
								@text 		explanation of base
								@desc 		Write expalanation displayed in help window when player is selecting base

								@param 	release
								@type 		boolean
								@text 		condition of release
								@desc 		Added to area's list when this is true; you can control this by PluginCommand
								@default 	false
							*/
		/***********************************************************************************************/
							/*~struct~AreaFastTravel:ja
								@param 	name
								@type 		string
								@text 		エリア名
								@desc 		国や領土といった大きなエリアの名前を設定します。
								@default 	エリア

								@param 	children
								@type 		struct<ChildrenFastTravel>[]
								@text 		トラベル先設定
								@desc 		実際にファストトラベル先にする各地の情報を設定します。
							*/
							/*--------------------------------------------------------------------------------*/
							/*~struct~AreaFastTravel:
								@param 	name
								@type 		string
								@text 		name of this area
								@desc 		Define the name of this area; country name or territory name etcetera
								@default 	Area 1

								@param 	children
								@type 		struct<ChildrenFastTravel>[]
								@text 		setting of regions
								@desc 		Construct regions where player actually transfers
							*/
		/***********************************************************************************************/
								/*~struct~ChildrenFastTravel:ja
									@param 	name
									@type 		string
									@text 		地名
									@desc 		ファストトラベル先の地名を設定します。
									@default 	地名

									@param 	mapId
									@type 		number
									@text 		マップID
									@desc 		ファストトラベル先のマップのIDを設定します。
									@default 	1
									@min 		0
									@decimals 	0

									@param 	x
									@type 		number
									@text 		ｘ座標
									@desc 		ファストトラベル先のマップのｘ座標を設定します。
									@default 	0
									@decimals 	0

									@param 	y
									@type 		number
									@text 		ｙ座標
									@desc 		ファストトラベル先のマップのｙ座標を設定します。
									@default 	0
									@decimals 	0

									@param 	image
									@type 		file
									@text 		イメージ画像
									@desc 		選択中に表示する、転送先のイメージ画像を設定します。設定しなくても問題ありません。
									@dir 		img
									@require 1

									@param 	memo
									@type 		note
									@text 		トラベル先解説
									@desc 		トラベル先にカーソルが合っているときに表示する地理解説を設定します。

									@param 	release
									@type 		boolean
									@text 		解禁状態
									@desc 		On（true）時、ファストトラベル先として表示されます。この設定はプラグインコマンドで変更可能です。
									@default 	false
								*/
								/*------------------------------------------------------------------------------------------------------*/
								/*~struct~ChildrenFastTravel:
									@param 	name
									@type 		string
									@text 		name of this region
									@desc 		Define the name of this region or destination
									@default 	Region 1

									@param 	mapId
									@type 		number
									@text 		mapId of this region
									@desc 		Control the mapId
									@default 	1
									@min 		0
									@decimals 	0

									@param 	x
									@type 		number
									@text 		x-coordinate of this region
									@desc 		Control the x-coordinate
									@default 	0
									@decimals 	0

									@param 	y
									@type 		number
									@text 		y-coordinate
									@desc 		Control the y-coordinate
									@default 	0
									@decimals 	0

									@param 	image
									@type 		file
									@text 		image of this region
									@desc 		Select the image if you need
									@dir 		img
									@require 1

									@param 	memo
									@type 		note
									@text 		explanation of this region
									@desc 		Write explanation displayed in help window when player is selecting this region

									@param 	release
									@type 		boolean
									@text 		condition of release
									@desc 		Added to region's list when this is true; you can control this by PluginCommand
									@default 	false
								*/

			const parseFastTravel = s => JSON.parse(s, (key, value)=>{
				switch(key){
					case 'needUpdate'	: return value === 'true';
					case 'name' 		: return value;
					case 'exeTravel' 	: return Number.parseFloat(value);
					case 'fontSize' 	: return Number.parseFloat(value);
					case 'base' 		: return value ? JSON.parse(value) : value;
					case 'area' 		: return value ? JSON.parse(value) : [];
					case 'nameValue' 	: return Number.parseFloat(value);
					case 'alwaysBase' 	: return value;
					case 'children' 	: return JSON.parse(value);
					case 'mapId'		: return Number.parseFloat(value);
					case 'x' 			: return Number.parseFloat(value);
					case 'y' 			: return Number.parseFloat(value);
					case 'image' 		: return value;
					case 'memo' 		: return value;
					case 'background' 	: return value;
					case 'release' 		: return value;
					case 'dialogMessage': return value;
					case 'destination' 	: return value;
					case 'checkMessage' : return value;
					case 'sealingMessage':return value;
					default 			: return value;
				}
			});//*

			let fastTravelList = params.fastTravel;
			let fastTravelSystem = params.fastTravel;
			let consolerNameFastTravel = 'fasttravel:';
			if(fastTravelList){
					fastTravelList = parseFastTravel(fastTravelList);
					fastTravelSystem = parseFastTravel(fastTravelSystem);
			}else{
					fastTravelList = makeNotValid();
					undefinedStructs.push(consolerNameFastTravel);
					consolerNameFastTravel += makeInvalidTerm();
			};
			consoler(consolerNameFastTravel, fastTravelList);

			let touchCampArea = 0;
			let currentCampName = '';
			let alreadyUpdatedFtParameter = false;

const getFastTravelAreas = function(ft){
	if(!isFastTravelValid()) return;

	//let ft = fastTravelList;
		ft = optimizeBase(ft);
		ft.area = ft.area.map(s => JSON.parse(s));
		
		for(var i = 0; i < ft.area.length; i++){
			ft.area[i].children = JSON.parse(ft.area[i].children);
			ft.area[i].children = ft.area[i].children.map(c => JSON.parse(c));
			ft.area[i].children = ft.area[i].children.map(c => optimizeCamp(c));
			ft.area[i].release = false;								
		};

		ft.area.unshift(ft.base);
		return ft.area;
};//*

const optimizeBase = function(ft){
	ft.base.nameValue 	= Number(ft.base.nameValue);
	ft.base.mapId 		= Number(ft.base.mapId || 0);
	ft.base.x 			= Number(ft.base.x || 0);
	ft.base.y 			= Number(ft.base.y || 0);
	ft.base.memo 		= ft.base.memo ? JSON.parse(ft.base.memo) : '';
	ft.base = stringToBoolean(ft.base);
	ft.base.temporarySealed = false;
	return ft;
};//*

const optimizeCamp = function(camp){
	camp.mapId = Number(camp.mapId || 0);
	camp.x = Number(camp.x || 0);
	camp.y = Number(camp.y || 0);
	camp.memo = camp.memo ? JSON.parse(camp.memo) : '';
	camp.release = camp.release === 'true';
	camp.temporarySealed = false;
	return camp;
};//*

const getFastTravelSettings = function(ft){
	if(!isFastTravelValid) return;
			
	ft.checkMessage = JSON.parse(ft.checkMessage);
	delete ft.base;
	delete ft.area;
	ft = stringToBoolean(ft);
	return ft;
};//*


const checkCurrentCamp = function(mapId, rangeX, rangeY){
	$gameFastTravel.updateParam();
	const FT = $gameFastTravel;
	if(mapId === $gameFastTravel.mapId()){
			touchCampArea = 0;
			currentCampName = $gameFastTravel.name();
			loadAreaImage($gameFastTravel.camp());
	}else{
			const areas = $gameFastTravel.areas();
			touchCampArea = areas.findIndex( (element, index) => {
											return index > 0 && element.children.some(key =>
															{ return key.mapId === mapId });
										});
			let area = $gameFastTravel.areas()[touchCampArea];
			let campId = area.children.findIndex((element)=>element.mapId === mapId &&
															rangeX.contains(element.x) &&
															rangeY.contains(element.y));
			currentCampName = $gameFastTravel.name(touchCampArea, campId);
			loadAreaImage($gameFastTravel.camp(touchCampArea, campId));
	}
	$gameFastTravel.setTouchCampArea();
	$gameFastTravel.setCurrentCampName();
};//*


Game_Player.prototype.resetRespown = function(id, x, y){
	this._respownMapId = id;
	this._respownX = x;
	this._respownY = y;
};//*


const loadAreaImage = function(camp){
	let path = camp.image.split('/')[0];
	let name = camp.image.split('/')[1];
	ImageManager.separateLoading(path, name);
};//*

const isFastTravelValid = function(){
	//return parseFastTravel(params.fastTravel).area.length > 0;
	return fieldValid && fastTravelList.exeTravel > 0;
};//*

const recoverFastTravelList = function(){
	fastTravelList = parseFastTravel(params.fastTravel);
};//*

if(fastTravelSystem) fastTravelSystem = getFastTravelSettings(fastTravelSystem);

if(isFastTravelValid()){
		const _DataManager_createGameObjects = DataManager.createGameObjects;
		DataManager.createGameObjects = function(){
			_DataManager_createGameObjects.apply(this, arguments);
			$gameFastTravel = new Game_FastTravel();
		};//*

		const _DataManager_makeSaveContents = DataManager.makeSaveContents;
		DataManager.makeSaveContents = function(){
			var contents = _DataManager_makeSaveContents.call(this);
				contents.gameFastTravel = $gameFastTravel;
			return contents;
		};//*

		const _DataManager_extractSaveContents = DataManager.extractSaveContents;
		DataManager.extractSaveContents = function(contents){
			_DataManager_extractSaveContents.call(this, contents);
			$gameFastTravel = contents.gameFastTravel;
		};//*

		if(MZ){
			const _Scene_Load_prototype_executeLoad = Scene_Load.prototype.executeLoad;
			Scene_Load.prototype.executeLoad = function(savefileId) {
				if(fastTravelList.needUpdate && alreadyUpdatedFtParameter){
					alreadyUpdatedFtParameter = false;
				}
			   	_Scene_Load_prototype_executeLoad.apply(this, arguments);
			};//*
		}else if(MV){
			const _Scene_Load_prototype_onSavefileOk = Scene_Load.prototype.onSavefileOk;
			Scene_Load.prototype.onSavefileOk = function() {
			    if ( DataManager.loadGame(this.savefileId()) ){
			    	if(fastTravelList.needUpdate && alreadyUpdatedFtParameter){
						alreadyUpdatedFtParameter = false;
					}
			    }
			    _Scene_Load_prototype_onSavefileOk.apply(this, arguments);
			};//*
		}
}////

class Game_FastTravel {
		constructor(){
			this._area = getFastTravelAreas(fastTravelList);
			//this._setting = getFastTravelSettings(fastTravelList);
			recoverFastTravelList();
			this._touchCampArea = 0;
			this._currentCampName = null;
			this._maxLength = 0;
			this._multiCamps = this.createMultiCamps();
			this._partyId = multiPartyValid ? multiParty.startId : 0;
			this._relativeMultiParty = true;
		};//*

		//25.02.21複数パーティが有効な時、パーティごとにキャンプの解法状況を管理できるように
		createMultiCamps (){
			let camps = [{"name" : 'party0', "conditions" : []},
						 {"name" : 'party1', "conditions" : []},
						 {"name" : 'party2', "conditions" : []},
						 {"name" : 'party3', "conditions" : []},
						 {"name" : 'party4', "conditions" : []},
						 {"name" : 'party5', "conditions" : []},];
			const base = this.camp();
			camps.forEach(camp => camp.conditions.push([this.getMultiCampRelease(base)]));
			const areas = this.areas();
			for(var i = 1; i < areas.length; i++){
				let areaCamps0 = this.getMultiCampsReleaseInArea(areas[i]);
				let areaCamps1 = this.getMultiCampsReleaseInArea(areas[i]);
				let areaCamps2 = this.getMultiCampsReleaseInArea(areas[i]);
				let areaCamps3 = this.getMultiCampsReleaseInArea(areas[i]);
				let areaCamps4 = this.getMultiCampsReleaseInArea(areas[i]);
				let areaCamps5 = this.getMultiCampsReleaseInArea(areas[i]);
				camps[0].conditions.push(areaCamps0);
				camps[1].conditions.push(areaCamps1);
				camps[2].conditions.push(areaCamps2);
				camps[3].conditions.push(areaCamps3);
				camps[4].conditions.push(areaCamps4);
				camps[5].conditions.push(areaCamps5);
			}
			return camps;
		};//*

		getMultiCampRelease (camp){
			return {"release" : camp.release, 
					"temporarySealed" : camp.temporarySealed};
		};//*

		getMultiCampsReleaseInArea (area){
			let children = area.children;
			let areaCamps = [];
			children.forEach(child => {
				areaCamps.push(this.getMultiCampRelease(child));
			})
			return areaCamps;
		};//*

		isOpenedMultiCamp (partyId, areaId, campId){
			return this.isReleasedMultiCamp(partyId, areaId, campId) &&
					!this.isTempSealedMultiCamp(partyId, areaId, campId);
		};//*

		isReleasedMultiCamp (partyId, areaId, campId){
			if(partyId > 0){
				const condition = this.getMultiCondition(partyId, areaId, campId);
				return condition.release;
			}else{
				return true;
			}
		};//*

		isTempSealedMultiCamp (partyId, areaId, campId){
			if(partyId > 0){
				const condition = this.getMultiCondition(partyId, areaId, campId);
				return condition.temporarySealed;
			}else{
				return false;
			}
		};//*

		setMultiCampRelease (value, partyId, areaId, campId){
			if(partyId < 0) partyId = this._partyId;

			if(partyId === 0){
				for(var i = 1; i < 6; i++){
					this.getMultiCondition(i, areaId, campId).release = value;
				}
			}else if(partyId > 0){
				this.getMultiCondition(partyId, areaId, campId).release = value;
			}
		};//*

		setMultiCampTempSeal (value, partyId, areaId, campId){
			if(partyId === 0){
				for(var i = 1; i < 6; i++){
					this.getMultiCondition(i, areaId, campId).temporarySealed = value;
				}
			}else if(partyId > 0){
				this.getMultiCondition(partyId, areaId, campId).temporarySealed = value;
			}else{
				//for example, case -1
				this.getMultiCondition(this._partyId, areaId, campId).temporarySealed = value;
			}
		};//*

		getMultiCamp (partyId){
			return this._multiCamps[partyId];
		};//*

		getMultiCondition(partyId, areaId, campId){
			const conditions = this.getMultiCamp(partyId).conditions;
			return areaId === 0 ? conditions[areaId][0] : conditions[areaId][campId];
		};//*

		setPartyId (id){
			if(this.relativeMultiParty()){
				if(0 <= id && id <= 5) this._partyId = id;	
			}else{
				this._partyId = 0;
			}
		};//*

		relativeMultiParty (){
			return this._relativeMultiParty;
		};//*

		//---------//
		/*25.03.24　パーティ合流時のためのMultiCamp条件の集合を追記*/
		//isOpenedCampだとMultiCampの解放条件まで入ってくるので別途専用の判別を行う

		gatherMultiCamp(){
			this.setPartyId(0);
			const areas = this.areas().length;
			const c1 = this.getMultiCamp(1).conditions;
			const c2 = this.getMultiCamp(2).conditions;
			const c3 = this.getMultiCamp(3).conditions;
			const c4 = this.getMultiCamp(4).conditions;
			const c5 = this.getMultiCamp(5).conditions;

			for (var i = 0; i < areas; i++){
				if(i === 0){
					let result0 = this.booleanBit(c1[0][0].release,
												  c2[0][0].release,
												  c3[0][0].release,
												  c4[0][0].release,
												  c5[0][0].release);
					if(result0){
						c1[0][0].release = result0;
						c2[0][0].release = result0;
						c3[0][0].release = result0;
						c4[0][0].release = result0;
						c5[0][0].release = result0;
					}
				}else{
					let camps = this.camps(i).length;
					for(var j = 0; j < camps; j++){
						let result = this.booleanBit(c1[i][j].release,
													 c2[i][j].release,
													 c3[i][j].release,
													 c4[i][j].release,
													 c5[i][j].release);
						if(result){
							c1[i][j].release = result;
							c2[i][j].release = result;
							c3[i][j].release = result;
							c4[i][j].release = result;
							c5[i][j].release = result;
						}
					}
				}
			}
		};//*

		booleanBit(key1, key2, key3, key4, key5, every){
			return every ? (key1 && key2 && key3 && key4 && key5) :
						(key1 || key2 || key3 || key4 || key5);
		};//*

		//---------//


		updateParam(){
			if(!fastTravelList.needUpdate) 	return;
			if(alreadyUpdatedFtParameter)	return;

			alreadyUpdatedFtParameter = true;

			let newFastTravelList = params.fastTravel;
				newFastTravelList = parseFastTravel(newFastTravelList);
			const newAreas = getFastTravelAreas(newFastTravelList);
			newAreas.forEach((area, index) => {
				if(index === 0){
					let base = this._area[index];
					if(!base) base = {};

					this.updateEachParam(base, area, true);
				}else{
					let oldArea = this._area[index];
					if(!oldArea){
						this._area.push(area);
					}else{
						area.children.forEach(child => {
							if(this.hasAreaChild(oldArea, child)){
								let childId = this.findIndexAreaChild(oldArea, child);
								this.updateEachParam(oldArea.children[childId], child, false);
							}else{
								oldArea.children.push(child);
							}
						})
						let shiftIds = [];
						let children = oldArea.children;
						children.forEach((child, cId) => {
							if(!this.hasAreaChild(area, child)) shiftIds.push(cId);
						})
						if(shiftIds.length > 0){
							children = children.filter((oc, id)=>{return !shiftIds.contains(id)});
						}
					}
				}
			});
		};//*

		updateEachParam (oldCamp, newCamp, isBase){
			if(!oldCamp || !newCamp) return;

			if(oldCamp.name !== newCamp.name) 	oldCamp.name = newCamp.name;
			if(oldCamp.mapId !== newCamp.mapId) oldCamp.mapId = newCamp.mapId;
			if(oldCamp.x !== newCamp.x) 		oldCamp.x = newCamp.x;
			if(oldCamp.y !== newCamp.y) 		oldCamp.y = newCamp.y;
			if(oldCamp.image !== newCamp.image)	oldCamp.image = newCamp.image;
			if(oldCamp.memo !== newCamp.memo)	oldCamp.memo = newCamp.memo;

			if(isBase){
				if(oldCamp.nameValue !== newCamp.nameValue)		oldCamp.nameValue = newCamp.nameValue;
				if(oldCamp.alwaysBase !== newCamp.alwaysBase) 	oldCamp.alwaysBase = newCamp.alwaysBase;	
			}
		};//*

		hasAreaChild (area, child){
			const children = area.children;
			return children.some(c => {return c.mapId === child.mapId && c.x === child.x && c.y === child.y});
		};//*

		setBaseName (){
			const id = this.baseNameValue();
			if(id > 0 && !$gameVariables.value(id)){
				$gameVariables.setValue(id, this.areas()[0].name);
			}
		};//*

		systemName (){
			return fastTravelSystem.name || 'ファストトラベル';
		};//*

		background (){
			return fastTravelSystem.background;
		};//*

		fontSize (){
			return fastTravelSystem.fontSize || 21;
		};//*

		commonEvent (){
			return fastTravelSystem.exeTravel || 0;
		};//*

		dialogMessage (){
			return fastTravelSystem.dialogMessage;
		};//*

		isDestinationValid (){
			return fastTravelSystem.destination;
		};//*

		checkMessage(id){
			if(id === 0 || id === 1){
					return fastTravelSystem.checkMessage[id];	
			}
		};//*

		sealingMessage (){
			return fastTravelSystem.sealingMessage;
		};//*

		setTouchCampArea (){
			this._touchCampArea = touchCampArea;
		};//*

		getTouchCampArea (){
			return this._touchCampArea;
		};//*

		setCurrentCampName (){
			this._currentCampName = currentCampName;
		};//*

		getCurrentCampName (){
			return this._currentCampName;
		};//*

		areas (){
			return this._area;
		};//*

		camps (areaId){
			if(areaId > 0){
					return this.areas()[areaId].children;
			}
		};//*

		isOpenedArea (areaId){
			if(areaId > 0){
					const camps = this.camps(areaId);
					return camps.some((c, index) => {
						return c.release && this.isReleasedMultiCamp(this._partyId, areaId, index);
					});
			}else{
					return this.camp().release && this.isReleasedMultiCamp(this._partyId, 0, 0);
			}
		};//*

		isOpenedCamp (areaId, campId){
			if(!areaId){
					return this.camp().release && 
							this.isReleasedMultiCamp(this._partyId, 0, 0);
			}else if(areaId > 0 && campId >= 0){
					return this.camp(areaId, campId).release && 
							this.isReleasedMultiCamp(this._partyId, areaId, campId);
			}
		};//*

		areaOpen (areaId){
			if(areaId >= 0 && !this.areas()[areaId].release){
					this.areas()[areaId].release = true;
			}
		};//*

		areaClose (areaId){
			if(areaId >= 0 && this.areas()[areaId].release){
					this.areas()[areaId].release = false;
			}
		};//*

		camp(areaId, campId){
			if(!areaId){
					return this.areas()[0];
			}else if(areaId > 0 && campId >= 0){
					return this.areas()[areaId].children[campId];	
			};//*
		};//*

		isAlwaysBase (){
			const base = this.camp();
			return base.alwaysBase;
		};//*

		mapId (areaId, campId){
			const camp = this.camp(areaId, campId);
			return camp.mapId;
		};//*

		name (areaId, campId){
			const id = $gameFastTravel.baseNameValue();
			const baseName = id > 0 ? $gameVariables.value(id) : this.camp().name;
			const areaCamp = this.camp(areaId, campId);

			return !areaId ? baseName : areaCamp.name;
		};//*

		baseNameValue (){
			return this.camp().nameValue;
		};//*

		open (areaId, campId, mapId, x, y){
			let camp = this.camp(areaId, campId);
				camp.release = true;
			if(mapId > 0 && !camp.mapId){
				camp.mapId = mapId;
				camp.x = x;
				camp.y = y + 1;
			}

			this.setMultiCampRelease(true, -1, areaId, campId);

			if(this.isTemporarySealed(areaId, campId)){
					this.releaseTemporary(areaId, campId);
			}
		};//*

		close (areaId, campId){
			let camp = this.camp(areaId, campId);
				camp.release = false;
			this.setMultiCampRelease(false, -1, areaId, campId);
		};//*

		getOpenedAreas (){
			return this.areas().filter((area, index) => {return this.isOpenedArea(index)});
		};//*

		getOpenedCamps (areaId){
			const camps = this.camps(areaId);
			return camps.filter((c, index) => {
				return c.release && this.isReleasedMultiCamp(this._partyId, areaId, index);
			});
		};//*

		isTemporarySealed (areaId, campId){
			return this.camp(areaId, campId).temporarySealed ||
					this.isTempSealedMultiCamp(this._partyId, areaId, campId);
		};//*

		sealTemporary (areaId, campId){
			const camp = this.camp(areaId, campId);
			camp.temporarySealed = true;
			this.setMultiCampTempSeal(true, -1, areaId, campId);
		};//*

		releaseTemporary (areaId, campId){
			const camp = this.camp(areaId, campId);
			camp.temporarySealed = false;
			this.setMultiCampTempSeal(false, -1, areaId, campId);
		};//*

		changeName (areaId, campId, name){
			const camp = this.camp(areaId, campId);
			camp.name = name;
		};//*

		changeImage(areaId, campId, name){
			const camp = this.camp(areaId, campId);
			camp.image = name;
		};//*

		//for editting name of base
		faceName(){
			return '';
		};//*

		faceIndex (){
			return 0;
		};//*

		maxLength (){
			return this._maxLength;
		};//*

		setMaxLength (value){
			if(value > 0){
				this._maxLength = value;
			}
		};//*

};//*Game_FastTravel fastTravel

	window[Game_FastTravel.name] = Game_FastTravel;

	//----------変数格納の拠点名を変更するシーンを定義--------------------//

class Scene_FastTravelBaseName extends Scene_Name {
		constructor (){
			super();
		};//*

		prepare () {
		    this._actorId = 0;
		    this._maxLength = $gameFastTravel.maxLength();
		};//*

		create () {
		    Scene_MenuBase.prototype.create.call(this);
		    this._actor = $gameFastTravel;
		    this.createEditWindow();
		    this.createInputWindow();
		};//*

		onInputOk () {
			const id = $gameFastTravel.baseNameValue();
			if(id <= 0) this.popScene;

		    $gameVariables.setValue(id, this._editWindow.name());
		    this.popScene();
		};//*
};//*Scene_FastTravelBaseName

	window[Scene_FastTravelBaseName.name] = Scene_FastTravelBaseName;

	//----------ファストトラベルのメニューウィンドウ作成を定義----------------//

Scene_Map.prototype.callFastTravel = function(){
	SceneManager.push(Scene_FastTravel);
	$gameTemp.clearDestination();
	this._mapNameWindow.hide();
	this._waitCount = 2;
};//*
if(!isFastTravelValid()) Scene_Map.prototype.callFastTravel = function(){};


class Scene_FastTravel extends Scene_Menu{
		constructor(){
			super();
		};//*

		start () {
			//for MZ
		    Scene_MenuBase.prototype.start.call(this);
		    	//this._statusWindow.refresh();
		};//*

		create (){
			if($gameFastTravel.background()){
					this.createBackground();	
			}
			this.createWindowLayer();
			if(MZ) this.createDummyWindows();
			
			this.createNameWindow();
			this.createAreaWindow();
			this.createRegionWindow();
			this.createImageWindow();
			this.createHelpWindow();
			this.createExecuteDialog();
			this.createExecuteWindow();
		};//*

		createBackground () {
			this._backgroundSprite = new Sprite();
		    this._backgroundSprite.bitmap = SceneManager.backgroundBitmap();
		    this.addChild(this._backgroundSprite);
		};//*

		createDummyWindows (){
			this._statusWindow = new Window_MenuStatus(0, 0);
				this._statusWindow.width = 0;
				this._statusWindow.height = 0;
			this._goldWindow = new Window_Gold(0, 0);
				this._goldWindow.width = 0;
				this._goldWindow.height = 0;
		};//*

		createNameWindow (){
			this._nameWindow = new Window_FastTravelName();
			this._nameWindow.reHeight();
			let text = $gameFastTravel.systemName();
			this._nameWindow.drawText(text, 0, 0, this._nameWindow.width, 'center');
			this.addWindow(this._nameWindow);
		};//*

		createAreaWindow (){
			this._areaWindow = new Window_FastTravelAreas(0, 0);
			this._areaWindow.width = Graphics.boxWidth;
			this._areaWindow.y = this._nameWindow.y + this._nameWindow.height;
			if(!this._areaWindow.height) this._areaWindow.height = this._areaWindow.windowHeight();
			this.addWindow(this._areaWindow);
			this._areaWindow.deactivate();
		};//*

		createRegionWindow (){
			this._regionWindow = new Window_FastTravelRegions(0, 0);
			this._regionWindow.width = Graphics.boxWidth / 3;
			this._regionWindow.y = this._areaWindow.y + this._areaWindow.height;
			this._regionWindow.height = Graphics.boxHeight - this._regionWindow.y;
			this._regionWindow._currentArea = null;
			this._regionWindow._isRegion = true;

			//this._regionWindow.setHandler('pagedown', this.onNextArea.bind(this));
			this._regionWindow.setHandler('right', this.onNextArea.bind(this));
			//this._regionWindow.setHandler('pageup', this.onPreviousArea.bind(this));
			this._regionWindow.setHandler('left', this.onPreviousArea.bind(this));
			this._regionWindow.setHandler('ok', this.onExecuteOk.bind(this));
			this._regionWindow.setHandler('cancel', this.popScene.bind(this));

			this.addWindow(this._regionWindow);
			this._regionWindow.activate();
			this._regionWindow.setAreaWindow(this._areaWindow);
			this._areaWindow.setRegionWindow(this._regionWindow);

			this._regionWindow.refresh();
			this._areaWindow.setArea(this._regionWindow._currentArea);
			this._areaWindow.refresh();	
		};//*

		createImageWindow (){
			this._imageWindow = new Window_FastTravelImage();
			this._imageWindow.reserveImages();
			let rWindow = this._regionWindow;
			this._imageWindow.x = rWindow.width;
			this._imageWindow.width = Graphics.boxWidth - this._imageWindow.x;
			this._imageWindow.y = rWindow.y;
			this._imageWindow.height = rWindow.height;
			this._currentImage = null;
								
			this.addWindow(this._imageWindow);
			this._imageWindow.setRegionWindow(this._regionWindow);
			this._imageWindow.setSprite();
		};//*

		createHelpWindow (){
			this._helpWindow = new Window_FastTravelHelp();
			let rWindow = this._regionWindow;
			this._helpWindow.x = rWindow.width;
			this._helpWindow.width = Graphics.boxWidth - this._helpWindow.x;
			this._helpWindow.height = rWindow.height / 3;
			this._helpWindow.y = (rWindow.y + rWindow.height) - this._helpWindow.height;

			this.addWindow(this._helpWindow);
			this._helpWindow.setRegionWindow(rWindow);
		};//*

		createExecuteDialog (){
			this._executeDialog = new Window_ExecuteFastTravelDialog();
			this._executeDialog.hide();
			this.addWindow(this._executeDialog);
			this._executeDialog.setRegionWindow(this._regionWindow);
		};//*

		createExecuteWindow (){
			this._executeWindow = new Window_ExecuteFastTravel();
			const width = (this._executeDialog.width - this._executeWindow.width)/2
			this._executeWindow.x = this._executeDialog.x + width;
			this._executeWindow.y = this._executeDialog.y + this._executeDialog.height;

			this._executeWindow.hide();
			this._executeWindow.deactivate();
			this._executeWindow.setHandler('ok', this.onFastTravelOk.bind(this));
			this._executeWindow.setHandler('cancel', this.onCancelOk.bind(this));
			this.addWindow(this._executeWindow);
			this._executeWindow.setRegionWindow(this._regionWindow);
		};//*

		/*シーンの挙動を設定*/	

		onNextArea (){
			const areas = this._areaWindow._list.length;
			const realIndex = (this._areaWindow.index() + 1) % areas;
			const commandName = this._areaWindow.commandName(realIndex);
			const areaIndex = $gameFastTravel.areas().findIndex(area => {return area.name === commandName});
			this._regionWindow._currentArea = areaIndex;
			this._areaWindow.setArea(this._regionWindow._currentArea);
			this._regionWindow.refresh();
		};//*

		onPreviousArea (){
			const areas = this._areaWindow._list.length;
			const realIndex = (this._areaWindow.index() + areas - 1) % areas;
			const commandName = this._areaWindow.commandName(realIndex);
			const areaIndex = $gameFastTravel.areas().findIndex(area => {return area.name === commandName});
			this._regionWindow._currentArea = areaIndex;
			this._areaWindow.setArea(this._regionWindow._currentArea);
			this._regionWindow.refresh();
		};//*

		onExecuteOk (){
			this._executeWindow.show();
			this._executeWindow.select(0);
			this._executeDialog.show();
			this._executeDialog.refresh();
			this._executeWindow.activate();
			this._regionWindow.deactivate();
		};//*
							
		onFastTravelOk (){
			this.popScene();
			this.decideCoordinate();
			if($gameFastTravel.commonEvent() > 0){
					$gameSystem.temporaryHideHUD();
					$gameMap._interpreter.terminate();
					$gameTemp.reserveCommonEvent($gameFastTravel.commonEvent());
			}
		};//*

		decideCoordinate (){
			const area = this._executeWindow.decideFastTravel();
			travel.mapId = area.mapId;
			travel.x = area.x;
			travel.y = area.y;
		};//*

		onCancelOk (){
			this._executeWindow.hide();
			this._executeDialog.hide();
			this._executeWindow.deactivate();
			this._regionWindow.activate();
		};//*	

};//*Scene_FastTravel

	window[Scene_FastTravel.name] = Scene_FastTravel;


	//--------リージョンウィンドウからトラベル先を取得するファンクション------------------//

Window_Base.prototype.decideFastTravel = function(){
	let areaId = this._regionWindow._currentArea;
	let index = this._regionWindow.index();
	let releasedCamps;
	if(areaId !== 0){
			releasedCamps = $gameFastTravel.getOpenedCamps(areaId);
			//const length = releasedCamps.length;
			if(this.isBottomBase(index)){
					areaId = 0;
					index = 0;
			}
	};
	const area = areaId === 0 ? $gameFastTravel.camp() : releasedCamps[index];
	return area;
};//*
if(!isFastTravelValid()) Window_Base.prototype.decideFastTravel = function(){return null};


Window_Base.prototype.isBottomBase = function(index){
	if(this._regionWindow){
			return this._regionWindow._currentArea !== 0 &&
					$gameFastTravel.isAlwaysBase() &&
					this._regionWindow.commandName(index) === $gameFastTravel.name();
	}else if(this._isRegion){ 
			//this is regionWindow
			return this._currentArea !== 0 &&
					$gameFastTravel.isAlwaysBase()  &&
					this.commandName(index) === $gameFastTravel.name();	
	}				
};//*
if(!isFastTravelValid()) Window_Base.prototype.isBottomBase = function(index){return false};


	//----------ネームウィンドウを定義---------------------//

class Window_FastTravelName extends Window_Base{
		constructor(){
			let x = 0;
			let y = 0;
			let width = Graphics.boxWidth;
			let height = Graphics.boxHeight;
			super(x, y, width, height);
		};//*

		standardFontSize (){
			const size = $gameFastTravel ? $gameFastTravel.fontSize() : 21;
			return Math.floor(size * 0.8) ;
		};//*

		lineHeight (){
			return Math.floor(this.standardFontSize() * 9 / 7);
		};//*

		reHeight (){
			this.height = this.lineHeight() + this.standardPadding() * 2;
		};//*

};//*Window_FastTravelName

	window[Window_FastTravelName.name] = Window_FastTravelName;

	//----------領土のウィンドウを定義------------//
class Window_FastTravelAreas extends Window_HorzCommand{
		constructor(x, y){
			super(x, y);
		};//*

		setRegionWindow (regionWindow){
			if(regionWindow){
					this._regionWindow = regionWindow;
			}
		};//*

		setArea (area){
			if(this._regionWindow && this._regionWindow._currentArea >= 0){
					//25.03.07追記、エリアID順に解禁しなかった場合への対応
					const areaName = $gameFastTravel.areas()[area].name;
					const realIndex = this._list.findIndex(command => {return command.name === areaName});
					this._currentArea = area;
					this.select(realIndex);
					this._regionWindow.select(0);
			}
		};//*

		standardFontSize (){
			const size = $gameFastTravel ? $gameFastTravel.fontSize() : 21;
			return Math.floor(size * 0.8);
		};//*

		maxCols (){
			return $gameFastTravel.getOpenedAreas().length ;
		};//*

		makeCommandList (){
			let area = $gameFastTravel.areas();
			for(var i = 0; i < area.length; i++){
				if($gameFastTravel.isOpenedArea(i)){
						this.addCommand(area[i].name, area[i].name);
				}
			}
		};//*					
};//*Window_FastTravelAreas

	window[Window_FastTravelAreas.name] = Window_FastTravelAreas;

	//-----------転送先のウィンドウを定義-------------//

class Window_FastTravelRegions extends Window_MenuCommand{
		constructor(x, y){
			super(x, y);
		};//*

		setAreaWindow (areaWindow){
			if(this._areaWindow){
					this._areaWindow = areaWindow;	
			}
		};//*

		standardFontSize (){
			return $gameFastTravel ? $gameFastTravel.fontSize() : 21;
		};//*

		makeCommandList (){
			if(this._currentArea === null || this._currentArea === undefined){
					this._currentArea = touchCampArea;
			};
			this.addRegionCommands();
			if($gameFastTravel.isAlwaysBase()){
					this.addBaseCommand();	
			}
		};//*

		addRegionCommands (){
			if(this._currentArea === 0){
					if(!$gameFastTravel.isAlwaysBase() ){
							this.addBaseCommand();
					}
			}else{
					let current = this._currentArea;
					for(var i =0; i < $gameFastTravel.camps(current).length; i++){
						if($gameFastTravel.isOpenedCamp(current, i)){
								let name = $gameFastTravel.name(current, i);
								let unabled = $gameFastTravel.isTemporarySealed(current, i);
								this.addCommand(name, name, !unabled);
						}
					};
			};
		};//*

		addBaseCommand (){
			let base = $gameFastTravel.camp();
			let id = $gameFastTravel.baseNameValue();
			if($gameFastTravel.isOpenedCamp()){
					let name = id ? $gameVariables.value(id) : $gameFastTravel.name();
					let unabled = $gameFastTravel.isTemporarySealed(0,0);
					this.addCommand(name, name, !unabled);
			}
		};//*

		drawItem (index) {
			var rect = MV ? this.itemRectForText(index) : this.itemLineRect(index);
		    var align = this.itemTextAlign();
		    this.resetTextColor();
		    this.changePaintOpacity(this.isCommandEnabled(index));
		    if(this.isBottomBase(index)){
		    		//拠点以外のエリアで拠点選択
					let y = MZ ? rect.y : this.height - (this.lineHeight()+this.standardPadding()*2);
					this.drawHorzLine(y);
			    	this.changePaintOpacity(this.isCommandEnabled(index)); //再設定しないとボトムに反映されなかった
			    	this.drawText(this.commandName(index), rect.x, y, rect.width, align);
		    }else{
			    	this.drawText(this.commandName(index), rect.x, rect.y, rect.width, align);	
		    } 
		};//*

		itemRect (index) {
			if(MV){
				return super.itemRect(index);
			}else if(MZ){
				const maxCols = this.maxCols();
			    const itemWidth = this.itemWidth();
			    const itemHeight = this.itemHeight();
			    const colSpacing = this.colSpacing();
			    const rowSpacing = this.rowSpacing();
			    const col = index % maxCols;
			    const row = Math.floor(index / maxCols);
			    const x = col * itemWidth + colSpacing / 2 - this.scrollBaseX();
				    const bottomBase = this.isBottomBase(index);
				    const defaultY = row * itemHeight + rowSpacing / 2 - this.scrollBaseY();
				    const bottomY = this.contentsHeight() - itemHeight * 2; 
				    //Selectable でinnerHeight + itemHeight()で上書きされているため余計に引いている
			    const y = !bottomBase ?  defaultY : bottomY;
			    const width = itemWidth - colSpacing;
			    const height = itemHeight - rowSpacing;
			    return new Rectangle(x, y, width, height);
			}
		};//*

		refresh () {
		    Window_Command.prototype.refresh.call(this);
		    this.activate();
		};//*

		updateCursor () {
		    if (this._cursorAll) {
			        var allRowsHeight = this.maxRows() * this.itemHeight();
			        this.setCursorRect(0, 0, this.contents.width, allRowsHeight);
			        this.setTopRow(0);
		    } else if (this.isCursorVisible()) {
				    var rect = this.itemRect(this.index());
		        	//拠点以外のエリアで拠点を選択した場合、カーソルを最下段に飛ばすよう調整
		        	if(this.isBottomBase(this.index())){
		        			//console.log(this.index());
			        		rect.y = this.height - (this.lineHeight()+this.standardPadding()*2);
			        		 this.setCursorRect(rect.x, rect.y, rect.width, rect.height);
		        	}else{
			       			 this.setCursorRect(rect.x, rect.y, rect.width, rect.height); 		
		        	};
		    } else {
			        this.setCursorRect(0, 0, 0, 0);
		    }
		};//*

		drawHorzLine (y) {
			const adjust = MV ? 1 : this.rowSpacing();
		    var lineY = y - adjust;
		    this.contents.paintOpacity = 48;
		    this.contents.fillRect(0, lineY, this.contentsWidth(), 2, this.lineColor());
		    this.contents.paintOpacity = 255;
		};//*

		lineColor () {
		    return this.normalColor();
		};//*

		//左右の挙動は追加設定が必要
		processHandling () {
			Window_MenuCommand.prototype.processHandling.apply(this, arguments);

			if (this.isOpenAndActive() && this.isRightEnabled()) {
					if (Input.isTriggered('right')) {
					        this.processRight();
					}
		    }
			if(this.isOpenAndActive() && this.isLeftEnabled()){
					if(Input.isTriggered('left')){
				    		this.processLeft();
			    	}
		    }
		};//*

		isRightEnabled () {
			return this.isHandled('right');
		};//*

		isLeftEnabled () {
		    return this.isHandled('left');
		};//*

		processRight () {
			this.playOkSound();
	        this.updateInputData();
	        //this.deactivate();
	        this.callRightHandler();
		};//*

		processLeft () {
	    	this.playOkSound();
	        this.updateInputData();
	        //this.deactivate();
	        this.callLeftHandler();
		};//*

		callRightHandler () {
		    this.callHandler('right');
		};//*

		callLeftHandler () {
		    this.callHandler('left');
		};//*

};//*Window_FastTravelRegions

	window[Window_FastTravelRegions.name] = Window_FastTravelRegions;

	//------------イメージウィンドウの定義---------------------------------//
class Window_FastTravelImage extends Window_Base{
		constructor(){
			super();
		};//*

		setRegionWindow (regionWindow){
			if(regionWindow){
					this._regionWindow = regionWindow;
			}
		};//*

		setSprite (){
			const area = this.decideFastTravel();
			const path = area ? area.image : '';
			const sprite = new Sprite();
			sprite.bitmap = ImageManager.loadBitmap('img/', path);
			this.addChild(sprite);
		};//*

		update (){
			const area = this.decideFastTravel();
			const path = area ? area.image : '';
			const start = this.children.length - 1;
			const sprite = this.children[start];
			if(path　&& path !== this._currentImage){
					const maxWidth = Math.floor(this.width * 0.8); 
					sprite.bitmap = ImageManager.loadBitmap('img/', path);
					sprite.scale.x = Math.floor(maxWidth / sprite.bitmap.width *100)/100;
					sprite.scale.y = sprite.scale.x;
					sprite.x = (this.width - maxWidth) / 2;
					sprite.y = this.lineHeight() / 2;
					this._currentImage = path;	
			}
		};//*

		reserveImages (){
			for(var i = 0; i < $gameFastTravel.areas().length; i++){
				if(i === 0){
						ImageManager.loadBitmap('img/', $gameFastTravel.camp().image);
				}else{
						$gameFastTravel.camps(i).map(c => ImageManager.loadBitmap('img/', c.image));	
				}
			}
		};//*

};//*Window_FastTravelImage

	window[Window_FastTravelImage.name] = Window_FastTravelImage;

	//-------------ヘルプウィンドウの定義---------------------------//
class Window_FastTravelHelp extends Window_Base{
		constructor(){
			let x = 0;
			let y = 0;
			let width = Graphics.boxWidth;
			let height = Graphics.boxHeight;	
			super(x, y, width, height);
			this._text;
		};//*

		standardFontSize (){
			const size = $gameFastTravel ? $gameFastTravel.fontSize() : 21;
			return Math.floor(size * 0.8);
		};//*

		lineHeight (){
			return Math.floor(this.standardFontSize() * 9 / 7) + 2;
		};//*

		setRegionWindow (regionWindow){
			if(regionWindow){
					this._regionWindow = regionWindow;	
			}
		};//*

		update (){
			const area = this.decideFastTravel();
			let memo = area ? area.memo : '';
			if(memo !== this._text){
					this._text = memo;
					if(this.contents){
							this.contents.clear();
					}
					let seal = area && area.temporarySealed ? 1 : 0;
					if(area && area.temporarySealed){
							this.changeTextColor(this.crisisColor());
							this.drawText($gameFastTravel.sealingMessage(), 0, 0, this.width);
							this.resetTextColor();
					};
								
					this.drawTextEx(memo, 0, seal * this.lineHeight());
			};
		};//*
};//*Window_FastTravelHelp

	window[Window_FastTravelHelp.name] = Window_FastTravelHelp;

	//------------実行ダイアログの定義---------------------//
class Window_ExecuteFastTravel extends Window_ExecuteCommand{
		constructor(){
			super();
		};//*

		setRegionWindow (regionWindow){
			if(regionWindow){
					this._regionWindow = regionWindow;
			}
		};//*
						
		makeCommandList (){
			this.addCommand($gameFastTravel.checkMessage(0), 'ok');
			this.addCommand($gameFastTravel.checkMessage(1), 'cancel');
		};//*

		drawItem (index) {
		    var rect = this.itemRectForText(index);
		    var align = this.itemTextAlign();
		    this.resetTextColor();
		    this.changePaintOpacity(this.isCommandEnabled(index));
		    this.drawText(this.commandName(index), rect.x, rect.y, rect.width, align);
		};//*
};//*Window_ExecuteFastTravel

	window[Window_ExecuteFastTravel.name] = Window_ExecuteFastTravel;

class Window_ExecuteFastTravelDialog extends Window_ExecuteDialog{
		constructor(){
			super();
		};//*

		setRegionWindow (regionWindow){
			if(regionWindow){
					this._regionWindow = regionWindow;
			}
		};//*

		refresh (){
			super.refresh();
			let text = $gameFastTravel.dialogMessage();
			if($gameFastTravel.isDestinationValid()){
					this.drawDestination(text);
			}else{
					this.drawText(text, 0, this.lineHeight(), this.width, 'center');
			}
		};//*

		drawDestination (text){
			const line = this.lineHeight();
			const name = this.decideFastTravel().name;
			if($gameSystem.isJapanese()){
					this.changeTextColor(this.crisisColor());
					this.drawText(name + ' へ', 0, line * 1, this.width, 'center');
					this.resetTextColor();
					this.drawText(text, 0, line * 2, this.width, 'center');
			}else{
					this.resetTextColor();
					this.drawText(text, 0, line * 1, this.width, 'center');
					this.changeTextColor(this.crisisColor());
					this.drawText('to ' + name + ' ?', 0, line * 2, this.width, 'center');
			}		
		};//*

		standardFontSize (){
			return $gameFastTravel ? $gameFastTravel.fontSize() : 21;
		};//*

};//*Window_ExecuteFastTravelDialog

	window[Window_ExecuteFastTravelDialog.name] = Window_ExecuteFastTravelDialog;

/*********************************************************************************************/
	/*-----------------ガイドのライブラリ化-------------------------------*/

		/*~struct~Guide:ja
			@param 	valid
			@type 		boolean
			@text 		ガイドの有効化
			@desc 		On（true）の時、ガイドに関する設定を有効にします。
			@default 	true

			@param 	name
			@type 		string
			@text 		システム名
			@desc 		メニューコマンドで表示されるガイドシステムの名前を設定します。
			@default 	クエスト一覧

			@param 	mainName
			@type 		string
			@text 		メインクエスト名
			@desc 		UIで表示されるメインクエストのシステム名を設定します。
			@default 	メインクエスト

			@param 	subName
			@type 		string
			@text 		サブクエスト名
			@desc 		UIで表示されるサブクエストのシステム名を設定します。
			@default 	サブクエスト

			@param 	mobName
			@type 		string
			@text 		モブクエスト名
			@desc 		UIで表示されるモブ討伐クエストのシステム名を設定します。
			@default 	討伐依頼

			@param 	current
			@type 		string
			@text 		現在の目標
			@desc 		ヘルプウィンドウに表示される現在目標の項目名を設定します。
			@default 	【現在の目標】

			@param 	clearText
			@type 		string
			@text 		クリアメッセージ
			@desc 		対象のクエストが完全にクリアされている場合に表示されるメッセージを設定します。
			@default 	All Clear!!

			@param 	iconId
			@type 		number
			@text 		クリアアイコン
			@desc 		クリア済のクエスト名に対し、付与するアイコンのIDを設定します。
			@default 	87
			@decimals 	0

			@param 	operateShift
			@type 		string[]
			@text 		シフト操作説明
			@desc 		シフトキーでの操作説明を設定します。１つ目が「未達成のみ表示」、２つ目が「全て表示」に関して表示します。
			@default 	["未達成のみ表示", "すべて表示"]

			@param 	operateCursor
			@type 		string[]
			@text 		左右操作説明
			@desc 		左右キーでの操作説明を設定します。１つ目がリスト切替、２つ目がページ切替に関して表示します。
			@default 	["リスト切替","ページ切替"]

			@param 	background
			@type 		boolean
			@text 		背景の透過設定
			@desc 		On（true）の時、メニューのように背景がぼやけます。Off（false）にすると真っ暗の背景になります。
			@default 	true

			@param 	listWidth
			@type 		number
			@text 		リスト幅（％）
			@desc 		クエスト名のリストウィンドウ幅を設定します。他のウィンドウ幅は連動して調整されます。
			@default 	40
			@decimals 	0
			@max 		100
		*/
		/*---------------------------------------------------------------------------------------------------*/
		/*~struct~Guide:
			@param 	valid
			@type 		boolean
			@text 		available guide system
			@desc 		Turn on the following settings when this is true
			@default 	true

			@param 	name
			@type 		string
			@text 		system name
			@desc 		Define the command name displayed in menu
			@default 	Quest List

			@param 	mainName
			@type 		string
			@text 		system name of main guide
			@desc 		Define the name displayed in guide scene
			@default 	Story

			@param 	subName
			@type 		string
			@text 		system name of sub guide
			@desc 		Define the name displayed in guide scene
			@default 	Sub Story

			@param 	mobName
			@type 		string
			@text 		system name of mob guide
			@desc 		Define the name displayed in guide scene
			@default 	Mob List

			@param 	current
			@type 		string
			@text 		system name of current phase
			@desc 		Define the name displayed in help window of guide scene
			@default 	【Current Phase】

			@param 	clearText
			@type 		string
			@text 		system name of clear
			@desc 		Define the name displayed when selecting quest is cleared
			@default 	All Clear!!

			@param 	iconId
			@type 		number
			@text 		icon of clear
			@desc 		Control iconId displayed when selecting quest is cleared
			@default 	87
			@decimals 	0

			@param 	operateShift
			@type 		string[]
			@text 		text of shift key
			@desc 		Define explanation of shift key; the former for only uncompleted, the later for all
			@default 	["show only uncompleted", "show all"]

			@param 	operateCursor
			@type 		string[]
			@text 		text of left and right key
			@desc 		Define explanation of left and right key about changing lists or pages
			@default 	["change List","change page"]

			@param 	background
			@type 		boolean
			@text 		opacity of background
			@desc 		When this is true, background is displayed blurry; otherwise black
			@default 	true

			@param 	listWidth
			@type 		number
			@text 		width of list（％）
			@desc 		Control width of the list window; the others work together
			@default 	40
			@decimals 	0
			@max 		100
		*/


		const parseGuide = s => JSON.parse(s, (key, value) =>{
			switch(key){
				case 'valid' 		: return value;
				case 'name' 		: return value;
				case 'mainName' 	: return value;
				case 'subName' 		: return value;
				case 'mobName' 		: return value;
				case 'current' 		: return value;
				case 'clearText' 	: return value;
				case 'iconId' 		: return Number.parseFloat(value);
				case 'operateShift' : return JSON.parse(value);
				case 'operateCursor': return JSON.parse(value);
				case 'background' 	: return value;
				case 'listWidth' 	: return Number.parseFloat(value);
				case 'popup' 		: return value;
				case 'popupSe' 		: return JSON.parse(value);
				default 			: return value;
			}
		});//*

				/*~struct~GuideItems:ja
					@param 	name
					@type 		string
					@text 		クエスト名
					@desc 		リストに表示されるクエストの名前を設定します。
					@default 	クエスト

					@param 	subChapters
					@type 		struct<GuideSubItems>[]
					@text 		クエスト副題
					@desc 		クエスト内容とヘルプウィンドウに表示される、進行中のクエスト名を設定します。
				*/
				/*---------------------------------------------------------------------------------*/
				/*~struct~GuideItems:
					@param 	name
					@type 		string
					@text 		name of this quest
					@desc 		Define the name displayed in quest's list
					@default 	Quest 1

					@param 	subChapters
					@type 		string[]
					@text 		subtitles of this quest
					@desc 		Define subtitles displayed in this quest's page and help window
				*/
			/*********************************************************************************************/
					/*~struct~GuideSubItems:ja
						@param 	subChapterName
						@type 	　　string
						@text 	　　サブチャプター名前
						@desc 		サブチャプターの名前を設定します。
						@default 	副題

						@param 	targets
						@type 		string[]
						@text 		サブチャプター目標
						@desc 		このサブチャプターで達成すべき項目を設定します。不要な場合は空欄で構いません。

						@param 	variables
						@type 		variable[]
						@text 		ターゲット変数
						@desc 		各ターゲットが参照する変数を設定します。不要な部分は設定なしで構いません。

						@param 	achievements
						@type 		number[]
						@text 		ターゲット達成値
						@desc 		各ターゲットで達成とみなす値を設定します。不要な部分は0で構いません。

						@param 	subContent
						@type 		note
						@text 		クエスト内容
						@desc 		このサブチャプターの詳細テキストを設定します。文字の装飾コードも使えます。
					*/
					/*---------------------------------------------------------*/
					/*~struct~GuideSubItems:
						@param 	subChapterName
						@type 	　　string
						@text 	　　subtitle
						@desc 		Write a subtitle
						@default 	sub title

						@param 	targets
						@type 		string[]
						@text 		target of this subtitle
						@desc 		Write what to do in this subtitle if you need

						@param 	variables
						@type 		variable[]
						@text 		variable for targets
						@desc 		Select a variable for each target if you need

						@param 	achievements
						@type 		number[]
						@text 		values to achieve
						@desc 		Control the values to judge targets achieved if you need

						@param 	subContent
						@type 		note
						@text 		texts for this subtitle
						@desc 		Write texts for this subtitle; you may use escape code like '\n[1]'
					*/

				const parseMSGuide = s => JSON.parse(s, (key, value) => {
					switch(key){
						case 'name' 		: return value;
						case 'subChapters' 	: return JSON.parse(value);
						//case 'subContents' 	: return JSON.parse(value);
						default 			: return value;
					}
				});//*

	const deepParseGuide = function(guide){
		guide = parseMSGuide(guide);
		guide = guide.map(g => {return JSON.parse(g)});
		guide = guide.map(g => {
							g.subChapters = g.subChapters ? JSON.parse(g.subChapters) : [];
							g.subChapters = g.subChapters.map(sg => {
								sg = sg ? JSON.parse(sg) : {};
								sg.targets = sg.targets ? JSON.parse(sg.targets) : [];
								sg.variables = sg.variables ? JSON.parse(sg.variables) : [];
								sg.variables = sg.variables.map(num => {return Number(num) || 0;})
								sg.achievements = sg.achievements ? JSON.parse(sg.achievements) : [];
								sg.achievements = sg.achievements.map(ac =>{return Number(ac) || 0;});
								sg.subContent = sg.subContent ? JSON.parse(sg.subContent) : '';
								sg.achieved = sg.variables.map(v => {return false});
								return sg;
							})
							return g;
						});
		return guide;
	};//*

	const emptyGuide = {"name":'', "subChapters":[], "subContents":''};

	let guide = params.guide;
	let consolerNameGuide = 'guide:';
	if(guide){
			guide = parseGuide(params.guide);
			guide = stringToBoolean(guide);	
	}else{
			guide = makeNotValid();
			undefinedStructs.push(consolerNameGuide);
			consolerNameGuide += makeInvalidTerm();
	};
	//------------------------------------------------//
	let mainGuide = params.mainGuide;
	let consolerNameMainGuide = 'MainGuide:';
	if(mainGuide){
			mainGuide = deepParseGuide(mainGuide);
	}else{
			mainGuide = [emptyGuide];
			undefinedStructs.push(consolerNameMainGuide);
			consolerNameMainGuide += makeInvalidTerm();
	};
	//------------------------------------------------//		
	let subGuide = params.subGuide;
	let consolerNameSubGuide = 'SubGuide:';
	if(subGuide){
			subGuide = deepParseGuide(subGuide);
	}else{
			subGuide = [emptyGuide];
			undefinedStructs.push(consolerNameSubGuide);
			consolerNameSubGuide += makeInvalidTerm();
	};
	//------------------------------------------------//		
	let mobGuide = params.mobGuide;
	let consolerNameMobGuide = 'MobGuide:';
	if(mobGuide){
			mobGuide = deepParseGuide(mobGuide);
	}else{
			mobGuide = [emptyGuide];
			undefinedStructs.push(consolerNameMobGuide);
			consolerNameMobGuide += makeInvalidTerm();
	};
	//------------------------------------------------//		
	consoler(consolerNameGuide, guide);
	consoler(consolerNameMainGuide, mainGuide);
	consoler(consolerNameSubGuide, subGuide);
	consoler(consolerNameMobGuide, mobGuide);

				/*~struct~GuideConfig:ja
						@param 	valid
						@type 		boolean
						@text 		ポップアップ有効化
						@desc 		On（true）の時、以下の設定が適用されます。
						@default 	true

						@param 	name
						@type 		string
						@text 		ポップアップ
						@desc 		クエストが更新された際に表示するメッセージを設定します。
						@default 	クエストが更新されました

						@param 	popupSe
						@type 		struct<GuidePopupSe>
						@text 		ポップアップSE
						@desc 		ポップアップ表示時に演奏するSEを設定します。

						@param 	display
						@type 		select
						@text 		表示方法
						@desc 		ガイドポップアップの表示方法を設定します。
						@default 	open-close
							@option 	展開・収束
							@value 	open-close

							@option 	スライド
							@value 	slide

						@param 	width
						@type 		number
						@text 		ウィンドウ幅（px）
						@desc 		ガイドポップアップの幅を設定します。100~400pxで設定できます。
						@default 	200
						@min 		100
						@max 		400
						@decimals 	0

						@param 	height
						@type 		number
						@text 		ウィンドウ高さ（px）
						@desc 		ガイドポップアップの高さを設定します。50~200pxで設定できます。
						@default 	80
						@min 		50
						@max 		200
						@decimals 	0

						@param 	position
						@type 		select
						@text 		ウィンドウ位置
						@desc 		ガイドポップアップを表示する場所を設定します。
						@default 	right
							@option 	右上
							@value 	right

							@option 	左上
							@value 	left

							@option 	上真ん中
							@value 	above

							@option 	画面中央
							@value 	center

						@param 	fontSize
						@type 		number
						@text 		文字サイズ（px）
						@desc 		ガイドポップアップのメッセージの文字サイズを設定します。
						@default 	18
						@min 		12
						@decimals 	0

						@param 	waitFrame
						@type 		number
						@text 		表示時間（フレーム）
						@desc 		ポップアップを表示する時間を設定します。
						@default 	60
						@min 		1
						@decimals 	0

						@param 	openSpeed
						@type 		number
						@text 		展開速度
						@desc 		ポップアップの展開速度を設定します。初期値は32で、大きいほど早くなります。
						@default 	32
						@min 		1
						@max 		255
						@decimals 	0

						@param 	closeSpeed
						@type 		number
						@text 		収束速度
						@desc 		ポップアップの収束速度を設定します。初期値は32で、大きいほど早くなります。
						@default 	32
						@min 		1
						@max 		255
						@decimals 	0
					*/
					/*----------------------------------------------------------------------------------*/
					/*~struct~GuideConfig:
						@param 	valid
						@type 		boolean
						@text 		available popup
						@desc 		Turn on the following settings when this is true
						@default 	true

						@param 	name
						@type 		string
						@text 		popup message
						@desc 		Define message when quests are updated
						@default 	Update Quest

						@param 	popupSe
						@type 		struct<GuidePopupSe>
						@text 		popup SE
						@desc 		Construct popup SE played when quests are updated

						@param 	display
						@type 		select
						@text 		type of displaying popup
						@desc 		Select a type of displaying
						@default 	open-close
							@option 	Open and Close
							@value 	open-close

							@option 	Slide in and out
							@value 	slide

						@param 	width
						@type 		number
						@text 		width of popup window（px）
						@desc 		Control the width between 100 and 400
						@default 	200
						@min 		100
						@max 		400
						@decimals 	0

						@param 	height
						@type 		number
						@text 		height of popup window（px）
						@desc 		Control the height between 50 and 200
						@default 	80
						@min 		50
						@max 		200
						@decimals 	0

						@param 	position
						@type 		select
						@text 		position of popup window
						@desc 		Select the position
						@default 	right
							@option 	upper right
							@value 	right

							@option 	upper left
							@value 	left

							@option 	upper center
							@value 	above

							@option 	center
							@value 	center

						@param 	fontSize
						@type 		number
						@text 		font size（px）
						@desc 		Control font size of popup window
						@default 	18
						@min 		12
						@decimals 	0

						@param 	waitFrame
						@type 		number
						@text 		duration of displaying popup window（frames）
						@desc 		Control the duration
						@default 	60
						@min 		1
						@decimals 	0

						@param 	openSpeed
						@type 		number
						@text 		speed to open or slide in
						@desc 		Control the speed; initial value is 32, and bigger makes speed faster
						@default 	32
						@min 		1
						@max 		255
						@decimals 	0

						@param 	closeSpeed
						@type 		number
						@text 		speed to close or slide out
						@desc 		Control the speed; initial value is 32, and bigger makes speed faster
						@default 	32
						@min 		1
						@max 		255
						@decimals 	0
					*/
		/*********************************************************************************************/
						/*~struct~GuidePopupSe:ja
								@param 	name
								@type 		file
								@text 		ポップアップSE
								@desc 		ポップアップ表示時に演奏するSEを設定します。
								@dir 		audio/se
								@require 1

								@param 	volume
								@type 		number
								@text 		SE音量
								@desc 		ポップアップのSEボリュームを設定します。
								@default 	70
								@decimals 	0
								@max 		100

								@param 	pitch
								@type 		number
								@text 		SE高さ
								@desc 		ポップアップのSEピッチを設定します。
								@default 	100
								@decimals 	0

								@param 	pan
								@type 		number
								@text 		SE位相
								@desc 		ポップアップのSEパンを設定します。
								@default 	0
								@decimals 	0
								@max 		100
								@min 		-100
						*/
						/*----------------------------------------------------------------------*/
						/*~struct~GuidePopupSe:
								@param 	name
								@type 		file
								@text 		popup SE
								@desc 		Select a popup SE played when popup is opened
								@dir 		audio/se
								@require 1

								@param 	volume
								@type 		number
								@text 		SE volume
								@desc 		Control the volume
								@default 	70
								@decimals 	0
								@max 		100

								@param 	pitch
								@type 		number
								@text 		SE pitch
								@desc 		Control the pitch
								@default 	100
								@decimals 	0

								@param 	pan
								@type 		number
								@text 		SE pan
								@desc 		Control the pan
								@default 	0
								@decimals 	0
								@max 		100
								@min 		-100
						*/

					const parseGuideConfig = s => JSON.parse(s, (key, value) => {
							switch(key){
								case 'valid' 			: return value;
								case 'name' 			: return value;
								case 'popupSe' 			: return value ? JSON.parse(value) : emptySE;
								case 'display' 			: return value;
 								case 'width' 			: return Number.parseFloat(value);
								case 'height' 			: return Number.parseFloat(value);
								case 'position' 		: return value;
								case 'fontSize' 		: return Number.parseFloat(value);
								case 'waitFrame' 		: return Number.parseFloat(value);
								case 'openSpeed' 		: return Number.parseFloat(value);
								case 'closeSpeed' 		: return Number.parseFloat(value);
								default 				: return value;
							}
						});//*

		let guideConfig = params.guideConfig;
		let consolerNameGuideConfig = 'guideConfig:';
		if(guideConfig){
				guideConfig = parseGuideConfig(guideConfig);
				guideConfig.popupSe = stringToNumber(guideConfig.popupSe);
				guideConfig = stringToBoolean(guideConfig);	
		}else{
				guideConfig = makeNotValid();
				undefinedStructs.push(consolerNameGuideConfig);
				consolerNameGuideConfig += makeInvalidTerm();
		};

		consoler(consolerNameGuideConfig, guideConfig);

			/*~struct~GuideHUD:ja
				@param 	valid
				@type 		boolean
				@text 		ガイドHUD有効化
				@desc　		On（true）の時、現在のガイドが画面上にも表示されるようになります
				@default 	false

				@param 	fontSize
				@type 		number
				@text 		文字サイズ
				@desc 		ガイドHUDに表示される文字のサイズを設定します。
				@default 	21
				@decimals 	0
				@min 		12
				@max 		36

				@param 	xPosition
				@type 		select
				@text 		ガイドHUD配置場所
				@desc 		ガイドHUDを画面のどこに配置するか設定します。ｙ軸は画面上で固定です。
				@default 	right
					@option 右
					@value 	right
					
					@option 中央
					@value 	center

					@option 左
					@value 	left
			*/
			/*----------------------------------------------------------------------*/
			/*~struct~GuideHUD:
				@param 	valid
				@type 		boolean
				@text 		enable Guide HUD
				@desc　		Display Guide HUD on screen when this is true
				@default 	false

				@param 	fontSize
				@type 		number
				@text 		font size
				@desc 		Control the font size for Guide HUD
				@default 	21
				@decimals 	0
				@min 		12
				@max 		36

				@param 	xPosition
				@type 		select
				@text 		position of Guide HUD
				@desc 		Select where Guide HUD is displayed; along y axis, HUD is fixed in upper screen
				@default 	right
					@option Right
					@value 	right
					
					@option Center
					@value 	center

					@option Left
					@value 	left
			*/

			const parseGuideHUD = s => JSON.parse(s, (key, value) => {
							switch(key){
								case 'valid' 			: return value;
								case 'fontSize' 		: return Number(value);
								case 'xPosition' 		: return value;
								default 				: return value;
							}
						});//*

		let guideHUD = params.guideHUD;
		let consolerNameGuideHUD = 'guideHUD:';
		if(guideHUD){
				guideHUD = parseGuideConfig(guideHUD);
				guideHUD = stringToBoolean(guideHUD);	
		}else{
				guideHUD = makeNotValid();
				undefinedStructs.push(consolerNameGuideHUD);
				consolerNameGuideHUD += makeInvalidTerm();
		};

		consoler(consolerNameGuideHUD, guideHUD);

if(fieldValid && guide.valid && guideHUD.valid){
	const _Scene_Map_prototype_updateMain = Scene_Map.prototype.updateMain;	
	Scene_Map.prototype.updateMain = function() {
	    _Scene_Map_prototype_updateMain.apply(this, arguments);
	    $gameGuide.addDisplayGuide();
	};//*
}

class Game_Guide {
		constructor(){
			this._main = mainGuide;
			this._sub = subGuide;
			this._mob = mobGuide;
			this._mainPhase = this._main.map(m => {return -1});
			this._subPhase = this._sub.map(s => {return -1});
			this._mobPhase = this._mob.map(s => {return -1});
			this._currentMainId = -1;
			this._currentSubId = -1;
			this._currentMobId = -1;
			this.clearCurrentGuide();
			this.createDisplayGuide();
		};//*

		clearCurrentGuide(){
			this._currentGuide = '';
		};//*

		createDisplayGuide (){
			const sprite = new Sprite();
			sprite.bitmap = new Bitmap(Graphics.boxWidth, Graphics.boxHeight);
			sprite.width = Graphics.boxWidth;
			sprite.height = Graphics.boxHeight;
			sprite.displayGuide = true;
			sprite.skipEncoder = true;
			this._currentGuideSprite = sprite;
		};//*

		updateParam(){
			this._main = mainGuide;
			this._sub = subGuide;
			this._mob = mobGuide;
 			this._mainPhase = this._main.map((m, index) => {return this._mainPhase[index] >= 0 ? this._mainPhase[index] : -1});
			this._subPhase = this._sub.map((s, index) => {return this._subPhase[index] >= 0 ? this._subPhase[index] : -1});
			this._mobPhase = this._mob.map((s, index) => {return this._mobPhase[index] >= 0 ? this._mobPhase[index] : -1});
		};//*

		name (){
			return guide.name;
		};//*

		mainSystemName (){
			return guide.mainName;
		};//*

		subSystemName (){
			return guide.subName;
		};//*

		mobSystemName (){
			return guide.mobName;
		};//*

		currentSystemName (){
			return guide.current;
		};//*

		clearSystemName (){
			return guide.clearText;
		};//*

		iconIndex (){
			return guide.iconId;
		};//*

		operateShift (id){
			return guide.operateShift[id];
		};//*

		operateCursor (id){
			return guide.operateCursor[id];
		};//*

		background (){
			return guide.background;
		};//*

		listWidth (){
			return guide.listWidth / 100;
		};//*

		popup (){
			return guideConfig.name || '';
		};//*

		//------------------------------------------
		filterMain (){
			let quests = this._main.filter((quest, index) => {return this._mainPhase[index] >= 0});
			if(!quests) quests.push(emptyGuide);
			return quests;
		};//*

		filterMainNotComp (){
			let quests = this.filterMain();
				quests = quests.filter(quest => {return !this.isCompleteQuestMain(quest)});
			return quests;
		};//*

		filterSub (){
			let quests = this._sub.filter((quest, index) => {return this._subPhase[index] >= 0});
			if(!quests) quests.push(emptyGuide);
			return quests;
		};//*

		filterSubNotComp (){
			let quests = this.filterSub();
				quests = quests.filter(quest => {return !this.isCompleteQuestSub(quest)});
			return quests;
		};//*

		filterMob (){
			let quests = this._mob.filter((quest, index) => {return this._mobPhase[index] >= 0});
			if(!quests) quests.push(emptyGuide);
			return quests;
		};//*

		filterMobNotComp (){
			let quests = this.filterMob();
				quests = quests.filter(quest => {return !this.isCompleteQuestMob(quest)});
			return quests;
		};//*

		//------------------------------------------
		startMain (id){
			if(this._mainPhase[id] < 0) this._mainPhase[id] = 0;
		};//*

		hasStartedMain(id, unchangedId){
			//スクリプトとしてユーザーが呼び出すのが主
			if(unchangedId) id --;
			return this._mainPhase[id] >= 0;
		};//*

		getMainPhase (quest){
			const id = this._main.indexOf(quest);
			return this._mainPhase[id];
		};//*

		gainMain (id){
			this._mainPhase[id] ++;
			this._mainPhase[id] = this.clampMain(id);
			if(guideConfig.valid){
					const name = this._main[id].name;
					this.callGuideWindow(name);
			}
		};//*

		clampMain (id){
			return this._mainPhase[id].clamp(0, this._main[id].subChapters.length - 1);
		};//*

		isCompleteMain (id, unchangedId){
			if(id < 0){return false};
			if(unchangedId) id --;
			return this._mainPhase[id] === this._main[id].subChapters.length - 1;
		};//*

		isCompleteQuestMain (quest){
			const id = this._main.indexOf(quest);
			return this.isCompleteMain(id);
		};//*

		getMainSubChapter (quest){
			const phase = this.getMainPhase(quest);
			return quest.subChapters[phase];
		};//*

		isCompleteSubChapterMain (id){
			//変数達成条件を持つサブチャプターの自動更新判定ファンクション
			const sc = this.getMainSubChapter(this._main[id]);
			const achieved = sc.achieved;
			if(achieved.length === 0) return;

			const variables = sc.variables;
			const achievements = sc.achievements;
			variables.forEach((vid,index) => {
				let value = $gameVariables.value(vid);
				if(value >= achievements[index] && !achieved[index]) achieved[index] = true;
			})

			return achieved.every(ele => {return ele});
		};//*

		autoGainMain (id){
			if(this.isCompleteSubChapterMain(id)) this.gainMain(id);
		};//*

		//------------------------------------------
		startSub (id){
			this._subPhase[id] = 0;
		};//*

		hasStartedSub(id, unchangedId){
			//スクリプトとしてユーザーが呼び出すのが主
			if(unchangedId) id --;
			return this._subPhase[id] >= 0;
		};//*

		getSubPhase (quest){
			const id = this._sub.indexOf(quest);
			return this._subPhase[id];
		};//*

		gainSub (id){
			this._subPhase[id] ++;
			this._subPhase[id] = this.clampSub(id);
			if(guideConfig.valid){
					const name = this._sub[id].name;
					this.callGuideWindow(name);
			}
		};//*

		clampSub (id){
			return this._subPhase[id].clamp(0, this._sub[id].subChapters.length - 1);
		};//*

		isCompleteSub (id, unchangedId){
			if(id < 0){return false};
			if(unchangedId) id --;
			return this._subPhase[id] === this._sub[id].subChapters.length - 1;
		};//*

		isCompleteQuestSub (quest){
			const id = this._sub.indexOf(quest);
			return this.isCompleteSub(id);
		};//*

		getSubSubChapter (quest){
			const phase = this.getSubPhase(quest);
			return quest.subChapters[phase];
		};//*

		isCompleteSubChapterSub (id){
			//変数達成条件を持つサブチャプターの自動更新判定ファンクション
			const sc = this.getSubSubChapter(this._sub[id]);
			const achieved = sc.achieved;
			if(achieved.length === 0) return;

			const variables = sc.variables;
			const achievements = sc.achievements;
			variables.forEach((vid,index) => {
				let value = $gameVariables.value(vid);
				if(value >= achievements[index] && !achieved[index]) achieved[index] = true;
			})

			return achieved.every(ele => {return ele});
		};//*

		autoGainSub (id){
			if(this.isCompleteSubChapterSub(id)) this.gainSub(id);
		};//*

		//------------------------------------------
		startMob (id){
			this._mobPhase[id] = 0;
		};//*

		hasStartedMob(id, unchangedId){
			//スクリプトとしてユーザーが呼び出すのが主
			if(unchangedId) id --;
			return this._mobPhase[id] >= 0;
		};//*

		getMobPhase (quest){
			const id = this._mob.indexOf(quest);
			return this._mobPhase[id];
		};//*

		gainMob (id){
			this._mobPhase[id] ++;
			this._mobPhase[id] = this.clampMob(id);
			if(guideConfig.valid){
					const name = this._mob[id].name;
					this.callGuideWindow(name);
			}
		};//*

		clampMob (id){
			return this._mobPhase[id].clamp(0, this._mob[id].subChapters.length - 1);
		};//*

		isCompleteMob (id, unchangedId){
			if(id < 0){return false};
			if(unchangedId) id --;
			return this._mobPhase[id] === this._mob[id].subChapters.length - 1;
		};//*

		isCompleteQuestMob (quest){
			const id = this._mob.indexOf(quest);
			return this.isCompleteMob(id);
		};//*

		getMobSubChapter (quest){
			const phase = this.getMobPhase(quest);
			return quest.subChapters[phase];
		};//*

		isCompleteSubChapterMob (id){
			//変数達成条件を持つサブチャプターの自動更新判定ファンクション
			const sc = this.getMobSubChapter(this._mob[id]);
			const achieved = sc.achieved;
			if(achieved.length === 0) return false;

			const variables = sc.variables;
			const achievements = sc.achievements;
			variables.forEach((vid,index) => {
				let value = $gameVariables.value(vid);
				if(value >= achievements[index] && !achieved[index]) achieved[index] = true;
			})

			return achieved.every(ele => {return ele});
		};//*

		autoGainMob (id){
			if(this.isCompleteSubChapterMob(id)) this.gainMob(id);
		};//*

		//------------------------------------------
		//for guide popup
		callGuideWindow (name){
			this.callSe();
			let guideWindow = new Window_Guide();
				guideWindow.initMembers();
				guideWindow.addScene();
				guideWindow.drawGuide(name);
				guideWindow.appear();
		};//*

		callSe (){
			AudioManager.playSe(guideConfig.popupSe);
		};//*

		//for guideHUD
		addDisplayGuide(){
			if(!guideHUD.valid) return;

			const sceneHasGuide = SceneManager._scene.children.findIndex(c => {return c.displayGuide});
			if(sceneHasGuide < 0) {
				this.createDisplayGuide();
				SceneManager._scene.addChild(this._currentGuideSprite);
				switch(this._currentGuide){
					case 'main' : this.displayMainGuide();
					case 'sub' 	: this.displaySubGuide();
					case 'mob' 	: this.displayMobGuide();
				}
			}else{
				if($gameMap.needsHideHUD() && this.guideHUDVisible()) this.hideGuideHUD();
				if(!$gameMap.needsHideHUD() && !this.guideHUDVisible())this.showGuideHUD();
			}
		};//*

		clearDisplayGuide(){
			if(this._currentGuide) this.clearCurrentGuide();
			this._currentGuideSprite.bitmap.clear();
		};//*

		guideHUDVisible (){
			return this._currentGuideSprite.visible;
		};//*

		hideGuideHUD (){
			this._currentGuideSprite.visible = false;
		};//*

		showGuideHUD (){
			this._currentGuideSprite.visible = true;
		};//*

		positionGuideHUD (width){
			switch(guideHUD.xPosition){
				case 'right' 	: return Graphics.boxWidth - width; 	break;
				case 'center' 	: return (Graphics.boxWidth - width)/2; break;
				case 'left' 	: return 0; break;
				default 		: return Graphics.boxWidth - width;
			}
		};//*

		drawBackGround (x, y, width, height){
			const color1 = this.dimColor1();
			const color2 = this.dimColor2();
			const bitmap = this._currentGuideSprite.bitmap;
			switch(guideHUD.xPosition){
				case 'right' :
					bitmap.gradientFillRect(x, y, width, height, color2, color1);
				break;
				case 'center' :
					bitmap.gradientFillRect(x, y, width / 2, height, color2, color1);
					bitmap.gradientFillRect(x + width / 2, y, width / 2, height, color1, color2);
				break;
				case 'left' :
					bitmap.gradientFillRect(x, y, width, height, color1, color2);
				break;
			}
    		//
		};//*

		dimColor1 (){
			return MV ? Window_Base.prototype.dimColor1.call(this) : ColorManager.dimColor1();
		};//*

		dimColor2 (){
			return MV ? Window_Base.prototype.dimColor2.call(this) : ColorManager.dimColor2();
		};//*

		drawGuideHUD (quest, phase){
			if(!guideHUD.valid) return;

			const bitmap = this._currentGuideSprite.bitmap;
			bitmap.fontSize = guideHUD.fontSize;
			const name = quest.name;
			const subChName = quest.subChapters[phase].subChapterName;
			const width = (name.length + subChName.length + 3) * bitmap.fontSize;
			const height = bitmap.fontSize + 10;
			const x = this.positionGuideHUD(width);
			bitmap.clear();
			this.drawBackGround(x, 0, width, height);
			bitmap.drawText(`${name} / ${subChName}`, x, 0, width, height, guideHUD.xPosition);
		}

		drawTargets (subChapter){
			if(!guideHUD.valid) return;

			const bitmap = this._currentGuideSprite.bitmap;
			let y = bitmap.fontSize + 10;
			bitmap.fontSize = guideHUD.fontSize * 0.8;
			const lineHeight = bitmap.fontSize + 6;
			const targets = subChapter.targets;
			const variables = subChapter.variables;
			const achievements = subChapter.achievements;
			for(var i = 0; i < targets.length; i++){
				let text = targets[i];
				let variable = variables[i] ? $gameVariables.value(variables[i]) : 0;
				let achievement = achievements[i] ? achievements[i] : 0;
				if(achievement) text += `( ${variable} / ${achievement} )`;

				let width = text.length * bitmap.fontSize;
				let x = this.positionGuideHUD(width);
				let y2 = y + lineHeight * i;

				this.drawBackGround(x, y2, width, lineHeight);
				if(achievement && variable >= achievement) bitmap.textColor = 'grey';
				bitmap.drawText(text, x, y2, width, lineHeight, guideHUD.xPosition);
				bitmap.textColor = 'white';
			}
		};//*

		drawAddGuideHUD (){}//*user defines;

		displayMainGuide(){
			if(this._currentMainId < 0) return;
			const quest = this._main[this._currentMainId];
			const phase = this._mainPhase[this._currentMainId];
			const subChapter = this.getMainSubChapter(quest);
			this.drawGuideHUD(quest, phase);
			this.drawTargets(subChapter);
			this.drawAddGuideHUD();		
		};//*

		updateDisplayMainGuide(id){
			if(id >= 0) this._currentMainId = id;
			this._currentGuide = 'main';
		};//*

		displaySubGuide(){
			if(this._currentSubId < 0) return;
			const quest = this._sub[this._currentSubId];
			const phase = this._subPhase[this._currentSubId];
			const subChapter = this.getSubSubChapter(quest);
			this.drawGuideHUD(quest, phase);
			this.drawTargets(subChapter);
			this.drawAddGuideHUD();		
		};//*

		updateDisplaySubGuide(id){
			if(id >= 0) this._currentSubId = id;
			this._currentGuide = 'sub';
		};//*

		displayMobGuide(){
			if(this._currentMobId < 0) return;
			const quest = this._mob[this._currentMobId];
			const phase = this._mobPhase[this._currentMobId];
			const subChapter = this.getMobSubChapter(quest);
			this.drawGuideHUD(quest, phase);
			this.drawTargets(subChapter);
			this.drawAddGuideHUD();		
		};//*

		updateDisplayMobGuide(id){
			if(id >= 0) this._currentMobId = id;
			this._currentGuide = 'mob';
		};//*

};//*Game_Guide

	window[Game_Guide.name] = Game_Guide;

class Window_Guide extends Window_Trophy {
		constructor(){
			super();
			const width = guideConfig.width;
			const height = guideConfig.height;
			const y = guideConfig.position !== 'center' ? 0 : Math.floor((Graphics.boxHeight - height)/2);
			let x = Graphics.boxWidth - width;
			switch(guideConfig.position){
				case 'left' 	: x = 0; break;
				case 'above' 	:
				case 'center' 	: x = Math.floor(x / 2); break;
				case 'right' 	: x = x; break;
			}
			this.width = width;
			this.height = height;
			this.y = y;
			this.x = x;
		};//*

		initMembers (){
			this._openness = 0;
			this._waitCount = 0;
			if(guideConfig.display === 'slide'){
					this._goalX = this.x;
					switch(guideConfig.position){
						case 'left' : this.x -= this.width; break;
						case 'right' : this.x += this.width; break;
					}
					this._startX = this.x;
			}
		};//*

		setWait (){
			this._waitCount = guideConfig.waitFrame;
		};//*

		drawGuide (name){
			this.resetTextColor();
			this.drawText($gameGuide.popup(), 0, 0, this.contentsWidth(), 'center');
			this.changeTextColor(this.crisisColor());
			this.drawText(name, 0 , this.lineHeight(), this.contentsWidth(), 'center');
		};//*

		standardFontSize (){
			return guideConfig.fontSize;
		};//*

		notMove (){
			return guideConfig.position === 'above' || guideConfig.position === 'center';
		};//*

		isOpen () {
			if(guideConfig.display === 'open-close' || this.notMove()){
					return this._openness >= 255;
			}else{
					return this.x === this._goalX;
			}
		};//*

		executeOpen (){
			if(guideConfig.display === 'open-close' || this.notMove()){
					this.openness += guideConfig.openSpeed;
			}else{
					this._openness = 255;
					let x = this.x;
					switch(guideConfig.position){
						case 'left' :
								x += guideConfig.openSpeed; 
								x = Math.min(x, this._goalX);
						break;
							
						case 'right' :
								x -= guideConfig.openSpeed;
								x = Math.max(x, this._goalX);
						break;
					};
					this.move(x, this.y, this.width, this.height);
			};

			if (this.isOpen()) {
					this._opening = false;
					this.setWait();
			}
		};//*

		isClosed () {
			if(guideConfig.display === 'open-close' || this.notMove()){
					return this._openness <= 0;
			}else{
					return this.x === this._startX;
			}
		};//*

		updateClose () {
		    if (this._closing) {
			       this.executeClose();
		    }
		};//*

		executeClose (){
			if(guideConfig.display === 'open-close' || this.notMove()){
					this.openness -= guideConfig.closeSpeed;
			}else{
					let x = this.x;
					switch(guideConfig.position){
						case 'left' :
								x -= guideConfig.openSpeed; 
								x = Math.max(x, this._startX);
						break;

						case 'right' :
								x += guideConfig.openSpeed;
								x = Math.min(x, this._startX);
						break;
					};
					this.move(x, this.y, this.width, this.height);
			};

			if (this.isClosed()) {
					this._closing = false;
			}
		};//*

};//*Window_Guide

	window[Window_Guide.name] = Window_Guide;

	/*----------------------------------------------------*/
if(fieldValid && guide.valid){
		const _DataManager_createGameObjects = DataManager.createGameObjects;
		DataManager.createGameObjects = function() {
			_DataManager_createGameObjects.apply(this, arguments);
					    
		    $gameGuide = new Game_Guide();
		};//*

		const _DataManager_makeSaveContents = DataManager.makeSaveContents;
		DataManager.makeSaveContents = function(){
			var contents = _DataManager_makeSaveContents.call(this);
			$gameGuide.updateParam();
				contents.gameGuide = $gameGuide;
			return contents;
		};//*

		const _DataManager_extractSaveContents = DataManager.extractSaveContents;
		DataManager.extractSaveContents = function(contents){
			_DataManager_extractSaveContents.call(this, contents);
			$gameGuide = contents.gameGuide;
		};//*
};////


if(fieldValid && guide.valid){
		const _Scene_Menu_prototype_createCommandWindow = Scene_Menu.prototype.createCommandWindow;
		Scene_Menu.prototype.createCommandWindow = function() {
			_Scene_Menu_prototype_createCommandWindow.apply(this, arguments);
		    this._commandWindow.setHandler('guide', this.commandGuide.bind(this));
		};//*

		Scene_Menu.prototype.commandGuide = function(){
			SceneManager.push(Scene_Guide);
		};//*

		const _Window_MenuCommand_prototype_addOriginalCommands = Window_MenuCommand.prototype.addOriginalCommands;
		Window_MenuCommand.prototype.addOriginalCommands = function() {
			const enabled = true;
			this.addCommand($gameGuide.name(), 'guide', enabled);
			_Window_MenuCommand_prototype_addOriginalCommands.apply(this, arguments);
		};//*
};//*guide.valid for Scene end

//ガイドシーンで使うカテゴリーリスト
let MainSub = ['main'];
if(guide.subName){
		MainSub.push('sub');
		if(guide.mobName){
				MainSub.push('mob');
		};
};

class Scene_Guide extends Scene_FastTravel {
		constructor(){
			super();
			this._tempShow = false; //for tutorialbook temp show
		};//*

		create (){
			if($gameGuide.background()){
					this.createBackground();	
			}
			this.createWindowLayer();
						
			this.createAreaWindow();
			this.createRegionWindow();
			this.createImageWindow();
			this.createHelpWindow();
			this.createOperatorWindow();
		};//*

		createAreaWindow (){
			this._areaWindow = new Window_GuideAreas(0, 0);
			this._areaWindow.width = Graphics.boxWidth;
			this._areaWindow.y = 0;
			if(!this._areaWindow.height) this._areaWindow.height = this._areaWindow.windowHeight();
			this.addWindow(this._areaWindow);
			this._areaWindow.deactivate();
		};//*

		createRegionWindow (){
			this._regionWindow = new Window_GuideRegions(0, 0);
			const width = Math.floor(Graphics.boxWidth * $gameGuide.listWidth());
			const y = this._areaWindow.y + this._areaWindow.height;
			const height = Graphics.boxHeight - y;
			this._regionWindow.width = width;
			this._regionWindow.y = y;
			this._regionWindow.height = height;
			this._regionWindow._isRegion = true;

			//this._regionWindow.setHandler('pagedown', 	this.onNextArea.bind(this));
			this._regionWindow.setHandler('right', 		this.onNextArea.bind(this));
			//this._regionWindow.setHandler('pageup', 	this.onPreviousArea.bind(this));
			this._regionWindow.setHandler('left', 		this.onPreviousArea.bind(this));
			this._regionWindow.setHandler('ok', 		this.onExecuteOk.bind(this));
			this._regionWindow.setHandler('cancel', 	this.popScene.bind(this));
			this._regionWindow.setHandler('shift', 		this.changeMode.bind(this));

			this.addWindow(this._regionWindow);
			this._regionWindow.activate();
			this._regionWindow.setAreaWindow(this._areaWindow);
			this._areaWindow.setRegionWindow(this._regionWindow);

			this._regionWindow.refresh();
			this._areaWindow.setArea(this._regionWindow._currentArea);
			this._areaWindow.refresh();	
		};//*

		createImageWindow (){
			let rWindow = this._regionWindow;
			this._imageWindow = new Window_GuideImage(0, 0);
			this._imageWindow.x = rWindow.width;
			this._imageWindow.y = rWindow.y;
			this._imageWindow.width = Graphics.boxWidth - this._imageWindow.x;
			this._imageWindow.height = Math.floor(rWindow.height * 3 / 4);
			this._currentImage = null;
			this._imageWindow.setHandler('cancel', 	this.onCancelOk.bind(this));
								
			this.addWindow(this._imageWindow);
			this._imageWindow.setRegionWindow(this._regionWindow);
			this._imageWindow.setTempShow(this._tempShow);
			this._imageWindow.refresh();
			this._imageWindow.deactivate();
			this._imageWindow.deselect();
		};//*

		createHelpWindow (){
			this._helpWindow = new Window_GuideHelp();
			let rWindow = this._regionWindow;
			this._helpWindow.x = rWindow.width;
			this._helpWindow.width = Graphics.boxWidth - this._helpWindow.x;
			this._helpWindow.y = this._imageWindow.y + this._imageWindow.height;
			this._helpWindow.height = Graphics.boxHeight - this._helpWindow.y - this._helpWindow.lineHeight() * 1.5;

			this.addWindow(this._helpWindow);
			this._helpWindow.setRegionWindow(rWindow);
		};//*

		createOperatorWindow (){
			this._operatorWindow = new Window_GuideOperator();
			let hWindow = this._helpWindow;
			this._operatorWindow.x = hWindow.x;
			this._operatorWindow.width = hWindow.width;
			this._operatorWindow.height = hWindow.lineHeight() * 1.5;
			this._operatorWindow.y = Graphics.boxHeight - this._operatorWindow.height;
			this._operatorWindow.setBackgroundType(1);
			
			this.addWindow(this._operatorWindow);
			this._operatorWindow.setRegionWindow(this._regionWindow);
			this._operatorWindow.drawOperator();
		};//*

		/*シーンの挙動を設定*/

		onNextArea (){
			let areas = MainSub.length;
			this._regionWindow._currentArea ++;
			this._regionWindow._currentArea %= areas;
			this._areaWindow.setArea(this._regionWindow._currentArea);
			this._regionWindow.refresh();
			this._imageWindow.resetPage();
			this._imageWindow.refresh();
		};//*

		onPreviousArea (){
			let areas = MainSub.length;
			this._regionWindow._currentArea += areas;
			this._regionWindow._currentArea --;
			this._regionWindow._currentArea %= areas;
			this._areaWindow.setArea(this._regionWindow._currentArea);
			this._regionWindow.refresh();
			this._imageWindow.resetPage();
			this._imageWindow.refresh();
		};//*

		onExecuteOk (){
			this._imageWindow.activate();
			this._imageWindow.select(0);
			this._regionWindow.deactivate();
			this._operatorWindow.refresh();
		};//*

		onCancelOk (){
			this._regionWindow.activate();
			this._regionWindow.selectLast();
			this._imageWindow.deactivate();
			this._imageWindow.deselect();
			this._operatorWindow.refresh();
		};//*

		changeMode (){
			const mode = this._regionWindow._mode;
			switch(mode){
				case 'all' 		: this._regionWindow.setMode('filter'); break;
				case 'filter' 	: this._regionWindow.setMode('all'); break;
			};
			this._imageWindow.setRegionIndex();
			this._imageWindow.refresh();
			this._operatorWindow.refresh();
		};//*

};//*Scene_Guide

	window[Scene_Guide.name] = Scene_Guide;

	/*-------------------------------------------*/
				
class Window_GuideAreas extends Window_FastTravelAreas {
		constructor(x, y){
			super(x, y);
		};//*

		maxCols (){
			return MainSub.length;
		};//*

		makeCommandList (){
			const main = $gameGuide.mainSystemName();
			const sub = $gameGuide.subSystemName();
			const mob = $gameGuide.mobSystemName();
			let command = [];
				command.push(main);
			if(sub){
					command.push(sub);

					if(mob){
						command.push(mob);
					};
			};

			for(var i = 0; i < this.maxCols(); i++){
				this.addCommand(command[i], command[i]);	
			}
			if(this._list.length === 0){
					const emptyCommand = {"name":'', "subChapters":[], "subContents":''};
					this.addCommand(emptyCommand, emptyCommand);
			}
		};//*

		setArea (area){
			if(this._regionWindow && this._regionWindow._currentArea >= 0){
					this._currentArea = area;
					this.select(this._currentArea);
					this._regionWindow.select(0);
			}
		};//*
};//*Window_GuideAreas

	window[Window_GuideAreas.name] = Window_GuideAreas;

	/*-------------------------------------------*/
class Window_GuideRegions extends Window_FastTravelRegions {
		constructor(x, y){
			super(x, y);
			this._currentArea = 0;
			this._index = 0;
			this._mode = 'all';
		};//*

		setMode (mode){
			this._mode = mode;
			this.refresh();
			this.select(0);
		};//*

		isFilter (){
			return this._mode === 'filter';
		};//*

		getQuests (){
			let quests;
			if(this._currentArea === 0){
					quests = !this.isFilter() ? $gameGuide.filterMain() : $gameGuide.filterMainNotComp();
			}else if(this._currentArea === 1){
					quests = !this.isFilter() ? $gameGuide.filterSub() : $gameGuide.filterSubNotComp();	
			}else if(this._currentArea === 2){
					quests = !this.isFilter() ? $gameGuide.filterMob() : $gameGuide.filterMobNotComp();
			}
			return quests;
		};//*

		makeCommandList (){
			if(this._currentArea === 0){
					this.addMainCommands();
			}else if(this._currentArea === 1){
					this.addSubCommands();
			}else if(this._currentArea === 2){
					this.addMobCommands();
			}
		};//*

		addMainCommands (){
			const quests = this.getQuests();
			for(var i =0; i < quests.length; i++){
				let name = quests[i].name;
				let enabled = true;
				this.addCommand(name, name, enabled);
			};
		};//*

		addSubCommands (){
			const quests = this.getQuests();
			for(var i =0; i < quests.length; i++){
				let name = quests[i].name;
				let enabled = true;
				this.addCommand(name, name, enabled);
			};
		};//*

		addMobCommands (){
			const quests = this.getQuests();
			for(var i =0; i < quests.length; i++){
				let name = quests[i].name;
				let enabled = true;
				this.addCommand(name, name, enabled);
			};
		};//*

		drawItem (index) {
			var rect = this.itemRectForText(index);
		    var align = this.itemTextAlign();
		    this.resetTextColor();
		    this.checkComp(index, rect);
		   	this.drawText(this.commandName(index), rect.x + 32, rect.y, rect.width, align);	 
		};//*

		checkComp (index, rect){
			const area = this._currentArea;
			const quest = this.getQuests()[index];
			let comp;
			if(area === 0){
					comp = $gameGuide.isCompleteQuestMain(quest);
			}else if(area === 1){
					comp = $gameGuide.isCompleteQuestSub(quest);
			}else if(area === 2){
					comp = $gameGuide.isCompleteQuestMob(quest);
			}

			if(comp){
					this.drawIcon($gameGuide.iconIndex(), rect.x, rect.y);
			}
		};//*

		updateCursor (){
			Window_MenuCommand.prototype.updateCursor.call(this);
		};//*

		isBottomBase (){
			//ファストトラベル用の判定ファンクションなので、ここでは常に不要
			return false;
		};//*
};//*Window_GuideRegions

	window[Window_GuideRegions.name] = Window_GuideRegions;

	/*-------------------------------------------*/
class Window_GuideImage extends Window_HorzCommand {
		constructor(x, y){
			super(x, y);
			this._page = 0;
			this._regionIndex = 0;
			this._tempShow = false;
		};//*

		isHorizontal () {
		    return true;
		};

		windowWidth (){
			return Graphics.boxWidth;
		};//*

		windowHeight (){
			return Graphics.boxHeight;
		};//*

		standardFontSize (){
			return 18;
		};//*

		resetFontSettings(){
			if(MZ){
				//MZではフォントサイズを固定値28で戻してしまう
				return;
			}else if(MV){
				//super.resetFontSettings();
				this.contents.fontFace = this.standardFontFace();
    			this.contents.fontSize = this.standardFontSize();
			}
		};//*

		processNewLine (textState) {
			this.resetTextColor();
		    super.processNewLine(textState);
		};//*

		commandName (index) {
			if(this._list[index]){
					 return this._list[index].name;	
			}else{
					return '';
			}
		};//*

		update (){
			super.update();
			if(this._regionIndex !== this._regionWindow.index()){
					this.setRegionIndex();
					this.refresh();
			}
		};//*

		setRegionWindow (regionWindow){
			if(regionWindow){
					this._regionWindow = regionWindow;
			}
		};//*

		setRegionIndex (){
			if(this._regionWindow){
					this._regionIndex = this._regionWindow.index();
					this._page = 0;
			}
		};//*

		setTempShow (temp){
			this._tempShow = temp;
		};//*

		isTempShow (){
			return this._tempShow;
		};//*

		maxCols (){
			return this.getPhase() + 1 || 1;
		};//*

		resetPage (){
			this._page = 0;
		};//*

		getQuest (){
			const area = this._regionWindow ? this._regionWindow._currentArea : 0;
			const modeF = this._regionWindow.isFilter();
			const index = this._regionWindow ? this._regionWindow.index() : 0;
			let quests;
			let quest;
			if(area === 0){
					quests = !modeF ? $gameGuide.filterMain() : $gameGuide.filterMainNotComp();
					quest = quests[index];
			}else if(area === 1){
					quests = !modeF ? $gameGuide.filterSub() : $gameGuide.filterSubNotComp();
					quest = quests[index];
			}else if(area === 2){
					quests = !modeF ? $gameGuide.filterMob() : $gameGuide.filterMobNotComp();
					quest = quests[index];
			}
			return quest;
		};//*

		getPhase (){
			if(this._regionWindow){
					const area = this._regionWindow._currentArea;
					const index = this._regionWindow.index();
					const quest = this.getQuest();
					let phase;
					if(area === 0){
							phase = $gameGuide.getMainPhase(quest);
					}else if(area === 1){
							phase = $gameGuide.getSubPhase(quest);
					}else if(area === 2){
							phase = $gameGuide.getMobPhase(quest);
					}

					return phase;
			}else{
					return 0;
			}
		};//*

		getCommandTexts (quest, phase){
			let texts = [];
			for(var i = 0; i <= phase; i++){
				let subChapter = quest.subChapters[i];
				let scName = subChapter.subChapterName;
				let scContent = subChapter.subContent;
				let text = `【${scName}】`;
				//checkTargets
				let targets = subChapter.targets;
				let variables = subChapter.variables;
				let achievements = subChapter.achievements;
				for(var j = 0; j < targets.length; j++){
					text += `\n　　　${targets[j]}`;
					if(achievements[j]) {
						let value = $gameVariables.value(variables[j]);
						text += `( ${value} / ${achievements[j]} )`; 
					}
				};//for j end

				texts.push(`${text}\n\n${scContent}` );
			};//for i end
			return texts;
		};//*

		makeCommandList (){
			if(this._regionWindow){
					const quest = this.getQuest();
					const phase = this.getPhase();
					const texts = this.getCommandTexts(quest, phase);
					for(var i = 0; i <= phase; i++){
						if(i !== quest.subChapters.length){
								this.addCommand(texts[i], 'text');
						}
					};	
			}
		};//*

		updateArrows () {
			const check = this.getPhase() > 0;
			this.downArrowVisible = check;
		    this.upArrowVisible = check;
		};//*

		drawAllItems () {
			this.drawItem(this._page);
		};//*

		drawItem (index) {
			var rect = this.itemRectForTextEx(index);
			this.changeTextColor(this.systemColor());
			this.drawTextEx(this.commandName(index), rect.x, rect.y);
			this.drawPageIndex();
		};//*

		drawPageIndex (){
			if(this._list){
					const y = this.contentsHeight() - this.lineHeight();
					const text = `- ${this._page + 1} / ${this.maxCols()} -`;
					this.resetTextColor();
					this.drawText(text, 0, y, this.contentsWidth(), 'center');	
			}
		};//*

		itemRectForTextEx (index){
			var rect = this.itemRectEx(index);
			    rect.x += this.textPadding();
			    rect.width -= this.textPadding() * 2;
		    return rect;
		};//*

		itemRectEx (index) {
		    var rect = new Rectangle();
		    var maxCols = 1;
			    rect.width = this.itemWidthEx();
			    rect.height = this.itemHeightEx(this.commandName(index));
			    rect.x = index % maxCols * (rect.width + this.spacing()) - this._scrollX;
			    rect.y = this.standardPadding();
		    return rect;
		};//*

		itemWidthEx () {
		    return this.contentsWidth();
		};//*

		itemHeightEx (subContents) {
			const lines = subContents.split('\n').length;
		    return this.lineHeight() * lines;
		};//*

		updateCursor () {
		    if (this._cursorAll) {
			        var allRowsHeight = this.maxRows() * this.itemHeight();
			        this.setCursorRect(0, 0, this.contents.width, allRowsHeight);
			        this.setTopRow(0);
		    } else if (this.isCursorVisible()) {
				    var rect = this.itemRectEx(this.index());
			        this.setCursorRect(rect.x, rect.y, rect.width, rect.height);
		    } else {
			        this.setCursorRect(0, 0, 0, 0);
			}
		};//*

		//for MZ, function's name differs
		refreshCursor (){
			this.updateCursor();
		};//*


		cursorRight (wrap) {
		    super.cursorRight(wrap);

		    if(this.isTempShow() && this._page === this.maxCols() - 1){
		    	this.callDialog();
		    	return;
		    }

		    this._page ++;
		    this._page %= this.maxCols();
		    this.refresh();
		};//*

		cursorDown (wrap) {
		    this.cursorRight(wrap);
		};//*

		cursorPagedown () {
			const wrap = true;
		    this.cursorRight(wrap);
		};//*

		cursorLeft (wrap) {
		    super.cursorLeft(wrap);

			if(this.isTempShow() && this._page === 0) return;

		    this._page += this.maxCols() - 1;
		    this._page %= this.maxCols();
		    this.refresh();
		};//*

		cursorUp (wrap) {
		    this.cursorLeft(wrap);
		};//*

		cursorPageup () {
			const wrap = true
			this.cursorLeft(wrap);
		};//*

		callDialog (){
			//for tutorialbook
			const scene = SceneManager._scene;
			const executeDialog = scene._executeDialog;
			const executeWindow = scene._executeWindow;
			if(executeDialog && executeWindow){
				scene.callDialog();
			};
		};//*
};//*Window_GuideImage

	window[Window_GuideImage.name] = Window_GuideImage;

	/*-------------------------------------------*/
class Window_GuideHelp extends Window_FastTravelHelp {
		constructor(x, y){
			super(x, y);
		};//*

		standardFontSize (){
			return 21;
		};//*

		getQuests (){
			const area = this._regionWindow._currentArea;
			const modeF = this._regionWindow.isFilter();
			let quests;
			if(area === 0){
					quests = !modeF ? $gameGuide.filterMain() : $gameGuide.filterMainNotComp();
			}else if(area === 1){
					quests = !modeF ? $gameGuide.filterSub() : $gameGuide.filterSubNotComp();
			}else if(area === 2){
					quests = !modeF ? $gameGuide.filterMob() : $gameGuide.filterMobNotComp();
			}
			return quests;
		};//*

		getPhase (area, quest){
			if(area === 0){
					return $gameGuide.getMainPhase(quest);
			}else if(area === 1){
					return $gameGuide.getSubPhase(quest);
			}else if(area === 2){
					return $gameGuide.getMobPhase(quest);
			}
		};//*

		getComp (area, quest){
			if(area === 0){
					return $gameGuide.isCompleteQuestMain(quest);
			}else if(area === 1){
					return $gameGuide.isCompleteQuestSub(quest);
			}else if(area === 2){
					return $gameGuide.isCompleteQuestMob(quest);
			}
		};//*

		update (){
			const area = this._regionWindow._currentArea;
			const index = this._regionWindow.index();
			const quest = this.getQuests()[index];
			const phase = this.getPhase(area, quest);
			const comp = this.getComp(area, quest);
						
			if(quest && this._text !== quest.subChapters[phase]){
					this._text = quest.subChapters[phase].subChapterName;
					if(this.contents){
							this.contents.clear();
							this.changeTextColor(this.systemColor());
							this.drawText($gameGuide.currentSystemName(), 0, 0, this.width);
					}
					const x = this.standardFontSize();
					const y = this.lineHeight();		
					if(comp){
							this.changeTextColor(this.crisisColor());
							this.drawText($gameGuide.clearSystemName(), 0, y, this.contentsWidth(), 'center');
					}else if(quest && quest.subChapters[phase]){
							this.resetTextColor();
							this.drawText(quest.subChapters[phase].subChapterName, 0, y, this.contentsWidth(), 'center');
					}
			}else if(!quest){
					if(this.contents){
							this._text = '';
							this.contents.clear();
							//this.changeTextColor(this.systemColor());
							//this.drawText($gameGuide.currentSystemName(), 0, 0, this.width);
					}
			};
		};//*
};//*Window_GuideHelp

	window[Window_GuideHelp.name] = Window_GuideHelp;

	/*------------------------------------------*/
class Window_GuideOperator extends Window_OperatorBase{
		constructor(){
			let width = Graphics.boxWidth;
			let height = Graphics.boxHeight;
			super(0, 0, width, height);
		};//*

		standardPadding (){
			return 6;
		};//*

		contentsHeight (){
			return this.height;
		};//*

		setRegionWindow (regionWindow){
			if(regionWindow){
					this._regionWindow = regionWindow;
			}
		};//*

		refresh (){
			if(this.contents){
					this.contents.clear();
					this.drawOperator();
			}
		};//*

		drawOperator (){
			if(this._regionWindow && this._regionWindow.active){
					const modeF 	= this._regionWindow.isFilter();
					const keyShift 	= keyName(keyOfShift) + ' : ';
					const id 		= !modeF ? 0 : 1;
					const shift 	= $gameGuide.operateShift(id);
					const keyLr 	= keyName(keyOfArrowLR) + ' : ';
					const lr 		= $gameGuide.operateCursor(0);
					const text = keyShift + shift + '　　　' + keyLr + lr;
					this.drawText(text, 0, 0, this.contentsWidth(), 'right');
			}else{
					const keyLr 	= keyName(keyOfArrowLR) + ' : ';
					const lr 		= $gameGuide.operateCursor(1);
					const text = keyLr + lr;
					this.drawText(text, 0, 0, this.contentsWidth(), 'right');
			}
		};//*
};//*Window_GuideOperator

	window[Window_GuideOperator.name] = Window_GuideOperator;


/*********************************************************************************************/
	/*-----------------戦闘BGMのライブラリ化-------------------------*/

				/*~struct~BattleBgms:ja
					@param 	battlePatern
					@type 		select
					@text 		戦闘の種類
					@desc 		この項のBGMを流す戦闘を選択します。BGMリストの作成に必要です。
							@option 	通常戦
							@value 	normal

							@option 	ボス戦
							@value 	boss

							@option 	イベント戦（ラスボス含む）
							@value 	event
					@default 	normal

					@param 	condition
					@type 		switch
					@text 		条件判定に使うスイッチ
					@desc 		指定したスイッチがOnの時、この項のBGMを以降の戦闘BGMとします。

					@param 	mapOverride
					@type 		boolean
					@text 		マップでも使用
					@desc 		On（true）にすると、条件のスイッチがOnになるだけでマップ上でもこの項のBGMが流れるようになります。
					@default 	false

					@param 	autoOff
					@type 		boolean
					@text 		自動Off設定
					@desc 		On（true）にすると、この項のBGMが設定された後に条件判定のスイッチをOffにします。
					@default 	false

					@param 	name
					@type 		file
					@text 		使用楽曲
					@desc 		この項で使いたい戦闘BGMを設定します。
					@dir 		audio/bgm
					@require 1

					@param 	volume
					@type 		number
					@text 		音量
					@desc 		この項で使うBGMのボリュームを設定します。
					@default 	90
					@max 		100
					@decimals 	0

					@param 	pitch
					@type 		number
					@text 		ピッチ
					@desc 		この項で使うBGMの音程・速度を設定します。
					@default 	100
					@decimals 	0

					@param 	pan
					@type 		number
					@text 		位相
					@desc 		この項で使うBGMの位相を設定します。
					@default 	0
					@max 		100
					@min 		-100
					@decimals 	0

					@param 	track
					@type 		number
					@text 		ジュークボックスID
					@desc 		ジュークボックスでのトラックNoを設定します。マップBGMと共有されます。0にするとリストから除外されます。
					@default 	0
					@decimals 	0

					@param 	title
					@type 		string
					@text 		曲名
					@desc 		ジュークボックスで表示する曲名を設定します。
					@default 	トラック

					@param 	creator
					@type 		string
					@text 		作曲者名
					@desc 		ジュークボックスで表示する作曲者名を設定します。

					@param 	creatorMemo
					@type 		note
					@text 		作曲者コメント
					@desc 		ジュークボックスで表示する作曲者コメントを設定します。不要な場合は空欄にして下さい。

					@param 	comment
					@type 		string
					@text 		一言メモ
					@desc 		BGMの用途などのメモにお使い下さい。なお、半角数字を使うと不具合の恐れがあります。
				*/
				/*------------------------------------------------------------------------------------------*/
				/*~struct~BattleBgms:
					@param 	battlePatern
					@type 		select
					@text 		type of battle
					@desc 		Select a type for making BGM lists
							@option 	normal battle
							@value 	normal

							@option 	boss battle
							@value 	boss

							@option 	event battle (including last battle)
							@value 	event
					@default 	normal

					@param 	condition
					@type 		switch
					@text 		condition game_switch
					@desc 		Set up this BGM when this switch turns on

					@param 	mapOverride
					@type 		boolean
					@text 		override map BGM
					@desc 		Override map BGM by this BGM, when both this and "condition" are true
					@default 	false

					@param 	autoOff
					@type 		boolean
					@text 		auto off
					@desc 		"condition" turns off by itself when this is true
					@default 	false

					@param 	name
					@type 		file
					@text 		BGM
					@desc 		Select this BGM
					@dir 		audio/bgm
					@require 1

					@param 	volume
					@type 		number
					@text 		volume of this BGM
					@desc 		Contorl the volume
					@default 	90
					@max 		100
					@decimals 	0

					@param 	pitch
					@type 		number
					@text 		pitch of this BGM
					@desc 		Control the pitch
					@default 	100
					@decimals 	0

					@param 	pan
					@type 		number
					@text 		pan of this BGM
					@desc 		Control the pitch
					@default 	0
					@max 		100
					@min 		-100
					@decimals 	0

					@param 	track
					@type 		number
					@text 		track of SoundTest
					@desc 		Control the track which is shared with map BGM; when 0, this is excepted from SoundTest
					@default 	0
					@decimals 	0

					@param 	title
					@type 		string
					@text 		title of BGM
					@desc 		Define the title displayed in SoundTest
					@default 	Track 1

					@param 	creator
					@type 		string
					@text 		creator's name
					@desc 		Define the name displayed in SoundTest

					@param 	creatorMemo
					@type 		note
					@text 		creator's comment
					@desc 		Write the comment displayed in SoundTest if you need

					@param 	comment
					@type 		string
					@text 		reminder
					@desc 		Write usage of this BGM
				*/

		let battleBgms = params.battleBgms;
		let consolerNameBattleBgms = 'battleBGMs:';
		if(battleBgms){
				battleBgms = JSON.parse(battleBgms);
				battleBgms = battleBgms.map(element => JSON.parse(element));
				battleBgms = battleBgms.map(element => stringToNumber(element));
				battleBgms = battleBgms.map(element => {
								element = stringToBoolean(element);
								return element;
							});
		}else{
				battleBgms = [emptyBgm];
				undefinedStructs.push(consolerNameBattleBgms);
				consolerNameBattleBgms += makeInvalidTerm();
		};

		consoler(consolerNameBattleBgms, battleBgms);

		let normalBattleBgms = battleBgms.filter((element) => {return element.battlePatern === 'normal'});
		let bossBattleBgms 	= battleBgms.filter((element) => {return element.battlePatern ===  'boss'});
		let eventBattleBgms = battleBgms.filter((element) => {return element.battlePatern ===  'event'});

	//オーバーライダーを抽出
	const bgmOverrider = battleBgms.filter((element) => {return element.mapOverride});
	let bgmOverriderBase = [];
	for(var i = 0; i < bgmOverrider.length; i++){
		bgmOverriderBase.push(bgmOverrider[i].condition);
	};

//BattleManagerでこのファンクションが呼び出されるので、ここで全戦闘曲を管理可能
if(fieldValid){
	const _Game_System_prototype_battleBgm = Game_System.prototype.battleBgm;
	Game_System.prototype.battleBgm = function() {
		let bgm = false;

		if(this.enableSetBattleBgms('event')){
			   	bgm = this.setEventBattleBgm();
	    }
		if(this.enableSetBattleBgms('boss') && !bgm){
		    	bgm = this.setBossBattleBgm();
	 	}
	    if(this.enableSetBattleBgms('normal') && !bgm){
		    	bgm = this.setNormalBattleBgm();
	    };
	    if(!bgm){
	   			//default
		  	  	bgm = this._battleBgm || $dataSystem.battleBgm;
		  	  	//bgm = $dataSystem.battleBgm;
	  	}

		if(jukeboxCondition && bgm.track){
			$gameJukebox.open(bgm.track);
		}
	   	this._battleBgm = bgm;
		return this._battleBgm;
	};//*
}////

Game_System.prototype.enableSetBattleBgms = function(type){
	switch(type){
		case 'event' 	: return eventBattleBgms.length > 0; break;
		case 'boss'		: return bossBattleBgms.length > 0; break;
		case 'normal'	: return normalBattleBgms.length > 0;break;
		default 		: return false;
	}
};//*
if(!fieldValid) Game_System.prototype.enableSetBattleBgms = function(type){return false};


Game_System.prototype.setEventBattleBgm = function(){
	const bgmOk = eventBattleBgms.filter((element) => {return $gameSwitches.value(element.condition)===true});
	const index = bgmOk.length;
	if(index === 0){
			return false;
	}else{
			let bgm = bgmOk[index - 1];
			return bgm;
	}
};//*
if(!fieldValid) Game_System.prototype.setEventBattleBgm = function(){return false};


Game_System.prototype.setBossBattleBgm = function(){
	const bgmOk = bossBattleBgms.filter((element) => {return $gameSwitches.value(element.condition)===true});
	const index = bgmOk.length;
	if(index === 0){
			return false;
	}else{
			let bgm = bgmOk[index - 1];
			return bgm;
	}
};//*
if(!fieldValid) Game_System.prototype.setBossBattleBgm = function(){return false};


Game_System.prototype.setNormalBattleBgm = function(){
	const bgmOk = normalBattleBgms.filter((element) => {return $gameSwitches.value(element.condition)===true});
	const index = bgmOk.length;
	if(index === 0){
			return false;
	}else{
			let bgm = bgmOk[index - 1];
			return bgm;
	}
};//*
if(!fieldValid) Game_System.prototype.setNormalBattleBgm = function(){return false};


if(fieldValid){
	const _Game_System_prototype_onBattleStart = Game_System.prototype.onBattleStart;
	Game_System.prototype.onBattleStart = function() {
		_Game_System_prototype_onBattleStart.apply(this, arguments);

		if(fieldValid && this._battleBgm.autoOff){
			   	$gameSwitches.setValue(this._battleBgm.condition, false);
	    }
	};//*
}////

if(fieldValid && bgmOverriderBase.length > 0){
		//マップBGMのオーバーライド機能
		const _Game_Switches_prototype_setValue = Game_Switches.prototype.setValue;
		Game_Switches.prototype.setValue = function(switchId, value) {
			_Game_Switches_prototype_setValue.apply(this, arguments);
			this.autoPlayBgm(switchId, value);
		};//*

		Game_Switches.prototype.autoPlayBgm = function(switchId, value){
			if(bgmOverriderBase.contains(switchId) && value){
					const id = bgmOverriderBase.findIndex(id => id === switchId);
			    	const bgm = bgmOverrider[id];
			    	AudioManager.playBgm(bgm);
			    	this.onChange();
			    	if(jukeboxCondition && bgm.track){
							$gameJukebox.open(bgm.track);
					}
		    };
		};//*
};//*bgmOverriderBase.length > 0 condition end

	/*-----------------マップBGMのライブラリ化-----------------------------*/

				/*~struct~MapBgms:ja
					@param 	name
					@type 		file
					@text 		使用楽曲
					@desc 		この項で使いたいマップBGMを設定します。
					@dir 		audio/bgm
					@require 1

					@param 	volume
					@type 		number
					@text 		音量
					@desc 		この項で使うBGMのボリュームを設定します。
					@default 	90
					@max 		100
					@decimals 	0

					@param 	pitch
					@type 		number
					@text 		ピッチ
					@desc 		この項で使うBGMの音程・速度を設定します。
					@default 	100
					@decimals 	0

					@param 	pan
					@type 		number
					@text 		位相
					@desc 		この項で使うBGMの位相を設定します。
					@default 	0
					@max 		100
					@min 		-100
					@decimals 	0

					@param 	track
					@type 		number
					@text 		ジュークボックスID
					@desc 		ジュークボックスでのトラックNoを設定します。戦闘BGMと共有されます。0にするとリストから除外されます。
					@default 	0
					@decimals 	0

					@param 	title
					@type 		string
					@text 		曲名
					@desc 		ジュークボックスで表示する曲名を設定します。
					@default 	トラック

					@param 	creator
					@type 		string
					@text 		作曲者名
					@desc 		ジュークボックスで表示する作曲者名を設定します。

					@param 	creatorMemo
					@type 		note
					@text 		作曲者コメント
					@desc 		ジュークボックスで表示する作曲者コメントを設定します。不要な場合は空欄にして下さい。

					@param 	comment
					@type 		string
					@text 		一言メモ
					@desc 		BGMの用途などのメモにお使い下さい。なお、半角数字を使うと不具合の恐れがあります。
				*/
				/*----------------------------------------------------------------------------------------*/
				/*~struct~MapBgms:
					@param 	name
					@type 		file
					@text 		map BGM
					@desc 		Select this BGM
					@dir 		audio/bgm
					@require 1

					@param 	volume
					@type 		number
					@text 		volume of this BGM
					@desc 		Control the volume
					@default 	90
					@max 		100
					@decimals 	0

					@param 	pitch
					@type 		number
					@text 		pitch of this BGM
					@desc 		Control the pitch
					@default 	100
					@decimals 	0

					@param 	pan
					@type 		number
					@text 		pan of this BGM
					@desc 		Control the pan
					@default 	0
					@max 		100
					@min 		-100
					@decimals 	0

					@param 	track
					@type 		number
					@text 		track of SoundTest
					@desc 		Control the track which is shared with battle BGM; when 0, this is excepted from SoundTest
					@default 	0
					@decimals 	0

					@param 	title
					@type 		string
					@text 		title of BGM
					@desc 		Define the title displayed in SoundTest
					@default 	Track 1

					@param 	creator
					@type 		string
					@text 		creator's name
					@desc 		Define creator's name displayed in SoundTest

					@param 	creatorMemo
					@type 		note
					@text 		creator's comment
					@desc 		Write the comment displayed in SoundTest if you need

					@param 	comment
					@type 		string
					@text 		memo
					@desc 		Write usage of this BGM
				*/

					const parseLibraryBgms = s => JSON.parse(s, (key, value)=>{
						switch(key){
							case 'battlePatern' : return value;
							case 'condition' 	: return Number.parseFloat(value);
							case 'mapOverride' 	: return value;
							case 'autoOff' 		: return value;
							case 'parallel' 	: return Number.parseFloat(value);
							case 'name' 		: return value;
							case 'volume' 		: return Number.parseFloat(value);
							case 'pitch' 		: return Number.parseFloat(value);
							case 'pan' 			: return Number.parseFloat(value);
							case 'track' 		: return Number.parseFloat(value);
							case 'title' 		: return value;
							case 'creator' 		: return value;
							case 'creatorMemo' 	: return value;
							case 'comment' 		: return value;
							default 			: return value;
						}
					});//*

		let mapBgms = params.mapBgms;
		let consolerNameMapBGM = 'mapBGMs:';
		if(mapBgms){
				mapBgms = JSON.parse(mapBgms);
				mapBgms = mapBgms.map(element => JSON.parse(element));
				mapBgms = mapBgms.map(element => stringToNumber(element));
				mapBgms = mapBgms.map(element => {
								element = stringToBoolean(element);
								return element;
							});	
		}else{
				mapBgms = [];
				undefinedStructs.push(consolerNameMapBGM);
				consolerNameMapBGM += makeInvalidTerm();
		};
		mapBgms.unshift(emptyBgm);
		consoler(consolerNameMapBGM, mapBgms);

		const mapBgmsCondition = Number(params.mapBgmsCondition);

if(fieldValid && mapBgmsCondition){

		const _Game_Variables_prototype_setValue = Game_Variables.prototype.setValue;
		Game_Variables.prototype.setValue = function(variableId, value, decimals) {
			    _Game_Variables_prototype_setValue.apply(this, arguments);
				    
			    this.autoPlayBgm(variableId, value);
		};//*

		Game_Variables.prototype.autoPlayBgm = function(variableId, value){
			if(variableId === mapBgmsCondition && value >= 0 &&value < mapBgms.length){
			    	const bgm = mapBgms[value];
			    	AudioManager.playBgm(bgm);
			    	this.onChange();
			    	if(bgm.autoOff){
				    		this._data[variableId] = 0;
			    	}
			    	if(jukeboxCondition && bgm.track > 0){
				    		$gameJukebox.open(bgm.track);
			    	}
		    };
		};//*

};//*mapBgmsCondition end

	/*-----------------マップSEのライブラリ化-----------------------------*/

				/*~struct~MapSes:ja
					@param 	parallel
					@type 		number
					@text 		同時SE
					@desc 		SEライブラリのIDを設定すると、このSEを鳴らす際に指定のSEも鳴らします。
					@default 	0
					@decimals 	0

					@param 	name
					@type 		file
					@text 		使用楽曲
					@desc 		この項で使いたいマップSEを設定します。
					@dir 		audio/se
					@require 1

					@param 	volume
					@type 		number
					@text 		音量
					@desc 		この項で使うSEのボリュームを設定します。
					@default 	90
					@max 		100
					@decimals 	0

					@param 	pitch
					@type 		number
					@text 		ピッチ
					@desc 		この項で使うSEの音程・速度を設定します。
					@default 	100
					@decimals 	0

					@param 	pan
					@type 		number
					@text 		位相
					@desc 		この項で使うSEの位相を設定します。
					@default 	0
					@max 		100
					@min 		-100
					@decimals 	0

					@param 	comment
					@type 		string
					@text 		一言メモ
					@desc 		SEの用途などのメモにお使い下さい。なお、半角数字を使うと不具合の恐れがあります。
				*/
				/*----------------------------------------------------------------------------------*/
				/*~struct~MapSes:
					@param 	parallel
					@type 		number
					@text 		parallel playing
					@desc 		Select index of "mapSes" which plays with this SE
					@default 	0
					@decimals 	0

					@param 	name
					@type 		file
					@text 		map SE
					@desc 		Select this SE
					@dir 		audio/se
					@require 1

					@param 	volume
					@type 		number
					@text 		volume of this SE
					@desc 		Control the volume
					@default 	90
					@max 		100
					@decimals 	0

					@param 	pitch
					@type 		number
					@text 		pitch of this SE
					@desc 		Control the pitch
					@default 	100
					@decimals 	0

					@param 	pan
					@type 		number
					@text 		pan of this SE
					@desc 		Control the pan
					@default 	0
					@max 		100
					@min 		-100
					@decimals 	0

					@param 	comment
					@type 		string
					@text 		memo
					@desc 		Write usage of this SE
				*/

		let mapSes = params.mapSes;
		let consolerNameMapSE = 'mapSEs:';
		if(mapSes){
				mapSes = JSON.parse(mapSes);
				mapSes = mapSes.map(element => JSON.parse(element));
				mapSes = mapSes.map(element => stringToNumber(element));	
		}else{
				mapSes = [];
				undefinedStructs.push(consolerNameMapSE);
				consolerNameMapSE += makeInvalidTerm();
		};
					
		mapSes.unshift(emptySE);
		consoler(consolerNameMapSE, mapSes);

		const mapSesCondition = Number(params.mapSesCondition);

if(fieldValid && mapSesCondition){

		const _Game_Variables_prototype_setValue = Game_Variables.prototype.setValue;
		Game_Variables.prototype.setValue = function(variableId, value, decimals) {
			_Game_Variables_prototype_setValue.apply(this, arguments);
				    
			this.autoPlaySe(variableId, value);
		};//*

		Game_Variables.prototype.autoPlaySe = function(variableId, value){
			if(variableId === mapSesCondition && value >= 0 && value < mapSes.length){
					const se = mapSes[value];
				    AudioManager.playSe(se);
				    this.onChange();
				    if(se.parallel){
				    		const se2 = mapSes[se.parallel];
				    		AudioManager.playSe(se2);
				    }
			};
		};//*

};//*mapSesCondition end


	/*-----------------マップMEのライブラリ化-----------------------------*/

				/*~struct~MapMes:ja
					@param 	name
					@type 		file
					@text 		使用楽曲
					@desc 		この項で使いたいマップMEを設定します。
					@dir 		audio/me
					@require 1

					@param 	volume
					@type 		number
					@text 		音量
					@desc 		この項で使うMEのボリュームを設定します。
					@default 	90
					@max 		100
					@decimals 	0

					@param 	pitch
					@type 		number
					@text 		ピッチ
					@desc 		この項で使うMEの音程・速度を設定します。
					@default 	100
					@decimals 	0

					@param 	pan
					@type 		number
					@text 		位相
					@desc 		この項で使うMEの位相を設定します。
					@default 	0
					@max 		100
					@min 		-100
					@decimals 	0

					@param 	comment
					@type 		string
					@text 		一言メモ
					@desc 		MEの用途などのメモにお使い下さい。なお、半角数字を使うと不具合の恐れがあります。
				*/
				/*-----------------------------------------------------------------------------------*/
				/*~struct~MapMes:
					@param 	name
					@type 		file
					@text 		map ME
					@desc 		Select this ME
					@dir 		audio/me
					@require 1

					@param 	volume
					@type 		number
					@text 		volume of this ME
					@desc 		Control the volume
					@default 	90
					@max 		100
					@decimals 	0

					@param 	pitch
					@type 		number
					@text 		pitch of this ME
					@desc 		Control the pitch
					@default 	100
					@decimals 	0

					@param 	pan
					@type 		number
					@text 		pan of this ME
					@desc 		Control the pan
					@default 	0
					@max 		100
					@min 		-100
					@decimals 	0

					@param 	comment
					@type 		string
					@text 		memo
					@desc 		Write usage of this ME
				*/

		let mapMes = params.mapMes;
		let consolerNameMapME = 'mapMEs:';
		if(mapMes){
				mapMes = JSON.parse(mapMes);
				mapMes = mapMes.map(element => JSON.parse(element));
				mapMes = mapMes.map(element => stringToNumber(element));	
		}else{
				mapMes = [];
				undefinedStructs.push(consolerNameMapME);
				consolerNameMapME += makeInvalidTerm();
		};
	
		mapMes.unshift(emptySE);
		consoler(consolerNameMapME, mapMes);

		const mapMesCondition = Number(params.mapMesCondition);

if(fieldValid && mapMesCondition){

		const _Game_Variables_prototype_setValue = Game_Variables.prototype.setValue;
		Game_Variables.prototype.setValue = function(variableId, value, decimals) {
		    _Game_Variables_prototype_setValue.apply(this, arguments);
				    
		    this.autoPlayMe(variableId, value);
		};//*

		Game_Variables.prototype.autoPlayMe = function(variableId, value){
			if(variableId === mapMesCondition && value >= 0 && value < mapMes.length){
			    	const me = mapMes[value];
			    	AudioManager.playMe(me);
			    	this.onChange();
		    };
		};//*

};//*mapMesCondition end

	/*-----------------マップBGSのライブラリ化-----------------------------*/

				/*~struct~MapBgss:ja
					@param 	name
					@type 		file
					@text 		使用楽曲
					@desc 		この項で使いたいマップBGSを設定します。
					@dir 		audio/bgs
					@require 1

					@param 	volume
					@type 		number
					@text 		音量
					@desc 		この項で使うBGSのボリュームを設定します。
					@default 	50
					@max 		100
					@decimals 	0

					@param 	pitch
					@type 		number
					@text 		ピッチ
					@desc 		この項で使うBGSの音程・速度を設定します。
					@default 	100
					@decimals 	0

					@param 	pan
					@type 		number
					@text 		位相
					@desc 		この項で使うBGSの位相を設定します。
					@default 	0
					@max 		100
					@min 		-100
					@decimals 	0

					@param 	comment
					@type 		string
					@text 		一言メモ
					@desc 		BGSの用途などのメモにお使い下さい。なお、半角数字を使うと不具合の恐れがあります。
				*/
				/*------------------------------------------------------------------------------------*/
				/*~struct~MapBgss:
					@param 	name
					@type 		file
					@text 		map BGS
					@desc 		Select this BGS
					@dir 		audio/bgs
					@require 1

					@param 	volume
					@type 		number
					@text 		volume of this BGS
					@desc 		Control the volume
					@default 	50
					@max 		100
					@decimals 	0

					@param 	pitch
					@type 		number
					@text 		pitch of this BGS
					@desc 		Control the pitch
					@default 	100
					@decimals 	0

					@param 	pan
					@type 		number
					@text 		pan of this BGS
					@desc 		Control the pan
					@default 	0
					@max 		100
					@min 		-100
					@decimals 	0

					@param 	comment
					@type 		string
					@text 		memo
					@desc 		Write usage of this BGS
				*/

		let mapBgss = params.mapBgss;
		let consolerNameMapBGS = 'mapBGSs:';
		if(mapBgss){
				mapBgss = JSON.parse(mapBgss);
				mapBgss = mapBgss.map(element => JSON.parse(element));
				mapBgss = mapBgss.map(element => stringToNumber(element));	
		}else{
				mapBgss = [];
				undefinedStructs.push(consolerNameMapBGS);
				consolerNameMapBGS += makeInvalidTerm();
		};

		mapBgss.unshift(emptySE);
		consoler(consolerNameMapBGS, mapBgss);

		const mapBgssCondition = Number(params.mapBgssCondition);

if(fieldValid && mapBgssCondition){

		const _Game_Variables_prototype_setValue = Game_Variables.prototype.setValue;
		Game_Variables.prototype.setValue = function(variableId, value, decimals) {
		    _Game_Variables_prototype_setValue.apply(this, arguments);
				    
		    this.autoPlayBgs(variableId, value);
		};//*

		Game_Variables.prototype.autoPlayBgs = function(variableId, value){
			if(variableId === mapBgssCondition && value >= 0 && value < mapBgss.length){
		    		const bgs = mapBgss[value];
			    	AudioManager.playBgs(bgs);
			    	this.onChange();
		    };
		};//*
};//*mapBgsCondition end


	/*-------------ジュークボックス設定------------------------------------------*/

				/*~struct~Jukebox:ja
					@param 	variableId
					@type 		variable
					@text 		ジュークボックス変数
					@desc 		1以上を設定すると、マップBGMと戦闘BGMの鑑賞モードを使えるようになります。マップBGM変数の設定も必要です。
					@default 	0

					@param 	name
					@type 		string
					@text 		システム名
					@desc 		タイトルコマンド、および鑑賞モード中に表示されるシステムとしての名前を設定します。
					@default 	ジュークボックス

					@param 	defaultCreator
					@type 		string
					@text 		メイン作曲者
					@desc 		ジュークボックスで表示するメインの作曲者名を設定します。戦闘BGM、マップBGMで作曲者が未設定の場合に表示されます。

					@param 	creatorText
					@type 		string
					@text 		作曲者システム名
					@desc 		「作曲者」を示すシステム名を設定します。
					@default 	作曲者

					@param 	initValid
					@type 		boolean
					@text 		解放状況
					@desc 		On（true）の時、タイトルメニューからジュークボックスが使用できます。スクリプトコマンドで後からOnにできます。
					@default 	false

					@param 	initMusicValid
					@type 		boolean
					@text 		BGMの解放状況
					@desc 		On（true）の時、初めから全曲が解放されます。Offの場合、演奏されたBGMが自動でOnになります。
					@default 	false
				*/
				/*------------------------------------------------------------------------------------------------*/
				/*~struct~Jukebox:
					@param 	variableId
					@type 		variable
					@text 		variable for SoundTest
					@desc 		Available SoundTest of battle and map BGM when this and "mapBgmsCondition" is more than 1
					@default 	0

					@param 	name
					@type 		string
					@text 		system name
					@desc 		Define the name displayed in title or SoundTest scene
					@default 	Jukebox

					@param 	defaultCreator
					@type 		string
					@text 		main composer
					@desc 		Define the name displayed in SoundTest when BGM's "creator" is undefined

					@param 	creatorText
					@type 		string
					@text 		system name for composer
					@desc 		Define the name
					@default 	Composer

					@param 	initValid
					@type 		boolean
					@text 		release condition
					@desc 		Available SoundTest at title when this is true; you can change this by PluginCommand later
					@default 	false

					@param 	initMusicValid
					@type 		boolean
					@text 		release condition of BGM
					@desc 		Release all BGM when this is true, otherwise release each BGM at the timing its playing
					@default 	false
				*/


		const parseJukebox = s => JSON.parse(s, (key, value)=>{
			switch(key){
				case 'variableId' 		: return Number.parseFloat(value);
				case 'name' 			: return value;
				case 'defaultCreator' 	: return value;
				case 'creatorText' 		: return value;
				case 'initValid' 		: return value;
				case 'initMusicValid'	: return value;
				default 				: return value;
			}
		});//*

		let Jukebox = params.jukebox;
		let consolerNameJukebox = 'Jukebox:';
		if(Jukebox){
			Jukebox = parseJukebox(Jukebox);
			Jukebox = stringToBoolean(Jukebox);	
		}else{
			Jukebox = makeNotValid();
			undefinedStructs.push(consolerNameJukebox);
			consolerNameJukebox += makeInvalidTerm();
		};
	
		let jukebox = mapBgms.concat(battleBgms);
			jukebox = jukebox.filter(music => {return music.track !== 0});
			jukebox = Array.from(new Set(jukebox));
			jukebox.sort((a,b)=> a.track - b.track);
			consoler(consolerNameJukebox, Jukebox, jukebox);

		const jukeboxCondition = Jukebox.variableId;

class Game_Jukebox{
		constructor(){
			this._valid = Jukebox.initValid;
			this._data = jukebox.map(bgm => {
					bgm.open = Jukebox.initMusicValid;
					return bgm;
				});
		};//*

		initialize (){
			this._valid = Jukebox.initValid;
			this._data = jukebox.map(bgm => {
					bgm.open = Jukebox.initMusicValid;
					return bgm;
				});
			this.update();
		};//*

		update (){
			ConfigManager.save();
		};//*

		updateParam(){
			if(this._data.length !== jukebox.length){
				const tempData = this._data.map(bgm => {return bgm});
				this._data = jukebox.map((bgm, index) => {
					bgm.open = tempData[index] ? tempData[index].open : Jukebox.initMusicValid;
					return bgm;
				});
			}
		};//*

		isValid (){
			return this._valid;
		};//*

		validOn (){
			this._valid = true;
			this.update();
		};//*

		validOff (){
			this._valid = false;
			this.update();
		};//*

		open (id){
			if(!this._data[id]){
					if(jukebox[id]){
							this._data[id] = jukebox[id];
					}else{
							return;
					}
			};
			if(!this._data[id].open){
					this._data[id].open = true;
					this.update();
			}
		};//*

		filter (){
			const bgms = this._data;
			return bgms.filter(bgm => {return bgm.track === -1 || bgm.open});
		};//*

};//*Game_Jukebox

	window[Game_Jukebox.name] = Game_Jukebox;


if(fieldValid && mapBgmsCondition && jukeboxCondition){
	const _Game_Variables_prototype_autoPlayBgm = Game_Variables.prototype.autoPlayBgm; 
	Game_Variables.prototype.autoPlayBgm = function(variableId, value){
		_Game_Variables_prototype_autoPlayBgm.apply(this, arguments);

		if(variableId === jukeboxCondition){
			    const bgm = $gameJukebox.filter()[value];
			   	if(bgm){
			    		AudioManager.playBgm(bgm);
			    		this.onChange();	
			   	}	
		};
	};//*

	const _Window_TitleCommand_prototype_makeCommandList = Window_TitleCommand.prototype.makeCommandList;
	Window_TitleCommand.prototype.makeCommandList = function() {
	    _Window_TitleCommand_prototype_makeCommandList.apply(this, arguments);
	    if($gameJukebox && $gameJukebox.isValid()){
		   		 this.addCommand(Jukebox.name, 'jukebox'); 	
		}
	};//*

	const _Scene_Title_prototype_createCommandWindow = Scene_Title.prototype.createCommandWindow;
	Scene_Title.prototype.createCommandWindow = function() {
		_Scene_Title_prototype_createCommandWindow.apply(this, arguments);
		this._commandWindow.setHandler('jukebox', this.commandJukebox.bind(this));
	};//*

	Scene_Title.prototype.commandJukebox = function(){
		SceneManager.push(Scene_Jukebox);
		//AudioManager.stopBgm();
	};//*
}////

class Scene_Jukebox extends Scene_MenuBase{
		constructor(){
			super();
			$gameSystem.saveBgm();
			AudioManager.stopBgm();
		};//*

		create (){
			super.create();
			super.createWindowLayer();
			this.createTitleWindow();
			this.createItemWindow();
			this.createHelpWindow();
			this.createInfoWindow();
		};//*

		createTitleWindow (){
			const width = Graphics.boxWidth;
			const height = Math.floor(Graphics.boxHeight * 2 / 13);
			this._titleWindow = new Window_Base (0, 0, width, height);
			this.addWindow(this._titleWindow);
			this.drawTitle();
		};//*

		createItemWindow (){
			const y = this._titleWindow.height;
			const width = Math.floor(Graphics.boxWidth / 2);
			const height = Graphics.boxHeight - y;
			this._itemWindow = new Window_Jukebox(0, y, width, height);
			this._itemWindow.setHandler('ok', this.processOk.bind(this));
			this._itemWindow.setHandler('cancel', this.popScene.bind(this));
			this._itemWindow.setHandler('right', this.processRight.bind(this));
			this._itemWindow.setHandler('left', this.processLeft.bind(this));
			this._itemWindow.refresh();
			this.addWindow(this._itemWindow);
			this._itemWindow.activate();
			this._itemWindow.select(0);
		};//*

		createHelpWindow (){
			this._helpWindow = new Window_Help(4);
			this._helpWindow.x = this._itemWindow.width;
			this._helpWindow.y = Graphics.boxHeight - this._helpWindow.height;
			this._helpWindow.width = Graphics.boxWidth - this._helpWindow.x;
			this.addWindow(this._helpWindow);
			this.drawHelp();
		};//*

		createInfoWindow (){
			const x = this._itemWindow.width;
			const y = this._titleWindow.height;
			const width = Graphics.boxWidth - x;
			const height = Graphics.boxHeight - this._helpWindow.height - y;
			this._infoWindow = new Window_JukeInfo(x, y, width, height);
			this._infoWindow.refresh();
			this.addWindow(this._infoWindow);
			this._itemWindow.setInfoWindow(this._infoWindow);
		};//*
			
		drawTitle (){
			this._titleWindow.drawText(Jukebox.name, 0, 0, this._titleWindow.width, 'center');
		};//*

		drawHelp (){
			const play = this.getTextObject(keyName(keyOfEnter), 'Play');
			const move = this.getTextObject(keyName(keyOfArrowUD), 'Select');
			const skip = this.getTextObject(keyName(keyOfArrowLR), 'Scroll');
			const quit = this.getTextObject(keyName(keyOfCancel), 'Quit');
			let controll = [];
				controll.push(play, move, skip, quit);
			const width = this._helpWindow.width;
			const titleWidth = this.getMaxTitleWidth(controll);
			const signWidth = this._helpWindow.textWidth(' : ');
			const signX = titleWidth;
			const nameX = signX + signWidth;
			const nameWidth = this._helpWindow.contentsWidth - nameX;
			const lineHeight = this._helpWindow.lineHeight();
			for(var i = 0; i < controll.length; i++){
				let y = lineHeight * i;
				this._helpWindow.drawText(controll[i].title, 0, y, titleWidth);
				this._helpWindow.drawText(controll[i].sign, signX, y, signWidth);
				this._helpWindow.drawText(controll[i].name, nameX, y, nameWidth);
			}
		};//*

		getTextObject (title, name){
			return {"title":title, "sign":' : ',"name":name};
		};//*

		getMaxTitleWidth (controll){
			const w = this._helpWindow;
			const titles = controll.map(c => {return w.textWidth(c.title)});
			let max = titles.reduce((a,b) => {
					return Math.max(a, b)
				});
			return max;
		};//*

		processOk(){
			this._itemWindow.playMusic();
		};//*

		processRight (){
			this._itemWindow.cursorRight();
		};//*

		processLeft (){
			this._itemWindow.cursorLeft();
		};//*

		popScene (){
			$gameSystem.replayBgm();
			super.popScene();
		};//*
};//*Scene_Jukebox

	window[Scene_Jukebox.name] = Scene_Jukebox;

class Window_Jukebox extends Window_Selectable {
		constructor(x, y, width, height){
			super(x, y, width, height);
			this._isPlaying = 0;
			this._jukebox = $gameJukebox.filter();
		};//*

		setInfoWindow (infoWindow){
			if(infoWindow){
					this._infoWindow = infoWindow
			}
		};//*

		maxItems (){
			return this._jukebox ? this._jukebox.length : $gameJukebox.filter().length;
		};//*

		drawItem (index){
			var rect = this.itemRectForText(index);
			const trackWidth = this.textWidth('000:');
			this.changePlayColor(index);
			this.drawJukeboxTrack(index, trackWidth, rect);
			this.drawJukeboxTitle(index, trackWidth, rect);
		};//*

		changePlayColor (index){
			if(this._isPlaying === index){
					this.changeTextColor(this.crisisColor());
			}else{
					this.resetTextColor();
			}
		};//*

		drawJukeboxTrack (index, trackWidth, rect){
			let track = this._jukebox[index].track;
				track += ':'
			if(index > 0){
					this.drawText(track.padZero(4), rect.x, rect.y, trackWidth);	
			}
		};//*

		drawJukeboxTitle (index, trackWidth, rect){
			const title = this._jukebox[index].title;
			if(index === 0){
					this.drawText(title, rect.x, rect.y, rect.width);
			}else{
					this.drawText(title, rect.x + trackWidth, rect.y, rect.width - trackWidth);	
			}
		};//*

		playMusic (){
			const index = this.index();
			const variableId = jukeboxCondition;
			$gameVariables.setValue(variableId, index);
			this.setJukeInfo(index);
			this.setPlayingTrack(index);
			this.refresh();
			this.activate();
		};//*

		setJukeInfo (index){
			const bgm = this._jukebox[index];
			if(this._infoWindow){
					this._infoWindow.setBgm(bgm);
			}
		};//*

		setPlayingTrack (index){
			this._isPlaying = index;
		};//*

		cursorRight (){
			let index = this.index();
			let rows = this.maxPageRows();
				index = Math.min(this._jukebox.length - 1, index + rows);
			this.select(index);
		};//*

		cursorLeft (){
			let index = this.index();
			let rows = this.maxPageRows();
				index = Math.max(0, index - rows);
			this.select(index);
		};//*

};//*Window_Jukebox

	window[Window_Jukebox.name] = Window_Jukebox;

class Window_JukeInfo extends Window_Base {
		constructor(x, y, width, height){
			super(x, y, width, height);
			this._currentBgm = jukebox[0];
		};//*

		standardFontSize (){
			return 18;
		};//*

		setBgm (bgm){
			this._currentBgm = bgm;
			this.refresh();
		};//*

		refresh (){
			this.contents.clear();
			this.drawTitle();
			this.drawCreator();
			this.drawMemo();
		};//*

		drawTitle (){
			const title = this.getTitle();
			this.drawText(title, 0 ,0);
		};//*

		getTitle (){
			return this._currentBgm.title;
		};//*

		drawCreator (){
			const creator = this.getCreator(); 
			const name = Jukebox.creatorText + ' : ';
			const nameWidth = this.textWidth(name);
			const y = this.lineHeight();
			this.changeTextColor(this.systemColor());
			this.drawText(name, 0, y, nameWidth);
			this.resetTextColor();
			this.drawText(creator, nameWidth, y, this.width - nameWidth);
		};//*

		getCreator (){
			let creator = this._currentBgm.creator || Jukebox.defaultCreator;
				creator = creator === emptyBgm.creator ? '' : creator;
			return creator; 
		};//*

		drawMemo (){
			const memo = this.getMemo();
			const y = this.lineHeight() * 2;
			this.drawTextEx(memo, 0, y);
		};//*

		getMemo (){
			let memo = this._currentBgm.creatorMemo;
				memo = memo ? JSON.parse(memo) : '';
			return memo;
		};//*

};//*Window_JukeInfo

	window[Window_JukeInfo.name] = Window_JukeInfo;

if(fieldValid && mapBgmsCondition && jukeboxCondition){
	const _DataManager_createGameObjects = DataManager.createGameObjects;
	DataManager.createGameObjects = function() {
		_DataManager_createGameObjects.apply(this, arguments);
					    
		$gameJukebox = new Game_Jukebox();
		if(ConfigManager.gameJukeboxBgms){
				$gameJukebox._valid = ConfigManager.gameJukeboxValid;
		    	$gameJukebox._data = ConfigManager.gameJukeboxBgms;
 	    }else{
		    	ConfigManager.gameJukebox = $gameJukebox;
	    };
	};//*

	const _ConfigManager_makeData = ConfigManager.makeData;
	ConfigManager.makeData = function() {
		let config = _ConfigManager_makeData.apply(this, arguments);
		//cannot inherit class , only object
		$gameJukebox.updateParam();
			config.gameJukeboxValid = $gameJukebox.isValid();
			config.gameJukeboxBgms = $gameJukebox._data;
		return config;
	};//*

	const _ConfigManager_applyData = ConfigManager.applyData;
	ConfigManager.applyData = function(config) {
		_ConfigManager_applyData.apply(this, arguments);
		this.gameJukeboxValid = config.gameJukeboxValid;
		this.gameJukeboxBgms = config.gameJukeboxBgms;
	};//*
};////

/*********************************************************************************************/
		/*-------------エンカウント設定--------------------*/

				/*~struct~Encount:ja
					@param 	rateType
					@type 		select
					@text 		エンカ率タイプ
					@desc 		エンカに必要な歩数決定の方法を設定します。選択肢の「歩数」はマップ設定の「敵出現歩数」を指します。
					@default 	normal
							@option　	デフォルト(1~歩数×2でエンカウント)
							@value 	normal

							@option 	最低保証型(歩数~歩数×2でエンカウント)
							@value 	guarantee

							@option 	固定型(歩数±(0~4)でエンカウント)
							@value 	solid

					@param 	solidAdjust
					@type 		number
					@text 		固定型補正値
					@desc 		固定型のみ、±で+が選ばれる確率を設定します。値が大きいほど、確率は高くなります。
					@default 	2
					@min 		2
					@decimals 	0 	

					@param 	dashEffect
					@type 		number
					@text 		ダッシュ時のエンカ率
					@desc 		ダッシュ中にエンカウント率へかける補正倍率を設定します。大きいほどエンカしやすくなります。初期値は1です。
					@default 	1
					@decimals 	0
					@min 		1
				*/
				/*-----------------------------------------------------------------------------------------------------------*/
				/*~struct~Encount:
					@param 	rateType
					@type 		select
					@text 		type of encount rate
					@desc 		Select a type; "step" in this choices is "Enc. Steps"
					@default 	normal
							@option　	default(encount at 1 ~ step * 2)
							@value 	normal

							@option 	guarantee(encount at step ~ step * 2)
							@value 	guarantee

							@option 	variance(encount at step ± (0~4))
							@value 	solid

					@param 	solidAdjust
					@type 		number
					@text 		adjuster for variance
					@desc 		Control percentage of + selected from ±, when "rateType" is variance; bigger value raise percentage
					@default 	2
					@min 		2
					@decimals 	0 	

					@param 	dashEffect
					@type 		number
					@text 		adjuster on dashing
					@desc 		Control rate adjuster on player's dashing; bigger value raise encount rate
					@default 	1
					@decimals 	0
					@min 		1
				*/

	const parseEncount = s => JSON.parse(s, (key, value)=>{
		switch(key){
			case 'rateType' 	: return value;
			case 'solidAdjust' 	: return Number.parseFloat(value);
			case 'dashEffect' 	: return Number.parseFloat(value);
			default 			: return value;
		}
	});//*

	let encount = params.encount;
	let consolerNameEncount = 'encount:';
	if(encount){
			encount = parseEncount(encount);
	}else{
			encount = makeNotValid();
			undefinedStructs.push(consolerNameEncount);
			consolerNameEncount += makeInvalidTerm();
	};
	consoler(consolerNameEncount,encount);

if(fieldValid){
		const _Game_Player_prototype_makeEncounterCount = Game_Player.prototype.makeEncounterCount;
		Game_Player.prototype.makeEncounterCount = function() {
		    var n = $gameMap.encounterStep();
			switch(encount.rateType){
				case 'normal' :
				    	this._encounterCount = Math.randomInt(n) + Math.randomInt(n) + 1;
				break;

				case 'guarantee' :
				    	this._encounterCount = n + Math.randomInt(n + 1);
				break;

				case 'solid' :
				    	let coefficient = Math.randomInt(encount.solidAdjust) ? 1 : -1;
				    	this._encounterCount = n + Math.randomInt(5) * coefficient;
				break;

				default : this._encounterCount = Math.randomInt(n) + Math.randomInt(n) + 1;
			}
		};//*

		const _Game_Player_prototype_updateEncounterCount = Game_Player.prototype.updateEncounterCount;
		Game_Player.prototype.updateEncounterCount = function() {
			if (this.canEncounter()) {
					this._encounterCount -= this.encounterProgressValue() * this.additionalProguressValue();
			}
		};//*
}//encount condition end

Game_Player.prototype.additionalProguressValue = function(){
	let value = 1;
	if(this.isDashing()){
			value *= encount.dashEffect ? encount.dashEffect : 1;
	}
	return value;
};//*
if(!fieldValid) Game_Player.prototype.additionalProguressValue = function(){return 1};


Game_Player.prototype.forceEncount = function(){
	if(this.canEncounter()){
			this._encounterCount = 0;
	}
};//*
if(!fieldValid) Game_Player.prototype.forceEncount = function(){};



	//*******************for plugin methods*********************************//

	//-------------不透明度自動化--------------------------//

//Game_CharacterBase.prototype.initMembersへの追記は、先述の移動強化の設定時にしている
Game_CharacterBase.prototype.initializeAutoOpacity = function(){
	this._startOpacity 		= 0;
	this._endOpacity 		= 0;
	this._offsetOpacity 	= 0;
	this._waitOpacity 		= 0;
	this._opacityWaitCount 	= 0;
};//*

if(fieldValid){
	const _Game_CharacterBase_prototype_update = Game_CharacterBase.prototype.update;
	Game_CharacterBase.prototype.update = function(){
		_Game_CharacterBase_prototype_update.apply(this, arguments);
			
		this.autoChangeOpacity();
	};//*
}////

Game_CharacterBase.prototype.autoChangeOpacity = function(){
	if(this._opacityWaitCount > 0){
		this._opacityWaitCount --;

		if(this._opacityWaitCount <= 0){
				this.addOpacity(this._offsetOpacity);

				this._opacityWaitCount = this.isOpacityEnd() ? 0 : this._waitOpacity;
				if(this.isOpacityEnd()){
					const opacity = this._endOpacity * 1;
					this.setOpacity(opacity);
					this.initializeAutoOpacity();
				}
		};
	}
};//*
if(!fieldValid) Game_CharacterBase.prototype.autoChangeOpacity = function(){};


Game_CharacterBase.prototype.setAutoChangeOpacity = function(start, end, offset, wait){
	this._startOpacity 		= start;
	this._endOpacity 		= end;
	this._offsetOpacity 	= offset * (start < end ? 1 : -1);
	this._waitOpacity 		= wait;
	this.setOpacity(start);
	this._opacityWaitCount = wait;
};//*
if(!fieldValid) Game_CharacterBase.prototype.setAutoChangeOpacity = function(start, end, offset, wait){};


Game_CharacterBase.prototype.addOpacity = function(opacity){
	this._opacity += opacity;
};//*
if(!fieldValid) Game_CharacterBase.prototype.addOpacity = function(opacity){};


Game_CharacterBase.prototype.isOpacityEnd = function(){
	if(this._startOpacity < this._endOpacity){
		return this.opacity() >= this._endOpacity;
	}else{
		return this.opacity() <= this._endOpacity;
	}
};//*
if(!fieldValid) Game_CharacterBase.prototype.isOpacityEnd = function(){return false};



	//-----------ジャンプ自動化--------------------------------//

let regionWall = params.regionWall;
const consolerNameRegionWall = 'regionWall:';
if(regionWall){
	regionWall = JSON.parse(regionWall);
	regionWall = regionWall.map(id => Number(id));

	if(regionWall.length === 0) regionWall = [0];
};

consoler(consolerNameRegionWall, regionWall);

let fallingSwitch = params.fallingSwitch;
const consolerNameFallingSwitch = 'fallingSwitch:';
if(fallingSwitch){
	fallingSwitch = Number(fallingSwitch);
};

consoler(consolerNameFallingSwitch, fallingSwitch);

let resistFallingAcceleration = params.resistFallingAcceleration;
const consolerNameResistFallingAcceleration = 'resistFallingAcceleration:';
if(resistFallingAcceleration){
	resistFallingAcceleration = Number(resistFallingAcceleration);
};

consoler(consolerNameResistFallingAcceleration, resistFallingAcceleration);

Game_CharacterBase.prototype.resistFallingAcceleration = function(){
	return this._resistFallingAcceleration || resistFallingAcceleration;
};//*
if(!fieldValid)Game_CharacterBase.prototype.resistFallingAcceleration = function(){return 0};

Game_CharacterBase.prototype.setResistFallingAcceleration = function(power){
	if(power >= 0) this._resistFallingAcceleration = power;
};//*
if(!fieldValid)Game_CharacterBase.prototype.resistFallingAcceleration = function(){};


const _Game_CharacterBase_prototype_updateJump = Game_CharacterBase.prototype.updateJump;
Game_CharacterBase.prototype.updateJump = function() {
	_Game_CharacterBase_prototype_updateJump.apply(this, arguments);
    
    if (this._jumpCount === 0){
    	const gm = $gameMap;
    	if(!this.checkJumpToHill(this.x, this.y) && this.isOnHill()) this._isOnHill = false;
    	if( this.isJumpTypeFall() || this.falloffInClimbing() ) this.executeFall();
    	if(this.isJumpTypeClimb() && 
    		!gm.checkWallSideTile(gm.allTiles(this.x, this.y))) this.setDirectionFix(false);
    }
};//*

const _Game_CharacterBase_prototype_updateMoveB = Game_CharacterBase.prototype.updateMove;
Game_CharacterBase.prototype.updateMove = function() {
    _Game_CharacterBase_prototype_updateMoveB.apply(this, arguments);
    if(this.isFalling()) this.updateFallSpeed();

    if (!this.isMoving() && $gameSystem.reservedSwitch()) {
    	$gameSystem.executeReservedSwitch();
    }
};//*

Game_CharacterBase.prototype.updateFallSpeed = function(){
	if(this.isMoving()){
		this._fallCount --;
		if(this._fallCount <= 0){
			this._fallCount = this.resistFallingAcceleration();
			let fallSpeed = Math.min(this.moveSpeed() + 1, 9);
			this.setMoveSpeed(fallSpeed);
		}
	}else{
		this.setFallCount(0);
		this.setMoveSpeed(this.moveSpeedBeforeFalling());
	}
};//*
if(!fieldValid)Game_CharacterBase.prototype.updateFallSpeed = function(){};

Game_CharacterBase.prototype.autoJump = function(x, y, dirFix, type){
	const dir = this.isJumpTypeClimb() ? Input._dir8 : this.direction();
	const straightPower = y;
	const bendedPower = x;
	this._autoJumpType = (type || 'step').toLowerCase();
	const goal = this.calcJumpGoal(dir, bendedPower, straightPower);
	const toHill = this.checkJumpToHill(goal.x, goal.y);
	let	plusX = goal.x - this.x;
	let	plusY = goal.y - this.y;

	if(toHill && !this.isOnHill()) this._isOnHill = true;
	if(this.isJumpTypeClimb() && $gameMap.checkWallSideTile($gameMap.allTiles(goal.x, goal.y))){
		this._direction = 8;
		this.setDirectionFix(true);
	}
	const lastDirectionFix = this.isDirectionFixed(dirFix);
	if(!this.isJumpTypeClimb()) this.setDirectionFix(dirFix);
	this.jump(plusX, plusY);
	if(!this.isJumpTypeClimb()) this.setDirectionFix(lastDirectionFix);
};//*
if(!fieldValid) Game_CharacterBase.prototype.autoJump = function(x, y, dirFix, type){};


Game_CharacterBase.prototype.checkJumpToHill = function(x, y){
	const tiles = $gameMap.allTiles(x, y);
	const lastTile = tiles[tiles.length - 1];
	return $gameMap.checkWallTopTile(tiles) || Tilemap.isRoofTile(lastTile);
};//*
if(!fieldValid) Game_CharacterBase.prototype.checkJumpToHill = function(x, y){return false};


Game_CharacterBase.prototype.calcJumpGoal = function(dir, bendedPower, straightPower){
	const currentX = dir === 4 ? Math.ceil(this.x) : Math.floor(this.x);
	const currentY = dir === 8 ? Math.ceil(this.y) : Math.floor(this.y);
	const checkPowers = this.makeCheckPowerForJump(bendedPower, straightPower);
	return this.calcJumpLandPoint(currentX, currentY, dir, checkPowers);
};//*
if(!fieldValid) Game_CharacterBase.prototype.calcJumpGoal = function(dir, bendedPower, straightPower){return null};


Game_CharacterBase.prototype.makeCheckPowerForJump = function(bendedPower, straightPower){
	let result = [];
	if(straightPower >= 0){
			for(var i = 0; i <= straightPower; i++){
				let bend = bendedPower * i / (straightPower > 0 ? straightPower : 1);
					bend = bend > 0 ? Math.floor(bend) : Math.ceil(bend);
				result.push([bend, i]);
			}	
	}else{
			for(var j = 0; straightPower <= j; j--){
				let bend = bendedPower * j / straightPower;
					bend = bend > 0 ? Math.floor(bend) : Math.ceil(bend);
				result.push([bend, j]);
			}
	}

	if(result.length === 0) result.push([0,0]);
	return result;
};//*
if(!fieldValid) Game_CharacterBase.prototype.makeCheckPowerForJump = function(bendedPower, straightPower){return []};


Game_CharacterBase.prototype.calcJumpLandPoint = function(x, y, dir, powers){
	const same = 1;
	const reverse = -1;
	const applyS = dir % 4 !== 0 ? same : reverse;
	const applyB = dir <= 4 ? same : reverse;
	const isDirV = dir % 8 <= 2;
	let landX = this.x;
	let landY = this.y;
	let finish = false;

	powers.forEach(power => {
		if(!finish){
				let bend 		= power[0] * applyB;
				let straight 	= power[1] * applyS;
				let checkX = x + (isDirV ? bend : straight);
				let checkY = y + (isDirV ? straight : bend);
				if(this.enableJumpLanding(checkX, checkY)){
						landX = checkX;
						landY = checkY;
				}else{
						finish = true;
				}
		}
	});
	return {x: landX, y: landY};
};//*
if(!fieldValid) Game_CharacterBase.prototype.calcJumpLandPoint = function(x, y, dir, powers, type){return null};



Game_CharacterBase.prototype.enableJumpLanding = function(x, y){
	return this.enableJumpLandingInMap(x, y) && this.enableJumpLandingAtRegion(x, y) &&
			$gameMap.eventsXyNt(x, y).length === 0;
};//*
if(!fieldValid) Game_CharacterBase.prototype.enableJumpLanding = function(x, y){return false};


Game_CharacterBase.prototype.enableJumpLandingInMap = function(x, y){
	if(this.isJumpTypeFall() && this.isOnHill()) return true;
	if(this.isJumpTypeFall() && !this.isOnHill() && this.checkJumpToHill(x, y) ) return false;

	//check the reversed direction of jumpping
	const gm = $gameMap;
	const dirX = x - this.x > 0 ? 4 : x - this.x < 0 ? 6 : 0; 
	const dirY = y - this.y > 0 ? 8 : y - this.y < 0 ? 2 : 0;
	x %= gm.width();
	y %= gm.height();

	let xOk = true;
	if( this.isJumpTypeRide() && dirX ) xOk = !gm.checkWallSideTile( gm.allTiles(x,y) );
	if( this.isJumpTypeStep() && dirX ) xOk = gm.isPassable(x, y, dirX);
	let yOk = true;
	if( this.isJumpTypeRide() && dirY ) yOk = !gm.checkWallSideTile( gm.allTiles(x,y) );
	if( this.isJumpTypeStep() && dirY ) yOk = gm.isPassable(x, y, dirY);

	const passable = xOk && yOk;
	const notInSea = !gm.isShipPassable(x, y);
	const notAbyssWall = this.isJumpTypeFall() ? true : gm.tileId(x, y, 0) > 0;
	return gm.isValid(x, y) && passable && notInSea && notAbyssWall;
};//*
if(!fieldValid) Game_CharacterBase.prototype.enableJumpLandingInMap = function(x, y){return false};


Game_CharacterBase.prototype.enableJumpLandingAtRegion = function(x, y){
	const regionId = $gameMap.regionId(x, y);
	return regionId === 0 || !regionWall.contains(regionId);
};//*
if(!fieldValid) Game_CharacterBase.prototype.enableJumpLandingAtRegion = function(x, y){return false};

Game_CharacterBase.prototype.isJumpTypeFall = function(){
	return this._autoJumpType === 'fall';
};//*
if(!fieldValid)Game_CharacterBase.prototype.isJumpTypeFall = function(){return false};

Game_CharacterBase.prototype.isJumpTypeClimb = function(){
	return this._autoJumpType === 'climb';
};//*
if(!fieldValid)Game_CharacterBase.prototype.isJumpTypeClimb = function(){return false};

Game_CharacterBase.prototype.isJumpTypeRide = function(){
	return this._autoJumpType === 'ride';
};//*
if(!fieldValid)Game_CharacterBase.prototype.isJumpTypeRide = function(){return false};

Game_CharacterBase.prototype.isJumpTypeStep = function(){
	return this._autoJumpType === 'step';
};//*
if(!fieldValid)Game_CharacterBase.prototype.isJumpTypeStep = function(){return false};

Game_CharacterBase.prototype.isClimbing = function(){
	return this.isJumpTypeClimb() && $gameMap.checkWallSideTile($gameMap.allTiles(this.x, this.y));
};//*
if(!fieldValid)Game_CharacterBase.prototype.isClimbing = function(){return false};

Game_CharacterBase.prototype.falloffInClimbing = function(){
	return this.isClimbing() &&
    	  ( !this.hasStamina() ||
    	  	$gameMap.checkWaterfallTile($gameMap.allTiles(this.x, this.y)) );
} ;//*
if(!fieldValid)Game_CharacterBase.prototype.falloffInClimbing = function(){return false};


Game_CharacterBase.prototype.executeFall = function(){
	const gm = $gameMap;
	if(this.isJumpTypeFall() &&
		this.isDeadByFalling() && fallingSwitch > 0){
			$gameSwitches.setValue(fallingSwitch, true);
	}
	
	this.setMoveSpeedBeforeFalling(this.moveSpeed());
	this.setFallCount(this.resistFallingAcceleration());
	while( gm.checkFallingTile(gm.allTiles(this.x, this.y)) ){
		if(this.stopFallingTile()) break;

		this.move(0, 1);
		if(this.isDeadByFalling() && fallingSwitch > 0){
			$gameSystem.setReservedSwitch(fallingSwitch);
			break;
		}
	}
};//*
if(!fieldValid)Game_CharacterBase.prototype.executeFall = function(){};

Game_CharacterBase.prototype.isDeadByFalling = function(belowY){
	//belowY is only for check stopFalling
	if(!belowY) belowY = this.y;
	const gm = $gameMap;
	const d = this.direction();
	const x = d === 4 ? Math.ceil(this.x) : Math.floor(this.x);
	const y = d === 8 ? Math.ceil(belowY) : Math.floor(belowY);
	return !gm.isValid(x, y) || gm.tileId(x, y, 0) === 0 || gm.isShipPassable(x, y);
};//*
if(!fieldValid)Game_CharacterBase.prototype.isDeadByFalling = function(){};

Game_CharacterBase.prototype.stopFallingTile = function(){
	const gm = $gameMap;
	const x = this.x;
	const y = this.y + 1;
	const tiles = gm.allTiles(x, y);
	return !gm.checkWallSideTile(tiles) && !gm.checkWaterfallTile(tiles) &&
			!gm.isPassable(x, y, 8) && !this.isDeadByFalling(y);
};//*
if(!fieldValid)Game_CharacterBase.prototype.stopFallingTile = function(){return false};

Game_CharacterBase.prototype.moveSpeedBeforeFalling = function(){
	return this._moveSpeedBeforeFalling;
};//*
if(!fieldValid)Game_CharacterBase.prototype.moveSpeedBeforeFalling = function(){return 4};

Game_CharacterBase.prototype.setMoveSpeedBeforeFalling = function(speed){
	if(speed >= 0) this._moveSpeedBeforeFalling = speed;
};//*
if(!fieldValid)Game_CharacterBase.prototype.setMoveSpeedBeforeFalling = function(){};

Game_CharacterBase.prototype.isFalling = function(){
	return this._fallCount > 0;
};//*
if(!fieldValid)Game_CharacterBase.prototype.isFalling = function(){return false};

Game_CharacterBase.prototype.setFallCount = function(count){
	if(count >= 0) this._fallCount = count;
};//*
if(!fieldValid)Game_CharacterBase.prototype.setFallCount = function(){};


	//----------足踏み自由化-------------------//
if(fieldValid){
	const _Game_CharacterBase_prototype_updateAnimation = Game_CharacterBase.prototype.updateAnimation;
	Game_CharacterBase.prototype.updateAnimation = function() {
	    this.updateAnimationCount();
	    if (this._animationCount >= this.animationWait()) {
	        this.updatePattern();
	        this._animationCount = 0;
	    }
	};

	const _Game_CharacterBase_prototype_animationWait = Game_CharacterBase.prototype.animationWait;
	Game_CharacterBase.prototype.animationWait = function() {
		if(!this._motionPattern){
			return _Game_CharacterBase_prototype_animationWait.apply(this, arguments);
		}else{
			const wait = this._motionWaits[this._motionIndex];
			return wait > 0 ? wait : _Game_CharacterBase_prototype_animationWait.apply(this, arguments);
		}
	};//*

	const _Game_CharacterBase_prototype_updateAnimationCount = Game_CharacterBase.prototype.updateAnimationCount;
	Game_CharacterBase.prototype.updateAnimationCount = function() {
		if(!this._fixPattern){
			_Game_CharacterBase_prototype_updateAnimationCount.apply(this, arguments);
		}else if(this._motionPattern){
			this._animationCount++;
		}
	};//*

	const _Game_CharacterBase_prototype_updatePattern = Game_CharacterBase.prototype.updatePattern;
	Game_CharacterBase.prototype.updatePattern = function() {
		if(!this._fixPattern){
			_Game_CharacterBase_prototype_updatePattern.apply(this, arguments);
		}else if(this._motionPattern){
			this._motionIndex++;
			if(this._motionIndex < this._motionWaits.length){
					this._pattern += this._motionPattern;
			}else{
					this.endMotion();
			}
		}
	};//*

	const _Game_CharacterBase_prototype_pattern = Game_CharacterBase.prototype.pattern;
	Game_CharacterBase.prototype.pattern = function() {
		if(!this._fixPattern){
			return _Game_CharacterBase_prototype_pattern.apply(this, arguments);
		}else{
			return this._pattern;
		}
	};//*
}////

Game_CharacterBase.prototype.setFixPattern = function(fix, pattern){
	this._fixPattern = fix; //boolean
	if(pattern >= 0) this.setPattern(pattern);
};//*
if(!fieldValid) Game_CharacterBase.prototype.setFixPattern = function(fix, pattern){};


Game_CharacterBase.prototype.setMotionPattern = function(motionType){
	this._motionPattern = motionType; //number
};//*
if(!fieldValid) Game_CharacterBase.prototype.setMotionPattern = function(motionType){};


Game_CharacterBase.prototype.startMotion = function(start, motionType, waitFrames){
	this.rememberOriginalCharacter();
	this.setFixPattern(true, start);
	this._animationCount = 0;
	this._motionWaits = waitFrames;
	this.setMotionPattern(motionType);
};//*
if(!fieldValid) Game_CharacterBase.prototype.startMotion = function(start, motionType, waitFrames){};


Game_CharacterBase.prototype.endMotion = function(){
	this.refreshOriginalCharacter();
	this.setMotionPattern(0);
	this._motionWaits = [];
	this._motionIndex = 0;
	this.setFixPattern(false);
};//*
if(!fieldValid) Game_CharacterBase.prototype.endMotion = function(){};


Game_CharacterBase.prototype.rememberOriginalCharacter = function(){
	this._originalCharacterName = this._characterName;
	this._originalCharacterIndex = this._characterIndex;
};//*
if(!fieldValid) Game_CharacterBase.prototype.rememberOriginalCharacter = function(){};


Game_CharacterBase.prototype.refreshOriginalCharacter = function(){
	this._characterName = this._originalCharacterName;
	this._characterIndex = this._originalCharacterIndex;
	this._originalCharacterName = '';
	this._originalCharacterIndex = 0;
};//*
if(!fieldValid) Game_CharacterBase.prototype.refreshOriginalCharacter = function(){};




/*------------移動に関する設定　end-------------------*/


/********************************************************************************************/
/*-------------------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------------------*/
/********************************************************************************************/


/*--------structing Window-------------------------------------
				メッセージウィンドウに関する設定
			 						 __ 	 ___
			\		 / 	| 	|\  | 	|  \  	|	| 	\		 /
			 \  /\	/	| 	| \ | 	|	| 	|	| 	 \  /\  /
			  \/  \/	| 	|  \| 	|__/  	|___| 	  \/  \/
--------------------------------------------------------------*/

/********************************************************************************************/
/*-------------------------------------------------------------------------------------------*/
/*-------------------------------------------------------------------------------------------*/
/********************************************************************************************/

		/*~struct~WindowBaseSet:ja
			@param 	valid
			@type 		boolean
			@text 		プラグインの有効化
			@desc 		On（true）にすると、このプラグインのウィンドウ効果を一括でOnにします。
			@default 	true

			@param 	helpFontSize
			@type 		number
			@text 		ヘルプの文字サイズ（px）
			@desc 		アイテムの説明に使われるヘルプウィンドウの文字サイズを設定します。初期値は28です。
			@default 	28
			@min 		12
			@decimals 	0

			@param 	operatorFontSize
			@type 		number
			@text 		操作方法の文字サイズ（px）
			@desc 		メニュー画面でShiftキーやMenuキーを使う特殊な操作を説明する文字のサイズを設定します。
			@default 	18
			@min 		12
			@max 		30
			@decimals 	0

			@param 	eventItemHelp
			@type 		boolean
			@text 		アイテム選択処理のヘルプ
			@desc 		On（true）の時、アイテム選択処理の際にアイテムの説明文を表示します。
			@default 	false
		*/
		/*-------------------------------------------------------------------------------------*/
		/*~struct~WindowBaseSet:
			@param 	valid
			@type 		boolean
			@text 		valid window custom
			@desc 		Turn on the following customs when this is true
			@default 	true

			@param 	helpFontSize
			@type 		number
			@text 		font size of all help window
			@desc 		Cotnrol the font size; initial value is 28
			@default 	28
			@min 		12
			@decimals 	0

			@param 	operatorFontSize
			@type 		number
			@text 		font size of operator（px）
			@desc 		Control the size to explain what shift or menu key works for in menu
			@default 	18
			@min 		12
			@max 		30
			@decimals 	0

			@param 	eventItemHelp
			@type 		boolean
			@text 		Help Window for choicing event items
			@desc 		Display the help of event items when this is true
			@default 	false
		*/

	const parseWindowBaseSet = s => JSON.parse(s, (key, value)=>{
		switch(key){
			case 'valid' 		: return value;
			case 'helpFontSize' : return Number.parseFloat(value);
			case 'operatorFontSize' : return Number.parseFloat(value);
			case 'eventItemHelp': return value;
			default 			: return value;
		}
	});//*

	let windowBaseSet = params.windowBaseSet;
	let consolerNameWindowBaseSet = 'windowBaseSet:';
	if(windowBaseSet){
			windowBaseSet = parseWindowBaseSet(windowBaseSet);
			windowBaseSet = stringToBoolean(windowBaseSet);	
	}else{
			windowBaseSet = makeNotValid();
			undefinedStructs.push(consolerNameWindowBaseSet);
			consolerNameWindowBaseSet += makeInvalidTerm();
	};
	consoler(consolerNameWindowBaseSet, windowBaseSet);

let windowManager = windowBaseSet.valid;

const _Window_EventItem_prototype_initialize_A = Window_EventItem.prototype.initialize;
Window_EventItem.prototype.initialize = function(messageWindow) {
	//MZでは引数はrectだが影響なし
	_Window_EventItem_prototype_initialize_A.apply(this, arguments);
	
	this._helpWindow = new Window_Help();
    this._helpWindow.hide();
    this._helpWindow.close();
    
};//*


if(windowManager){
	const _Window_Help_prototype_standardFontSize = Window_Help.prototype.standardFontSize;
	Window_Help.prototype.standardFontSize = function(){
		const defaultSize = _Window_Help_prototype_standardFontSize.apply(this, arguments);
		return windowBaseSet.helpFontSize ? windowBaseSet.helpFontSize : defaultSize;
	};//*

	if(MV && windowBaseSet.eventItemHelp){
			const _Scene_Map_prototype_createMessageWindow = Scene_Map.prototype.createMessageWindow;
			Scene_Map.prototype.createMessageWindow = function() {
				_Scene_Map_prototype_createMessageWindow.apply(this, arguments);

			    if(this._messageWindow._itemWindow._helpWindow){
			    	this.addWindow(this._messageWindow._itemWindow._helpWindow);
			    }
			};//*
	}else if(MZ && windowBaseSet.eventItemHelp){
			//MZはScene_Mapの継承元としてScene_Messageがあるので、そちらから作れるように
			const _Scene_Message_prototype_createEventItemWindow = Scene_Message.prototype.createEventItemWindow;
			Scene_Message.prototype.createEventItemWindow = function() {
				_Scene_Message_prototype_createEventItemWindow.apply(this, arguments);
				
			    if(this._eventItemWindow._helpWindow){
			    	this.addWindow(this._eventItemWindow._helpWindow);
			    }
			};//*
	}

	const _Window_EventItem_prototype_includes = Window_EventItem.prototype.includes;
	Window_EventItem.prototype.includes = function(item) {
		if(this._category === 'weapon'){
			return DataManager.isWeapon(item);
		}else if(this._category === 'armor'){
			return DataManager.isArmor(item);
		}else{
			var itypeId = $gameMessage.itemChoiceItypeId();
		    return DataManager.isItem(item) && item.itypeId === itypeId;
		}	    
	};//*

	//継承元のオリジナルItemListと同じ。サブカテゴリーの実装において加えたMELOSのItemListの変更点を打ち消すため。
	const _Window_EventItem_prototype_makeItemList = Window_EventItem.prototype.makeItemList;
	Window_EventItem.prototype.makeItemList = function() {
	    this._data = $gameParty.allItems().filter(function(item) {
	        return this.includes(item);
	    }, this);
	    if (this.includes(null)) {
	        this._data.push(null);
	    }
	};//*

	const _Window_EventItem_prototype_start = Window_EventItem.prototype.start;
	Window_EventItem.prototype.start = function() {
	    _Window_EventItem_prototype_start.apply(this, arguments);
	    if(windowBaseSet.eventItemHelp && this._helpWindow){
	    	if(!this._helpWindow.visible) this._helpWindow.show();
	    	this._helpWindow.open();
	    }
	};//*

	const _Window_EventItem_prototype_onOk = Window_EventItem.prototype.onOk;
	Window_EventItem.prototype.onOk = function() {
		_Window_EventItem_prototype_onOk.apply(this, arguments);
		if(windowBaseSet.eventItemHelp && this._helpWindow){
			this._helpWindow.close();
		}
	};//*

	const _Window_EventItem_prototype_onCancel = Window_EventItem.prototype.onCancel;
	Window_EventItem.prototype.onCancel = function() {
	    _Window_EventItem_prototype_onCancel.apply(this, arguments);
	    if(windowBaseSet.eventItemHelp && this._helpWindow){
			this._helpWindow.close();
		}
	};//*

	const _Window_EventItem_prototype_updatePlacement = Window_EventItem.prototype.updatePlacement;
	Window_EventItem.prototype.updatePlacement = function() {
		const mPos = this._messageWindow._positionType;
		if(!$gameSystem.enableBalloonMessage()){
			_Window_EventItem_prototype_updatePlacement.apply(this, arguments);
			if(windowBaseSet.eventItemHelp && this._helpWindow){
					const hPos = mPos % 2 + 1;
					this._helpWindow.y = hPos * (Graphics.boxHeight - this._helpWindow.height) / 2;
			}
		}else{
			this.y = Graphics.boxHeight - this.height;
		}
	};//*
}////

if(MV){
		Scene_Map.prototype.resetChoice = function(){
			this._messageWindow._itemWindow.setCategory('none');
		};//*
		if(!windowManager) Scene_Map.prototype.resetChoice = function(){};


		Scene_Map.prototype.weaponChoice = function(){
			this._messageWindow._itemWindow.setCategory('weapon');
		};//*
		if(!windowManager) Scene_Map.prototype.weaponChoice = function(){};


		Scene_Map.prototype.armorChoice = function(){
			this._messageWindow._itemWindow.setCategory('armor');
		};//*
		if(!windowManager) Scene_Map.prototype.armorChoice = function(){};


}else if(MZ){
		Scene_Message.prototype.resetChoice = function(){
			this._messageWindow._eventItemWindow.setCategory('none');
		};//*
		if(!windowManager) Scene_Message.prototype.resetChoice = function(){};


		Scene_Message.prototype.weaponChoice = function(){
			this._messageWindow._eventItemWindow.setCategory('weapon');
		};//*
		if(!windowManager) Scene_Message.prototype.weaponChoice = function(){};


		Scene_Message.prototype.armorChoice = function(){
			this._messageWindow._eventItemWindow.setCategory('armor');
		};//*
		if(!windowManager) Scene_Message.prototype.armorChoice = function(){};
}

//MZでScene_Mapにヘルプウィンドウ生成ファンクションが存在しないので独自に生成
Scene_Map.prototype.helpWindowRect = function() {
	const wx = 0;
    const wy = 0;
    const ww = Graphics.boxWidth;
    const wh = 100;
    return new Rectangle(wx, wy, ww, wh);
};//*
if(!windowManager) Scene_Map.prototype.helpWindowRect = function() {return null};


	/*-------------ルビの制御コード設定------------------------*/
if(windowManager){
	const _Window_Message_prototype_startMessage = Window_Message.prototype.startMessage;
	Window_Message.prototype.startMessage = function() {
		_Window_Message_prototype_startMessage.apply(this, arguments);
		this.insertRuby(this._textState);
	};//*

	const _Window_Base_prototype_convertEscapeCharacters = Window_Base.prototype.convertEscapeCharacters;
	Window_Base.prototype.convertEscapeCharacters = function(text) {
	    let parentText = _Window_Base_prototype_convertEscapeCharacters.apply(this, arguments);
	    	parentText = this.convertMelosRubyEscapeCharacters(parentText);
	    return parentText;
	};//*

	const _Game_Message_prototype_clear = Game_Message.prototype.clear;
	Game_Message.prototype.clear = function(){
		_Game_Message_prototype_clear.apply(this, arguments);
		this._ruby = [];
	};//*

	/*//for MZ
	const _Window_Message_prototype_createTextState = Window_Base.prototype.createTextState;
	Window_Message.prototype.createTextState = function(text, x, y, width) {
	    let textState = _Window_Message_prototype_createTextState.apply(this, arguments);
	    	textState.text = this.convertMelosRubyEscapeCharacters(textState.text);
	    return textState;
	};//*
	*/
};////

Window_Base.prototype.convertMelosRubyEscapeCharacters = function(text){
	text = text.replace(/\x1bpad\[(\w+)\]/gi, function(){
		return keyName(arguments[1]);
	}.bind(this));
	//\rb[baseText\rubyText\lines\align]
	text = text.replace(/\x1brb\[(\D+)\x1b(\D+)\x1b(\d)\]/gi, function() {
	   return this.createRuby(arguments);
    }.bind(this));
    return text;
};//*
if(!windowManager) Window_Base.prototype.convertMelosRubyEscapeCharacters = function(text){return text};

Window_Base.prototype.createRuby = function(args){
	//args = [escapedText, 1st(\D+), 2nd(\D+), (\d), indexOf(this escapeCode), wholeText]
    let newLine = args[5].split('\n');
    let adjust = 0;
    for(var i = 0; i < arguments[3]; i++){
   		adjust += newLine[i].length;
	   	adjust += i === 0 ? 1 : 0;
    }
    const faceAdjust = Window_Message.prototype.newLineX.call(this);

    let size = this.standardFontSize();
    let rubySize = Math.min(Math.floor(size * args[1].length / args[2].length), 10);
    let positionX = (args[4] - adjust) * size + faceAdjust;
    const padding = Message.textPadding || 0;
	let positionY =  (size + padding) * args[3] - rubySize * 2;
		positionY = Math.max(positionY, -18);
	let maxWidth = args[1].length * size;
	$gameMessage.getRuby(args[4], args[2], positionX, positionY, rubySize, maxWidth);	     

    return args[1];
};//*
if(!windowManager) Window_Base.prototype.createRuby = function(args){return args[1]};


Window_Base.prototype.insertRuby = function(text){
	const rubies = $gameMessage._ruby;
	let length = rubies.length;
		for(var i =0 ; i < length; i++){
			this.contents.fontSize = rubies[i].size;
			this.changeTextColor(this.crisisColor());
			this.drawText(rubies[i].ruby, rubies[i].pX, rubies[i].pY, rubies[i].width, 'center');
			this.contents.fontSize = this.standardFontSize();
			this.changeTextColor(this.normalColor());
		}	
	$gameMessage._ruby = [];
};//*
if(!windowManager) Window_Base.prototype.insertRuby = function(text){};


Game_Message.prototype.getRuby = function(index, rubies, x, y, fontSize, maxWidth){
	this._ruby.push({id: index, ruby: rubies, pX: x, pY: y, size: fontSize, width: maxWidth});
};//*
if(!windowManager) Game_Message.prototype.getRuby = function(index, rubies, x, y, fontSize, maxWidth){};


	/*---------セリフのバルーン化の設定----------------------*/

	/*~struct~Message:ja
		@param 	balloon
		@type 		boolean
		@text 		フキダシ化
		@desc 		On（true）にすると、話者の位置にウィンドウが表示されます。
		@default 	true
		
		@param 	fontSize
		@type 		number
		@text 		フォントサイズ（px）
		@desc 		デフォルトのフォントサイズを設定します。初期値は28です。
		@default 	28
		@min 		14
		@decimals 	0
		
		@param 	padding
		@type 		number
		@text 		余白（px）
		@desc 		基本的な余白を設定します。初期値は18です。
		@default 	18
		@min 		1
		@decimals 	0

		@param 	textPadding
		@type 		number
		@text 		行間の余白(px)
		@desc 		行間の空間を設定します。初期値は8です。
		@default 	8
		@decimals 	0
		
		@param 	opacity
		@type 		number
		@text 		ウィンドウの透明度
		@desc 		0~255で不透明度を設定します。初期値は192です。
		@default 	192
		@max 		255
		@decimals 	0
		
		@param 	lines
		@type 		number
		@text 		表示される行数（行）
		@desc 		ウィンドウに表示される文章の行数を設定します。
		@default 	4
		@min 		1
		@decimals 	0
		
		@param 	lineHeight
		@type 		number
		@text		１行あたりの高さ（px）
		@desc 		表示される１行の高さを設定します。初期値は36です。
		@default 	36
		@min 		18
		@decimals 	0
		
		@param 	width
		@type 		number
		@text 		ウィンドウの幅（px）
		@desc 		表示されるウィンドウの横幅を設定します。0にするとデフォルト値になります。
		@default 	0
		@decimals 	0
		
	*/
	/*----------------------------------------------------------------------------------*/
	/*~struct~Message:
		@param 	balloon
		@type 		boolean
		@text 		balloon valid
		@desc 		Put message window as balloon when this is true
		@default 	true
		
		@param 	fontSize
		@type 		number
		@text 		font size of message window（px）
		@desc 		Control font size; initial value is 28
		@default 	28
		@min 		14
		@decimals 	0
		
		@param 	padding
		@type 		number
		@text 		padding of message window（px）
		@desc 		Control padding of windows; initial value is 18
		@default 	18
		@min 		1
		@decimals 	0

		@param 	textPadding
		@type 		number
		@text 		padding of texts in message window(px)
		@desc 		Control padding between texts; initial value is 8
		@default 	8
		@decimals 	0
		
		@param 	opacity
		@type 		number
		@text 		opacity of message window's background
		@desc 		Control the opacity between 0 and 255; initial value is 192
		@default 	192
		@max 		255
		@decimals 	0
		
		@param 	lines
		@type 		number
		@text 		row's lines of message window（lines）
		@desc 		Control lines displayed in message window
		@default 	4
		@min 		1
		@decimals 	0
		
		@param 	lineHeight
		@type 		number
		@text		line height（px）
		@desc 		Control line height; initial value is 36
		@default 	36
		@min 		18
		@decimals 	0
		
		@param 	width
		@type 		number
		@text 		width of message window（px）
		@desc 		Control the width; when this is 0, the width returns to default
		@default 	0
		@decimals 	0
		
	*/

	const parseMessage = s => JSON.parse(s, (key, value)=>{
		switch(key){
			case 'balloon' 		: return value;
			case 'fontSize' 	: return Number.parseFloat(value);
			case 'padding'		: return Number.parseFloat(value);
			case 'textPadding' 	: return Number.parseFloat(value);
			case 'opacity' 		: return Number.parseFloat(value);
			case 'lines'  		: return Number.parseFloat(value);
			case 'lineHeight' 	: return Number.parseFloat(value);
			case 'width' 		: return Number.parseFloat(value);
			default 			: return value;
		}
	});//*

	let Message = params.message;
	let consolerNameMessage = 'gameMessage:';
	if(Message){
		Message = parseMessage(Message);
		Message = stringToBoolean(Message);
	}else{
		Message = makeNotValid();
		undefinedStructs.push(consolerNameMessage);
		consolerNameMessage += makeInvalidTerm();
	};
	
	consoler(consolerNameMessage, Message);

const _Game_System_prototype_initialize_I = Game_System.prototype.initialize;
Game_System.prototype.initialize = function(){
	_Game_System_prototype_initialize_I.apply(this, arguments);
	this._balloonMessage = Message.balloon;
	this._balloonPosition = 'right';
	this._initialMessageRows = Message.lines > 0 ? Message.lines : 4;
	this.initializeMessageRows();
};//*

if(windowManager){
	const _Window_Message_prototype_standardFontSize = Window_Message.prototype.standardFontSize;
	Window_Message.prototype.standardFontSize = function(){
		const defaultSize = _Window_Message_prototype_standardFontSize.apply(this, arguments);
		return Message.fontSize || defaultSize;
	};//*

	const _Window_Message_prototype_standardPadding = Window_Message.prototype.standardPadding;
	Window_Message.prototype.standardPadding = function(){
		const defaultPadding = _Window_Message_prototype_standardPadding.apply(this, arguments);

		return Message.padding || defaultPadding;
	};//*

	const _Window_Message_prototype_textPadding = Window_Message.prototype.textPadding;
	Window_Message.prototype.textPadding = function(){
		const defaultPadding = _Window_Message_prototype_textPadding.apply(this, arguments);

		return Message.textPadding || defaultPadding;
	};//*

	const _Window_Message_prototype_calcTextHeight = Window_Message.prototype.calcTextHeight;
	Window_Message.prototype.calcTextHeight = function(textState, all) {
	    var lastFontSize = this.contents.fontSize;
	    var textHeight = 0;
	    var lines = textState.text.slice(textState.index).split('\n');
	    var maxLines = all ? lines.length : 1;

	    for (var i = 0; i < maxLines; i++) {
	        var maxFontSize = this.contents.fontSize;
	        var regExp = /\x1b[\{\}]/g;
	        for (;;) {
	            var array = regExp.exec(lines[i]);
	            if (array) {
	                if (array[0] === '\x1b{') {
	                    this.makeFontBigger();
	                }
	                if (array[0] === '\x1b}') {
	                    this.makeFontSmaller();
	                }
	                if (maxFontSize < this.contents.fontSize) {
	                    maxFontSize = this.contents.fontSize;
	                }
	            } else {
	                break;
	            }
	        }
	        //textHeight += maxFontSize + 8;
	        textHeight += maxFontSize + this.textPadding();
	    }

	    this.contents.fontSize = lastFontSize;
	    return textHeight;
	};//*

	const _Window_Message_prototype_standardBackOpacity = Window_Message.prototype.standardBackOpacity;
	Window_Message.prototype.standardBackOpacity = function(){
		const defaultOpacity = _Window_Message_prototype_standardBackOpacity.apply(this, arguments);

		return Message.opacity >= 0 ? Message.opacity : defaultOpacity;
	};//*

	const _Window_Message_prototype_lineHeight = Window_Message.prototype.lineHeight;
	Window_Message.prototype.lineHeight = function(){
		const defaultHeight = _Window_Message_prototype_lineHeight.apply(this, arguments);

		return Message.lineHeight || defaultHeight;
	};//*

	const _Window_Message_prototype_numVisibleRows = Window_Message.prototype.numVisibleRows;
	Window_Message.prototype.numVisibleRows = function(){
		return $gameSystem.messageRows();
	};//*


	//const _Window_Message_prototype_windowWidth = Window_Message.prototype.windowWidth;
	Window_Message.prototype.windowWidth = function(){
		//_Window_Message_prototype_windowWidth.apply(this, arguments);

		if(Message.width > 0 && $gameSystem.enableBalloonMessage()){
			return Message.width;
		}else {
			return Graphics.boxWidth;
		}
	};//*

	if(MZ){
		const _Scene_Message_prototype_messageWindowRect = Scene_Message.prototype.messageWindowRect;
		Scene_Message.prototype.messageWindowRect = function() {
		    const ww = Message.width > 0 ? Message.width : Graphics.boxWidth;
		    const rows = $gameSystem.messageRows();
		    const wh = this.calcWindowHeight(rows, false) + 8;
		    const wx = (Graphics.boxWidth - ww) / 2;
		    const wy = 0;
		    return new Rectangle(wx, wy, ww, wh);
		};//*
	};

	const _Window_Message_prototype_updatePlacement = Window_Message.prototype.updatePlacement;
	Window_Message.prototype.updatePlacement = function(){
		_Window_Message_prototype_updatePlacement.apply(this, arguments);

		if($gameSystem.enableBalloonMessage()){
			const tileWidth = $gameMap.tileWidth();
			const tileHeight = $gameMap.tileHeight();
			if(speakerChange){
				//フキダシ位置の調整
				let heightAdjust = 4 / $gameSystem.messageRows();
				fukidashiX = Math.max(eventFX, 0) + tileWidth / 2;
				fukidashiY = Math.max(eventFY - tileHeight, 0) -this.height / heightAdjust;
				const bp = $gameSystem.balloonPosition();
				console.log(bp);
				if(bp !== 'right'){
					fukidashiX = this.adjustBalloonPositionX(fukidashiX, bp);
					fukidashiY = this.adjustBalloonPositionY(fukidashiY, bp);
				}
			}
			const limitedWidth = Graphics.boxWidth - (this.width + 20);
			const limitedMinHeight = 0; //tileHeight * 2 - this.height ;
			const limitedMaxHeight = Graphics.boxHeight - this.height;
			const fY = fukidashiY;

			this.x = Math.max(0, Math.min(fukidashiX, limitedWidth));
			this.y = fY.clamp(limitedMinHeight, limitedMaxHeight);
			consoler('fukidashi coordinate:', this.x, this.y);
			speakerChange = false;
		}
	};//*

	Window_Message.prototype.adjustBalloonPositionX = function(x, bp){
		const width = $gameMap.tileWidth() + this.width;
		switch(bp){
			case 'upperleft':
			case 'left':
			case 'belowleft':
				return x - width;
			break;
			case 'uppercenter':
			case 'center':
			case 'belowcenter':
				return x - width / 2;
			break;
			default : return x;
		}
	};//*

	Window_Message.prototype.adjustBalloonPositionY = function(y, bp){
		switch(bp){
			case 'upperleft':
			case 'uppercenter':
			case 'upperright':
				return y - $gameMap.tileHeight();
			break;
			case 'belowleft':
			case 'belowcenter':
			case 'belowright':
				return y + $gameMap.tileHeight();
			break;
			default : return y;
		}
	};//*

	const _Window_Base_prototype_drawFace = Window_Base.prototype.drawFace;
	Window_Message.prototype.drawFace = function(faceName, faceIndex, x, y, width, height) {
		const rowRate  = Math.min(1, this.numVisibleRows() / 4);
	    width  = width || Window_Base._faceWidth;
	    height = height || Window_Base._faceHeight;
	   	var bitmap = ImageManager.loadFace(faceName);
	    var pw = Window_Base._faceWidth;
	    var ph = Window_Base._faceHeight;
	    var sw = Math.min(width, pw);
	    var sh = Math.min(height, ph);
	    var dx = Math.floor(x + Math.max(width - pw, 0) / 2);
	    var dy = Math.floor(y + Math.max(height - ph, 0) / 2);
	    var sx = faceIndex % 4 * pw + (pw - sw) / 2;
	    var sy = Math.floor(faceIndex / 4) * ph + (ph - sh) / 2;
	    let dw = sw * rowRate;
	    let dh = sh * rowRate;
	    this.contents.blt(bitmap, sx, sy, sw, sh, dx, dy, dw, dh);
	};//*

	const _Window_Message_prototype_newLineX = Window_Message.prototype.newLineX;
	Window_Message.prototype.newLineX = function() {
		const padding = this.standardPadding() + this.textPadding();
		const faceWidth = Window_Base._faceWidth * Math.min(1, this.numVisibleRows()/4);
	    return $gameMessage.faceName() === '' ? 0 : faceWidth + padding;
	};//*

	//何故か付随ウィンドウの位置調整がされなかったので、コアのスクリプトを復元
	Window_ChoiceList.prototype.updatePlacement = function() {
	    var positionType = $gameMessage.choicePositionType();
	    var messageY = this._messageWindow.y;
	    this.width = this.windowWidth();
	    this.height = this.windowHeight();
	    switch (positionType) {
	    case 0:
	        this.x = 0;
	        break;
	    case 1:
	        this.x = (Graphics.boxWidth - this.width) / 2;
	        break;
	    case 2:
	        this.x = Graphics.boxWidth - this.width;
	        break;
	    }
	    if (messageY >= Graphics.boxHeight / 2) {
	        this.y = messageY - this.height;
	    } else {
	        this.y = messageY + this._messageWindow.height;
	    }
	};//*

}////


Game_System.prototype.enableBalloonMessage = function(){
	return this._balloonMessage;
};//*
if(!windowManager) Game_System.prototype.enableBalloonMessage = function(){return false};


Game_System.prototype.setBalloonMessage = function(value){
	this._balloonMessage = value;
};//*
if(!windowManager) Game_System.prototype.setBalloonMessage = function(value){};

Game_System.prototype.balloonPosition = function(){
	return this._balloonPosition;
};//*

Game_System.prototype.setBalloonPosition = function(pos){
	switch(pos.toLowerCase()){
		case 'upperleft':
		case 'uppercenter':
		case 'upperright':
		case 'left':
		case 'center':
		case 'bottomleft':
		case 'bottomcenter':
		case 'bottomright': this._balloonPosition = pos; break;
		default : this._balloonPosition = 'right';
	}
};//*

Game_System.prototype.messageRows = function(){
	return windowManager ? this._messageRows : 4;
};//*

Game_System.prototype.setMessageRows = function(rows){
	this._messageRows = rows || 4;
};//*

Game_System.prototype.initializeMessageRows = function(){
	this.setMessageRows(this._initialMessageRows);
};//*


/*************************************************************************************************/
	/*--------------マップ名表示の設定------------------*/

		/*~struct~MapName:ja
		@param 	valid
		@type 		boolean
		@text 		導入の有効化
		@desc 		On（true）にすると、マップ名の表示に以下の設定を反映します。
		@default 	true

		@param 	originX
		@type 		number
		@text 		原点X座標
		@desc 		マップ名表示の左上原点のX座標を設定します。
		@default 	0
		@decimals 	0

		@param 	originY
		@type 		number
		@text 		原点Y座標
		@desc 		マップ名表示の左上原点のY座標を設定します。
		@default 	0
		@decimals 	0

		@param 	size
		@type 		number
		@text 		フォントサイズ(px)
		@desc 		マップ名のフォントサイズを設定します。初期値は18です。
		@default 	18
		@decimals 	0

		@param 	width
		@type 		number
		@text 		ウィンドウ幅(px)
		@desc 		マップ名の幅を設定します。初期値は360です。
		@default 	360
		@decimals 	0

		@param 	lineHeight
		@type 		number
		@text 		１行の高さ
		@desc 		マップ名の１行の高さを設定します。初期値は36です。
		@default 	36
		@decimals 	0

		@param 	se
		@type 		file
		@text 		マップ名SE
		@desc 		マップ名を表示する際に演奏するSEを設定します。
		@dir 		audio/se
		@require 1

		@param 	volume
		@type 		number
		@text 		マップ名SE音量
		@desc 		マップ名を表示する際のSEボリュームを設定します。
		@default 	70
		@decimals 	0
		@max 		100

		@param 	pitch
		@type 		number
		@text 		マップ名SEピッチ
		@desc 		マップ名を表示する際のSEピッチを設定します。
		@default 	100
		@decimals 	0

		@param 	pan
		@type 		number
		@text 		マップ名SE位相
		@desc 		マップ名を表示する際のSEパンを設定します。
		@default 	0
		@decimals 	0
		*/
		/*--------------------------------------------------------------*/
		/*~struct~MapName:
		@param 	valid
		@type 		boolean
		@text 		valid function
		@desc 		Turn on the following when this is true
		@default 	true

		@param 	originX
		@type 		number
		@text 		x-coordinate
		@desc 		Control the x-coordinate of map name
		@default 	0
		@decimals 	0

		@param 	originY
		@type 		number
		@text 		y-coordinate
		@desc 		Control the y-coordinate of map name
		@default 	0
		@decimals 	0

		@param 	size
		@type 		number
		@text 		font size(px)
		@desc 		Control font size of map name; initial value is 18
		@default 	18
		@decimals 	0

		@param 	width
		@type 		number
		@text 		width of map name(px)
		@desc 		Control the width; initial value is 360
		@default 	360
		@decimals 	0

		@param 	lineHeight
		@type 		number
		@text 		line height
		@desc 		Control the line height; initial value is 36
		@default 	36
		@decimals 	0

		@param 	se
		@type 		file
		@text 		SE for map name
		@desc 		Select a SE played on displaying map name
		@dir 		audio/se
		@require 1

		@param 	volume
		@type 		number
		@text 		volume of SE
		@desc 		Control the volume
		@default 	70
		@decimals 	0
		@max 		100

		@param 	pitch
		@type 		number
		@text 		pitch of SE
		@desc 		Control the pitch
		@default 	100
		@decimals 	0

		@param 	pan
		@type 		number
		@text 		pan of SE
		@desc 		Control the pan
		@default 	0
		@decimals 	0
		*/

		const parseMapName = s => JSON.parse(s, (key, value) => {
			switch(key){
				case 'valid' 		: return value;
				case 'originX' 		: return Number.parseFloat(value);
				case 'originY' 		: return Number.parseFloat(value);
				case 'size' 		: return Number.parseFloat(value);
				case 'width' 		: return Number.parseFloat(value);
				case 'lineHeight' 	: return Number.parseFloat(value);
				case 'se' 			: return value;
				case 'volume' 		: return Number.parseFloat(value);
				case 'pitch' 		: return Number.parseFloat(value);
				case 'pan' 			: return Number.parseFloat(value);
				default 			: return value;
			};
		});//*

		let mapNameWindow = params.mapName;
		let consolerNameMapName = 'mapName:';
		if(mapNameWindow){
				mapNameWindow = parseMapName(mapNameWindow);
				mapNameWindow = stringToBoolean(mapNameWindow);	
		}else{
				mapNameWindow = makeNotValid();
				undefinedStructs.push(consolerNameMapName);
				consolerNameMapName += makeInvalidTerm();
		};
		consoler(consolerNameMapName, mapNameWindow);
			
if(windowManager && mapNameWindow.valid){
/*
	const _Scene_Map_prototype_start = Scene_Map.prototype.start;
	Scene_Map.prototype.start = function() {
		_Scene_Map_prototype_start.apply(this, arguments);
	    if(this._transfer){
	    	this.playMapNameSE();
	    }
	};//*

	Scene_Map.prototype.playMapNameSE = function(){
		if(this.isEnabledMapNameSE()){
			const arr = mapNameWindow;
			const se = {"name": arr.se, "volume": arr.volume, "pitch": arr.pitch, "pan": arr.pan};
			AudioManager.playSe(se);
		}
	};//*

	Scene_Map.prototype.isEnabledMapNameSE = function(){
		return $gameMap.isNameDisplayEnabled() && $gameMap.displayName() && mapNameWindow.se;
	};//*
*/
	Window_MapName.prototype.standardFontSize = function(){
		return mapNameWindow.size;
	};//*

	const _Window_MapName_prototype_initialize = Window_MapName.prototype.initialize;
	Window_MapName.prototype.initialize = function() {
		this._initializingCompleted = false;
	    var wight = this.windowWidth();
	    var height = this.windowHeight();

		let x = mapNameWindow.originX;
	    let y = mapNameWindow.originY;

	    Window_Base.prototype.initialize.call(this, x, y, wight, height); //changed
	    this.opacity = 0;
	    this.contentsOpacity = 0;
	    this._showCount = 0;
	    this.refresh();
	};//*

	Window_MapName.prototype.lineHeight = function(){
		return mapNameWindow.lineHeight;
	};//*

	Window_MapName.prototype.windowWidth = function() {
	    return mapNameWindow.width;
	};//*

	Window_MapName.prototype.windowHeight = function() {
	    return this.fittingHeight(1);
	};//*

	const _Window_MapName_prototype_refresh = Window_MapName.prototype.refresh;
	Window_MapName.prototype.refresh = function() {
		_Window_MapName_prototype_refresh.apply(this, arguments);
		if(t